---
layout: post
title: Website Minimalism
author: geerlingguy
nid: 413
comments: true
redirect_from: /blog/jeff-geerling/website-minimalism/
created: 1323121122
---
<em>Before I get started, I want to make it <strong>abundantly clear</strong> that I am in no way ripping on <a href="http://catholichotdish.com/">Catholic Hot Dish.com</a> in this post—I simply wanted an example for illustration, and this is one site that follows a design pattern I've seen on many Catholic sites. I enjoy Catholic Hot Dish, and am saying nothing of the blog or it's content—simply it's design choices...</em>

<img src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/Jeff%20Geerling/tons-of-share-links.jpg" alt="Catholic Hot Dish Share Links" width="144" height="500" style="float: right; margin: 5px;" />Now that that's out of the way, I wanted to point out an alarming trend I've seen on many new Catholic websites, parish websites, diocesan websites, and blogs: the tendency to pollute the entire design with too much 'stuff' that distracts from the website's actual content (what readers want to see).

Since I often read things in my RSS reader or Instapaper, it's not a huge deal to me—I click one button and the overpowering design of a site vanishes—but it is a problem for many of your site's readers, who aren't tech savvy enough to use such services. It's especially troublesome if you don't have a mobile-optimized design (or if your mobile-optimized design doesn't actually provide the bits of information that are actually important and present in your 'full' design).

The worst case is a design that has too many design elements and doesn't have a mobile-optimized version, meaning a mobile device may be loading 1-2MB worth of resources over a 3G connection, <em>just to read your article</em>!

<h3>Sharing Too Much</h3>

There seems to be a tendency to push the 'share' links—and to push them <em>hard</em>. It's now normal to see a set of Facebook, Twitter, Google+, ShareThis, etc. links in not one, but three to five (or even MORE) places on a particular page.<!--break -->

In the example of Catholic Hot Dish, there are post-sharing buttons above and below the post (1 &amp; 2), there's a sitewide 'stay connected' set of links at the top right (3), there's a Google+ widget (4), there's a Facebook fan page widget (5), there's a Twitter widget (6), and an extra set of two (redundant) share widgets at the bottom of the page (7 &amp; 8).

Not only do all these widgets cause pages to <strong>load more slowly</strong> (in the case of CHD, probably about 3-4x longer than if all those widgets were gone—they make up more than half of the page size, and add about 60-100 requests per page), they also clutter the design and make it <strong>less likely someone will share something</strong> (because there are too many ways to do it!).

<h3>Overemphasis Causes Distraction</h3>

It's a bit like the sign-emphasis syndrome I encounter quite often when helping Catholic organizations with advertisements and campaigns, especially for printed material or graphics.

People have a tendency to overemphasize to the point of distraction:
<p style="text-align: center;"><img src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/Jeff%20Geerling/overshare-event-ad-too-bold.jpg" alt="Biggest Event ugly ad" title="" width="300" height="203" /></p>
Notice how, in the image above, even though we emphasize almost everything in the ad, nothing really stands out (well, maybe the title, but that's it).

There are two things you need to do to make sure you hit people where it counts and make them want to do what <em>you</em> want them to do (on your website, in an ad, on a flyer, etc.):

<ol>
	<li><strong>Take away the cruft.</strong></li>
	<li><strong>Highlight only what's <em>really</em> important.</strong></li>
</ol>

<h3>An Example of Minimal Web Design</h3>

I've been focusing on the idea of 'distractionless' web design for the past few years, and I recently rebuilt <a href="http://catholicnewslive.com/">Catholic News Live</a>'s website to try to cut out even more distraction from the site. I had to do a few things to get to the point where I am now:

<ol>
	<li>Focus on the features I want people to use:</li>
<ol>
	<li>Reading the latest news stories.</li>
	<li>Finding/purchasing the Catholic News Live mobile app.</li>
</ol>
	<li>Cut out everything that doesn't help with (1):</li>
<ol>
	<li>I took out all the ads on the site (they weren't really generating revenue anyways).</li>
	<li>I took out all sidebar and footer information except for links to the mobile app (and a couple 'follow/like' buttons).</li>
	<li>I distilled the list of the latest news down to the fewest functional elements.</li>
</ol>

</ol>

<p style="text-align: center;"><img src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/Jeff%20Geerling/cnl-website-design.jpg" alt="Catholic News Live website design" title="" width="600" height="174" />
Catholic News Live... before and after a makeover.</p>
Nothing I took away made the site harder to use, or less functional—rather, it made the website faster to load (average page load times are down 30%, and the page size is halved), and made the relevant functionality of the site easier for end users to grasp and use.

<h3>Make some Changes</h3>

Look at the sidebars, widgets, links, and modules/plugins your site is currently using. Do you really need a 'ShareThis' link in addition to Twitter, Facebook, and Google+ share links, or can you just get by with one or two of those links?

Do you really need that 3D cloud of tags that fly around the mouse when you hover over them?

Do you really need an image rotator that shows the latest pictures you took on a family vacation?

Think about the actual utility of every element of your website, and whether it is essential to your site's functionality, or whether it may be distracting and paralyzing to your website's usability.

<em>Take away the cruft. Keep only what's important.</em>
