---
layout: post
title: Private Social Networks for Parishes
author: geerlingguy
nid: 404
comments: true
redirect_from: /blog/jeff-geerling/private-social-networ/
created: 1318105396
---
<p>I read a good post on the idea of parish online communities yesterday, over on Catholic Tech Talk (great site!), titled: <a href="http://catholictechtalk.com/blog/2011/10/06/private-vs-public/">Parish Online Communities: Private vs. Public</a>. In it, Ryan Foley speaks about the value of parishes having private communities incorporated with their websites and parish member management systems.</p><p>I wrote, in response:</p><p>Coming from the perspective of having worked on a similar kind of project diocesan-wide (for priests), I have to say that creating an insular (parish-level, or even diocese-level) social networks is a serious undertaking.</p><p>We've tried twice to create online spaces (private social networks) for a particular population of the diocese, but both times, after an initial push by a few people that were forced into being leaders, the experiment failed. The reasons were many, but mostly boiled down to:</p><ol><li>Not enough buy-in to make it worthwhile (the people who were most active were those who were already using other communications channels to keep in touch anyways).</li><li>Not enough 'space' (a few people posted a lot, causing many of the priests who would've otherwise been interested to stay out of the discussion).</li><li>The 'just another network' syndrome; for many of the people who seemed they would be the target demographic, they quickly responded with complaints that we were simply asking them to manage yet another profile/persona, and one which didn't really provide them added value (compared to the small communities they were already in on Facebook, Twitter, and in real life).</li></ol><!--break--><p>I'm not saying this to downplay the idea of a social network—rather, I'd say it's important to be prepared. If you want to make a successful private network (as have many large corporations, and some smaller communities), you need to have a lot in place from the start:</p><ul><li>A 'community manager' (or many), who will moderate things, try to keep discussions sane, and ensure the network is always fresh.</li><li>A 'hook' (or many); something that will keep people coming back. Once the online community is established, the hook might *be* the community. This must be something people will value and want more of. With Facebook, it's connections with past and present friends and family (and pictures). With Twitter, it's often meaningful, quick conversations, or simple sharing.</li><li>Simplicity in setup and management: If people can login quickly, and get started immediately, you'll have a much better chance of at least letting people in the door. If you make people do a lot of things before they can even see what you have to offer, you're shutting the door already.</li></ul><p>Do I think a private social network is good for a parish? It depends on the parish... I think many, if not most, are not ready for one. Do I think flockNote is good for a parish? Same answer. Sadly, most of our work right now needs to be in the field of getting pastors and leaders simply to consider the possible positive impact online community and relationships (in any form) will make on people's lives. Only with their full support can an initiative like using a social network or finding new communications channels have any fruits.</p><p><em>Disclaimer: I work for flockNote.</em></p>
