---
layout: post
title: Catholic News Live - Simple iPhone App for Catholic News
author: geerlingguy
nid: 378
comments: true
redirect_from: /blog/oscatholic/catholic-news-live-simpl/
created: 1300381392
---
<p>About a week after completing work on the first release of the Archdiocese of St. Louis' "Catholic STL" app, I decided to spend a few nights and weekends working on a more personal project...</p><p>A few months ago, I was browsing the App Store, looking for a simple Catholic news app where I could quickly browse through the latest Catholic news from a relatively comprehensive array of sources. Seeing none, and realizing that my experimental '<a href="http://catholicnewslive.com/">Catholic News Live</a>' website already had the data I needed to build my own app, I decided to port some of the code from Catholic STL, and write my own app—<a href="http://catholicnewslive.com/about/mobile-app">Catholic News Live</a>, or CNL for short.</p><p style="text-align: center;"><a href="http://itunes.apple.com/us/app/catholic-news-live/id422525557?mt=8"><img src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/oscatholic/App%20Icon.png" alt="Catholic News Live App Icon" width="125" height="125" /></a></p><!--break--><p>All the news data, which is gathered using the <a href="http://managingnews.com/">Managing News</a> Drupal distribution, which uses the <a href="http://drupal.org/project/feeds">Feeds</a> module, a <a href="http://drupal.org/project/geotaxonomy">Geotaxonomy</a> module, and some other glue modules, is fed into the app through a custom feed that has the news article title, URI, summary, and lat/long information.</p><p>I basically parse that data in a feed at app launch time, and whenever the user refreshes the feed, then display the data either in a list, or on a world map (at one point, I was displaying all news—including stories without a location—on the map, but it took about 10 seconds for the iPhone to drop all the news pins!).</p><p>Well, anyways, version 1.0 of the CNL (Catholic News Live) app is finally up for sale on the App Store, and I'm already squashing a few bugs for version 1.1, and working on a couple (small) new features.</p><p>I'm starting to actually wrap my mind around memory management and performance optimizations on the iPhone—knowledge that will definitely help as multi-core processors start arriving in these mobile devices! Want to know more? Ask in the comments!</p><ul><li>See the official page for the app: <strong><a href="http://catholicnewslive.com/about/mobile-app">Catholic News Live - Mobile App</a></strong>.</li><li>Buy the app: <strong><a href="http://itunes.apple.com/us/app/catholic-news-live/id422525557?mt=8">$0.99 on the App Store</a></strong>.</li></ul><p>Listed below are a few of the bits and pieces of other open-source software I used in building the app; these are some invaluable tools to help anyone building an app to make it work as well/as intuitively as many other iOS apps, without doing quite so much grunt work:</p><ul><li><a href="http://www.getsharekit.com/">ShareKit</a> - for sharing news on Twitter, Facebook, Instapaper, etc.</li><li><a href="http://www.midwesternmac.com/jjgwebview">JJGWebView</a> - a simple UIWebView class for the iPhone (developed by yours truly).</li><li><a href="https://github.com/enormego/EGOTableViewPullRefresh">EGOTableViewPullRefresh</a> - for the pull-to-refresh action in the news article listing.</li></ul>
