---
layout: post
title: The Importance of Accessibility on the Web
author: geerlingguy
nid: 347
comments: true
redirect_from: /blog/jeff-geerling/importance-accessibil/
created: 1288883299
---
<p><img src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/oscatholic/universal-access.png" alt="Universal Access - Accessibility (Icon)" style="float: right; width: 247px; height: 248px; border-width: 0px; border-style: solid; margin: 10px;" />An issue which is often in the back of my mind, but often not even on the radar of a lot of Catholic web developers (I know this from experience) is online accessibility. Many new/remodeled Catholic Churches have hundreds of new technologies in place to help those with disabilities—wheelchair ramps, wider aisles, larger bathrooms, elevators... and many of these innovations cost a pretty penny.</p>
<p>Shouldn't we develop our websites with the same amount of care for disabled persons' unique set of abilities?</p>
<p>Much time during the design of the current <a href="http://archstl.org/">archstl.org</a> website was spent on <a href="http://www.w3.org/TR/WCAG20/">WCAG 2</a> and <a href="http://www.section508.gov/docs/Section%20508%20Standards%20Guide.pdf">Section 508</a> compliance, and the web development platform we have chosen (Drupal) goes a long way towards helping in this regard (in fact, Drupal 7 will be almost completely WCAG 2.0 compliant from the start!).</p>
<p>The <a href="http://archstl.org/">archstl.org</a> website passes the WCAG 2.0 checklist with only a few minor suggestions (but none that will cause much hassle for users with disabilities). Check it at <a href="http://achecker.ca/checker/index.php">http://achecker.ca/checker/index.php</a>.</p>
<p>I also try to have 'real-world' persons with visual impairment test my designs, to make sure they can easily:</p>
<ol>
<li>Browse the website</li>
<li>Search the website</li>
<li>Hear/see the information on the page they'd like to hear or see</li>
<li>Know what images are on the page, even if they can't see them</li>
</ol> <!--break-->
<p>One of the biggest struggles I have in the Archdiocese is helping other people realize the importance of having an accessible website—most especially in terms of adding 'alt' tags to images and forming links properly.</p>
<p>The three largest issues faced in accessibility for web developers are:</p>
<ol>
<li>Having a solid theme/template for your website that enforces WCAG/508 guidelines on a high level.</li>
<li>Educating your content managers on using alt tags properly, understanding text-based browsing, etc.</li>
<li>Knowing your audience—if you have persons with disabilities using your website, you should ask them for feedback, and involve them in design testing.</li>
</ol>
<p>Let's do all we can to be inclusive of all those using our websites. There are times when it may be outside the constraints of your budget... but you should, at a minimum, try to make your site browsable by persons with disabilities!</p>
<h3>More Reading and Resources</h3>
<ul>
<li><a href="http://www.section508.gov/index.cfm?fuseAction=stds">Section508.gov</a></li>
<li><a href="http://www.w3.org/TR/WCAG20/">Web Content Accessibility Guidelines (WCAG) 2.0</a></li>
<li><a href="http://achecker.ca/checker/index.php">ATRC Website Accessibility Checker</a></li>
</ul>
