---
layout: post
title: Create a Podcast, Quick n' Easy, using Drupal with Views + FileField
author: geerlingguy
nid: 345
comments: true
redirect_from: /blog/oscatholic/create-podcast-quick-n-e/
created: 1288388757
---
<p><img alt="Podcast Logo" src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/oscatholic/podcast.png" style="border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: solid; border-right-style: solid; border-bottom-style: solid; border-left-style: solid; float: right; width: 150px; height: 150px; " title="" />After having created a <a href="http://www.lifeisaprayer.com/catholic-car-wash">few</a> <a href="http://feeds.feedburner.com/lolsaints-podcast?format=xml">different</a> <a href="http://www.reapteam.org/podcast">podcasts</a> on different Drupal sites for different purposes, using a variety of methods, I can speak with a little authority on which methods are the best, easiest, etc. There is an <a href="http://drupal.org/project/audio">Audio</a> module, and an <a href="http://drupal.org/project/itunes">iTunes</a> module, which help with more advanced podcasting needs... but most people just want a podcast which will allow visitors to either listen while on the website, or to be able to subscribe to the podcast in iTunes or another media player.</p>
<p>If your needs are relatively simple, it&#39;s quite easy to get a podcast up and running on your Drupal website:</p>
<h3>Step 1 - Make a Podcast-ready Content Type</h3>
<p>In one of your content types, add a <a href="http://drupal.org/project/filefield">filefield</a> that allows the uploading of MP3 and/or M4A files, and create a podcast episode or two. Make sure you set the filefield&#39;s display to &#39;Generic Files&#39; for the RSS display settings (at&nbsp;admin/content/node-type/[your-node-type]/display/rss).</p>
<p><em>(You can also use something like <a href="http://drupal.org/project/swftools">SWF Tools</a>&nbsp;to display a player for the file for regular (&quot;Basic&quot;) node views&mdash;so people can play the audio file without having to open your feed in iTunes. Otherwise files will just display as links to the downloadable file).</em></p>
<h3>Step 2 - Make a View with a Page and Feed Display</h3>
<p>Now, create a view, and in that view, create a list of all your podcast nodes (nodes that have the MP3/M4A files attached) on a Page display, then create a Feed display that shows a few episodes, and attach that Feed display to the Page display.</p>
<h3>Step 3 - Avoid a Hassle by Burning Your Feed</h3>
<p><a href="feedburner.google.com/"><img alt="FeedBurner Logo" src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/oscatholic/FeedBurner-Logo-200_0.png" style="border-top-width: 0px; border-right-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-top-style: solid; border-right-style: solid; border-bottom-style: solid; border-left-style: solid; margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px; float: right; width: 200px; height: 40px; " title="" /></a>Many would recommend trying to get the feed working properly with iTunes by using the aforementioned iTunes module or some other hackery, but there&#39;s a much easier option: <a href="http://feedburner.google.com/">FeedBurner</a>. You need to set up an account with FeedBurner. Then use FeedBurner to &#39;burn&#39; one of your feeds&mdash;be sure to check the &#39;I am a podcaster!&#39; checkbox. Fill out all the relevant details, and then look at what your FeedBurner URL is (mine, for example, is http://feeds.feedburner.com/<strong>reviewcast-podcast</strong> - this is for the <a href="http://stlouisreview.com/reviewcast">ReviewCast</a>).</p>
<p>Install the <a href="http://drupal.org/project/feedburner">FeedBurner</a> module on your Drupal site, and then go to its settings page. Click the &#39;Burn feed&#39; tab to add your new feed - you&#39;ll need to know the path to the Feed display that you configured in your View earlier, and the FeedBurner URL (just use the part that&#39;s bolded above).</p>
<h3>Step 4 - Profit?</h3>
<p>Now, clear all your caches (in case the feed you had in your views was cached already), and you should have a podcast page which not only allows site visitors to play files directly, but also offers iTunes (or other service) subscriptions. You can submit your FeedBurner URL to iTunes&#39; Podcast directory if you&#39;d like to be included.</p>
<p>Nice!</p>
