---
layout: post
title: Website Hosting Management, DNS Information
author: geerlingguy
nid: 328
comments: true
redirect_from: /wiki/117/website-hosting-managemen/
created: 1285096506
---
<p>Almost every website on the Internet is accessed using a name like &quot;www.opensourcecatholic.com&quot; or &quot;www.archstl.org.&quot; These are called <em>domain names</em>. There is a whole system on the internet called DNS, which allow people&#39;s computers to access the right information when they type in a domain name in their browser.</p>
<p>In order to have a website that is accessible via a domain name, you need to have a domain name registrar to set up the domain name... kind of like how you need a telephone company to give you a phone number.</p>
<p>There are many domain name registrars on the Internet (too many to go through in a comprehensive manner), but we typically recommend <a href="http://www.name.com/">name.com</a> or <a href="http://smallbusiness.yahoo.com/domains">Yahoo! Small Business</a>. Once you have purchased a domain name (for example, mycatholicparish.com or awesomeparish.org), you will need to use a web hosting company to &#39;serve&#39; your website.</p>
<p>There are many different options when it comes to a web hosting company:</p>
<ul>
<li>You can manage your own website without having to know much about web development or pay a lot of money (or any at all!) by using a solution such as <a href="http://wordpress.com/">Wordpress.com</a> or <a href="http://www.drupalgardens.com/">Drupal Gardens</a>.</li>
<li>You can put your own web pages or website system on a server for a relatively low cost per month using a host like <a href="http://www.hostgator.com/">Host Gator</a> or <a href="http://www.dreamhost.com/">Dreamhost</a>.</li>
<li>(If you have a lot of website visitors, or have special requirements for your website) You can put your website on a Virtual Private Server (VPS) or dedicated server. This is only recommended for organizations with more resources to devote to their websites.</li>
</ul>
<p>Whatever option you choose, you should be sure that the information for logging in and managing your accounts with both the registrar and the hosting company resides not with any individual, but with the organization.</p>
<h3>Keeping Things Running</h3>
<p>Many times, a web developer is called and asked if he or she can help an organization move the organization&#39;s website to a different hosting company. This is not always an easy task... and it&#39;s especially hard if the organization has no idea (a) who owns/manages their domain name, or (b) the login information for their web hosting company.</p>
<p>You can find out the information for your domain name, at least, using the <a href="http://whois.domaintools.com/">&#39;whois&#39; tool at DomainTools.com</a>. Go to that website, and enter your domain name. For example, here&#39;s the <a href="http://whois.domaintools.com/opensourcecatholic.com">whois information for opensourcecatholic.com</a>.</p>
<p>The person listed as the administrative contact should typically be the person who owns/manages the domain name for your organization. If you contact this person, he or she should be able to help you get control of your domain name.</p>
<h3>Losing Your Domain Name</h3>
<p>Please note: if you don&#39;t pay the yearly fee to renew your domain name, you will lose it, and someone else might pick it up&mdash;just like if you don&#39;t pay the phone company, you&#39;ll lose your phone number!</p>
<p>If a lot of people know your website by its domain name, it&#39;s not very nice to let the domain name go sour&mdash;they might not know how to find your information online anymore!</p>
