---
layout: post
title: 'News Websites: Make Your News Readable!'
author: geerlingguy
nid: 278
comments: true
redirect_from: /blog/oscatholic/news-websites-make-your/
created: 1276007096
---
<p>For anyone involved in web development for news publications, one of the most important aspects of the website is its textual layout.&nbsp;Your site must be readable on a variety of devices, and, failing that, you should try to make it look great on at least one platform (usually the desktop browser)&mdash;typically other platforms will follow.</p>
<p>There are a few things to watch out for:</p>
<ol>
<li>You can have lines too close together&mdash;use line-height to give proper spacing/breathing room between consecutive lines of text.</li>
<li>You can have paragraphs too close together&mdash;add some margins between paragraphs so they are divided visually.</li>
<li>You can have too narrow a viewport for your content, meaning users spend more time scrolling than reading. (However, you don&#39;t want to have it too wide either&mdash;sometimes a semi-fluid layout can be useful).</li>
</ol>
<!--break-->
<p>Let&#39;s take an example:</p>
<p class="rtecenter"><img alt="Catholic News Service narrow viewport" class="imagecache-300px-by-300px" src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/imagecache/300px-by-300px/user-uploads/oscatholic/cns-website-narrow.png" title="" /></p>
<p>The Catholic News Service website has been around for a very long time, and they distribute tons of articles to the Catholic community. Their website, as it currently stands, is a bit difficult to read for those with larger screen sizes.</p>
<p>Opening up the site with Safari, I can enable Reader use Instapaper to read the story in a wider format, but that is a barrier to getting to read the content quickly.</p>
<p class="rtecenter"><img alt="Catholic News Service in Safari Reader" class="imagecache-300px-by-300px" src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/imagecache/300px-by-300px/user-uploads/oscatholic/cns-website-safari-reader.png" title="" /></p>
<p>In order to make their layout more presentable, I would suggest the following:</p>
<ul>
<li>Make the body text black (right now it&#39;s blue), for added contrast.</li>
<li>Make the layout about 200px (or more) wider, for longer lines of text.</li>
<li>Possibly diversify the color scheme a bit&mdash;an orange color would be great for highlighting certain elements; alternatively, some more greys could help hide certain distracting elements (like meta information).</li>
</ul>
<p>I think most Catholic news organizations could take a second look at their website and begin the groundwork towards making their sites easier to read for any visitors&mdash;especially those reading the site on the desktop. I realize that some of these sites have a lot of legacy content that would need to be updated to make it conform to a new design, but nowadays tools are more abundant than ever to get this to happen, and I&#39;m sure there are some on this site who would be willing to help :-)</p>
<p>(As an aside: RSS feeds are also helpful for readability, as many people are used to reading news through their favorite news readers&mdash;if your site doesn&#39;t have an RSS feed (or many), then you should consider adding one at some point. It has other benefits as well, such as increased exposure to the Google News site and other aggregators).</p>
