---
layout: post
title: Website Performance
author: geerlingguy
nid: 250
comments: true
redirect_from: /wiki/117/website-performance/
created: 1271784155
---
<p>
	It is not enough to simply have a website, no matter how beautiful it is, or how much content you add. The best websites, and those that are liked and revisited by many, hit hard on all cylinders: They are well-designed, they have meaningful content, and they are easy on the eyes and easy to use. But something that is often overlooked, especially by those with very fast Internet connections, or those working mostly on a local development machine, is site performance.</p>
<p>
	With Google giving a bonus to websites that load more quickly, and with statistics correlating page load times and user dissatisfaction with a website, it is increasingly important to make sure your website loads quickly. There are thousands of ways you can speed up your website, but the process usually goes like this:</p>
<ol>
	<li>
		Optimize your web server (sometimes not possible).</li>
	<li>
		Optimize your website&#39;s code.</li>
	<li>
		Cache compiled code and database queries (if using a content management system or custom application.</li>
	<li>
		Use web design techniques for optimized HTML, JavaScript and Images (for instance, use CSS image sprites to cut down on HTTP requests).</li>
</ol>
<p>
	This page will be expanded with more information about general performance guidelines, and children pages explaining resources for the four steps above will also be added.</p>
<p>
	For now, here are some great resources to help you get started in increasing your website&#39;s performance:</p>
<ul>
	<li>
		<strong><a href="http://www.webpagetest.org/">WebPagetest</a></strong> - for testing your page load times, with excellent waterfall graphics and stats.</li>
	<li>
		<strong><a href="http://developer.yahoo.com/yslow/">Yahoo YSlow for Firebug</a></strong> - FireFox-only extension that checks common performance shortcomings.</li>
	<li>
		<strong><a href="http://code.google.com/speed/">Google Site Speed</a></strong> - Resources from Google for making a faster web.</li>
</ul>
