---
layout: post
title: Quote demonstrating bad software design
author: jr-duboc
nid: 244
comments: true
redirect_from: /blog/jrduboc/quote-demonstrating-bad-s/
created: 1271101959
---
<p>
	From a paper I read recently:&nbsp;</p>
<blockquote>
	<p>
		Based on the observation that users did not use a number of support functions, such as the medical notes and the consultation review interface, future trials will include a short tutorial.</p>
</blockquote>
<p>
	The authors are talking about a <a href="duboc.me/en/category/tags/phd" lang="en" title="PhD project: semantic virtual patient">virtual patient system</a>, but this probably applies to many applications. If users didn&#39;t use certain functions, in my book there can be two reasons:</p>
<ol>
	<li>
		The features are not well designed, and users don&#39;t know how to access them or,</li>
	<li>
		They don&#39;t actually need the features.</li>
</ol>
<p>
	Either way, the right solution is probably not to bombard users with tutorials, but rather to do some proper user tests and redesign or eliminate useless features (or even better, not bother to build them at all. Duh. Life is too short for useless code).</p>
<p>
	I&#39;d say that&#39;s how bad software is built. What&#39;s your opinion?</p>
<p>
	<!--break--></p>
