---
layout: post
title: New Drupal Book - Drupal 6 Performance Tips
author: trevor-james
nid: 225
comments: true
redirect_from: /blog/trevorjames/new-drupal-book-drupal-/
created: 1269543977
---
<p>
	<a href="http://www.packtpub.com/drupal-6-performance-tips-to-maximize-and-optimize-your-framework/book" target="_blank"><img align="right" alt="" height="200" hspace="10" src="http://www.opensourcecatholic.com/sites/opensourcecatholic.com/files/user-uploads/trevor.james/Drupal-6-Performance-Tips.jpg" title="" vspace="10" width="162" /></a><a href="http://www.packtpub.com/drupal-6-performance-tips-to-maximize-and-optimize-your-framework/book">Drupal 6 Performance Tips</a>, by Trevor James and TJ Holowaychuk, is a newly-published title from Packt Publishing aimed at Drupal beginners, developers, designers, and webmasters who utilize the Drupal content management system to create robust websites. It provides crucial performance-related information for Drupal users of all experience levels, including module contributors, webmasters who simply configure and maintain Drupal websites, and even themers.</p>
<p>
	The book contains basic and advanced topics on Drupal performance that will appeal both to the Drupal novice and the advanced user or developer. With this book you will learn how to maximize and optimize your Drupal 6 framework using best practice performance solutions and tools. The book covers how to vastly improve performance through upgrades, caching, configuring and optimization using core and contributed modules.</p>
<h2>
	Some of what you will learn</h2>
<ul>
	<li>
		Upgrade your Drupal 5 site to Drupal 6 using best practice upgrade paths</li>
	<li>
		Back up and maintain your Drupal 6 site using core and contributed modules and utilities</li>
	<li>
		Configure the Drupal core and contributed modules for high traffic</li>
	<li>
		Run core Drupal page compression, CSS and JS compression, and use Drupal page caching</li>
	<li>
		Run scheduled cron tasks to perform crucial garbage-collection processes</li>
	<li>
		Use the Development (Devel) module to monitor page loads and queries</li>
	<li>
		Use the Boost module for anonymous page caching, tweak Boost settings, and use Boost blocks and advanced Boost settings to monitor site performance</li>
	<li>
		Install and use Memcache API and Integration module, and Authcache and Advanced Cached modules to enhance and monitor site performance</li>
	<li>
		Configure a Drupal multisite environment for best performance</li>
</ul>
<h2>
	About the Book</h2>
<p>
	Drupal is one of the most respected and widely used open source content management frameworks. Small, medium, and large-scale websites are built using Drupal and the framework supports e-commerce, CRM, multisite and web service integrations.</p>
<p>
	Once you get your Drupal site installed and up and running, you will be concerned with site performance and how fast you can make your Drupal site run. This book will focus on implementing performance modules and solutions to help speed up your Drupal website.</p>
<p>
	We will look at introductory topics such as upgrading your Drupal site, maintaining your site, and enabling core Drupal page compression and caching.</p>
<p>
	Then we will turn to an advanced look at some contributed modules that help speed up performance, including Development, Boost, Authcache, Advanced Cache, and the Memcache API and Integration module.</p>
<p>
	Finally, we&rsquo;ll look at how best to implement a Drupal multisite environment and run it with high-speed performance in mind.</p>
<h2>
	Want a Sample?</h2>
<p>
	To help promote the content provided within this book, Packt is generous enough to provide sample content of what you can expect from reading this book.</p>
<ul>
	<li>
		<a href="http://www.packtpub.com/article/drupal-6-performance-optimization-using-views-panels-caching">Article: Drupal 6 Performance Optimization Using Views and Panels Caching</a></li>
</ul>
<h2>
	About the authors</h2>
<p>
	<strong>Trevor James</strong><br />
	Trevor James (<a href="http://drupal.org/user/720820">trevorjames</a>) is a Drupal developer and web designer based in Middletown, MD, USA. Trevor has been designing websites for 13 years using a combination of HTML, XHTML, CSS, and ColdFusion. He has been using Drupal intensively for more than 2 years. Trevor&#39;s focus is on building web portals for higher education, public education (K-12), non-profit, and small business environments. He is interested in the best methods of developing Drupal themes, Drupal site performance, and using CCK, Views and Panels to develop front-end interfaces to support data-intensive websites. He loves teaching people about Drupal and how to use this excellent open source content management framework. He is also a contributor and community member on drupal.org and related Drupal community projects.</p>
<p>
	<strong>TJ Holowaychuk</strong><br />
	TJ Holowaychuk (<a href="http://drupal.org/user/78427">tjholowaychuk</a>), president of Vision Media, is an avid contributor to the Drupal project as well as to other open-source applications. Contributing over 16 Drupal modules, several themes, and having fully designed, developed, and maintained hundreds of Drupal websites, he has displayed a wealth of knowledge across different aspects of the industry.</p>
<h3 class="title">
	<a class="active" href="http://drupal.org/node/712514#comment-2696006" target="_blank">SlideShare tutorial posted ...</a></h3>
<div class="content">
	<p>
		SlideShare tutorial posted - Drupal Core Performance Tutorial</p>
	<p>
		I&#39;ve posted a short tutorial on configuring Drupal core performance over at SlideShare. Enjoy!</p>
	<p>
		<a href="http://www.slideshare.net/drupal6performancetips/drupal-6-performance-tips-core-drupal-performance-tutorial" rel="nofollow" target="_blank" title="http://www.slideshare.net/drupal6performancetips/drupal-6-performance-tips-core-drupal-performance-tutorial">http://www.slideshare.net/drupal6performancetips/drupal-6-performance-ti...</a></p>
	<p>
		-Trevor</p>
	<h3 class="title">
		<a class="active" href="http://drupal.org/node/712514#comment-2743290">DrupalEasy podcast</a></h3>
	Featured in an interview on DrupalEasy this week:
	<div class="content">
		<p>
			<a href="http://variantcube.com/" rel="nofollow" target="_blank" title="http://variantcube.com/">http://variantcube.com/</a></p>
		<p>
			<a href="http://drupaleasy.com/podcast/2010/03/drupaleasy-podcast-32-drupal-6-performance-tips-interview" rel="nofollow" target="_blank" title="http://drupaleasy.com/podcast/2010/03/drupaleasy-podcast-32-drupal-6-performance-tips-interview">http://drupaleasy.com/podcast/2010/03/drupaleasy-podcast-32-drupal-6-per...</a></p>
		<p>
			-Trevor</p>
	</div>
	<p>
		&nbsp;</p>
</div>
