---
layout: post
title: 'OSV Asks: How effectively does your parish''s website connect?'
author: geerlingguy
nid: 221
comments: true
redirect_from: /blog/oscatholic/osv-asks-how-effectively/
created: 1269010441
---
<p>
	<strong>It is not good enough anymore to simply &#39;be present&#39; on the web, just as it is not good enough (nor was it ever good enough) to simply &#39;be present&#39; at Holy Mass.</strong></p>
<p>
	Catholics should make it a point to engage, to connect, and to assist others in their faith formation&mdash;online, at the mall, in the home, and at their Churches.</p>
<p>
	The Our Sunday Visitor issue from March 14, 2010 asks, &quot;<a href="http://www.osv.com/tabid/7621/itemid/6084/How-parish-websites-can-better-connect-with-Cathol.aspx">How effectively does your parish&#39;s website connect?</a>&quot; The answer to this question, for almost all parish websites I&#39;ve reviewed, is &quot;barely.&quot;</p>
<p>
	OSV gives some basic guidelines that should be met by every parish website (some of these are simply irrelevant or should be ignored, but at least most of them are good... my comments are in brackets):</p>
<ul>
	<li>
		Avoid flash animation whenever possible. [<em>Note: This is not necessarily a great guideline, imo, but the intention is to avoid gaudiness... just like AVOIDING ALL CAPS!</em>].</li>
	<li>
		Be well-organized and easy to read with a top menu and a side menu [<em>could be one or the other, imo</em>] on the &#39;Welcome&#39; page [<em>I hate the idea of a &#39;welcome&#39; page - give us content, straight up, on the first page!</em>].</li>
	<li>
		Offer features that make it easier for people with disabilities to use [<em>sadly, most sites ignore this one... even the more appealing sites</em>].</li>
	<li>
		Include pictures of people, not just buildings, to show a sense of community. [<em>And, I would add, don&#39;t overload your site with pictures!</em>].</li>
	<li>
		Don&#39;t include advertisements [<em>parish websites are not a venue for generating revenue, but you can allow online donations</em>].</li>
</ul>
<!--break-->
<p>
	The OSV also offers content suggestions for parish websites; they say websites should feature (in addition to Mass times and bulletins):</p>
<ul>
	<li>
		A mission statement that describes parish worship, life and community [<em>I fully agree on this one!</em>].</li>
	<li>
		Directions to the parish and contact information.</li>
	<li>
		An interactive parish calendar that can be updated by a variety of people [<em>Google Calendars is both easy and free, and integrates easily with any website</em>].</li>
	<li>
		Interactive forms that allow people to register for the parish as well as events... and sacramental forms that can be printed. [<em>This is a basic/easy functionality, and there is no reason why parishes still require tons of paperwork to be mailed all over the place, imo</em>].</li>
	<li>
		Password-protected &#39;Members Only&#39; section for committee members to share information, post updates and obtain feedback from others [<em>VERY easy to do if you use Drupal - just set up Organic Groups</em>].</li>
	<li>
		Online giving tools.</li>
	<li>
		A page for visitors. [<em>Umm, how about a whole </em>section<em>, complete with a &#39;We invite you to join our parish&#39; section? Maybe even a video from the pastor welcoming new members?</em>].</li>
	<li>
		A page for Catholics returning to the faith.</li>
	<li>
		Pages for the various age groups in a parish, with age specific content [<em>Even better if each section had a forum, group blog, etc... easy to do with Organic Groups.</em>]</li>
	<li>
		Podcasts or print versions of the Sunday homily. [I prefer both, but at least give a printed copy, perhaps on the Pastor&#39;s blog].</li>
	<li>
		Blogs, forums, prayer request page, etc. [<em>These community features can help integrate parishioners&#39; home lives with their at-Church lives, and strengthen a sense of community</em>].</li>
	<li>
		Bilingual content when appropriate. [<em>If you want this, use a CMS with good translation capabilities, like Drupal</em>].</li>
</ul>
<p>
	Did you notice I mentioned Drupal quite a bit in this post? If you think I&#39;m biased, well, I am. Drupal was practically built with parishes in mind! Out of the box, it supports different levels of memberships, a group blog, and multiple content types.</p>
<p>
	With extra modules, you can add interactive online forms, enable multiple &#39;groups&#39; under which people can post content and share information, and do almost anything under the sun.</p>
<p>
	And, best of all, <a href="http://drupal.org/">Drupal</a> (and other Content Management Systems like it, including <a href="http://wordpress.org/">Wordpress</a> (better for smaller sites) and <a href="http://joomla.org/">Joomla</a> (good for sites with a little bit less room for expansion)) is 100% free. It takes some getting used to, and it will take a developer to get things running (just like with any website project), but it is free to install, free to maintain, and free to upgrade. If you&#39;re going to invest in a website, make sure that you invest wisely!</p>
<p>
	I would also add to OSV&#39;s list that parishes should strive to involve themselves (even if it&#39;s just one of the priests, or a lay employee) in social media&mdash;Facebook, Twitter, FlockNote, or something else, if at all possible. If pastors truly want to &quot;meet people where they&#39;re at&quot; (a phrase I hear all too often), why are they so reticent to dive into the online community? Your flock is waiting!</p>
