---
layout: post
title: What Makes a Good Parish Website?
author: geerlingguy
nid: 143
comments: true
redirect_from: /blog/oscatholic/what-makes-good-parish-website/
created: 1256662071
---
<p>I have been asked more times than I care to recall if I know of any good example parish websites, and, if not, what would make a good parish website.</p>
<p>Unfortunately, I don&#39;t know of any parish website I would say is &quot;great.&quot; A couple &quot;good&quot; or &quot;okay&quot; ones, maybe, but nothing to call home and tell my Mom about. So, what are my criteria for a great parish website? One of which I would be proud to call myself a member?</p>
<h3>Design</h3>
<p><strong>The website must be pleasing to the eye</strong> (just like the Church <em>should</em> be). An ugly, or 90s-looking site, doesn&#39;t attract or hold my attention. It must follow the simple principles of design: color, appropriate use of negative space, a common theme, and good font design must all be taken into account.</p>
<p>Design also means the site is <strong>easy to navigate</strong>. It should have only a few main navigational options, and shouldn&#39;t be jumbled with a boatload of information on every page&mdash;and most especially the home page. (<a href="/blog/oscatholic/fear-apples-reducing-complexity">Read more on this topic</a>).</p>
<h3>Organization</h3>
<p><strong>Know thy audience.</strong> What is the most important information for those coming to your website? Are you targeting your parishioners, or visitors, or both? Is the school website separate, or integral to the parish website?</p>
<p>WAY too many parish websites start with a cruddy &#39;splash&#39; page that takes a long time to load, looks stupid, and wastes my time. Give me the parish page by default, and let me click over to the school page if need be.</p>
<p>There are a few things which, in my mind, <strong>must be one every parish website&#39;s home page</strong>:</p>
<!--break-->
<ol>
<li>A picture of the parish (well-exposed&mdash;get a professional picture if possible). Don&#39;t make it huge or too overbearing, but incorporate it in the design.</li>
<li>Something that describes where the parish is located (in which (Arch)diocese).</li>
<li>Sunday Mass Times (every visitor needs to know this). Don&#39;t put ALL your Mass times - instead, put Sunday times, then a link to more Mass and Sacrament information.</li>
<li>Contact information (phone, fax, address).</li>
<li>Links (part of a well-designed navigation area) to:
<ol>
<li>Calendar of Events</li>
<li>Personnel information</li>
<li>Parish History (if possible)</li>
<li>Parish Organizations or Groups</li>
<li>Parish News / Pastor&#39;s Blog (NOT a copy/paste of the Pastor&#39;s homily... real news, please! You can also offer reflections, but save the homily for Mass)</li>
</ol>
</li>
</ol>
<p>Then, if your parish wants, you can add in the following to the mix:</p>
<ul>
<li>Parish forums and/or bulletin boards (each parishioner could get a login)</li>
<li>Parish Bulletin (although the Parish news section should incorporate these items)</li>
<li>Schedule for ministers/ministries</li>
<li>Blogs, Podcasts, and Video Podcasts (especially relating to RCIA)</li>
<li>Photo galleries (either built into the site, or via a service like Flickr)</li>
</ul>
<h3>Technology/Back-End</h3>
<p>It is a minimum requirement that the site run on a CMS. I would suggest Wordpress for something relatively basic, Joomla for many medium sized parishes that don&#39;t want to do too many community features, and Drupal for any parish that wants to dive in and allow for an online community that&#39;s plays off of the physical, real community inside the Church.</p>
<p>Most parishes (if not all) don&#39;t need a dedicated server for this stuff. A $5/month HostGator account would serve everything up just peachy. I&#39;m running 7 high-volume websites off a $25/month Hot Drupal account (we&#39;re speaking 1-2,000 page views an hour). Most parishes get maybe 10-20 page views an hour, if that. Seriously.</p>
<h3>Conclusion</h3>
<p>You can get even more advanced than what I&#39;ve described above. But I would like to see one site incorporate these features. Just one. Oh, and I&#39;d like it to look presentable. Show me that, and I&#39;ll send you a buck via PayPal. Mind you, this is just a parish website. School websites are a whole different ball of wax.</p>
<p>I&#39;m going to be building out a sample site using Drupal for a local parish, and we&#39;ll see where that goes... but I&#39;d like to see the Church become a leader in this area. Too long have we trailed waaaaay behind our Protestant bretheren in this realm. I don&#39;t want cookie-cutter parish sites, either. I want online communities that allow for people in parishes to grow in faith and grow in love for Christ through the sites.</p>
<p><strong>Down with brochure sites! Down with Front Page!</strong></p>
<p>More/general reading: <a href="/blog/geerlingguy/building-catholic-parishorganizat">Building Catholic Parish/Organization Websites</a></p>
