---
layout: post
title: Fear of Apples - Reducing Complexity
author: geerlingguy
nid: 141
comments: true
redirect_from: /blog/oscatholic/fear-apples-reducing-complexity/
created: 1255877888
---
<p>After reading Seth Godin&#39;s simple article on reducing complexity, entitled <a href="http://sethgodin.typepad.com/seths_blog/2009/10/fear-of-apples.html">Fear of Apples</a>, I felt compelled to write &nbsp;short piece about steps one could take to make users&#39; browsing experience that much nicer.</p>
<p>Basically, by reducing complexity and limiting people&#39;s options, you free them to (a) choose easier, and (b) remember what they&#39;ve chosen.</p>
<p>As a quick example, we start with the Archdiocese of Saint Louis&#39; current website, which gives users a metric ton of choices for navigation:</p>
<p class="rtecenter"><img alt="Archstl.org - Old Site" height="333" src="/sites/opensourcecatholic.com/files/user-uploads/oscatholic/archstl-old-options.jpg" width="550" /><br />
15 Navigation Options + Search + Quick Links</p>
<p class="rteleft">The way things are, people coming to the site for the first time have over 24 functional choices to make; it&#39;s not readily apparent what are the most important navigation options on the page.</p>
<!--break-->
<p class="rteleft">If we want to make things easier for people, we need to reduce the options&mdash;instead of 24 options, let&#39;s trim it down to 9 main options, with a small, differently-styled &#39;quick links&#39; section:</p>
<p class="rtecenter"><img alt="Archstl.org - New Site" height="334" src="/sites/opensourcecatholic.com/files/user-uploads/oscatholic/archstl-new-options.jpg" width="550" /><br />
5 Navigation Options + Search + Ads</p>
<p class="rteleft">In this new arrangement, it might have more graphic complexity, but the options are trimmed to such an extent, that it is (hopefully) easier for a user to choose where they would like to go.</p>
<p class="rteleft">Apple, love it or hate it, has done a great job (for some time) at simplifying people&#39;s options so they can &#39;make the right choice.&#39; Look at their computer lineups:</p>
<p class="rteleft">Consumer Macs:</p>
<ul>
<li>MacBook</li>
<li>iMac</li>
<li>Mac mini</li>
</ul>
<p class="rteleft">Professional Macs:</p>
<ul>
<li>MacBook Pro</li>
<li>Mac Pro</li>
</ul>
<p class="rteleft">Companies like Dell, Lenovo, HP, and Sony have a major problem&mdash;the same kind of problem most Church websites have&mdash;they have dozens of lines of laptops and desktops, with an arcane numbering system (6402bl??? seriously???), and people have no idea what to order, or what they <em>have</em> ordered. When someone asks, &quot;Do you like your computer? What model did you get?&quot; The answer is, &quot;Umm, something like a Dell Inspiron 660bl with the gaming option.&quot; If you ask a Mac user, the answer is: &quot;I have a MacBook.&quot; Which one will <em>you</em> remember?</p>
<p class="rteleft">Simplify, and it will not only increase customer/visitor satisfaction, but it will also help people become more familiar with your site and/or products.</p>
<p class="rteleft">Tell them what they want by giving them only the essential options!</p>
<p class="rteleft">See related post on the Archdiocese of St. Louis&#39; Web Development website: <a href="http://archstl.org/webdev/imagegallery/navigational-structures-quick-prime">Navigational Structures: a Quick Primer</a></p>
