---
layout: post
title: Why Twitter?
author: archstl
nid: 160
comments: true
redirect_from: /blog/archstl/why-twitter/
created: 1246549030
---
<p class="rtecenter"><a href="https://twitter.com/archstl"><img alt="@archstl Twitter Account page" width="400" height="273" style="border: 1px solid #999; padding: 4px;" src="/sites/opensourcecatholic.com/files/user-uploads/archstl/archstl-twitter-account.jpg" /></a></p>
<p>The Archdiocese of Saint Louis started its <a href="https://twitter.com/archstl">Twitter account</a> in December 2008, in preparation for the news of a new Archbishop. In tandem with an SMS message signup, a timely update on the website, a press release, and a few other methods of generating buzz, the Archdiocese was able to reach thousands of Catholics in Saint Louis and around the world with news about its new Archbishop within a matter of minutes.</p>
<p>Why did the Archdiocese choose Twitter, and what are some good uses for Twitter? Well, Twitter is by far the most popular 'micro-blogging' service, but that's one of many reasons why we chose to use Twitter for more timely news. We found Twitter to be helpful because:</p>
<ol>
    <li>It is an <strong>immediate</strong> 'push' notification service; all of your updates are pushed out to each follower.</li>
    <li>It is <strong>unobtrusive</strong>; people can easily opt-in and opt-out&mdash;much more so than with email.</li>
    <li>It is <strong>ubiquitous</strong>; generally, those who use Twitter are connected on the web, on their mobile phones, and in other ways&mdash;your message can go everywhere.</li>
    <li>It is <strong>social</strong>; people can generate buzz for you&mdash;all you need to do is give the first effort, and if it is newsworthy, it will be re-tweeted and spread across many parts of the web.</li>
</ol>
<p>Twitter is also extremely useful for live events, such as the Installation Mass of Archbishop Robert J. Carlson (on June 10, 2009). At this event, we had our Communications staff take pictures in a few different areas&mdash;our timeline was updated with pictures of bishops <a href="https://twitter.com/archstl/status/2106509315">before Mass</a>, a few pictures <a href="https://twitter.com/archstl/status/2107270306">during Mass</a>, and <a href="https://twitter.com/archstl/status/2111588695">other tidbits</a> that people may have found interesting.</p>
<!--break-->
<p>When you tweet an event while it's going on, it's called &quot;Live Tweeting&quot; the event, and it can really help boost your other online content, like your website, or a live stream.</p>
<h3>Don't Neglect Your Website</h3>
<p>Twitter is great, and can be a very good promotional tool for your organization. However, Twitter is considered by many to be a secondary mode of communication, as it has some severe limitations, like the character limit (you can only type 140 characters per message), and the fact that there are many more people in the world who do <em>not</em> have Twitter than do! Because of this, it is important to use Twitter for its intended purpose, and to make sure your most important online entity&mdash;your website&mdash;is a first-class citizen of your online toolset. Make it timely, make it beautiful, and make it easily linkable!</p>
<p>During the Installation, we had an <a href="http://stlouisreview.com/installation">Installation Page</a> running on the Saint Louis Review website, with pictures from our photographers being added every twenty minutes or so, along with two or three stories that were posted during the Mass.</p>
<p>Also, the Archdiocesan website had a <a href="http://www.archstl.org/streaming/2009/installation-mass.html">live stream of the Installation</a>, along with links to all the relevant sources of <a href="http://www.archstl.org/index.php?option=com_content&amp;task=view&amp;id=899&amp;Itemid=1">information, photos and videos</a> from the Mass. This allowed people who were either (a) uncomfortable with or not knowledgeable of Twitter, or (b) simply browsing the web to still get the latest news (and more in-depth coverage) of the Installation.</p>
<p>The key is to make sure your website, which is a more permanent and visible manifestation of your organization online, is treated as a first-class citizen in your online presence.</p>
<h3>Don't Neglect Your Followers</h3>
<p>One mistake that is made by many organizations, companies and individuals who join Twitter is that they never read other people's tweets, they never reply to anything, and they don't re-tweet (RT) anything that would be worth reading or viewing by their own followers.</p>
<p>The point of Twitter, Facebook, et all is to help make the web 'social.' These services work best when there is at least some small level of interaction. The whole 'web 2.0' idea is that users generate, reference, promote, and share content. Instead of your organization shoving ideas and content down other's throats, you share it with them, and if they have a question about it, you can reply to them.</p>
<p>This requires a skilled communicator on your side, though, especially because of privacy concerns, the impetus towards teaching the truth, and the call to be charitable and compassionate in all things. Sometimes it is best not to reply to someone's hateful or ill-conceived message; other times, it's best to simply leave things be.</p>
<h3>Remembering the Big Picture</h3>
<p>User <a href="/users/jplumey">jplumey</a> brings up a good point in the comments below: we cannot forget that Twitter, like Facebook, email, phone calls, etc., is a secondary means of communication and evangelization. You should not make the mistake of missing person-to-person evangelization and communication&mdash;there is nothing that can ever be its equal. In the world of instantaneous information sharing, a caring and loving encounter and a physical presence is of paramount importance if we are to minister as Jesus would.</p>
