/*
 * SPDX-License-Identifier: MIT
 * SPDX-FileCopyrightText: 2021 Rafael Silva <perigoso@riseup.net>
 */

#pragma once

#include "util/types.h"

struct spi_hal_t {
	/* bidirectional byte transfer */
	u8 (*transfer)(struct spi_hal_t interface, u8 data);
	/* select/unselect device */
	void (*select)(struct spi_hal_t interface, u8 state);
	/* arbitrary user data */
	void *drv_data;
};
