# Deep Dive

Beyond the more superficial differences, in the following chapters we will try to go deep into the syntax and behavior of Haxe and ActionScript, drawing comparisons where we can.

Although we will be introducing new and powerful features of the Haxe programming language that are not available in ActionScript, the focus is on converting ActionScript to working Haxe code, so many of these topics will not be covered thoroughly, or may not be mentioned at all.

The [Haxe Manual](http://haxe.org/manual) is an excellent resource for understanding Haxe more deeply, particularly features that are not supported in ActionScript, such as `enum`, `typedef`, generics, type parameters, macros, abstracts... the list goes on.

The Haxe language is not unlike a hardware store. If you need to hang a picture frame in your home, you will only scratch the surface of all the tools and supplies available, but this is alright. Translating from ActionScript to Haxe, I recommend that after you feel comfortable with Haxe, take a look at some of the features available, but do not feel obligated to begin using them all.

The board game "Othello" has this slogan, which is appropriate:

 > A Minute to Learn... A Lifetime to Master

So enjoy this process, and do not feel any pressure to go and try to master advanced features which are awesome, but like the hardware store, are designed for that _one time where you really need it_, not the day-in, day-out "hammer and nail" work.