/*******************************************************************************
 * Copyright (c) 2018-2024 openblack developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/openblack/openblack
 *
 * openblack is licensed under the GNU General Public License version 3.
 *******************************************************************************/

#pragma once

#include "Mock.h"

class ZoomOutInMockAction final: public MockAction
{
	static constexpr uint32_t k_Start1 = k_StabilizeFrames + 1;
	static constexpr uint32_t k_End1 = k_StabilizeFrames + k_InteractionFrames - 1;
	static constexpr uint32_t k_Start2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames + 1;
	static constexpr uint32_t k_End2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames + k_InteractionFrames - 1;

public:
	~ZoomOutInMockAction() final = default;

	[[nodiscard]] bool GetBindable(openblack::input::BindableActionMap action) const final
	{
		using openblack::input::BindableActionMap;
		if (frameNumber >= k_Start1 && frameNumber <= k_End1)
		{
			return (static_cast<uint32_t>(action) & (static_cast<uint32_t>(BindableActionMap::ZOOM_ON) |
			                                         static_cast<uint32_t>(BindableActionMap::MOVE_BACKWARDS))) != 0;
		}

		if (frameNumber >= k_Start2 && frameNumber <= k_End2)
		{
			return (static_cast<uint32_t>(action) & (static_cast<uint32_t>(BindableActionMap::ZOOM_ON) |
			                                         static_cast<uint32_t>(BindableActionMap::MOVE_FORWARDS))) != 0;
		}

		return false;
	}
};

// NOLINTBEGIN(bugprone-branch-clone, google-readability-function-size, readability-function-size)
class ZoomOutInMockDynamicsSystem: public MockDynamicsSystem
{
public:
	ZoomOutInMockDynamicsSystem() = default;

	[[nodiscard]] std::optional<glm::vec2> RayCastClosestHitScreenCoord(glm::u16vec2 screenCoord) const override
	{
		if (screenCoord == k_ScreenCentreLine[0])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[1])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[2])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 563.2467041f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[3])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 189.2355652f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[4])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 100.4535294f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[5])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 62.1956444f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[6])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 39.9825211f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[7])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 26.0952835f}};
			case 202:
				return std::nullopt;
			case 301:
				return std::nullopt;
			case 502:
				return std::nullopt;
			case 601:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[8])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000, 16.1538353}};
			case 1:
				return {{1000.0000000, -770.0559082}};
			case 2:
				return {{1000.0000000, -743.0767822}};
			case 3:
				return {{1000.0000000, -5.7276611}};
			case 4:
				return {{1000.0000000, 105.8948517}};
			case 5:
				return {{1000.0000000, 112.1076202}};
			case 6:
				return {{1000.0000000, 118.2447052}};
			case 7:
				return {{1000.0000000, 200.3244019}};
			case 8:
				return {{1000.0000000, 204.8554993}};
			case 9:
				return {{1000.0000000, 264.9228516}};
			case 10:
				return {{1000.0000000, 268.0856323}};
			case 11:
				return {{1000.0000000, 271.2250366}};
			case 12:
				return {{1000.0000000, 313.6578369}};
			case 13:
				return {{1000.0000000, 316.1343384}};
			case 14:
				return {{1000.0000000, 318.7072144}};
			case 15:
				return {{1000.0000000, 321.1528931}};
			case 16:
				return {{1000.0000000, 355.7194519}};
			case 17:
				return {{1000.0000000, 357.7429199}};
			case 18:
				return {{1000.0000000, 384.0479126}};
			case 19:
				return {{1000.0000000, 407.4533691}};
			case 20:
				return {{1000.0000000, 427.1724854}};
			case 21:
				return {{1000.0000000, 428.2545471}};
			case 22:
				return {{1000.0000000, 443.9299011}};
			case 23:
				return {{1000.0000000, 444.8811340}};
			case 24:
				return {{1000.0000000, 459.2140198}};
			case 25:
				return {{1000.0000000, 460.0471497}};
			case 26:
				return {{1000.0000000, 472.5143433}};
			case 27:
				return {{1000.0000000, 473.2416382}};
			case 28:
				return {{1000.0000000, 483.4656067}};
			case 29:
				return {{1000.0000000, 484.1685791}};
			case 30:
				return {{1000.0000000, 493.8484192}};
			case 31:
				return {{1000.0000000, 494.3926697}};
			case 32:
				return {{1000.0000000, 502.4442139}};
			case 33:
				return {{1000.0000000, 502.9736938}};
			case 34:
				return {{1000.0000000, 510.7427979}};
			case 35:
				return {{1000.0000000, 511.1937256}};
			case 36:
				return {{1000.0000000, 518.1301270}};
			case 37:
				return {{1000.0000000, 518.5700684}};
			case 38:
				return {{1000.0000000, 519.0095215}};
			case 39:
				return {{1000.0000000, 500.6634216}};
			case 40:
				return {{1000.0000000, 498.8476868}};
			case 41:
				return {{1000.0000000, 471.6894531}};
			case 42:
				return {{1000.0000000, 469.9794006}};
			case 43:
				return {{1000.0000000, 442.9660645}};
			case 44:
				return {{1000.0000000, 417.5871277}};
			case 45:
				return {{1000.0000000, 391.1619568}};
			case 46:
				return {{1000.0000000, 389.5305786}};
			case 47:
				return {{1000.0000000, 364.7833862}};
			case 48:
				return {{1000.0000000, 363.1747437}};
			case 49:
				return {{1000.0000000, 337.2171631}};
			case 50:
				return {{1000.0000000, 335.5335999}};
			case 51:
				return {{1000.0000000, 309.9683228}};
			case 52:
				return {{1000.0000000, 308.3560791}};
			case 53:
				return {{1000.0000000, 285.0237427}};
			case 54:
				return {{1000.0000000, 283.0931091}};
			case 55:
				return {{1000.0000000, 258.5480347}};
			case 56:
				return {{1000.0000000, 256.9194946}};
			case 57:
				return {{1000.0000000, 232.4271393}};
			case 58:
				return {{1000.0000000, 230.9935760}};
			case 59:
				return {{1000.0000000, 208.8545990}};
			case 60:
				return {{1000.0000000, 207.3721313}};
			case 61:
				return {{1000.0000000, 184.0393066}};
			case 62:
				return {{1000.0000000, 182.6068115}};
			case 63:
				return {{1000.0000000, 161.3394165}};
			case 64:
				return {{1000.0000000, 159.7380066}};
			case 65:
				return {{1000.0000000, 137.5003815}};
			case 66:
				return {{1000.0000000, 115.8879089}};
			case 67:
				return {{1000.0000000, 95.8544159}};
			case 68:
				return {{1000.0000000, 94.5362091}};
			case 69:
				return {{1000.0000000, 73.7548065}};
			case 70:
				return {{1000.0000000, 72.4786377}};
			case 71:
				return {{1000.0000000, 52.5038910}};
			case 72:
				return {{1000.0000000, 51.1960602}};
			case 73:
				return {{1000.0000000, 32.9644012}};
			case 74:
				return {{1000.0000000, 31.5235901}};
			case 75:
				return {{1000.0000000, 30.2701569}};
			case 76:
				return {{1000.0000000, 11.1421204}};
			case 77:
				return {{1000.0000000, 10.1613617}};
			case 78:
				return {{1000.0000000, -7.2264404}};
			case 79:
				return {{1000.0000000, -8.4018555}};
			case 80:
				return {{1000.0000000, -26.1702881}};
			case 81:
				return {{1000.0000000, -27.1201172}};
			case 82:
				return {{1000.0000000, -44.8266602}};
			case 83:
				return {{1000.0000000, -45.5584717}};
			case 84:
				return {{1000.0000000, -61.5065918}};
			case 85:
				return {{1000.0000000, -62.6777344}};
			case 86:
				return {{1000.0000000, -78.9976807}};
			case 87:
				return {{1000.0000000, -79.9364014}};
			case 88:
				return {{1000.0000000, -95.5395508}};
			case 89:
				return {{1000.0000000, -96.6873779}};
			case 90:
				return {{1000.0000000, -110.8873291}};
			case 91:
				return {{1000.0000000, -125.5928955}};
			case 92:
				return {{1000.0000000, -139.0494385}};
			case 93:
				return {{1000.0000000, -139.7036133}};
			case 94:
				return {{1000.0000000, -153.5233154}};
			case 95:
				return {{1000.0000000, -154.3769531}};
			case 96:
				return {{1000.0000000, -167.5012207}};
			case 97:
				return {{1000.0000000, -168.5506592}};
			case 98:
				return {{1000.0000000, -180.2821045}};
			case 99:
				return {{1000.0000000, -181.0770264}};
			case 100:
				return {{1000.0000000, -193.0888672}};
			case 101:
				return {{1000.0000000, -194.0817871}};
			case 102:
				return {{1000.0000000, -205.6433105}};
			case 103:
				return {{1000.0000000, -216.1108398}};
			case 104:
				return {{1000.0000000, -216.8082275}};
			case 105:
				return {{1000.0000000, -227.3505859}};
			case 106:
				return {{1000.0000000, -228.0187988}};
			case 107:
				return {{1000.0000000, -228.5657959}};
			case 108:
				return {{1000.0000000, -238.1468506}};
			case 109:
				return {{1000.0000000, -238.7722168}};
			case 110:
				return {{1000.0000000, -248.4827881}};
			case 111:
				return {{1000.0000000, -249.0815430}};
			case 112:
				return {{1000.0000000, -258.1691895}};
			case 113:
				return {{1000.0000000, -258.7281494}};
			case 114:
				return {{1000.0000000, -275.2501221}};
			case 115:
				return {{1000.0000000, -283.1724854}};
			case 116:
				return {{1000.0000000, -283.3957520}};
			case 117:
				return {{1000.0000000, -290.4317627}};
			case 118:
				return {{1000.0000000, -290.8327637}};
			case 119:
				return {{1000.0000000, -297.8603516}};
			case 120:
				return {{1000.0000000, -298.2362061}};
			case 121:
				return {{1000.0000000, -304.2756348}};
			case 122:
				return {{1000.0000000, -304.6058350}};
			case 123:
				return {{1000.0000000, -305.0563965}};
			case 124:
				return {{1000.0000000, -311.0228271}};
			case 125:
				return {{1000.0000000, -316.6230469}};
			case 126:
				return {{1000.0000000, -317.1135254}};
			case 127:
				return {{1000.0000000, -321.9949951}};
			case 128:
				return {{1000.0000000, -322.4465332}};
			case 129:
				return {{1000.0000000, -322.8072510}};
			case 130:
				return {{1000.0000000, -327.5804443}};
			case 131:
				return {{1000.0000000, -332.0192871}};
			case 132:
				return {{1000.0000000, -332.1802979}};
			case 133:
				return {{1000.0000000, -336.0573730}};
			case 134:
				return {{1000.0000000, -336.1817627}};
			case 135:
				return {{1000.0000000, -340.1765137}};
			case 136:
				return {{1000.0000000, -340.2766113}};
			case 137:
				return {{1000.0000000, -343.6551514}};
			case 138:
				return {{1000.0000000, -346.5415039}};
			case 139:
				return {{1000.0000000, -349.7819824}};
			case 140:
				return {{1000.0000000, -349.7995605}};
			case 141:
				return {{1000.0000000, -352.2539062}};
			case 142:
				return {{1000.0000000, -352.4711914}};
			case 143:
				return {{1000.0000000, -354.5693359}};
			case 144:
				return {{1000.0000000, -354.7683105}};
			case 145:
				return {{1000.0000000, -356.8011475}};
			case 146:
				return {{1000.0000000, -356.9757080}};
			case 147:
				return {{1000.0000000, -358.6204834}};
			case 148:
				return {{1000.0000000, -358.7729492}};
			case 149:
				return {{1000.0000000, -360.5307617}};
			case 150:
				return {{1000.0000000, -360.4355469}};
			case 151:
				return {{1000.0000000, -361.8718262}};
			case 152:
				return {{1000.0000000, -361.7562256}};
			case 153:
				return {{1000.0000000, -363.0778809}};
			case 154:
				return {{1000.0000000, -363.1750488}};
			case 155:
				return {{1000.0000000, -364.0666504}};
			case 156:
				return {{1000.0000000, -364.1520996}};
			case 157:
				return {{1000.0000000, -364.8118896}};
			case 158:
				return {{1000.0000000, -365.1131592}};
			case 159:
				return {{1000.0000000, -365.6785889}};
			case 160:
				return {{1000.0000000, -365.7379150}};
			case 161:
				return {{1000.0000000, -366.8975830}};
			case 162:
				return {{1000.0000000, -367.1383057}};
			case 163:
				return {{1000.0000000, -367.1704102}};
			case 164:
				return {{1000.0000000, -367.5058594}};
			case 165:
				return {{1000.0000000, -367.5330811}};
			case 166:
				return {{1000.0000000, -367.8172607}};
			case 167:
				return {{1000.0000000, -367.8402100}};
			case 168:
				return {{1000.0000000, -368.0611572}};
			case 169:
				return {{1000.0000000, -368.0804443}};
			case 170:
				return {{1000.0000000, -368.2398682}};
			case 171:
				return {{1000.0000000, -368.2490234}};
			case 172:
				return {{1000.0000000, -368.3774414}};
			case 173:
				return {{1000.0000000, -368.1584473}};
			case 174:
				return {{1000.0000000, -368.4852295}};
			case 175:
				return {{1000.0000000, -368.4898682}};
			case 176:
				return {{1000.0000000, -368.5522461}};
			case 177:
				return {{1000.0000000, -368.5556641}};
			case 178:
				return {{1000.0000000, -368.6008301}};
			case 179:
				return {{1000.0000000, -368.6030273}};
			case 180:
				return {{1000.0000000, -368.6293945}};
			case 181:
				return {{1000.0000000, -368.6307373}};
			case 182:
				return {{1000.0000000, -368.6463623}};
			case 183:
				return {{1000.0000000, -368.6523438}};
			case 184:
				return {{1000.0000000, -368.6516113}};
			case 185:
				return {{1000.0000000, -368.6513672}};
			case 186:
				return {{1000.0000000, -368.6455078}};
			case 187:
				return {{1000.0000000, -368.6450195}};
			case 188:
				return {{1000.0000000, -368.6356201}};
			case 189:
				return {{1000.0000000, -368.6350098}};
			case 190:
				return {{1000.0000000, -368.6240234}};
			case 191:
				return {{1000.0000000, -368.6234131}};
			case 192:
				return {{1000.0000000, -368.6105957}};
			case 193:
				return {{1000.0000000, -368.6097412}};
			case 194:
				return {{1000.0000000, -368.5974121}};
			case 195:
				return {{1000.0000000, -368.5965576}};
			case 196:
				return {{1000.0000000, -368.5834961}};
			case 197:
				return {{1000.0000000, -368.5827637}};
			case 198:
				return {{1000.0000000, -368.5701904}};
			case 199:
				return {{1000.0000000, -368.5695801}};
			case 200:
				return {{1000.0000000, -368.5584717}};
			case 201:
				return {{1000.0000000, -368.5578613}};
			case 202:
				return {{1000.0000000, -368.5469971}};
			case 203:
				return {{1000.0000000, -368.5463867}};
			case 204:
				return {{1000.0000000, -368.5367432}};
			case 205:
				return {{1000.0000000, -368.5361328}};
			case 206:
				return {{1000.0000000, -368.5201416}};
			case 207:
				return {{1000.0000000, -368.5137939}};
			case 208:
				return {{1000.0000000, -368.5135498}};
			case 209:
				return {{1000.0000000, -368.2873535}};
			case 210:
				return {{1000.0000000, -368.2816162}};
			case 211:
				return {{1000.0000000, -368.5142822}};
			case 212:
				return {{1000.0000000, -368.5092773}};
			case 213:
				return {{1000.0000000, -368.5089111}};
			case 214:
				return {{1000.0000000, -368.2791748}};
			case 215:
				return {{1000.0000000, -368.5117188}};
			case 216:
				return {{1000.0000000, -368.5083008}};
			case 217:
				return {{1000.0000000, -368.5152588}};
			case 218:
				return {{1000.0000000, -368.5123291}};
			case 219:
				return {{1000.0000000, -368.5195312}};
			case 220:
				return {{1000.0000000, -368.5172119}};
			case 221:
				return {{1000.0000000, -368.5241699}};
			case 222:
				return {{1000.0000000, -368.5222168}};
			case 223:
				return {{1000.0000000, -368.5292969}};
			case 224:
				return {{1000.0000000, -368.5278320}};
			case 225:
				return {{1000.0000000, -368.5349121}};
			case 226:
				return {{1000.0000000, -368.5336914}};
			case 227:
				return {{1000.0000000, -368.3149414}};
			case 228:
				return {{1000.0000000, -368.3138428}};
			case 229:
				return {{1000.0000000, -368.5541992}};
			case 230:
				return {{1000.0000000, -368.5529785}};
			case 231:
				return {{1000.0000000, -368.3409424}};
			case 232:
				return {{1000.0000000, -368.5816650}};
			case 233:
				return {{1000.0000000, -368.5815430}};
			case 234:
				return {{1000.0000000, -368.5812988}};
			case 235:
				return {{1000.0000000, -368.3620605}};
			case 236:
				return {{1000.0000000, -368.3693848}};
			case 237:
				return {{1000.0000000, -368.6027832}};
			case 238:
				return {{1000.0000000, -368.3837891}};
			case 239:
				return {{1000.0000000, -368.3836670}};
			case 240:
				return {{1000.0000000, -368.3908691}};
			case 241:
				return {{1000.0000000, -368.6243896}};
			case 242:
				return {{1000.0000000, -368.4053955}};
			case 243:
				return {{1000.0000000, -368.4053955}};
			case 244:
				return {{1000.0000000, -368.6461182}};
			case 245:
				return {{1000.0000000, -368.6462402}};
			case 246:
				return {{1000.0000000, -368.4270020}};
			case 247:
				return {{1000.0000000, -368.4270020}};
			case 248:
				return {{1000.0000000, -368.4414062}};
			case 249:
				return {{1000.0000000, -368.4412842}};
			case 250:
				return {{1000.0000000, -368.4484863}};
			case 251:
				return {{1000.0000000, -368.4484863}};
			case 252:
				return {{1000.0000000, -368.4631348}};
			case 253:
				return {{1000.0000000, -368.4631348}};
			case 254:
				return {{1000.0000000, -368.4631348}};
			case 255:
				return {{1000.0000000, -368.4848633}};
			case 256:
				return {{1000.0000000, -368.4993896}};
			case 257:
				return {{1000.0000000, -368.4995117}};
			case 258:
				return {{1000.0000000, -368.5065918}};
			case 259:
				return {{1000.0000000, -368.5065918}};
			case 260:
				return {{1000.0000000, -368.2800293}};
			case 261:
				return {{1000.0000000, -368.5211182}};
			case 262:
				return {{1000.0000000, -368.5211182}};
			case 263:
				return {{1000.0000000, -368.3017578}};
			case 264:
				return {{1000.0000000, -368.5355225}};
			case 265:
				return {{1000.0000000, -368.5427246}};
			case 266:
				return {{1000.0000000, -368.5573730}};
			case 267:
				return {{1000.0000000, -368.5572510}};
			case 268:
				return {{1000.0000000, -368.3377686}};
			case 269:
				return {{1000.0000000, -368.3376465}};
			case 270:
				return {{1000.0000000, -368.5788574}};
			case 271:
				return {{1000.0000000, -368.5788574}};
			case 272:
				return {{1000.0000000, -368.3593750}};
			case 273:
				return {{1000.0000000, -368.3592529}};
			case 274:
				return {{1000.0000000, -368.6007080}};
			case 275:
				return {{1000.0000000, -368.3737793}};
			case 276:
				return {{1000.0000000, -368.3737793}};
			case 277:
				return {{1000.0000000, -368.6151123}};
			case 278:
				return {{1000.0000000, -368.6152344}};
			case 279:
				return {{1000.0000000, -368.6151123}};
			case 280:
				return {{1000.0000000, -368.3953857}};
			case 281:
				return {{1000.0000000, -368.6368408}};
			case 282:
				return {{1000.0000000, -368.4169922}};
			case 283:
				return {{1000.0000000, -368.4169922}};
			case 284:
				return {{1000.0000000, -368.4167480}};
			case 285:
				return {{1000.0000000, -368.4312744}};
			case 286:
				return {{1000.0000000, -368.4311523}};
			case 287:
				return {{1000.0000000, -368.4310303}};
			case 288:
				return {{1000.0000000, -368.4454346}};
			case 289:
				return {{1000.0000000, -368.4454346}};
			case 290:
				return {{1000.0000000, -368.4451904}};
			case 291:
				return {{1000.0000000, -368.4526367}};
			case 292:
				return {{1000.0000000, -368.4525146}};
			case 293:
				return {{1000.0000000, -368.4522705}};
			case 294:
				return {{1000.0000000, -368.4669189}};
			case 295:
				return {{1000.0000000, -368.4665527}};
			case 296:
				return {{1000.0000000, -368.4809570}};
			case 297:
				return {{1000.0000000, -368.4812012}};
			case 298:
				return {{1000.0000000, -368.4809570}};
			case 299:
				return {{1000.0000000, -368.4880371}};
			case 300:
				return {{1000.0000000, -368.4880371}};
			case 301:
				return {{1000.0000000, -368.2607422}};
			case 302:
				return {{1000.0000000, -368.5023193}};
			case 303:
				return {{1000.0000000, -368.5020752}};
			case 304:
				return {{1000.0000000, -368.2821045}};
			case 305:
				return {{1000.0000000, -368.5164795}};
			case 306:
				return {{1000.0000000, -368.5162354}};
			case 307:
				return {{1000.0000000, -368.5234375}};
			case 308:
				return {{1000.0000000, -368.5231934}};
			case 309:
				return {{1000.0000000, -368.3028564}};
			case 310:
				return {{1000.0000000, -368.5446777}};
			case 311:
				return {{1000.0000000, -368.5445557}};
			case 312:
				return {{1000.0000000, -368.5517578}};
			case 313:
				return {{1000.0000000, -368.5517578}};
			case 314:
				return {{1000.0000000, -368.5516357}};
			case 315:
				return {{1000.0000000, -368.5588379}};
			case 316:
				return {{1000.0000000, -368.5588379}};
			case 317:
				return {{1000.0000000, -368.5585938}};
			case 318:
				return {{1000.0000000, -368.5657959}};
			case 319:
				return {{1000.0000000, -368.5656738}};
			case 320:
				return {{1000.0000000, -368.5728760}};
			case 321:
				return {{1000.0000000, -368.5728760}};
			case 322:
				return {{1000.0000000, -368.5727539}};
			case 323:
				return {{1000.0000000, -368.3452148}};
			case 324:
				return {{1000.0000000, -368.3453369}};
			case 325:
				return {{1000.0000000, -368.3452148}};
			case 326:
				return {{1000.0000000, -368.5799561}};
			case 327:
				return {{1000.0000000, -368.5798340}};
			case 328:
				return {{1000.0000000, -368.5798340}};
			case 329:
				return {{1000.0000000, -368.3525391}};
			case 330:
				return {{1000.0000000, -368.3524170}};
			case 331:
				return {{1000.0000000, -368.3522949}};
			case 332:
				return {{1000.0000000, -368.5869141}};
			case 333:
				return {{1000.0000000, -368.5870361}};
			case 334:
				return {{1000.0000000, -368.5869141}};
			case 335:
				return {{1000.0000000, -368.3596191}};
			case 336:
				return {{1000.0000000, -368.3594971}};
			case 337:
				return {{1000.0000000, -368.3594971}};
			case 338:
				return {{1000.0000000, -368.3594971}};
			case 339:
				return {{1000.0000000, -368.3594971}};
			case 340:
				return {{1000.0000000, -368.3594971}};
			case 341:
				return {{1000.0000000, -368.5942383}};
			case 342:
				return {{1000.0000000, -368.5942383}};
			case 343:
				return {{1000.0000000, -368.5942383}};
			case 344:
				return {{1000.0000000, -368.5942383}};
			case 345:
				return {{1000.0000000, -368.5942383}};
			case 346:
				return {{1000.0000000, -368.3666992}};
			case 347:
				return {{1000.0000000, -368.3668213}};
			case 348:
				return {{1000.0000000, -368.3666992}};
			case 349:
				return {{1000.0000000, -368.3666992}};
			case 350:
				return {{1000.0000000, -368.3665771}};
			case 351:
				return {{1000.0000000, -368.3666992}};
			case 352:
				return {{1000.0000000, -368.3668213}};
			case 353:
				return {{1000.0000000, -368.3668213}};
			case 354:
				return {{1000.0000000, -368.3666992}};
			case 355:
				return {{1000.0000000, -368.3666992}};
			case 356:
				return {{1000.0000000, -368.3666992}};
			case 357:
				return {{1000.0000000, -368.3666992}};
			case 358:
				return {{1000.0000000, -368.3665771}};
			case 359:
				return {{1000.0000000, -368.3665771}};
			case 360:
				return {{1000.0000000, -368.3665771}};
			case 361:
				return {{1000.0000000, -368.3666992}};
			case 362:
				return {{1000.0000000, -368.3665771}};
			case 363:
				return {{1000.0000000, -368.3665771}};
			case 364:
				return {{1000.0000000, -368.3665771}};
			case 365:
				return {{1000.0000000, -368.3665771}};
			case 366:
				return {{1000.0000000, -368.3666992}};
			case 367:
				return {{1000.0000000, -368.3666992}};
			case 368:
				return {{1000.0000000, -368.3665771}};
			case 369:
				return {{1000.0000000, -368.3665771}};
			case 370:
				return {{1000.0000000, -368.3666992}};
			case 371:
				return {{1000.0000000, -368.3666992}};
			case 372:
				return {{1000.0000000, -368.3666992}};
			case 373:
				return {{1000.0000000, -368.3666992}};
			case 374:
				return {{1000.0000000, -368.3665771}};
			case 375:
				return {{1000.0000000, -368.3665771}};
			case 376:
				return {{1000.0000000, -368.3665771}};
			case 377:
				return {{1000.0000000, -368.3665771}};
			case 378:
				return {{1000.0000000, -368.3665771}};
			case 379:
				return {{1000.0000000, -368.3664551}};
			case 380:
				return {{1000.0000000, -368.3665771}};
			case 381:
				return {{1000.0000000, -368.3665771}};
			case 382:
				return {{1000.0000000, -368.3664551}};
			case 383:
				return {{1000.0000000, -368.3664551}};
			case 384:
				return {{1000.0000000, -368.3665771}};
			case 385:
				return {{1000.0000000, -368.3665771}};
			case 386:
				return {{1000.0000000, -368.3665771}};
			case 387:
				return {{1000.0000000, -368.3665771}};
			case 388:
				return {{1000.0000000, -368.3665771}};
			case 389:
				return {{1000.0000000, -368.3665771}};
			case 390:
				return {{1000.0000000, -368.3665771}};
			case 391:
				return {{1000.0000000, -368.3665771}};
			case 392:
				return {{1000.0000000, -368.3665771}};
			case 393:
				return {{1000.0000000, -368.3665771}};
			case 394:
				return {{1000.0000000, -368.3664551}};
			case 395:
				return {{1000.0000000, -368.3665771}};
			case 396:
				return {{1000.0000000, -368.3665771}};
			case 397:
				return {{1000.0000000, -368.3665771}};
			case 398:
				return {{1000.0000000, -368.3665771}};
			case 399:
				return {{1000.0000000, -368.3665771}};
			case 400:
				return {{1000.0000000, -368.3666992}};
			case 401:
				return {{1000.0000000, -368.3665771}};
			case 402:
				return {{1000.0000000, -368.3665771}};
			case 403:
				return {{1000.0000000, -368.3665771}};
			case 404:
				return {{1000.0000000, -368.3665771}};
			case 405:
				return {{1000.0000000, -368.3665771}};
			case 406:
				return {{1000.0000000, -368.3665771}};
			case 407:
				return {{1000.0000000, -368.3665771}};
			case 408:
				return {{1000.0000000, -368.3665771}};
			case 409:
				return {{1000.0000000, -368.3665771}};
			case 410:
				return {{1000.0000000, -368.3665771}};
			case 411:
				return {{1000.0000000, -368.3665771}};
			case 412:
				return {{1000.0000000, -368.3665771}};
			case 413:
				return {{1000.0000000, -368.3665771}};
			case 414:
				return {{1000.0000000, -368.3665771}};
			case 415:
				return {{1000.0000000, -368.3665771}};
			case 416:
				return {{1000.0000000, -368.3665771}};
			case 417:
				return {{1000.0000000, -368.3666992}};
			case 418:
				return {{1000.0000000, -368.3666992}};
			case 419:
				return {{1000.0000000, -368.3666992}};
			case 420:
				return {{1000.0000000, -368.3666992}};
			case 421:
				return {{1000.0000000, -368.3666992}};
			case 422:
				return {{1000.0000000, -368.3665771}};
			case 423:
				return {{1000.0000000, -368.3665771}};
			case 424:
				return {{1000.0000000, -368.3665771}};
			case 425:
				return {{1000.0000000, -368.3666992}};
			case 426:
				return {{1000.0000000, -368.3666992}};
			case 427:
				return {{1000.0000000, -368.3666992}};
			case 428:
				return {{1000.0000000, -368.3666992}};
			case 429:
				return {{1000.0000000, -368.3666992}};
			case 430:
				return {{1000.0000000, -368.3666992}};
			case 431:
				return {{1000.0000000, -368.3666992}};
			case 432:
				return {{1000.0000000, -368.3666992}};
			case 433:
				return {{1000.0000000, -368.3666992}};
			case 434:
				return {{1000.0000000, -368.3666992}};
			case 435:
				return {{1000.0000000, -368.3666992}};
			case 436:
				return {{1000.0000000, -368.3666992}};
			case 437:
				return {{1000.0000000, -368.3666992}};
			case 438:
				return {{1000.0000000, -368.3666992}};
			case 439:
				return {{1000.0000000, -368.3666992}};
			case 440:
				return {{1000.0000000, -368.3666992}};
			case 441:
				return {{1000.0000000, -368.3666992}};
			case 442:
				return {{1000.0000000, -368.3666992}};
			case 443:
				return {{1000.0000000, -368.3666992}};
			case 444:
				return {{1000.0000000, -368.3666992}};
			case 445:
				return {{1000.0000000, -368.3666992}};
			case 446:
				return {{1000.0000000, -368.3666992}};
			case 447:
				return {{1000.0000000, -368.3666992}};
			case 448:
				return {{1000.0000000, -368.3666992}};
			case 449:
				return {{1000.0000000, -368.3666992}};
			case 450:
				return {{1000.0000000, -368.3666992}};
			case 451:
				return {{1000.0000000, -368.3666992}};
			case 452:
				return {{1000.0000000, -368.3666992}};
			case 453:
				return {{1000.0000000, -368.3666992}};
			case 454:
				return {{1000.0000000, -368.3666992}};
			case 455:
				return {{1000.0000000, -368.3666992}};
			case 456:
				return {{1000.0000000, -368.3666992}};
			case 457:
				return {{1000.0000000, -368.3666992}};
			case 458:
				return {{1000.0000000, -368.3666992}};
			case 459:
				return {{1000.0000000, -368.3666992}};
			case 460:
				return {{1000.0000000, -368.3666992}};
			case 461:
				return {{1000.0000000, -368.3666992}};
			case 462:
				return {{1000.0000000, -368.3666992}};
			case 463:
				return {{1000.0000000, -368.3666992}};
			case 464:
				return {{1000.0000000, -368.3666992}};
			case 465:
				return {{1000.0000000, -368.3666992}};
			case 466:
				return {{1000.0000000, -368.3666992}};
			case 467:
				return {{1000.0000000, -368.3666992}};
			case 468:
				return {{1000.0000000, -368.3666992}};
			case 469:
				return {{1000.0000000, -368.3666992}};
			case 470:
				return {{1000.0000000, -368.3666992}};
			case 471:
				return {{1000.0000000, -368.3666992}};
			case 472:
				return {{1000.0000000, -368.3666992}};
			case 473:
				return {{1000.0000000, -368.3666992}};
			case 474:
				return {{1000.0000000, -368.3666992}};
			case 475:
				return {{1000.0000000, -368.3666992}};
			case 476:
				return {{1000.0000000, -368.3666992}};
			case 477:
				return {{1000.0000000, -368.3666992}};
			case 478:
				return {{1000.0000000, -368.3666992}};
			case 479:
				return {{1000.0000000, -368.3666992}};
			case 480:
				return {{1000.0000000, -368.3666992}};
			case 481:
				return {{1000.0000000, -368.3666992}};
			case 482:
				return {{1000.0000000, -368.3666992}};
			case 483:
				return {{1000.0000000, -368.3666992}};
			case 484:
				return {{1000.0000000, -368.3666992}};
			case 485:
				return {{1000.0000000, -368.3666992}};
			case 486:
				return {{1000.0000000, -368.3666992}};
			case 487:
				return {{1000.0000000, -368.3666992}};
			case 488:
				return {{1000.0000000, -368.3666992}};
			case 489:
				return {{1000.0000000, -368.3666992}};
			case 490:
				return {{1000.0000000, -368.3666992}};
			case 491:
				return {{1000.0000000, -368.3666992}};
			case 492:
				return {{1000.0000000, -368.3666992}};
			case 493:
				return {{1000.0000000, -368.3666992}};
			case 494:
				return {{1000.0000000, -368.3666992}};
			case 495:
				return {{1000.0000000, -368.3666992}};
			case 496:
				return {{1000.0000000, -368.3666992}};
			case 497:
				return {{1000.0000000, -368.3666992}};
			case 498:
				return {{1000.0000000, -368.3666992}};
			case 499:
				return {{1000.0000000, -368.3666992}};
			case 500:
				return {{1000.0000000, -368.3666992}};
			case 501:
				return {{1000.0000000, -368.3666992}};
			case 502:
				return {{1000.0000000, -368.3666992}};
			case 503:
				return {{1000.0000000, -368.3666992}};
			case 504:
				return {{1000.0000000, -368.3665771}};
			case 505:
				return {{1000.0000000, -368.3666992}};
			case 506:
				return {{1000.0000000, -368.3666992}};
			case 507:
				return {{1000.0000000, -368.3668213}};
			case 508:
				return {{1000.0000000, -368.3666992}};
			case 509:
				return {{1000.0000000, -368.5942383}};
			case 510:
				return {{1000.0000000, -368.5942383}};
			case 511:
				return {{1000.0000000, -368.3594971}};
			case 512:
				return {{1000.0000000, -368.3594971}};
			case 513:
				return {{1000.0000000, -368.3593750}};
			case 514:
				return {{1000.0000000, -368.3593750}};
			case 515:
				return {{1000.0000000, -368.3593750}};
			case 516:
				return {{1000.0000000, -368.3592529}};
			case 517:
				return {{1000.0000000, -368.3520508}};
			case 518:
				return {{1000.0000000, -368.3519287}};
			case 519:
				return {{1000.0000000, -368.5793457}};
			case 520:
				return {{1000.0000000, -368.5793457}};
			case 521:
				return {{1000.0000000, -368.5792236}};
			case 522:
				return {{1000.0000000, -368.5720215}};
			case 523:
				return {{1000.0000000, -368.5720215}};
			case 524:
				return {{1000.0000000, -368.5718994}};
			case 525:
				return {{1000.0000000, -368.5645752}};
			case 526:
				return {{1000.0000000, -368.5645752}};
			case 527:
				return {{1000.0000000, -368.5643311}};
			case 528:
				return {{1000.0000000, -368.5571289}};
			case 529:
				return {{1000.0000000, -368.5570068}};
			case 530:
				return {{1000.0000000, -368.5568848}};
			case 531:
				return {{1000.0000000, -368.5494385}};
			case 532:
				return {{1000.0000000, -368.3146973}};
			case 533:
				return {{1000.0000000, -368.3146973}};
			case 534:
				return {{1000.0000000, -368.3073730}};
			case 535:
				return {{1000.0000000, -368.3072510}};
			case 536:
				return {{1000.0000000, -368.5341797}};
			case 537:
				return {{1000.0000000, -368.5196533}};
			case 538:
				return {{1000.0000000, -368.5195312}};
			case 539:
				return {{1000.0000000, -368.5048828}};
			case 540:
				return {{1000.0000000, -368.5050049}};
			case 541:
				return {{1000.0000000, -368.5046387}};
			case 542:
				return {{1000.0000000, -368.4975586}};
			case 543:
				return {{1000.0000000, -368.4975586}};
			case 544:
				return {{1000.0000000, -368.4971924}};
			case 545:
				return {{1000.0000000, -368.4826660}};
			case 546:
				return {{1000.0000000, -368.4826660}};
			case 547:
				return {{1000.0000000, -368.4824219}};
			case 548:
				return {{1000.0000000, -368.4752197}};
			case 549:
				return {{1000.0000000, -368.4750977}};
			case 550:
				return {{1000.0000000, -368.4749756}};
			case 551:
				return {{1000.0000000, -368.4603271}};
			case 552:
				return {{1000.0000000, -368.4602051}};
			case 553:
				return {{1000.0000000, -368.4455566}};
			case 554:
				return {{1000.0000000, -368.4454346}};
			case 555:
				return {{1000.0000000, -368.4381104}};
			case 556:
				return {{1000.0000000, -368.4379883}};
			case 557:
				return {{1000.0000000, -368.4378662}};
			case 558:
				return {{1000.0000000, -368.4232178}};
			case 559:
				return {{1000.0000000, -368.4232178}};
			case 560:
				return {{1000.0000000, -368.4228516}};
			case 561:
				return {{1000.0000000, -368.6427002}};
			case 562:
				return {{1000.0000000, -368.6428223}};
			case 563:
				return {{1000.0000000, -368.4083252}};
			case 564:
				return {{1000.0000000, -368.4011230}};
			case 565:
				return {{1000.0000000, -368.4010010}};
			case 566:
				return {{1000.0000000, -368.4008789}};
			case 567:
				return {{1000.0000000, -368.3863525}};
			case 568:
				return {{1000.0000000, -368.3863525}};
			case 569:
				return {{1000.0000000, -368.6055908}};
			case 570:
				return {{1000.0000000, -368.3642578}};
			case 571:
				return {{1000.0000000, -368.5837402}};
			case 572:
				return {{1000.0000000, -368.5836182}};
			case 573:
				return {{1000.0000000, -368.3492432}};
			case 574:
				return {{1000.0000000, -368.3421631}};
			case 575:
				return {{1000.0000000, -368.5689697}};
			case 576:
				return {{1000.0000000, -368.5687256}};
			case 577:
				return {{1000.0000000, -368.3273926}};
			case 578:
				return {{1000.0000000, -368.3273926}};
			case 579:
				return {{1000.0000000, -368.3272705}};
			case 580:
				return {{1000.0000000, -368.5466309}};
			case 581:
				return {{1000.0000000, -368.5467529}};
			case 582:
				return {{1000.0000000, -368.3126221}};
			case 583:
				return {{1000.0000000, -368.5319824}};
			case 584:
				return {{1000.0000000, -368.5318604}};
			case 585:
				return {{1000.0000000, -368.2907715}};
			case 586:
				return {{1000.0000000, -368.2906494}};
			case 587:
				return {{1000.0000000, -368.5172119}};
			case 588:
				return {{1000.0000000, -368.5098877}};
			case 589:
				return {{1000.0000000, -368.5098877}};
			case 590:
				return {{1000.0000000, -368.5097656}};
			case 591:
				return {{1000.0000000, -368.4954834}};
			case 592:
				return {{1000.0000000, -368.4954834}};
			case 593:
				return {{1000.0000000, -368.4954834}};
			case 594:
				return {{1000.0000000, -368.4810791}};
			case 595:
				return {{1000.0000000, -368.4810791}};
			case 596:
				return {{1000.0000000, -368.4810791}};
			case 597:
				return {{1000.0000000, -368.4738770}};
			case 598:
				return {{1000.0000000, -368.4739990}};
			case 599:
				return {{1000.0000000, -368.2403564}};
			case 600:
				return {{1000.0000000, -368.4593506}};
			case 601:
				return {{1000.0000000, -368.4592285}};
			case 602:
				return {{1000.0000000, -368.4376221}};
			case 603:
				return {{1000.0000000, -368.4376221}};
			case 604:
				return {{1000.0000000, -368.4230957}};
			case 605:
				return {{1000.0000000, -368.4230957}};
			case 606:
				return {{1000.0000000, -368.4157715}};
			case 607:
				return {{1000.0000000, -368.4157715}};
			case 608:
				return {{1000.0000000, -368.4157715}};
			case 609:
				return {{1000.0000000, -368.6347656}};
			case 610:
				return {{1000.0000000, -368.6347656}};
			case 611:
				return {{1000.0000000, -368.3942871}};
			case 612:
				return {{1000.0000000, -368.3942871}};
			case 613:
				return {{1000.0000000, -368.3869629}};
			case 614:
				return {{1000.0000000, -368.3870850}};
			case 615:
				return {{1000.0000000, -368.6131592}};
			case 616:
				return {{1000.0000000, -368.3796387}};
			case 617:
				return {{1000.0000000, -368.3797607}};
			case 618:
				return {{1000.0000000, -368.6060791}};
			case 619:
				return {{1000.0000000, -368.6059570}};
			case 620:
				return {{1000.0000000, -368.6059570}};
			case 621:
				return {{1000.0000000, -368.3725586}};
			case 622:
				return {{1000.0000000, -368.3725586}};
			case 623:
				return {{1000.0000000, -368.3653564}};
			case 624:
				return {{1000.0000000, -368.3653564}};
			case 625:
				return {{1000.0000000, -368.3653564}};
			case 626:
				return {{1000.0000000, -368.3652344}};
			case 627:
				return {{1000.0000000, -368.3653564}};
			case 628:
				return {{1000.0000000, -368.3653564}};
			case 629:
				return {{1000.0000000, -368.3580322}};
			case 630:
				return {{1000.0000000, -368.3581543}};
			case 631:
				return {{1000.0000000, -368.3581543}};
			case 632:
				return {{1000.0000000, -368.3581543}};
			case 633:
				return {{1000.0000000, -368.3581543}};
			case 634:
				return {{1000.0000000, -368.5841064}};
			case 635:
				return {{1000.0000000, -368.5839844}};
			case 636:
				return {{1000.0000000, -368.5841064}};
			case 637:
				return {{1000.0000000, -368.5839844}};
			case 638:
				return {{1000.0000000, -368.5841064}};
			case 639:
				return {{1000.0000000, -368.3507080}};
			case 640:
				return {{1000.0000000, -368.3508301}};
			case 641:
				return {{1000.0000000, -368.3508301}};
			case 642:
				return {{1000.0000000, -368.3508301}};
			case 643:
				return {{1000.0000000, -368.3508301}};
			case 644:
				return {{1000.0000000, -368.3508301}};
			case 645:
				return {{1000.0000000, -368.3509521}};
			case 646:
				return {{1000.0000000, -368.3509521}};
			case 647:
				return {{1000.0000000, -368.3508301}};
			case 648:
				return {{1000.0000000, -368.3508301}};
			case 649:
				return {{1000.0000000, -368.3508301}};
			case 650:
				return {{1000.0000000, -368.3508301}};
			case 651:
				return {{1000.0000000, -368.3509521}};
			case 652:
				return {{1000.0000000, -368.3509521}};
			case 653:
				return {{1000.0000000, -368.3509521}};
			case 654:
				return {{1000.0000000, -368.3508301}};
			case 655:
				return {{1000.0000000, -368.3508301}};
			case 656:
				return {{1000.0000000, -368.3509521}};
			case 657:
				return {{1000.0000000, -368.3508301}};
			case 658:
				return {{1000.0000000, -368.3509521}};
			case 659:
				return {{1000.0000000, -368.3509521}};
			case 660:
				return {{1000.0000000, -368.3508301}};
			case 661:
				return {{1000.0000000, -368.3508301}};
			case 662:
				return {{1000.0000000, -368.3509521}};
			case 663:
				return {{1000.0000000, -368.3508301}};
			case 664:
				return {{1000.0000000, -368.3508301}};
			case 665:
				return {{1000.0000000, -368.3508301}};
			case 666:
				return {{1000.0000000, -368.3508301}};
			case 667:
				return {{1000.0000000, -368.3508301}};
			case 668:
				return {{1000.0000000, -368.3508301}};
			case 669:
				return {{1000.0000000, -368.3508301}};
			case 670:
				return {{1000.0000000, -368.3509521}};
			case 671:
				return {{1000.0000000, -368.3508301}};
			case 672:
				return {{1000.0000000, -368.3508301}};
			case 673:
				return {{1000.0000000, -368.3507080}};
			case 674:
				return {{1000.0000000, -368.3507080}};
			case 675:
				return {{1000.0000000, -368.3507080}};
			case 676:
				return {{1000.0000000, -368.3508301}};
			case 677:
				return {{1000.0000000, -368.3507080}};
			case 678:
				return {{1000.0000000, -368.3507080}};
			case 679:
				return {{1000.0000000, -368.3508301}};
			case 680:
				return {{1000.0000000, -368.3508301}};
			case 681:
				return {{1000.0000000, -368.3507080}};
			case 682:
				return {{1000.0000000, -368.3507080}};
			case 683:
				return {{1000.0000000, -368.3508301}};
			case 684:
				return {{1000.0000000, -368.3507080}};
			case 685:
				return {{1000.0000000, -368.3508301}};
			case 686:
				return {{1000.0000000, -368.3508301}};
			case 687:
				return {{1000.0000000, -368.3508301}};
			case 688:
				return {{1000.0000000, -368.3509521}};
			case 689:
				return {{1000.0000000, -368.3510742}};
			case 690:
				return {{1000.0000000, -368.3509521}};
			case 691:
				return {{1000.0000000, -368.3509521}};
			case 692:
				return {{1000.0000000, -368.3509521}};
			case 693:
				return {{1000.0000000, -368.3509521}};
			case 694:
				return {{1000.0000000, -368.3509521}};
			case 695:
				return {{1000.0000000, -368.3509521}};
			case 696:
				return {{1000.0000000, -368.3509521}};
			case 697:
				return {{1000.0000000, -368.3509521}};
			case 698:
				return {{1000.0000000, -368.3509521}};
			case 699:
				return {{1000.0000000, -368.3509521}};
			case 700:
				return {{1000.0000000, -368.3508301}};
			case 701:
				return {{1000.0000000, -368.3508301}};
			case 702:
				return {{1000.0000000, -368.3508301}};
			case 703:
				return {{1000.0000000, -368.3508301}};
			case 704:
				return {{1000.0000000, -368.3508301}};
			case 705:
				return {{1000.0000000, -368.3508301}};
			case 706:
				return {{1000.0000000, -368.3508301}};
			case 707:
				return {{1000.0000000, -368.3508301}};
			case 708:
				return {{1000.0000000, -368.3509521}};
			case 709:
				return {{1000.0000000, -368.3509521}};
			case 710:
				return {{1000.0000000, -368.3509521}};
			case 711:
				return {{1000.0000000, -368.3509521}};
			case 712:
				return {{1000.0000000, -368.3509521}};
			case 713:
				return {{1000.0000000, -368.3509521}};
			case 714:
				return {{1000.0000000, -368.3509521}};
			case 715:
				return {{1000.0000000, -368.3509521}};
			case 716:
				return {{1000.0000000, -368.3509521}};
			case 717:
				return {{1000.0000000, -368.3509521}};
			case 718:
				return {{1000.0000000, -368.3509521}};
			case 719:
				return {{1000.0000000, -368.3509521}};
			case 720:
				return {{1000.0000000, -368.3509521}};
			case 721:
				return {{1000.0000000, -368.3509521}};
			case 722:
				return {{1000.0000000, -368.3509521}};
			case 723:
				return {{1000.0000000, -368.3509521}};
			case 724:
				return {{1000.0000000, -368.3509521}};
			case 725:
				return {{1000.0000000, -368.3509521}};
			case 726:
				return {{1000.0000000, -368.3509521}};
			case 727:
				return {{1000.0000000, -368.3509521}};
			case 728:
				return {{1000.0000000, -368.3509521}};
			case 729:
				return {{1000.0000000, -368.3509521}};
			case 730:
				return {{1000.0000000, -368.3509521}};
			case 731:
				return {{1000.0000000, -368.3509521}};
			case 732:
				return {{1000.0000000, -368.3509521}};
			case 733:
				return {{1000.0000000, -368.3509521}};
			case 734:
				return {{1000.0000000, -368.3509521}};
			case 735:
				return {{1000.0000000, -368.3509521}};
			case 736:
				return {{1000.0000000, -368.3509521}};
			case 737:
				return {{1000.0000000, -368.3509521}};
			case 738:
				return {{1000.0000000, -368.3509521}};
			case 739:
				return {{1000.0000000, -368.3509521}};
			case 740:
				return {{1000.0000000, -368.3509521}};
			case 741:
				return {{1000.0000000, -368.3509521}};
			case 742:
				return {{1000.0000000, -368.3509521}};
			case 743:
				return {{1000.0000000, -368.3509521}};
			case 744:
				return {{1000.0000000, -368.3509521}};
			case 745:
				return {{1000.0000000, -368.3509521}};
			case 746:
				return {{1000.0000000, -368.3509521}};
			case 747:
				return {{1000.0000000, -368.3509521}};
			case 748:
				return {{1000.0000000, -368.3509521}};
			case 749:
				return {{1000.0000000, -368.3509521}};
			case 750:
				return {{1000.0000000, -368.3509521}};
			case 751:
				return {{1000.0000000, -368.3509521}};
			case 752:
				return {{1000.0000000, -368.3509521}};
			case 753:
				return {{1000.0000000, -368.3509521}};
			case 754:
				return {{1000.0000000, -368.3509521}};
			case 755:
				return {{1000.0000000, -368.3509521}};
			case 756:
				return {{1000.0000000, -368.3509521}};
			case 757:
				return {{1000.0000000, -368.3509521}};
			case 758:
				return {{1000.0000000, -368.3509521}};
			case 759:
				return {{1000.0000000, -368.3509521}};
			case 760:
				return {{1000.0000000, -368.3509521}};
			case 761:
				return {{1000.0000000, -368.3509521}};
			case 762:
				return {{1000.0000000, -368.3509521}};
			case 763:
				return {{1000.0000000, -368.3509521}};
			case 764:
				return {{1000.0000000, -368.3509521}};
			case 765:
				return {{1000.0000000, -368.3509521}};
			case 766:
				return {{1000.0000000, -368.3509521}};
			case 767:
				return {{1000.0000000, -368.3509521}};
			case 768:
				return {{1000.0000000, -368.3509521}};
			case 769:
				return {{1000.0000000, -368.3509521}};
			case 770:
				return {{1000.0000000, -368.3509521}};
			case 771:
				return {{1000.0000000, -368.3509521}};
			case 772:
				return {{1000.0000000, -368.3509521}};
			case 773:
				return {{1000.0000000, -368.3509521}};
			case 774:
				return {{1000.0000000, -368.3509521}};
			case 775:
				return {{1000.0000000, -368.3509521}};
			case 776:
				return {{1000.0000000, -368.3509521}};
			case 777:
				return {{1000.0000000, -368.3509521}};
			case 778:
				return {{1000.0000000, -368.3509521}};
			case 779:
				return {{1000.0000000, -368.3509521}};
			case 780:
				return {{1000.0000000, -368.3509521}};
			case 781:
				return {{1000.0000000, -368.3509521}};
			case 782:
				return {{1000.0000000, -368.3509521}};
			case 783:
				return {{1000.0000000, -368.3509521}};
			case 784:
				return {{1000.0000000, -368.3509521}};
			case 785:
				return {{1000.0000000, -368.3509521}};
			case 786:
				return {{1000.0000000, -368.3509521}};
			case 787:
				return {{1000.0000000, -368.3509521}};
			case 788:
				return {{1000.0000000, -368.3509521}};
			case 789:
				return {{1000.0000000, -368.3509521}};
			case 790:
				return {{1000.0000000, -368.3509521}};
			case 791:
				return {{1000.0000000, -368.3509521}};
			case 792:
				return {{1000.0000000, -368.3509521}};
			case 793:
				return {{1000.0000000, -368.3509521}};
			case 794:
				return {{1000.0000000, -368.3509521}};
			case 795:
				return {{1000.0000000, -368.3509521}};
			case 796:
				return {{1000.0000000, -368.3509521}};
			case 797:
				return {{1000.0000000, -368.3509521}};
			case 798:
				return {{1000.0000000, -368.3509521}};
			case 799:
				return {{1000.0000000, -368.3509521}};
			case 800:
				return {{1000.0000000, -368.3509521}};
			case 801:
				return {{1000.0000000, -368.3509521}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[9])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 9.0254517f}};
			case 202:
				return {{1000.0000000f, 1075.0816650f}};
			case 301:
				return {{1000.0000000f, 1099.3552246}};
			case 502:
				return {{1000.0000000f, 1104.2067871}};
			case 601:
				return {{1000.0000000f, 1085.0701904}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[10])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 3.4066925f}};
			case 202:
				return {{1000.0000000f, 1097.5006104f}};
			case 301:
				return {{1000.0000000f, 1122.1517334}};
			case 502:
				return {{1000.0000000f, 1127.0755615}};
			case 601:
				return {{1000.0000000f, 1107.6390381}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[11])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -0.9229774f}};
			case 202:
				return {{1000.0000000f, 1104.8607178f}};
			case 301:
				return {{1000.0000000f, 1129.6359863}};
			case 502:
				return {{1000.0000000f, 1134.5833740}};
			case 601:
				return {{1000.0000000f, 1115.0499268}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[12])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -4.5307636f}};
			case 202:
				return {{1000.0000000f, 1108.6668701f}};
			case 301:
				return {{1000.0000000f, 1133.5073242}};
			case 502:
				return {{1000.0000000f, 1138.4648438}};
			case 601:
				return {{1000.0000000f, 1118.8843994}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[13])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -7.4373074f}};
			case 202:
				return {{1000.0000000f, 1110.8963623}};
			case 301:
				return {{1000.0000000f, 1135.7751465}};
			case 502:
				return {{1000.0000000f, 1140.7402344}};
			case 601:
				return {{1000.0000000f, 1121.1271973}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[14])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -9.9486294f}};
			case 202:
				return {{1000.0000000f, 1112.4274902}};
			case 301:
				return {{1000.0000000f, 1137.3316650}};
			case 502:
				return {{1000.0000000f, 1142.3015137}};
			case 601:
				return {{1000.0000000f, 1122.6687012}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[15])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -12.0339508f}};
			case 202:
				return {{1000.0000000f, 1113.4934082}};
			case 301:
				return {{1000.0000000f, 1138.4149170}};
			case 502:
				return {{1000.0000000f, 1143.3887939}};
			case 601:
				return {{1000.0000000f, 1123.7420654}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_MockMousePos)
		{
			switch (frameNumber)
			{
			case 0:
				return {{15.8141842, -13.4212151}};
			case 1:
				return {{998.6565552, 1118.0327148}};
			case 2:
				return {{998.6566772, 1118.0330811}};
			case 3:
				return {{998.6575928, 1118.0344238}};
			case 4:
				return {{998.6578369, 1118.0350342}};
			case 5:
				return {{998.6578979, 1118.0350342}};
			case 6:
				return {{998.6578979, 1118.0351562}};
			case 7:
				return {{998.6581421, 1118.0354004}};
			case 8:
				return {{998.6581421, 1118.0354004}};
			case 9:
				return {{998.6583862, 1118.0360107}};
			case 10:
				return {{998.6583862, 1118.0361328}};
			case 11:
				return {{998.6583862, 1118.0361328}};
			case 12:
				return {{998.6585083, 1118.0363770}};
			case 13:
				return {{998.6585083, 1118.0363770}};
			case 14:
				return {{998.6585083, 1118.0363770}};
			case 15:
				return {{998.6585083, 1118.0363770}};
			case 16:
				return {{998.6586914, 1118.0366211}};
			case 17:
				return {{998.6586914, 1118.0366211}};
			case 18:
				return {{998.6588135, 1118.0368652}};
			case 19:
				return {{998.6589355, 1118.0369873}};
			case 20:
				return {{998.6591187, 1118.0371094}};
			case 21:
				return {{998.6591187, 1118.0371094}};
			case 22:
				return {{998.6591187, 1118.0375977}};
			case 23:
				return {{998.6591187, 1118.0375977}};
			case 24:
				return {{998.6593018, 1118.0377197}};
			case 25:
				return {{998.6593018, 1118.0377197}};
			case 26:
				return {{998.6593628, 1118.0378418}};
			case 27:
				return {{998.6593628, 1118.0378418}};
			case 28:
				return {{998.6593628, 1118.0378418}};
			case 29:
				return {{998.6594238, 1118.0379639}};
			case 30:
				return {{998.6594238, 1118.0380859}};
			case 31:
				return {{998.6594238, 1118.0380859}};
			case 32:
				return {{998.6595459, 1118.0380859}};
			case 33:
				return {{998.6595459, 1118.0380859}};
			case 34:
				return {{998.6596069, 1118.0382080}};
			case 35:
				return {{998.6596069, 1118.0382080}};
			case 36:
				return {{998.6596680, 1118.0382080}};
			case 37:
				return {{998.6596680, 1118.0382080}};
			case 38:
				return {{998.6596680, 1118.0382080}};
			case 39:
				return {{998.6050415, 1117.9583740}};
			case 40:
				return {{998.6004639, 1117.9519043}};
			case 41:
				return {{998.5250854, 1117.8411865}};
			case 42:
				return {{998.5202026, 1117.8342285}};
			case 43:
				return {{998.4447632, 1117.7239990}};
			case 44:
				return {{998.3740845, 1117.6204834}};
			case 45:
				return {{998.2989502, 1117.5107422}};
			case 46:
				return {{998.2943726, 1117.5034180}};
			case 47:
				return {{998.2241821, 1117.4010010}};
			case 48:
				return {{998.2192993, 1117.3937988}};
			case 49:
				return {{998.1444702, 1117.2852783}};
			case 50:
				return {{998.1400146, 1117.2783203}};
			case 51:
				return {{998.0661011, 1117.1699219}};
			case 52:
				return {{998.0614624, 1117.1633301}};
			case 53:
				return {{997.9931030, 1117.0632324}};
			case 54:
				return {{997.9883423, 1117.0559082}};
			case 55:
				return {{997.9157104, 1116.9499512}};
			case 56:
				return {{997.9113770, 1116.9432373}};
			case 57:
				return {{997.8395996, 1116.8388672}};
			case 58:
				return {{997.8350830, 1116.8316650}};
			case 59:
				return {{997.7686157, 1116.7346191}};
			case 60:
				return {{997.7645264, 1116.7280273}};
			case 61:
				return {{997.6946411, 1116.6263428}};
			case 62:
				return {{997.6901855, 1116.6201172}};
			case 63:
				return {{997.6260376, 1116.5261230}};
			case 64:
				return {{997.6213379, 1116.5197754}};
			case 65:
				return {{997.5543213, 1116.4202881}};
			case 66:
				return {{997.4876709, 1116.3229980}};
			case 67:
				return {{997.4268799, 1116.2340088}};
			case 68:
				return {{997.4226074, 1116.2282715}};
			case 69:
				return {{997.3584595, 1116.1345215}};
			case 70:
				return {{997.3546753, 1116.1284180}};
			case 71:
				return {{997.2918701, 1116.0371094}};
			case 72:
				return {{997.2882690, 1116.0312500}};
			case 73:
				return {{997.2311401, 1115.9484863}};
			case 74:
				return {{997.2274780, 1115.9427490}};
			case 75:
				return {{997.2233887, 1115.9372559}};
			case 76:
				return {{997.1643066, 1115.8500977}};
			case 77:
				return {{997.1604004, 1115.8443604}};
			case 78:
				return {{997.1060791, 1115.7656250}};
			case 79:
				return {{997.1025391, 1115.7595215}};
			case 80:
				return {{997.0460205, 1115.6776123}};
			case 81:
				return {{997.0431519, 1115.6727295}};
			case 82:
				return {{996.9878540, 1115.5917969}};
			case 83:
				return {{996.9848022, 1115.5877686}};
			case 84:
				return {{996.9347534, 1115.5148926}};
			case 85:
				return {{996.9316406, 1115.5096436}};
			case 86:
				return {{996.8798828, 1115.4344482}};
			case 87:
				return {{996.8767700, 1115.4294434}};
			case 88:
				return {{996.8270874, 1115.3565674}};
			case 89:
				return {{996.8242188, 1115.3520508}};
			case 90:
				return {{996.7781982, 1115.2857666}};
			case 91:
				return {{996.7322388, 1115.2180176}};
			case 92:
				return {{996.6903687, 1115.1567383}};
			case 93:
				return {{996.6872559, 1115.1528320}};
			case 94:
				return {{996.6439209, 1115.0891113}};
			case 95:
				return {{996.6413574, 1115.0844727}};
			case 96:
				return {{996.5997314, 1115.0242920}};
			case 97:
				return {{996.5974121, 1115.0205078}};
			case 98:
				return {{996.5593872, 1114.9663086}};
			case 99:
				return {{996.5569458, 1114.9620361}};
			case 100:
				return {{996.5190430, 1114.9064941}};
			case 101:
				return {{996.5166626, 1114.9024658}};
			case 102:
				return {{996.4803467, 1114.8493652}};
			case 103:
				return {{996.4471436, 1114.8009033}};
			case 104:
				return {{996.4453735, 1114.7979736}};
			case 105:
				return {{996.4117432, 1114.7495117}};
			case 106:
				return {{996.4096069, 1114.7465820}};
			case 107:
				return {{996.4075928, 1114.7440186}};
			case 108:
				return {{996.3780518, 1114.7004395}};
			case 109:
				return {{996.3764648, 1114.6977539}};
			case 110:
				return {{996.3460693, 1114.6536865}};
			case 111:
				return {{996.3442383, 1114.6506348}};
			case 112:
				return {{996.3157959, 1114.6094971}};
			case 113:
				return {{996.3142090, 1114.6070557}};
			case 114:
				return {{996.2634277, 1114.5322266}};
			case 115:
				return {{996.2390137, 1114.4976807}};
			case 116:
				return {{996.2378540, 1114.4953613}};
			case 117:
				return {{996.2164307, 1114.4639893}};
			case 118:
				return {{996.2153320, 1114.4620361}};
			case 119:
				return {{996.1939087, 1114.4304199}};
			case 120:
				return {{996.1929932, 1114.4294434}};
			case 121:
				return {{996.1745605, 1114.4014893}};
			case 122:
				return {{996.1728516, 1114.3999023}};
			case 123:
				return {{996.1718140, 1114.3980713}};
			case 124:
				return {{996.1535034, 1114.3715820}};
			case 125:
				return {{996.1361694, 1114.3464355}};
			case 126:
				return {{996.1347656, 1114.3447266}};
			case 127:
				return {{996.1205444, 1114.3227539}};
			case 128:
				return {{996.1194458, 1114.3221436}};
			case 129:
				return {{996.1185303, 1114.3204346}};
			case 130:
				return {{996.1038818, 1114.2991943}};
			case 131:
				return {{996.0902100, 1114.2783203}};
			case 132:
				return {{996.0897217, 1114.2772217}};
			case 133:
				return {{996.0779419, 1114.2603760}};
			case 134:
				return {{996.0769653, 1114.2600098}};
			case 135:
				return {{996.0654297, 1114.2429199}};
			case 136:
				return {{996.0649414, 1114.2418213}};
			case 137:
				return {{996.0555420, 1114.2282715}};
			case 138:
				return {{996.0457764, 1114.2138672}};
			case 139:
				return {{996.0378418, 1114.2017822}};
			case 140:
				return {{996.0368652, 1114.2006836}};
			case 141:
				return {{996.0293579, 1114.1906738}};
			case 142:
				return {{996.0292969, 1114.1895752}};
			case 143:
				return {{996.0226440, 1114.1788330}};
			case 144:
				return {{996.0218506, 1114.1791992}};
			case 145:
				return {{996.0155640, 1114.1700439}};
			case 146:
				return {{996.0155029, 1114.1693115}};
			case 147:
				return {{996.0106812, 1114.1623535}};
			case 148:
				return {{996.0104370, 1114.1616211}};
			case 149:
				return {{996.0059204, 1114.1550293}};
			case 150:
				return {{996.0051270, 1114.1542969}};
			case 151:
				return {{996.0014648, 1114.1489258}};
			case 152:
				return {{996.0012817, 1114.1485596}};
			case 153:
				return {{995.9979248, 1114.1435547}};
			case 154:
				return {{995.9971924, 1114.1424561}};
			case 155:
				return {{995.9947510, 1114.1383057}};
			case 156:
				return {{995.9942017, 1114.1379395}};
			case 157:
				return {{995.9913330, 1114.1345215}};
			case 158:
				return {{995.9914551, 1114.1347656}};
			case 159:
				return {{995.9893799, 1114.1317139}};
			case 160:
				return {{995.9888916, 1114.1317139}};
			case 161:
				return {{995.9858398, 1114.1260986}};
			case 162:
				return {{995.9853516, 1114.1248779}};
			case 163:
				return {{995.9848633, 1114.1246338}};
			case 164:
				return {{995.9840088, 1114.1234131}};
			case 165:
				return {{995.9839478, 1114.1235352}};
			case 166:
				return {{995.9832764, 1114.1224365}};
			case 167:
				return {{995.9831543, 1114.1213379}};
			case 168:
				return {{995.9825439, 1114.1206055}};
			case 169:
				return {{995.9827881, 1114.1210938}};
			case 170:
				return {{995.9824219, 1114.1206055}};
			case 171:
				return {{995.9821167, 1114.1203613}};
			case 172:
				return {{995.9817505, 1114.1198730}};
			case 173:
				return {{995.9819336, 1114.1199951}};
			case 174:
				return {{995.9816895, 1114.1196289}};
			case 175:
				return {{995.9813232, 1114.1198730}};
			case 176:
				return {{995.9811401, 1114.1196289}};
			case 177:
				return {{995.9811401, 1114.1197510}};
			case 178:
				return {{995.9810791, 1114.1196289}};
			case 179:
				return {{995.9812012, 1114.1191406}};
			case 180:
				return {{995.9811401, 1114.1190186}};
			case 181:
				return {{995.9811401, 1114.1191406}};
			case 182:
				return {{995.9811401, 1114.1190186}};
			case 183:
				return {{995.9811401, 1114.1190186}};
			case 184:
				return {{995.9811401, 1114.1191406}};
			case 185:
				return {{995.9811401, 1114.1191406}};
			case 186:
				return {{995.9811401, 1114.1191406}};
			case 187:
				return {{995.9811401, 1114.1191406}};
			case 188:
				return {{995.9811401, 1114.1191406}};
			case 189:
				return {{995.9811401, 1114.1191406}};
			case 190:
				return {{995.9812012, 1114.1191406}};
			case 191:
				return {{995.9811401, 1114.1191406}};
			case 192:
				return {{995.9812012, 1114.1191406}};
			case 193:
				return {{995.9812012, 1114.1191406}};
			case 194:
				return {{995.9812012, 1114.1191406}};
			case 195:
				return {{995.9812012, 1114.1191406}};
			case 196:
				return {{995.9812012, 1114.1191406}};
			case 197:
				return {{995.9811401, 1114.1197510}};
			case 198:
				return {{995.9811401, 1114.1197510}};
			case 199:
				return {{995.9811401, 1114.1197510}};
			case 200:
				return {{995.9811401, 1114.1197510}};
			case 201:
				return {{995.9811401, 1114.1197510}};
			case 202:
				return {{995.9812012, 1114.1197510}};
			case 203:
				return {{995.9811401, 1114.1197510}};
			case 204:
				return {{995.9811401, 1114.1306152}};
			case 205:
				return {{995.9811401, 1114.1323242}};
			case 206:
				return {{995.9808960, 1114.2296143}};
			case 207:
				return {{995.9808960, 1114.3198242}};
			case 208:
				return {{995.9810791, 1114.3269043}};
			case 209:
				return {{995.9809570, 1114.3345947}};
			case 210:
				return {{995.9805908, 1114.4840088}};
			case 211:
				return {{995.9808350, 1114.4945068}};
			case 212:
				return {{995.9802856, 1114.6933594}};
			case 213:
				return {{995.9795532, 1114.7067871}};
			case 214:
				return {{995.9789429, 1114.9364014}};
			case 215:
				return {{995.9786987, 1114.9534912}};
			case 216:
				return {{995.9779053, 1115.2421875}};
			case 217:
				return {{995.9782715, 1115.2611084}};
			case 218:
				return {{995.9774780, 1115.5913086}};
			case 219:
				return {{995.9774170, 1115.6132812}};
			case 220:
				return {{995.9765625, 1115.9566650}};
			case 221:
				return {{995.9765015, 1115.9807129}};
			case 222:
				return {{995.9754028, 1116.3809814}};
			case 223:
				return {{995.9748535, 1116.4067383}};
			case 224:
				return {{995.9738770, 1116.8081055}};
			case 225:
				return {{995.9743652, 1116.8360596}};
			case 226:
				return {{995.9732056, 1117.2901611}};
			case 227:
				return {{995.9727783, 1117.3186035}};
			case 228:
				return {{995.9715576, 1117.7951660}};
			case 229:
				return {{995.9716187, 1117.8255615}};
			case 230:
				return {{995.9689941, 1118.7954102}};
			case 231:
				return {{995.9670410, 1119.3104248}};
			case 232:
				return {{995.9677124, 1119.3435059}};
			case 233:
				return {{995.9671021, 1119.3759766}};
			case 234:
				return {{995.9658203, 1119.8736572}};
			case 235:
				return {{995.9645996, 1120.4145508}};
			case 236:
				return {{995.9643555, 1120.4481201}};
			case 237:
				return {{995.9624634, 1120.9636230}};
			case 238:
				return {{995.9631348, 1120.9984131}};
			case 239:
				return {{995.9610596, 1121.5559082}};
			case 240:
				return {{995.9613037, 1121.5909424}};
			case 241:
				return {{995.9598389, 1122.1535645}};
			case 242:
				return {{995.9595337, 1122.1896973}};
			case 243:
				return {{995.9577026, 1122.7207031}};
			case 244:
				return {{995.9578857, 1122.7564697}};
			case 245:
				return {{995.9564209, 1123.3278809}};
			case 246:
				return {{995.9565430, 1123.3629150}};
			case 247:
				return {{995.9551392, 1123.9362793}};
			case 248:
				return {{995.9548950, 1123.9729004}};
			case 249:
				return {{995.9534912, 1124.5122070}};
			case 250:
				return {{995.9530640, 1124.5478516}};
			case 251:
				return {{995.9515381, 1125.1239014}};
			case 252:
				return {{995.9518433, 1125.1606445}};
			case 253:
				return {{995.9512329, 1125.1962891}};
			case 254:
				return {{995.9482422, 1126.3103027}};
			case 255:
				return {{995.9467773, 1126.8800049}};
			case 256:
				return {{995.9466553, 1126.9163818}};
			case 257:
				return {{995.9456787, 1127.4532471}};
			case 258:
				return {{995.9448853, 1127.4886475}};
			case 259:
				return {{995.9448242, 1127.5246582}};
			case 260:
				return {{995.9433594, 1128.0992432}};
			case 261:
				return {{995.9436035, 1128.1358643}};
			case 262:
				return {{995.9420776, 1128.7120361}};
			case 263:
				return {{995.9423828, 1128.7478027}};
			case 264:
				return {{995.9403076, 1129.2882080}};
			case 265:
				return {{995.9386597, 1129.8662109}};
			case 266:
				return {{995.9382324, 1129.9017334}};
			case 267:
				return {{995.9368896, 1130.4432373}};
			case 268:
				return {{995.9370117, 1130.4796143}};
			case 269:
				return {{995.9356079, 1131.0568848}};
			case 270:
				return {{995.9353638, 1131.0931396}};
			case 271:
				return {{995.9338379, 1131.6707764}};
			case 272:
				return {{995.9335938, 1131.7064209}};
			case 273:
				return {{995.9321289, 1132.2476807}};
			case 274:
				return {{995.9323730, 1132.2844238}};
			case 275:
				return {{995.9323120, 1132.3201904}};
			case 276:
				return {{995.9307861, 1132.8977051}};
			case 277:
				return {{995.9300537, 1132.9337158}};
			case 278:
				return {{995.9299316, 1132.9692383}};
			case 279:
				return {{995.9284668, 1133.5465088}};
			case 280:
				return {{995.9273682, 1134.0867920}};
			case 281:
				return {{995.9261475, 1134.6629639}};
			case 282:
				return {{995.9252930, 1134.6987305}};
			case 283:
				return {{995.9252930, 1134.7352295}};
			case 284:
				return {{995.9239502, 1135.2750244}};
			case 285:
				return {{995.9240112, 1135.3111572}};
			case 286:
				return {{995.9240112, 1135.3477783}};
			case 287:
				return {{995.9225464, 1135.9238281}};
			case 288:
				return {{995.9221802, 1135.9594727}};
			case 289:
				return {{995.9221802, 1135.9951172}};
			case 290:
				return {{995.9206543, 1136.5710449}};
			case 291:
				return {{995.9204102, 1136.6065674}};
			case 292:
				return {{995.9204102, 1136.6427002}};
			case 293:
				return {{995.9190674, 1137.1828613}};
			case 294:
				return {{995.9191284, 1137.2183838}};
			case 295:
				return {{995.9176636, 1137.7944336}};
			case 296:
				return {{995.9173584, 1137.8293457}};
			case 297:
				return {{995.9173584, 1137.8652344}};
			case 298:
				return {{995.9157715, 1138.4404297}};
			case 299:
				return {{995.9149780, 1138.4760742}};
			case 300:
				return {{995.9150391, 1138.5119629}};
			case 301:
				return {{995.9136353, 1139.0511475}};
			case 302:
				return {{995.9137573, 1139.0876465}};
			case 303:
				return {{995.9123535, 1139.6519775}};
			case 304:
				return {{995.9125366, 1139.6867676}};
			case 305:
				return {{995.9124146, 1139.7209473}};
			case 306:
				return {{995.9111328, 1140.2250977}};
			case 307:
				return {{995.9103394, 1140.2574463}};
			case 308:
				return {{995.9090576, 1140.7592773}};
			case 309:
				return {{995.9079590, 1141.2191162}};
			case 310:
				return {{995.9079590, 1141.2470703}};
			case 311:
				return {{995.9070435, 1141.6374512}};
			case 312:
				return {{995.9069824, 1141.6618652}};
			case 313:
				return {{995.9069824, 1141.6865234}};
			case 314:
				return {{995.9060669, 1142.0546875}};
			case 315:
				return {{995.9055176, 1142.0766602}};
			case 316:
				return {{995.9055176, 1142.0981445}};
			case 317:
				return {{995.9046021, 1142.4184570}};
			case 318:
				return {{995.9046021, 1142.4371338}};
			case 319:
				return {{995.9039307, 1142.6978760}};
			case 320:
				return {{995.9042358, 1142.7141113}};
			case 321:
				return {{995.9041748, 1142.7296143}};
			case 322:
				return {{995.9036255, 1142.9677734}};
			case 323:
				return {{995.9033813, 1142.9810791}};
			case 324:
				return {{995.9033813, 1142.9945068}};
			case 325:
				return {{995.9029541, 1143.1823730}};
			case 326:
				return {{995.9026489, 1143.1944580}};
			case 327:
				return {{995.9025879, 1143.2059326}};
			case 328:
				return {{995.9020996, 1143.3732910}};
			case 329:
				return {{995.9023438, 1143.3819580}};
			case 330:
				return {{995.9023438, 1143.3919678}};
			case 331:
				return {{995.9020386, 1143.5292969}};
			case 332:
				return {{995.9021606, 1143.5371094}};
			case 333:
				return {{995.9021606, 1143.5447998}};
			case 334:
				return {{995.9019775, 1143.6497803}};
			case 335:
				return {{995.9010010, 1143.6568604}};
			case 336:
				return {{995.9010010, 1143.6632080}};
			case 337:
				return {{995.9008179, 1143.7531738}};
			case 338:
				return {{995.9009399, 1143.7578125}};
			case 339:
				return {{995.9009399, 1143.7628174}};
			case 340:
				return {{995.9007568, 1143.8344727}};
			case 341:
				return {{995.9008179, 1143.8386230}};
			case 342:
				return {{995.9007568, 1143.8920898}};
			case 343:
				return {{995.9006348, 1143.9372559}};
			case 344:
				return {{995.9001465, 1143.9714355}};
			case 345:
				return {{995.9001465, 1143.9735107}};
			case 346:
				return {{995.9001465, 1143.9753418}};
			case 347:
				return {{995.9000244, 1144.0021973}};
			case 348:
				return {{995.9001465, 1144.0031738}};
			case 349:
				return {{995.9000244, 1144.0234375}};
			case 350:
				return {{995.9001465, 1144.0245361}};
			case 351:
				return {{995.9000244, 1144.0256348}};
			case 352:
				return {{995.9000244, 1144.0385742}};
			case 353:
				return {{995.9000244, 1144.0393066}};
			case 354:
				return {{995.9000244, 1144.0489502}};
			case 355:
				return {{995.9000244, 1144.0489502}};
			case 356:
				return {{995.9000244, 1144.0499268}};
			case 357:
				return {{995.9000244, 1144.0559082}};
			case 358:
				return {{995.9001465, 1144.0550537}};
			case 359:
				return {{995.9001465, 1144.0582275}};
			case 360:
				return {{995.9000244, 1144.0583496}};
			case 361:
				return {{995.9000244, 1144.0589600}};
			case 362:
				return {{995.9000244, 1144.0598145}};
			case 363:
				return {{995.9000244, 1144.0598145}};
			case 364:
				return {{995.9000244, 1144.0598145}};
			case 365:
				return {{995.9000244, 1144.0598145}};
			case 366:
				return {{995.9000244, 1144.0595703}};
			case 367:
				return {{995.9000244, 1144.0595703}};
			case 368:
				return {{995.9001465, 1144.0583496}};
			case 369:
				return {{995.9001465, 1144.0582275}};
			case 370:
				return {{995.9001465, 1144.0563965}};
			case 371:
				return {{995.9001465, 1144.0562744}};
			case 372:
				return {{995.9001465, 1144.0561523}};
			case 373:
				return {{995.9001465, 1144.0540771}};
			case 374:
				return {{995.9001465, 1144.0516357}};
			case 375:
				return {{995.9001465, 1144.0491943}};
			case 376:
				return {{995.9000244, 1144.0501709}};
			case 377:
				return {{995.9000244, 1144.0495605}};
			case 378:
				return {{995.9000244, 1144.0477295}};
			case 379:
				return {{995.9000244, 1144.0471191}};
			case 380:
				return {{995.9000244, 1144.0474854}};
			case 381:
				return {{995.9000244, 1144.0446777}};
			case 382:
				return {{995.9000244, 1144.0450439}};
			case 383:
				return {{995.9000244, 1144.0449219}};
			case 384:
				return {{995.9000244, 1144.0428467}};
			case 385:
				return {{995.9000244, 1144.0422363}};
			case 386:
				return {{995.9000244, 1144.0426025}};
			case 387:
				return {{995.9001465, 1144.0406494}};
			case 388:
				return {{995.9000244, 1144.0405273}};
			case 389:
				return {{995.9001465, 1144.0388184}};
			case 390:
				return {{995.9000244, 1144.0385742}};
			case 391:
				return {{995.9000244, 1144.0379639}};
			case 392:
				return {{995.9001465, 1144.0369873}};
			case 393:
				return {{995.9000244, 1144.0368652}};
			case 394:
				return {{995.9001465, 1144.0367432}};
			case 395:
				return {{995.9001465, 1144.0354004}};
			case 396:
				return {{995.9000244, 1144.0351562}};
			case 397:
				return {{995.9001465, 1144.0350342}};
			case 398:
				return {{995.9001465, 1144.0339355}};
			case 399:
				return {{995.9000244, 1144.0336914}};
			case 400:
				return {{995.9001465, 1144.0327148}};
			case 401:
				return {{995.9001465, 1144.0327148}};
			case 402:
				return {{995.9001465, 1144.0327148}};
			case 403:
				return {{995.9000244, 1144.0318604}};
			case 404:
				return {{995.9000244, 1144.0318604}};
			case 405:
				return {{995.9000244, 1144.0318604}};
			case 406:
				return {{995.9001465, 1144.0306396}};
			case 407:
				return {{995.9000244, 1144.0300293}};
			case 408:
				return {{995.9001465, 1144.0300293}};
			case 409:
				return {{995.9001465, 1144.0300293}};
			case 410:
				return {{995.9001465, 1144.0300293}};
			case 411:
				return {{995.9000244, 1144.0296631}};
			case 412:
				return {{995.9000244, 1144.0296631}};
			case 413:
				return {{995.9000244, 1144.0296631}};
			case 414:
				return {{995.9000244, 1144.0288086}};
			case 415:
				return {{995.9000244, 1144.0288086}};
			case 416:
				return {{995.9000244, 1144.0288086}};
			case 417:
				return {{995.9001465, 1144.0290527}};
			case 418:
				return {{995.9001465, 1144.0290527}};
			case 419:
				return {{995.9001465, 1144.0290527}};
			case 420:
				return {{995.9001465, 1144.0288086}};
			case 421:
				return {{995.9001465, 1144.0288086}};
			case 422:
				return {{995.9001465, 1144.0281982}};
			case 423:
				return {{995.9001465, 1144.0281982}};
			case 424:
				return {{995.9001465, 1144.0281982}};
			case 425:
				return {{995.9001465, 1144.0285645}};
			case 426:
				return {{995.9001465, 1144.0285645}};
			case 427:
				return {{995.9001465, 1144.0285645}};
			case 428:
				return {{995.9000244, 1144.0284424}};
			case 429:
				return {{995.9000244, 1144.0284424}};
			case 430:
				return {{995.9000244, 1144.0284424}};
			case 431:
				return {{995.9001465, 1144.0284424}};
			case 432:
				return {{995.9001465, 1144.0284424}};
			case 433:
				return {{995.9001465, 1144.0284424}};
			case 434:
				return {{995.9001465, 1144.0284424}};
			case 435:
				return {{995.9001465, 1144.0284424}};
			case 436:
				return {{995.9001465, 1144.0284424}};
			case 437:
				return {{995.9001465, 1144.0284424}};
			case 438:
				return {{995.9001465, 1144.0284424}};
			case 439:
				return {{995.9001465, 1144.0284424}};
			case 440:
				return {{995.9001465, 1144.0284424}};
			case 441:
				return {{995.9001465, 1144.0284424}};
			case 442:
				return {{995.9001465, 1144.0284424}};
			case 443:
				return {{995.9001465, 1144.0284424}};
			case 444:
				return {{995.9001465, 1144.0284424}};
			case 445:
				return {{995.9001465, 1144.0284424}};
			case 446:
				return {{995.9001465, 1144.0284424}};
			case 447:
				return {{995.9001465, 1144.0284424}};
			case 448:
				return {{995.9001465, 1144.0284424}};
			case 449:
				return {{995.9001465, 1144.0284424}};
			case 450:
				return {{995.9001465, 1144.0284424}};
			case 451:
				return {{995.9001465, 1144.0284424}};
			case 452:
				return {{995.9001465, 1144.0284424}};
			case 453:
				return {{995.9001465, 1144.0284424}};
			case 454:
				return {{995.9001465, 1144.0284424}};
			case 455:
				return {{995.9001465, 1144.0284424}};
			case 456:
				return {{995.9001465, 1144.0284424}};
			case 457:
				return {{995.9001465, 1144.0284424}};
			case 458:
				return {{995.9001465, 1144.0284424}};
			case 459:
				return {{995.9001465, 1144.0284424}};
			case 460:
				return {{995.9001465, 1144.0284424}};
			case 461:
				return {{995.9001465, 1144.0284424}};
			case 462:
				return {{995.9001465, 1144.0284424}};
			case 463:
				return {{995.9001465, 1144.0284424}};
			case 464:
				return {{995.9001465, 1144.0284424}};
			case 465:
				return {{995.9001465, 1144.0284424}};
			case 466:
				return {{995.9001465, 1144.0284424}};
			case 467:
				return {{995.9001465, 1144.0284424}};
			case 468:
				return {{995.9001465, 1144.0284424}};
			case 469:
				return {{995.9001465, 1144.0284424}};
			case 470:
				return {{995.9001465, 1144.0284424}};
			case 471:
				return {{995.9001465, 1144.0284424}};
			case 472:
				return {{995.9001465, 1144.0284424}};
			case 473:
				return {{995.9001465, 1144.0284424}};
			case 474:
				return {{995.9001465, 1144.0284424}};
			case 475:
				return {{995.9001465, 1144.0284424}};
			case 476:
				return {{995.9001465, 1144.0284424}};
			case 477:
				return {{995.9001465, 1144.0284424}};
			case 478:
				return {{995.9001465, 1144.0284424}};
			case 479:
				return {{995.9001465, 1144.0284424}};
			case 480:
				return {{995.9001465, 1144.0284424}};
			case 481:
				return {{995.9001465, 1144.0284424}};
			case 482:
				return {{995.9001465, 1144.0284424}};
			case 483:
				return {{995.9001465, 1144.0284424}};
			case 484:
				return {{995.9001465, 1144.0284424}};
			case 485:
				return {{995.9001465, 1144.0284424}};
			case 486:
				return {{995.9001465, 1144.0284424}};
			case 487:
				return {{995.9001465, 1144.0284424}};
			case 488:
				return {{995.9001465, 1144.0284424}};
			case 489:
				return {{995.9001465, 1144.0284424}};
			case 490:
				return {{995.9001465, 1144.0284424}};
			case 491:
				return {{995.9001465, 1144.0284424}};
			case 492:
				return {{995.9001465, 1144.0284424}};
			case 493:
				return {{995.9001465, 1144.0284424}};
			case 494:
				return {{995.9001465, 1144.0284424}};
			case 495:
				return {{995.9001465, 1144.0284424}};
			case 496:
				return {{995.9001465, 1144.0284424}};
			case 497:
				return {{995.9001465, 1144.0284424}};
			case 498:
				return {{995.9001465, 1144.0284424}};
			case 499:
				return {{995.9001465, 1144.0284424}};
			case 500:
				return {{995.9001465, 1144.0284424}};
			case 501:
				return {{995.9001465, 1144.0284424}};
			case 502:
				return {{995.9001465, 1144.0284424}};
			case 503:
				return {{995.9001465, 1144.0278320}};
			case 504:
				return {{995.9002075, 1143.9945068}};
			case 505:
				return {{995.9001465, 1143.9924316}};
			case 506:
				return {{995.9001465, 1143.9902344}};
			case 507:
				return {{995.9001465, 1143.9877930}};
			case 508:
				return {{995.9002686, 1143.9261475}};
			case 509:
				return {{995.9002075, 1143.9204102}};
			case 510:
				return {{995.9005127, 1143.8125000}};
			case 511:
				return {{995.9008789, 1143.8039551}};
			case 512:
				return {{995.9012451, 1143.6577148}};
			case 513:
				return {{995.9010010, 1143.6473389}};
			case 514:
				return {{995.9011230, 1143.6354980}};
			case 515:
				return {{995.9016113, 1143.6240234}};
			case 516:
				return {{995.9027100, 1143.4141846}};
			case 517:
				return {{995.9023438, 1143.3997803}};
			case 518:
				return {{995.9030151, 1143.1433105}};
			case 519:
				return {{995.9027710, 1143.1259766}};
			case 520:
				return {{995.9027710, 1143.1083984}};
			case 521:
				return {{995.9034424, 1142.8258057}};
			case 522:
				return {{995.9036255, 1142.8054199}};
			case 523:
				return {{995.9042358, 1142.7857666}};
			case 524:
				return {{995.9051514, 1142.4422607}};
			case 525:
				return {{995.9046631, 1142.4200439}};
			case 526:
				return {{995.9046631, 1142.3972168}};
			case 527:
				return {{995.9056396, 1142.0407715}};
			case 528:
				return {{995.9057007, 1142.0158691}};
			case 529:
				return {{995.9057007, 1141.9914551}};
			case 530:
				return {{995.9067383, 1141.5781250}};
			case 531:
				return {{995.9072266, 1141.5511475}};
			case 532:
				return {{995.9072876, 1141.5242920}};
			case 533:
				return {{995.9083252, 1141.0820312}};
			case 534:
				return {{995.9083252, 1141.0532227}};
			case 535:
				return {{995.9084473, 1141.0246582}};
			case 536:
				return {{995.9113159, 1140.1060791}};
			case 537:
				return {{995.9106445, 1140.0747070}};
			case 538:
				return {{995.9118652, 1139.5789795}};
			case 539:
				return {{995.9127808, 1139.5473633}};
			case 540:
				return {{995.9127808, 1139.5156250}};
			case 541:
				return {{995.9140015, 1139.0340576}};
			case 542:
				return {{995.9139404, 1139.0013428}};
			case 543:
				return {{995.9140015, 1138.9687500}};
			case 544:
				return {{995.9154053, 1138.4392090}};
			case 545:
				return {{995.9152832, 1138.4055176}};
			case 546:
				return {{995.9152222, 1138.3719482}};
			case 547:
				return {{995.9171143, 1137.8653564}};
			case 548:
				return {{995.9173584, 1137.8317871}};
			case 549:
				return {{995.9176025, 1137.7976074}};
			case 550:
				return {{995.9189453, 1137.2469482}};
			case 551:
				return {{995.9192505, 1137.2128906}};
			case 552:
				return {{995.9207153, 1136.6553955}};
			case 553:
				return {{995.9205322, 1136.6196289}};
			case 554:
				return {{995.9218750, 1136.0917969}};
			case 555:
				return {{995.9221802, 1136.0570068}};
			case 556:
				return {{995.9221802, 1136.0216064}};
			case 557:
				return {{995.9237061, 1135.4539795}};
			case 558:
				return {{995.9234619, 1135.4182129}};
			case 559:
				return {{995.9235229, 1135.3825684}};
			case 560:
				return {{995.9249268, 1134.8114014}};
			case 561:
				return {{995.9253540, 1134.7761230}};
			case 562:
				return {{995.9253540, 1134.7401123}};
			case 563:
				return {{995.9267578, 1134.2025146}};
			case 564:
				return {{995.9276123, 1134.1669922}};
			case 565:
				return {{995.9276733, 1134.1311035}};
			case 566:
				return {{995.9291992, 1133.5555420}};
			case 567:
				return {{995.9288940, 1133.5191650}};
			case 568:
				return {{995.9302979, 1132.9787598}};
			case 569:
				return {{995.9316406, 1132.4024658}};
			case 570:
				return {{995.9332886, 1131.8254395}};
			case 571:
				return {{995.9335938, 1131.7899170}};
			case 572:
				return {{995.9335938, 1131.7539062}};
			case 573:
				return {{995.9351196, 1131.2126465}};
			case 574:
				return {{995.9354248, 1131.1770020}};
			case 575:
				return {{995.9355469, 1131.1408691}};
			case 576:
				return {{995.9369507, 1130.5632324}};
			case 577:
				return {{995.9371948, 1130.5269775}};
			case 578:
				return {{995.9372559, 1130.4908447}};
			case 579:
				return {{995.9387207, 1129.9134521}};
			case 580:
				return {{995.9384155, 1129.8776855}};
			case 581:
				return {{995.9384766, 1129.8415527}};
			case 582:
				return {{995.9399414, 1129.3004150}};
			case 583:
				return {{995.9403076, 1129.2648926}};
			case 584:
				return {{995.9418335, 1128.6877441}};
			case 585:
				return {{995.9425049, 1128.6508789}};
			case 586:
				return {{995.9425049, 1128.6153564}};
			case 587:
				return {{995.9439697, 1128.0744629}};
			case 588:
				return {{995.9437256, 1128.0388184}};
			case 589:
				return {{995.9438477, 1128.0028076}};
			case 590:
				return {{995.9454346, 1127.4259033}};
			case 591:
				return {{995.9451294, 1127.3908691}};
			case 592:
				return {{995.9451904, 1127.3542480}};
			case 593:
				return {{995.9477539, 1126.7778320}};
			case 594:
				return {{995.9473877, 1126.7416992}};
			case 595:
				return {{995.9473877, 1126.7054443}};
			case 596:
				return {{995.9489746, 1126.1649170}};
			case 597:
				return {{995.9487915, 1126.1298828}};
			case 598:
				return {{995.9487915, 1126.0937500}};
			case 599:
				return {{995.9502563, 1125.5178223}};
			case 600:
				return {{995.9505615, 1125.4822998}};
			case 601:
				return {{995.9534912, 1124.3726807}};
			case 602:
				return {{995.9534302, 1124.3376465}};
			case 603:
				return {{995.9548950, 1123.7908936}};
			case 604:
				return {{995.9552002, 1123.7570801}};
			case 605:
				return {{995.9569702, 1123.2800293}};
			case 606:
				return {{995.9567871, 1123.2500000}};
			case 607:
				return {{995.9567871, 1123.2194824}};
			case 608:
				return {{995.9580078, 1122.7562256}};
			case 609:
				return {{995.9580078, 1122.7281494}};
			case 610:
				return {{995.9591064, 1122.3121338}};
			case 611:
				return {{995.9591675, 1122.2875977}};
			case 612:
				return {{995.9600220, 1121.9407959}};
			case 613:
				return {{995.9600220, 1121.9191895}};
			case 614:
				return {{995.9608154, 1121.5939941}};
			case 615:
				return {{995.9613647, 1121.5749512}};
			case 616:
				return {{995.9613647, 1121.5561523}};
			case 617:
				return {{995.9622192, 1121.2770996}};
			case 618:
				return {{995.9624023, 1121.2614746}};
			case 619:
				return {{995.9624023, 1121.2453613}};
			case 620:
				return {{995.9628906, 1121.0227051}};
			case 621:
				return {{995.9625854, 1121.0090332}};
			case 622:
				return {{995.9631348, 1120.8070068}};
			case 623:
				return {{995.9633789, 1120.7949219}};
			case 624:
				return {{995.9633789, 1120.7839355}};
			case 625:
				return {{995.9638062, 1120.6254883}};
			case 626:
				return {{995.9636841, 1120.6165771}};
			case 627:
				return {{995.9636841, 1120.6069336}};
			case 628:
				return {{995.9643555, 1120.3525391}};
			case 629:
				return {{995.9644775, 1120.3455811}};
			case 630:
				return {{995.9647217, 1120.2573242}};
			case 631:
				return {{995.9646606, 1120.2523193}};
			case 632:
				return {{995.9646606, 1120.2475586}};
			case 633:
				return {{995.9648438, 1120.1723633}};
			case 634:
				return {{995.9652710, 1120.1674805}};
			case 635:
				return {{995.9654541, 1120.1079102}};
			case 636:
				return {{995.9652710, 1120.1044922}};
			case 637:
				return {{995.9658203, 1120.1016846}};
			case 638:
				return {{995.9658813, 1120.0583496}};
			case 639:
				return {{995.9658813, 1120.0551758}};
			case 640:
				return {{995.9658813, 1120.0531006}};
			case 641:
				return {{995.9659424, 1120.0178223}};
			case 642:
				return {{995.9658813, 1120.0157471}};
			case 643:
				return {{995.9659424, 1119.9902344}};
			case 644:
				return {{995.9658813, 1119.9887695}};
			case 645:
				return {{995.9658813, 1119.9876709}};
			case 646:
				return {{995.9659424, 1119.9682617}};
			case 647:
				return {{995.9659424, 1119.9667969}};
			case 648:
				return {{995.9659424, 1119.9658203}};
			case 649:
				return {{995.9659424, 1119.9521484}};
			case 650:
				return {{995.9659424, 1119.9519043}};
			case 651:
				return {{995.9659424, 1119.9426270}};
			case 652:
				return {{995.9659424, 1119.9426270}};
			case 653:
				return {{995.9659424, 1119.9421387}};
			case 654:
				return {{995.9659424, 1119.9359131}};
			case 655:
				return {{995.9659424, 1119.9356689}};
			case 656:
				return {{995.9659424, 1119.9329834}};
			case 657:
				return {{995.9659424, 1119.9328613}};
			case 658:
				return {{995.9659424, 1119.9316406}};
			case 659:
				return {{995.9659424, 1119.9317627}};
			case 660:
				return {{995.9659424, 1119.9322510}};
			case 661:
				return {{995.9659424, 1119.9328613}};
			case 662:
				return {{995.9659424, 1119.9329834}};
			case 663:
				return {{995.9659424, 1119.9348145}};
			case 664:
				return {{995.9659424, 1119.9344482}};
			case 665:
				return {{995.9659424, 1119.9371338}};
			case 666:
				return {{995.9659424, 1119.9372559}};
			case 667:
				return {{995.9659424, 1119.9368896}};
			case 668:
				return {{995.9659424, 1119.9396973}};
			case 669:
				return {{995.9659424, 1119.9393311}};
			case 670:
				return {{995.9659424, 1119.9399414}};
			case 671:
				return {{995.9659424, 1119.9420166}};
			case 672:
				return {{995.9659424, 1119.9426270}};
			case 673:
				return {{995.9659424, 1119.9451904}};
			case 674:
				return {{995.9659424, 1119.9448242}};
			case 675:
				return {{995.9659424, 1119.9454346}};
			case 676:
				return {{995.9659424, 1119.9476318}};
			case 677:
				return {{995.9659424, 1119.9472656}};
			case 678:
				return {{995.9659424, 1119.9478760}};
			case 679:
				return {{995.9659424, 1119.9500732}};
			case 680:
				return {{995.9659424, 1119.9497070}};
			case 681:
				return {{995.9659424, 1119.9521484}};
			case 682:
				return {{995.9659424, 1119.9517822}};
			case 683:
				return {{995.9659424, 1119.9523926}};
			case 684:
				return {{995.9659424, 1119.9542236}};
			case 685:
				return {{995.9659424, 1119.9543457}};
			case 686:
				return {{995.9659424, 1119.9554443}};
			case 687:
				return {{995.9659424, 1119.9560547}};
			case 688:
				return {{995.9658813, 1119.9573975}};
			case 689:
				return {{995.9658813, 1119.9586182}};
			case 690:
				return {{995.9659424, 1119.9597168}};
			case 691:
				return {{995.9659424, 1119.9598389}};
			case 692:
				return {{995.9659424, 1119.9594727}};
			case 693:
				return {{995.9659424, 1119.9603271}};
			case 694:
				return {{995.9659424, 1119.9603271}};
			case 695:
				return {{995.9659424, 1119.9616699}};
			case 696:
				return {{995.9659424, 1119.9616699}};
			case 697:
				return {{995.9659424, 1119.9616699}};
			case 698:
				return {{995.9659424, 1119.9622803}};
			case 699:
				return {{995.9659424, 1119.9622803}};
			case 700:
				return {{995.9659424, 1119.9628906}};
			case 701:
				return {{995.9659424, 1119.9628906}};
			case 702:
				return {{995.9659424, 1119.9632568}};
			case 703:
				return {{995.9659424, 1119.9632568}};
			case 704:
				return {{995.9659424, 1119.9632568}};
			case 705:
				return {{995.9659424, 1119.9636230}};
			case 706:
				return {{995.9659424, 1119.9636230}};
			case 707:
				return {{995.9659424, 1119.9636230}};
			case 708:
				return {{995.9659424, 1119.9638672}};
			case 709:
				return {{995.9659424, 1119.9638672}};
			case 710:
				return {{995.9659424, 1119.9637451}};
			case 711:
				return {{995.9659424, 1119.9637451}};
			case 712:
				return {{995.9659424, 1119.9637451}};
			case 713:
				return {{995.9659424, 1119.9643555}};
			case 714:
				return {{995.9659424, 1119.9643555}};
			case 715:
				return {{995.9659424, 1119.9643555}};
			case 716:
				return {{995.9658813, 1119.9639893}};
			case 717:
				return {{995.9658813, 1119.9639893}};
			case 718:
				return {{995.9659424, 1119.9644775}};
			case 719:
				return {{995.9659424, 1119.9647217}};
			case 720:
				return {{995.9659424, 1119.9643555}};
			case 721:
				return {{995.9659424, 1119.9643555}};
			case 722:
				return {{995.9659424, 1119.9643555}};
			case 723:
				return {{995.9659424, 1119.9643555}};
			case 724:
				return {{995.9659424, 1119.9643555}};
			case 725:
				return {{995.9659424, 1119.9643555}};
			case 726:
				return {{995.9659424, 1119.9643555}};
			case 727:
				return {{995.9659424, 1119.9643555}};
			case 728:
				return {{995.9659424, 1119.9643555}};
			case 729:
				return {{995.9659424, 1119.9643555}};
			case 730:
				return {{995.9659424, 1119.9643555}};
			case 731:
				return {{995.9659424, 1119.9643555}};
			case 732:
				return {{995.9659424, 1119.9643555}};
			case 733:
				return {{995.9659424, 1119.9643555}};
			case 734:
				return {{995.9659424, 1119.9643555}};
			case 735:
				return {{995.9659424, 1119.9643555}};
			case 736:
				return {{995.9659424, 1119.9643555}};
			case 737:
				return {{995.9659424, 1119.9643555}};
			case 738:
				return {{995.9659424, 1119.9643555}};
			case 739:
				return {{995.9659424, 1119.9643555}};
			case 740:
				return {{995.9659424, 1119.9643555}};
			case 741:
				return {{995.9659424, 1119.9643555}};
			case 742:
				return {{995.9659424, 1119.9643555}};
			case 743:
				return {{995.9659424, 1119.9643555}};
			case 744:
				return {{995.9659424, 1119.9643555}};
			case 745:
				return {{995.9659424, 1119.9643555}};
			case 746:
				return {{995.9659424, 1119.9643555}};
			case 747:
				return {{995.9659424, 1119.9643555}};
			case 748:
				return {{995.9659424, 1119.9643555}};
			case 749:
				return {{995.9659424, 1119.9643555}};
			case 750:
				return {{995.9659424, 1119.9643555}};
			case 751:
				return {{995.9659424, 1119.9643555}};
			case 752:
				return {{995.9659424, 1119.9643555}};
			case 753:
				return {{995.9659424, 1119.9643555}};
			case 754:
				return {{995.9659424, 1119.9643555}};
			case 755:
				return {{995.9659424, 1119.9643555}};
			case 756:
				return {{995.9659424, 1119.9643555}};
			case 757:
				return {{995.9659424, 1119.9643555}};
			case 758:
				return {{995.9659424, 1119.9643555}};
			case 759:
				return {{995.9659424, 1119.9643555}};
			case 760:
				return {{995.9659424, 1119.9643555}};
			case 761:
				return {{995.9659424, 1119.9643555}};
			case 762:
				return {{995.9659424, 1119.9643555}};
			case 763:
				return {{995.9659424, 1119.9643555}};
			case 764:
				return {{995.9659424, 1119.9643555}};
			case 765:
				return {{995.9659424, 1119.9643555}};
			case 766:
				return {{995.9659424, 1119.9643555}};
			case 767:
				return {{995.9659424, 1119.9643555}};
			case 768:
				return {{995.9659424, 1119.9643555}};
			case 769:
				return {{995.9659424, 1119.9643555}};
			case 770:
				return {{995.9659424, 1119.9643555}};
			case 771:
				return {{995.9659424, 1119.9643555}};
			case 772:
				return {{995.9659424, 1119.9643555}};
			case 773:
				return {{995.9659424, 1119.9643555}};
			case 774:
				return {{995.9659424, 1119.9643555}};
			case 775:
				return {{995.9659424, 1119.9643555}};
			case 776:
				return {{995.9659424, 1119.9643555}};
			case 777:
				return {{995.9659424, 1119.9643555}};
			case 778:
				return {{995.9659424, 1119.9643555}};
			case 779:
				return {{995.9659424, 1119.9643555}};
			case 780:
				return {{995.9659424, 1119.9643555}};
			case 781:
				return {{995.9659424, 1119.9643555}};
			case 782:
				return {{995.9659424, 1119.9643555}};
			case 783:
				return {{995.9659424, 1119.9643555}};
			case 784:
				return {{995.9659424, 1119.9643555}};
			case 785:
				return {{995.9659424, 1119.9643555}};
			case 786:
				return {{995.9659424, 1119.9643555}};
			case 787:
				return {{995.9659424, 1119.9643555}};
			case 788:
				return {{995.9659424, 1119.9643555}};
			case 789:
				return {{995.9659424, 1119.9643555}};
			case 790:
				return {{995.9659424, 1119.9643555}};
			case 791:
				return {{995.9659424, 1119.9643555}};
			case 792:
				return {{995.9659424, 1119.9643555}};
			case 793:
				return {{995.9659424, 1119.9643555}};
			case 794:
				return {{995.9659424, 1119.9643555}};
			case 795:
				return {{995.9659424, 1119.9643555}};
			case 796:
				return {{995.9659424, 1119.9643555}};
			case 797:
				return {{995.9659424, 1119.9643555}};
			case 798:
				return {{995.9659424, 1119.9643555}};
			case 799:
				return {{995.9659424, 1119.9643555}};
			case 800:
				return {{995.9659424, 1119.9643555}};
			case 801:
				return {{995.9659424, 1119.9643555}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		assert(false); // Shouldn't be any unaccounted raycasts
		return std::nullopt;
	}
};
// NOLINTEND(bugprone-branch-clone, google-readability-function-size, readability-function-size)
