/*******************************************************************************
 * Copyright (c) 2018-2024 openblack developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/openblack/openblack
 *
 * openblack is licensed under the GNU General Public License version 3.
 *******************************************************************************/

#pragma once

#include "Mock.h"

class TiltDownZoomOutMockAction final: public MockAction
{
	static constexpr uint32_t k_Start1 = k_StabilizeFrames + 1;
	static constexpr uint32_t k_End1 = k_StabilizeFrames + k_InteractionFrames - 1;
	static constexpr uint32_t k_Start2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames + 1;
	static constexpr uint32_t k_End2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames + k_InteractionFrames - 1;

public:
	~TiltDownZoomOutMockAction() final = default;

	[[nodiscard]] bool GetBindable(openblack::input::BindableActionMap action) const final
	{
		using openblack::input::BindableActionMap;
		if (frameNumber >= k_Start1 && frameNumber <= k_End1)
		{
			return (static_cast<uint32_t>(action) & static_cast<uint32_t>(BindableActionMap::TILT_DOWN)) != 0;
		}

		if (frameNumber >= k_Start2 && frameNumber <= k_End2)
		{
			return (static_cast<uint32_t>(action) & (static_cast<uint32_t>(BindableActionMap::ZOOM_ON) |
			                                         static_cast<uint32_t>(BindableActionMap::MOVE_BACKWARDS))) != 0;
		}

		return false;
	}
};

// NOLINTBEGIN(bugprone-branch-clone, google-readability-function-size, readability-function-size)
class TiltDownZoomOutMockDynamicsSystem: public MockDynamicsSystem
{
public:
	TiltDownZoomOutMockDynamicsSystem() = default;

	[[nodiscard]] std::optional<glm::vec2> RayCastClosestHitScreenCoord(glm::u16vec2 screenCoord) const override
	{
		if (screenCoord == k_ScreenCentreLine[0])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1098.6373291}};
			case 502:
				return {{1000.0000000, 1104.0295410}};
			case 601:
				return {{1000.0000000, 1054.3438721}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[1])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1104.5364990}};
			case 502:
				return {{1000.0000000, 1107.6240234}};
			case 601:
				return {{1000.0000000, 1072.5954590}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[2])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 563.2467041f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1108.1452637}};
			case 502:
				return {{1000.0000000, 1110.0925293}};
			case 601:
				return {{1000.0000000, 1085.1472168}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[3])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 189.2355652f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1110.4764404}};
			case 502:
				return {{1000.0000000, 1111.8146973}};
			case 601:
				return {{1000.0000000, 1093.8922119}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[4])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 100.4535294f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1112.1796875}};
			case 502:
				return {{1000.0000000, 1113.1444092}};
			case 601:
				return {{1000.0000000, 1100.6450195}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[5])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 62.1956444f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1113.4201660}};
			case 502:
				return {{1000.0000000, 1114.1514893}};
			case 601:
				return {{1000.0000000, 1105.7628174}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[6])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 39.9825211f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1114.4096680}};
			case 502:
				return {{1000.0000000, 1114.9804688}};
			case 601:
				return {{1000.0000000, 1109.9742432}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[7])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 26.0952835f}};
			case 202:
				return std::nullopt;
			case 301:
				return {{1000.0000000, 1115.1793213}};
			case 502:
				return {{1000.0000000, 1115.6416016}};
			case 601:
				return {{1000.0000000, 1113.3314209}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[8])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000, 16.1538353}};
			case 1:
				return {{1000.0000000, -770.0559082}};
			case 2:
				return {{1000.0000000, -743.0767822}};
			case 3:
				return {{1000.0000000, -5.7276611}};
			case 4:
				return {{1000.0000000, 105.8948517}};
			case 5:
				return {{1000.0000000, 112.1076202}};
			case 6:
				return {{1000.0000000, 118.2447052}};
			case 7:
				return {{1000.0000000, 200.3244019}};
			case 8:
				return {{1000.0000000, 204.8554993}};
			case 9:
				return {{1000.0000000, 264.9228516}};
			case 10:
				return {{1000.0000000, 268.0856323}};
			case 11:
				return {{1000.0000000, 271.2250366}};
			case 12:
				return {{1000.0000000, 313.6578369}};
			case 13:
				return {{1000.0000000, 316.1343384}};
			case 14:
				return {{1000.0000000, 318.7072144}};
			case 15:
				return {{1000.0000000, 321.1528931}};
			case 16:
				return {{1000.0000000, 355.7194519}};
			case 17:
				return {{1000.0000000, 357.7429199}};
			case 18:
				return {{1000.0000000, 384.0479126}};
			case 19:
				return {{1000.0000000, 407.4533691}};
			case 20:
				return {{1000.0000000, 427.1724854}};
			case 21:
				return {{1000.0000000, 428.2545471}};
			case 22:
				return {{1000.0000000, 443.9299011}};
			case 23:
				return {{1000.0000000, 444.8811340}};
			case 24:
				return {{1000.0000000, 459.2140198}};
			case 25:
				return {{1000.0000000, 460.0471497}};
			case 26:
				return {{1000.0000000, 472.5143433}};
			case 27:
				return {{1000.0000000, 473.2416382}};
			case 28:
				return {{1000.0000000, 483.4656067}};
			case 29:
				return {{1000.0000000, 484.1685791}};
			case 30:
				return {{1000.0000000, 493.8484192}};
			case 31:
				return {{1000.0000000, 494.3926697}};
			case 32:
				return {{1000.0000000, 502.4442139}};
			case 33:
				return {{1000.0000000, 502.9736938}};
			case 34:
				return {{1000.0000000, 510.7427979}};
			case 35:
				return {{1000.0000000, 511.1937256}};
			case 36:
				return {{1000.0000000, 518.1301270}};
			case 37:
				return {{1000.0000000, 518.5700684}};
			case 38:
				return {{1000.0000000, 519.0095215}};
			case 39:
				return {{1000.0000000, 500.6634216}};
			case 40:
				return {{1000.0000000, 498.8476868}};
			case 41:
				return {{1000.0000000, 471.6894531}};
			case 42:
				return {{1000.0000000, 469.9794006}};
			case 43:
				return {{1000.0000000, 442.9660645}};
			case 44:
				return {{1000.0000000, 417.5871277}};
			case 45:
				return {{1000.0000000, 391.1619568}};
			case 46:
				return {{1000.0000000, 389.5305786}};
			case 47:
				return {{1000.0000000, 364.7833862}};
			case 48:
				return {{1000.0000000, 363.1747437}};
			case 49:
				return {{1000.0000000, 337.2171631}};
			case 50:
				return {{1000.0000000, 335.5335999}};
			case 51:
				return {{1000.0000000, 309.9683228}};
			case 52:
				return {{1000.0000000, 308.3560791}};
			case 53:
				return {{1000.0000000, 285.0237427}};
			case 54:
				return {{1000.0000000, 283.0931091}};
			case 55:
				return {{1000.0000000, 258.5480347}};
			case 56:
				return {{1000.0000000, 256.9194946}};
			case 57:
				return {{1000.0000000, 232.4271393}};
			case 58:
				return {{1000.0000000, 230.9935760}};
			case 59:
				return {{1000.0000000, 208.8545990}};
			case 60:
				return {{1000.0000000, 207.3721313}};
			case 61:
				return {{1000.0000000, 184.0393066}};
			case 62:
				return {{1000.0000000, 182.6068115}};
			case 63:
				return {{1000.0000000, 161.3394165}};
			case 64:
				return {{1000.0000000, 159.7380066}};
			case 65:
				return {{1000.0000000, 137.5003815}};
			case 66:
				return {{1000.0000000, 115.8879089}};
			case 67:
				return {{1000.0000000, 95.8544159}};
			case 68:
				return {{1000.0000000, 94.5362091}};
			case 69:
				return {{1000.0000000, 73.7548065}};
			case 70:
				return {{1000.0000000, 72.4786377}};
			case 71:
				return {{1000.0000000, 52.5038910}};
			case 72:
				return {{1000.0000000, 51.1960602}};
			case 73:
				return {{1000.0000000, 32.9644012}};
			case 74:
				return {{1000.0000000, 31.5235901}};
			case 75:
				return {{1000.0000000, 30.2701569}};
			case 76:
				return {{1000.0000000, 11.1421204}};
			case 77:
				return {{1000.0000000, 10.1613617}};
			case 78:
				return {{1000.0000000, -7.2264404}};
			case 79:
				return {{1000.0000000, -8.4018555}};
			case 80:
				return {{1000.0000000, -26.1702881}};
			case 81:
				return {{1000.0000000, -27.1201172}};
			case 82:
				return {{1000.0000000, -44.8266602}};
			case 83:
				return {{1000.0000000, -45.5584717}};
			case 84:
				return {{1000.0000000, -61.5065918}};
			case 85:
				return {{1000.0000000, -62.6777344}};
			case 86:
				return {{1000.0000000, -78.9976807}};
			case 87:
				return {{1000.0000000, -79.9364014}};
			case 88:
				return {{1000.0000000, -95.5395508}};
			case 89:
				return {{1000.0000000, -96.6873779}};
			case 90:
				return {{1000.0000000, -110.8873291}};
			case 91:
				return {{1000.0000000, -125.5928955}};
			case 92:
				return {{1000.0000000, -139.0494385}};
			case 93:
				return {{1000.0000000, -139.7036133}};
			case 94:
				return {{1000.0000000, -153.5233154}};
			case 95:
				return {{1000.0000000, -154.3769531}};
			case 96:
				return {{1000.0000000, -167.5012207}};
			case 97:
				return {{1000.0000000, -168.5506592}};
			case 98:
				return {{1000.0000000, -180.2821045}};
			case 99:
				return {{1000.0000000, -181.0770264}};
			case 100:
				return {{1000.0000000, -193.0888672}};
			case 101:
				return {{1000.0000000, -194.0817871}};
			case 102:
				return {{1000.0000000, -205.6433105}};
			case 103:
				return {{1000.0000000, -216.1108398}};
			case 104:
				return {{1000.0000000, -216.8082275}};
			case 105:
				return {{1000.0000000, -227.3505859}};
			case 106:
				return {{1000.0000000, -228.0187988}};
			case 107:
				return {{1000.0000000, -228.5657959}};
			case 108:
				return {{1000.0000000, -238.1468506}};
			case 109:
				return {{1000.0000000, -238.7722168}};
			case 110:
				return {{1000.0000000, -248.4827881}};
			case 111:
				return {{1000.0000000, -249.0815430}};
			case 112:
				return {{1000.0000000, -258.1691895}};
			case 113:
				return {{1000.0000000, -258.7281494}};
			case 114:
				return {{1000.0000000, -275.2501221}};
			case 115:
				return {{1000.0000000, -283.1724854}};
			case 116:
				return {{1000.0000000, -283.3957520}};
			case 117:
				return {{1000.0000000, -290.4317627}};
			case 118:
				return {{1000.0000000, -290.8327637}};
			case 119:
				return {{1000.0000000, -297.8603516}};
			case 120:
				return {{1000.0000000, -298.2362061}};
			case 121:
				return {{1000.0000000, -304.2756348}};
			case 122:
				return {{1000.0000000, -304.6058350}};
			case 123:
				return {{1000.0000000, -305.0563965}};
			case 124:
				return {{1000.0000000, -311.0228271}};
			case 125:
				return {{1000.0000000, -316.6230469}};
			case 126:
				return {{1000.0000000, -317.1135254}};
			case 127:
				return {{1000.0000000, -321.9949951}};
			case 128:
				return {{1000.0000000, -322.4465332}};
			case 129:
				return {{1000.0000000, -322.8072510}};
			case 130:
				return {{1000.0000000, -327.5804443}};
			case 131:
				return {{1000.0000000, -332.0192871}};
			case 132:
				return {{1000.0000000, -332.1802979}};
			case 133:
				return {{1000.0000000, -336.0573730}};
			case 134:
				return {{1000.0000000, -336.1817627}};
			case 135:
				return {{1000.0000000, -340.1765137}};
			case 136:
				return {{1000.0000000, -340.2766113}};
			case 137:
				return {{1000.0000000, -343.6551514}};
			case 138:
				return {{1000.0000000, -346.5415039}};
			case 139:
				return {{1000.0000000, -349.7819824}};
			case 140:
				return {{1000.0000000, -349.7995605}};
			case 141:
				return {{1000.0000000, -352.2539062}};
			case 142:
				return {{1000.0000000, -352.4711914}};
			case 143:
				return {{1000.0000000, -354.5693359}};
			case 144:
				return {{1000.0000000, -354.7683105}};
			case 145:
				return {{1000.0000000, -356.8011475}};
			case 146:
				return {{1000.0000000, -356.9757080}};
			case 147:
				return {{1000.0000000, -358.6204834}};
			case 148:
				return {{1000.0000000, -358.7729492}};
			case 149:
				return {{1000.0000000, -360.5307617}};
			case 150:
				return {{1000.0000000, -360.4355469}};
			case 151:
				return {{1000.0000000, -361.8718262}};
			case 152:
				return {{1000.0000000, -361.7562256}};
			case 153:
				return {{1000.0000000, -363.0778809}};
			case 154:
				return {{1000.0000000, -363.1750488}};
			case 155:
				return {{1000.0000000, -364.0666504}};
			case 156:
				return {{1000.0000000, -364.1520996}};
			case 157:
				return {{1000.0000000, -364.8118896}};
			case 158:
				return {{1000.0000000, -365.1131592}};
			case 159:
				return {{1000.0000000, -365.6785889}};
			case 160:
				return {{1000.0000000, -365.7379150}};
			case 161:
				return {{1000.0000000, -366.8975830}};
			case 162:
				return {{1000.0000000, -367.1383057}};
			case 163:
				return {{1000.0000000, -367.1704102}};
			case 164:
				return {{1000.0000000, -367.5058594}};
			case 165:
				return {{1000.0000000, -367.5330811}};
			case 166:
				return {{1000.0000000, -367.8172607}};
			case 167:
				return {{1000.0000000, -367.8402100}};
			case 168:
				return {{1000.0000000, -368.0611572}};
			case 169:
				return {{1000.0000000, -368.0804443}};
			case 170:
				return {{1000.0000000, -368.2398682}};
			case 171:
				return {{1000.0000000, -368.2490234}};
			case 172:
				return {{1000.0000000, -368.3774414}};
			case 173:
				return {{1000.0000000, -368.1584473}};
			case 174:
				return {{1000.0000000, -368.4852295}};
			case 175:
				return {{1000.0000000, -368.4898682}};
			case 176:
				return {{1000.0000000, -368.5522461}};
			case 177:
				return {{1000.0000000, -368.5556641}};
			case 178:
				return {{1000.0000000, -368.6008301}};
			case 179:
				return {{1000.0000000, -368.6030273}};
			case 180:
				return {{1000.0000000, -368.6293945}};
			case 181:
				return {{1000.0000000, -368.6307373}};
			case 182:
				return {{1000.0000000, -368.6463623}};
			case 183:
				return {{1000.0000000, -368.6523438}};
			case 184:
				return {{1000.0000000, -368.6516113}};
			case 185:
				return {{1000.0000000, -368.6513672}};
			case 186:
				return {{1000.0000000, -368.6455078}};
			case 187:
				return {{1000.0000000, -368.6450195}};
			case 188:
				return {{1000.0000000, -368.6356201}};
			case 189:
				return {{1000.0000000, -368.6350098}};
			case 190:
				return {{1000.0000000, -368.6240234}};
			case 191:
				return {{1000.0000000, -368.6234131}};
			case 192:
				return {{1000.0000000, -368.6105957}};
			case 193:
				return {{1000.0000000, -368.6097412}};
			case 194:
				return {{1000.0000000, -368.5974121}};
			case 195:
				return {{1000.0000000, -368.5965576}};
			case 196:
				return {{1000.0000000, -368.5834961}};
			case 197:
				return {{1000.0000000, -368.5827637}};
			case 198:
				return {{1000.0000000, -368.5701904}};
			case 199:
				return {{1000.0000000, -368.5695801}};
			case 200:
				return {{1000.0000000, -368.5584717}};
			case 201:
				return {{1000.0000000, -368.5578613}};
			case 202:
				return {{1000.0000000, -368.5469971}};
			case 203:
				return {{1000.0000000, -367.8695068}};
			case 204:
				return {{1000.0000000, -210.3620605}};
			case 205:
				return {{1000.0000000, -193.6252441}};
			case 206:
				return {{1000.0000000, 419.5933533}};
			case 207:
				return {{1000.0000000, 607.0214233}};
			case 208:
				return {{1000.0000000, 616.8871460}};
			case 209:
				return {{1000.0000000, 626.4470825}};
			case 210:
				return {{1000.0000000, 746.7623291}};
			case 211:
				return {{1000.0000000, 752.6770020}};
			case 212:
				return {{1000.0000000, 829.6629639}};
			case 213:
				return {{1000.0000000, 833.5689697}};
			case 214:
				return {{1000.0000000, 883.0609741}};
			case 215:
				return {{1000.0000000, 885.8560791}};
			case 216:
				return {{1000.0000000, 924.1134033}};
			case 217:
				return {{1000.0000000, 926.1663818}};
			case 218:
				return {{1000.0000000, 954.9337769}};
			case 219:
				return {{1000.0000000, 956.5107422}};
			case 220:
				return {{1000.0000000, 977.7290039}};
			case 221:
				return {{1000.0000000, 978.9976807}};
			case 222:
				return {{1000.0000000, 997.2494507}};
			case 223:
				return {{1000.0000000, 998.2799683}};
			case 224:
				return {{1000.0000000, 1012.4270630}};
			case 225:
				return {{1000.0000000, 1013.2910156}};
			case 226:
				return {{1000.0000000, 1025.9698486}};
			case 227:
				return {{1000.0000000, 1026.7054443}};
			case 228:
				return {{1000.0000000, 1037.4659424}};
			case 229:
				return {{1000.0000000, 1038.1025391}};
			case 230:
				return {{1000.0000000, 1054.9775391}};
			case 231:
				return {{1000.0000000, 1062.1665039}};
			case 232:
				return {{1000.0000000, 1062.5849609}};
			case 233:
				return {{1000.0000000, 1063.0006104}};
			case 234:
				return {{1000.0000000, 1068.8659668}};
			case 235:
				return {{1000.0000000, 1074.4228516}};
			case 236:
				return {{1000.0000000, 1074.7470703}};
			case 237:
				return {{1000.0000000, 1079.3522949}};
			case 238:
				return {{1000.0000000, 1079.6392822}};
			case 239:
				return {{1000.0000000, 1083.9791260}};
			case 240:
				return {{1000.0000000, 1084.2358398}};
			case 241:
				return {{1000.0000000, 1088.0650635}};
			case 242:
				return {{1000.0000000, 1088.2915039}};
			case 243:
				return {{1000.0000000, 1091.4761963}};
			case 244:
				return {{1000.0000000, 1091.6773682}};
			case 245:
				return {{1000.0000000, 1094.6951904}};
			case 246:
				return {{1000.0000000, 1094.8696289}};
			case 247:
				return {{1000.0000000, 1097.5332031}};
			case 248:
				return {{1000.0000000, 1097.6934814}};
			case 249:
				return {{1000.0000000, 1099.9067383}};
			case 250:
				return {{1000.0000000, 1100.0449219}};
			case 251:
				return {{1000.0000000, 1102.1403809}};
			case 252:
				return {{1000.0000000, 1102.2633057}};
			case 253:
				return {{1000.0000000, 1102.3834229}};
			case 254:
				return {{1000.0000000, 1105.7388916}};
			case 255:
				return {{1000.0000000, 1107.1763916}};
			case 256:
				return {{1000.0000000, 1107.2597656}};
			case 257:
				return {{1000.0000000, 1108.4462891}};
			case 258:
				return {{1000.0000000, 1108.5216064}};
			case 259:
				return {{1000.0000000, 1108.5939941}};
			case 260:
				return {{1000.0000000, 1109.6970215}};
			case 261:
				return {{1000.0000000, 1109.7614746}};
			case 262:
				return {{1000.0000000, 1110.7215576}};
			case 263:
				return {{1000.0000000, 1110.7778320}};
			case 264:
				return {{1000.0000000, 1111.5639648}};
			case 265:
				return {{1000.0000000, 1112.2984619}};
			case 266:
				return {{1000.0000000, 1112.3409424}};
			case 267:
				return {{1000.0000000, 1112.9388428}};
			case 268:
				return {{1000.0000000, 1112.9761963}};
			case 269:
				return {{1000.0000000, 1113.5240479}};
			case 270:
				return {{1000.0000000, 1113.5554199}};
			case 271:
				return {{1000.0000000, 1114.0163574}};
			case 272:
				return {{1000.0000000, 1114.0426025}};
			case 273:
				return {{1000.0000000, 1114.4022217}};
			case 274:
				return {{1000.0000000, 1114.4240723}};
			case 275:
				return {{1000.0000000, 1114.4456787}};
			case 276:
				return {{1000.0000000, 1114.7545166}};
			case 277:
				return {{1000.0000000, 1114.7722168}};
			case 278:
				return {{1000.0000000, 1114.7889404}};
			case 279:
				return {{1000.0000000, 1115.0303955}};
			case 280:
				return {{1000.0000000, 1115.2080078}};
			case 281:
				return {{1000.0000000, 1115.3562012}};
			case 282:
				return {{1000.0000000, 1115.3634033}};
			case 283:
				return {{1000.0000000, 1115.3715820}};
			case 284:
				return {{1000.0000000, 1115.4738770}};
			case 285:
				return {{1000.0000000, 1115.4794922}};
			case 286:
				return {{1000.0000000, 1115.4855957}};
			case 287:
				return {{1000.0000000, 1115.5667725}};
			case 288:
				return {{1000.0000000, 1115.5714111}};
			case 289:
				return {{1000.0000000, 1115.5748291}};
			case 290:
				return {{1000.0000000, 1115.6367188}};
			case 291:
				return {{1000.0000000, 1115.6395264}};
			case 292:
				return {{1000.0000000, 1115.6431885}};
			case 293:
				return {{1000.0000000, 1115.6885986}};
			case 294:
				return {{1000.0000000, 1115.6910400}};
			case 295:
				return {{1000.0000000, 1115.7341309}};
			case 296:
				return {{1000.0000000, 1115.7364502}};
			case 297:
				return {{1000.0000000, 1115.7397461}};
			case 298:
				return {{1000.0000000, 1115.7805176}};
			case 299:
				return {{1000.0000000, 1115.7827148}};
			case 300:
				return {{1000.0000000, 1115.7850342}};
			case 301:
				return {{1000.0000000, 1115.8249512}};
			case 302:
				return {{1000.0000000, 1115.8278809}};
			case 303:
				return {{1000.0000000, 1115.8666992}};
			case 304:
				return {{1000.0000000, 1115.8690186}};
			case 305:
				return {{1000.0000000, 1115.8710938}};
			case 306:
				return {{1000.0000000, 1115.9017334}};
			case 307:
				return {{1000.0000000, 1115.9039307}};
			case 308:
				return {{1000.0000000, 1115.9333496}};
			case 309:
				return {{1000.0000000, 1115.9600830}};
			case 310:
				return {{1000.0000000, 1115.9616699}};
			case 311:
				return {{1000.0000000, 1115.9846191}};
			case 312:
				return {{1000.0000000, 1115.9868164}};
			case 313:
				return {{1000.0000000, 1115.9884033}};
			case 314:
				return {{1000.0000000, 1116.0111084}};
			case 315:
				return {{1000.0000000, 1116.0125732}};
			case 316:
				return {{1000.0000000, 1116.0144043}};
			case 317:
				return {{1000.0000000, 1116.0361328}};
			case 318:
				return {{1000.0000000, 1116.0374756}};
			case 319:
				return {{1000.0000000, 1116.0568848}};
			case 320:
				return {{1000.0000000, 1116.0576172}};
			case 321:
				return {{1000.0000000, 1116.0590820}};
			case 322:
				return {{1000.0000000, 1116.0783691}};
			case 323:
				return {{1000.0000000, 1116.0789795}};
			case 324:
				return {{1000.0000000, 1116.0803223}};
			case 325:
				return {{1000.0000000, 1116.0971680}};
			case 326:
				return {{1000.0000000, 1116.0976562}};
			case 327:
				return {{1000.0000000, 1116.0992432}};
			case 328:
				return {{1000.0000000, 1116.1158447}};
			case 329:
				return {{1000.0000000, 1116.1164551}};
			case 330:
				return {{1000.0000000, 1116.1175537}};
			case 331:
				return {{1000.0000000, 1116.1320801}};
			case 332:
				return {{1000.0000000, 1116.1339111}};
			case 333:
				return {{1000.0000000, 1116.1345215}};
			case 334:
				return {{1000.0000000, 1116.1466064}};
			case 335:
				return {{1000.0000000, 1116.1470947}};
			case 336:
				return {{1000.0000000, 1116.1480713}};
			case 337:
				return {{1000.0000000, 1116.1601562}};
			case 338:
				return {{1000.0000000, 1116.1605225}};
			case 339:
				return {{1000.0000000, 1116.1608887}};
			case 340:
				return {{1000.0000000, 1116.1708984}};
			case 341:
				return {{1000.0000000, 1116.1718750}};
			case 342:
				return {{1000.0000000, 1116.1801758}};
			case 343:
				return {{1000.0000000, 1116.1870117}};
			case 344:
				return {{1000.0000000, 1116.1925049}};
			case 345:
				return {{1000.0000000, 1116.1927490}};
			case 346:
				return {{1000.0000000, 1116.1943359}};
			case 347:
				return {{1000.0000000, 1116.1984863}};
			case 348:
				return {{1000.0000000, 1116.1986084}};
			case 349:
				return {{1000.0000000, 1116.2023926}};
			case 350:
				return {{1000.0000000, 1116.2025146}};
			case 351:
				return {{1000.0000000, 1116.2026367}};
			case 352:
				return {{1000.0000000, 1116.2061768}};
			case 353:
				return {{1000.0000000, 1116.2061768}};
			case 354:
				return {{1000.0000000, 1116.2080078}};
			case 355:
				return {{1000.0000000, 1116.2081299}};
			case 356:
				return {{1000.0000000, 1116.2082520}};
			case 357:
				return {{1000.0000000, 1116.2099609}};
			case 358:
				return {{1000.0000000, 1116.2099609}};
			case 359:
				return {{1000.0000000, 1116.2106934}};
			case 360:
				return {{1000.0000000, 1116.2106934}};
			case 361:
				return {{1000.0000000, 1116.2106934}};
			case 362:
				return {{1000.0000000, 1116.2116699}};
			case 363:
				return {{1000.0000000, 1116.2116699}};
			case 364:
				return {{1000.0000000, 1116.2116699}};
			case 365:
				return {{1000.0000000, 1116.2116699}};
			case 366:
				return {{1000.0000000, 1116.2119141}};
			case 367:
				return {{1000.0000000, 1116.2119141}};
			case 368:
				return {{1000.0000000, 1116.2119141}};
			case 369:
				return {{1000.0000000, 1116.2119141}};
			case 370:
				return {{1000.0000000, 1116.2119141}};
			case 371:
				return {{1000.0000000, 1116.2119141}};
			case 372:
				return {{1000.0000000, 1116.2119141}};
			case 373:
				return {{1000.0000000, 1116.2117920}};
			case 374:
				return {{1000.0000000, 1116.2116699}};
			case 375:
				return {{1000.0000000, 1116.2106934}};
			case 376:
				return {{1000.0000000, 1116.2106934}};
			case 377:
				return {{1000.0000000, 1116.2106934}};
			case 378:
				return {{1000.0000000, 1116.2104492}};
			case 379:
				return {{1000.0000000, 1116.2105713}};
			case 380:
				return {{1000.0000000, 1116.2105713}};
			case 381:
				return {{1000.0000000, 1116.2103271}};
			case 382:
				return {{1000.0000000, 1116.2103271}};
			case 383:
				return {{1000.0000000, 1116.2102051}};
			case 384:
				return {{1000.0000000, 1116.2099609}};
			case 385:
				return {{1000.0000000, 1116.2099609}};
			case 386:
				return {{1000.0000000, 1116.2099609}};
			case 387:
				return {{1000.0000000, 1116.2098389}};
			case 388:
				return {{1000.0000000, 1116.2098389}};
			case 389:
				return {{1000.0000000, 1116.2086182}};
			case 390:
				return {{1000.0000000, 1116.2087402}};
			case 391:
				return {{1000.0000000, 1116.2087402}};
			case 392:
				return {{1000.0000000, 1116.2084961}};
			case 393:
				return {{1000.0000000, 1116.2086182}};
			case 394:
				return {{1000.0000000, 1116.2086182}};
			case 395:
				return {{1000.0000000, 1116.2084961}};
			case 396:
				return {{1000.0000000, 1116.2083740}};
			case 397:
				return {{1000.0000000, 1116.2083740}};
			case 398:
				return {{1000.0000000, 1116.2082520}};
			case 399:
				return {{1000.0000000, 1116.2082520}};
			case 400:
				return {{1000.0000000, 1116.2080078}};
			case 401:
				return {{1000.0000000, 1116.2080078}};
			case 402:
				return {{1000.0000000, 1116.2080078}};
			case 403:
				return {{1000.0000000, 1116.2077637}};
			case 404:
				return {{1000.0000000, 1116.2077637}};
			case 405:
				return {{1000.0000000, 1116.2077637}};
			case 406:
				return {{1000.0000000, 1116.2076416}};
			case 407:
				return {{1000.0000000, 1116.2069092}};
			case 408:
				return {{1000.0000000, 1116.2069092}};
			case 409:
				return {{1000.0000000, 1116.2069092}};
			case 410:
				return {{1000.0000000, 1116.2070312}};
			case 411:
				return {{1000.0000000, 1116.2069092}};
			case 412:
				return {{1000.0000000, 1116.2069092}};
			case 413:
				return {{1000.0000000, 1116.2070312}};
			case 414:
				return {{1000.0000000, 1116.2069092}};
			case 415:
				return {{1000.0000000, 1116.2070312}};
			case 416:
				return {{1000.0000000, 1116.2070312}};
			case 417:
				return {{1000.0000000, 1116.2070312}};
			case 418:
				return {{1000.0000000, 1116.2070312}};
			case 419:
				return {{1000.0000000, 1116.2076416}};
			case 420:
				return {{1000.0000000, 1116.2076416}};
			case 421:
				return {{1000.0000000, 1116.2076416}};
			case 422:
				return {{1000.0000000, 1116.2075195}};
			case 423:
				return {{1000.0000000, 1116.2076416}};
			case 424:
				return {{1000.0000000, 1116.2076416}};
			case 425:
				return {{1000.0000000, 1116.2076416}};
			case 426:
				return {{1000.0000000, 1116.2076416}};
			case 427:
				return {{1000.0000000, 1116.2076416}};
			case 428:
				return {{1000.0000000, 1116.2076416}};
			case 429:
				return {{1000.0000000, 1116.2076416}};
			case 430:
				return {{1000.0000000, 1116.2076416}};
			case 431:
				return {{1000.0000000, 1116.2076416}};
			case 432:
				return {{1000.0000000, 1116.2076416}};
			case 433:
				return {{1000.0000000, 1116.2076416}};
			case 434:
				return {{1000.0000000, 1116.2076416}};
			case 435:
				return {{1000.0000000, 1116.2076416}};
			case 436:
				return {{1000.0000000, 1116.2076416}};
			case 437:
				return {{1000.0000000, 1116.2077637}};
			case 438:
				return {{1000.0000000, 1116.2077637}};
			case 439:
				return {{1000.0000000, 1116.2077637}};
			case 440:
				return {{1000.0000000, 1116.2077637}};
			case 441:
				return {{1000.0000000, 1116.2076416}};
			case 442:
				return {{1000.0000000, 1116.2076416}};
			case 443:
				return {{1000.0000000, 1116.2076416}};
			case 444:
				return {{1000.0000000, 1116.2076416}};
			case 445:
				return {{1000.0000000, 1116.2076416}};
			case 446:
				return {{1000.0000000, 1116.2076416}};
			case 447:
				return {{1000.0000000, 1116.2076416}};
			case 448:
				return {{1000.0000000, 1116.2076416}};
			case 449:
				return {{1000.0000000, 1116.2076416}};
			case 450:
				return {{1000.0000000, 1116.2077637}};
			case 451:
				return {{1000.0000000, 1116.2077637}};
			case 452:
				return {{1000.0000000, 1116.2077637}};
			case 453:
				return {{1000.0000000, 1116.2077637}};
			case 454:
				return {{1000.0000000, 1116.2077637}};
			case 455:
				return {{1000.0000000, 1116.2077637}};
			case 456:
				return {{1000.0000000, 1116.2077637}};
			case 457:
				return {{1000.0000000, 1116.2077637}};
			case 458:
				return {{1000.0000000, 1116.2077637}};
			case 459:
				return {{1000.0000000, 1116.2077637}};
			case 460:
				return {{1000.0000000, 1116.2077637}};
			case 461:
				return {{1000.0000000, 1116.2077637}};
			case 462:
				return {{1000.0000000, 1116.2077637}};
			case 463:
				return {{1000.0000000, 1116.2077637}};
			case 464:
				return {{1000.0000000, 1116.2077637}};
			case 465:
				return {{1000.0000000, 1116.2077637}};
			case 466:
				return {{1000.0000000, 1116.2077637}};
			case 467:
				return {{1000.0000000, 1116.2077637}};
			case 468:
				return {{1000.0000000, 1116.2077637}};
			case 469:
				return {{1000.0000000, 1116.2077637}};
			case 470:
				return {{1000.0000000, 1116.2077637}};
			case 471:
				return {{1000.0000000, 1116.2077637}};
			case 472:
				return {{1000.0000000, 1116.2077637}};
			case 473:
				return {{1000.0000000, 1116.2077637}};
			case 474:
				return {{1000.0000000, 1116.2077637}};
			case 475:
				return {{1000.0000000, 1116.2077637}};
			case 476:
				return {{1000.0000000, 1116.2077637}};
			case 477:
				return {{1000.0000000, 1116.2077637}};
			case 478:
				return {{1000.0000000, 1116.2077637}};
			case 479:
				return {{1000.0000000, 1116.2077637}};
			case 480:
				return {{1000.0000000, 1116.2077637}};
			case 481:
				return {{1000.0000000, 1116.2077637}};
			case 482:
				return {{1000.0000000, 1116.2077637}};
			case 483:
				return {{1000.0000000, 1116.2077637}};
			case 484:
				return {{1000.0000000, 1116.2077637}};
			case 485:
				return {{1000.0000000, 1116.2077637}};
			case 486:
				return {{1000.0000000, 1116.2077637}};
			case 487:
				return {{1000.0000000, 1116.2077637}};
			case 488:
				return {{1000.0000000, 1116.2077637}};
			case 489:
				return {{1000.0000000, 1116.2077637}};
			case 490:
				return {{1000.0000000, 1116.2077637}};
			case 491:
				return {{1000.0000000, 1116.2077637}};
			case 492:
				return {{1000.0000000, 1116.2077637}};
			case 493:
				return {{1000.0000000, 1116.2077637}};
			case 494:
				return {{1000.0000000, 1116.2077637}};
			case 495:
				return {{1000.0000000, 1116.2077637}};
			case 496:
				return {{1000.0000000, 1116.2077637}};
			case 497:
				return {{1000.0000000, 1116.2077637}};
			case 498:
				return {{1000.0000000, 1116.2077637}};
			case 499:
				return {{1000.0000000, 1116.2077637}};
			case 500:
				return {{1000.0000000, 1116.2077637}};
			case 501:
				return {{1000.0000000, 1116.2077637}};
			case 502:
				return {{1000.0000000, 1116.2077637}};
			case 503:
				return {{1000.0000000, 1116.2080078}};
			case 504:
				return {{1000.0000000, 1116.2073975}};
			case 505:
				return {{1000.0000000, 1116.2075195}};
			case 506:
				return {{1000.0000000, 1116.2075195}};
			case 507:
				return {{1000.0000000, 1116.2071533}};
			case 508:
				return {{1000.0000000, 1116.2077637}};
			case 509:
				return {{1000.0000000, 1116.2070312}};
			case 510:
				return {{1000.0000000, 1116.2075195}};
			case 511:
				return {{1000.0000000, 1116.2075195}};
			case 512:
				return {{1000.0000000, 1116.2071533}};
			case 513:
				return {{1000.0000000, 1116.2075195}};
			case 514:
				return {{1000.0000000, 1116.2077637}};
			case 515:
				return {{1000.0000000, 1116.2075195}};
			case 516:
				return {{1000.0000000, 1116.2075195}};
			case 517:
				return {{1000.0000000, 1116.2080078}};
			case 518:
				return {{1000.0000000, 1116.2069092}};
			case 519:
				return {{1000.0000000, 1116.2071533}};
			case 520:
				return {{1000.0000000, 1116.2071533}};
			case 521:
				return {{1000.0000000, 1116.2075195}};
			case 522:
				return {{1000.0000000, 1116.2073975}};
			case 523:
				return {{1000.0000000, 1116.2075195}};
			case 524:
				return {{1000.0000000, 1116.2073975}};
			case 525:
				return {{1000.0000000, 1116.2077637}};
			case 526:
				return {{1000.0000000, 1116.2075195}};
			case 527:
				return {{1000.0000000, 1116.2077637}};
			case 528:
				return {{1000.0000000, 1116.2078857}};
			case 529:
				return {{1000.0000000, 1116.2080078}};
			case 530:
				return {{1000.0000000, 1116.2077637}};
			case 531:
				return {{1000.0000000, 1116.2073975}};
			case 532:
				return {{1000.0000000, 1116.2073975}};
			case 533:
				return {{1000.0000000, 1116.2077637}};
			case 534:
				return {{1000.0000000, 1116.2080078}};
			case 535:
				return {{1000.0000000, 1116.2073975}};
			case 536:
				return {{1000.0000000, 1116.2075195}};
			case 537:
				return {{1000.0000000, 1116.2070312}};
			case 538:
				return {{1000.0000000, 1116.2076416}};
			case 539:
				return {{1000.0000000, 1116.2071533}};
			case 540:
				return {{1000.0000000, 1116.2073975}};
			case 541:
				return {{1000.0000000, 1116.2076416}};
			case 542:
				return {{1000.0000000, 1116.2073975}};
			case 543:
				return {{1000.0000000, 1116.2071533}};
			case 544:
				return {{1000.0000000, 1116.2080078}};
			case 545:
				return {{1000.0000000, 1116.2077637}};
			case 546:
				return {{1000.0000000, 1116.2067871}};
			case 547:
				return {{1000.0000000, 1116.2075195}};
			case 548:
				return {{1000.0000000, 1116.2072754}};
			case 549:
				return {{1000.0000000, 1116.2078857}};
			case 550:
				return {{1000.0000000, 1116.2078857}};
			case 551:
				return {{1000.0000000, 1116.2071533}};
			case 552:
				return {{1000.0000000, 1116.2073975}};
			case 553:
				return {{1000.0000000, 1116.2075195}};
			case 554:
				return {{1000.0000000, 1116.2080078}};
			case 555:
				return {{1000.0000000, 1116.2077637}};
			case 556:
				return {{1000.0000000, 1116.2071533}};
			case 557:
				return {{1000.0000000, 1116.2080078}};
			case 558:
				return {{1000.0000000, 1116.2075195}};
			case 559:
				return {{1000.0000000, 1116.2080078}};
			case 560:
				return {{1000.0000000, 1116.2075195}};
			case 561:
				return {{1000.0000000, 1116.2073975}};
			case 562:
				return {{1000.0000000, 1116.2071533}};
			case 563:
				return {{1000.0000000, 1116.2070312}};
			case 564:
				return {{1000.0000000, 1116.2073975}};
			case 565:
				return {{1000.0000000, 1116.2072754}};
			case 566:
				return {{1000.0000000, 1116.2071533}};
			case 567:
				return {{1000.0000000, 1116.2075195}};
			case 568:
				return {{1000.0000000, 1116.2073975}};
			case 569:
				return {{1000.0000000, 1116.2076416}};
			case 570:
				return {{1000.0000000, 1116.2076416}};
			case 571:
				return {{1000.0000000, 1116.2073975}};
			case 572:
				return {{1000.0000000, 1116.2072754}};
			case 573:
				return {{1000.0000000, 1116.2072754}};
			case 574:
				return {{1000.0000000, 1116.2080078}};
			case 575:
				return {{1000.0000000, 1116.2080078}};
			case 576:
				return {{1000.0000000, 1116.2080078}};
			case 577:
				return {{1000.0000000, 1116.2071533}};
			case 578:
				return {{1000.0000000, 1116.2077637}};
			case 579:
				return {{1000.0000000, 1116.2076416}};
			case 580:
				return {{1000.0000000, 1116.2078857}};
			case 581:
				return {{1000.0000000, 1116.2072754}};
			case 582:
				return {{1000.0000000, 1116.2072754}};
			case 583:
				return {{1000.0000000, 1116.2067871}};
			case 584:
				return {{1000.0000000, 1116.2073975}};
			case 585:
				return {{1000.0000000, 1116.2075195}};
			case 586:
				return {{1000.0000000, 1116.2080078}};
			case 587:
				return {{1000.0000000, 1116.2080078}};
			case 588:
				return {{1000.0000000, 1116.2080078}};
			case 589:
				return {{1000.0000000, 1116.2078857}};
			case 590:
				return {{1000.0000000, 1116.2077637}};
			case 591:
				return {{1000.0000000, 1116.2069092}};
			case 592:
				return {{1000.0000000, 1116.2073975}};
			case 593:
				return {{1000.0000000, 1116.2073975}};
			case 594:
				return {{1000.0000000, 1116.2070312}};
			case 595:
				return {{1000.0000000, 1116.2073975}};
			case 596:
				return {{1000.0000000, 1116.2072754}};
			case 597:
				return {{1000.0000000, 1116.2075195}};
			case 598:
				return {{1000.0000000, 1116.2080078}};
			case 599:
				return {{1000.0000000, 1116.2080078}};
			case 600:
				return {{1000.0000000, 1116.2077637}};
			case 601:
				return {{1000.0000000, 1116.2076416}};
			case 602:
				return {{1000.0000000, 1116.2080078}};
			case 603:
				return {{1000.0000000, 1116.2073975}};
			case 604:
				return {{1000.0000000, 1116.2073975}};
			case 605:
				return {{1000.0000000, 1116.2080078}};
			case 606:
				return {{1000.0000000, 1116.2073975}};
			case 607:
				return {{1000.0000000, 1116.2083740}};
			case 608:
				return {{1000.0000000, 1116.2077637}};
			case 609:
				return {{1000.0000000, 1116.2067871}};
			case 610:
				return {{1000.0000000, 1116.2075195}};
			case 611:
				return {{1000.0000000, 1116.2069092}};
			case 612:
				return {{1000.0000000, 1116.2077637}};
			case 613:
				return {{1000.0000000, 1116.2080078}};
			case 614:
				return {{1000.0000000, 1116.2080078}};
			case 615:
				return {{1000.0000000, 1116.2075195}};
			case 616:
				return {{1000.0000000, 1116.2083740}};
			case 617:
				return {{1000.0000000, 1116.2084961}};
			case 618:
				return {{1000.0000000, 1116.2075195}};
			case 619:
				return {{1000.0000000, 1116.2080078}};
			case 620:
				return {{1000.0000000, 1116.2083740}};
			case 621:
				return {{1000.0000000, 1116.2076416}};
			case 622:
				return {{1000.0000000, 1116.2076416}};
			case 623:
				return {{1000.0000000, 1116.2077637}};
			case 624:
				return {{1000.0000000, 1116.2070312}};
			case 625:
				return {{1000.0000000, 1116.2075195}};
			case 626:
				return {{1000.0000000, 1116.2080078}};
			case 627:
				return {{1000.0000000, 1116.2080078}};
			case 628:
				return {{1000.0000000, 1116.2070312}};
			case 629:
				return {{1000.0000000, 1116.2082520}};
			case 630:
				return {{1000.0000000, 1116.2065430}};
			case 631:
				return {{1000.0000000, 1116.2076416}};
			case 632:
				return {{1000.0000000, 1116.2080078}};
			case 633:
				return {{1000.0000000, 1116.2075195}};
			case 634:
				return {{1000.0000000, 1116.2073975}};
			case 635:
				return {{1000.0000000, 1116.2070312}};
			case 636:
				return {{1000.0000000, 1116.2070312}};
			case 637:
				return {{1000.0000000, 1116.2072754}};
			case 638:
				return {{1000.0000000, 1116.2075195}};
			case 639:
				return {{1000.0000000, 1116.2071533}};
			case 640:
				return {{1000.0000000, 1116.2075195}};
			case 641:
				return {{1000.0000000, 1116.2072754}};
			case 642:
				return {{1000.0000000, 1116.2071533}};
			case 643:
				return {{1000.0000000, 1116.2072754}};
			case 644:
				return {{1000.0000000, 1116.2076416}};
			case 645:
				return {{1000.0000000, 1116.2072754}};
			case 646:
				return {{1000.0000000, 1116.2070312}};
			case 647:
				return {{1000.0000000, 1116.2076416}};
			case 648:
				return {{1000.0000000, 1116.2076416}};
			case 649:
				return {{1000.0000000, 1116.2083740}};
			case 650:
				return {{1000.0000000, 1116.2076416}};
			case 651:
				return {{1000.0000000, 1116.2067871}};
			case 652:
				return {{1000.0000000, 1116.2073975}};
			case 653:
				return {{1000.0000000, 1116.2077637}};
			case 654:
				return {{1000.0000000, 1116.2072754}};
			case 655:
				return {{1000.0000000, 1116.2080078}};
			case 656:
				return {{1000.0000000, 1116.2067871}};
			case 657:
				return {{1000.0000000, 1116.2075195}};
			case 658:
				return {{1000.0000000, 1116.2070312}};
			case 659:
				return {{1000.0000000, 1116.2080078}};
			case 660:
				return {{1000.0000000, 1116.2080078}};
			case 661:
				return {{1000.0000000, 1116.2071533}};
			case 662:
				return {{1000.0000000, 1116.2076416}};
			case 663:
				return {{1000.0000000, 1116.2070312}};
			case 664:
				return {{1000.0000000, 1116.2084961}};
			case 665:
				return {{1000.0000000, 1116.2077637}};
			case 666:
				return {{1000.0000000, 1116.2075195}};
			case 667:
				return {{1000.0000000, 1116.2073975}};
			case 668:
				return {{1000.0000000, 1116.2072754}};
			case 669:
				return {{1000.0000000, 1116.2077637}};
			case 670:
				return {{1000.0000000, 1116.2082520}};
			case 671:
				return {{1000.0000000, 1116.2075195}};
			case 672:
				return {{1000.0000000, 1116.2071533}};
			case 673:
				return {{1000.0000000, 1116.2077637}};
			case 674:
				return {{1000.0000000, 1116.2073975}};
			case 675:
				return {{1000.0000000, 1116.2071533}};
			case 676:
				return {{1000.0000000, 1116.2071533}};
			case 677:
				return {{1000.0000000, 1116.2082520}};
			case 678:
				return {{1000.0000000, 1116.2075195}};
			case 679:
				return {{1000.0000000, 1116.2080078}};
			case 680:
				return {{1000.0000000, 1116.2071533}};
			case 681:
				return {{1000.0000000, 1116.2071533}};
			case 682:
				return {{1000.0000000, 1116.2078857}};
			case 683:
				return {{1000.0000000, 1116.2077637}};
			case 684:
				return {{1000.0000000, 1116.2077637}};
			case 685:
				return {{1000.0000000, 1116.2077637}};
			case 686:
				return {{1000.0000000, 1116.2075195}};
			case 687:
				return {{1000.0000000, 1116.2077637}};
			case 688:
				return {{1000.0000000, 1116.2071533}};
			case 689:
				return {{1000.0000000, 1116.2075195}};
			case 690:
				return {{1000.0000000, 1116.2080078}};
			case 691:
				return {{1000.0000000, 1116.2080078}};
			case 692:
				return {{1000.0000000, 1116.2080078}};
			case 693:
				return {{1000.0000000, 1116.2078857}};
			case 694:
				return {{1000.0000000, 1116.2072754}};
			case 695:
				return {{1000.0000000, 1116.2071533}};
			case 696:
				return {{1000.0000000, 1116.2075195}};
			case 697:
				return {{1000.0000000, 1116.2073975}};
			case 698:
				return {{1000.0000000, 1116.2080078}};
			case 699:
				return {{1000.0000000, 1116.2075195}};
			case 700:
				return {{1000.0000000, 1116.2070312}};
			case 701:
				return {{1000.0000000, 1116.2080078}};
			case 702:
				return {{1000.0000000, 1116.2084961}};
			case 703:
				return {{1000.0000000, 1116.2082520}};
			case 704:
				return {{1000.0000000, 1116.2082520}};
			case 705:
				return {{1000.0000000, 1116.2075195}};
			case 706:
				return {{1000.0000000, 1116.2072754}};
			case 707:
				return {{1000.0000000, 1116.2073975}};
			case 708:
				return {{1000.0000000, 1116.2072754}};
			case 709:
				return {{1000.0000000, 1116.2070312}};
			case 710:
				return {{1000.0000000, 1116.2070312}};
			case 711:
				return {{1000.0000000, 1116.2069092}};
			case 712:
				return {{1000.0000000, 1116.2069092}};
			case 713:
				return {{1000.0000000, 1116.2067871}};
			case 714:
				return {{1000.0000000, 1116.2067871}};
			case 715:
				return {{1000.0000000, 1116.2067871}};
			case 716:
				return {{1000.0000000, 1116.2082520}};
			case 717:
				return {{1000.0000000, 1116.2080078}};
			case 718:
				return {{1000.0000000, 1116.2075195}};
			case 719:
				return {{1000.0000000, 1116.2080078}};
			case 720:
				return {{1000.0000000, 1116.2078857}};
			case 721:
				return {{1000.0000000, 1116.2078857}};
			case 722:
				return {{1000.0000000, 1116.2078857}};
			case 723:
				return {{1000.0000000, 1116.2078857}};
			case 724:
				return {{1000.0000000, 1116.2078857}};
			case 725:
				return {{1000.0000000, 1116.2078857}};
			case 726:
				return {{1000.0000000, 1116.2077637}};
			case 727:
				return {{1000.0000000, 1116.2077637}};
			case 728:
				return {{1000.0000000, 1116.2078857}};
			case 729:
				return {{1000.0000000, 1116.2077637}};
			case 730:
				return {{1000.0000000, 1116.2077637}};
			case 731:
				return {{1000.0000000, 1116.2077637}};
			case 732:
				return {{1000.0000000, 1116.2077637}};
			case 733:
				return {{1000.0000000, 1116.2077637}};
			case 734:
				return {{1000.0000000, 1116.2077637}};
			case 735:
				return {{1000.0000000, 1116.2077637}};
			case 736:
				return {{1000.0000000, 1116.2077637}};
			case 737:
				return {{1000.0000000, 1116.2077637}};
			case 738:
				return {{1000.0000000, 1116.2077637}};
			case 739:
				return {{1000.0000000, 1116.2077637}};
			case 740:
				return {{1000.0000000, 1116.2077637}};
			case 741:
				return {{1000.0000000, 1116.2077637}};
			case 742:
				return {{1000.0000000, 1116.2077637}};
			case 743:
				return {{1000.0000000, 1116.2077637}};
			case 744:
				return {{1000.0000000, 1116.2077637}};
			case 745:
				return {{1000.0000000, 1116.2077637}};
			case 746:
				return {{1000.0000000, 1116.2077637}};
			case 747:
				return {{1000.0000000, 1116.2077637}};
			case 748:
				return {{1000.0000000, 1116.2077637}};
			case 749:
				return {{1000.0000000, 1116.2077637}};
			case 750:
				return {{1000.0000000, 1116.2077637}};
			case 751:
				return {{1000.0000000, 1116.2077637}};
			case 752:
				return {{1000.0000000, 1116.2077637}};
			case 753:
				return {{1000.0000000, 1116.2077637}};
			case 754:
				return {{1000.0000000, 1116.2077637}};
			case 755:
				return {{1000.0000000, 1116.2077637}};
			case 756:
				return {{1000.0000000, 1116.2077637}};
			case 757:
				return {{1000.0000000, 1116.2077637}};
			case 758:
				return {{1000.0000000, 1116.2077637}};
			case 759:
				return {{1000.0000000, 1116.2077637}};
			case 760:
				return {{1000.0000000, 1116.2077637}};
			case 761:
				return {{1000.0000000, 1116.2077637}};
			case 762:
				return {{1000.0000000, 1116.2077637}};
			case 763:
				return {{1000.0000000, 1116.2077637}};
			case 764:
				return {{1000.0000000, 1116.2077637}};
			case 765:
				return {{1000.0000000, 1116.2077637}};
			case 766:
				return {{1000.0000000, 1116.2077637}};
			case 767:
				return {{1000.0000000, 1116.2077637}};
			case 768:
				return {{1000.0000000, 1116.2077637}};
			case 769:
				return {{1000.0000000, 1116.2077637}};
			case 770:
				return {{1000.0000000, 1116.2077637}};
			case 771:
				return {{1000.0000000, 1116.2077637}};
			case 772:
				return {{1000.0000000, 1116.2077637}};
			case 773:
				return {{1000.0000000, 1116.2077637}};
			case 774:
				return {{1000.0000000, 1116.2077637}};
			case 775:
				return {{1000.0000000, 1116.2077637}};
			case 776:
				return {{1000.0000000, 1116.2077637}};
			case 777:
				return {{1000.0000000, 1116.2077637}};
			case 778:
				return {{1000.0000000, 1116.2077637}};
			case 779:
				return {{1000.0000000, 1116.2077637}};
			case 780:
				return {{1000.0000000, 1116.2077637}};
			case 781:
				return {{1000.0000000, 1116.2077637}};
			case 782:
				return {{1000.0000000, 1116.2077637}};
			case 783:
				return {{1000.0000000, 1116.2077637}};
			case 784:
				return {{1000.0000000, 1116.2077637}};
			case 785:
				return {{1000.0000000, 1116.2077637}};
			case 786:
				return {{1000.0000000, 1116.2077637}};
			case 787:
				return {{1000.0000000, 1116.2077637}};
			case 788:
				return {{1000.0000000, 1116.2077637}};
			case 789:
				return {{1000.0000000, 1116.2077637}};
			case 790:
				return {{1000.0000000, 1116.2077637}};
			case 791:
				return {{1000.0000000, 1116.2077637}};
			case 792:
				return {{1000.0000000, 1116.2077637}};
			case 793:
				return {{1000.0000000, 1116.2077637}};
			case 794:
				return {{1000.0000000, 1116.2077637}};
			case 795:
				return {{1000.0000000, 1116.2077637}};
			case 796:
				return {{1000.0000000, 1116.2077637}};
			case 797:
				return {{1000.0000000, 1116.2077637}};
			case 798:
				return {{1000.0000000, 1116.2077637}};
			case 799:
				return {{1000.0000000, 1116.2077637}};
			case 800:
				return {{1000.0000000, 1116.2077637}};
			case 801:
				return {{1000.0000000, 1116.2077637}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[9])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 9.0254517f}};
			case 202:
				return {{1000.0000000f, 1075.0816650f}};
			case 301:
				return {{1000.0000000, 1116.3481445}};
			case 502:
				return {{1000.0000000, 1116.6738281}};
			case 601:
				return {{1000.0000000, 1118.5781250}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[10])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 3.4066925f}};
			case 202:
				return {{1000.0000000, 1097.5006104f}};
			case 301:
				return {{1000.0000000, 1116.8032227}};
			case 502:
				return {{1000.0000000, 1117.0852051}};
			case 601:
				return {{1000.0000000, 1120.6666260}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[11])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -0.9229774f}};
			case 202:
				return {{1000.0000000, 1104.8607178f}};
			case 301:
				return {{1000.0000000, 1117.1820068}};
			case 502:
				return {{1000.0000000, 1117.4323730}};
			case 601:
				return {{1000.0000000, 1122.4295654}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[12])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -4.5307636f}};
			case 202:
				return {{1000.0000000, 1108.6668701f}};
			case 301:
				return {{1000.0000000, 1117.5192871}};
			case 502:
				return {{1000.0000000, 1117.7443848}};
			case 601:
				return {{1000.0000000, 1124.0136719}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[13] || (screenCoord + glm::u16vec2(0, 1)) == k_ScreenCentreLine[13])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -7.4373074f}};
			case 202:
				return {{1000.0000000, 1110.8963623}};
			case 301:
				return {{1000.0000000, 1117.8066406}};
			case 502:
				return {{1000.0000000, 1118.0120850}};
			case 601:
				return {{1000.0000000, 1125.3754883}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[14])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -9.9486294f}};
			case 202:
				return {{1000.0000000, 1112.4274902}};
			case 301:
				return {{1000.0000000, 1118.0667725}};
			case 502:
				return {{1000.0000000, 1118.2569580}};
			case 601:
				return {{1000.0000000, 1126.6199951}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[15])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -12.0339508f}};
			case 202:
				return {{1000.0000000, 1113.4934082}};
			case 301:
				return {{1000.0000000, 1118.2915039}};
			case 502:
				return {{1000.0000000, 1118.4704590}};
			case 601:
				return {{1000.0000000, 1127.7036133}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_MockMousePos)
		{
			switch (frameNumber)
			{
			case 0:
				return {{15.8141842, -13.4212151}};
			case 1:
				return {{998.6565552, 1118.0327148}};
			case 2:
				return {{998.6566772, 1118.0330811}};
			case 3:
				return {{998.6575928, 1118.0344238}};
			case 4:
				return {{998.6578369, 1118.0350342}};
			case 5:
				return {{998.6578979, 1118.0350342}};
			case 6:
				return {{998.6578979, 1118.0351562}};
			case 7:
				return {{998.6581421, 1118.0354004}};
			case 8:
				return {{998.6581421, 1118.0354004}};
			case 9:
				return {{998.6583862, 1118.0360107}};
			case 10:
				return {{998.6583862, 1118.0361328}};
			case 11:
				return {{998.6583862, 1118.0361328}};
			case 12:
				return {{998.6585083, 1118.0363770}};
			case 13:
				return {{998.6585083, 1118.0363770}};
			case 14:
				return {{998.6585083, 1118.0363770}};
			case 15:
				return {{998.6585083, 1118.0363770}};
			case 16:
				return {{998.6586914, 1118.0366211}};
			case 17:
				return {{998.6586914, 1118.0366211}};
			case 18:
				return {{998.6588135, 1118.0368652}};
			case 19:
				return {{998.6589355, 1118.0369873}};
			case 20:
				return {{998.6591187, 1118.0371094}};
			case 21:
				return {{998.6591187, 1118.0371094}};
			case 22:
				return {{998.6591187, 1118.0375977}};
			case 23:
				return {{998.6591187, 1118.0375977}};
			case 24:
				return {{998.6593018, 1118.0377197}};
			case 25:
				return {{998.6593018, 1118.0377197}};
			case 26:
				return {{998.6593628, 1118.0378418}};
			case 27:
				return {{998.6593628, 1118.0378418}};
			case 28:
				return {{998.6593628, 1118.0378418}};
			case 29:
				return {{998.6594238, 1118.0379639}};
			case 30:
				return {{998.6594238, 1118.0380859}};
			case 31:
				return {{998.6594238, 1118.0380859}};
			case 32:
				return {{998.6595459, 1118.0380859}};
			case 33:
				return {{998.6595459, 1118.0380859}};
			case 34:
				return {{998.6596069, 1118.0382080}};
			case 35:
				return {{998.6596069, 1118.0382080}};
			case 36:
				return {{998.6596680, 1118.0382080}};
			case 37:
				return {{998.6596680, 1118.0382080}};
			case 38:
				return {{998.6596680, 1118.0382080}};
			case 39:
				return {{998.6050415, 1117.9583740}};
			case 40:
				return {{998.6004639, 1117.9519043}};
			case 41:
				return {{998.5250854, 1117.8411865}};
			case 42:
				return {{998.5202026, 1117.8342285}};
			case 43:
				return {{998.4447632, 1117.7239990}};
			case 44:
				return {{998.3740845, 1117.6204834}};
			case 45:
				return {{998.2989502, 1117.5107422}};
			case 46:
				return {{998.2943726, 1117.5034180}};
			case 47:
				return {{998.2241821, 1117.4010010}};
			case 48:
				return {{998.2192993, 1117.3937988}};
			case 49:
				return {{998.1444702, 1117.2852783}};
			case 50:
				return {{998.1400146, 1117.2783203}};
			case 51:
				return {{998.0661011, 1117.1699219}};
			case 52:
				return {{998.0614624, 1117.1633301}};
			case 53:
				return {{997.9931030, 1117.0632324}};
			case 54:
				return {{997.9883423, 1117.0559082}};
			case 55:
				return {{997.9157104, 1116.9499512}};
			case 56:
				return {{997.9113770, 1116.9432373}};
			case 57:
				return {{997.8395996, 1116.8388672}};
			case 58:
				return {{997.8350830, 1116.8316650}};
			case 59:
				return {{997.7686157, 1116.7346191}};
			case 60:
				return {{997.7645264, 1116.7280273}};
			case 61:
				return {{997.6946411, 1116.6263428}};
			case 62:
				return {{997.6901855, 1116.6201172}};
			case 63:
				return {{997.6260376, 1116.5261230}};
			case 64:
				return {{997.6213379, 1116.5197754}};
			case 65:
				return {{997.5543213, 1116.4202881}};
			case 66:
				return {{997.4876709, 1116.3229980}};
			case 67:
				return {{997.4268799, 1116.2340088}};
			case 68:
				return {{997.4226074, 1116.2282715}};
			case 69:
				return {{997.3584595, 1116.1345215}};
			case 70:
				return {{997.3546753, 1116.1284180}};
			case 71:
				return {{997.2918701, 1116.0371094}};
			case 72:
				return {{997.2882690, 1116.0312500}};
			case 73:
				return {{997.2311401, 1115.9484863}};
			case 74:
				return {{997.2274780, 1115.9427490}};
			case 75:
				return {{997.2233887, 1115.9372559}};
			case 76:
				return {{997.1643066, 1115.8500977}};
			case 77:
				return {{997.1604004, 1115.8443604}};
			case 78:
				return {{997.1060791, 1115.7656250}};
			case 79:
				return {{997.1025391, 1115.7595215}};
			case 80:
				return {{997.0460205, 1115.6776123}};
			case 81:
				return {{997.0431519, 1115.6727295}};
			case 82:
				return {{996.9878540, 1115.5917969}};
			case 83:
				return {{996.9848022, 1115.5877686}};
			case 84:
				return {{996.9347534, 1115.5148926}};
			case 85:
				return {{996.9316406, 1115.5096436}};
			case 86:
				return {{996.8798828, 1115.4344482}};
			case 87:
				return {{996.8767700, 1115.4294434}};
			case 88:
				return {{996.8270874, 1115.3565674}};
			case 89:
				return {{996.8242188, 1115.3520508}};
			case 90:
				return {{996.7781982, 1115.2857666}};
			case 91:
				return {{996.7322388, 1115.2180176}};
			case 92:
				return {{996.6903687, 1115.1567383}};
			case 93:
				return {{996.6872559, 1115.1528320}};
			case 94:
				return {{996.6439209, 1115.0891113}};
			case 95:
				return {{996.6413574, 1115.0844727}};
			case 96:
				return {{996.5997314, 1115.0242920}};
			case 97:
				return {{996.5974121, 1115.0205078}};
			case 98:
				return {{996.5593872, 1114.9663086}};
			case 99:
				return {{996.5569458, 1114.9620361}};
			case 100:
				return {{996.5190430, 1114.9064941}};
			case 101:
				return {{996.5166626, 1114.9024658}};
			case 102:
				return {{996.4803467, 1114.8493652}};
			case 103:
				return {{996.4471436, 1114.8009033}};
			case 104:
				return {{996.4453735, 1114.7979736}};
			case 105:
				return {{996.4117432, 1114.7495117}};
			case 106:
				return {{996.4096069, 1114.7465820}};
			case 107:
				return {{996.4075928, 1114.7440186}};
			case 108:
				return {{996.3780518, 1114.7004395}};
			case 109:
				return {{996.3764648, 1114.6977539}};
			case 110:
				return {{996.3460693, 1114.6536865}};
			case 111:
				return {{996.3442383, 1114.6506348}};
			case 112:
				return {{996.3157959, 1114.6094971}};
			case 113:
				return {{996.3142090, 1114.6070557}};
			case 114:
				return {{996.2634277, 1114.5322266}};
			case 115:
				return {{996.2390137, 1114.4976807}};
			case 116:
				return {{996.2378540, 1114.4953613}};
			case 117:
				return {{996.2164307, 1114.4639893}};
			case 118:
				return {{996.2153320, 1114.4620361}};
			case 119:
				return {{996.1939087, 1114.4304199}};
			case 120:
				return {{996.1929932, 1114.4294434}};
			case 121:
				return {{996.1745605, 1114.4014893}};
			case 122:
				return {{996.1728516, 1114.3999023}};
			case 123:
				return {{996.1718140, 1114.3980713}};
			case 124:
				return {{996.1535034, 1114.3715820}};
			case 125:
				return {{996.1361694, 1114.3464355}};
			case 126:
				return {{996.1347656, 1114.3447266}};
			case 127:
				return {{996.1205444, 1114.3227539}};
			case 128:
				return {{996.1194458, 1114.3221436}};
			case 129:
				return {{996.1185303, 1114.3204346}};
			case 130:
				return {{996.1038818, 1114.2991943}};
			case 131:
				return {{996.0902100, 1114.2783203}};
			case 132:
				return {{996.0897217, 1114.2772217}};
			case 133:
				return {{996.0779419, 1114.2603760}};
			case 134:
				return {{996.0769653, 1114.2600098}};
			case 135:
				return {{996.0654297, 1114.2429199}};
			case 136:
				return {{996.0649414, 1114.2418213}};
			case 137:
				return {{996.0555420, 1114.2282715}};
			case 138:
				return {{996.0457764, 1114.2138672}};
			case 139:
				return {{996.0378418, 1114.2017822}};
			case 140:
				return {{996.0368652, 1114.2006836}};
			case 141:
				return {{996.0293579, 1114.1906738}};
			case 142:
				return {{996.0292969, 1114.1895752}};
			case 143:
				return {{996.0226440, 1114.1788330}};
			case 144:
				return {{996.0218506, 1114.1791992}};
			case 145:
				return {{996.0155640, 1114.1700439}};
			case 146:
				return {{996.0155029, 1114.1693115}};
			case 147:
				return {{996.0106812, 1114.1623535}};
			case 148:
				return {{996.0104370, 1114.1616211}};
			case 149:
				return {{996.0059204, 1114.1550293}};
			case 150:
				return {{996.0051270, 1114.1542969}};
			case 151:
				return {{996.0014648, 1114.1489258}};
			case 152:
				return {{996.0012817, 1114.1485596}};
			case 153:
				return {{995.9979248, 1114.1435547}};
			case 154:
				return {{995.9971924, 1114.1424561}};
			case 155:
				return {{995.9947510, 1114.1383057}};
			case 156:
				return {{995.9942017, 1114.1379395}};
			case 157:
				return {{995.9913330, 1114.1345215}};
			case 158:
				return {{995.9914551, 1114.1347656}};
			case 159:
				return {{995.9893799, 1114.1317139}};
			case 160:
				return {{995.9888916, 1114.1317139}};
			case 161:
				return {{995.9858398, 1114.1260986}};
			case 162:
				return {{995.9853516, 1114.1248779}};
			case 163:
				return {{995.9848633, 1114.1246338}};
			case 164:
				return {{995.9840088, 1114.1234131}};
			case 165:
				return {{995.9839478, 1114.1235352}};
			case 166:
				return {{995.9832764, 1114.1224365}};
			case 167:
				return {{995.9831543, 1114.1213379}};
			case 168:
				return {{995.9825439, 1114.1206055}};
			case 169:
				return {{995.9827881, 1114.1210938}};
			case 170:
				return {{995.9824219, 1114.1206055}};
			case 171:
				return {{995.9821167, 1114.1203613}};
			case 172:
				return {{995.9817505, 1114.1198730}};
			case 173:
				return {{995.9819336, 1114.1199951}};
			case 174:
				return {{995.9816895, 1114.1196289}};
			case 175:
				return {{995.9813232, 1114.1198730}};
			case 176:
				return {{995.9811401, 1114.1196289}};
			case 177:
				return {{995.9811401, 1114.1197510}};
			case 178:
				return {{995.9810791, 1114.1196289}};
			case 179:
				return {{995.9812012, 1114.1191406}};
			case 180:
				return {{995.9811401, 1114.1190186}};
			case 181:
				return {{995.9811401, 1114.1191406}};
			case 182:
				return {{995.9811401, 1114.1190186}};
			case 183:
				return {{995.9811401, 1114.1190186}};
			case 184:
				return {{995.9811401, 1114.1191406}};
			case 185:
				return {{995.9811401, 1114.1191406}};
			case 186:
				return {{995.9811401, 1114.1191406}};
			case 187:
				return {{995.9811401, 1114.1191406}};
			case 188:
				return {{995.9811401, 1114.1191406}};
			case 189:
				return {{995.9811401, 1114.1191406}};
			case 190:
				return {{995.9812012, 1114.1191406}};
			case 191:
				return {{995.9811401, 1114.1191406}};
			case 192:
				return {{995.9812012, 1114.1191406}};
			case 193:
				return {{995.9812012, 1114.1191406}};
			case 194:
				return {{995.9812012, 1114.1191406}};
			case 195:
				return {{995.9812012, 1114.1191406}};
			case 196:
				return {{995.9812012, 1114.1191406}};
			case 197:
				return {{995.9811401, 1114.1197510}};
			case 198:
				return {{995.9811401, 1114.1197510}};
			case 199:
				return {{995.9811401, 1114.1197510}};
			case 200:
				return {{995.9811401, 1114.1197510}};
			case 201:
				return {{995.9811401, 1114.1197510}};
			case 202:
				return {{995.9812012, 1114.1197510}};
			case 203:
				return {{995.9811401, 1114.1197510}};
			case 204:
				return {{995.9831543, 1114.1226807}};
			case 205:
				return {{995.9833374, 1114.1235352}};
			case 206:
				return {{995.9990845, 1114.1523438}};
			case 207:
				return {{996.0112305, 1114.1745605}};
			case 208:
				return {{996.0120239, 1114.1770020}};
			case 209:
				return {{996.0130615, 1114.1782227}};
			case 210:
				return {{996.0280762, 1114.2060547}};
			case 211:
				return {{996.0291138, 1114.2081299}};
			case 212:
				return {{996.0455933, 1114.2384033}};
			case 213:
				return {{996.0466309, 1114.2410889}};
			case 214:
				return {{996.0631714, 1114.2713623}};
			case 215:
				return {{996.0643311, 1114.2729492}};
			case 216:
				return {{996.0830078, 1114.3085938}};
			case 217:
				return {{996.0842285, 1114.3103027}};
			case 218:
				return {{996.1041870, 1114.3471680}};
			case 219:
				return {{996.1054077, 1114.3496094}};
			case 220:
				return {{996.1254272, 1114.3867188}};
			case 221:
				return {{996.1267090, 1114.3897705}};
			case 222:
				return {{996.1495361, 1114.4316406}};
			case 223:
				return {{996.1510010, 1114.4344482}};
			case 224:
				return {{996.1739502, 1114.4770508}};
			case 225:
				return {{996.1755371, 1114.4808350}};
			case 226:
				return {{996.2020264, 1114.5299072}};
			case 227:
				return {{996.2037354, 1114.5334473}};
			case 228:
				return {{996.2324219, 1114.5867920}};
			case 229:
				return {{996.2343750, 1114.5904541}};
			case 230:
				return {{996.2974854, 1114.7103271}};
			case 231:
				return {{996.3345337, 1114.7795410}};
			case 232:
				return {{996.3369141, 1114.7835693}};
			case 233:
				return {{996.3392334, 1114.7890625}};
			case 234:
				return {{996.3771973, 1114.8599854}};
			case 235:
				return {{996.4207764, 1114.9433594}};
			case 236:
				return {{996.4235840, 1114.9493408}};
			case 237:
				return {{996.4678345, 1115.0336914}};
			case 238:
				return {{996.4709473, 1115.0395508}};
			case 239:
				return {{996.5219116, 1115.1381836}};
			case 240:
				return {{996.5252686, 1115.1447754}};
			case 241:
				return {{996.5803223, 1115.2513428}};
			case 242:
				return {{996.5839233, 1115.2578125}};
			case 243:
				return {{996.6393433, 1115.3664551}};
			case 244:
				return {{996.6431885, 1115.3730469}};
			case 245:
				return {{996.7062378, 1115.4978027}};
			case 246:
				return {{996.7103271, 1115.5057373}};
			case 247:
				return {{996.7773438, 1115.6386719}};
			case 248:
				return {{996.7816162, 1115.6473389}};
			case 249:
				return {{996.8477783, 1115.7792969}};
			case 250:
				return {{996.8521729, 1115.7893066}};
			case 251:
				return {{996.9259644, 1115.9385986}};
			case 252:
				return {{996.9306030, 1115.9479980}};
			case 253:
				return {{996.9353027, 1115.9580078}};
			case 254:
				return {{997.0849609, 1116.2680664}};
			case 255:
				return {{997.1635742, 1116.4350586}};
			case 256:
				return {{997.1685181, 1116.4455566}};
			case 257:
				return {{997.2421265, 1116.6058350}};
			case 258:
				return {{997.2470703, 1116.6164551}};
			case 259:
				return {{997.2519531, 1116.6274414}};
			case 260:
				return {{997.3295898, 1116.7995605}};
			case 261:
				return {{997.3343506, 1116.8104248}};
			case 262:
				return {{997.4096069, 1116.9821777}};
			case 263:
				return {{997.4142456, 1116.9930420}};
			case 264:
				return {{997.4817505, 1117.1519775}};
			case 265:
				return {{997.5500488, 1117.3173828}};
			case 266:
				return {{997.5540771, 1117.3281250}};
			case 267:
				return {{997.6135864, 1117.4768066}};
			case 268:
				return {{997.6174316, 1117.4866943}};
			case 269:
				return {{997.6750488, 1117.6363525}};
			case 270:
				return {{997.6784668, 1117.6457520}};
			case 271:
				return {{997.7292480, 1117.7839355}};
			case 272:
				return {{997.7322388, 1117.7917480}};
			case 273:
				return {{997.7733154, 1117.9072266}};
			case 274:
				return {{997.7758179, 1117.9147949}};
			case 275:
				return {{997.7782593, 1117.9217529}};
			case 276:
				return {{997.8144531, 1118.0281982}};
			case 277:
				return {{997.8164673, 1118.0338135}};
			case 278:
				return {{997.8184814, 1118.0402832}};
			case 279:
				return {{997.8471680, 1118.1276855}};
			case 280:
				return {{997.8685913, 1118.1947021}};
			case 281:
				return {{997.8863525, 1118.2524414}};
			case 282:
				return {{997.8873291, 1118.2556152}};
			case 283:
				return {{997.8882446, 1118.2583008}};
			case 284:
				return {{997.9006348, 1118.2994385}};
			case 285:
				return {{997.9013672, 1118.3018799}};
			case 286:
				return {{997.9020996, 1118.3041992}};
			case 287:
				return {{997.9119263, 1118.3370361}};
			case 288:
				return {{997.9124756, 1118.3388672}};
			case 289:
				return {{997.9129639, 1118.3409424}};
			case 290:
				return {{997.9202881, 1118.3657227}};
			case 291:
				return {{997.9206543, 1118.3669434}};
			case 292:
				return {{997.9211426, 1118.3687744}};
			case 293:
				return {{997.9266357, 1118.3879395}};
			case 294:
				return {{997.9270020, 1118.3891602}};
			case 295:
				return {{997.9321289, 1118.4074707}};
			case 296:
				return {{997.9324951, 1118.4082031}};
			case 297:
				return {{997.9328003, 1118.4093018}};
			case 298:
				return {{997.9377441, 1118.4267578}};
			case 299:
				return {{997.9381104, 1118.4281006}};
			case 300:
				return {{997.9383545, 1118.4291992}};
			case 301:
				return {{997.9431763, 1118.4461670}};
			case 302:
				return {{997.9434814, 1118.4470215}};
			case 303:
				return {{997.9482422, 1118.4639893}};
			case 304:
				return {{997.9484863, 1118.4649658}};
			case 305:
				return {{997.9486694, 1118.4656982}};
			case 306:
				return {{997.9523926, 1118.4792480}};
			case 307:
				return {{997.9527588, 1118.4804688}};
			case 308:
				return {{997.9562378, 1118.4934082}};
			case 309:
				return {{997.9594727, 1118.5050049}};
			case 310:
				return {{997.9596558, 1118.5057373}};
			case 311:
				return {{997.9625244, 1118.5161133}};
			case 312:
				return {{997.9626465, 1118.5167236}};
			case 313:
				return {{997.9628906, 1118.5173340}};
			case 314:
				return {{997.9656372, 1118.5279541}};
			case 315:
				return {{997.9658203, 1118.5283203}};
			case 316:
				return {{997.9660034, 1118.5289307}};
			case 317:
				return {{997.9686279, 1118.5386963}};
			case 318:
				return {{997.9687500, 1118.5395508}};
			case 319:
				return {{997.9711304, 1118.5484619}};
			case 320:
				return {{997.9711914, 1118.5484619}};
			case 321:
				return {{997.9713135, 1118.5491943}};
			case 322:
				return {{997.9736938, 1118.5581055}};
			case 323:
				return {{997.9737549, 1118.5589600}};
			case 324:
				return {{997.9739380, 1118.5590820}};
			case 325:
				return {{997.9759521, 1118.5667725}};
			case 326:
				return {{997.9760742, 1118.5672607}};
			case 327:
				return {{997.9761353, 1118.5673828}};
			case 328:
				return {{997.9781494, 1118.5753174}};
			case 329:
				return {{997.9782715, 1118.5753174}};
			case 330:
				return {{997.9783936, 1118.5759277}};
			case 331:
				return {{997.9801025, 1118.5827637}};
			case 332:
				return {{997.9802856, 1118.5832520}};
			case 333:
				return {{997.9803467, 1118.5838623}};
			case 334:
				return {{997.9818726, 1118.5895996}};
			case 335:
				return {{997.9819336, 1118.5897217}};
			case 336:
				return {{997.9820557, 1118.5900879}};
			case 337:
				return {{997.9833984, 1118.5957031}};
			case 338:
				return {{997.9834595, 1118.5957031}};
			case 339:
				return {{997.9835205, 1118.5963135}};
			case 340:
				return {{997.9847412, 1118.6008301}};
			case 341:
				return {{997.9848633, 1118.6009521}};
			case 342:
				return {{997.9858398, 1118.6047363}};
			case 343:
				return {{997.9866943, 1118.6080322}};
			case 344:
				return {{997.9873657, 1118.6110840}};
			case 345:
				return {{997.9874268, 1118.6110840}};
			case 346:
				return {{997.9874268, 1118.6110840}};
			case 347:
				return {{997.9880371, 1118.6137695}};
			case 348:
				return {{997.9880371, 1118.6137695}};
			case 349:
				return {{997.9885254, 1118.6153564}};
			case 350:
				return {{997.9885864, 1118.6153564}};
			case 351:
				return {{997.9885864, 1118.6154785}};
			case 352:
				return {{997.9888916, 1118.6170654}};
			case 353:
				return {{997.9888916, 1118.6170654}};
			case 354:
				return {{997.9891968, 1118.6182861}};
			case 355:
				return {{997.9891968, 1118.6182861}};
			case 356:
				return {{997.9891968, 1118.6182861}};
			case 357:
				return {{997.9893799, 1118.6186523}};
			case 358:
				return {{997.9894409, 1118.6186523}};
			case 359:
				return {{997.9895020, 1118.6191406}};
			case 360:
				return {{997.9895020, 1118.6191406}};
			case 361:
				return {{997.9895020, 1118.6191406}};
			case 362:
				return {{997.9895630, 1118.6192627}};
			case 363:
				return {{997.9895630, 1118.6192627}};
			case 364:
				return {{997.9895630, 1118.6192627}};
			case 365:
				return {{997.9896240, 1118.6198730}};
			case 366:
				return {{997.9896240, 1118.6198730}};
			case 367:
				return {{997.9896240, 1118.6198730}};
			case 368:
				return {{997.9896240, 1118.6198730}};
			case 369:
				return {{997.9896240, 1118.6198730}};
			case 370:
				return {{997.9896240, 1118.6198730}};
			case 371:
				return {{997.9896240, 1118.6198730}};
			case 372:
				return {{997.9896240, 1118.6198730}};
			case 373:
				return {{997.9896240, 1118.6198730}};
			case 374:
				return {{997.9895630, 1118.6192627}};
			case 375:
				return {{997.9895020, 1118.6191406}};
			case 376:
				return {{997.9895020, 1118.6191406}};
			case 377:
				return {{997.9895020, 1118.6191406}};
			case 378:
				return {{997.9895020, 1118.6191406}};
			case 379:
				return {{997.9895020, 1118.6191406}};
			case 380:
				return {{997.9895020, 1118.6191406}};
			case 381:
				return {{997.9894409, 1118.6186523}};
			case 382:
				return {{997.9894409, 1118.6186523}};
			case 383:
				return {{997.9894409, 1118.6186523}};
			case 384:
				return {{997.9894409, 1118.6186523}};
			case 385:
				return {{997.9893799, 1118.6186523}};
			case 386:
				return {{997.9893799, 1118.6186523}};
			case 387:
				return {{997.9893799, 1118.6186523}};
			case 388:
				return {{997.9893799, 1118.6186523}};
			case 389:
				return {{997.9892578, 1118.6184082}};
			case 390:
				return {{997.9892578, 1118.6184082}};
			case 391:
				return {{997.9892578, 1118.6184082}};
			case 392:
				return {{997.9892578, 1118.6184082}};
			case 393:
				return {{997.9892578, 1118.6184082}};
			case 394:
				return {{997.9892578, 1118.6184082}};
			case 395:
				return {{997.9892578, 1118.6184082}};
			case 396:
				return {{997.9892578, 1118.6184082}};
			case 397:
				return {{997.9892578, 1118.6184082}};
			case 398:
				return {{997.9891968, 1118.6182861}};
			case 399:
				return {{997.9891968, 1118.6182861}};
			case 400:
				return {{997.9891968, 1118.6182861}};
			case 401:
				return {{997.9891968, 1118.6175537}};
			case 402:
				return {{997.9891357, 1118.6175537}};
			case 403:
				return {{997.9891357, 1118.6175537}};
			case 404:
				return {{997.9891357, 1118.6175537}};
			case 405:
				return {{997.9891357, 1118.6174316}};
			case 406:
				return {{997.9891357, 1118.6174316}};
			case 407:
				return {{997.9890137, 1118.6174316}};
			case 408:
				return {{997.9890137, 1118.6174316}};
			case 409:
				return {{997.9890137, 1118.6174316}};
			case 410:
				return {{997.9890137, 1118.6174316}};
			case 411:
				return {{997.9890137, 1118.6174316}};
			case 412:
				return {{997.9890137, 1118.6174316}};
			case 413:
				return {{997.9891357, 1118.6174316}};
			case 414:
				return {{997.9890137, 1118.6174316}};
			case 415:
				return {{997.9890137, 1118.6174316}};
			case 416:
				return {{997.9891357, 1118.6174316}};
			case 417:
				return {{997.9890137, 1118.6174316}};
			case 418:
				return {{997.9891357, 1118.6174316}};
			case 419:
				return {{997.9891357, 1118.6174316}};
			case 420:
				return {{997.9891357, 1118.6174316}};
			case 421:
				return {{997.9891357, 1118.6174316}};
			case 422:
				return {{997.9891357, 1118.6174316}};
			case 423:
				return {{997.9891357, 1118.6174316}};
			case 424:
				return {{997.9891357, 1118.6174316}};
			case 425:
				return {{997.9891357, 1118.6174316}};
			case 426:
				return {{997.9891357, 1118.6174316}};
			case 427:
				return {{997.9891357, 1118.6174316}};
			case 428:
				return {{997.9891357, 1118.6174316}};
			case 429:
				return {{997.9891357, 1118.6174316}};
			case 430:
				return {{997.9891357, 1118.6174316}};
			case 431:
				return {{997.9891357, 1118.6174316}};
			case 432:
				return {{997.9891357, 1118.6174316}};
			case 433:
				return {{997.9891357, 1118.6174316}};
			case 434:
				return {{997.9891357, 1118.6174316}};
			case 435:
				return {{997.9891357, 1118.6174316}};
			case 436:
				return {{997.9891357, 1118.6174316}};
			case 437:
				return {{997.9891357, 1118.6174316}};
			case 438:
				return {{997.9891357, 1118.6174316}};
			case 439:
				return {{997.9891357, 1118.6174316}};
			case 440:
				return {{997.9891357, 1118.6174316}};
			case 441:
				return {{997.9891357, 1118.6174316}};
			case 442:
				return {{997.9891357, 1118.6174316}};
			case 443:
				return {{997.9891357, 1118.6174316}};
			case 444:
				return {{997.9891357, 1118.6174316}};
			case 445:
				return {{997.9891357, 1118.6174316}};
			case 446:
				return {{997.9891357, 1118.6174316}};
			case 447:
				return {{997.9891357, 1118.6174316}};
			case 448:
				return {{997.9891357, 1118.6174316}};
			case 449:
				return {{997.9891357, 1118.6174316}};
			case 450:
				return {{997.9891357, 1118.6174316}};
			case 451:
				return {{997.9891357, 1118.6174316}};
			case 452:
				return {{997.9891357, 1118.6174316}};
			case 453:
				return {{997.9891357, 1118.6174316}};
			case 454:
				return {{997.9891357, 1118.6174316}};
			case 455:
				return {{997.9891357, 1118.6174316}};
			case 456:
				return {{997.9891357, 1118.6174316}};
			case 457:
				return {{997.9891357, 1118.6174316}};
			case 458:
				return {{997.9891357, 1118.6174316}};
			case 459:
				return {{997.9891357, 1118.6174316}};
			case 460:
				return {{997.9891357, 1118.6174316}};
			case 461:
				return {{997.9891357, 1118.6174316}};
			case 462:
				return {{997.9891357, 1118.6174316}};
			case 463:
				return {{997.9891357, 1118.6174316}};
			case 464:
				return {{997.9891357, 1118.6174316}};
			case 465:
				return {{997.9891357, 1118.6174316}};
			case 466:
				return {{997.9891357, 1118.6174316}};
			case 467:
				return {{997.9891357, 1118.6174316}};
			case 468:
				return {{997.9891357, 1118.6174316}};
			case 469:
				return {{997.9891357, 1118.6174316}};
			case 470:
				return {{997.9891357, 1118.6174316}};
			case 471:
				return {{997.9891357, 1118.6174316}};
			case 472:
				return {{997.9891357, 1118.6174316}};
			case 473:
				return {{997.9891357, 1118.6174316}};
			case 474:
				return {{997.9891357, 1118.6174316}};
			case 475:
				return {{997.9891357, 1118.6174316}};
			case 476:
				return {{997.9891357, 1118.6174316}};
			case 477:
				return {{997.9891357, 1118.6174316}};
			case 478:
				return {{997.9891357, 1118.6174316}};
			case 479:
				return {{997.9891357, 1118.6174316}};
			case 480:
				return {{997.9891357, 1118.6174316}};
			case 481:
				return {{997.9891357, 1118.6174316}};
			case 482:
				return {{997.9891357, 1118.6174316}};
			case 483:
				return {{997.9891357, 1118.6174316}};
			case 484:
				return {{997.9891357, 1118.6174316}};
			case 485:
				return {{997.9891357, 1118.6174316}};
			case 486:
				return {{997.9891357, 1118.6174316}};
			case 487:
				return {{997.9891357, 1118.6174316}};
			case 488:
				return {{997.9891357, 1118.6174316}};
			case 489:
				return {{997.9891357, 1118.6174316}};
			case 490:
				return {{997.9891357, 1118.6174316}};
			case 491:
				return {{997.9891357, 1118.6174316}};
			case 492:
				return {{997.9891357, 1118.6174316}};
			case 493:
				return {{997.9891357, 1118.6174316}};
			case 494:
				return {{997.9891357, 1118.6174316}};
			case 495:
				return {{997.9891357, 1118.6174316}};
			case 496:
				return {{997.9891357, 1118.6174316}};
			case 497:
				return {{997.9891357, 1118.6174316}};
			case 498:
				return {{997.9891357, 1118.6174316}};
			case 499:
				return {{997.9891357, 1118.6174316}};
			case 500:
				return {{997.9891357, 1118.6174316}};
			case 501:
				return {{997.9891357, 1118.6174316}};
			case 502:
				return {{997.9891357, 1118.6174316}};
			case 503:
				return {{997.9888916, 1118.6177979}};
			case 504:
				return {{997.9750977, 1118.6345215}};
			case 505:
				return {{997.9741821, 1118.6354980}};
			case 506:
				return {{997.9731445, 1118.6363525}};
			case 507:
				return {{997.9722900, 1118.6379395}};
			case 508:
				return {{997.9465332, 1118.6685791}};
			case 509:
				return {{997.9443970, 1118.6713867}};
			case 510:
				return {{997.8992310, 1118.7254639}};
			case 511:
				return {{997.8957520, 1118.7294922}};
			case 512:
				return {{997.8348389, 1118.8026123}};
			case 513:
				return {{997.8300781, 1118.8081055}};
			case 514:
				return {{997.8255615, 1118.8139648}};
			case 515:
				return {{997.8204956, 1118.8199463}};
			case 516:
				return {{997.7330322, 1118.9244385}};
			case 517:
				return {{997.7269287, 1118.9318848}};
			case 518:
				return {{997.6199341, 1119.0599365}};
			case 519:
				return {{997.6127930, 1119.0687256}};
			case 520:
				return {{997.6052856, 1119.0772705}};
			case 521:
				return {{997.4874878, 1119.2191162}};
			case 522:
				return {{997.4791870, 1119.2287598}};
			case 523:
				return {{997.4704590, 1119.2392578}};
			case 524:
				return {{997.3273926, 1119.4107666}};
			case 525:
				return {{997.3180542, 1119.4221191}};
			case 526:
				return {{997.3085938, 1119.4334717}};
			case 527:
				return {{997.1596680, 1119.6116943}};
			case 528:
				return {{997.1492920, 1119.6241455}};
			case 529:
				return {{997.1389160, 1119.6363525}};
			case 530:
				return {{996.9664307, 1119.8432617}};
			case 531:
				return {{996.9554443, 1119.8568115}};
			case 532:
				return {{996.9442749, 1119.8699951}};
			case 533:
				return {{996.7593994, 1120.0914307}};
			case 534:
				return {{996.7477417, 1120.1058350}};
			case 535:
				return {{996.7355957, 1120.1201172}};
			case 536:
				return {{996.3518677, 1120.5803223}};
			case 537:
				return {{996.3391724, 1120.5948486}};
			case 538:
				return {{996.1321411, 1120.8436279}};
			case 539:
				return {{996.1185303, 1120.8594971}};
			case 540:
				return {{996.1055908, 1120.8753662}};
			case 541:
				return {{995.9044189, 1121.1159668}};
			case 542:
				return {{995.8908081, 1121.1328125}};
			case 543:
				return {{995.8769531, 1121.1486816}};
			case 544:
				return {{995.6563721, 1121.4136963}};
			case 545:
				return {{995.6423340, 1121.4301758}};
			case 546:
				return {{995.6283569, 1121.4468994}};
			case 547:
				return {{995.4168701, 1121.7010498}};
			case 548:
				return {{995.4027710, 1121.7177734}};
			case 549:
				return {{995.3883057, 1121.7347412}};
			case 550:
				return {{995.1586304, 1122.0103760}};
			case 551:
				return {{995.1437988, 1122.0273438}};
			case 552:
				return {{994.9109497, 1122.3066406}};
			case 553:
				return {{994.8967896, 1122.3240967}};
			case 554:
				return {{994.6762695, 1122.5881348}};
			case 555:
				return {{994.6617432, 1122.6060791}};
			case 556:
				return {{994.6468506, 1122.6234131}};
			case 557:
				return {{994.4096680, 1122.9075928}};
			case 558:
				return {{994.3952026, 1122.9252930}};
			case 559:
				return {{994.3802490, 1122.9433594}};
			case 560:
				return {{994.1417236, 1123.2285156}};
			case 561:
				return {{994.1269531, 1123.2463379}};
			case 562:
				return {{994.1122437, 1123.2648926}};
			case 563:
				return {{993.8876953, 1123.5336914}};
			case 564:
				return {{993.8729858, 1123.5515137}};
			case 565:
				return {{993.8576660, 1123.5690918}};
			case 566:
				return {{993.6174927, 1123.8570557}};
			case 567:
				return {{993.6023560, 1123.8756104}};
			case 568:
				return {{993.3765259, 1124.1456299}};
			case 569:
				return {{993.1360474, 1124.4343262}};
			case 570:
				return {{992.8953857, 1124.7226562}};
			case 571:
				return {{992.8801270, 1124.7408447}};
			case 572:
				return {{992.8650513, 1124.7584229}};
			case 573:
				return {{992.6395264, 1125.0295410}};
			case 574:
				return {{992.6243896, 1125.0474854}};
			case 575:
				return {{992.6093750, 1125.0651855}};
			case 576:
				return {{992.3682861, 1125.3547363}};
			case 577:
				return {{992.3532715, 1125.3725586}};
			case 578:
				return {{992.3380127, 1125.3911133}};
			case 579:
				return {{992.0970459, 1125.6798096}};
			case 580:
				return {{992.0819092, 1125.6979980}};
			case 581:
				return {{992.0669556, 1125.7158203}};
			case 582:
				return {{991.8410645, 1125.9862061}};
			case 583:
				return {{991.8258057, 1126.0045166}};
			case 584:
				return {{991.5850220, 1126.2932129}};
			case 585:
				return {{991.5701904, 1126.3112793}};
			case 586:
				return {{991.5551758, 1126.3292236}};
			case 587:
				return {{991.3294067, 1126.5997314}};
			case 588:
				return {{991.3141479, 1126.6179199}};
			case 589:
				return {{991.2994385, 1126.6354980}};
			case 590:
				return {{991.0588379, 1126.9237061}};
			case 591:
				return {{991.0435791, 1126.9418945}};
			case 592:
				return {{991.0285034, 1126.9606934}};
			case 593:
				return {{990.7879639, 1127.2486572}};
			case 594:
				return {{990.7729492, 1127.2667236}};
			case 595:
				return {{990.7579346, 1127.2843018}};
			case 596:
				return {{990.5322266, 1127.5548096}};
			case 597:
				return {{990.5173340, 1127.5729980}};
			case 598:
				return {{990.5023804, 1127.5905762}};
			case 599:
				return {{990.2619019, 1127.8786621}};
			case 600:
				return {{990.2471924, 1127.8970947}};
			case 601:
				return {{989.7840576, 1128.4519043}};
			case 602:
				return {{989.7691650, 1128.4697266}};
			case 603:
				return {{989.5407104, 1128.7429199}};
			case 604:
				return {{989.5273438, 1128.7598877}};
			case 605:
				return {{989.3279419, 1128.9984131}};
			case 606:
				return {{989.3151245, 1129.0135498}};
			case 607:
				return {{989.3024292, 1129.0285645}};
			case 608:
				return {{989.1090088, 1129.2607422}};
			case 609:
				return {{989.0976562, 1129.2744141}};
			case 610:
				return {{988.9238281, 1129.4830322}};
			case 611:
				return {{988.9135742, 1129.4945068}};
			case 612:
				return {{988.7687988, 1129.6684570}};
			case 613:
				return {{988.7593994, 1129.6790771}};
			case 614:
				return {{988.6242065, 1129.8422852}};
			case 615:
				return {{988.6162720, 1129.8509521}};
			case 616:
				return {{988.6080933, 1129.8609619}};
			case 617:
				return {{988.4918823, 1130.0003662}};
			case 618:
				return {{988.4854126, 1130.0084229}};
			case 619:
				return {{988.4784546, 1130.0168457}};
			case 620:
				return {{988.3852539, 1130.1280518}};
			case 621:
				return {{988.3800659, 1130.1343994}};
			case 622:
				return {{988.2950439, 1130.2357178}};
			case 623:
				return {{988.2907104, 1130.2419434}};
			case 624:
				return {{988.2856445, 1130.2473145}};
			case 625:
				return {{988.2197266, 1130.3266602}};
			case 626:
				return {{988.2156982, 1130.3310547}};
			case 627:
				return {{988.2119141, 1130.3366699}};
			case 628:
				return {{988.1055908, 1130.4633789}};
			case 629:
				return {{988.1027832, 1130.4664307}};
			case 630:
				return {{988.0661621, 1130.5107422}};
			case 631:
				return {{988.0639038, 1130.5131836}};
			case 632:
				return {{988.0615845, 1130.5158691}};
			case 633:
				return {{988.0304565, 1130.5535889}};
			case 634:
				return {{988.0284424, 1130.5552979}};
			case 635:
				return {{988.0038452, 1130.5856934}};
			case 636:
				return {{988.0020752, 1130.5871582}};
			case 637:
				return {{988.0010376, 1130.5888672}};
			case 638:
				return {{987.9829102, 1130.6104736}};
			case 639:
				return {{987.9816895, 1130.6116943}};
			case 640:
				return {{987.9808960, 1130.6131592}};
			case 641:
				return {{987.9662476, 1130.6308594}};
			case 642:
				return {{987.9651489, 1130.6312256}};
			case 643:
				return {{987.9545898, 1130.6442871}};
			case 644:
				return {{987.9537964, 1130.6446533}};
			case 645:
				return {{987.9537354, 1130.6458740}};
			case 646:
				return {{987.9452515, 1130.6551514}};
			case 647:
				return {{987.9448853, 1130.6555176}};
			case 648:
				return {{987.9440918, 1130.6563721}};
			case 649:
				return {{987.9388428, 1130.6633301}};
			case 650:
				return {{987.9385376, 1130.6634521}};
			case 651:
				return {{987.9346924, 1130.6674805}};
			case 652:
				return {{987.9349365, 1130.6683350}};
			case 653:
				return {{987.9345093, 1130.6682129}};
			case 654:
				return {{987.9322510, 1130.6716309}};
			case 655:
				return {{987.9318237, 1130.6712646}};
			case 656:
				return {{987.9306030, 1130.6728516}};
			case 657:
				return {{987.9307861, 1130.6728516}};
			case 658:
				return {{987.9302979, 1130.6735840}};
			case 659:
				return {{987.9300537, 1130.6738281}};
			case 660:
				return {{987.9303589, 1130.6733398}};
			case 661:
				return {{987.9308472, 1130.6730957}};
			case 662:
				return {{987.9308472, 1130.6728516}};
			case 663:
				return {{987.9315186, 1130.6721191}};
			case 664:
				return {{987.9313965, 1130.6721191}};
			case 665:
				return {{987.9321899, 1130.6712646}};
			case 666:
				return {{987.9323730, 1130.6711426}};
			case 667:
				return {{987.9324341, 1130.6708984}};
			case 668:
				return {{987.9333496, 1130.6696777}};
			case 669:
				return {{987.9337158, 1130.6699219}};
			case 670:
				return {{987.9337158, 1130.6696777}};
			case 671:
				return {{987.9346924, 1130.6684570}};
			case 672:
				return {{987.9346924, 1130.6682129}};
			case 673:
				return {{987.9356689, 1130.6672363}};
			case 674:
				return {{987.9359131, 1130.6669922}};
			case 675:
				return {{987.9359131, 1130.6669922}};
			case 676:
				return {{987.9367676, 1130.6657715}};
			case 677:
				return {{987.9370117, 1130.6655273}};
			case 678:
				return {{987.9370117, 1130.6655273}};
			case 679:
				return {{987.9379272, 1130.6647949}};
			case 680:
				return {{987.9382935, 1130.6645508}};
			case 681:
				return {{987.9390869, 1130.6639404}};
			case 682:
				return {{987.9388428, 1130.6629639}};
			case 683:
				return {{987.9388428, 1130.6628418}};
			case 684:
				return {{987.9395752, 1130.6618652}};
			case 685:
				return {{987.9393921, 1130.6621094}};
			case 686:
				return {{987.9400024, 1130.6612549}};
			case 687:
				return {{987.9406738, 1130.6614990}};
			case 688:
				return {{987.9412231, 1130.6605225}};
			case 689:
				return {{987.9416504, 1130.6599121}};
			case 690:
				return {{987.9420166, 1130.6595459}};
			case 691:
				return {{987.9417725, 1130.6593018}};
			case 692:
				return {{987.9417725, 1130.6593018}};
			case 693:
				return {{987.9420166, 1130.6586914}};
			case 694:
				return {{987.9421387, 1130.6593018}};
			case 695:
				return {{987.9424438, 1130.6589355}};
			case 696:
				return {{987.9425659, 1130.6586914}};
			case 697:
				return {{987.9425659, 1130.6586914}};
			case 698:
				return {{987.9428101, 1130.6580811}};
			case 699:
				return {{987.9429932, 1130.6578369}};
			case 700:
				return {{987.9431763, 1130.6575928}};
			case 701:
				return {{987.9434204, 1130.6574707}};
			case 702:
				return {{987.9436035, 1130.6577148}};
			case 703:
				return {{987.9434814, 1130.6579590}};
			case 704:
				return {{987.9434814, 1130.6579590}};
			case 705:
				return {{987.9436035, 1130.6580811}};
			case 706:
				return {{987.9437866, 1130.6580811}};
			case 707:
				return {{987.9437866, 1130.6580811}};
			case 708:
				return {{987.9439697, 1130.6575928}};
			case 709:
				return {{987.9437866, 1130.6574707}};
			case 710:
				return {{987.9439697, 1130.6573486}};
			case 711:
				return {{987.9436035, 1130.6572266}};
			case 712:
				return {{987.9436035, 1130.6572266}};
			case 713:
				return {{987.9436646, 1130.6575928}};
			case 714:
				return {{987.9436035, 1130.6574707}};
			case 715:
				return {{987.9436035, 1130.6574707}};
			case 716:
				return {{987.9436646, 1130.6571045}};
			case 717:
				return {{987.9439697, 1130.6569824}};
			case 718:
				return {{987.9440308, 1130.6568604}};
			case 719:
				return {{987.9439697, 1130.6568604}};
			case 720:
				return {{987.9439697, 1130.6568604}};
			case 721:
				return {{987.9439697, 1130.6568604}};
			case 722:
				return {{987.9439697, 1130.6568604}};
			case 723:
				return {{987.9439697, 1130.6568604}};
			case 724:
				return {{987.9439697, 1130.6568604}};
			case 725:
				return {{987.9439697, 1130.6568604}};
			case 726:
				return {{987.9439697, 1130.6568604}};
			case 727:
				return {{987.9439697, 1130.6568604}};
			case 728:
				return {{987.9439697, 1130.6568604}};
			case 729:
				return {{987.9439697, 1130.6568604}};
			case 730:
				return {{987.9439697, 1130.6568604}};
			case 731:
				return {{987.9439697, 1130.6568604}};
			case 732:
				return {{987.9439697, 1130.6568604}};
			case 733:
				return {{987.9439697, 1130.6568604}};
			case 734:
				return {{987.9439697, 1130.6568604}};
			case 735:
				return {{987.9439697, 1130.6568604}};
			case 736:
				return {{987.9439697, 1130.6568604}};
			case 737:
				return {{987.9439697, 1130.6568604}};
			case 738:
				return {{987.9439697, 1130.6568604}};
			case 739:
				return {{987.9439697, 1130.6568604}};
			case 740:
				return {{987.9439697, 1130.6568604}};
			case 741:
				return {{987.9439697, 1130.6568604}};
			case 742:
				return {{987.9439697, 1130.6568604}};
			case 743:
				return {{987.9439697, 1130.6568604}};
			case 744:
				return {{987.9439697, 1130.6568604}};
			case 745:
				return {{987.9439697, 1130.6568604}};
			case 746:
				return {{987.9439697, 1130.6568604}};
			case 747:
				return {{987.9439697, 1130.6568604}};
			case 748:
				return {{987.9439697, 1130.6568604}};
			case 749:
				return {{987.9439697, 1130.6568604}};
			case 750:
				return {{987.9439697, 1130.6568604}};
			case 751:
				return {{987.9439697, 1130.6568604}};
			case 752:
				return {{987.9439697, 1130.6568604}};
			case 753:
				return {{987.9439697, 1130.6568604}};
			case 754:
				return {{987.9439697, 1130.6568604}};
			case 755:
				return {{987.9439697, 1130.6568604}};
			case 756:
				return {{987.9439697, 1130.6568604}};
			case 757:
				return {{987.9439697, 1130.6568604}};
			case 758:
				return {{987.9439697, 1130.6568604}};
			case 759:
				return {{987.9439697, 1130.6568604}};
			case 760:
				return {{987.9439697, 1130.6568604}};
			case 761:
				return {{987.9439697, 1130.6568604}};
			case 762:
				return {{987.9439697, 1130.6568604}};
			case 763:
				return {{987.9439697, 1130.6568604}};
			case 764:
				return {{987.9439697, 1130.6568604}};
			case 765:
				return {{987.9439697, 1130.6568604}};
			case 766:
				return {{987.9439697, 1130.6568604}};
			case 767:
				return {{987.9439697, 1130.6568604}};
			case 768:
				return {{987.9439697, 1130.6568604}};
			case 769:
				return {{987.9439697, 1130.6568604}};
			case 770:
				return {{987.9439697, 1130.6568604}};
			case 771:
				return {{987.9439697, 1130.6568604}};
			case 772:
				return {{987.9439697, 1130.6568604}};
			case 773:
				return {{987.9439697, 1130.6568604}};
			case 774:
				return {{987.9439697, 1130.6568604}};
			case 775:
				return {{987.9439697, 1130.6568604}};
			case 776:
				return {{987.9439697, 1130.6568604}};
			case 777:
				return {{987.9439697, 1130.6568604}};
			case 778:
				return {{987.9439697, 1130.6568604}};
			case 779:
				return {{987.9439697, 1130.6568604}};
			case 780:
				return {{987.9439697, 1130.6568604}};
			case 781:
				return {{987.9439697, 1130.6568604}};
			case 782:
				return {{987.9439697, 1130.6568604}};
			case 783:
				return {{987.9439697, 1130.6568604}};
			case 784:
				return {{987.9439697, 1130.6568604}};
			case 785:
				return {{987.9439697, 1130.6568604}};
			case 786:
				return {{987.9439697, 1130.6568604}};
			case 787:
				return {{987.9439697, 1130.6568604}};
			case 788:
				return {{987.9439697, 1130.6568604}};
			case 789:
				return {{987.9439697, 1130.6568604}};
			case 790:
				return {{987.9439697, 1130.6568604}};
			case 791:
				return {{987.9439697, 1130.6568604}};
			case 792:
				return {{987.9439697, 1130.6568604}};
			case 793:
				return {{987.9439697, 1130.6568604}};
			case 794:
				return {{987.9439697, 1130.6568604}};
			case 795:
				return {{987.9439697, 1130.6568604}};
			case 796:
				return {{987.9439697, 1130.6568604}};
			case 797:
				return {{987.9439697, 1130.6568604}};
			case 798:
				return {{987.9439697, 1130.6568604}};
			case 799:
				return {{987.9439697, 1130.6568604}};
			case 800:
				return {{987.9439697, 1130.6568604}};
			case 801:
				return {{987.9439697, 1130.6568604}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		assert(false); // Shouldn't be any unaccounted raycasts
		return std::nullopt;
	}
};
// NOLINTEND(bugprone-branch-clone, google-readability-function-size, readability-function-size)
