/*******************************************************************************
 * Copyright (c) 2018-2024 openblack developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/openblack/openblack
 *
 * openblack is licensed under the GNU General Public License version 3.
 *******************************************************************************/

#pragma once

#include <algorithm>

#include <glm/vec2.hpp>

#include "Input/GameActionMapInterface.h"
#include "Mock.h"

class MiddleDragRightUpMockAction final: public MockAction
{
	static constexpr uint32_t k_Start1 = k_StabilizeFrames;
	static constexpr uint32_t k_End1 = k_StabilizeFrames + k_InteractionFrames;
	static constexpr uint32_t k_Start2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames;
	static constexpr uint32_t k_End2 = k_StabilizeFrames + k_InteractionFrames + k_StabilizeFrames + k_InteractionFrames;

public:
	~MiddleDragRightUpMockAction() final = default;

	[[nodiscard]] bool GetBindable(openblack::input::BindableActionMap action) const final
	{
		using openblack::input::BindableActionMap;
		if (frameNumber > k_Start1 - 1 && frameNumber < k_End2 + 1)
		{
			return (static_cast<uint32_t>(action) & static_cast<uint32_t>(BindableActionMap::ROTATE_AROUND_MOUSE_ON)) != 0;
		}

		return false;
	}

	[[nodiscard]] glm::uvec2 GetMousePosition() const final { return {k_Width / 2, 450}; }

	[[nodiscard]] glm::ivec2 GetMouseDelta() const final
	{
		if (frameNumber > k_Start1 && frameNumber < k_End1)
		{
			return {1, 0};
		}
		if (frameNumber > k_Start2 && frameNumber < k_End2)
		{
			return {0, 1};
		}
		return {0, 0};
	}
};

// NOLINTBEGIN(bugprone-branch-clone, google-readability-function-size, readability-function-size)
class MiddleDragRightUpMockDynamicsSystem final: public MockDynamicsSystem
{
public:
	~MiddleDragRightUpMockDynamicsSystem() final = default;

	[[nodiscard]] std::optional<glm::vec2> RayCastClosestHitScreenCoord(glm::u16vec2 screenCoord) const override
	{
		if (screenCoord == k_ScreenCentreLine[0])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 201:
				return std::nullopt;
			case 602:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[1])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			case 201:
				return std::nullopt;
			case 602:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[2])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 563.2467041f}};
			case 201:
				return std::nullopt;
			case 602:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[3])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 189.2355652f}};
			case 201:
				return std::nullopt;
			case 602:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[4])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 100.4535294f}};
			case 201:
				return std::nullopt;
			case 602:
				return {{777.4022827f, 864.2114258f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[5])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 62.1956444f}};
			case 201:
				return std::nullopt;
			case 602:
				return {{956.2937012f, 1060.6733398f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[6])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 39.9825211f}};
			case 201:
				return std::nullopt;
			case 602:
				return {{979.1914062f, 1085.8186035f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[7])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 26.0952835f}};
			case 201:
				return std::nullopt;
			case 602:
				return {{987.8566895f, 1095.3319092f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[8])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000, 16.1538353}};
			case 1:
				return {{1000.0000000, -770.0559082}};
			case 2:
				return {{1000.0000000, -743.0767822}};
			case 3:
				return {{1000.0000000, -5.7276611}};
			case 4:
				return {{1000.0000000, 105.8948517}};
			case 5:
				return {{1000.0000000, 112.1076202}};
			case 6:
				return {{1000.0000000, 118.2447052}};
			case 7:
				return {{1000.0000000, 200.3244019}};
			case 8:
				return {{1000.0000000, 204.8554993}};
			case 9:
				return {{1000.0000000, 264.9228516}};
			case 10:
				return {{1000.0000000, 268.0856323}};
			case 11:
				return {{1000.0000000, 271.2250366}};
			case 12:
				return {{1000.0000000, 313.6578369}};
			case 13:
				return {{1000.0000000, 316.1343384}};
			case 14:
				return {{1000.0000000, 318.7072144}};
			case 15:
				return {{1000.0000000, 321.1528931}};
			case 16:
				return {{1000.0000000, 355.7194519}};
			case 17:
				return {{1000.0000000, 357.7429199}};
			case 18:
				return {{1000.0000000, 384.0479126}};
			case 19:
				return {{1000.0000000, 407.4533691}};
			case 20:
				return {{1000.0000000, 427.1724854}};
			case 21:
				return {{1000.0000000, 428.2545471}};
			case 22:
				return {{1000.0000000, 443.9299011}};
			case 23:
				return {{1000.0000000, 444.8811340}};
			case 24:
				return {{1000.0000000, 459.2140198}};
			case 25:
				return {{1000.0000000, 460.0471497}};
			case 26:
				return {{1000.0000000, 472.5143433}};
			case 27:
				return {{1000.0000000, 473.2416382}};
			case 28:
				return {{1000.0000000, 483.4656067}};
			case 29:
				return {{1000.0000000, 484.1685791}};
			case 30:
				return {{1000.0000000, 493.8484192}};
			case 31:
				return {{1000.0000000, 494.3926697}};
			case 32:
				return {{1000.0000000, 502.4442139}};
			case 33:
				return {{1000.0000000, 502.9736938}};
			case 34:
				return {{1000.0000000, 510.7427979}};
			case 35:
				return {{1000.0000000, 511.1937256}};
			case 36:
				return {{1000.0000000, 518.1301270}};
			case 37:
				return {{1000.0000000, 518.5700684}};
			case 38:
				return {{1000.0000000, 519.0095215}};
			case 39:
				return {{1000.0000000, 500.6634216}};
			case 40:
				return {{1000.0000000, 498.8476868}};
			case 41:
				return {{1000.0000000, 471.6894531}};
			case 42:
				return {{1000.0000000, 469.9794006}};
			case 43:
				return {{1000.0000000, 442.9660645}};
			case 44:
				return {{1000.0000000, 417.5871277}};
			case 45:
				return {{1000.0000000, 391.1619568}};
			case 46:
				return {{1000.0000000, 389.5305786}};
			case 47:
				return {{1000.0000000, 364.7833862}};
			case 48:
				return {{1000.0000000, 363.1747437}};
			case 49:
				return {{1000.0000000, 337.2171631}};
			case 50:
				return {{1000.0000000, 335.5335999}};
			case 51:
				return {{1000.0000000, 309.9683228}};
			case 52:
				return {{1000.0000000, 308.3560791}};
			case 53:
				return {{1000.0000000, 285.0237427}};
			case 54:
				return {{1000.0000000, 283.0931091}};
			case 55:
				return {{1000.0000000, 258.5480347}};
			case 56:
				return {{1000.0000000, 256.9194946}};
			case 57:
				return {{1000.0000000, 232.4271393}};
			case 58:
				return {{1000.0000000, 230.9935760}};
			case 59:
				return {{1000.0000000, 208.8545990}};
			case 60:
				return {{1000.0000000, 207.3721313}};
			case 61:
				return {{1000.0000000, 184.0393066}};
			case 62:
				return {{1000.0000000, 182.6068115}};
			case 63:
				return {{1000.0000000, 161.3394165}};
			case 64:
				return {{1000.0000000, 159.7380066}};
			case 65:
				return {{1000.0000000, 137.5003815}};
			case 66:
				return {{1000.0000000, 115.8879089}};
			case 67:
				return {{1000.0000000, 95.8544159}};
			case 68:
				return {{1000.0000000, 94.5362091}};
			case 69:
				return {{1000.0000000, 73.7548065}};
			case 70:
				return {{1000.0000000, 72.4786377}};
			case 71:
				return {{1000.0000000, 52.5038910}};
			case 72:
				return {{1000.0000000, 51.1960602}};
			case 73:
				return {{1000.0000000, 32.9644012}};
			case 74:
				return {{1000.0000000, 31.5235901}};
			case 75:
				return {{1000.0000000, 30.2701569}};
			case 76:
				return {{1000.0000000, 11.1421204}};
			case 77:
				return {{1000.0000000, 10.1613617}};
			case 78:
				return {{1000.0000000, -7.2264404}};
			case 79:
				return {{1000.0000000, -8.4018555}};
			case 80:
				return {{1000.0000000, -26.1702881}};
			case 81:
				return {{1000.0000000, -27.1201172}};
			case 82:
				return {{1000.0000000, -44.8266602}};
			case 83:
				return {{1000.0000000, -45.5584717}};
			case 84:
				return {{1000.0000000, -61.5065918}};
			case 85:
				return {{1000.0000000, -62.6777344}};
			case 86:
				return {{1000.0000000, -78.9976807}};
			case 87:
				return {{1000.0000000, -79.9364014}};
			case 88:
				return {{1000.0000000, -95.5395508}};
			case 89:
				return {{1000.0000000, -96.6873779}};
			case 90:
				return {{1000.0000000, -110.8873291}};
			case 91:
				return {{1000.0000000, -125.5928955}};
			case 92:
				return {{1000.0000000, -139.0494385}};
			case 93:
				return {{1000.0000000, -139.7036133}};
			case 94:
				return {{1000.0000000, -153.5233154}};
			case 95:
				return {{1000.0000000, -154.3769531}};
			case 96:
				return {{1000.0000000, -167.5012207}};
			case 97:
				return {{1000.0000000, -168.5506592}};
			case 98:
				return {{1000.0000000, -180.2821045}};
			case 99:
				return {{1000.0000000, -181.0770264}};
			case 100:
				return {{1000.0000000, -193.0888672}};
			case 101:
				return {{1000.0000000, -194.0817871}};
			case 102:
				return {{1000.0000000, -205.6433105}};
			case 103:
				return {{1000.0000000, -216.1108398}};
			case 104:
				return {{1000.0000000, -216.8082275}};
			case 105:
				return {{1000.0000000, -227.3505859}};
			case 106:
				return {{1000.0000000, -228.0187988}};
			case 107:
				return {{1000.0000000, -228.5657959}};
			case 108:
				return {{1000.0000000, -238.1468506}};
			case 109:
				return {{1000.0000000, -238.7722168}};
			case 110:
				return {{1000.0000000, -248.4827881}};
			case 111:
				return {{1000.0000000, -249.0815430}};
			case 112:
				return {{1000.0000000, -258.1691895}};
			case 113:
				return {{1000.0000000, -258.7281494}};
			case 114:
				return {{1000.0000000, -275.2501221}};
			case 115:
				return {{1000.0000000, -283.1724854}};
			case 116:
				return {{1000.0000000, -283.3957520}};
			case 117:
				return {{1000.0000000, -290.4317627}};
			case 118:
				return {{1000.0000000, -290.8327637}};
			case 119:
				return {{1000.0000000, -297.8603516}};
			case 120:
				return {{1000.0000000, -298.2362061}};
			case 121:
				return {{1000.0000000, -304.2756348}};
			case 122:
				return {{1000.0000000, -304.6058350}};
			case 123:
				return {{1000.0000000, -305.0563965}};
			case 124:
				return {{1000.0000000, -311.0228271}};
			case 125:
				return {{1000.0000000, -316.6230469}};
			case 126:
				return {{1000.0000000, -317.1135254}};
			case 127:
				return {{1000.0000000, -321.9949951}};
			case 128:
				return {{1000.0000000, -322.4465332}};
			case 129:
				return {{1000.0000000, -322.8072510}};
			case 130:
				return {{1000.0000000, -327.5804443}};
			case 131:
				return {{1000.0000000, -332.0192871}};
			case 132:
				return {{1000.0000000, -332.1802979}};
			case 133:
				return {{1000.0000000, -336.0573730}};
			case 134:
				return {{1000.0000000, -336.1817627}};
			case 135:
				return {{1000.0000000, -340.1765137}};
			case 136:
				return {{1000.0000000, -340.2766113}};
			case 137:
				return {{1000.0000000, -343.6551514}};
			case 138:
				return {{1000.0000000, -346.5415039}};
			case 139:
				return {{1000.0000000, -349.7819824}};
			case 140:
				return {{1000.0000000, -349.7995605}};
			case 141:
				return {{1000.0000000, -352.2539062}};
			case 142:
				return {{1000.0000000, -352.4711914}};
			case 143:
				return {{1000.0000000, -354.5693359}};
			case 144:
				return {{1000.0000000, -354.7683105}};
			case 145:
				return {{1000.0000000, -356.8011475}};
			case 146:
				return {{1000.0000000, -356.9757080}};
			case 147:
				return {{1000.0000000, -358.6204834}};
			case 148:
				return {{1000.0000000, -358.7729492}};
			case 149:
				return {{1000.0000000, -360.5307617}};
			case 150:
				return {{1000.0000000, -360.4355469}};
			case 151:
				return {{1000.0000000, -361.8718262}};
			case 152:
				return {{1000.0000000, -361.7562256}};
			case 153:
				return {{1000.0000000, -363.0778809}};
			case 154:
				return {{1000.0000000, -363.1750488}};
			case 155:
				return {{1000.0000000, -364.0666504}};
			case 156:
				return {{1000.0000000, -364.1520996}};
			case 157:
				return {{1000.0000000, -364.8118896}};
			case 158:
				return {{1000.0000000, -365.1131592}};
			case 159:
				return {{1000.0000000, -365.6785889}};
			case 160:
				return {{1000.0000000, -365.7379150}};
			case 161:
				return {{1000.0000000, -366.8975830}};
			case 162:
				return {{1000.0000000, -367.1383057}};
			case 163:
				return {{1000.0000000, -367.1704102}};
			case 164:
				return {{1000.0000000, -367.5058594}};
			case 165:
				return {{1000.0000000, -367.5330811}};
			case 166:
				return {{1000.0000000, -367.8172607}};
			case 167:
				return {{1000.0000000, -367.8402100}};
			case 168:
				return {{1000.0000000, -368.0611572}};
			case 169:
				return {{1000.0000000, -368.0804443}};
			case 170:
				return {{1000.0000000, -368.2398682}};
			case 171:
				return {{1000.0000000, -368.2490234}};
			case 172:
				return {{1000.0000000, -368.3774414}};
			case 173:
				return {{1000.0000000, -368.1584473}};
			case 174:
				return {{1000.0000000, -368.4852295}};
			case 175:
				return {{1000.0000000, -368.4898682}};
			case 176:
				return {{1000.0000000, -368.5522461}};
			case 177:
				return {{1000.0000000, -368.5556641}};
			case 178:
				return {{1000.0000000, -368.6008301}};
			case 179:
				return {{1000.0000000, -368.6030273}};
			case 180:
				return {{1000.0000000, -368.6293945}};
			case 181:
				return {{1000.0000000, -368.6307373}};
			case 182:
				return {{1000.0000000, -368.6463623}};
			case 183:
				return {{1000.0000000, -368.6523438}};
			case 184:
				return {{1000.0000000, -368.6516113}};
			case 185:
				return {{1000.0000000, -368.6513672}};
			case 186:
				return {{1000.0000000, -368.6455078}};
			case 187:
				return {{1000.0000000, -368.6450195}};
			case 188:
				return {{1000.0000000, -368.6356201}};
			case 189:
				return {{1000.0000000, -368.6350098}};
			case 190:
				return {{1000.0000000, -368.6240234}};
			case 191:
				return {{1000.0000000, -368.6234131}};
			case 192:
				return {{1000.0000000, -368.6105957}};
			case 193:
				return {{1000.0000000, -368.6097412}};
			case 194:
				return {{1000.0000000, -368.5974121}};
			case 195:
				return {{1000.0000000, -368.5965576}};
			case 196:
				return {{1000.0000000, -368.5834961}};
			case 197:
				return {{1000.0000000, -368.5827637}};
			case 198:
				return {{1000.0000000, -368.5701904}};
			case 199:
				return {{1000.0000000, -368.5695801}};
			case 200:
				return {{1000.0000000, -368.5584717}};
			case 201:
				return {{1000.0000000, -368.5578613}};
			case 202:
				return {{1000.0000000, -368.5493164}};
			case 203:
				return {{1000.0000000, -368.5489502}};
			case 204:
				return {{1000.0028076, -368.5454102}};
			case 205:
				return {{1000.0031738, -368.5452881}};
			case 206:
				return {{1000.0297852, -368.5479736}};
			case 207:
				return {{999.9353027, -368.5522461}};
			case 208:
				return {{999.9369507, -368.5526123}};
			case 209:
				return {{999.9386597, -368.5529785}};
			case 210:
				return {{999.9716187, -368.5590820}};
			case 211:
				return {{999.9739990, -368.5594482}};
			case 212:
				return {{999.9024048, -368.5666504}};
			case 213:
				return {{999.9055786, -368.5671387}};
			case 214:
				return {{999.8424683, -368.5747070}};
			case 215:
				return {{999.8463745, -368.5751953}};
			case 216:
				return {{999.6823730, -368.5841064}};
			case 217:
				return {{999.6870728, -368.5848389}};
			case 218:
				return {{999.4185181, -368.5947266}};
			case 219:
				return {{999.4238892, -368.5953369}};
			case 220:
				return {{999.0438843, -368.6055908}};
			case 221:
				return {{999.0499268, -368.6063232}};
			case 222:
				return {{998.4529419, -368.3925781}};
			case 223:
				return {{998.4595947, -368.3934326}};
			case 224:
				return {{997.6315918, -368.4056396}};
			case 225:
				return {{997.6387329, -368.4064941}};
			case 226:
				return {{996.4764404, -368.4208984}};
			case 227:
				return {{996.3676147, -368.4218750}};
			case 228:
				return {{994.6312866, -368.2119141}};
			case 229:
				return {{994.5228882, -368.2130127}};
			case 230:
				return {{988.9639893, -367.7963867}};
			case 231:
				return {{984.4483643, -367.3645020}};
			case 232:
				return {{984.1076660, -367.3657227}};
			case 233:
				return {{983.7669678, -367.3670654}};
			case 234:
				return {{977.6167603, -366.7023926}};
			case 235:
				return {{968.4653320, -365.8229980}};
			case 236:
				return {{967.7762451, -365.5917969}};
			case 237:
				return {{955.7229614, -364.4812012}};
			case 238:
				return {{954.8018799, -364.4826660}};
			case 239:
				return {{936.4058838, -362.4633789}};
			case 240:
				return {{935.0314331, -362.2410889}};
			case 241:
				return {{908.4544678, -359.0769043}};
			case 242:
				return {{906.3903198, -358.8552246}};
			case 243:
				return {{870.4876709, -354.5404053}};
			case 244:
				return {{867.7371826, -354.0883789}};
			case 245:
				return {{812.9014893, -346.9906006}};
			case 246:
				return {{808.8605347, -346.2982178}};
			case 247:
				return {{731.0349121, -335.8187256}};
			case 248:
				return {{725.3254395, -334.8817139}};
			case 249:
				return {{625.9713135, -320.7211914}};
			case 250:
				return {{618.5826416, -319.5142822}};
			case 251:
				return {{483.3864746, -299.0288086}};
			case 252:
				return {{474.1159668, -297.4661865}};
			case 253:
				return {{464.8225708, -295.8995361}};
			case 254:
				return {{166.4906616, -245.0302734}};
			case 255:
				return {{49.5931396, -221.6988525}};
			case 256:
				return {{43.9376221, -220.4083252}};
			case 257:
				return {{-18.0361938, -204.7172852}};
			case 258:
				return {{-20.6878052, -204.0515137}};
			case 259:
				return {{-23.0370483, -203.1595459}};
			case 260:
				return {{-38.3344116, -193.9923096}};
			case 261:
				return {{-38.1477051, -193.7709961}};
			case 262:
				return {{-20.2567139, -190.2056885}};
			case 263:
				return {{-18.5148315, -190.1021729}};
			case 264:
				return {{13.4063721, -189.7578125}};
			case 265:
				return {{52.3161621, -190.6379395}};
			case 266:
				return {{54.9110107, -190.6119385}};
			case 267:
				return {{90.4812622, -191.8872070}};
			case 268:
				return {{92.7321777, -191.8237305}};
			case 269:
				return {{126.2482910, -192.4730225}};
			case 270:
				return {{128.1790161, -192.6209717}};
			case 271:
				return {{156.0119019, -192.6563721}};
			case 272:
				return {{157.6595459, -192.3142090}};
			case 273:
				return {{178.2662354, -191.6481934}};
			case 274:
				return {{179.5140991, -191.5163574}};
			case 275:
				return {{180.7608032, -191.3846436}};
			case 276:
				return {{196.9075928, -189.3229980}};
			case 277:
				return {{197.7767944, -189.1937256}};
			case 278:
				return {{198.6392822, -189.0285645}};
			case 279:
				return {{209.2710571, -185.7954102}};
			case 280:
				return {{215.3584595, -181.6279297}};
			case 281:
				return {{218.7891235, -176.4804688}};
			case 282:
				return {{218.8008423, -176.2850342}};
			case 283:
				return {{218.9338379, -175.8898926}};
			case 284:
				return {{219.1224365, -170.5588379}};
			case 285:
				return {{219.0159912, -170.1290283}};
			case 286:
				return {{218.9094849, -169.9356689}};
			case 287:
				return {{216.0404663, -163.1584473}};
			case 288:
				return {{215.8171387, -162.7314453}};
			case 289:
				return {{215.5972900, -162.1081543}};
			case 290:
				return {{209.9193115, -154.5544434}};
			case 291:
				return {{209.4628906, -153.8951416}};
			case 292:
				return {{209.0066528, -153.4710693}};
			case 293:
				return {{201.3444824, -145.1290283}};
			case 294:
				return {{200.7733765, -144.7075195}};
			case 295:
				return {{190.5798340, -134.7711182}};
			case 296:
				return {{189.8947144, -134.1182861}};
			case 297:
				return {{189.2023315, -133.6562500}};
			case 298:
				return {{177.1658936, -122.9746094}};
			case 299:
				return {{176.3673096, -122.0915527}};
			case 300:
				return {{175.5595093, -121.6307373}};
			case 301:
				return {{162.8455811, -110.4713135}};
			case 302:
				return {{161.9224243, -110.0114746}};
			case 303:
				return {{147.4930420, -97.6791992}};
			case 304:
				return {{146.4542847, -96.9869385}};
			case 305:
				return {{145.6624756, -96.1107178}};
			case 306:
				return {{131.7905884, -84.5830078}};
			case 307:
				return {{130.7523804, -83.8912354}};
			case 308:
				return {{116.5539551, -72.1511230}};
			case 309:
				return {{102.7699585, -60.9575195}};
			case 310:
				return {{101.9638672, -60.4981689}};
			case 311:
				return {{90.0287476, -50.6931152}};
			case 312:
				return {{89.3384399, -50.0009766}};
			case 313:
				return {{88.5317993, -49.3088379}};
			case 314:
				return {{76.8981934, -40.0893555}};
			case 315:
				return {{76.2070312, -39.6290283}};
			case 316:
				return {{75.6318970, -38.9364014}};
			case 317:
				return {{65.1473999, -30.6374512}};
			case 318:
				return {{64.5716553, -30.1765137}};
			case 319:
				return {{55.9022827, -23.2003174}};
			case 320:
				return {{55.3257446, -22.7388916}};
			case 321:
				return {{54.8654175, -22.2774658}};
			case 322:
				return {{46.7680664, -15.9919434}};
			case 323:
				return {{46.1614380, -15.7014160}};
			case 324:
				return {{45.7003174, -15.2393799}};
			case 325:
				return {{39.2129517, -10.1032715}};
			case 326:
				return {{38.8673706, -9.6407471}};
			case 327:
				return {{38.4055176, -9.4107666}};
			case 328:
				return {{32.4605713, -4.6715088}};
			case 329:
				return {{32.1143799, -4.4409180}};
			case 330:
				return {{31.7681274, -4.2104492}};
			case 331:
				return {{26.7739868, -0.2232666}};
			case 332:
				return {{26.5434570, 0.00769042969}};
			case 333:
				return {{26.1643677, 0.06933594}};
			case 334:
				return {{22.0948830, 3.2820458}};
			case 335:
				return {{21.9512157, 3.5715504}};
			case 336:
				return {{21.6617775, 3.5703163}};
			case 337:
				return {{18.2870884, 6.3783479}};
			case 338:
				return {{17.9979534, 6.5230112}};
			case 339:
				return {{17.8538990, 6.8125396}};
			case 340:
				return {{14.9090681, 8.8987856}};
			case 341:
				return {{14.9101219, 9.1885796}};
			case 342:
				return {{12.7420406, 11.0672464}};
			case 343:
				return {{10.8074970, 12.1418381}};
			case 344:
				return {{9.5072184, 13.5891361}};
			case 345:
				return {{9.2167320, 13.5887861}};
			case 346:
				return {{9.3630047, 13.4429474}};
			case 347:
				return {{8.0036650, 14.5224104}};
			case 348:
				return {{7.8589873, 14.5217876}};
			case 349:
				return {{6.9907217, 15.0992203}};
			case 350:
				return {{6.9907546, 15.3896799}};
			case 351:
				return {{6.7874026, 15.1653748}};
			case 352:
				return {{6.2095170, 15.5995331}};
			case 353:
				return {{5.9185910, 15.5988550}};
			case 354:
				return {{5.6302543, 16.0334549}};
			case 355:
				return {{5.4849839, 16.0336113}};
			case 356:
				return {{5.6304603, 16.3239899}};
			case 357:
				return {{5.1957474, 16.6136189}};
			case 358:
				return {{5.1957808, 16.4682045}};
			case 359:
				return {{4.9052076, 16.7577057}};
			case 360:
				return {{5.0506220, 16.7579575}};
			case 361:
				return {{5.0508585, 16.7580643}};
			case 362:
				return {{4.7601695, 17.0484505}};
			case 363:
				return {{4.7601695, 17.0484505}};
			case 364:
				return {{4.7601695, 17.0484505}};
			case 365:
				return {{4.7601695, 17.0484505}};
			case 366:
				return {{4.6149292, 17.0480690}};
			case 367:
				return {{4.6149292, 17.0480690}};
			case 368:
				return {{4.6143432, 17.0480652}};
			case 369:
				return {{4.6143432, 17.0480652}};
			case 370:
				return {{4.6140161, 17.0479984}};
			case 371:
				return {{4.7596598, 17.0486946}};
			case 372:
				return {{4.6139030, 17.0488853}};
			case 373:
				return {{4.7590156, 16.9031506}};
			case 374:
				return {{4.7583504, 17.0493507}};
			case 375:
				return {{4.7576966, 17.0499306}};
			case 376:
				return {{4.7576966, 17.0499306}};
			case 377:
				return {{4.7574654, 17.0497093}};
			case 378:
				return {{4.7569408, 16.7590504}};
			case 379:
				return {{4.7568936, 16.7590313}};
			case 380:
				return {{4.9027624, 16.7592220}};
			case 381:
				return {{4.9021153, 16.9049416}};
			case 382:
				return {{4.9019117, 16.9047966}};
			case 383:
				return {{4.9019279, 16.9048195}};
			case 384:
				return {{5.0466056, 16.7595692}};
			case 385:
				return {{5.0466347, 16.7597218}};
			case 386:
				return {{5.0463581, 16.7595882}};
			case 387:
				return {{5.0457835, 16.7599258}};
			case 388:
				return {{5.0462255, 16.7603016}};
			case 389:
				return {{5.0457721, 16.6147156}};
			case 390:
				return {{5.0457721, 16.6147156}};
			case 391:
				return {{5.0457721, 16.6147156}};
			case 392:
				return {{5.0454330, 16.6151352}};
			case 393:
				return {{5.0454330, 16.6151352}};
			case 394:
				return {{5.0454330, 16.6151352}};
			case 395:
				return {{5.1903811, 16.4699955}};
			case 396:
				return {{5.1903811, 16.4699955}};
			case 397:
				return {{5.1903811, 16.4699955}};
			case 398:
				return {{5.1903267, 16.6159477}};
			case 399:
				return {{5.1903267, 16.6159477}};
			case 400:
				return {{5.1896372, 16.6153793}};
			case 401:
				return {{5.1896372, 16.6153793}};
			case 402:
				return {{5.1896372, 16.6153793}};
			case 403:
				return {{5.1896095, 16.6161366}};
			case 404:
				return {{5.1896095, 16.6161366}};
			case 405:
				return {{5.1896095, 16.6161366}};
			case 406:
				return {{5.1894813, 16.6161804}};
			case 407:
				return {{5.3348627, 16.4709702}};
			case 408:
				return {{5.3344727, 16.6163235}};
			case 409:
				return {{5.3344727, 16.6163235}};
			case 410:
				return {{5.3344727, 16.6163235}};
			case 411:
				return {{5.3348088, 16.3251991}};
			case 412:
				return {{5.3348088, 16.3251991}};
			case 413:
				return {{5.3348088, 16.3251991}};
			case 414:
				return {{5.3344727, 16.3254128}};
			case 415:
				return {{5.3344727, 16.3254128}};
			case 416:
				return {{5.3344727, 16.3254128}};
			case 417:
				return {{5.3344631, 16.3254700}};
			case 418:
				return {{5.3344631, 16.3254700}};
			case 419:
				return {{5.3344631, 16.3254700}};
			case 420:
				return {{5.3345804, 16.3256989}};
			case 421:
				return {{5.3345804, 16.3256989}};
			case 422:
				return {{5.3345003, 16.3257084}};
			case 423:
				return {{5.3345003, 16.3257084}};
			case 424:
				return {{5.3345003, 16.3257084}};
			case 425:
				return {{5.3345003, 16.3257084}};
			case 426:
				return {{5.3345003, 16.3257084}};
			case 427:
				return {{5.3345003, 16.3257084}};
			case 428:
				return {{5.3344488, 16.3257542}};
			case 429:
				return {{5.3344488, 16.3257542}};
			case 430:
				return {{5.3344488, 16.3257542}};
			case 431:
				return {{5.3344488, 16.3257542}};
			case 432:
				return {{5.3344488, 16.3257542}};
			case 433:
				return {{5.3344488, 16.3257542}};
			case 434:
				return {{5.3344488, 16.3257542}};
			case 435:
				return {{5.3344488, 16.3257542}};
			case 436:
				return {{5.3344488, 16.3257542}};
			case 437:
				return {{5.3344488, 16.3257542}};
			case 438:
				return {{5.3344488, 16.3257542}};
			case 439:
				return {{5.3344488, 16.3257542}};
			case 440:
				return {{5.3344488, 16.3257542}};
			case 441:
				return {{5.3344488, 16.3257542}};
			case 442:
				return {{5.3344488, 16.3257542}};
			case 443:
				return {{5.3344488, 16.3257542}};
			case 444:
				return {{5.3344488, 16.3257542}};
			case 445:
				return {{5.3344488, 16.3257542}};
			case 446:
				return {{5.3344488, 16.3257542}};
			case 447:
				return {{5.3344488, 16.3257542}};
			case 448:
				return {{5.3344488, 16.3257542}};
			case 449:
				return {{5.3344488, 16.3257542}};
			case 450:
				return {{5.3344488, 16.3257542}};
			case 451:
				return {{5.3344488, 16.3257542}};
			case 452:
				return {{5.3344488, 16.3257542}};
			case 453:
				return {{5.3344488, 16.3257542}};
			case 454:
				return {{5.3344488, 16.3257542}};
			case 455:
				return {{5.3344488, 16.3257542}};
			case 456:
				return {{5.3344488, 16.3257542}};
			case 457:
				return {{5.3344488, 16.3257542}};
			case 458:
				return {{5.3344488, 16.3257542}};
			case 459:
				return {{5.3344488, 16.3257542}};
			case 460:
				return {{5.3344488, 16.3257542}};
			case 461:
				return {{5.3344488, 16.3257542}};
			case 462:
				return {{5.3344488, 16.3257542}};
			case 463:
				return {{5.3344488, 16.3257542}};
			case 464:
				return {{5.3344488, 16.3257542}};
			case 465:
				return {{5.3344488, 16.3257542}};
			case 466:
				return {{5.3344488, 16.3257542}};
			case 467:
				return {{5.3344488, 16.3257542}};
			case 468:
				return {{5.3344488, 16.3257542}};
			case 469:
				return {{5.3344488, 16.3257542}};
			case 470:
				return {{5.3344488, 16.3257542}};
			case 471:
				return {{5.3344488, 16.3257542}};
			case 472:
				return {{5.3344488, 16.3257542}};
			case 473:
				return {{5.3344488, 16.3257542}};
			case 474:
				return {{5.3344488, 16.3257542}};
			case 475:
				return {{5.3344488, 16.3257542}};
			case 476:
				return {{5.3344488, 16.3257542}};
			case 477:
				return {{5.3344488, 16.3257542}};
			case 478:
				return {{5.3344488, 16.3257542}};
			case 479:
				return {{5.3344488, 16.3257542}};
			case 480:
				return {{5.3344488, 16.3257542}};
			case 481:
				return {{5.3344488, 16.3257542}};
			case 482:
				return {{5.3344488, 16.3257542}};
			case 483:
				return {{5.3344488, 16.3257542}};
			case 484:
				return {{5.3344488, 16.3257542}};
			case 485:
				return {{5.3344488, 16.3257542}};
			case 486:
				return {{5.3344488, 16.3257542}};
			case 487:
				return {{5.3344488, 16.3257542}};
			case 488:
				return {{5.3344488, 16.3257542}};
			case 489:
				return {{5.3344488, 16.3257542}};
			case 490:
				return {{5.3344488, 16.3257542}};
			case 491:
				return {{5.3344488, 16.3257542}};
			case 492:
				return {{5.3344488, 16.3257542}};
			case 493:
				return {{5.3344488, 16.3257542}};
			case 494:
				return {{5.3344488, 16.3257542}};
			case 495:
				return {{5.3344488, 16.3257542}};
			case 496:
				return {{5.3344488, 16.3257542}};
			case 497:
				return {{5.3344488, 16.3257542}};
			case 498:
				return {{5.3344488, 16.3257542}};
			case 499:
				return {{5.3344488, 16.3257542}};
			case 500:
				return {{5.3344488, 16.3257542}};
			case 501:
				return {{5.3344488, 16.3257542}};
			case 502:
				return {{5.3344488, 16.3257542}};
			case 503:
				return {{28.2406445, 41.4808693}};
			case 504:
				return {{221.7081604, 254.0726471}};
			case 505:
				return {{229.3795624, 262.3594360}};
			case 506:
				return {{237.1751556, 270.9210510}};
			case 507:
				return {{245.2805481, 279.7118225}};
			case 508:
				return {{403.9000244, 453.9332275}};
			case 509:
				return {{414.1206055, 465.1739807}};
			case 510:
				return {{568.5106812, 634.8157959}};
			case 511:
				return {{576.9265137, 644.0563354}};
			case 512:
				return {{685.7495728, 763.5212402}};
			case 513:
				return {{691.8070068, 770.1539307}};
			case 514:
				return {{697.6925659, 776.6714478}};
			case 515:
				return {{703.4967651, 783.0548706}};
			case 516:
				return {{782.4951782, 869.8181763}};
			case 517:
				return {{786.5487671, 874.2960205}};
			case 518:
				return {{840.0819092, 933.0570068}};
			case 519:
				return {{842.7783813, 935.9923706}};
			case 520:
				return {{845.4494629, 938.8848877}};
			case 521:
				return {{878.7614746, 975.5046997}};
			case 522:
				return {{880.6000977, 977.5527344}};
			case 523:
				return {{882.4067383, 979.5084229}};
			case 524:
				return {{906.8323975, 1006.3403931}};
			case 525:
				return {{908.1013184, 1007.7337646}};
			case 526:
				return {{909.3435059, 1009.1047363}};
			case 527:
				return {{925.4757690, 1026.8250732}};
			case 528:
				return {{926.3900757, 1027.8342285}};
			case 529:
				return {{927.2832642, 1028.8106689}};
			case 530:
				return {{939.7443237, 1042.4987793}};
			case 531:
				return {{940.4187622, 1043.2370605}};
			case 532:
				return {{941.0814819, 1043.9512939}};
			case 533:
				return {{950.2329102, 1054.0145264}};
			case 534:
				return {{950.7253418, 1054.5531006}};
			case 535:
				return {{951.2153320, 1055.0881348}};
			case 536:
				return {{963.1948242, 1068.2456055}};
			case 537:
				return {{963.4917603, 1068.5749512}};
			case 538:
				return {{967.7042236, 1073.1979980}};
			case 539:
				return {{967.9351196, 1073.4516602}};
			case 540:
				return {{968.1619873, 1073.7042236}};
			case 541:
				return {{971.2496948, 1077.0872803}};
			case 542:
				return {{971.4320068, 1077.2939453}};
			case 543:
				return {{971.6143799, 1077.4925537}};
			case 544:
				return {{974.2782593, 1080.4194336}};
			case 545:
				return {{974.4328613, 1080.5854492}};
			case 546:
				return {{974.5858154, 1080.7559814}};
			case 547:
				return {{976.6504517, 1083.0286865}};
			case 548:
				return {{976.7791748, 1083.1687012}};
			case 549:
				return {{976.9049683, 1083.3055420}};
			case 550:
				return {{978.7727051, 1085.3536377}};
			case 551:
				return {{978.8798828, 1085.4730225}};
			case 552:
				return {{980.4709473, 1087.2211914}};
			case 553:
				return {{980.5639038, 1087.3221436}};
			case 554:
				return {{981.8477783, 1088.7294922}};
			case 555:
				return {{981.9274902, 1088.8227539}};
			case 556:
				return {{982.0063477, 1088.9085693}};
			case 557:
				return {{983.1879883, 1090.2028809}};
			case 558:
				return {{983.2556763, 1090.2794189}};
			case 559:
				return {{983.3238525, 1090.3533936}};
			case 560:
				return {{984.3502197, 1091.4801025}};
			case 561:
				return {{984.4108887, 1091.5462646}};
			case 562:
				return {{984.4729614, 1091.6108398}};
			case 563:
				return {{985.3197021, 1092.5432129}};
			case 564:
				return {{985.3720093, 1092.6059570}};
			case 565:
				return {{985.4277344, 1092.6613770}};
			case 566:
				return {{986.2341919, 1093.5513916}};
			case 567:
				return {{986.2822266, 1093.6040039}};
			case 568:
				return {{986.9631958, 1094.3510742}};
			case 569:
				return {{987.6135254, 1095.0657959}};
			case 570:
				return {{988.1895752, 1095.6956787}};
			case 571:
				return {{988.2235718, 1095.7343750}};
			case 572:
				return {{988.2578125, 1095.7712402}};
			case 573:
				return {{988.7324219, 1096.2934570}};
			case 574:
				return {{988.7635498, 1096.3267822}};
			case 575:
				return {{988.7940063, 1096.3613281}};
			case 576:
				return {{989.2506104, 1096.8614502}};
			case 577:
				return {{989.2797241, 1096.8935547}};
			case 578:
				return {{989.3053589, 1096.9248047}};
			case 579:
				return {{989.7214355, 1097.3820801}};
			case 580:
				return {{989.7485352, 1097.4064941}};
			case 581:
				return {{989.7717896, 1097.4331055}};
			case 582:
				return {{990.1331787, 1097.8288574}};
			case 583:
				return {{990.1567383, 1097.8551025}};
			case 584:
				return {{990.5136108, 1098.2471924}};
			case 585:
				return {{990.5352173, 1098.2709961}};
			case 586:
				return {{990.5551147, 1098.2937012}};
			case 587:
				return {{990.8666382, 1098.6361084}};
			case 588:
				return {{990.8862305, 1098.6580811}};
			case 589:
				return {{990.9058838, 1098.6774902}};
			case 590:
				return {{991.2146606, 1099.0178223}};
			case 591:
				return {{991.2335205, 1099.0385742}};
			case 592:
				return {{991.2506104, 1099.0598145}};
			case 593:
				return {{991.5408325, 1099.3767090}};
			case 594:
				return {{991.5578613, 1099.3955078}};
			case 595:
				return {{991.5750732, 1099.4154053}};
			case 596:
				return {{991.8315430, 1099.6964111}};
			case 597:
				return {{991.8482056, 1099.7139893}};
			case 598:
				return {{991.8630981, 1099.7325439}};
			case 599:
				return {{992.1214600, 1100.0141602}};
			case 600:
				return {{992.1372070, 1100.0316162}};
			case 601:
				return {{992.5910645, 1100.5278320}};
			case 602:
				return {{992.6031494, 1100.5449219}};
			case 603:
				return {{992.8461304, 1100.8104248}};
			case 604:
				return {{992.8616943, 1100.8269043}};
			case 605:
				return {{993.0974731, 1101.0872803}};
			case 606:
				return {{993.1116943, 1101.1031494}};
			case 607:
				return {{993.1270752, 1101.1192627}};
			case 608:
				return {{993.3428345, 1101.3560791}};
			case 609:
				return {{993.3554077, 1101.3698730}};
			case 610:
				return {{993.5235596, 1101.5537109}};
			case 611:
				return {{993.5328369, 1101.5649414}};
			case 612:
				return {{993.6518555, 1101.6951904}};
			case 613:
				return {{993.6591187, 1101.7004395}};
			case 614:
				return {{993.7496338, 1101.8018799}};
			case 615:
				return {{993.7546387, 1101.8077393}};
			case 616:
				return {{993.7590332, 1101.8128662}};
			case 617:
				return {{993.8217163, 1101.8828125}};
			case 618:
				return {{993.8251953, 1101.8859863}};
			case 619:
				return {{993.8278198, 1101.8889160}};
			case 620:
				return {{993.8699341, 1101.9331055}};
			case 621:
				return {{993.8713989, 1101.9372559}};
			case 622:
				return {{993.9017334, 1101.9687500}};
			case 623:
				return {{993.9035034, 1101.9694824}};
			case 624:
				return {{993.9035034, 1101.9721680}};
			case 625:
				return {{993.9227295, 1101.9924316}};
			case 626:
				return {{993.9233398, 1101.9932861}};
			case 627:
				return {{993.9248047, 1101.9951172}};
			case 628:
				return {{993.9464722, 1102.0190430}};
			case 629:
				return {{993.9476318, 1102.0201416}};
			case 630:
				return {{993.9531250, 1102.0247803}};
			case 631:
				return {{993.9535522, 1102.0270996}};
			case 632:
				return {{993.9537964, 1102.0262451}};
			case 633:
				return {{993.9566650, 1102.0303955}};
			case 634:
				return {{993.9575195, 1102.0296631}};
			case 635:
				return {{993.9608154, 1102.0329590}};
			case 636:
				return {{993.9594116, 1102.0360107}};
			case 637:
				return {{993.9611206, 1102.0335693}};
			case 638:
				return {{993.9627075, 1102.0362549}};
			case 639:
				return {{993.9621582, 1102.0364990}};
			case 640:
				return {{993.9626465, 1102.0372314}};
			case 641:
				return {{993.9627686, 1102.0372314}};
			case 642:
				return {{993.9626465, 1102.0390625}};
			case 643:
				return {{993.9637451, 1102.0390625}};
			case 644:
				return {{993.9636841, 1102.0384521}};
			case 645:
				return {{993.9641113, 1102.0375977}};
			case 646:
				return {{993.9650879, 1102.0397949}};
			case 647:
				return {{993.9647827, 1102.0378418}};
			case 648:
				return {{993.9641113, 1102.0390625}};
			case 649:
				return {{993.9661255, 1102.0390625}};
			case 650:
				return {{993.9647217, 1102.0389404}};
			case 651:
				return {{993.9655762, 1102.0401611}};
			case 652:
				return {{993.9653320, 1102.0377197}};
			case 653:
				return {{993.9653320, 1102.0379639}};
			case 654:
				return {{993.9663086, 1102.0388184}};
			case 655:
				return {{993.9644775, 1102.0402832}};
			case 656:
				return {{993.9643555, 1102.0402832}};
			case 657:
				return {{993.9650879, 1102.0399170}};
			case 658:
				return {{993.9660645, 1102.0388184}};
			case 659:
				return {{993.9652100, 1102.0390625}};
			case 660:
				return {{993.9653320, 1102.0390625}};
			case 661:
				return {{993.9652100, 1102.0388184}};
			case 662:
				return {{993.9651489, 1102.0388184}};
			case 663:
				return {{993.9661255, 1102.0399170}};
			case 664:
				return {{993.9657593, 1102.0394287}};
			case 665:
				return {{993.9658203, 1102.0385742}};
			case 666:
				return {{993.9655151, 1102.0391846}};
			case 667:
				return {{993.9654541, 1102.0390625}};
			case 668:
				return {{993.9655151, 1102.0401611}};
			case 669:
				return {{993.9660034, 1102.0396729}};
			case 670:
				return {{993.9660034, 1102.0395508}};
			case 671:
				return {{993.9650879, 1102.0396729}};
			case 672:
				return {{993.9655762, 1102.0390625}};
			case 673:
				return {{993.9655151, 1102.0389404}};
			case 674:
				return {{993.9651489, 1102.0395508}};
			case 675:
				return {{993.9650879, 1102.0395508}};
			case 676:
				return {{993.9651489, 1102.0396729}};
			case 677:
				return {{993.9657593, 1102.0390625}};
			case 678:
				return {{993.9656982, 1102.0390625}};
			case 679:
				return {{993.9658203, 1102.0401611}};
			case 680:
				return {{993.9653320, 1102.0395508}};
			case 681:
				return {{993.9653320, 1102.0385742}};
			case 682:
				return {{993.9660034, 1102.0380859}};
			case 683:
				return {{993.9659424, 1102.0380859}};
			case 684:
				return {{993.9660034, 1102.0390625}};
			case 685:
				return {{993.9655151, 1102.0399170}};
			case 686:
				return {{993.9645996, 1102.0399170}};
			case 687:
				return {{993.9663696, 1102.0395508}};
			case 688:
				return {{993.9663696, 1102.0395508}};
			case 689:
				return {{993.9661255, 1102.0393066}};
			case 690:
				return {{993.9648438, 1102.0390625}};
			case 691:
				return {{993.9645996, 1102.0388184}};
			case 692:
				return {{993.9645996, 1102.0388184}};
			case 693:
				return {{993.9645996, 1102.0388184}};
			case 694:
				return {{993.9666138, 1102.0386963}};
			case 695:
				return {{993.9666748, 1102.0386963}};
			case 696:
				return {{993.9664307, 1102.0384521}};
			case 697:
				return {{993.9664307, 1102.0384521}};
			case 698:
				return {{993.9654541, 1102.0385742}};
			case 699:
				return {{993.9653320, 1102.0384521}};
			case 700:
				return {{993.9654541, 1102.0396729}};
			case 701:
				return {{993.9653320, 1102.0394287}};
			case 702:
				return {{993.9653931, 1102.0394287}};
			case 703:
				return {{993.9652100, 1102.0393066}};
			case 704:
				return {{993.9652100, 1102.0391846}};
			case 705:
				return {{993.9652100, 1102.0393066}};
			case 706:
				return {{993.9651489, 1102.0390625}};
			case 707:
				return {{993.9651489, 1102.0390625}};
			case 708:
				return {{993.9651489, 1102.0390625}};
			case 709:
				return {{993.9650879, 1102.0390625}};
			case 710:
				return {{993.9650879, 1102.0390625}};
			case 711:
				return {{993.9649658, 1102.0389404}};
			case 712:
				return {{993.9649658, 1102.0389404}};
			case 713:
				return {{993.9649048, 1102.0389404}};
			case 714:
				return {{993.9649048, 1102.0388184}};
			case 715:
				return {{993.9648438, 1102.0388184}};
			case 716:
				return {{993.9648438, 1102.0388184}};
			case 717:
				return {{993.9647827, 1102.0388184}};
			case 718:
				return {{993.9648438, 1102.0388184}};
			case 719:
				return {{993.9647827, 1102.0386963}};
			case 720:
				return {{993.9647827, 1102.0388184}};
			case 721:
				return {{993.9647827, 1102.0386963}};
			case 722:
				return {{993.9647827, 1102.0386963}};
			case 723:
				return {{993.9647827, 1102.0386963}};
			case 724:
				return {{993.9648438, 1102.0388184}};
			case 725:
				return {{993.9647827, 1102.0388184}};
			case 726:
				return {{993.9647827, 1102.0386963}};
			case 727:
				return {{993.9647827, 1102.0386963}};
			case 728:
				return {{993.9647827, 1102.0388184}};
			case 729:
				return {{993.9647827, 1102.0388184}};
			case 730:
				return {{993.9647827, 1102.0388184}};
			case 731:
				return {{993.9647827, 1102.0388184}};
			case 732:
				return {{993.9647827, 1102.0388184}};
			case 733:
				return {{993.9647827, 1102.0388184}};
			case 734:
				return {{993.9648438, 1102.0388184}};
			case 735:
				return {{993.9648438, 1102.0388184}};
			case 736:
				return {{993.9648438, 1102.0388184}};
			case 737:
				return {{993.9648438, 1102.0388184}};
			case 738:
				return {{993.9648438, 1102.0388184}};
			case 739:
				return {{993.9648438, 1102.0388184}};
			case 740:
				return {{993.9649048, 1102.0388184}};
			case 741:
				return {{993.9649048, 1102.0388184}};
			case 742:
				return {{993.9649048, 1102.0388184}};
			case 743:
				return {{993.9649048, 1102.0388184}};
			case 744:
				return {{993.9649048, 1102.0389404}};
			case 745:
				return {{993.9649048, 1102.0389404}};
			case 746:
				return {{993.9649658, 1102.0389404}};
			case 747:
				return {{993.9649658, 1102.0389404}};
			case 748:
				return {{993.9649658, 1102.0390625}};
			case 749:
				return {{993.9649658, 1102.0390625}};
			case 750:
				return {{993.9649658, 1102.0390625}};
			case 751:
				return {{993.9650879, 1102.0390625}};
			case 752:
				return {{993.9650879, 1102.0390625}};
			case 753:
				return {{993.9650879, 1102.0390625}};
			case 754:
				return {{993.9650879, 1102.0390625}};
			case 755:
				return {{993.9650879, 1102.0390625}};
			case 756:
				return {{993.9650879, 1102.0390625}};
			case 757:
				return {{993.9650879, 1102.0390625}};
			case 758:
				return {{993.9650879, 1102.0390625}};
			case 759:
				return {{993.9650879, 1102.0390625}};
			case 760:
				return {{993.9649658, 1102.0390625}};
			case 761:
				return {{993.9649658, 1102.0390625}};
			case 762:
				return {{993.9649658, 1102.0390625}};
			case 763:
				return {{993.9649658, 1102.0390625}};
			case 764:
				return {{993.9649658, 1102.0390625}};
			case 765:
				return {{993.9649658, 1102.0390625}};
			case 766:
				return {{993.9649658, 1102.0390625}};
			case 767:
				return {{993.9649658, 1102.0390625}};
			case 768:
				return {{993.9649658, 1102.0390625}};
			case 769:
				return {{993.9649658, 1102.0390625}};
			case 770:
				return {{993.9649658, 1102.0390625}};
			case 771:
				return {{993.9649658, 1102.0390625}};
			case 772:
				return {{993.9649658, 1102.0390625}};
			case 773:
				return {{993.9649658, 1102.0390625}};
			case 774:
				return {{993.9650879, 1102.0390625}};
			case 775:
				return {{993.9650879, 1102.0390625}};
			case 776:
				return {{993.9650879, 1102.0390625}};
			case 777:
				return {{993.9650879, 1102.0390625}};
			case 778:
				return {{993.9650879, 1102.0390625}};
			case 779:
				return {{993.9650879, 1102.0390625}};
			case 780:
				return {{993.9650879, 1102.0390625}};
			case 781:
				return {{993.9650879, 1102.0390625}};
			case 782:
				return {{993.9650879, 1102.0390625}};
			case 783:
				return {{993.9650879, 1102.0390625}};
			case 784:
				return {{993.9650879, 1102.0390625}};
			case 785:
				return {{993.9650879, 1102.0390625}};
			case 786:
				return {{993.9650879, 1102.0390625}};
			case 787:
				return {{993.9650879, 1102.0390625}};
			case 788:
				return {{993.9650879, 1102.0390625}};
			case 789:
				return {{993.9650879, 1102.0390625}};
			case 790:
				return {{993.9650879, 1102.0390625}};
			case 791:
				return {{993.9650879, 1102.0390625}};
			case 792:
				return {{993.9650879, 1102.0390625}};
			case 793:
				return {{993.9650879, 1102.0390625}};
			case 794:
				return {{993.9650879, 1102.0390625}};
			case 795:
				return {{993.9650879, 1102.0390625}};
			case 796:
				return {{993.9650879, 1102.0390625}};
			case 797:
				return {{993.9650879, 1102.0390625}};
			case 798:
				return {{993.9649658, 1102.0390625}};
			case 799:
				return {{993.9649658, 1102.0390625}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[9])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 9.0254517f}};
			case 201:
				return {{1000.0000000f, 1075.0812988f}};
			case 602:
				return {{995.4705811f, 1103.6923828f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[10])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 3.4066925f}};
			case 201:
				return {{1000.0000000f, 1097.5003662f}};
			case 602:
				return {{997.4780884f, 1105.8974609f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[11])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -0.9229774f}};
			case 201:
				return {{1000.0000000f, 1104.8605957f}};
			case 602:
				return {{998.8959961f, 1107.4537354f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[12])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -4.5307636f}};
			case 1:
				return {{1000.0000000f, 1116.1998291f}};
			case 2:
				return {{1000.0000000f, 1116.1997070f}};
			case 3:
				return {{1000.0000000f, 1116.2059326f}};
			case 4:
				return {{1000.0000000f, 1116.2072754f}};
			case 5:
				return {{1000.0000000f, 1116.2073975f}};
			case 6:
				return {{1000.0000000f, 1116.2075195f}};
			case 7:
				return {{1000.0000000f, 1116.2087402f}};
			case 8:
				return {{1000.0000000f, 1116.2087402f}};
			case 9:
				return {{1000.0000000f, 1116.2099609f}};
			case 10:
				return {{1000.0000000f, 1116.2099609f}};
			case 11:
				return {{1000.0000000f, 1116.2099609f}};
			case 12:
				return {{1000.0000000f, 1116.2109375f}};
			case 13:
				return {{1000.0000000f, 1116.2109375f}};
			case 14:
				return {{1000.0000000f, 1116.2110596f}};
			case 15:
				return {{1000.0000000f, 1116.2110596f}};
			case 16:
				return {{1000.0000000f, 1116.2119141f}};
			case 17:
				return {{1000.0000000f, 1116.2119141f}};
			case 18:
				return {{1000.0000000f, 1116.2126465f}};
			case 19:
				return {{1000.0000000f, 1116.2132568f}};
			case 20:
				return {{1000.0000000f, 1116.2138672f}};
			case 21:
				return {{1000.0000000f, 1116.2138672f}};
			case 22:
				return {{1000.0000000f, 1116.2143555f}};
			case 23:
				return {{1000.0000000f, 1116.2144775f}};
			case 24:
				return {{1000.0000000f, 1116.2148438f}};
			case 25:
				return {{1000.0000000f, 1116.2148438f}};
			case 26:
				return {{1000.0000000f, 1116.2153320f}};
			case 27:
				return {{1000.0000000f, 1116.2153320f}};
			case 28:
				return {{1000.0000000f, 1116.2156982f}};
			case 29:
				return {{1000.0000000f, 1116.2156982f}};
			case 30:
				return {{1000.0000000f, 1116.2160645f}};
			case 31:
				return {{1000.0000000f, 1116.2160645f}};
			case 32:
				return {{1000.0000000f, 1116.2163086f}};
			case 33:
				return {{1000.0000000f, 1116.2164307f}};
			case 34:
				return {{1000.0000000f, 1116.2167969f}};
			case 35:
				return {{1000.0000000f, 1116.2167969f}};
			case 36:
				return {{1000.0000000f, 1116.2169189f}};
			case 37:
				return {{1000.0000000f, 1116.2169189f}};
			case 38:
				return {{1000.0000000f, 1116.2170410f}};
			case 39:
				return {{1000.0000000f, 1116.0631104f}};
			case 40:
				return {{1000.0000000f, 1116.0500488f}};
			case 41:
				return {{1000.0000000f, 1115.8371582f}};
			case 42:
				return {{1000.0000000f, 1115.8244629f}};
			case 43:
				return {{1000.0000000f, 1115.6113281f}};
			case 44:
				return {{1000.0000000f, 1115.4114990f}};
			case 45:
				return {{1000.0000000f, 1115.2003174f}};
			case 46:
				return {{1000.0000000f, 1115.1870117f}};
			case 47:
				return {{1000.0000000f, 1114.9885254f}};
			case 48:
				return {{1000.0000000f, 1114.9752197f}};
			case 49:
				return {{1000.0000000f, 1114.7661133f}};
			case 50:
				return {{1000.0000000f, 1114.7526855f}};
			case 51:
				return {{1000.0000000f, 1114.5437012f}};
			case 52:
				return {{1000.0000000f, 1114.5313721f}};
			case 53:
				return {{1000.0000000f, 1114.3376465f}};
			case 54:
				return {{1000.0000000f, 1114.3237305f}};
			case 55:
				return {{1000.0000000f, 1114.1207275f}};
			case 56:
				return {{1000.0000000f, 1114.1076660f}};
			case 57:
				return {{1000.0000000f, 1113.9056396f}};
			case 58:
				return {{1000.0000000f, 1113.8916016f}};
			case 59:
				return {{1000.0000000f, 1113.7060547f}};
			case 60:
				return {{1000.0000000f, 1113.6927490f}};
			case 61:
				return {{1000.0000000f, 1113.4967041f}};
			case 62:
				return {{1000.0000000f, 1113.4848633f}};
			case 63:
				return {{1000.0000000f, 1113.3021240f}};
			case 64:
				return {{1000.0000000f, 1113.2899170f}};
			case 65:
				return {{1000.0000000f, 1113.0999756f}};
			case 66:
				return {{1000.0000000f, 1112.9127197f}};
			case 67:
				return {{1000.0000000f, 1112.7402344f}};
			case 68:
				return {{1000.0000000f, 1112.7285156f}};
			case 69:
				return {{1000.0000000f, 1112.5487061f}};
			case 70:
				return {{1000.0000000f, 1112.5377197f}};
			case 71:
				return {{1000.0000000f, 1112.3625488f}};
			case 72:
				return {{1000.0000000f, 1112.3515625f}};
			case 73:
				return {{1000.0000000f, 1112.1894531f}};
			case 74:
				return {{1000.0000000f, 1112.1791992f}};
			case 75:
				return {{1000.0000000f, 1112.1695557f}};
			case 76:
				return {{1000.0000000f, 1112.0009766f}};
			case 77:
				return {{1000.0000000f, 1111.9915771f}};
			case 78:
				return {{1000.0000000f, 1111.8374023f}};
			case 79:
				return {{1000.0000000f, 1111.8281250f}};
			case 80:
				return {{1000.0000000f, 1111.6679688f}};
			case 81:
				return {{1000.0000000f, 1111.6583252f}};
			case 82:
				return {{1000.0000000f, 1111.5053711f}};
			case 83:
				return {{1000.0000000f, 1111.4946289f}};
			case 84:
				return {{1000.0000000f, 1111.3544922f}};
			case 85:
				return {{1000.0000000f, 1111.3453369f}};
			case 86:
				return {{1000.0000000f, 1111.2001953f}};
			case 87:
				return {{1000.0000000f, 1111.1918945f}};
			case 88:
				return {{1000.0000000f, 1111.0515137f}};
			case 89:
				return {{1000.0000000f, 1111.0428467f}};
			case 90:
				return {{1000.0000000f, 1110.9154053f}};
			case 91:
				return {{1000.0000000f, 1110.7847900f}};
			case 92:
				return {{1000.0000000f, 1110.6647949f}};
			case 93:
				return {{1000.0000000f, 1110.6569824f}};
			case 94:
				return {{1000.0000000f, 1110.5344238f}};
			case 95:
				return {{1000.0000000f, 1110.5277100f}};
			case 96:
				return {{1000.0000000f, 1110.4105225f}};
			case 97:
				return {{1000.0000000f, 1110.4025879f}};
			case 98:
				return {{1000.0000000f, 1110.2971191f}};
			case 99:
				return {{1000.0000000f, 1110.2906494f}};
			case 100:
				return {{1000.0000000f, 1110.1828613f}};
			case 101:
				return {{1000.0000000f, 1110.1771240f}};
			case 102:
				return {{1000.0000000f, 1110.0727539f}};
			case 103:
				return {{1000.0000000f, 1109.9815674f}};
			case 104:
				return {{1000.0000000f, 1109.9738770f}};
			case 105:
				return {{1000.0000000f, 1109.8812256f}};
			case 106:
				return {{1000.0000000f, 1109.8757324f}};
			case 107:
				return {{1000.0000000f, 1109.8702393f}};
			case 108:
				return {{1000.0000000f, 1109.7858887f}};
			case 109:
				return {{1000.0000000f, 1109.7807617f}};
			case 110:
				return {{1000.0000000f, 1109.6961670f}};
			case 111:
				return {{1000.0000000f, 1109.6900635f}};
			case 112:
				return {{1000.0000000f, 1109.6108398f}};
			case 113:
				return {{1000.0000000f, 1109.6064453f}};
			case 114:
				return {{1000.0000000f, 1109.4621582f}};
			case 115:
				return {{1000.0000000f, 1109.3956299f}};
			case 116:
				return {{1000.0000000f, 1109.3911133f}};
			case 117:
				return {{1000.0000000f, 1109.3317871f}};
			case 118:
				return {{1000.0000000f, 1109.3271484f}};
			case 119:
				return {{1000.0000000f, 1109.2663574f}};
			case 120:
				return {{1000.0000000f, 1109.2640381f}};
			case 121:
				return {{1000.0000000f, 1109.2104492f}};
			case 122:
				return {{1000.0000000f, 1109.2072754f}};
			case 123:
				return {{1000.0000000f, 1109.2038574f}};
			case 124:
				return {{1000.0000000f, 1109.1527100f}};
			case 125:
				return {{1000.0000000f, 1109.1042480f}};
			case 126:
				return {{1000.0000000f, 1109.1013184f}};
			case 127:
				return {{1000.0000000f, 1109.0588379f}};
			case 128:
				return {{1000.0000000f, 1109.0552979f}};
			case 129:
				return {{1000.0000000f, 1109.0543213f}};
			case 130:
				return {{1000.0000000f, 1109.0135498f}};
			case 131:
				return {{1000.0000000f, 1108.9732666f}};
			case 132:
				return {{1000.0000000f, 1108.9721680f}};
			case 133:
				return {{1000.0000000f, 1108.9395752f}};
			case 134:
				return {{1000.0000000f, 1108.9367676f}};
			case 135:
				return {{1000.0000000f, 1108.9049072f}};
			case 136:
				return {{1000.0000000f, 1108.9038086f}};
			case 137:
				return {{1000.0000000f, 1108.8754883f}};
			case 138:
				return {{1000.0000000f, 1108.8500977f}};
			case 139:
				return {{1000.0000000f, 1108.8258057f}};
			case 140:
				return {{1000.0000000f, 1108.8237305f}};
			case 141:
				return {{1000.0000000f, 1108.8041992f}};
			case 142:
				return {{1000.0000000f, 1108.8023682f}};
			case 143:
				return {{1000.0000000f, 1108.7824707f}};
			case 144:
				return {{1000.0000000f, 1108.7832031f}};
			case 145:
				return {{1000.0000000f, 1108.7645264f}};
			case 146:
				return {{1000.0000000f, 1108.7631836f}};
			case 147:
				return {{1000.0000000f, 1108.7495117f}};
			case 148:
				return {{1000.0000000f, 1108.7484131f}};
			case 149:
				return {{1000.0000000f, 1108.7355957f}};
			case 150:
				return {{1000.0000000f, 1108.7343750f}};
			case 151:
				return {{1000.0000000f, 1108.7238770f}};
			case 152:
				return {{1000.0000000f, 1108.7232666f}};
			case 153:
				return {{1000.0000000f, 1108.7136230f}};
			case 154:
				return {{1000.0000000f, 1108.7114258f}};
			case 155:
				return {{1000.0000000f, 1108.7033691f}};
			case 156:
				return {{1000.0000000f, 1108.7036133f}};
			case 157:
				return {{1000.0000000f, 1108.6971436f}};
			case 158:
				return {{1000.0000000f, 1108.6965332f}};
			case 159:
				return {{1000.0000000f, 1108.6907959f}};
			case 160:
				return {{1000.0000000f, 1108.6887207f}};
			case 161:
				return {{1000.0000000f, 1108.6809082f}};
			case 162:
				return {{1000.0000000f, 1108.6774902f}};
			case 163:
				return {{1000.0000000f, 1108.6772461f}};
			case 164:
				return {{1000.0000000f, 1108.6748047f}};
			case 165:
				return {{1000.0000000f, 1108.6750488f}};
			case 166:
				return {{1000.0000000f, 1108.6729736f}};
			case 167:
				return {{1000.0000000f, 1108.6719971f}};
			case 168:
				return {{1000.0000000f, 1108.6704102f}};
			case 169:
				return {{1000.0000000f, 1108.6713867f}};
			case 170:
				return {{1000.0000000f, 1108.6702881f}};
			case 171:
				return {{1000.0000000f, 1108.6687012f}};
			case 172:
				return {{1000.0000000f, 1108.6678467f}};
			case 173:
				return {{1000.0000000f, 1108.6683350f}};
			case 174:
				return {{1000.0000000f, 1108.6676025f}};
			case 175:
				return {{1000.0000000f, 1108.6680908f}};
			case 176:
				return {{1000.0000000f, 1108.6676025f}};
			case 177:
				return {{1000.0000000f, 1108.6667480f}};
			case 178:
				return {{1000.0000000f, 1108.6663818f}};
			case 179:
				return {{1000.0000000f, 1108.6666260f}};
			case 180:
				return {{1000.0000000f, 1108.6663818f}};
			case 181:
				return {{1000.0000000f, 1108.6665039f}};
			case 182:
				return {{1000.0000000f, 1108.6665039f}};
			case 183:
				return {{1000.0000000f, 1108.6665039f}};
			case 184:
				return {{1000.0000000f, 1108.6665039f}};
			case 185:
				return {{1000.0000000f, 1108.6665039f}};
			case 186:
				return {{1000.0000000f, 1108.6665039f}};
			case 187:
				return {{1000.0000000f, 1108.6665039f}};
			case 188:
				return {{1000.0000000f, 1108.6666260f}};
			case 189:
				return {{1000.0000000f, 1108.6665039f}};
			case 190:
				return {{1000.0000000f, 1108.6666260f}};
			case 191:
				return {{1000.0000000f, 1108.6666260f}};
			case 192:
				return {{1000.0000000f, 1108.6667480f}};
			case 193:
				return {{1000.0000000f, 1108.6666260f}};
			case 194:
				return {{1000.0000000f, 1108.6667480f}};
			case 195:
				return {{1000.0000000f, 1108.6666260f}};
			case 196:
				return {{1000.0000000f, 1108.6667480f}};
			case 197:
				return {{1000.0000000f, 1108.6667480f}};
			case 198:
				return {{1000.0000000f, 1108.6667480f}};
			case 199:
				return {{1000.0000000f, 1108.6667480f}};
			case 200:
				return {{1000.0000000f, 1108.6667480f}};
			case 201:
				return {{1000.0000000f, 1108.6667480f}};
			case 202:
				return {{1000.0000000f, 1108.6668701f}};
			case 203:
				return {{1000.0000000f, 1108.6667480f}};
			case 204:
				return {{1000.0028076f, 1108.6667480f}};
			case 205:
				return {{1000.0031738f, 1108.6667480f}};
			case 206:
				return {{1000.0298462f, 1108.6663818f}};
			case 207:
				return {{1000.0506592f, 1108.6660156f}};
			case 208:
				return {{1000.0533447f, 1108.6660156f}};
			case 209:
				return {{1000.0540161f, 1108.6660156f}};
			case 210:
				return {{1000.0869751f, 1108.6652832f}};
			case 211:
				return {{1000.0893555f, 1108.6652832f}};
			case 212:
				return {{1000.1331787f, 1108.6638184f}};
			case 213:
				return {{1000.1364136f, 1108.6628418f}};
			case 214:
				return {{1000.1896973f, 1108.6618652f}};
			case 215:
				return {{1000.1935425f, 1108.6616211f}};
			case 216:
				return {{1000.2603760f, 1108.6586914f}};
			case 217:
				return {{1000.2650146f, 1108.6585693f}};
			case 218:
				return {{1000.3426514f, 1108.6542969f}};
			case 219:
				return {{1000.3490601f, 1108.6540527f}};
			case 220:
				return {{1000.4306030f, 1108.6489258f}};
			case 221:
				return {{1000.4366455f, 1108.6485596f}};
			case 222:
				return {{1000.5327759f, 1108.6416016f}};
			case 223:
				return {{1000.5404053f, 1108.6401367f}};
			case 224:
				return {{1000.6363525f, 1108.6322021f}};
			case 225:
				return {{1000.6445312f, 1108.6315918f}};
			case 226:
				return {{1000.7532959f, 1108.6223145f}};
			case 227:
				return {{1000.7587891f, 1108.6206055f}};
			case 228:
				return {{1000.8715210f, 1108.6094971f}};
			case 229:
				return {{1000.8785400f, 1108.6086426f}};
			case 230:
				return {{1001.0937500f, 1108.5819092f}};
			case 231:
				return {{1001.1939697f, 1108.5643311f}};
			case 232:
				return {{1001.2001953f, 1108.5643311f}};
			case 233:
				return {{1001.2053223f, 1108.5621338f}};
			case 234:
				return {{1001.2844238f, 1108.5454102f}};
			case 235:
				return {{1001.3491211f, 1108.5285645f}};
			case 236:
				return {{1001.3531494f, 1108.5273438f}};
			case 237:
				return {{1001.3872070f, 1108.5092773f}};
			case 238:
				return {{1001.3878174f, 1108.5090332f}};
			case 239:
				return {{1001.3823242f, 1108.4912109f}};
			case 240:
				return {{1001.3808594f, 1108.4919434f}};
			case 241:
				return {{1001.3131714f, 1108.4786377f}};
			case 242:
				return {{1001.3062744f, 1108.4782715f}};
			case 243:
				return {{1001.1593018f, 1108.4746094f}};
			case 244:
				return {{1001.1457520f, 1108.4750977f}};
			case 245:
				return {{1000.8648682f, 1108.4920654f}};
			case 246:
				return {{1000.8426514f, 1108.4946289f}};
			case 247:
				return {{1000.3900757f, 1108.5585938f}};
			case 248:
				return {{1000.3546753f, 1108.5644531f}};
			case 249:
				return {{999.7448730f, 1108.7012939f}};
			case 250:
				return {{999.6972656f, 1108.7124023f}};
			case 251:
				return {{998.8678589f, 1108.9846191f}};
			case 252:
				return {{998.8115845f, 1109.0054932f}};
			case 253:
				return {{998.7551880f, 1109.0275879f}};
			case 254:
				return {{997.1427002f, 1109.8775635f}};
			case 255:
				return {{996.6433105f, 1110.2592773f}};
			case 256:
				return {{996.6222534f, 1110.2785645f}};
			case 257:
				return {{996.4305420f, 1110.4781494f}};
			case 258:
				return {{996.4260864f, 1110.4863281f}};
			case 259:
				return {{996.4226685f, 1110.4914551f}};
			case 260:
				return {{996.4686279f, 1110.5217285f}};
			case 261:
				return {{996.4775391f, 1110.5178223f}};
			case 262:
				return {{996.6821899f, 1110.4218750f}};
			case 263:
				return {{996.6988525f, 1110.4134521f}};
			case 264:
				return {{996.9692383f, 1110.2630615f}};
			case 265:
				return {{997.2871094f, 1110.0822754f}};
			case 266:
				return {{997.3081055f, 1110.0703125f}};
			case 267:
				return {{997.6099243f, 1109.9001465f}};
			case 268:
				return {{997.6297607f, 1109.8891602f}};
			case 269:
				return {{997.9351807f, 1109.7214355f}};
			case 270:
				return {{997.9528198f, 1109.7124023f}};
			case 271:
				return {{998.2310791f, 1109.5637207f}};
			case 272:
				return {{998.2484131f, 1109.5555420f}};
			case 273:
				return {{998.4820557f, 1109.4348145f}};
			case 274:
				return {{998.4973145f, 1109.4266357f}};
			case 275:
				return {{998.5106201f, 1109.4195557f}};
			case 276:
				return {{998.7292480f, 1109.3074951f}};
			case 277:
				return {{998.7424316f, 1109.3022461f}};
			case 278:
				return {{998.7547607f, 1109.2961426f}};
			case 279:
				return {{998.9426270f, 1109.2006836f}};
			case 280:
				return {{999.0966187f, 1109.1251221f}};
			case 281:
				return {{999.2407837f, 1109.0534668f}};
			case 282:
				return {{999.2497559f, 1109.0478516f}};
			case 283:
				return {{999.2573242f, 1109.0433350f}};
			case 284:
				return {{999.3726196f, 1108.9852295f}};
			case 285:
				return {{999.3793335f, 1108.9825439f}};
			case 286:
				return {{999.3870850f, 1108.9768066f}};
			case 287:
				return {{999.4901123f, 1108.9246826f}};
			case 288:
				return {{999.4957886f, 1108.9218750f}};
			case 289:
				return {{999.5025024f, 1108.9190674f}};
			case 290:
				return {{999.5889282f, 1108.8723145f}};
			case 291:
				return {{999.5947266f, 1108.8704834f}};
			case 292:
				return {{999.5994873f, 1108.8674316f}};
			case 293:
				return {{999.6671143f, 1108.8288574f}};
			case 294:
				return {{999.6710205f, 1108.8265381f}};
			case 295:
				return {{999.7323608f, 1108.7929688f}};
			case 296:
				return {{999.7351685f, 1108.7915039f}};
			case 297:
				return {{999.7388916f, 1108.7879639f}};
			case 298:
				return {{999.7897339f, 1108.7584229f}};
			case 299:
				return {{999.7925415f, 1108.7565918f}};
			case 300:
				return {{999.7943726f, 1108.7548828f}};
			case 301:
				return {{999.8328857f, 1108.7298584f}};
			case 302:
				return {{999.8358765f, 1108.7287598f}};
			case 303:
				return {{999.8676147f, 1108.7080078f}};
			case 304:
				return {{999.8703613f, 1108.7060547f}};
			case 305:
				return {{999.8730469f, 1108.7049561f}};
			case 306:
				return {{999.8983765f, 1108.6879883f}};
			case 307:
				return {{999.8984375f, 1108.6873779f}};
			case 308:
				return {{999.9226074f, 1108.6739502f}};
			case 309:
				return {{999.9411621f, 1108.6623535f}};
			case 310:
				return {{999.9420776f, 1108.6623535f}};
			case 311:
				return {{999.9571533f, 1108.6558838f}};
			case 312:
				return {{999.9573364f, 1108.6561279f}};
			case 313:
				return {{999.9584961f, 1108.6535645f}};
			case 314:
				return {{999.9722290f, 1108.6480713f}};
			case 315:
				return {{999.9716797f, 1108.6501465f}};
			case 316:
				return {{999.9731445f, 1108.6489258f}};
			case 317:
				return {{999.9818115f, 1108.6470947f}};
			case 318:
				return {{999.9836426f, 1108.6464844f}};
			case 319:
				return {{999.9904785f, 1108.6441650f}};
			case 320:
				return {{999.9926758f, 1108.6440430f}};
			case 321:
				return {{999.9916992f, 1108.6440430f}};
			case 322:
				return {{999.9976196f, 1108.6448975f}};
			case 323:
				return {{999.9981689f, 1108.6452637f}};
			case 324:
				return {{999.9986572f, 1108.6445312f}};
			case 325:
				return {{1000.0029297f, 1108.6458740f}};
			case 326:
				return {{1000.0027466f, 1108.6453857f}};
			case 327:
				return {{1000.0037231f, 1108.6463623f}};
			case 328:
				return {{1000.0067749f, 1108.6461182f}};
			case 329:
				return {{1000.0061646f, 1108.6473389f}};
			case 330:
				return {{1000.0066528f, 1108.6473389f}};
			case 331:
				return {{1000.0090942f, 1108.6489258f}};
			case 332:
				return {{1000.0101318f, 1108.6484375f}};
			case 333:
				return {{1000.0090942f, 1108.6488037f}};
			case 334:
				return {{1000.0112915f, 1108.6506348f}};
			case 335:
				return {{1000.0109253f, 1108.6512451f}};
			case 336:
				return {{1000.0115356f, 1108.6510010f}};
			case 337:
				return {{1000.0108643f, 1108.6525879f}};
			case 338:
				return {{1000.0122681f, 1108.6524658f}};
			case 339:
				return {{1000.0115967f, 1108.6524658f}};
			case 340:
				return {{1000.0112305f, 1108.6535645f}};
			case 341:
				return {{1000.0122070f, 1108.6547852f}};
			case 342:
				return {{1000.0111084f, 1108.6567383f}};
			case 343:
				return {{1000.0098877f, 1108.6580811f}};
			case 344:
				return {{1000.0106812f, 1108.6577148f}};
			case 345:
				return {{1000.0101318f, 1108.6595459f}};
			case 346:
				return {{1000.0096436f, 1108.6599121f}};
			case 347:
				return {{1000.0097046f, 1108.6599121f}};
			case 348:
				return {{1000.0090942f, 1108.6618652f}};
			case 349:
				return {{1000.0072021f, 1108.6623535f}};
			case 350:
				return {{1000.0074463f, 1108.6611328f}};
			case 351:
				return {{1000.0078125f, 1108.6608887f}};
			case 352:
				return {{1000.0072021f, 1108.6630859f}};
			case 353:
				return {{1000.0073853f, 1108.6628418f}};
			case 354:
				return {{1000.0060425f, 1108.6646729f}};
			case 355:
				return {{1000.0072021f, 1108.6634521f}};
			case 356:
				return {{1000.0061035f, 1108.6632080f}};
			case 357:
				return {{1000.0057373f, 1108.6636963f}};
			case 358:
				return {{1000.0057983f, 1108.6635742f}};
			case 359:
				return {{1000.0046387f, 1108.6636963f}};
			case 360:
				return {{1000.0047607f, 1108.6636963f}};
			case 361:
				return {{1000.0048218f, 1108.6636963f}};
			case 362:
				return {{1000.0042114f, 1108.6652832f}};
			case 363:
				return {{1000.0042114f, 1108.6652832f}};
			case 364:
				return {{1000.0042114f, 1108.6652832f}};
			case 365:
				return {{1000.0042114f, 1108.6652832f}};
			case 366:
				return {{1000.0042114f, 1108.6650391f}};
			case 367:
				return {{1000.0042114f, 1108.6650391f}};
			case 368:
				return {{1000.0039062f, 1108.6671143f}};
			case 369:
				return {{1000.0039062f, 1108.6671143f}};
			case 370:
				return {{1000.0025024f, 1108.6663818f}};
			case 371:
				return {{1000.0024414f, 1108.6663818f}};
			case 372:
				return {{1000.0023804f, 1108.6663818f}};
			case 373:
				return {{1000.0018311f, 1108.6655273f}};
			case 374:
				return {{1000.0012207f, 1108.6658936f}};
			case 375:
				return {{1000.0015869f, 1108.6665039f}};
			case 376:
				return {{1000.0015259f, 1108.6663818f}};
			case 377:
				return {{1000.0014648f, 1108.6663818f}};
			case 378:
				return {{1000.0008545f, 1108.6667480f}};
			case 379:
				return {{1000.0008545f, 1108.6667480f}};
			case 380:
				return {{1000.0007324f, 1108.6667480f}};
			case 381:
				return {{1000.0002441f, 1108.6671143f}};
			case 382:
				return {{1000.0011597f, 1108.6672363f}};
			case 383:
				return {{1000.0010986f, 1108.6672363f}};
			case 384:
				return {{999.9996338f, 1108.6663818f}};
			case 385:
				return {{1000.0005493f, 1108.6665039f}};
			case 386:
				return {{1000.0004883f, 1108.6665039f}};
			case 387:
				return {{999.9999390f, 1108.6668701f}};
			case 388:
				return {{1000.0009155f, 1108.6667480f}};
			case 389:
				return {{999.9993896f, 1108.6661377f}};
			case 390:
				return {{999.9993896f, 1108.6661377f}};
			case 391:
				return {{999.9993896f, 1108.6661377f}};
			case 392:
				return {{999.9990845f, 1108.6666260f}};
			case 393:
				return {{999.9990845f, 1108.6666260f}};
			case 394:
				return {{999.9990845f, 1108.6666260f}};
			case 395:
				return {{999.9997559f, 1108.6669922f}};
			case 396:
				return {{999.9997559f, 1108.6669922f}};
			case 397:
				return {{999.9997559f, 1108.6669922f}};
			case 398:
				return {{999.9995117f, 1108.6658936f}};
			case 399:
				return {{999.9995117f, 1108.6658936f}};
			case 400:
				return {{1000.0002441f, 1108.6661377f}};
			case 401:
				return {{1000.0002441f, 1108.6661377f}};
			case 402:
				return {{1000.0002441f, 1108.6661377f}};
			case 403:
				return {{1000.0000610f, 1108.6655273f}};
			case 404:
				return {{1000.0000610f, 1108.6655273f}};
			case 405:
				return {{1000.0000610f, 1108.6655273f}};
			case 406:
				return {{999.9999390f, 1108.6666260f}};
			case 407:
				return {{1000.0006714f, 1108.6667480f}};
			case 408:
				return {{999.9996338f, 1108.6668701f}};
			case 409:
				return {{999.9996338f, 1108.6668701f}};
			case 410:
				return {{999.9996338f, 1108.6668701f}};
			case 411:
				return {{999.9993896f, 1108.6669922f}};
			case 412:
				return {{999.9993896f, 1108.6669922f}};
			case 413:
				return {{999.9993896f, 1108.6669922f}};
			case 414:
				return {{1000.0004883f, 1108.6660156f}};
			case 415:
				return {{1000.0004883f, 1108.6660156f}};
			case 416:
				return {{1000.0004883f, 1108.6660156f}};
			case 417:
				return {{1000.0004883f, 1108.6672363f}};
			case 418:
				return {{1000.0004883f, 1108.6672363f}};
			case 419:
				return {{1000.0004883f, 1108.6672363f}};
			case 420:
				return {{1000.0003662f, 1108.6673584f}};
			case 421:
				return {{1000.0003662f, 1108.6673584f}};
			case 422:
				return {{1000.0003052f, 1108.6674805f}};
			case 423:
				return {{1000.0003052f, 1108.6674805f}};
			case 424:
				return {{1000.0003052f, 1108.6674805f}};
			case 425:
				return {{1000.0002441f, 1108.6674805f}};
			case 426:
				return {{1000.0002441f, 1108.6674805f}};
			case 427:
				return {{1000.0002441f, 1108.6674805f}};
			case 428:
				return {{1000.0001221f, 1108.6674805f}};
			case 429:
				return {{1000.0001221f, 1108.6674805f}};
			case 430:
				return {{1000.0001221f, 1108.6674805f}};
			case 431:
				return {{1000.0001221f, 1108.6674805f}};
			case 432:
				return {{1000.0001221f, 1108.6674805f}};
			case 433:
				return {{1000.0001221f, 1108.6674805f}};
			case 434:
				return {{1000.0001221f, 1108.6674805f}};
			case 435:
				return {{1000.0001221f, 1108.6674805f}};
			case 436:
				return {{1000.0001221f, 1108.6674805f}};
			case 437:
				return {{1000.0001221f, 1108.6674805f}};
			case 438:
				return {{1000.0001221f, 1108.6674805f}};
			case 439:
				return {{1000.0001221f, 1108.6674805f}};
			case 440:
				return {{1000.0001221f, 1108.6674805f}};
			case 441:
				return {{1000.0001221f, 1108.6674805f}};
			case 442:
				return {{1000.0001221f, 1108.6674805f}};
			case 443:
				return {{1000.0001221f, 1108.6674805f}};
			case 444:
				return {{1000.0001221f, 1108.6674805f}};
			case 445:
				return {{1000.0001221f, 1108.6674805f}};
			case 446:
				return {{1000.0001221f, 1108.6674805f}};
			case 447:
				return {{1000.0001221f, 1108.6674805f}};
			case 448:
				return {{1000.0001221f, 1108.6674805f}};
			case 449:
				return {{1000.0001221f, 1108.6674805f}};
			case 450:
				return {{1000.0001221f, 1108.6674805f}};
			case 451:
				return {{1000.0001221f, 1108.6674805f}};
			case 452:
				return {{1000.0001221f, 1108.6674805f}};
			case 453:
				return {{1000.0001221f, 1108.6674805f}};
			case 454:
				return {{1000.0001221f, 1108.6674805f}};
			case 455:
				return {{1000.0001221f, 1108.6674805f}};
			case 456:
				return {{1000.0001221f, 1108.6674805f}};
			case 457:
				return {{1000.0001221f, 1108.6674805f}};
			case 458:
				return {{1000.0001221f, 1108.6674805f}};
			case 459:
				return {{1000.0001221f, 1108.6674805f}};
			case 460:
				return {{1000.0001221f, 1108.6674805f}};
			case 461:
				return {{1000.0001221f, 1108.6674805f}};
			case 462:
				return {{1000.0001221f, 1108.6674805f}};
			case 463:
				return {{1000.0001221f, 1108.6674805f}};
			case 464:
				return {{1000.0001221f, 1108.6674805f}};
			case 465:
				return {{1000.0001221f, 1108.6674805f}};
			case 466:
				return {{1000.0001221f, 1108.6674805f}};
			case 467:
				return {{1000.0001221f, 1108.6674805f}};
			case 468:
				return {{1000.0001221f, 1108.6674805f}};
			case 469:
				return {{1000.0001221f, 1108.6674805f}};
			case 470:
				return {{1000.0001221f, 1108.6674805f}};
			case 471:
				return {{1000.0001221f, 1108.6674805f}};
			case 472:
				return {{1000.0001221f, 1108.6674805f}};
			case 473:
				return {{1000.0001221f, 1108.6674805f}};
			case 474:
				return {{1000.0001221f, 1108.6674805f}};
			case 475:
				return {{1000.0001221f, 1108.6674805f}};
			case 476:
				return {{1000.0001221f, 1108.6674805f}};
			case 477:
				return {{1000.0001221f, 1108.6674805f}};
			case 478:
				return {{1000.0001221f, 1108.6674805f}};
			case 479:
				return {{1000.0001221f, 1108.6674805f}};
			case 480:
				return {{1000.0001221f, 1108.6674805f}};
			case 481:
				return {{1000.0001221f, 1108.6674805f}};
			case 482:
				return {{1000.0001221f, 1108.6674805f}};
			case 483:
				return {{1000.0001221f, 1108.6674805f}};
			case 484:
				return {{1000.0001221f, 1108.6674805f}};
			case 485:
				return {{1000.0001221f, 1108.6674805f}};
			case 486:
				return {{1000.0001221f, 1108.6674805f}};
			case 487:
				return {{1000.0001221f, 1108.6674805f}};
			case 488:
				return {{1000.0001221f, 1108.6674805f}};
			case 489:
				return {{1000.0001221f, 1108.6674805f}};
			case 490:
				return {{1000.0001221f, 1108.6674805f}};
			case 491:
				return {{1000.0001221f, 1108.6674805f}};
			case 492:
				return {{1000.0001221f, 1108.6674805f}};
			case 493:
				return {{1000.0001221f, 1108.6674805f}};
			case 494:
				return {{1000.0001221f, 1108.6674805f}};
			case 495:
				return {{1000.0001221f, 1108.6674805f}};
			case 496:
				return {{1000.0001221f, 1108.6674805f}};
			case 497:
				return {{1000.0001221f, 1108.6674805f}};
			case 498:
				return {{1000.0001221f, 1108.6674805f}};
			case 499:
				return {{1000.0001221f, 1108.6674805f}};
			case 500:
				return {{1000.0001221f, 1108.6674805f}};
			case 501:
				return {{1000.0001221f, 1108.6674805f}};
			case 502:
				return {{1000.0001221f, 1108.6674805f}};
			case 503:
				return {{1000.0000610f, 1108.6673584f}};
			case 504:
				return {{999.9997559f, 1108.6671143f}};
			case 505:
				return {{1000.0000000f, 1108.6660156f}};
			case 506:
				return {{1000.0003662f, 1108.6665039f}};
			case 507:
				return {{999.9996948f, 1108.6669922f}};
			case 508:
				return {{999.9998779f, 1108.6669922f}};
			case 509:
				return {{999.9990845f, 1108.6673584f}};
			case 510:
				return {{999.9996948f, 1108.6679688f}};
			case 511:
				return {{1000.0001221f, 1108.6671143f}};
			case 512:
				return {{1000.0006104f, 1108.6662598f}};
			case 513:
				return {{1000.0003052f, 1108.6679688f}};
			case 514:
				return {{1000.0001221f, 1108.6668701f}};
			case 515:
				return {{1000.0000000f, 1108.6667480f}};
			case 516:
				return {{1000.0003662f, 1108.6669922f}};
			case 517:
				return {{1000.0000000f, 1108.6665039f}};
			case 518:
				return {{999.9998779f, 1108.6680908f}};
			case 519:
				return {{1000.0000610f, 1108.6672363f}};
			case 520:
				return {{1000.0002441f, 1108.6677246f}};
			case 521:
				return {{999.9996948f, 1108.6667480f}};
			case 522:
				return {{1000.0004883f, 1108.6671143f}};
			case 523:
				return {{1000.0001221f, 1108.6660156f}};
			case 524:
				return {{1000.0001221f, 1108.6676025f}};
			case 525:
				return {{1000.0000000f, 1108.6673584f}};
			case 526:
				return {{1000.0010986f, 1108.6677246f}};
			case 527:
				return {{999.9998779f, 1108.6660156f}};
			case 528:
				return {{1000.0002441f, 1108.6667480f}};
			case 529:
				return {{999.9997559f, 1108.6667480f}};
			case 530:
				return {{1000.0009155f, 1108.6671143f}};
			case 531:
				return {{999.9993896f, 1108.6672363f}};
			case 532:
				return {{1000.0003052f, 1108.6668701f}};
			case 533:
				return {{1000.0003052f, 1108.6660156f}};
			case 534:
				return {{999.9999390f, 1108.6671143f}};
			case 535:
				return {{1000.0003052f, 1108.6668701f}};
			case 536:
				return {{1000.0005493f, 1108.6667480f}};
			case 537:
				return {{1000.0002441f, 1108.6667480f}};
			case 538:
				return {{1000.0004883f, 1108.6667480f}};
			case 539:
				return {{1000.0006714f, 1108.6677246f}};
			case 540:
				return {{1000.0002441f, 1108.6671143f}};
			case 541:
				return {{1000.0007324f, 1108.6674805f}};
			case 542:
				return {{999.9993896f, 1108.6661377f}};
			case 543:
				return {{1000.0000000f, 1108.6682129f}};
			case 544:
				return {{1000.0003052f, 1108.6662598f}};
			case 545:
				return {{999.9999390f, 1108.6658936f}};
			case 546:
				return {{1000.0004883f, 1108.6671143f}};
			case 547:
				return {{1000.0000000f, 1108.6672363f}};
			case 548:
				return {{1000.0000000f, 1108.6666260f}};
			case 549:
				return {{1000.0006714f, 1108.6661377f}};
			case 550:
				return {{999.9998779f, 1108.6665039f}};
			case 551:
				return {{999.9996948f, 1108.6665039f}};
			case 552:
				return {{999.9996338f, 1108.6658936f}};
			case 553:
				return {{999.9997559f, 1108.6669922f}};
			case 554:
				return {{1000.0000610f, 1108.6669922f}};
			case 555:
				return {{999.9997559f, 1108.6663818f}};
			case 556:
				return {{1000.0002441f, 1108.6666260f}};
			case 557:
				return {{1000.0002441f, 1108.6667480f}};
			case 558:
				return {{1000.0008545f, 1108.6673584f}};
			case 559:
				return {{999.9996948f, 1108.6667480f}};
			case 560:
				return {{1000.0003052f, 1108.6665039f}};
			case 561:
				return {{999.9994507f, 1108.6658936f}};
			case 562:
				return {{1000.0000000f, 1108.6677246f}};
			case 563:
				return {{1000.0008545f, 1108.6668701f}};
			case 564:
				return {{1000.0000610f, 1108.6666260f}};
			case 565:
				return {{999.9998779f, 1108.6676025f}};
			case 566:
				return {{1000.0004883f, 1108.6674805f}};
			case 567:
				return {{999.9999390f, 1108.6669922f}};
			case 568:
				return {{1000.0003052f, 1108.6667480f}};
			case 569:
				return {{999.9998779f, 1108.6660156f}};
			case 570:
				return {{999.9998779f, 1108.6669922f}};
			case 571:
				return {{1000.0002441f, 1108.6658936f}};
			case 572:
				return {{999.9996338f, 1108.6662598f}};
			case 573:
				return {{999.9994507f, 1108.6667480f}};
			case 574:
				return {{1000.0003052f, 1108.6667480f}};
			case 575:
				return {{1000.0002441f, 1108.6671143f}};
			case 576:
				return {{1000.0001221f, 1108.6672363f}};
			case 577:
				return {{1000.0002441f, 1108.6662598f}};
			case 578:
				return {{1000.0000000f, 1108.6668701f}};
			case 579:
				return {{1000.0005493f, 1108.6677246f}};
			case 580:
				return {{1000.0006714f, 1108.6666260f}};
			case 581:
				return {{999.9996338f, 1108.6658936f}};
			case 582:
				return {{1000.0001221f, 1108.6658936f}};
			case 583:
				return {{999.9995117f, 1108.6665039f}};
			case 584:
				return {{999.9996948f, 1108.6660156f}};
			case 585:
				return {{1000.0006714f, 1108.6667480f}};
			case 586:
				return {{1000.0001221f, 1108.6669922f}};
			case 587:
				return {{999.9997559f, 1108.6658936f}};
			case 588:
				return {{999.9999390f, 1108.6672363f}};
			case 589:
				return {{1000.0001221f, 1108.6669922f}};
			case 590:
				return {{1000.0004883f, 1108.6663818f}};
			case 591:
				return {{999.9996948f, 1108.6665039f}};
			case 592:
				return {{999.9998779f, 1108.6668701f}};
			case 593:
				return {{1000.0003662f, 1108.6663818f}};
			case 594:
				return {{999.9996338f, 1108.6666260f}};
			case 595:
				return {{1000.0003052f, 1108.6662598f}};
			case 596:
				return {{1000.0001221f, 1108.6667480f}};
			case 597:
				return {{1000.0006104f, 1108.6667480f}};
			case 598:
				return {{1000.0000000f, 1108.6656494f}};
			case 599:
				return {{1000.0000610f, 1108.6658936f}};
			case 600:
				return {{999.9999390f, 1108.6660156f}};
			case 601:
				return {{999.9999390f, 1108.6657715f}};
			case 602:
				return {{999.9999390f, 1108.6665039f}};
			case 603:
				return {{1000.0109863f, 1108.6784668f}};
			case 604:
				return {{1000.0125732f, 1108.6799316f}};
			case 605:
				return {{1000.0333252f, 1108.7025146f}};
			case 606:
				return {{1000.0344849f, 1108.7052002f}};
			case 607:
				return {{1000.0360107f, 1108.7065430f}};
			case 608:
				return {{1000.0562744f, 1108.7272949f}};
			case 609:
				return {{1000.0571289f, 1108.7282715f}};
			case 610:
				return {{1000.0692749f, 1108.7430420f}};
			case 611:
				return {{1000.0704346f, 1108.7438965f}};
			case 612:
				return {{1000.0751343f, 1108.7497559f}};
			case 613:
				return {{1000.0756226f, 1108.7496338f}};
			case 614:
				return {{1000.0751343f, 1108.7492676f}};
			case 615:
				return {{1000.0749512f, 1108.7489014f}};
			case 616:
				return {{1000.0745239f, 1108.7490234f}};
			case 617:
				return {{1000.0693359f, 1108.7435303f}};
			case 618:
				return {{1000.0694580f, 1108.7431641f}};
			case 619:
				return {{1000.0692139f, 1108.7425537f}};
			case 620:
				return {{1000.0621338f, 1108.7354736f}};
			case 621:
				return {{1000.0619507f, 1108.7340088f}};
			case 622:
				return {{1000.0533447f, 1108.7255859f}};
			case 623:
				return {{1000.0534668f, 1108.7249756f}};
			case 624:
				return {{1000.0524292f, 1108.7250977f}};
			case 625:
				return {{1000.0446167f, 1108.7159424f}};
			case 626:
				return {{1000.0443115f, 1108.7154541f}};
			case 627:
				return {{1000.0433350f, 1108.7143555f}};
			case 628:
				return {{1000.0289307f, 1108.6987305f}};
			case 629:
				return {{1000.0279541f, 1108.6978760f}};
			case 630:
				return {{1000.0225220f, 1108.6904297f}};
			case 631:
				return {{1000.0218506f, 1108.6911621f}};
			case 632:
				return {{1000.0213013f, 1108.6904297f}};
			case 633:
				return {{1000.0158691f, 1108.6842041f}};
			case 634:
				return {{1000.0157471f, 1108.6835938f}};
			case 635:
				return {{1000.0116577f, 1108.6784668f}};
			case 636:
				return {{1000.0116577f, 1108.6784668f}};
			case 637:
				return {{1000.0110474f, 1108.6784668f}};
			case 638:
				return {{1000.0072021f, 1108.6756592f}};
			case 639:
				return {{1000.0076904f, 1108.6744385f}};
			case 640:
				return {{1000.0072021f, 1108.6744385f}};
			case 641:
				return {{1000.0045166f, 1108.6708984f}};
			case 642:
				return {{1000.0043335f, 1108.6711426f}};
			case 643:
				return {{1000.0021973f, 1108.6693115f}};
			case 644:
				return {{1000.0023193f, 1108.6690674f}};
			case 645:
				return {{1000.0017090f, 1108.6689453f}};
			case 646:
				return {{1000.0000610f, 1108.6672363f}};
			case 647:
				return {{1000.0007324f, 1108.6667480f}};
			case 648:
				return {{1000.0002441f, 1108.6667480f}};
			case 649:
				return {{999.9992676f, 1108.6662598f}};
			case 650:
				return {{999.9993896f, 1108.6658936f}};
			case 651:
				return {{999.9982910f, 1108.6647949f}};
			case 652:
				return {{999.9981079f, 1108.6641846f}};
			case 653:
				return {{999.9985352f, 1108.6643066f}};
			case 654:
				return {{999.9978638f, 1108.6639404f}};
			case 655:
				return {{999.9978638f, 1108.6646729f}};
			case 656:
				return {{999.9974976f, 1108.6643066f}};
			case 657:
				return {{999.9976807f, 1108.6638184f}};
			case 658:
				return {{999.9970093f, 1108.6644287f}};
			case 659:
				return {{999.9972534f, 1108.6633301f}};
			case 660:
				return {{999.9973145f, 1108.6634521f}};
			case 661:
				return {{999.9972534f, 1108.6632080f}};
			case 662:
				return {{999.9972534f, 1108.6632080f}};
			case 663:
				return {{999.9974976f, 1108.6640625f}};
			case 664:
				return {{999.9978027f, 1108.6645508f}};
			case 665:
				return {{999.9975586f, 1108.6643066f}};
			case 666:
				return {{999.9979248f, 1108.6640625f}};
			case 667:
				return {{999.9979248f, 1108.6640625f}};
			case 668:
				return {{999.9980469f, 1108.6647949f}};
			case 669:
				return {{999.9978638f, 1108.6645508f}};
			case 670:
				return {{999.9978638f, 1108.6645508f}};
			case 671:
				return {{999.9982300f, 1108.6647949f}};
			case 672:
				return {{999.9985352f, 1108.6644287f}};
			case 673:
				return {{999.9982300f, 1108.6647949f}};
			case 674:
				return {{999.9986572f, 1108.6644287f}};
			case 675:
				return {{999.9985352f, 1108.6652832f}};
			case 676:
				return {{999.9988403f, 1108.6646729f}};
			case 677:
				return {{999.9986572f, 1108.6652832f}};
			case 678:
				return {{999.9986572f, 1108.6652832f}};
			case 679:
				return {{999.9988403f, 1108.6660156f}};
			case 680:
				return {{999.9991455f, 1108.6656494f}};
			case 681:
				return {{999.9988403f, 1108.6654053f}};
			case 682:
				return {{999.9992676f, 1108.6651611f}};
			case 683:
				return {{999.9992676f, 1108.6651611f}};
			case 684:
				return {{999.9995117f, 1108.6658936f}};
			case 685:
				return {{999.9993896f, 1108.6656494f}};
			case 686:
				return {{999.9989014f, 1108.6652832f}};
			case 687:
				return {{999.9999390f, 1108.6651611f}};
			case 688:
				return {{1000.0000000f, 1108.6654053f}};
			case 689:
				return {{999.9994507f, 1108.6658936f}};
			case 690:
				return {{999.9993896f, 1108.6655273f}};
			case 691:
				return {{999.9993286f, 1108.6666260f}};
			case 692:
				return {{999.9993286f, 1108.6666260f}};
			case 693:
				return {{999.9993896f, 1108.6668701f}};
			case 694:
				return {{1000.0000000f, 1108.6667480f}};
			case 695:
				return {{1000.0000000f, 1108.6667480f}};
			case 696:
				return {{1000.0005493f, 1108.6667480f}};
			case 697:
				return {{1000.0005493f, 1108.6667480f}};
			case 698:
				return {{1000.0000610f, 1108.6667480f}};
			case 699:
				return {{1000.0000000f, 1108.6666260f}};
			case 700:
				return {{1000.0000610f, 1108.6667480f}};
			case 701:
				return {{1000.0000610f, 1108.6666260f}};
			case 702:
				return {{1000.0001221f, 1108.6666260f}};
			case 703:
				return {{1000.0000610f, 1108.6665039f}};
			case 704:
				return {{1000.0000610f, 1108.6665039f}};
			case 705:
				return {{1000.0000610f, 1108.6665039f}};
			case 706:
				return {{1000.0000610f, 1108.6665039f}};
			case 707:
				return {{1000.0000610f, 1108.6665039f}};
			case 708:
				return {{1000.0000610f, 1108.6665039f}};
			case 709:
				return {{1000.0000610f, 1108.6665039f}};
			case 710:
				return {{1000.0001221f, 1108.6665039f}};
			case 711:
				return {{1000.0000610f, 1108.6665039f}};
			case 712:
				return {{1000.0000610f, 1108.6665039f}};
			case 713:
				return {{1000.0000610f, 1108.6665039f}};
			case 714:
				return {{1000.0000610f, 1108.6665039f}};
			case 715:
				return {{1000.0000610f, 1108.6665039f}};
			case 716:
				return {{1000.0000610f, 1108.6665039f}};
			case 717:
				return {{1000.0000610f, 1108.6665039f}};
			case 718:
				return {{1000.0000610f, 1108.6665039f}};
			case 719:
				return {{1000.0000610f, 1108.6665039f}};
			case 720:
				return {{1000.0000610f, 1108.6665039f}};
			case 721:
				return {{1000.0000610f, 1108.6665039f}};
			case 722:
				return {{1000.0000610f, 1108.6665039f}};
			case 723:
				return {{1000.0000610f, 1108.6665039f}};
			case 724:
				return {{1000.0000610f, 1108.6665039f}};
			case 725:
				return {{1000.0000610f, 1108.6665039f}};
			case 726:
				return {{1000.0000610f, 1108.6665039f}};
			case 727:
				return {{1000.0000610f, 1108.6665039f}};
			case 728:
				return {{1000.0000610f, 1108.6665039f}};
			case 729:
				return {{1000.0000610f, 1108.6665039f}};
			case 730:
				return {{1000.0000610f, 1108.6665039f}};
			case 731:
				return {{1000.0000610f, 1108.6665039f}};
			case 732:
				return {{1000.0000610f, 1108.6665039f}};
			case 733:
				return {{1000.0000610f, 1108.6665039f}};
			case 734:
				return {{1000.0000610f, 1108.6665039f}};
			case 735:
				return {{1000.0000610f, 1108.6665039f}};
			case 736:
				return {{1000.0000610f, 1108.6665039f}};
			case 737:
				return {{1000.0000610f, 1108.6665039f}};
			case 738:
				return {{1000.0000610f, 1108.6665039f}};
			case 739:
				return {{1000.0000610f, 1108.6665039f}};
			case 740:
				return {{1000.0000610f, 1108.6665039f}};
			case 741:
				return {{1000.0000610f, 1108.6665039f}};
			case 742:
				return {{1000.0000610f, 1108.6665039f}};
			case 743:
				return {{1000.0000610f, 1108.6665039f}};
			case 744:
				return {{1000.0000610f, 1108.6665039f}};
			case 745:
				return {{1000.0000610f, 1108.6665039f}};
			case 746:
				return {{1000.0000610f, 1108.6665039f}};
			case 747:
				return {{1000.0000610f, 1108.6665039f}};
			case 748:
				return {{1000.0000610f, 1108.6665039f}};
			case 749:
				return {{1000.0000610f, 1108.6665039f}};
			case 750:
				return {{1000.0000610f, 1108.6665039f}};
			case 751:
				return {{1000.0000610f, 1108.6665039f}};
			case 752:
				return {{1000.0000610f, 1108.6665039f}};
			case 753:
				return {{1000.0000610f, 1108.6665039f}};
			case 754:
				return {{1000.0000610f, 1108.6665039f}};
			case 755:
				return {{1000.0001221f, 1108.6665039f}};
			case 756:
				return {{1000.0001221f, 1108.6665039f}};
			case 757:
				return {{1000.0000610f, 1108.6665039f}};
			case 758:
				return {{1000.0001221f, 1108.6665039f}};
			case 759:
				return {{1000.0000610f, 1108.6665039f}};
			case 760:
				return {{1000.0000610f, 1108.6665039f}};
			case 761:
				return {{1000.0000610f, 1108.6665039f}};
			case 762:
				return {{1000.0000610f, 1108.6665039f}};
			case 763:
				return {{1000.0000610f, 1108.6665039f}};
			case 764:
				return {{1000.0000610f, 1108.6665039f}};
			case 765:
				return {{1000.0000610f, 1108.6665039f}};
			case 766:
				return {{1000.0000610f, 1108.6665039f}};
			case 767:
				return {{1000.0000610f, 1108.6665039f}};
			case 768:
				return {{1000.0000610f, 1108.6665039f}};
			case 769:
				return {{1000.0000610f, 1108.6665039f}};
			case 770:
				return {{1000.0000610f, 1108.6665039f}};
			case 771:
				return {{1000.0000610f, 1108.6665039f}};
			case 772:
				return {{1000.0000610f, 1108.6665039f}};
			case 773:
				return {{1000.0000610f, 1108.6665039f}};
			case 774:
				return {{1000.0000610f, 1108.6665039f}};
			case 775:
				return {{1000.0000610f, 1108.6665039f}};
			case 776:
				return {{1000.0001221f, 1108.6665039f}};
			case 777:
				return {{1000.0001221f, 1108.6665039f}};
			case 778:
				return {{1000.0001221f, 1108.6665039f}};
			case 779:
				return {{1000.0001221f, 1108.6665039f}};
			case 780:
				return {{1000.0001221f, 1108.6665039f}};
			case 781:
				return {{1000.0001221f, 1108.6665039f}};
			case 782:
				return {{1000.0001221f, 1108.6665039f}};
			case 783:
				return {{1000.0001221f, 1108.6665039f}};
			case 784:
				return {{1000.0001221f, 1108.6665039f}};
			case 785:
				return {{1000.0001221f, 1108.6665039f}};
			case 786:
				return {{1000.0001221f, 1108.6665039f}};
			case 787:
				return {{1000.0001221f, 1108.6665039f}};
			case 788:
				return {{1000.0001221f, 1108.6665039f}};
			case 789:
				return {{1000.0001221f, 1108.6665039f}};
			case 790:
				return {{1000.0001221f, 1108.6665039f}};
			case 791:
				return {{1000.0001221f, 1108.6665039f}};
			case 792:
				return {{1000.0001221f, 1108.6665039f}};
			case 793:
				return {{1000.0001221f, 1108.6665039f}};
			case 794:
				return {{1000.0001221f, 1108.6665039f}};
			case 795:
				return {{1000.0000610f, 1108.6665039f}};
			case 796:
				return {{1000.0000610f, 1108.6665039f}};
			case 797:
				return {{1000.0000610f, 1108.6665039f}};
			case 798:
				return {{1000.0000610f, 1108.6665039f}};
			case 799:
				return {{1000.0000610f, 1108.6665039f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[13])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -7.4373074f}};
			case 201:
				return {{1000.0000000f, 1110.8963623f}};
			case 602:
				return {{1000.8431396f, 1109.5930176f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[14])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -9.9486294f}};
			case 201:
				return {{1000.0000000f, 1112.4274902f}};
			case 602:
				return {{1001.5410156f, 1110.3586426f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[15])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -12.0339508f}};
			case 201:
				return {{1000.0000000f, 1113.4934082f}};
			case 602:
				return {{1002.0995483f, 1110.9719238f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		assert(false); // Shouldn't be any unaccounted raycasts
		return std::nullopt;
	}
};
// NOLINTEND(bugprone-branch-clone, google-readability-function-size, readability-function-size)
