/*******************************************************************************
 * Copyright (c) 2018-2024 openblack developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/openblack/openblack
 *
 * openblack is licensed under the GNU General Public License version 3.
 *******************************************************************************/

#pragma once

#include "Mock.h"

class DoubleClickFlyToMockAction final: public MockAction
{
public:
	~DoubleClickFlyToMockAction() final = default;

	[[nodiscard]] bool GetUnbindable(openblack::input::UnbindableActionMap action) const final
	{
		using openblack::input::UnbindableActionMap;
		if (frameNumber == k_StabilizeFrames + 1)
		{
			return (static_cast<uint32_t>(action) & static_cast<uint32_t>(UnbindableActionMap::DOUBLE_CLICK)) != 0;
		}

		return false;
	}

	[[nodiscard]] std::array<std::optional<glm::vec3>, 2> GetHandPositions() const final
	{
		return {{{}, {{1080.70996f, 0.0f, 966.307434f}}}};
	}

	[[nodiscard]] glm::uvec2 GetMousePosition() const final { return {100, 600 - 290}; }
};

// NOLINTBEGIN(bugprone-branch-clone, google-readability-function-size, readability-function-size)
class DoubleClickFlyToMockDynamicsSystem: public MockDynamicsSystem
{
public:
	DoubleClickFlyToMockDynamicsSystem() = default;

	[[nodiscard]] std::optional<glm::vec2> RayCastClosestHitScreenCoord(glm::u16vec2 screenCoord) const override
	{
		if (screenCoord == glm::u16vec2(100, 310))
		{
			switch (frameNumber)
			{
			case 0:
				return {{-25.3900986f, 14.0252552f}};
			case 1:
				return {{1029.1203613f, 1064.5491943f}};
			case 2:
				return {{1029.1135254f, 1064.5766602f}};
			case 3:
				return {{1028.5572510f, 1065.6354980f}};
			case 4:
				return {{1028.4062500f, 1065.9229736f}};
			case 5:
				return {{1028.3969727f, 1065.9406738f}};
			case 6:
				return {{1028.3879395f, 1065.9580078f}};
			case 7:
				return {{1028.2517090f, 1066.2174072f}};
			case 8:
				return {{1028.2438965f, 1066.2319336f}};
			case 9:
				return {{1028.1279297f, 1066.4528809f}};
			case 10:
				return {{1028.1210938f, 1066.4658203f}};
			case 11:
				return {{1028.1142578f, 1066.4787598f}};
			case 12:
				return {{1028.0216064f, 1066.6552734f}};
			case 13:
				return {{1028.0156250f, 1066.6666260f}};
			case 14:
				return {{1028.0101318f, 1066.6770020f}};
			case 15:
				return {{1028.0042725f, 1066.6883545f}};
			case 16:
				return {{1027.9200439f, 1066.8487549f}};
			case 17:
				return {{1027.9147949f, 1066.8586426f}};
			case 18:
				return {{1027.8454590f, 1066.9907227f}};
			case 19:
				return {{1027.7796631f, 1067.1157227f}};
			case 20:
				return {{1027.7214355f, 1067.2266846f}};
			case 21:
				return {{1027.7178955f, 1067.2335205f}};
			case 22:
				return {{1027.6689453f, 1067.3266602f}};
			case 23:
				return {{1027.6658936f, 1067.3323975f}};
			case 24:
				return {{1027.6188965f, 1067.4218750f}};
			case 25:
				return {{1027.6162109f, 1067.4271240f}};
			case 26:
				return {{1027.5738525f, 1067.5075684f}};
			case 27:
				return {{1027.5712891f, 1067.5124512f}};
			case 28:
				return {{1027.5355225f, 1067.5806885f}};
			case 29:
				return {{1027.5332031f, 1067.5849609f}};
			case 30:
				return {{1027.4984131f, 1067.6512451f}};
			case 31:
				return {{1027.4959717f, 1067.6560059f}};
			case 32:
				return {{1027.4661865f, 1067.7125244f}};
			case 33:
				return {{1027.4642334f, 1067.7163086f}};
			case 34:
				return {{1027.4345703f, 1067.7727051f}};
			case 35:
				return {{1027.4328613f, 1067.7761230f}};
			case 36:
				return {{1027.4057617f, 1067.8276367f}};
			case 37:
				return {{1027.4040527f, 1067.8309326f}};
			case 38:
				return {{1027.4024658f, 1067.8337402f}};
			case 39:
				return {{1028.4942627f, 1065.7554932f}};
			case 40:
				return {{1028.5811768f, 1065.5703125f}};
			case 41:
				return {{1030.0968018f, 1062.6896973f}};
			case 42:
				return {{1030.1918945f, 1062.5092773f}};
			case 43:
				return {{1031.7077637f, 1059.6191406f}};
			case 44:
				return {{1033.1256104f, 1056.9296875f}};
			case 45:
				return {{1034.6220703f, 1054.0552979f}};
			case 46:
				return {{1034.7279053f, 1053.8835449f}};
			case 47:
				return {{1036.1262207f, 1051.1875000f}};
			case 48:
				return {{1036.2325439f, 1051.0299072f}};
			case 49:
				return {{1037.7147217f, 1048.1834717f}};
			case 50:
				return {{1037.8052979f, 1048.0025635f}};
			case 51:
				return {{1039.2860107f, 1045.1893311f}};
			case 52:
				return {{1039.3914795f, 1045.0104980f}};
			case 53:
				return {{1040.7452393f, 1042.3983154f}};
			case 54:
				return {{1040.8529053f, 1042.2200928f}};
			case 55:
				return {{1042.3055420f, 1039.4616699f}};
			case 56:
				return {{1042.3879395f, 1039.2966309f}};
			case 57:
				return {{1043.8232422f, 1036.5711670f}};
			case 58:
				return {{1043.9121094f, 1036.3828125f}};
			case 59:
				return {{1045.2285156f, 1033.8732910f}};
			case 60:
				return {{1045.3209229f, 1033.7055664f}};
			case 61:
				return {{1046.7054443f, 1031.0544434f}};
			case 62:
				return {{1046.7988281f, 1030.8818359f}};
			case 63:
				return {{1048.0748291f, 1028.4356689f}};
			case 64:
				return {{1048.1600342f, 1028.2851562f}};
			case 65:
				return {{1049.5111084f, 1025.7316895f}};
			case 66:
				return {{1050.8247070f, 1023.2147827f}};
			case 67:
				return {{1052.0571289f, 1020.9014282f}};
			case 68:
				return {{1052.1218262f, 1020.7436523f}};
			case 69:
				return {{1053.3997803f, 1018.3309326f}};
			case 70:
				return {{1053.4710693f, 1018.1951904f}};
			case 71:
				return {{1054.7084961f, 1015.8224487f}};
			case 72:
				return {{1054.8061523f, 1015.6865845f}};
			case 73:
				return {{1055.9266357f, 1013.5125122f}};
			case 74:
				return {{1055.9876709f, 1013.3786011f}};
			case 75:
				return {{1056.0737305f, 1013.2227783f}};
			case 76:
				return {{1057.2524414f, 1010.9735718f}};
			case 77:
				return {{1057.3264160f, 1010.8246460f}};
			case 78:
				return {{1058.4041748f, 1008.7948608f}};
			case 79:
				return {{1058.4788818f, 1008.6475830f}};
			case 80:
				return {{1059.5981445f, 1006.5262451f}};
			case 81:
				return {{1059.6616211f, 1006.4004517f}};
			case 82:
				return {{1060.7490234f, 1004.3116455f}};
			case 83:
				return {{1060.8145752f, 1004.1966553f}};
			case 84:
				return {{1061.8057861f, 1002.3056641f}};
			case 85:
				return {{1061.8708496f, 1002.2094116f}};
			case 86:
				return {{1062.8819580f, 1000.2409668f}};
			case 87:
				return {{1062.9396973f, 1000.1309204f}};
			case 88:
				return {{1063.9460449f, 998.2497559f}};
			case 89:
				return {{1064.0067139f, 998.1354980f}};
			case 90:
				return {{1064.8927002f, 996.4315186f}};
			case 91:
				return {{1065.8138428f, 994.6844482f}};
			case 92:
				return {{1066.6445312f, 993.0789185f}};
			case 93:
				return {{1066.7039795f, 992.9749756f}};
			case 94:
				return {{1067.5721436f, 991.3457031f}};
			case 95:
				return {{1067.6160889f, 991.2434082f}};
			case 96:
				return {{1068.4516602f, 989.6766357f}};
			case 97:
				return {{1068.4979248f, 989.5982666f}};
			case 98:
				return {{1069.2373047f, 988.1734619f}};
			case 99:
				return {{1069.2901611f, 988.0880737f}};
			case 100:
				return {{1070.0332031f, 986.6291504f}};
			case 101:
				return {{1070.0866699f, 986.5548096f}};
			case 102:
				return {{1070.8128662f, 985.1696777f}};
			case 103:
				return {{1071.4467773f, 983.9371338f}};
			case 104:
				return {{1071.4902344f, 983.8603516f}};
			case 105:
				return {{1072.1535645f, 982.5945435f}};
			case 106:
				return {{1072.2016602f, 982.5355225f}};
			case 107:
				return {{1072.2479248f, 982.4453125f}};
			case 108:
				return {{1072.8254395f, 981.3296509f}};
			case 109:
				return {{1072.8715820f, 981.2501221f}};
			case 110:
				return {{1073.4598389f, 980.1154175f}};
			case 111:
				return {{1073.4989014f, 980.0634155f}};
			case 112:
				return {{1074.0555420f, 978.9874268f}};
			case 113:
				return {{1074.0998535f, 978.8989258f}};
			case 114:
				return {{1075.0986328f, 976.9955444f}};
			case 115:
				return {{1075.5823975f, 976.0885010f}};
			case 116:
				return {{1075.6126709f, 976.0326538f}};
			case 117:
				return {{1076.0307617f, 975.2346802f}};
			case 118:
				return {{1076.0533447f, 975.1831665f}};
			case 119:
				return {{1076.4710693f, 974.3560791f}};
			case 120:
				return {{1076.5031738f, 974.3289185f}};
			case 121:
				return {{1076.8732910f, 973.6223145f}};
			case 122:
				return {{1076.9093018f, 973.5613403f}};
			case 123:
				return {{1076.9167480f, 973.5325928f}};
			case 124:
				return {{1077.2816162f, 972.8361816f}};
			case 125:
				return {{1077.6345215f, 972.1851196f}};
			case 126:
				return {{1077.6545410f, 972.1430054f}};
			case 127:
				return {{1077.9392090f, 971.5857544f}};
			case 128:
				return {{1077.9686279f, 971.5253296f}};
			case 129:
				return {{1077.9746094f, 971.4991455f}};
			case 130:
				return {{1078.2683105f, 970.9679565f}};
			case 131:
				return {{1078.5372314f, 970.4384766f}};
			case 132:
				return {{1078.5499268f, 970.4143677f}};
			case 133:
				return {{1078.7882080f, 969.9734497f}};
			case 134:
				return {{1078.7946777f, 969.9487305f}};
			case 135:
				return {{1079.0410156f, 969.5220947f}};
			case 136:
				return {{1079.0477295f, 969.4967041f}};
			case 137:
				return {{1079.2337646f, 969.1119385f}};
			case 138:
				return {{1079.4213867f, 968.7726440f}};
			case 139:
				return {{1079.5953369f, 968.4607544f}};
			case 140:
				return {{1079.6035156f, 968.4191895f}};
			case 141:
				return {{1079.7398682f, 968.1597290f}};
			case 142:
				return {{1079.7531738f, 968.1415405f}};
			case 143:
				return {{1079.8829346f, 967.8646240f}};
			case 144:
				return {{1079.8964844f, 967.8450928f}};
			case 145:
				return {{1080.0272217f, 967.6248779f}};
			case 146:
				return {{1080.0328369f, 967.6060791f}};
			case 147:
				return {{1080.1307373f, 967.4194336f}};
			case 148:
				return {{1080.1334229f, 967.4097290f}};
			case 149:
				return {{1080.2399902f, 967.2354736f}};
			case 150:
				return {{1080.2479248f, 967.2293091f}};
			case 151:
				return {{1080.3200684f, 967.0764771f}};
			case 152:
				return {{1080.3074951f, 967.0673828f}};
			case 153:
				return {{1080.3753662f, 966.9382324f}};
			case 154:
				return {{1080.3955078f, 966.9239502f}};
			case 155:
				return {{1080.4527588f, 966.8150635f}};
			case 156:
				return {{1080.4641113f, 966.8042603f}};
			case 157:
				return {{1080.5104980f, 966.7161865f}};
			case 158:
				return {{1080.5144043f, 966.7202148f}};
			case 159:
				return {{1080.5543213f, 966.6148682f}};
			case 160:
				return {{1080.5592041f, 966.6168823f}};
			case 161:
				return {{1080.6203613f, 966.5003662f}};
			case 162:
				return {{1080.6357422f, 966.4534912f}};
			case 163:
				return {{1080.6386719f, 966.4614258f}};
			case 164:
				return {{1080.6534424f, 966.4331665f}};
			case 165:
				return {{1080.6748047f, 966.4206543f}};
			case 166:
				return {{1080.6901855f, 966.3913574f}};
			case 167:
				return {{1080.6805420f, 966.3789062f}};
			case 168:
				return {{1080.6926270f, 966.3561401f}};
			case 169:
				return {{1080.6846924f, 966.3709717f}};
			case 170:
				return {{1080.6933594f, 966.3546143f}};
			case 171:
				return {{1080.7038574f, 966.3333130f}};
			case 172:
				return {{1080.7091064f, 966.3233032f}};
			case 173:
				return {{1080.7060547f, 966.3290405f}};
			case 174:
				return {{1080.7111816f, 966.3194580f}};
			case 175:
				return {{1080.7084961f, 966.3103638f}};
			case 176:
				return {{1080.7117920f, 966.3039551f}};
			case 177:
				return {{1080.7087402f, 966.3098145f}};
			case 178:
				return {{1080.7127686f, 966.3018799f}};
			case 179:
				return {{1080.7261963f, 966.3049927f}};
			case 180:
				return {{1080.7110596f, 966.3056030f}};
			case 181:
				return {{1080.7111816f, 966.3052979f}};
			case 182:
				return {{1080.7119141f, 966.3037109f}};
			case 183:
				return {{1080.7122803f, 966.3031006f}};
			case 184:
				return {{1080.7105713f, 966.3063965f}};
			case 185:
				return {{1080.7105713f, 966.3064575f}};
			case 186:
				return {{1080.7102051f, 966.3070068f}};
			case 187:
				return {{1080.7119141f, 966.3038330f}};
			case 188:
				return {{1080.7114258f, 966.3048706f}};
			case 189:
				return {{1080.7113037f, 966.3049316f}};
			case 190:
				return {{1080.7106934f, 966.3060303f}};
			case 191:
				return {{1080.7106934f, 966.3060913f}};
			case 192:
				return {{1080.7116699f, 966.3041992f}};
			case 193:
				return {{1080.7116699f, 966.3043823f}};
			case 194:
				return {{1080.7109375f, 966.3056641f}};
			case 195:
				return {{1080.7258301f, 966.3056641f}};
			case 196:
				return {{1080.7252197f, 966.3070068f}};
			case 197:
				return {{1080.7233887f, 966.3103638f}};
			case 198:
				return {{1080.7243652f, 966.3084717f}};
			case 199:
				return {{1080.7111816f, 966.3051758f}};
			case 200:
				return {{1080.7088623f, 966.3095093f}};
			case 201:
				return {{1080.7105713f, 966.3063965f}};
			case 202:
				return {{1080.7099609f, 966.3074341f}};
			case 203:
				return {{1080.6979980f, 966.3015747f}};
			case 204:
				return {{1081.5277100f, 964.8193970f}};
			case 205:
				return {{1081.6051025f, 964.6418457f}};
			case 206:
				return {{1087.1656494f, 954.4348755f}};
			case 207:
				return {{1091.4719238f, 946.4947510f}};
			case 208:
				return {{1091.7963867f, 945.8954468f}};
			case 209:
				return {{1092.1262207f, 945.3085327f}};
			case 210:
				return {{1097.8986816f, 934.7148438f}};
			case 211:
				return {{1098.2939453f, 933.9993896f}};
			case 212:
				return {{1105.0583496f, 921.6129150f}};
			case 213:
				return {{1105.5083008f, 920.7888794f}};
			case 214:
				return {{1112.6345215f, 907.7796631f}};
			case 215:
				return {{1113.1300049f, 906.8572388f}};
			case 216:
				return {{1121.4158936f, 891.7612305f}};
			case 217:
				return {{1121.9382324f, 890.8040771f}};
			case 218:
				return {{1130.8095703f, 874.7034302f}};
			case 219:
				return {{1131.3870850f, 873.6554565f}};
			case 220:
				return {{1140.1157227f, 857.8944092f}};
			case 221:
				return {{1140.6993408f, 856.8099976f}};
			case 222:
				return {{1150.2885742f, 839.5240479f}};
			case 223:
				return {{1150.9003906f, 838.4500122f}};
			case 224:
				return {{1160.0791016f, 822.0216064f}};
			case 225:
				return {{1160.6795654f, 820.9024658f}};
			case 226:
				return {{1170.5307617f, 803.3897705f}};
			case 227:
				return {{1171.1616211f, 802.3004761f}};
			case 228:
				return {{1180.9392090f, 784.9402466f}};
			case 229:
				return {{1181.5690918f, 783.8692627f}};
			case 230:
				return {{1200.0334473f, 751.5950928f}};
			case 231:
				return {{1209.1706543f, 735.8665771f}};
			case 232:
				return {{1209.7539062f, 734.8870850f}};
			case 233:
				return {{1210.3005371f, 733.9486084f}};
			case 234:
				return {{1218.4793701f, 720.0594482f}};
			case 235:
				return {{1226.7703857f, 706.1547241f}};
			case 236:
				return {{1227.2924805f, 705.2996216f}};
			case 237:
				return {{1234.5848389f, 693.2745972f}};
			case 238:
				return {{1235.0593262f, 692.4877930f}};
			case 239:
				return {{1242.2929688f, 680.8238525f}};
			case 240:
				return {{1242.7250977f, 680.1452026f}};
			case 241:
				return {{1249.3623047f, 669.7274170f}};
			case 242:
				return {{1249.7470703f, 669.1281738f}};
			case 243:
				return {{1255.3759766f, 660.5900879f}};
			case 244:
				return {{1255.7302246f, 660.0451660f}};
			case 245:
				return {{1261.0903320f, 652.2629395f}};
			case 246:
				return {{1261.3991699f, 651.8115234f}};
			case 247:
				return {{1266.0798340f, 645.4168091f}};
			case 248:
				return {{1266.3437500f, 645.0626221f}};
			case 249:
				return {{1270.0981445f, 640.3597412f}};
			case 250:
				return {{1270.3321533f, 640.0686646f}};
			case 251:
				return {{1273.6606445f, 636.3873901f}};
			case 252:
				return {{1273.8586426f, 636.2221680f}};
			case 253:
				return {{1274.0434570f, 636.0163574f}};
			case 254:
				return {{1278.4987793f, 632.9044189f}};
			case 255:
				return {{1279.8721924f, 633.1301270f}};
			case 256:
				return {{1279.9371338f, 633.1939087f}};
			case 257:
				return {{1280.6357422f, 634.5759277f}};
			case 258:
				return {{1280.6699219f, 634.7127686f}};
			case 259:
				return {{1280.7009277f, 634.8477783f}};
			case 260:
				return {{1280.8051758f, 637.5785522f}};
			case 261:
				return {{1280.7896729f, 637.8154297f}};
			case 262:
				return {{1280.3087158f, 641.7282715f}};
			case 263:
				return {{1280.2536621f, 641.9981689f}};
			case 264:
				return {{1279.3172607f, 646.6705933f}};
			case 265:
				return {{1277.7871094f, 652.6027832f}};
			case 266:
				return {{1277.6697998f, 653.0004883f}};
			case 267:
				return {{1275.7795410f, 659.4332275f}};
			case 268:
				return {{1275.6517334f, 659.8898315f}};
			case 269:
				return {{1273.1914062f, 667.6317139f}};
			case 270:
				return {{1273.0129395f, 668.1591797f}};
			case 271:
				return {{1270.1384277f, 676.6842651f}};
			case 272:
				return {{1269.9436035f, 677.2403564f}};
			case 273:
				return {{1266.8756104f, 685.9105225f}};
			case 274:
				return {{1266.6820068f, 686.5298462f}};
			case 275:
				return {{1266.4516602f, 687.1147461f}};
			case 276:
				return {{1262.8322754f, 697.0260620f}};
			case 277:
				return {{1262.5976562f, 697.6788940f}};
			case 278:
				return {{1262.3703613f, 698.3110352f}};
			case 279:
				return {{1258.4208984f, 708.8040771f}};
			case 280:
				return {{1254.5032959f, 719.0698242f}};
			case 281:
				return {{1250.1002197f, 730.3739014f}};
			case 282:
				return {{1249.8183594f, 731.0824585f}};
			case 283:
				return {{1249.5413818f, 731.8027344f}};
			case 284:
				return {{1245.2281494f, 742.6947632f}};
			case 285:
				return {{1244.9519043f, 743.4417114f}};
			case 286:
				return {{1244.6575928f, 744.1754150f}};
			case 287:
				return {{1239.9029541f, 756.0454102f}};
			case 288:
				return {{1239.6002197f, 756.8118286f}};
			case 289:
				return {{1239.3024902f, 757.5557861f}};
			case 290:
				return {{1234.4418945f, 769.5958862f}};
			case 291:
				return {{1234.1215820f, 770.3453369f}};
			case 292:
				return {{1233.8283691f, 771.1022339f}};
			case 293:
				return {{1228.7778320f, 783.0522461f}};
			case 294:
				return {{1228.4144287f, 783.8894043f}};
			case 295:
				return {{1222.2709961f, 797.6134644f}};
			case 296:
				return {{1221.8743896f, 798.4854736f}};
			case 297:
				return {{1221.4707031f, 799.3663330f}};
			case 298:
				return {{1214.8088379f, 813.6260376f}};
			case 299:
				return {{1214.3808594f, 814.5417480f}};
			case 300:
				return {{1213.9525146f, 815.4300537f}};
			case 301:
				return {{1207.4831543f, 828.8757935f}};
			case 302:
				return {{1207.0598145f, 829.7683716f}};
			case 303:
				return {{1200.1271973f, 843.8515625f}};
			case 304:
				return {{1199.6949463f, 844.7242432f}};
			case 305:
				return {{1199.2661133f, 845.5892334f}};
			case 306:
				return {{1192.9100342f, 858.2983398f}};
			case 307:
				return {{1192.4926758f, 859.1388550f}};
			case 308:
				return {{1185.9709473f, 872.0261230f}};
			case 309:
				return {{1179.7593994f, 884.1946411f}};
			case 310:
				return {{1179.3901367f, 884.9271240f}};
			case 311:
				return {{1173.9206543f, 895.5594482f}};
			case 312:
				return {{1173.5672607f, 896.2380371f}};
			case 313:
				return {{1173.2154541f, 896.9230957f}};
			case 314:
				return {{1167.8203125f, 907.3792114f}};
			case 315:
				return {{1167.4978027f, 908.0062256f}};
			case 316:
				return {{1167.1726074f, 908.6304321f}};
			case 317:
				return {{1162.2349854f, 918.1853027f}};
			case 318:
				return {{1161.9337158f, 918.7591553f}};
			case 319:
				return {{1157.6871338f, 926.9748535f}};
			case 320:
				return {{1157.4167480f, 927.4989014f}};
			case 321:
				return {{1157.1516113f, 928.0240479f}};
			case 322:
				return {{1153.0333252f, 935.9801025f}};
			case 323:
				return {{1152.7951660f, 936.4553223f}};
			case 324:
				return {{1152.5509033f, 936.9286499f}};
			case 325:
				return {{1149.0662842f, 943.6975098f}};
			case 326:
				return {{1148.8502197f, 944.1300049f}};
			case 327:
				return {{1148.6313477f, 944.5544434f}};
			case 328:
				return {{1145.2945557f, 951.0845337f}};
			case 329:
				return {{1145.0937500f, 951.4760742f}};
			case 330:
				return {{1144.9034424f, 951.8591919f}};
			case 331:
				return {{1141.9252930f, 957.7369385f}};
			case 332:
				return {{1141.7421875f, 958.0842285f}};
			case 333:
				return {{1141.5698242f, 958.4357910f}};
			case 334:
				return {{1139.0764160f, 963.3994141f}};
			case 335:
				return {{1138.9230957f, 963.7178955f}};
			case 336:
				return {{1138.7653809f, 964.0344238f}};
			case 337:
				return {{1136.3980713f, 968.8013916f}};
			case 338:
				return {{1136.2535400f, 969.0863037f}};
			case 339:
				return {{1136.1190186f, 969.3661499f}};
			case 340:
				return {{1134.0231934f, 973.6445312f}};
			case 341:
				return {{1133.9028320f, 973.9017334f}};
			case 342:
				return {{1132.1590576f, 977.5253296f}};
			case 343:
				return {{1130.4914551f, 981.0338745f}};
			case 344:
				return {{1129.1040039f, 984.0190430f}};
			case 345:
				return {{1129.0181885f, 984.2077026f}};
			case 346:
				return {{1128.9307861f, 984.3925781f}};
			case 347:
				return {{1127.6354980f, 987.2466431f}};
			case 348:
				return {{1127.5584717f, 987.4124756f}};
			case 349:
				return {{1126.4271240f, 989.9624023f}};
			case 350:
				return {{1126.3615723f, 990.1131592f}};
			case 351:
				return {{1126.2952881f, 990.2622070f}};
			case 352:
				return {{1125.3764648f, 992.3890381f}};
			case 353:
				return {{1125.3198242f, 992.5240479f}};
			case 354:
				return {{1124.4709473f, 994.5535278f}};
			case 355:
				return {{1124.4240723f, 994.6698608f}};
			case 356:
				return {{1124.3775635f, 994.7876587f}};
			case 357:
				return {{1123.6580811f, 996.5743408f}};
			case 358:
				return {{1123.6162109f, 996.6818237f}};
			case 359:
				return {{1123.0399170f, 998.1647949f}};
			case 360:
				return {{1123.0061035f, 998.2569580f}};
			case 361:
				return {{1122.9705811f, 998.3489380f}};
			case 362:
				return {{1122.4589844f, 999.7332764f}};
			case 363:
				return {{1122.4289551f, 999.8129883f}};
			case 364:
				return {{1122.3992920f, 999.8941650f}};
			case 365:
				return {{1122.3720703f, 999.9769287f}};
			case 366:
				return {{1121.9837646f, 1001.0933838f}};
			case 367:
				return {{1121.9587402f, 1001.1636963f}};
			case 368:
				return {{1121.6212158f, 1002.1972656f}};
			case 369:
				return {{1121.6004639f, 1002.2556152f}};
			case 370:
				return {{1121.3355713f, 1003.1367188f}};
			case 371:
				return {{1121.3225098f, 1003.1879272f}};
			case 372:
				return {{1121.3099365f, 1003.2387695f}};
			case 373:
				return {{1121.1204834f, 1003.9301147f}};
			case 374:
				return {{1120.9746094f, 1004.5490112f}};
			case 375:
				return {{1120.8771973f, 1005.0517578f}};
			case 376:
				return {{1120.8718262f, 1005.0771484f}};
			case 377:
				return {{1120.8687744f, 1005.1056519f}};
			case 378:
				return {{1120.8222656f, 1005.4653931f}};
			case 379:
				return {{1120.8227539f, 1005.4876099f}};
			case 380:
				return {{1120.8216553f, 1005.5097656f}};
			case 381:
				return {{1120.8151855f, 1005.7808838f}};
			case 382:
				return {{1120.8154297f, 1005.7952881f}};
			case 383:
				return {{1120.8142090f, 1005.8078003f}};
			case 384:
				return {{1120.8436279f, 1005.9703369f}};
			case 385:
				return {{1120.8489990f, 1005.9776611f}};
			case 386:
				return {{1120.8508301f, 1005.9845581f}};
			case 387:
				return {{1120.9178467f, 1006.0603027f}};
			case 388:
				return {{1120.9223633f, 1006.0625000f}};
			case 389:
				return {{1121.0174561f, 1006.0498657f}};
			case 390:
				return {{1121.0209961f, 1006.0454712f}};
			case 391:
				return {{1121.0284424f, 1006.0425415f}};
			case 392:
				return {{1121.1433105f, 1005.9483643f}};
			case 393:
				return {{1121.1508789f, 1005.9414673f}};
			case 394:
				return {{1121.1586914f, 1005.9291992f}};
			case 395:
				return {{1121.3026123f, 1005.7516479f}};
			case 396:
				return {{1121.3121338f, 1005.7404175f}};
			case 397:
				return {{1121.3221436f, 1005.7236328f}};
			case 398:
				return {{1121.4855957f, 1005.4653320f}};
			case 399:
				return {{1121.4970703f, 1005.4485474f}};
			case 400:
				return {{1121.6669922f, 1005.1422119f}};
			case 401:
				return {{1121.6762695f, 1005.1199341f}};
			case 402:
				return {{1121.6879883f, 1005.0975952f}};
			case 403:
				return {{1121.8856201f, 1004.7039795f}};
			case 404:
				return {{1121.8967285f, 1004.6762695f}};
			case 405:
				return {{1121.9099121f, 1004.6538696f}};
			case 406:
				return {{1122.1081543f, 1004.2233887f}};
			case 407:
				return {{1122.3226318f, 1003.7130737f}};
			case 408:
				return {{1122.5477295f, 1003.1496582f}};
			case 409:
				return {{1122.5653076f, 1003.1127319f}};
			case 410:
				return {{1122.5778809f, 1003.0740356f}};
			case 411:
				return {{1122.7983398f, 1002.4976807f}};
			case 412:
				return {{1122.8135986f, 1002.4560547f}};
			case 413:
				return {{1122.8283691f, 1002.4180908f}};
			case 414:
				return {{1123.0706787f, 1001.7495728f}};
			case 415:
				return {{1123.0861816f, 1001.7047729f}};
			case 416:
				return {{1123.1016846f, 1001.6636963f}};
			case 417:
				return {{1123.3488770f, 1000.9465942f}};
			case 418:
				return {{1123.3632812f, 1000.9008789f}};
			case 419:
				return {{1123.3778076f, 1000.8547974f}};
			case 420:
				return {{1123.6143799f, 1000.1441650f}};
			case 421:
				return {{1123.6296387f, 1000.0938721f}};
			case 422:
				return {{1123.8863525f, 999.2951050f}};
			case 423:
				return {{1123.9000244f, 999.2437134f}};
			case 424:
				return {{1123.9152832f, 999.1940918f}};
			case 425:
				return {{1124.1562500f, 998.4107666f}};
			case 426:
				return {{1124.1733398f, 998.3584595f}};
			case 427:
				return {{1124.1888428f, 998.3026733f}};
			case 428:
				return {{1124.4490967f, 997.4353638f}};
			case 429:
				return {{1124.4631348f, 997.3787842f}};
			case 430:
				return {{1124.4803467f, 997.3240967f}};
			case 431:
				return {{1124.7421875f, 996.4246826f}};
			case 432:
				return {{1124.7579346f, 996.3656006f}};
			case 433:
				return {{1124.7755127f, 996.3098755f}};
			case 434:
				return {{1125.0169678f, 995.4399414f}};
			case 435:
				return {{1125.0361328f, 995.3817139f}};
			case 436:
				return {{1125.0516357f, 995.3235474f}};
			case 437:
				return {{1125.3123779f, 994.3718872f}};
			case 438:
				return {{1125.3293457f, 994.3148804f}};
			case 439:
				return {{1125.5885010f, 993.3437500f}};
			case 440:
				return {{1125.8314209f, 992.4240723f}};
			case 441:
				return {{1126.0895996f, 991.4284668f}};
			case 442:
				return {{1126.1093750f, 991.3660889f}};
			case 443:
				return {{1126.1253662f, 991.3056641f}};
			case 444:
				return {{1126.1412354f, 991.2435303f}};
			case 445:
				return {{1126.3806152f, 990.3011475f}};
			case 446:
				return {{1126.3961182f, 990.2370605f}};
			case 447:
				return {{1126.6513672f, 989.2312622f}};
			case 448:
				return {{1126.6699219f, 989.1700439f}};
			case 449:
				return {{1126.6850586f, 989.1071167f}};
			case 450:
				return {{1126.9378662f, 988.0982056f}};
			case 451:
				return {{1126.9558105f, 988.0370483f}};
			case 452:
				return {{1127.1894531f, 987.0971069f}};
			case 453:
				return {{1127.2009277f, 987.0341797f}};
			case 454:
				return {{1127.2181396f, 986.9710693f}};
			case 455:
				return {{1127.4643555f, 985.9766235f}};
			case 456:
				return {{1127.4830322f, 985.9133911f}};
			case 457:
				return {{1127.7222900f, 984.9293213f}};
			case 458:
				return {{1127.7393799f, 984.8685303f}};
			case 459:
				return {{1127.7546387f, 984.8060303f}};
			case 460:
				return {{1127.9761963f, 983.9008179f}};
			case 461:
				return {{1127.9924316f, 983.8420410f}};
			case 462:
				return {{1128.0065918f, 983.7836304f}};
			case 463:
				return {{1128.0225830f, 983.7233887f}};
			case 464:
				return {{1128.2553711f, 982.7776489f}};
			case 465:
				return {{1128.2701416f, 982.7196655f}};
			case 466:
				return {{1128.2850342f, 982.6598511f}};
			case 467:
				return {{1128.4962158f, 981.7952881f}};
			case 468:
				return {{1128.5114746f, 981.7419434f}};
			case 469:
				return {{1128.7318115f, 980.8447876f}};
			case 470:
				return {{1128.9503174f, 979.9770508f}};
			case 471:
				return {{1129.1453857f, 979.1925659f}};
			case 472:
				return {{1129.1594238f, 979.1457520f}};
			case 473:
				return {{1129.1677246f, 979.0930786f}};
			case 474:
				return {{1129.1813965f, 979.0408325f}};
			case 475:
				return {{1129.3848877f, 978.2431641f}};
			case 476:
				return {{1129.3955078f, 978.1938477f}};
			case 477:
				return {{1129.5887451f, 977.4342041f}};
			case 478:
				return {{1129.6015625f, 977.3883667f}};
			case 479:
				return {{1129.6130371f, 977.3424072f}};
			case 480:
				return {{1129.7844238f, 976.6685791f}};
			case 481:
				return {{1129.7962646f, 976.6222534f}};
			case 482:
				return {{1129.8079834f, 976.5795288f}};
			case 483:
				return {{1129.9826660f, 975.9023438f}};
			case 484:
				return {{1129.9925537f, 975.8636475f}};
			case 485:
				return {{1130.0046387f, 975.8229980f}};
			case 486:
				return {{1130.1583252f, 975.2272949f}};
			case 487:
				return {{1130.1669922f, 975.1899414f}};
			case 488:
				return {{1130.3220215f, 974.5974731f}};
			case 489:
				return {{1130.3333740f, 974.5594482f}};
			case 490:
				return {{1130.3405762f, 974.5278931f}};
			case 491:
				return {{1130.3500977f, 974.4924316f}};
			case 492:
				return {{1130.4940186f, 973.9490967f}};
			case 493:
				return {{1130.5019531f, 973.9130859f}};
			case 494:
				return {{1130.6293945f, 973.4448853f}};
			case 495:
				return {{1130.6361084f, 973.4146118f}};
			case 496:
				return {{1130.6444092f, 973.3863525f}};
			case 497:
				return {{1130.6529541f, 973.3542480f}};
			case 498:
				return {{1130.7767334f, 972.9001465f}};
			case 499:
				return {{1130.7839355f, 972.8715820f}};
			case 500:
				return {{1130.8991699f, 972.4596558f}};
			case 501:
				return {{1130.9053955f, 972.4326172f}};
			case 502:
				return {{1130.9107666f, 972.4079590f}};
			case 503:
				return {{1131.0065918f, 972.0584717f}};
			case 504:
				return {{1131.1844482f, 971.4278564f}};
			case 505:
				return {{1131.1914062f, 971.4132080f}};
			case 506:
				return {{1131.1933594f, 971.3929443f}};
			case 507:
				return {{1131.1981201f, 971.3745117f}};
			case 508:
				return {{1131.2745361f, 971.1064453f}};
			case 509:
				return {{1131.2797852f, 971.0916138f}};
			case 510:
				return {{1131.3499756f, 970.8544922f}};
			case 511:
				return {{1131.3524170f, 970.8429565f}};
			case 512:
				return {{1131.4101562f, 970.6469116f}};
			case 513:
				return {{1131.4116211f, 970.6368408f}};
			case 514:
				return {{1131.4150391f, 970.6245117f}};
			case 515:
				return {{1131.4189453f, 970.6125488f}};
			case 516:
				return {{1131.4707031f, 970.4400024f}};
			case 517:
				return {{1131.4736328f, 970.4310303f}};
			case 518:
				return {{1131.5147705f, 970.2826538f}};
			case 519:
				return {{1131.5209961f, 970.2746582f}};
			case 520:
				return {{1131.5207520f, 970.2669678f}};
			case 521:
				return {{1131.5552979f, 970.1549072f}};
			case 522:
				return {{1131.5585938f, 970.1461182f}};
			case 523:
				return {{1131.5577393f, 970.1390991f}};
			case 524:
				return {{1131.5915527f, 970.0382080f}};
			case 525:
				return {{1131.5899658f, 970.0324097f}};
			case 526:
				return {{1131.5927734f, 970.0286255f}};
			case 527:
				return {{1131.6173096f, 969.9500122f}};
			case 528:
				return {{1131.6196289f, 969.9427490f}};
			case 529:
				return {{1131.6177979f, 969.9415283f}};
			case 530:
				return {{1131.6391602f, 969.8749390f}};
			case 531:
				return {{1131.6408691f, 969.8684082f}};
			case 532:
				return {{1131.6428223f, 969.8674927f}};
			case 533:
				return {{1131.6575928f, 969.8145142f}};
			case 534:
				return {{1131.6591797f, 969.8123169f}};
			case 535:
				return {{1131.6624756f, 969.8083496f}};
			case 536:
				return {{1131.6823730f, 969.7353516f}};
			case 537:
				return {{1131.6835938f, 969.7340088f}};
			case 538:
				return {{1131.6915283f, 969.7059326f}};
			case 539:
				return {{1131.6942139f, 969.7070312f}};
			case 540:
				return {{1131.6906738f, 969.7060547f}};
			case 541:
				return {{1131.6993408f, 969.6849365f}};
			case 542:
				return {{1131.6999512f, 969.6843262f}};
			case 543:
				return {{1131.6981201f, 969.6837158f}};
			case 544:
				return {{1131.7026367f, 969.6716919f}};
			case 545:
				return {{1131.7031250f, 969.6710815f}};
			case 546:
				return {{1131.7036133f, 969.6705322f}};
			case 547:
				return {{1131.7055664f, 969.6597900f}};
			case 548:
				return {{1131.7059326f, 969.6593628f}};
			case 549:
				return {{1131.7060547f, 969.6591187f}};
			case 550:
				return {{1131.7075195f, 969.6500244f}};
			case 551:
				return {{1131.7076416f, 969.6497803f}};
			case 552:
				return {{1131.7115479f, 969.6464844f}};
			case 553:
				return {{1131.7116699f, 969.6463013f}};
			case 554:
				return {{1131.7109375f, 969.6447144f}};
			case 555:
				return {{1131.7109375f, 969.6447144f}};
			case 556:
				return {{1131.7111816f, 969.6442261f}};
			case 557:
				return {{1131.7119141f, 969.6409912f}};
			case 558:
				return {{1131.7116699f, 969.6411133f}};
			case 559:
				return {{1131.7116699f, 969.6411133f}};
			case 560:
				return {{1131.7137451f, 969.6408081f}};
			case 561:
				return {{1131.7137451f, 969.6408081f}};
			case 562:
				return {{1131.7137451f, 969.6408081f}};
			case 563:
				return {{1131.7115479f, 969.6392212f}};
			case 564:
				return {{1131.7115479f, 969.6390381f}};
			case 565:
				return {{1131.7115479f, 969.6392822f}};
			case 566:
				return {{1131.7109375f, 969.6418457f}};
			case 567:
				return {{1131.7109375f, 969.6419678f}};
			case 568:
				return {{1131.7122803f, 969.6447144f}};
			case 569:
				return {{1131.7113037f, 969.6459961f}};
			case 570:
				return {{1131.7109375f, 969.6467285f}};
			case 571:
				return {{1131.7106934f, 969.6469727f}};
			case 572:
				return {{1131.7106934f, 969.6470947f}};
			case 573:
				return {{1131.7080078f, 969.6501465f}};
			case 574:
				return {{1131.7080078f, 969.6501465f}};
			case 575:
				return {{1131.7080078f, 969.6501465f}};
			case 576:
				return {{1131.7116699f, 969.6511230f}};
			case 577:
				return {{1131.7116699f, 969.6511230f}};
			case 578:
				return {{1131.7115479f, 969.6513672f}};
			case 579:
				return {{1131.7106934f, 969.6501465f}};
			case 580:
				return {{1131.7108154f, 969.6499634f}};
			case 581:
				return {{1131.7106934f, 969.6502075f}};
			case 582:
				return {{1131.7102051f, 969.6508789f}};
			case 583:
				return {{1131.7102051f, 969.6508789f}};
			case 584:
				return {{1131.7092285f, 969.6540527f}};
			case 585:
				return {{1131.7092285f, 969.6540527f}};
			case 586:
				return {{1131.7092285f, 969.6563110f}};
			case 587:
				return {{1131.7089844f, 969.6566772f}};
			case 588:
				return {{1131.7088623f, 969.6569214f}};
			case 589:
				return {{1131.7088623f, 969.6569824f}};
			case 590:
				return {{1131.7103271f, 969.6575317f}};
			case 591:
				return {{1131.7104492f, 969.6572876f}};
			case 592:
				return {{1131.7104492f, 969.6572876f}};
			case 593:
				return {{1131.7078857f, 969.6582031f}};
			case 594:
				return {{1131.7078857f, 969.6582031f}};
			case 595:
				return {{1131.7078857f, 969.6582031f}};
			case 596:
				return {{1131.7076416f, 969.6585693f}};
			case 597:
				return {{1131.7076416f, 969.6585693f}};
			case 598:
				return {{1131.7076416f, 969.6586914f}};
			case 599:
				return {{1131.7072754f, 969.6593018f}};
			case 600:
				return {{1131.7072754f, 969.6593018f}};
			case 601:
				return {{1131.7066650f, 969.6597900f}};
			case 602:
				return {{1131.7066650f, 969.6597900f}};
			case 603:
				return {{1131.7086182f, 969.6597900f}};
			case 604:
				return {{1131.7086182f, 969.6597900f}};
			case 605:
				return {{1131.7084961f, 969.6600342f}};
			case 606:
				return {{1131.7084961f, 969.6600342f}};
			case 607:
				return {{1131.7084961f, 969.6600342f}};
			case 608:
				return {{1131.7084961f, 969.6600342f}};
			case 609:
				return {{1131.7082520f, 969.6602783f}};
			case 610:
				return {{1131.7082520f, 969.6602783f}};
			case 611:
				return {{1131.7082520f, 969.6602783f}};
			case 612:
				return {{1131.7082520f, 969.6602783f}};
			case 613:
				return {{1131.7082520f, 969.6602783f}};
			case 614:
				return {{1131.7081299f, 969.6605225f}};
			case 615:
				return {{1131.7081299f, 969.6605225f}};
			case 616:
				return {{1131.7081299f, 969.6605225f}};
			case 617:
				return {{1131.7080078f, 969.6607056f}};
			case 618:
				return {{1131.7080078f, 969.6607056f}};
			case 619:
				return {{1131.7080078f, 969.6607056f}};
			case 620:
				return {{1131.7080078f, 969.6607056f}};
			case 621:
				return {{1131.7080078f, 969.6607056f}};
			case 622:
				return {{1131.7080078f, 969.6607056f}};
			case 623:
				return {{1131.7080078f, 969.6607056f}};
			case 624:
				return {{1131.7080078f, 969.6607056f}};
			case 625:
				return {{1131.7080078f, 969.6607056f}};
			case 626:
				return {{1131.7080078f, 969.6607056f}};
			case 627:
				return {{1131.7080078f, 969.6607056f}};
			case 628:
				return {{1131.7080078f, 969.6607056f}};
			case 629:
				return {{1131.7080078f, 969.6607056f}};
			case 630:
				return {{1131.7080078f, 969.6607056f}};
			case 631:
				return {{1131.7080078f, 969.6607056f}};
			case 632:
				return {{1131.7080078f, 969.6607056f}};
			case 633:
				return {{1131.7080078f, 969.6607056f}};
			case 634:
				return {{1131.7080078f, 969.6607056f}};
			case 635:
				return {{1131.7080078f, 969.6607056f}};
			case 636:
				return {{1131.7080078f, 969.6607056f}};
			case 637:
				return {{1131.7080078f, 969.6607056f}};
			case 638:
				return {{1131.7080078f, 969.6607056f}};
			case 639:
				return {{1131.7080078f, 969.6607056f}};
			case 640:
				return {{1131.7080078f, 969.6607056f}};
			case 641:
				return {{1131.7080078f, 969.6607056f}};
			case 642:
				return {{1131.7080078f, 969.6607056f}};
			case 643:
				return {{1131.7080078f, 969.6607056f}};
			case 644:
				return {{1131.7080078f, 969.6607056f}};
			case 645:
				return {{1131.7080078f, 969.6607056f}};
			case 646:
				return {{1131.7080078f, 969.6607056f}};
			case 647:
				return {{1131.7080078f, 969.6607056f}};
			case 648:
				return {{1131.7080078f, 969.6607056f}};
			case 649:
				return {{1131.7080078f, 969.6607056f}};
			case 650:
				return {{1131.7080078f, 969.6607056f}};
			case 651:
				return {{1131.7081299f, 969.6605225f}};
			case 652:
				return {{1131.7081299f, 969.6605225f}};
			case 653:
				return {{1131.7081299f, 969.6605225f}};
			case 654:
				return {{1131.7081299f, 969.6605225f}};
			case 655:
				return {{1131.7081299f, 969.6605225f}};
			case 656:
				return {{1131.7081299f, 969.6605225f}};
			case 657:
				return {{1131.7081299f, 969.6605225f}};
			case 658:
				return {{1131.7081299f, 969.6605225f}};
			case 659:
				return {{1131.7081299f, 969.6605225f}};
			case 660:
				return {{1131.7081299f, 969.6605225f}};
			case 661:
				return {{1131.7081299f, 969.6605225f}};
			case 662:
				return {{1131.7081299f, 969.6605225f}};
			case 663:
				return {{1131.7081299f, 969.6605225f}};
			case 664:
				return {{1131.7081299f, 969.6605225f}};
			case 665:
				return {{1131.7081299f, 969.6605225f}};
			case 666:
				return {{1131.7081299f, 969.6605225f}};
			case 667:
				return {{1131.7081299f, 969.6605225f}};
			case 668:
				return {{1131.7081299f, 969.6605225f}};
			case 669:
				return {{1131.7081299f, 969.6605225f}};
			case 670:
				return {{1131.7081299f, 969.6605225f}};
			case 671:
				return {{1131.7081299f, 969.6605225f}};
			case 672:
				return {{1131.7081299f, 969.6605225f}};
			case 673:
				return {{1131.7081299f, 969.6605225f}};
			case 674:
				return {{1131.7081299f, 969.6605225f}};
			case 675:
				return {{1131.7081299f, 969.6605225f}};
			case 676:
				return {{1131.7080078f, 969.6607056f}};
			case 677:
				return {{1131.7080078f, 969.6607056f}};
			case 678:
				return {{1131.7080078f, 969.6607056f}};
			case 679:
				return {{1131.7080078f, 969.6607056f}};
			case 680:
				return {{1131.7080078f, 969.6607056f}};
			case 681:
				return {{1131.7080078f, 969.6607056f}};
			case 682:
				return {{1131.7080078f, 969.6607056f}};
			case 683:
				return {{1131.7080078f, 969.6607056f}};
			case 684:
				return {{1131.7081299f, 969.6605225f}};
			case 685:
				return {{1131.7081299f, 969.6605225f}};
			case 686:
				return {{1131.7081299f, 969.6605225f}};
			case 687:
				return {{1131.7081299f, 969.6605225f}};
			case 688:
				return {{1131.7081299f, 969.6605225f}};
			case 689:
				return {{1131.7081299f, 969.6605225f}};
			case 690:
				return {{1131.7081299f, 969.6605225f}};
			case 691:
				return {{1131.7081299f, 969.6605225f}};
			case 692:
				return {{1131.7081299f, 969.6605225f}};
			case 693:
				return {{1131.7081299f, 969.6605225f}};
			case 694:
				return {{1131.7081299f, 969.6605225f}};
			case 695:
				return {{1131.7081299f, 969.6605225f}};
			case 696:
				return {{1131.7081299f, 969.6605225f}};
			case 697:
				return {{1131.7081299f, 969.6605225f}};
			case 698:
				return {{1131.7081299f, 969.6605225f}};
			case 699:
				return {{1131.7081299f, 969.6605225f}};
			case 700:
				return {{1131.7081299f, 969.6605225f}};
			case 701:
				return {{1131.7081299f, 969.6605225f}};
			case 702:
				return {{1131.7081299f, 969.6605225f}};
			case 703:
				return {{1131.7081299f, 969.6605225f}};
			case 704:
				return {{1131.7081299f, 969.6605225f}};
			case 705:
				return {{1131.7081299f, 969.6605225f}};
			case 706:
				return {{1131.7081299f, 969.6605225f}};
			case 707:
				return {{1131.7081299f, 969.6605225f}};
			case 708:
				return {{1131.7081299f, 969.6605225f}};
			case 709:
				return {{1131.7081299f, 969.6605225f}};
			case 710:
				return {{1131.7081299f, 969.6605225f}};
			case 711:
				return {{1131.7081299f, 969.6605225f}};
			case 712:
				return {{1131.7081299f, 969.6605225f}};
			case 713:
				return {{1131.7081299f, 969.6605225f}};
			case 714:
				return {{1131.7081299f, 969.6605225f}};
			case 715:
				return {{1131.7081299f, 969.6605225f}};
			case 716:
				return {{1131.7081299f, 969.6605225f}};
			case 717:
				return {{1131.7081299f, 969.6605225f}};
			case 718:
				return {{1131.7081299f, 969.6605225f}};
			case 719:
				return {{1131.7081299f, 969.6605225f}};
			case 720:
				return {{1131.7081299f, 969.6605225f}};
			case 721:
				return {{1131.7081299f, 969.6605225f}};
			case 722:
				return {{1131.7081299f, 969.6605225f}};
			case 723:
				return {{1131.7081299f, 969.6605225f}};
			case 724:
				return {{1131.7081299f, 969.6605225f}};
			case 725:
				return {{1131.7081299f, 969.6605225f}};
			case 726:
				return {{1131.7081299f, 969.6605225f}};
			case 727:
				return {{1131.7081299f, 969.6605225f}};
			case 728:
				return {{1131.7081299f, 969.6605225f}};
			case 729:
				return {{1131.7081299f, 969.6605225f}};
			case 730:
				return {{1131.7081299f, 969.6605225f}};
			case 731:
				return {{1131.7081299f, 969.6605225f}};
			case 732:
				return {{1131.7081299f, 969.6605225f}};
			case 733:
				return {{1131.7081299f, 969.6605225f}};
			case 734:
				return {{1131.7081299f, 969.6605225f}};
			case 735:
				return {{1131.7081299f, 969.6605225f}};
			case 736:
				return {{1131.7081299f, 969.6605225f}};
			case 737:
				return {{1131.7081299f, 969.6605225f}};
			case 738:
				return {{1131.7081299f, 969.6605225f}};
			case 739:
				return {{1131.7081299f, 969.6605225f}};
			case 740:
				return {{1131.7081299f, 969.6605225f}};
			case 741:
				return {{1131.7081299f, 969.6605225f}};
			case 742:
				return {{1131.7081299f, 969.6605225f}};
			case 743:
				return {{1131.7081299f, 969.6605225f}};
			case 744:
				return {{1131.7081299f, 969.6605225f}};
			case 745:
				return {{1131.7081299f, 969.6605225f}};
			case 746:
				return {{1131.7081299f, 969.6605225f}};
			case 747:
				return {{1131.7081299f, 969.6605225f}};
			case 748:
				return {{1131.7081299f, 969.6605225f}};
			case 749:
				return {{1131.7081299f, 969.6605225f}};
			case 750:
				return {{1131.7081299f, 969.6605225f}};
			case 751:
				return {{1131.7081299f, 969.6605225f}};
			case 752:
				return {{1131.7081299f, 969.6605225f}};
			case 753:
				return {{1131.7081299f, 969.6605225f}};
			case 754:
				return {{1131.7081299f, 969.6605225f}};
			case 755:
				return {{1131.7081299f, 969.6605225f}};
			case 756:
				return {{1131.7081299f, 969.6605225f}};
			case 757:
				return {{1131.7081299f, 969.6605225f}};
			case 758:
				return {{1131.7081299f, 969.6605225f}};
			case 759:
				return {{1131.7081299f, 969.6605225f}};
			case 760:
				return {{1131.7081299f, 969.6605225f}};
			case 761:
				return {{1131.7081299f, 969.6605225f}};
			case 762:
				return {{1131.7081299f, 969.6605225f}};
			case 763:
				return {{1131.7081299f, 969.6605225f}};
			case 764:
				return {{1131.7081299f, 969.6605225f}};
			case 765:
				return {{1131.7081299f, 969.6605225f}};
			case 766:
				return {{1131.7081299f, 969.6605225f}};
			case 767:
				return {{1131.7081299f, 969.6605225f}};
			case 768:
				return {{1131.7081299f, 969.6605225f}};
			case 769:
				return {{1131.7081299f, 969.6605225f}};
			case 770:
				return {{1131.7081299f, 969.6605225f}};
			case 771:
				return {{1131.7081299f, 969.6605225f}};
			case 772:
				return {{1131.7081299f, 969.6605225f}};
			case 773:
				return {{1131.7081299f, 969.6605225f}};
			case 774:
				return {{1131.7081299f, 969.6605225f}};
			case 775:
				return {{1131.7081299f, 969.6605225f}};
			case 776:
				return {{1131.7081299f, 969.6605225f}};
			case 777:
				return {{1131.7081299f, 969.6605225f}};
			case 778:
				return {{1131.7081299f, 969.6605225f}};
			case 779:
				return {{1131.7081299f, 969.6605225f}};
			case 780:
				return {{1131.7081299f, 969.6605225f}};
			case 781:
				return {{1131.7081299f, 969.6605225f}};
			case 782:
				return {{1131.7081299f, 969.6605225f}};
			case 783:
				return {{1131.7081299f, 969.6605225f}};
			case 784:
				return {{1131.7081299f, 969.6605225f}};
			case 785:
				return {{1131.7081299f, 969.6605225f}};
			case 786:
				return {{1131.7081299f, 969.6605225f}};
			case 787:
				return {{1131.7081299f, 969.6605225f}};
			case 788:
				return {{1131.7081299f, 969.6605225f}};
			case 789:
				return {{1131.7081299f, 969.6605225f}};
			case 790:
				return {{1131.7081299f, 969.6605225f}};
			case 791:
				return {{1131.7081299f, 969.6605225f}};
			case 792:
				return {{1131.7081299f, 969.6605225f}};
			case 793:
				return {{1131.7081299f, 969.6605225f}};
			case 794:
				return {{1131.7081299f, 969.6605225f}};
			case 795:
				return {{1131.7081299f, 969.6605225f}};
			case 796:
				return {{1131.7081299f, 969.6605225f}};
			case 797:
				return {{1131.7081299f, 969.6605225f}};
			case 798:
				return {{1131.7081299f, 969.6605225f}};
			case 799:
				return {{1131.7081299f, 969.6605225f}};
			case 800:
				return {{1131.7081299f, 969.6605225f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[0])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[1])
		{
			switch (frameNumber)
			{
			case 0:
				return std::nullopt;
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[2])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 563.2467041f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[3])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 189.2355652f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[4])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 100.4535294f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[5])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 62.1956444f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[6])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 39.9825211f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[7])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 26.0952835f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[8])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 16.1538353f}};
			case 1:
				return {{1000.0000000f, -770.0559082f}};
			case 2:
				return {{1000.0000000f, -743.0767822f}};
			case 3:
				return {{1000.0000000f, -5.7276611f}};
			case 4:
				return {{1000.0000000f, 105.8948517f}};
			case 5:
				return {{1000.0000000f, 112.1076202f}};
			case 6:
				return {{1000.0000000f, 118.2447052f}};
			case 7:
				return {{1000.0000000f, 200.3244019f}};
			case 8:
				return {{1000.0000000f, 204.8554993f}};
			case 9:
				return {{1000.0000000f, 264.9228516f}};
			case 10:
				return {{1000.0000000f, 268.0856323f}};
			case 11:
				return {{1000.0000000f, 271.2250366f}};
			case 12:
				return {{1000.0000000f, 313.6578369f}};
			case 13:
				return {{1000.0000000f, 316.1343384f}};
			case 14:
				return {{1000.0000000f, 318.7072144f}};
			case 15:
				return {{1000.0000000f, 321.1528931f}};
			case 16:
				return {{1000.0000000f, 355.7194519f}};
			case 17:
				return {{1000.0000000f, 357.7429199f}};
			case 18:
				return {{1000.0000000f, 384.0479126f}};
			case 19:
				return {{1000.0000000f, 407.4533691f}};
			case 20:
				return {{1000.0000000f, 427.1724854f}};
			case 21:
				return {{1000.0000000f, 428.2545471f}};
			case 22:
				return {{1000.0000000f, 443.9299011f}};
			case 23:
				return {{1000.0000000f, 444.8811340f}};
			case 24:
				return {{1000.0000000f, 459.2140198f}};
			case 25:
				return {{1000.0000000f, 460.0471497f}};
			case 26:
				return {{1000.0000000f, 472.5143433f}};
			case 27:
				return {{1000.0000000f, 473.2416382f}};
			case 28:
				return {{1000.0000000f, 483.4656067f}};
			case 29:
				return {{1000.0000000f, 484.1685791f}};
			case 30:
				return {{1000.0000000f, 493.8484192f}};
			case 31:
				return {{1000.0000000f, 494.3926697f}};
			case 32:
				return {{1000.0000000f, 502.4442139f}};
			case 33:
				return {{1000.0000000f, 502.9736938f}};
			case 34:
				return {{1000.0000000f, 510.7427979f}};
			case 35:
				return {{1000.0000000f, 511.1937256f}};
			case 36:
				return {{1000.0000000f, 518.1301270f}};
			case 37:
				return {{1000.0000000f, 518.5700684f}};
			case 38:
				return {{1000.0000000f, 519.0095215f}};
			case 39:
				return {{1000.0000000f, 500.6634216f}};
			case 40:
				return {{1000.0000000f, 498.8476868f}};
			case 41:
				return {{1000.0000000f, 471.6894531f}};
			case 42:
				return {{1000.0000000f, 469.9794006f}};
			case 43:
				return {{1000.0000000f, 442.9660645f}};
			case 44:
				return {{1000.0000000f, 417.5871277f}};
			case 45:
				return {{1000.0000000f, 391.1619568f}};
			case 46:
				return {{1000.0000000f, 389.5305786f}};
			case 47:
				return {{1000.0000000f, 364.7833862f}};
			case 48:
				return {{1000.0000000f, 363.1747437f}};
			case 49:
				return {{1000.0000000f, 337.2171631f}};
			case 50:
				return {{1000.0000000f, 335.5335999f}};
			case 51:
				return {{1000.0000000f, 309.9683228f}};
			case 52:
				return {{1000.0000000f, 308.3560791f}};
			case 53:
				return {{1000.0000000f, 285.0237427f}};
			case 54:
				return {{1000.0000000f, 283.0931091f}};
			case 55:
				return {{1000.0000000f, 258.5480347f}};
			case 56:
				return {{1000.0000000f, 256.9194946f}};
			case 57:
				return {{1000.0000000f, 232.4271393f}};
			case 58:
				return {{1000.0000000f, 230.9935760f}};
			case 59:
				return {{1000.0000000f, 208.8545990f}};
			case 60:
				return {{1000.0000000f, 207.3721313f}};
			case 61:
				return {{1000.0000000f, 184.0393066f}};
			case 62:
				return {{1000.0000000f, 182.6068115f}};
			case 63:
				return {{1000.0000000f, 161.3394165f}};
			case 64:
				return {{1000.0000000f, 159.7380066f}};
			case 65:
				return {{1000.0000000f, 137.5003815f}};
			case 66:
				return {{1000.0000000f, 115.8879089f}};
			case 67:
				return {{1000.0000000f, 95.8544159f}};
			case 68:
				return {{1000.0000000f, 94.5362091f}};
			case 69:
				return {{1000.0000000f, 73.7548065f}};
			case 70:
				return {{1000.0000000f, 72.4786377f}};
			case 71:
				return {{1000.0000000f, 52.5038910f}};
			case 72:
				return {{1000.0000000f, 51.1960602f}};
			case 73:
				return {{1000.0000000f, 32.9644012f}};
			case 74:
				return {{1000.0000000f, 31.5235901f}};
			case 75:
				return {{1000.0000000f, 30.2701569f}};
			case 76:
				return {{1000.0000000f, 11.1421204f}};
			case 77:
				return {{1000.0000000f, 10.1613617f}};
			case 78:
				return {{1000.0000000f, -7.2264404f}};
			case 79:
				return {{1000.0000000f, -8.4018555f}};
			case 80:
				return {{1000.0000000f, -26.1702881f}};
			case 81:
				return {{1000.0000000f, -27.1201172f}};
			case 82:
				return {{1000.0000000f, -44.8266602f}};
			case 83:
				return {{1000.0000000f, -45.5584717f}};
			case 84:
				return {{1000.0000000f, -61.5065918f}};
			case 85:
				return {{1000.0000000f, -62.6777344f}};
			case 86:
				return {{1000.0000000f, -78.9976807f}};
			case 87:
				return {{1000.0000000f, -79.9364014f}};
			case 88:
				return {{1000.0000000f, -95.5395508f}};
			case 89:
				return {{1000.0000000f, -96.6873779f}};
			case 90:
				return {{1000.0000000f, -110.8873291f}};
			case 91:
				return {{1000.0000000f, -125.5928955f}};
			case 92:
				return {{1000.0000000f, -139.0494385f}};
			case 93:
				return {{1000.0000000f, -139.7036133f}};
			case 94:
				return {{1000.0000000f, -153.5233154f}};
			case 95:
				return {{1000.0000000f, -154.3769531f}};
			case 96:
				return {{1000.0000000f, -167.5012207f}};
			case 97:
				return {{1000.0000000f, -168.5506592f}};
			case 98:
				return {{1000.0000000f, -180.2821045f}};
			case 99:
				return {{1000.0000000f, -181.0770264f}};
			case 100:
				return {{1000.0000000f, -193.0888672f}};
			case 101:
				return {{1000.0000000f, -194.0817871f}};
			case 102:
				return {{1000.0000000f, -205.6433105f}};
			case 103:
				return {{1000.0000000f, -216.1108398f}};
			case 104:
				return {{1000.0000000f, -216.8082275f}};
			case 105:
				return {{1000.0000000f, -227.3505859f}};
			case 106:
				return {{1000.0000000f, -228.0187988f}};
			case 107:
				return {{1000.0000000f, -228.5657959f}};
			case 108:
				return {{1000.0000000f, -238.1468506f}};
			case 109:
				return {{1000.0000000f, -238.7722168f}};
			case 110:
				return {{1000.0000000f, -248.4827881f}};
			case 111:
				return {{1000.0000000f, -249.0815430f}};
			case 112:
				return {{1000.0000000f, -258.1691895f}};
			case 113:
				return {{1000.0000000f, -258.7281494f}};
			case 114:
				return {{1000.0000000f, -275.2501221f}};
			case 115:
				return {{1000.0000000f, -283.1724854f}};
			case 116:
				return {{1000.0000000f, -283.3957520f}};
			case 117:
				return {{1000.0000000f, -290.4317627f}};
			case 118:
				return {{1000.0000000f, -290.8327637f}};
			case 119:
				return {{1000.0000000f, -297.8603516f}};
			case 120:
				return {{1000.0000000f, -298.2362061f}};
			case 121:
				return {{1000.0000000f, -304.2756348f}};
			case 122:
				return {{1000.0000000f, -304.6058350f}};
			case 123:
				return {{1000.0000000f, -305.0563965f}};
			case 124:
				return {{1000.0000000f, -311.0228271f}};
			case 125:
				return {{1000.0000000f, -316.6230469f}};
			case 126:
				return {{1000.0000000f, -317.1135254f}};
			case 127:
				return {{1000.0000000f, -321.9949951f}};
			case 128:
				return {{1000.0000000f, -322.4465332f}};
			case 129:
				return {{1000.0000000f, -322.8072510f}};
			case 130:
				return {{1000.0000000f, -327.5804443f}};
			case 131:
				return {{1000.0000000f, -332.0192871f}};
			case 132:
				return {{1000.0000000f, -332.1802979f}};
			case 133:
				return {{1000.0000000f, -336.0573730f}};
			case 134:
				return {{1000.0000000f, -336.1817627f}};
			case 135:
				return {{1000.0000000f, -340.1765137f}};
			case 136:
				return {{1000.0000000f, -340.2766113f}};
			case 137:
				return {{1000.0000000f, -343.6551514f}};
			case 138:
				return {{1000.0000000f, -346.5415039f}};
			case 139:
				return {{1000.0000000f, -349.7819824f}};
			case 140:
				return {{1000.0000000f, -349.7995605f}};
			case 141:
				return {{1000.0000000f, -352.2539062f}};
			case 142:
				return {{1000.0000000f, -352.4711914f}};
			case 143:
				return {{1000.0000000f, -354.5693359f}};
			case 144:
				return {{1000.0000000f, -354.7683105f}};
			case 145:
				return {{1000.0000000f, -356.8011475f}};
			case 146:
				return {{1000.0000000f, -356.9757080f}};
			case 147:
				return {{1000.0000000f, -358.6204834f}};
			case 148:
				return {{1000.0000000f, -358.7729492f}};
			case 149:
				return {{1000.0000000f, -360.5307617f}};
			case 150:
				return {{1000.0000000f, -360.4355469f}};
			case 151:
				return {{1000.0000000f, -361.8718262f}};
			case 152:
				return {{1000.0000000f, -361.7562256f}};
			case 153:
				return {{1000.0000000f, -363.0778809f}};
			case 154:
				return {{1000.0000000f, -363.1750488f}};
			case 155:
				return {{1000.0000000f, -364.0666504f}};
			case 156:
				return {{1000.0000000f, -364.1520996f}};
			case 157:
				return {{1000.0000000f, -364.8118896f}};
			case 158:
				return {{1000.0000000f, -365.1131592f}};
			case 159:
				return {{1000.0000000f, -365.6785889f}};
			case 160:
				return {{1000.0000000f, -365.7379150f}};
			case 161:
				return {{1000.0000000f, -366.8975830f}};
			case 162:
				return {{1000.0000000f, -367.1383057f}};
			case 163:
				return {{1000.0000000f, -367.1704102f}};
			case 164:
				return {{1000.0000000f, -367.5058594f}};
			case 165:
				return {{1000.0000000f, -367.5330811f}};
			case 166:
				return {{1000.0000000f, -367.8172607f}};
			case 167:
				return {{1000.0000000f, -367.8402100f}};
			case 168:
				return {{1000.0000000f, -368.0611572f}};
			case 169:
				return {{1000.0000000f, -368.0804443f}};
			case 170:
				return {{1000.0000000f, -368.2398682f}};
			case 171:
				return {{1000.0000000f, -368.2490234f}};
			case 172:
				return {{1000.0000000f, -368.3774414f}};
			case 173:
				return {{1000.0000000f, -368.1584473f}};
			case 174:
				return {{1000.0000000f, -368.4852295f}};
			case 175:
				return {{1000.0000000f, -368.4898682f}};
			case 176:
				return {{1000.0000000f, -368.5522461f}};
			case 177:
				return {{1000.0000000f, -368.5556641f}};
			case 178:
				return {{1000.0000000f, -368.6008301f}};
			case 179:
				return {{1000.0000000f, -368.6030273f}};
			case 180:
				return {{1000.0000000f, -368.6293945f}};
			case 181:
				return {{1000.0000000f, -368.6307373f}};
			case 182:
				return {{1000.0000000f, -368.6463623f}};
			case 183:
				return {{1000.0000000f, -368.6523438f}};
			case 184:
				return {{1000.0000000f, -368.6516113f}};
			case 185:
				return {{1000.0000000f, -368.6513672f}};
			case 186:
				return {{1000.0000000f, -368.6455078f}};
			case 187:
				return {{1000.0000000f, -368.6450195f}};
			case 188:
				return {{1000.0000000f, -368.6356201f}};
			case 189:
				return {{1000.0000000f, -368.6350098f}};
			case 190:
				return {{1000.0000000f, -368.6240234f}};
			case 191:
				return {{1000.0000000f, -368.6234131f}};
			case 192:
				return {{1000.0000000f, -368.6105957f}};
			case 193:
				return {{1000.0000000f, -368.6097412f}};
			case 194:
				return {{1000.0000000f, -368.5974121f}};
			case 195:
				return {{1000.0000000f, -368.5965576f}};
			case 196:
				return {{1000.0000000f, -368.5834961f}};
			case 197:
				return {{1000.0000000f, -368.5827637f}};
			case 198:
				return {{1000.0000000f, -368.5701904f}};
			case 199:
				return {{1000.0000000f, -368.5695801f}};
			case 200:
				return {{1000.0000000f, -368.5584717f}};
			case 201:
				return {{1000.0000000f, -368.5578613f}};
			case 202:
				return {{1000.0000000f, -368.5469971f}};
			case 203:
				return {{1000.0001221f, -368.6025391f}};
			case 204:
				return {{1000.0377808f, -367.1490479f}};
			case 205:
				return {{1000.0422974f, -367.0168457f}};
			case 206:
				return {{1000.6481934f, -358.3353271f}};
			case 207:
				return {{1001.0569458f, -351.6333008f}};
			case 208:
				return {{1001.0541992f, -350.9328613f}};
			case 209:
				return {{1001.0684814f, -350.6297607f}};
			case 210:
				return {{1001.6578979f, -341.1396484f}};
			case 211:
				return {{1001.6409912f, -340.6165771f}};
			case 212:
				return {{1002.3639526f, -329.2614746f}};
			case 213:
				return {{1002.4221802f, -328.5823975f}};
			case 214:
				return {{1003.1420288f, -316.5308838f}};
			case 215:
				return {{1003.1764526f, -315.7784424f}};
			case 216:
				return {{1004.0240479f, -301.2464600f}};
			case 217:
				return {{1004.1032715f, -300.3363037f}};
			case 218:
				return {{1005.0376587f, -284.4755859f}};
			case 219:
				return {{1005.1494751f, -283.4581299f}};
			case 220:
				return {{1006.1228027f, -267.3049316f}};
			case 221:
				return {{1006.1948242f, -266.0444336f}};
			case 222:
				return {{1007.3257446f, -247.5069580f}};
			case 223:
				return {{1007.3994751f, -246.2775879f}};
			case 224:
				return {{1008.4697266f, -227.7188721f}};
			case 225:
				return {{1008.5687866f, -226.4713135f}};
			case 226:
				return {{1009.8247070f, -205.5640869f}};
			case 227:
				return {{1009.9031372f, -204.3250732f}};
			case 228:
				return {{1011.2250366f, -182.3916016f}};
			case 229:
				return {{1011.3435669f, -180.9370117f}};
			case 230:
				return {{1014.0571289f, -135.9060059f}};
			case 231:
				return {{1015.5102539f, -111.5306396f}};
			case 232:
				return {{1015.6115723f, -109.9249268f}};
			case 233:
				return {{1015.7025757f, -108.4061279f}};
			case 234:
				return {{1017.1416626f, -84.7895508f}};
			case 235:
				return {{1018.6712036f, -59.1810303f}};
			case 236:
				return {{1018.7833252f, -57.5002441f}};
			case 237:
				return {{1020.2786865f, -32.9406738f}};
			case 238:
				return {{1020.3551636f, -31.2847900f}};
			case 239:
				return {{1021.9876709f, -4.5701904f}};
			case 240:
				return {{1022.0880737f, -2.8698730f}};
			case 241:
				return {{1023.7260742f, 24.2356339f}};
			case 242:
				return {{1023.8251953f, 25.8925171f}};
			case 243:
				return {{1025.3864746f, 51.6288948f}};
			case 244:
				return {{1025.4981689f, 53.3281670f}};
			case 245:
				return {{1027.1676025f, 81.1182556f}};
			case 246:
				return {{1027.2987061f, 82.8154144f}};
			case 247:
				return {{1028.9633789f, 110.7204742f}};
			case 248:
				return {{1029.0517578f, 112.4204941f}};
			case 249:
				return {{1030.6501465f, 138.7059937f}};
			case 250:
				return {{1030.7630615f, 140.4692383f}};
			case 251:
				return {{1032.4630127f, 168.6167908f}};
			case 252:
				return {{1032.5495605f, 170.3578949f}};
			case 253:
				return {{1032.6711426f, 172.1118317f}};
			case 254:
				return {{1035.9624023f, 226.4988403f}};
			case 255:
				return {{1037.6665039f, 254.4980469f}};
			case 256:
				return {{1037.7509766f, 256.2382202f}};
			case 257:
				return {{1039.3293457f, 282.3259888f}};
			case 258:
				return {{1039.4322510f, 284.0917664f}};
			case 259:
				return {{1039.5675049f, 285.7866211f}};
			case 260:
				return {{1041.2227783f, 313.4099426f}};
			case 261:
				return {{1041.3244629f, 315.1403809f}};
			case 262:
				return {{1042.9801025f, 342.5137939f}};
			case 263:
				return {{1043.0806885f, 344.2075806f}};
			case 264:
				return {{1044.6107178f, 369.5702820f}};
			case 265:
				return {{1046.2342529f, 396.2939758f}};
			case 266:
				return {{1046.3347168f, 397.9867859f}};
			case 267:
				return {{1047.8287354f, 422.6835632f}};
			case 268:
				return {{1047.9371338f, 424.3296814f}};
			case 269:
				return {{1049.4962158f, 450.2796631f}};
			case 270:
				return {{1049.6099854f, 451.8942261f}};
			case 271:
				return {{1051.1376953f, 477.3769531f}};
			case 272:
				return {{1051.2232666f, 478.9445801f}};
			case 273:
				return {{1052.6512451f, 502.3971863f}};
			case 274:
				return {{1052.7326660f, 503.9306946f}};
			case 275:
				return {{1052.8267822f, 505.4753113f}};
			case 276:
				return {{1054.3016357f, 529.9103394f}};
			case 277:
				return {{1054.3980713f, 531.4248047f}};
			case 278:
				return {{1054.4908447f, 532.9143677f}};
			case 279:
				return {{1055.9426270f, 556.7503662f}};
			case 280:
				return {{1057.2401123f, 578.5659180f}};
			case 281:
				return {{1058.6302490f, 601.2690430f}};
			case 282:
				return {{1058.7155762f, 602.6635742f}};
			case 283:
				return {{1058.8046875f, 604.0430908f}};
			case 284:
				return {{1060.0451660f, 624.6990356f}};
			case 285:
				return {{1060.1328125f, 626.0624390f}};
			case 286:
				return {{1060.1984863f, 627.4210205f}};
			case 287:
				return {{1061.5031738f, 648.7343750f}};
			case 288:
				return {{1061.5759277f, 650.0371094f}};
			case 289:
				return {{1061.6582031f, 651.3395996f}};
			case 290:
				return {{1062.9133301f, 671.9124756f}};
			case 291:
				return {{1062.9836426f, 673.1735229f}};
			case 292:
				return {{1063.0561523f, 674.4375610f}};
			case 293:
				return {{1064.0747070f, 694.0289307f}};
			case 294:
				return {{1064.1374512f, 695.3781738f}};
			case 295:
				return {{1064.9652100f, 717.1038818f}};
			case 296:
				return {{1065.0123291f, 718.4752808f}};
			case 297:
				return {{1065.0656738f, 719.8273315f}};
			case 298:
				return {{1065.6806641f, 741.6655884f}};
			case 299:
				return {{1065.7053223f, 743.0278931f}};
			case 300:
				return {{1065.7384033f, 744.3752441f}};
			case 301:
				return {{1066.1646729f, 764.3271484f}};
			case 302:
				return {{1066.1876221f, 765.6389771f}};
			case 303:
				return {{1066.5233154f, 785.9915771f}};
			case 304:
				return {{1066.5346680f, 787.2360840f}};
			case 305:
				return {{1066.5443115f, 788.4677124f}};
			case 306:
				return {{1066.7769775f, 806.3659058f}};
			case 307:
				return {{1066.7978516f, 807.5218506f}};
			case 308:
				return {{1066.9932861f, 825.2939453f}};
			case 309:
				return {{1067.1567383f, 841.7212524f}};
			case 310:
				return {{1067.1644287f, 842.7031860f}};
			case 311:
				return {{1067.3140869f, 856.8152466f}};
			case 312:
				return {{1067.3273926f, 857.7132568f}};
			case 313:
				return {{1067.3409424f, 858.6035156f}};
			case 314:
				return {{1067.4943848f, 872.2449951f}};
			case 315:
				return {{1067.4959717f, 873.0542603f}};
			case 316:
				return {{1067.5102539f, 873.8604126f}};
			case 317:
				return {{1067.6838379f, 886.1375732f}};
			case 318:
				return {{1067.6976318f, 886.8715820f}};
			case 319:
				return {{1067.8776855f, 897.2818604f}};
			case 320:
				return {{1067.8891602f, 897.9484863f}};
			case 321:
				return {{1067.9020996f, 898.6009521f}};
			case 322:
				return {{1068.1124268f, 908.5851440f}};
			case 323:
				return {{1068.1275635f, 909.1771240f}};
			case 324:
				return {{1068.1440430f, 909.7664795f}};
			case 325:
				return {{1068.3657227f, 918.1643066f}};
			case 326:
				return {{1068.3822021f, 918.6984253f}};
			case 327:
				return {{1068.3945312f, 919.2249756f}};
			case 328:
				return {{1068.6600342f, 927.2623291f}};
			case 329:
				return {{1068.6765137f, 927.7365723f}};
			case 330:
				return {{1068.6931152f, 928.2074585f}};
			case 331:
				return {{1068.9869385f, 935.3841553f}};
			case 332:
				return {{1069.0036621f, 935.8048096f}};
			case 333:
				return {{1069.0208740f, 936.2294922f}};
			case 334:
				return {{1069.3184814f, 942.2600708f}};
			case 335:
				return {{1069.3361816f, 942.6386108f}};
			case 336:
				return {{1069.3541260f, 943.0209351f}};
			case 337:
				return {{1069.6923828f, 948.7783203f}};
			case 338:
				return {{1069.7076416f, 949.1205444f}};
			case 339:
				return {{1069.7331543f, 949.4597778f}};
			case 340:
				return {{1070.0843506f, 954.6016846f}};
			case 341:
				return {{1070.1099854f, 954.9048462f}};
			case 342:
				return {{1070.4545898f, 959.2515869f}};
			case 343:
				return {{1070.8403320f, 963.4528809f}};
			case 344:
				return {{1071.2102051f, 967.0260620f}};
			case 345:
				return {{1071.2384033f, 967.2523193f}};
			case 346:
				return {{1071.2600098f, 967.4768677f}};
			case 347:
				return {{1071.6662598f, 970.8815918f}};
			case 348:
				return {{1071.6929932f, 971.0822754f}};
			case 349:
				return {{1072.1094971f, 974.1334229f}};
			case 350:
				return {{1072.1345215f, 974.3173828f}};
			case 351:
				return {{1072.1591797f, 974.4953003f}};
			case 352:
				return {{1072.5548096f, 977.0498657f}};
			case 353:
				return {{1072.5815430f, 977.2140503f}};
			case 354:
				return {{1073.0040283f, 979.6582642f}};
			case 355:
				return {{1073.0289307f, 979.8004150f}};
			case 356:
				return {{1073.0585938f, 979.9459839f}};
			case 357:
				return {{1073.4832764f, 982.1126709f}};
			case 358:
				return {{1073.5106201f, 982.2406006f}};
			case 359:
				return {{1073.9074707f, 984.0537109f}};
			case 360:
				return {{1073.9368896f, 984.1685791f}};
			case 361:
				return {{1073.9638672f, 984.2821045f}};
			case 362:
				return {{1074.3898926f, 985.9913330f}};
			case 363:
				return {{1074.4165039f, 986.0926514f}};
			case 364:
				return {{1074.4410400f, 986.1912842f}};
			case 365:
				return {{1074.4680176f, 986.2932739f}};
			case 366:
				return {{1074.8636475f, 987.6950684f}};
			case 367:
				return {{1074.8902588f, 987.7801514f}};
			case 368:
				return {{1075.3034668f, 989.1015625f}};
			case 369:
				return {{1075.3330078f, 989.1806030f}};
			case 370:
				return {{1075.7436523f, 990.3308105f}};
			case 371:
				return {{1075.7663574f, 990.4010010f}};
			case 372:
				return {{1075.7930908f, 990.4668579f}};
			case 373:
				return {{1076.1707764f, 991.4000854f}};
			case 374:
				return {{1076.5666504f, 992.2670898f}};
			case 375:
				return {{1076.9501953f, 993.0096436f}};
			case 376:
				return {{1076.9737549f, 993.0547485f}};
			case 377:
				return {{1077.0014648f, 993.0952148f}};
			case 378:
				return {{1077.3509521f, 993.6776123f}};
			case 379:
				return {{1077.3714600f, 993.7106934f}};
			case 380:
				return {{1077.3958740f, 993.7454834f}};
			case 381:
				return {{1077.7576904f, 994.2484131f}};
			case 382:
				return {{1077.7805176f, 994.2725220f}};
			case 383:
				return {{1077.8015137f, 994.3034668f}};
			case 384:
				return {{1078.1285400f, 994.6719971f}};
			case 385:
				return {{1078.1499023f, 994.6951294f}};
			case 386:
				return {{1078.1712646f, 994.7159424f}};
			case 387:
				return {{1078.5085449f, 995.0113525f}};
			case 388:
				return {{1078.5263672f, 995.0260010f}};
			case 389:
				return {{1078.8496094f, 995.2305908f}};
			case 390:
				return {{1078.8679199f, 995.2395020f}};
			case 391:
				return {{1078.8892822f, 995.2519531f}};
			case 392:
				return {{1079.1752930f, 995.3580322f}};
			case 393:
				return {{1079.1953125f, 995.3632812f}};
			case 394:
				return {{1079.2113037f, 995.3687744f}};
			case 395:
				return {{1079.5009766f, 995.4022827f}};
			case 396:
				return {{1079.5168457f, 995.4009399f}};
			case 397:
				return {{1079.5347900f, 995.4029541f}};
			case 398:
				return {{1079.8106689f, 995.3572998f}};
			case 399:
				return {{1079.8262939f, 995.3527832f}};
			case 400:
				return {{1080.0660400f, 995.2493286f}};
			case 401:
				return {{1080.0812988f, 995.2406006f}};
			case 402:
				return {{1080.0965576f, 995.2298584f}};
			case 403:
				return {{1080.3371582f, 995.0521240f}};
			case 404:
				return {{1080.3520508f, 995.0391235f}};
			case 405:
				return {{1080.3669434f, 995.0261230f}};
			case 406:
				return {{1080.5739746f, 994.7982788f}};
			case 407:
				return {{1080.7792969f, 994.5019531f}};
			case 408:
				return {{1080.9702148f, 994.1516113f}};
			case 409:
				return {{1080.9818115f, 994.1260986f}};
			case 410:
				return {{1080.9934082f, 994.1053467f}};
			case 411:
				return {{1081.1546631f, 993.7265625f}};
			case 412:
				return {{1081.1655273f, 993.7006836f}};
			case 413:
				return {{1081.1766357f, 993.6732178f}};
			case 414:
				return {{1081.3331299f, 993.2201538f}};
			case 415:
				return {{1081.3415527f, 993.1890869f}};
			case 416:
				return {{1081.3498535f, 993.1616821f}};
			case 417:
				return {{1081.4879150f, 992.6585693f}};
			case 418:
				return {{1081.4935303f, 992.6258545f}};
			case 419:
				return {{1081.5028076f, 992.5935059f}};
			case 420:
				return {{1081.6145020f, 992.0794067f}};
			case 421:
				return {{1081.6228027f, 992.0455933f}};
			case 422:
				return {{1081.7292480f, 991.4593506f}};
			case 423:
				return {{1081.7347412f, 991.4223633f}};
			case 424:
				return {{1081.7386475f, 991.3839722f}};
			case 425:
				return {{1081.8226318f, 990.7972412f}};
			case 426:
				return {{1081.8271484f, 990.7579346f}};
			case 427:
				return {{1081.8332520f, 990.7164307f}};
			case 428:
				return {{1081.9041748f, 990.0549316f}};
			case 429:
				return {{1081.9074707f, 990.0162354f}};
			case 430:
				return {{1081.9110107f, 989.9736328f}};
			case 431:
				return {{1081.9665527f, 989.2776489f}};
			case 432:
				return {{1081.9689941f, 989.2340088f}};
			case 433:
				return {{1081.9729004f, 989.1868896f}};
			case 434:
				return {{1082.0122070f, 988.5108643f}};
			case 435:
				return {{1082.0134277f, 988.4628906f}};
			case 436:
				return {{1082.0167236f, 988.4185791f}};
			case 437:
				return {{1082.0457764f, 987.6672363f}};
			case 438:
				return {{1082.0456543f, 987.6184692f}};
			case 439:
				return {{1082.0620117f, 986.8469849f}};
			case 440:
				return {{1082.0635986f, 986.1031494f}};
			case 441:
				return {{1082.0581055f, 985.2981567f}};
			case 442:
				return {{1082.0570068f, 985.2438354f}};
			case 443:
				return {{1082.0595703f, 985.1936035f}};
			case 444:
				return {{1082.0562744f, 985.1449585f}};
			case 445:
				return {{1082.0423584f, 984.3726807f}};
			case 446:
				return {{1082.0400391f, 984.3218994f}};
			case 447:
				return {{1082.0152588f, 983.4909058f}};
			case 448:
				return {{1082.0119629f, 983.4361572f}};
			case 449:
				return {{1082.0119629f, 983.3868408f}};
			case 450:
				return {{1081.9738770f, 982.5479126f}};
			case 451:
				return {{1081.9746094f, 982.4948120f}};
			case 452:
				return {{1081.9334717f, 981.7064819f}};
			case 453:
				return {{1081.9312744f, 981.6573486f}};
			case 454:
				return {{1081.9276123f, 981.6026611f}};
			case 455:
				return {{1081.8795166f, 980.7634277f}};
			case 456:
				return {{1081.8762207f, 980.7105713f}};
			case 457:
				return {{1081.8262939f, 979.8756104f}};
			case 458:
				return {{1081.8220215f, 979.8271484f}};
			case 459:
				return {{1081.8198242f, 979.7728271f}};
			case 460:
				return {{1081.7644043f, 978.9990234f}};
			case 461:
				return {{1081.7607422f, 978.9492798f}};
			case 462:
				return {{1081.7573242f, 978.8973999f}};
			case 463:
				return {{1081.7519531f, 978.8434448f}};
			case 464:
				return {{1081.6947021f, 978.0319214f}};
			case 465:
				return {{1081.6879883f, 977.9847412f}};
			case 466:
				return {{1081.6854248f, 977.9315186f}};
			case 467:
				return {{1081.6300049f, 977.1850586f}};
			case 468:
				return {{1081.6228027f, 977.1367798f}};
			case 469:
				return {{1081.5607910f, 976.3613281f}};
			case 470:
				return {{1081.4986572f, 975.6069336f}};
			case 471:
				return {{1081.4392090f, 974.9177246f}};
			case 472:
				return {{1081.4349365f, 974.8723755f}};
			case 473:
				return {{1081.4326172f, 974.8293457f}};
			case 474:
				return {{1081.4283447f, 974.7821655f}};
			case 475:
				return {{1081.3675537f, 974.0796509f}};
			case 476:
				return {{1081.3625488f, 974.0358887f}};
			case 477:
				return {{1081.3007812f, 973.3640137f}};
			case 478:
				return {{1081.3011475f, 973.3218384f}};
			case 479:
				return {{1081.2968750f, 973.2838135f}};
			case 480:
				return {{1081.2427979f, 972.6843262f}};
			case 481:
				return {{1081.2381592f, 972.6436768f}};
			case 482:
				return {{1081.2355957f, 972.6071777f}};
			case 483:
				return {{1081.1812744f, 972.0037231f}};
			case 484:
				return {{1081.1796875f, 971.9645996f}};
			case 485:
				return {{1081.1760254f, 971.9299927f}};
			case 486:
				return {{1081.1269531f, 971.3978271f}};
			case 487:
				return {{1081.1245117f, 971.3626709f}};
			case 488:
				return {{1081.0756836f, 970.8316650f}};
			case 489:
				return {{1081.0751953f, 970.7983398f}};
			case 490:
				return {{1081.0703125f, 970.7693481f}};
			case 491:
				return {{1081.0695801f, 970.7361450f}};
			case 492:
				return {{1081.0261230f, 970.2451172f}};
			case 493:
				return {{1081.0212402f, 970.2156982f}};
			case 494:
				return {{1080.9853516f, 969.7915039f}};
			case 495:
				return {{1080.9813232f, 969.7617188f}};
			case 496:
				return {{1080.9815674f, 969.7342529f}};
			case 497:
				return {{1080.9796143f, 969.7110596f}};
			case 498:
				return {{1080.9416504f, 969.2933350f}};
			case 499:
				return {{1080.9415283f, 969.2719116f}};
			case 500:
				return {{1080.9062500f, 968.8946533f}};
			case 501:
				return {{1080.9075928f, 968.8687744f}};
			case 502:
				return {{1080.9025879f, 968.8470459f}};
			case 503:
				return {{1080.8800049f, 968.5297852f}};
			case 504:
				return {{1080.8323975f, 967.9498901f}};
			case 505:
				return {{1080.8283691f, 967.9348145f}};
			case 506:
				return {{1080.8265381f, 967.9173584f}};
			case 507:
				return {{1080.8248291f, 967.9003296f}};
			case 508:
				return {{1080.8073730f, 967.6563721f}};
			case 509:
				return {{1080.8051758f, 967.6406250f}};
			case 510:
				return {{1080.7890625f, 967.4204102f}};
			case 511:
				return {{1080.7886963f, 967.4082031f}};
			case 512:
				return {{1080.7751465f, 967.2301025f}};
			case 513:
				return {{1080.7724609f, 967.2189941f}};
			case 514:
				return {{1080.7739258f, 967.2104492f}};
			case 515:
				return {{1080.7711182f, 967.1977539f}};
			case 516:
				return {{1080.7609863f, 967.0374146f}};
			case 517:
				return {{1080.7622070f, 967.0256348f}};
			case 518:
				return {{1080.7484131f, 966.8927002f}};
			case 519:
				return {{1080.7495117f, 966.8823853f}};
			case 520:
				return {{1080.7484131f, 966.8765259f}};
			case 521:
				return {{1080.7412109f, 966.7686768f}};
			case 522:
				return {{1080.7420654f, 966.7637939f}};
			case 523:
				return {{1080.7386475f, 966.7543945f}};
			case 524:
				return {{1080.7338867f, 966.6632080f}};
			case 525:
				return {{1080.7322998f, 966.6565552f}};
			case 526:
				return {{1080.7330322f, 966.6527710f}};
			case 527:
				return {{1080.7294922f, 966.5787354f}};
			case 528:
				return {{1080.7301025f, 966.5753784f}};
			case 529:
				return {{1080.7242432f, 966.5701294f}};
			case 530:
				return {{1080.7235107f, 966.5101318f}};
			case 531:
				return {{1080.7239990f, 966.5072021f}};
			case 532:
				return {{1080.7202148f, 966.5026855f}};
			case 533:
				return {{1080.7199707f, 966.4507446f}};
			case 534:
				return {{1080.7203369f, 966.4486694f}};
			case 535:
				return {{1080.7183838f, 966.4465942f}};
			case 536:
				return {{1080.7158203f, 966.3802490f}};
			case 537:
				return {{1080.7160645f, 966.3768311f}};
			case 538:
				return {{1080.7103271f, 966.3533936f}};
			case 539:
				return {{1080.7124023f, 966.3504028f}};
			case 540:
				return {{1080.7126465f, 966.3494263f}};
			case 541:
				return {{1080.7100830f, 966.3317871f}};
			case 542:
				return {{1080.7102051f, 966.3329468f}};
			case 543:
				return {{1080.7103271f, 966.3320312f}};
			case 544:
				return {{1080.7116699f, 966.3171387f}};
			case 545:
				return {{1080.7117920f, 966.3168335f}};
			case 546:
				return {{1080.7119141f, 966.3160400f}};
			case 547:
				return {{1080.7084961f, 966.3048096f}};
			case 548:
				return {{1080.7084961f, 966.3043213f}};
			case 549:
				return {{1080.7084961f, 966.3037720f}};
			case 550:
				return {{1080.7109375f, 966.3010254f}};
			case 551:
				return {{1080.7109375f, 966.3005371f}};
			case 552:
				return {{1080.7092285f, 966.2926636f}};
			case 553:
				return {{1080.7092285f, 966.2923584f}};
			case 554:
				return {{1080.7114258f, 966.2905884f}};
			case 555:
				return {{1080.7114258f, 966.2905884f}};
			case 556:
				return {{1080.7114258f, 966.2905884f}};
			case 557:
				return {{1080.7114258f, 966.2893677f}};
			case 558:
				return {{1080.7114258f, 966.2894287f}};
			case 559:
				return {{1080.7114258f, 966.2891846f}};
			case 560:
				return {{1080.7092285f, 966.2890625f}};
			case 561:
				return {{1080.7092285f, 966.2891235f}};
			case 562:
				return {{1080.7092285f, 966.2889404f}};
			case 563:
				return {{1080.7109375f, 966.2893677f}};
			case 564:
				return {{1080.7109375f, 966.2893677f}};
			case 565:
				return {{1080.7109375f, 966.2893677f}};
			case 566:
				return {{1080.7106934f, 966.2899780f}};
			case 567:
				return {{1080.7106934f, 966.2899780f}};
			case 568:
				return {{1080.7084961f, 966.2910156f}};
			case 569:
				return {{1080.7082520f, 966.2917480f}};
			case 570:
				return {{1080.7080078f, 966.2928467f}};
			case 571:
				return {{1080.7080078f, 966.2930908f}};
			case 572:
				return {{1080.7080078f, 966.2930908f}};
			case 573:
				return {{1080.7097168f, 966.2941895f}};
			case 574:
				return {{1080.7097168f, 966.2941895f}};
			case 575:
				return {{1080.7097168f, 966.2941895f}};
			case 576:
				return {{1080.7094727f, 966.2952271f}};
			case 577:
				return {{1080.7094727f, 966.2954712f}};
			case 578:
				return {{1080.7094727f, 966.2955322f}};
			case 579:
				return {{1080.7072754f, 966.2964478f}};
			case 580:
				return {{1080.7072754f, 966.2965088f}};
			case 581:
				return {{1080.7072754f, 966.2965088f}};
			case 582:
				return {{1080.7113037f, 966.2973633f}};
			case 583:
				return {{1080.7113037f, 966.2974854f}};
			case 584:
				return {{1080.7110596f, 966.2983398f}};
			case 585:
				return {{1080.7110596f, 966.2983398f}};
			case 586:
				return {{1080.7110596f, 966.2983398f}};
			case 587:
				return {{1080.7109375f, 966.3034668f}};
			case 588:
				return {{1080.7109375f, 966.3034668f}};
			case 589:
				return {{1080.7109375f, 966.3034668f}};
			case 590:
				return {{1080.7108154f, 966.3020020f}};
			case 591:
				return {{1080.7108154f, 966.3023682f}};
			case 592:
				return {{1080.7108154f, 966.3023682f}};
			case 593:
				return {{1080.7106934f, 966.3048096f}};
			case 594:
				return {{1080.7106934f, 966.3048096f}};
			case 595:
				return {{1080.7106934f, 966.3049927f}};
			case 596:
				return {{1080.7105713f, 966.3052368f}};
			case 597:
				return {{1080.7105713f, 966.3052368f}};
			case 598:
				return {{1080.7105713f, 966.3054810f}};
			case 599:
				return {{1080.7104492f, 966.3037720f}};
			case 600:
				return {{1080.7104492f, 966.3037720f}};
			case 601:
				return {{1080.7103271f, 966.3064575f}};
			case 602:
				return {{1080.7103271f, 966.3064575f}};
			case 603:
				return {{1080.7102051f, 966.3064575f}};
			case 604:
				return {{1080.7102051f, 966.3064575f}};
			case 605:
				return {{1080.7102051f, 966.3067627f}};
			case 606:
				return {{1080.7102051f, 966.3067627f}};
			case 607:
				return {{1080.7102051f, 966.3067627f}};
			case 608:
				return {{1080.7102051f, 966.3070068f}};
			case 609:
				return {{1080.7102051f, 966.3070068f}};
			case 610:
				return {{1080.7102051f, 966.3070068f}};
			case 611:
				return {{1080.7102051f, 966.3074951f}};
			case 612:
				return {{1080.7102051f, 966.3073120f}};
			case 613:
				return {{1080.7102051f, 966.3073120f}};
			case 614:
				return {{1080.7102051f, 966.3074951f}};
			case 615:
				return {{1080.7102051f, 966.3074951f}};
			case 616:
				return {{1080.7102051f, 966.3074951f}};
			case 617:
				return {{1080.7102051f, 966.3074951f}};
			case 618:
				return {{1080.7102051f, 966.3074951f}};
			case 619:
				return {{1080.7102051f, 966.3074951f}};
			case 620:
				return {{1080.7102051f, 966.3074951f}};
			case 621:
				return {{1080.7102051f, 966.3074951f}};
			case 622:
				return {{1080.7102051f, 966.3074951f}};
			case 623:
				return {{1080.7102051f, 966.3074951f}};
			case 624:
				return {{1080.7102051f, 966.3074951f}};
			case 625:
				return {{1080.7102051f, 966.3077393f}};
			case 626:
				return {{1080.7102051f, 966.3077393f}};
			case 627:
				return {{1080.7102051f, 966.3077393f}};
			case 628:
				return {{1080.7102051f, 966.3077393f}};
			case 629:
				return {{1080.7102051f, 966.3077393f}};
			case 630:
				return {{1080.7102051f, 966.3077393f}};
			case 631:
				return {{1080.7102051f, 966.3077393f}};
			case 632:
				return {{1080.7102051f, 966.3077393f}};
			case 633:
				return {{1080.7102051f, 966.3077393f}};
			case 634:
				return {{1080.7102051f, 966.3077393f}};
			case 635:
				return {{1080.7102051f, 966.3077393f}};
			case 636:
				return {{1080.7102051f, 966.3077393f}};
			case 637:
				return {{1080.7102051f, 966.3077393f}};
			case 638:
				return {{1080.7102051f, 966.3074951f}};
			case 639:
				return {{1080.7102051f, 966.3074951f}};
			case 640:
				return {{1080.7102051f, 966.3074951f}};
			case 641:
				return {{1080.7102051f, 966.3074951f}};
			case 642:
				return {{1080.7102051f, 966.3074951f}};
			case 643:
				return {{1080.7102051f, 966.3074951f}};
			case 644:
				return {{1080.7102051f, 966.3074951f}};
			case 645:
				return {{1080.7102051f, 966.3074951f}};
			case 646:
				return {{1080.7102051f, 966.3074951f}};
			case 647:
				return {{1080.7102051f, 966.3074951f}};
			case 648:
				return {{1080.7102051f, 966.3074951f}};
			case 649:
				return {{1080.7102051f, 966.3074951f}};
			case 650:
				return {{1080.7102051f, 966.3074951f}};
			case 651:
				return {{1080.7102051f, 966.3074951f}};
			case 652:
				return {{1080.7102051f, 966.3074951f}};
			case 653:
				return {{1080.7102051f, 966.3074951f}};
			case 654:
				return {{1080.7102051f, 966.3074951f}};
			case 655:
				return {{1080.7102051f, 966.3074951f}};
			case 656:
				return {{1080.7102051f, 966.3070679f}};
			case 657:
				return {{1080.7102051f, 966.3070679f}};
			case 658:
				return {{1080.7102051f, 966.3070679f}};
			case 659:
				return {{1080.7102051f, 966.3070679f}};
			case 660:
				return {{1080.7102051f, 966.3070679f}};
			case 661:
				return {{1080.7102051f, 966.3070679f}};
			case 662:
				return {{1080.7102051f, 966.3070679f}};
			case 663:
				return {{1080.7102051f, 966.3070679f}};
			case 664:
				return {{1080.7102051f, 966.3070679f}};
			case 665:
				return {{1080.7102051f, 966.3070679f}};
			case 666:
				return {{1080.7102051f, 966.3070679f}};
			case 667:
				return {{1080.7102051f, 966.3070679f}};
			case 668:
				return {{1080.7102051f, 966.3074951f}};
			case 669:
				return {{1080.7102051f, 966.3074951f}};
			case 670:
				return {{1080.7102051f, 966.3074951f}};
			case 671:
				return {{1080.7102051f, 966.3074951f}};
			case 672:
				return {{1080.7102051f, 966.3074951f}};
			case 673:
				return {{1080.7102051f, 966.3074951f}};
			case 674:
				return {{1080.7102051f, 966.3074951f}};
			case 675:
				return {{1080.7102051f, 966.3074951f}};
			case 676:
				return {{1080.7102051f, 966.3074951f}};
			case 677:
				return {{1080.7102051f, 966.3074951f}};
			case 678:
				return {{1080.7102051f, 966.3074951f}};
			case 679:
				return {{1080.7102051f, 966.3074951f}};
			case 680:
				return {{1080.7102051f, 966.3074951f}};
			case 681:
				return {{1080.7102051f, 966.3074951f}};
			case 682:
				return {{1080.7102051f, 966.3074951f}};
			case 683:
				return {{1080.7102051f, 966.3074951f}};
			case 684:
				return {{1080.7102051f, 966.3074951f}};
			case 685:
				return {{1080.7102051f, 966.3074951f}};
			case 686:
				return {{1080.7102051f, 966.3074951f}};
			case 687:
				return {{1080.7102051f, 966.3074951f}};
			case 688:
				return {{1080.7102051f, 966.3074951f}};
			case 689:
				return {{1080.7102051f, 966.3074951f}};
			case 690:
				return {{1080.7102051f, 966.3074951f}};
			case 691:
				return {{1080.7102051f, 966.3074951f}};
			case 692:
				return {{1080.7102051f, 966.3074951f}};
			case 693:
				return {{1080.7102051f, 966.3070679f}};
			case 694:
				return {{1080.7102051f, 966.3070679f}};
			case 695:
				return {{1080.7102051f, 966.3070679f}};
			case 696:
				return {{1080.7102051f, 966.3070679f}};
			case 697:
				return {{1080.7102051f, 966.3070679f}};
			case 698:
				return {{1080.7102051f, 966.3074951f}};
			case 699:
				return {{1080.7102051f, 966.3074951f}};
			case 700:
				return {{1080.7102051f, 966.3074951f}};
			case 701:
				return {{1080.7102051f, 966.3074951f}};
			case 702:
				return {{1080.7102051f, 966.3074951f}};
			case 703:
				return {{1080.7102051f, 966.3074951f}};
			case 704:
				return {{1080.7102051f, 966.3074951f}};
			case 705:
				return {{1080.7102051f, 966.3074951f}};
			case 706:
				return {{1080.7102051f, 966.3074951f}};
			case 707:
				return {{1080.7102051f, 966.3074951f}};
			case 708:
				return {{1080.7102051f, 966.3074951f}};
			case 709:
				return {{1080.7102051f, 966.3074951f}};
			case 710:
				return {{1080.7102051f, 966.3074951f}};
			case 711:
				return {{1080.7102051f, 966.3074951f}};
			case 712:
				return {{1080.7102051f, 966.3074951f}};
			case 713:
				return {{1080.7102051f, 966.3074951f}};
			case 714:
				return {{1080.7102051f, 966.3074951f}};
			case 715:
				return {{1080.7102051f, 966.3074951f}};
			case 716:
				return {{1080.7102051f, 966.3074951f}};
			case 717:
				return {{1080.7102051f, 966.3074951f}};
			case 718:
				return {{1080.7102051f, 966.3070679f}};
			case 719:
				return {{1080.7102051f, 966.3070679f}};
			case 720:
				return {{1080.7102051f, 966.3070679f}};
			case 721:
				return {{1080.7102051f, 966.3070679f}};
			case 722:
				return {{1080.7102051f, 966.3070679f}};
			case 723:
				return {{1080.7102051f, 966.3074951f}};
			case 724:
				return {{1080.7102051f, 966.3074951f}};
			case 725:
				return {{1080.7102051f, 966.3074951f}};
			case 726:
				return {{1080.7102051f, 966.3074951f}};
			case 727:
				return {{1080.7102051f, 966.3074951f}};
			case 728:
				return {{1080.7102051f, 966.3074951f}};
			case 729:
				return {{1080.7102051f, 966.3074951f}};
			case 730:
				return {{1080.7102051f, 966.3074951f}};
			case 731:
				return {{1080.7102051f, 966.3074951f}};
			case 732:
				return {{1080.7102051f, 966.3074951f}};
			case 733:
				return {{1080.7102051f, 966.3074951f}};
			case 734:
				return {{1080.7102051f, 966.3074951f}};
			case 735:
				return {{1080.7102051f, 966.3074951f}};
			case 736:
				return {{1080.7102051f, 966.3074951f}};
			case 737:
				return {{1080.7102051f, 966.3074951f}};
			case 738:
				return {{1080.7102051f, 966.3074951f}};
			case 739:
				return {{1080.7102051f, 966.3074951f}};
			case 740:
				return {{1080.7102051f, 966.3074951f}};
			case 741:
				return {{1080.7102051f, 966.3074951f}};
			case 742:
				return {{1080.7102051f, 966.3074951f}};
			case 743:
				return {{1080.7102051f, 966.3074951f}};
			case 744:
				return {{1080.7102051f, 966.3074951f}};
			case 745:
				return {{1080.7102051f, 966.3074951f}};
			case 746:
				return {{1080.7102051f, 966.3070679f}};
			case 747:
				return {{1080.7102051f, 966.3070679f}};
			case 748:
				return {{1080.7102051f, 966.3070679f}};
			case 749:
				return {{1080.7102051f, 966.3070679f}};
			case 750:
				return {{1080.7102051f, 966.3074951f}};
			case 751:
				return {{1080.7102051f, 966.3074951f}};
			case 752:
				return {{1080.7102051f, 966.3074951f}};
			case 753:
				return {{1080.7102051f, 966.3074951f}};
			case 754:
				return {{1080.7102051f, 966.3074951f}};
			case 755:
				return {{1080.7102051f, 966.3074951f}};
			case 756:
				return {{1080.7102051f, 966.3074951f}};
			case 757:
				return {{1080.7102051f, 966.3074951f}};
			case 758:
				return {{1080.7102051f, 966.3074951f}};
			case 759:
				return {{1080.7102051f, 966.3074951f}};
			case 760:
				return {{1080.7102051f, 966.3074951f}};
			case 761:
				return {{1080.7102051f, 966.3074951f}};
			case 762:
				return {{1080.7102051f, 966.3074951f}};
			case 763:
				return {{1080.7102051f, 966.3074951f}};
			case 764:
				return {{1080.7102051f, 966.3074951f}};
			case 765:
				return {{1080.7102051f, 966.3074951f}};
			case 766:
				return {{1080.7102051f, 966.3074951f}};
			case 767:
				return {{1080.7102051f, 966.3074951f}};
			case 768:
				return {{1080.7102051f, 966.3074951f}};
			case 769:
				return {{1080.7102051f, 966.3074951f}};
			case 770:
				return {{1080.7102051f, 966.3074951f}};
			case 771:
				return {{1080.7102051f, 966.3074951f}};
			case 772:
				return {{1080.7102051f, 966.3070679f}};
			case 773:
				return {{1080.7102051f, 966.3070679f}};
			case 774:
				return {{1080.7102051f, 966.3074951f}};
			case 775:
				return {{1080.7102051f, 966.3074951f}};
			case 776:
				return {{1080.7102051f, 966.3074951f}};
			case 777:
				return {{1080.7102051f, 966.3074951f}};
			case 778:
				return {{1080.7102051f, 966.3074951f}};
			case 779:
				return {{1080.7102051f, 966.3074951f}};
			case 780:
				return {{1080.7102051f, 966.3074951f}};
			case 781:
				return {{1080.7102051f, 966.3074951f}};
			case 782:
				return {{1080.7102051f, 966.3074951f}};
			case 783:
				return {{1080.7102051f, 966.3074951f}};
			case 784:
				return {{1080.7102051f, 966.3074951f}};
			case 785:
				return {{1080.7102051f, 966.3074951f}};
			case 786:
				return {{1080.7102051f, 966.3074951f}};
			case 787:
				return {{1080.7102051f, 966.3074951f}};
			case 788:
				return {{1080.7102051f, 966.3070679f}};
			case 789:
				return {{1080.7102051f, 966.3070679f}};
			case 790:
				return {{1080.7102051f, 966.3070679f}};
			case 791:
				return {{1080.7102051f, 966.3070679f}};
			case 792:
				return {{1080.7102051f, 966.3070679f}};
			case 793:
				return {{1080.7102051f, 966.3074951f}};
			case 794:
				return {{1080.7102051f, 966.3074951f}};
			case 795:
				return {{1080.7102051f, 966.3074951f}};
			case 796:
				return {{1080.7102051f, 966.3074951f}};
			case 797:
				return {{1080.7102051f, 966.3074951f}};
			case 798:
				return {{1080.7102051f, 966.3074951f}};
			case 799:
				return {{1080.7102051f, 966.3074951f}};
			case 800:
				return {{1080.7102051f, 966.3074951f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[9])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 9.0254517f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[10])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, 3.4066925f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[11])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -0.9229774f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[12])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -4.5307636f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[13])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -7.4373074f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[14])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -9.9486294f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		else if (screenCoord == k_ScreenCentreLine[15])
		{
			switch (frameNumber)
			{
			case 0:
				return {{0.0000000f, -12.0339508f}};
			}
			assert(false); // Shouldn't be any unaccounted raycasts
		}
		assert(false); // Shouldn't be any unaccounted raycasts
		return std::nullopt;
	}
};
// NOLINTEND(bugprone-branch-clone, google-readability-function-size, readability-function-size)
