/******************************************************************************
 * Copyright (c) 2018-2024 openblack developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/openblack/openblack
 *
 * openblack is licensed under the GNU General Public License version 3.
 *******************************************************************************/

#include "AllMeshes.h"

namespace openblack
{

const std::array<std::string, static_cast<uint16_t>(MeshId::_COUNT)> k_MeshNames = {
    "Dummy",
    "AnimalBat1",
    "AnimalBat2",
    "AnimalCrow1",
    "AnimalCrow2",
    "AnimalDove1",
    "AnimalDove2",
    "AnimalPigeon1",
    "AnimalPigeon2",
    "AnimalSeagull1",
    "AnimalSeagull2",
    "AnimalSpellDove",
    "AnimalSwallow1",
    "AnimalSwallow2",
    "AnimalVulture1",
    "AnimalVulture2",
    "AnimalCow1",
    "AnimalCow2",
    "AnimalCow3",
    "AnimalHorse1",
    "AnimalHorse2",
    "AnimalHorse3",
    "AnimalLeopard1",
    "AnimalLeopard2",
    "AnimalLeopard3",
    "AnimalLion1",
    "AnimalLion2",
    "AnimalLion3",
    "AnimalPig1",
    "AnimalPig2",
    "AnimalPig3",
    "SharkBoned",
    "AnimalSheep1",
    "AnimalSheep2",
    "AnimalSheep3",
    "AnimalTiger1",
    "AnimalTiger2",
    "AnimalTiger3",
    "AnimalTortoise1",
    "AnimalTortoise2",
    "AnimalTortoise3",
    "AnimalWolf1",
    "AnimalWolf2",
    "AnimalWolf3",
    "AnimalZebra1",
    "AnimalZebra2",
    "AnimalZebra3",
    "BuildingAmerican1",
    "BuildingAmerican1A",
    "BuildingAmerican2",
    "BuildingAmerican2A",
    "BuildingAmerican3",
    "BuildingAmerican3A",
    "BuildingAmerican4",
    "BuildingAmerican5",
    "BuildingAmericanCreche",
    "BuildingAmericanFence",
    "BuildingAmericanGraveyard",
    "BuildingAmericanTotem",
    "BuildingAmericanWonder",
    "BuildingAmericanWorkshop",
    "BuildingAztec1",
    "BuildingAztec2",
    "BuildingAztec3",
    "BuildingAztec4",
    "BuildingAztec5",
    "BuildingAztecCreche",
    "BuildingAztecGraveyard",
    "BuildingAztecOlmecHead",
    "BuildingAztecStatue",
    "BuildingAztecTemple",
    "BuildingAztecTotem",
    "BuildingAztecWonder",
    "BuildingAztecWorkshop",
    "BuildingCeltic1",
    "BuildingCeltic2",
    "BuildingCeltic3",
    "BuildingCeltic4",
    "BuildingCeltic5",
    "BuildingCeltic5A",
    "BuildingCelticCreche",
    "BuildingCelticFenceShort",
    "BuildingCelticFenceTall",
    "BuildingCelticGraveyard",
    "BuildingCelticGrave01",
    "BuildingCelticGrave02",
    "BuildingCelticGrave03",
    "BuildingCelticTotem",
    "BuildingCelticWallGateSpell",
    "BuildingCelticWallTowerSpell",
    "BuildingCelticWallSpell",
    "BuildingCelticWonder",
    "BuildingCelticWorkshop",
    "BuildingCitadelAmericanAltar",
    "BuildingCitadelAztecAltar",
    "BuildingCitadelCelticAltar",
    "BuildingCitadelDesireHungry",
    "BuildingCitadelDesireSleep",
    "BuildingCitadelEgyptianAltar",
    "BuildingCitadelGreekAltar",
    "BuildingCitadelJapaneseAltar",
    "BuildingCitadelNorseAltar",
    "BuildingCitadelPopCounterBead",
    "BuildingCitadelTibetanAltar",
    "BuildingEgyptian1",
    "BuildingEgyptian1A",
    "BuildingEgyptian2",
    "BuildingEgyptian2A",
    "BuildingEgyptian3",
    "BuildingEgyptian4",
    "BuildingEgyptian5",
    "BuildingEgyptian5A",
    "BuildingEgyptianBarrel",
    "BuildingEgyptianCart",
    "BuildingEgyptianCreche",
    "BuildingEgyptianGraveyard",
    "BuildingEgyptianNeedle",
    "BuildingEgyptianPotA",
    "BuildingEgyptianPotB",
    "BuildingEgyptianTotem",
    "BuildingEgyptianWell",
    "BuildingEgyptianWindmill",
    "BuildingEgyptianWonder",
    "BuildingEgyptianWorkshop",
    "BuildingGreek1",
    "BuildingGreek2",
    "BuildingGreek2A",
    "BuildingGreek3",
    "BuildingGreek4",
    "BuildingGreek5",
    "BuildingGreek5A",
    "BuildingGreekCreche",
    "BuildingGreekGraveyard",
    "BuildingGreekSail",
    "BuildingGreekStatue",
    "BuildingGreekTotem",
    "BuildingGreekWonder",
    "BuildingGreekWorkshop",
    "BuildingJapanese1",
    "BuildingJapanese2",
    "BuildingJapanese3",
    "BuildingJapanese4",
    "BuildingJapanese5",
    "BuildingJapaneseCreche",
    "BuildingJapaneseGraveyard",
    "BuildingJapaneseTotem",
    "BuildingJapaneseWonder",
    "BuildingJapaneseWorkshop",
    "BuildingCampfire",
    "BuildingCreaturePenLesahPole",
    "BuildingFootballCentreCircle",
    "BuildingFootballCornerFlag",
    "BuildingFootballGoal",
    "BuildingFootballPitch",
    "BuildingFootballPitchBig",
    "BuildingMineEntrance",
    "BuildingPier",
    "BuildingScaffold01",
    "BuildingScaffold02",
    "BuildingScaffold03",
    "BuildingXandoBase",
    "BuildingXandoO",
    "BuildingXandoX",
    "PiperEntrancePhys1",
    "BuildingAmericanVillageCentre",
    "BuildingAztecVillageCentre",
    "BuildingCelticVillageCentre",
    "BuildingDesireFlagABODE",
    "BuildingDesireFlagCHILDREN",
    "BuildingDesireFlagCIVIC_BUILDING",
    "BuildingDesireFlagFOOD",
    "BuildingDesireFlagPLAYTIME",
    "BuildingDesireFlagPROTECTION",
    "BuildingDesireFlagRAIN",
    "BuildingDesireFlagSUN",
    "BuildingDesireFlagWood",
    "BuildingEgyptianVillageCentre",
    "BuildingGreekVillageCentre",
    "BuildingJapaneseVillageCentre",
    "BuildingNorseVillageCentre",
    "BuildingPlayerIcon01",
    "BuildingPlayerIcon01Plinth",
    "BuildingPlayerIconApe",
    "BuildingPlayerIconBear",
    "BuildingPlayerIconCow",
    "BuildingPlayerIconHorse",
    "BuildingPlayerIconLeopard",
    "BuildingPlayerIconLion",
    "BuildingPlayerIconPlinthAmerican",
    "BuildingPlayerIconPlinthAztec",
    "BuildingPlayerIconPlinthCeltic",
    "BuildingPlayerIconPlinthEgyptian",
    "BuildingPlayerIconPlinthGreek",
    "BuildingPlayerIconPlinthJapanese",
    "BuildingPlayerIconPlinthNorse",
    "BuildingPlayerIconPlinthTibetan",
    "BuildingPlayerIconPolarBear",
    "BuildingPlayerIconSheep",
    "BuildingPlayerIconTiger",
    "BuildingPlayerIconTortoise",
    "BuildingPlayerIconWolf",
    "BuildingPlayerIconZebra",
    "BuildingTibetanVillageCentre",
    "BuildingVillageCentreSpellHand",
    "BuildingNorse1",
    "BuildingNorse2",
    "BuildingNorse2A",
    "BuildingNorse3",
    "BuildingNorse3A",
    "BuildingNorse4",
    "BuildingNorse5",
    "BuildingNorseCreche",
    "BuildingNorseGate",
    "BuildingNorseGraveyard",
    "BuildingNorsePigPen",
    "BuildingNorseTemple",
    "BuildingNorseTotem",
    "BuildingNorseWonder",
    "BuildingNorseWorkshop",
    "NorseGatePhys1",
    "NorseGatePhys2",
    "BuildingAmericanStoragePit",
    "BuildingAztecStoragePit",
    "BuildingCelticStoragePit",
    "BuildingEgyptianStoragePit",
    "BuildingGrain",
    "BuildingGreekStoragePit",
    "BuildingJapaneseStoragePit",
    "BuildingNorseStoragePit",
    "BuildingTibetanStoragePit",
    "BuildingWood00",
    "BuildingWood01",
    "BuildingWood02",
    "BuildingWood03",
    "BuildingWood04",
    "BuildingWoodOutside",
    "BuildingTibetan1",
    "BuildingTibetan2",
    "BuildingTibetan3",
    "BuildingTibetan3A",
    "BuildingTibetan4",
    "BuildingTibetan5",
    "BuildingTibetan5A",
    "BuildingTibetanCreche",
    "BuildingTibetanGraveyard",
    "BuildingTibetanLargePillar",
    "BuildingTibetanMiniTemple",
    "BuildingTibetanTotem",
    "BuildingTibetanWonder",
    "BuildingTibetanWorkshop",
    "BuildingSpellHand",
    "BuildingWorshipGrain",
    "BuildingWorshipSite01Neutral",
    "Boulder1Chalk",
    "Boulder1Lime",
    "Boulder1Sand",
    "Boulder1Volcanic",
    "Boulder2Chalk",
    "Boulder2Lime",
    "Boulder2Sand",
    "Boulder2Volcanic",
    "Boulder3Chalk",
    "Boulder3Lime",
    "Boulder3Sand",
    "Boulder3Volcanic",
    "FatPilarChalk",
    "FatPilarLime",
    "FatPilarSand",
    "FatPilarVolcanic",
    "FeatureCreatureCave",
    "FeatureForest",
    "FeatureForest01",
    "FeatureForest02",
    "FeatureForest03",
    "FeatureForestBook01",
    "FeatureGiantSkeleton",
    "FeatureGiantSkull",
    "FeatureIdol",
    "FeaturePiperCave",
    "FeatureRib1",
    "FeatureRib2",
    "FeatureSpoutHole",
    "FeatureVertabrae",
    "Pilar2Chalk",
    "Pilar2Lime",
    "Pilar2Sand",
    "Pilar2Volcanic",
    "Pilar3Chalk",
    "Pilar3Lime",
    "Pilar3Sand",
    "Pilar3Volcanic",
    "PilarChalk",
    "PilarLime",
    "PilarSand",
    "PilarVolcanic",
    "Puzzle1",
    "Puzzle2",
    "Puzzle3",
    "Puzzle4",
    "Puzzle5",
    "SpikeyPilarChalk",
    "SpikeyPilarLime",
    "SpikeyPilarSand",
    "SpikeyPilarVolcanic",
    "Z_PhoneBox",
    "I_Blast",
    "I_Fireball",
    "I_Food",
    "I_Football",
    "I_Forest",
    "I_Heal",
    "I_Lightning",
    "I_Lightning2",
    "I_Miniscroll",
    "I_MiniscrollActive",
    "I_MiniscrollBronze",
    "I_MiniscrollBronzeActive",
    "I_MiniscrollGold",
    "I_MiniscrollGoldActive",
    "I_MiniscrollSilver",
    "I_MiniscrollSilverActive",
    "I_OfferingBedroll",
    "I_OfferingFertility",
    "I_OfferingFood",
    "I_OfferingPlay",
    "I_OfferingProtection",
    "I_OfferingSkull",
    "I_OfferingVillageImprove",
    "I_OfferingWater",
    "I_OfferingWood",
    "I_Priest",
    "I_Shield",
    "I_Skeleton",
    "I_SpellGem",
    "I_Trees",
    "I_Wall",
    "GateTotemPlinthePhys1",
    "GateTotemPlinthePhys2",
    "GateTotemPlinthePhys3",
    "ObjectArk",
    "ObjectArkDryDock",
    "ObjectArkWreck",
    "ObjectAxe",
    "ObjectBag",
    "ObjectBall",
    "ObjectBellTower",
    "ObjectBoxFrame",
    "ObjectBranchEvergreenInHand",
    "ObjectBranchFruitInHand",
    "ObjectBranchHardWoodInHand",
    "ObjectBurntTree",
    "ObjectCauldron",
    "ObjectChampi",
    "ObjectCreatureTurd",
    "ObjectCrook",
    "ObjectFishingRod",
    "ObjectFlatRockChalk",
    "ObjectFlatRockLimeStone",
    "ObjectFlatRockSandStone",
    "ObjectFlatRockVolcanic",
    "ObjectFlowerBed1",
    "ObjectFlowerBed2",
    "ObjectGateTotemApe",
    "ObjectGateTotemBlank",
    "ObjectGateTotemCow",
    "ObjectGateTotemPlinthe",
    "ObjectGateTotemTiger",
    "ObjectHammer",
    "ObjectInfoSign",
    "ObjectJapaneseStoneThing",
    "ObjectLargeFishDead",
    "ObjectLightBulb",
    "ObjectLogsInHand",
    "ObjectLongRockChalk",
    "ObjectLongRockLimeStone",
    "ObjectLongRockSandStone",
    "ObjectLongRockVolcanic",
    "ObjectMagicMushroom",
    "ObjectMalletHeavy",
    "ObjectRockChalk",
    "ObjectRockLimeStone",
    "ObjectRockSandStone",
    "ObjectRockVolcanic",
    "ObjectSaw",
    "ObjectScythe",
    "ObjectSharpRockChalk",
    "ObjectSharpRockLimeStone",
    "ObjectSharpRockSandStone",
    "ObjectSharpRockVolcanic",
    "ObjectSkullTotem",
    "ObjectSpade",
    "ObjectSquareRockChalk",
    "ObjectSquareRockLimeStone",
    "ObjectSquareRockSandStone",
    "ObjectSquareRockVolcanic",
    "ObjectTickertApe",
    "ObjectToadstool",
    "ObjectTombStone",
    "ObjectTownLight",
    "ObjectToyBall",
    "ObjectToyBowlingBall",
    "ObjectToyCuddly",
    "ObjectToyDice",
    "ObjectToySkittle",
    "ObjectWheatEnclosure",
    "ObjectWheatInHand",
    "ObjectWoodInHand",
    "RewardChestExplode",
    "SculptureInProgress",
    "SingingStoneCenter",
    "SingingStone",
    "IdolBuilder",
    "NewShaolin",
    "PersonAmericanFemaleA1",
    "PersonAmericanFemaleA2",
    "PersonAmericanFemaleA3",
    "PersonAmericanMaleA1",
    "PersonAmericanMaleA2",
    "PersonAmericanMaleA3",
    "PersonAnimalBreeder",
    "PersonAnimalTrainer",
    "PersonAztecFemaleA1",
    "PersonAztecFemaleA2",
    "PersonAztecFemaleA3",
    "PersonAztecLeader",
    "PersonAztecMaleA1",
    "PersonAztecMaleA2",
    "PersonAztecMaleA3",
    "PersonBandit",
    "PersonBoyBlack1",
    "PersonBoyBlack2",
    "PersonBoyBlack3",
    "PersonBoyOriental1",
    "PersonBoyOriental2",
    "PersonBoyOriental3",
    "PersonBoyTan1",
    "PersonBoyTan2",
    "PersonBoyTan3",
    "PersonBoyWhite",
    "PersonBoyWhite1",
    "PersonBoyWhite2",
    "PersonBoyWhite3",
    "PersonCelticFootballer",
    "PersonCelticFemaleA1",
    "PersonCelticFemaleA2",
    "PersonCelticFemaleA3",
    "PersonCelticMaleA1",
    "PersonCelticMaleA2",
    "PersonCelticMaleA3",
    "PersonCrusader",
    "PersonCultPriest",
    "PersonCultPriestess",
    "PersonEgyptianFemaleA1",
    "PersonEgyptianFemaleA2",
    "PersonEgyptianFemaleA3",
    "PersonEgyptianMaleA1",
    "PersonEgyptianMaleA2",
    "PersonEgyptianMaleA3",
    "PersonEgyptianMaleB1",
    "PersonEgyptianMaleB2",
    "PersonEngineer",
    "PersonGirlBlack1",
    "PersonGirlBlack2",
    "PersonGirlBlack3",
    "PersonGirlOriental1",
    "PersonGirlOriental2",
    "PersonGirlOriental3",
    "PersonGirlTan1",
    "PersonGirlTan2",
    "PersonGirlTan3",
    "PersonGirlWhite",
    "PersonGirlWhite1",
    "PersonGirlWhite2",
    "PersonGirlWhite3",
    "PersonGreekFemaleA1",
    "PersonGreekFemaleA2",
    "PersonGreekFemaleA3",
    "PersonGreekMaleA1",
    "PersonGreekMaleA2",
    "PersonGreekMaleA3",
    "PersonHermit",
    "PersonHippy",
    "PersonIdolBuilder",
    "PersonIntroFemale",
    "PersonIntroMale",
    "PersonJapaneseFemaleA2",
    "PersonJapaneseFemaleA3",
    "PersonJapaneseMaleA1",
    "PersonJapaneseMaleA2",
    "PersonJapaneseMaleA3",
    "PersonJapnFemaleA1",
    "PersonJapnFemaleA2",
    "PersonJapnFemaleA3",
    "PersonJapnMaleA1",
    "PersonJapnMaleA2",
    "PersonJapnMaleA3",
    "PersonNomad",
    "PersonNorseFootballer",
    "PersonNorseFemaleA1",
    "PersonNorseFemaleA2",
    "PersonNorseFemaleA3",
    "PersonNorseMaleA1",
    "PersonNorseMaleA2",
    "PersonNorseMaleA3",
    "PersonNorseSailor",
    "PersonPiedPiper",
    "PersonSailorAccordian",
    "PersonSculptor",
    "PersonShaolinMonk",
    "PersonShepard",
    "PersonSkeletonFemale",
    "PersonSkeletonMale",
    "PersonTibetanFemaleA2",
    "PersonTibetanFemaleA3",
    "PersonTibetanMaleA1",
    "PersonTibetanMaleA2",
    "PersonTibetanMaleA3",
    "PersonTibtFemaleA1",
    "PersonTibtFemaleA2",
    "PersonTibtFemaleA3",
    "PersonTibtMaleA1",
    "PersonTibtMaleA2",
    "PersonTibtMaleA3",
    "PersonTibtMaleB1",
    "PersonTibtMaleB2",
    "Creed",
    "SpellBlastCone",
    "SpellBlastCentre",
    "SpellBlastInner",
    "SpellBlastOuter",
    "SpellColumn",
    "SpellFireballTail",
    "SpellHealMesh",
    "SpellGrainPile",
    "SpellHornOfPlenty",
    "SpellPhile",
    "SpellPhileAngry",
    "SpellPhileBig",
    "SpellPhileFat",
    "SpellPhileFreeze",
    "SpellPhileFrighten",
    "SpellPhileHungry",
    "SpellPhileIll",
    "SpellPhileInvisible",
    "SpellPhileItchy",
    "SpellPhileLove",
    "SpellPhileSmall",
    "SpellPhileStrong",
    "SpellPhileThin",
    "SpellPhileThirsty",
    "SpellPhileTired",
    "SpellPhileWeak",
    "SpellRainCone",
    "SpellShieldMagicLowPoly",
    "SpellSolidShield",
    "SpellSpellBallSurface02",
    "SpellSkullIcon",
    "SpellSpellCreator",
    "SpellSpellDispenser",
    "SpellVortexCylinder",
    "SpellZCheatBox",
    "SpellPulseIn",
    "SpellPulseOut",
    "AnimalWorm",
    "BuildingDummyCitadel",
    "Z_AppleBarrel",
    "Z_Arrow",
    "Z_SpellRock01",
    "Z_SpellRock02",
    "TreeCopse",
    "TreeCopseA",
    "TreeBeech",
    "TreeBirch",
    "TreeBush",
    "TreeBushA",
    "TreeBushB",
    "TreeCedar",
    "TreeConifer",
    "TreeConiferA",
    "TreeCypress",
    "TreeCypressA",
    "TreeHedge",
    "TreeHedgeA",
    "TreeOak",
    "TreeOakA",
    "TreeOlive",
    "TreePalm",
    "TreePalmA",
    "TreePalmB",
    "TreePalmC",
    "TreePine",
    "TreeRice",
    "TreeRoots",
    "TreeRootsPile",
    "TreeWheat",
    "TreeWheatInField",
    "U_Axe",
    "U_Bag",
    "U_Ball",
    "U_Bench",
    "U_Bucket",
    "U_Bucket2",
    "U_Cart",
    "U_Chest",
    "U_ChestTop",
    "U_Crook",
    "U_FishingRod",
    "U_Frame",
    "U_FrameSkin",
    "U_Hammer",
    "U_MalletHeavy",
    "U_Saw",
    "U_Scythe",
    "U_Spade",
    "U_Stool",
    "U_Stool01",
    "U_Table",
    "U_Trough",
    "U_WashingLineAmerican",
    "U_WashingLineAztec",
    "U_WashingLineCeltic",
    "U_WashingLineEgyptian",
    "U_WashingLineGreek",
    "U_WashingLineJapanese",
    "U_WashingLineNorse",
    "U_WashingLineTibetan",
};
} // namespace openblack
