# [Go to ideas ➡️](https://github.com/open-source-ideas/ideas/issues)

#### 🥇 Open Source Ideas has proudly led to *11 projects* coming to fruition in a perfect harmony of talent and the open source spirit, and has *over 200  ideas* for those looking for a new project!

# 💡 Open Source Ideas

> For many working with Open Source, good ideas or cool projects aren't the limiting factor. Time is. But there are a lot of different people out there with various levels of experience and background. Some want to create open source projects, but don't know where to start or what to create. Why don't we solve both of these problems with each other's help? :bird: :chicken: :boom:

Welcome to Open Source Ideas! 👋 This is a crowdsourced collection of open source ideas you can take inspiration from, join, or encourage others to attempt! The community is fueled by the dedicated contributors like yourself, and each and every idea is greatly appreciated!

If you would like to take a look at the existing ideas, head on over to the [issues page](https://github.com/open-source-ideas/ideas/issues)! We've also labelled and tagged every issue to make it easier for people like yourself to find them!

<details>
  <summary>Tags and filters</summary>
  
:muscle: Want to put in a minimal effort? Or perhaps build a rocketship? Got little time? Got a lot of time? Filter by estimated workload here!
  
* [`Little work`](https://github.com/open-source-ideas/ideas/labels/Little%20work)
* [`Medium work`](https://github.com/open-source-ideas/ideas/labels/Medium%20work)
* [`Much work`](https://github.com/open-source-ideas/ideas/labels/Much%20work)

🧑‍💼 Are you just starting your programming carreer? Or are you taking a break from your senior backend developer position? Filter by difficulty?

* [`Beginner`](https://github.com/open-source-ideas/ideas/issues?q=is%3Aissue+is%3Aopen+label%3ABeginner)
* [`Intermediate`](https://github.com/open-source-ideas/ideas/issues?q=is%3Aissue+is%3Aopen+label%3AIntermediate)
* [`Advanced`](https://github.com/open-source-ideas/ideas/issues?q=is%3Aissue+is%3Aopen+label%3AAdvanced)

🧐 Are you a sucker for the grand Internet of Things? Or perhaps you want to whip out your favorite OCR library and recognise some L's? Check out all our available categories!

* [`Mobile app`](https://github.com/open-source-ideas/open-source-ideas/labels/Mobile%20app)
* [`IoT`](https://github.com/open-source-ideas/open-source-ideas/labels/IoT)
* [`Web app`](https://github.com/open-source-ideas/open-source-ideas/labels/Web%20app)
* [`Frontend/UI`](https://github.com/open-source-ideas/open-source-ideas/labels/Frontend%2FUI)
* [`AI/ML`](https://github.com/open-source-ideas/open-source-ideas/labels/AI%2FML)
* [`APIs/Backend`](https://github.com/open-source-ideas/open-source-ideas/labels/APIs%2FBackend)
* [`Voice Assistant`](https://github.com/open-source-ideas/open-source-ideas/labels/Voice%20assistant)
* [`Developer Tooling`](https://github.com/open-source-ideas/open-source-ideas/labels/Developer%20tooling)
* [`Extension/Plugin/Add-On`](https://github.com/open-source-ideas/open-source-ideas/labels/Extension%2FPlugin%2FAdd-on)
* [`Design/UX`](https://github.com/open-source-ideas/open-source-ideas/labels/Design%2FUX)
* [`AR/VR`](https://github.com/open-source-ideas/open-source-ideas/labels/AR%2FVR)
* [`Bots`](https://github.com/open-source-ideas/open-source-ideas/labels/Bots)
* [`Security`](https://github.com/open-source-ideas/open-source-ideas/labels/Security)
* [`Blockchain`](https://github.com/open-source-ideas/open-source-ideas/labels/Blockchain)
* [`Futuristic Tech/Something Unique`](https://github.com/open-source-ideas/open-source-ideas/labels/Futuristic%20tech%2FUnique%20ideas)
</details>

If you're curious what other projects have started from this community, [take a look at the _Hall of Fame_](#completed-hall-of-fame)!

----------------

**Let's show what open in Open Source means by creating a welcoming, inclusive and supportive community for all that want to be involved.** My hope is that we can get more people involved with Open Source, learning the customary behavior and continuing to drive the open community forward. [Read more about the initiative in the blog post](https://hackernoon.com/open-source-ideas-initiative-ca747121ac34).

This project adheres to the [Contributor Covenant code of conduct](./CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

### I've got an idea to share

If there is anyone with cool ideas for projects and doesn't have the time to create them, [post it as an issue](https://github.com/open-source-ideas/ideas/issues/new) on this repo, mark it with the appropriate label(s) and advertise it if you so please.

Try to include as much information as needed to implement the project, and be open to answering questions if necessary. Add a label to the project for whether it is estimated to be [`Little work`](https://github.com/open-source-ideas/ideas/labels/Little%20work), [`Medium work`](https://github.com/open-source-ideas/ideas/labels/Medium%20work) or [`Much work`](https://github.com/open-source-ideas/ideas/labels/Much%20work).
<br/>
Also, try to answer the issue template as correctly as possible. If the project is perfect for first-timers, label the issue as [`First Contribute`](https://github.com/open-source-ideas/ideas/labels/First%20Contribute).
<br/>
Finally, try to label the issue with the most appropriate tech categor(y|ies) to attract excited, motivated developers to your idea! (see list above)

### I want to create a project

If you are Open Source-curious or just looking for your next project, you can look through the Issue-list and pick one of your liking. If anything captures your imagination, you can join the issue by commenting on it. If there are people who want to cooperate, that's fantastic. Just submit a comment and the person who created the issue can answer.

Feel free to keep the issue updated with the progress of the project and ask for help if needed. When the project is finished/published, add a link to the published project and the issue can be closed (and you & your teammates will make the Completed Hall of Fame below!)

### If it already exists

As is often the case with Open Source, a project already exists, but people aren't aware that it does. If there are any issues opened that already exist in the real world, let us know and the issue will be closed (with a link to the existing project for people to use).

---

# Completed Hall of Fame
### [HamzaEzzRa/Multishot](https://github.com/HamzaEzzRa/Multishot)
- :white_check_mark: Completed by [@HamzaEzzRa](https://github.com/HamzaEzzRa)
- :heart: Pitched in [issue #234](https://github.com/open-source-ideas/open-source-ideas/issues/234) by [@AdrienDS](https://github.com/AdrienDS)

### [roymoran/page](https://github.com/roymoran/page)

- :white_check_mark: Completed by [@roymoran](https://github.com/roymoran)
- :heart: Pitched in [issue #271](https://github.com/open-source-ideas/open-source-ideas/issues/271) by [@roymoran](https://github.com/roymoran)
- :rocket: Website [pagecli.com](https://pagecli.com)
### [AmruthPillai/All-The-Words-That-I-Know](https://github.com/AmruthPillai/All-The-Words-That-I-Know)

- :white_check_mark: Completed by [@AmruthPillai](https://github.com/AmruthPillai)
- :heart: Pitched in [issue #204](https://github.com/open-source-ideas/open-source-ideas/issues/204) by [@xenotropic](https://github.com/xenotropic)

### [azz-eddine/nws_webapp](https://github.com/azz-eddine/nws_webapp)

- :white_check_mark: Completed by [@azz-eddine](https://github.com/azz-eddine)
- :heart: Pitched in [issue #74](https://github.com/open-source-ideas/open-source-ideas/issues/74) by [@xenotropic](https://github.com/xenotropic)
- :rocket: Website [nws.overnightproject.com/](http://nws.overnightproject.com/)

### [projectunic0rn/pub](https://github.com/projectunic0rn/pub)

- :white_check_mark: Completed by [@rmjordas](https://github.com/rmjordas), [@rickywid](https://github.com/rickywid), [@aaron2212](https://github.com/aaron2212), [@roymoran](https://github.com/roymoran)
- :heart: Pitched in [issue #195](https://github.com/open-source-ideas/open-source-ideas/issues/195) by [@roymoran](https://github.com/roymoran)
- :rocket: Website [projectunicorn.net](https://projectunicorn.net)

### [fredrikaugust/bulk-renamer](https://github.com/FredrikAugust/bulk-renamer)

- :white_check_mark: Completed by [@fredrikaugust](https://github.com/fredrikaugust)
- :heart: Pitched in [issue #149](https://github.com/open-source-ideas/open-source-ideas/issues/149) by [@KOLANICH](https://github.com/KOLANICH)

### [bsonntag/npm-notifier](https://github.com/bsonntag/npm-notifier)

- :white_check_mark: Completed by [@bsonntag](https://github.com/bsonntag)
- :heart: Pitched in [issue #6](https://github.com/mikaelbr/open-source-ideas/issues/6) by [@mikaelbr](https://github.com/mikaelbr)

###  [twobucks/slack-message](https://github.com/twobucks/slack-message)

- :white_check_mark: Completed by [@dinodsaurus](https://github.com/dinodsaurus)
- :heart: Pitched in [issue #2](https://github.com/mikaelbr/open-source-ideas/issues/2) by [@mikaelbr](https://github.com/mikaelbr)

###  [kencrocken/FiraCodeiScript](https://github.com/kencrocken/FiraCodeiScript)

- :white_check_mark: Completed by [@kencrocken](https://github.com/kencrocken)
- :heart: Pitched in [issue #10](https://github.com/open-source-ideas/open-source-ideas/issues/10) by [@mikaelbr](https://github.com/mikaelbr)

###  [mikaelbr/open-source-ideas](https://github.com/mikaelbr/open-source-ideas)

- :white_check_mark: Completed by [@FredrikAugust](https://github.com/FredrikAugust)
- :heart: Pitched in [issue #1](https://github.com/mikaelbr/open-source-ideas/issues/1) by [@mikaelbr](https://github.com/mikaelbr)
