# `cuBLAS Migration` Sample

The `cuBLAS Migration` sample is a collection of code samples that demonstrate the cuBLAS equivalent in Intel® oneAPI Math Kernel Library (oneMKL). 

| Area                   | Description
|:---                    |:---
| What you will learn    | How to begin migrating CUDA code to a SYCL*-compliant equivalent
| Time to complete       | 90 minutes
| Category               | Code Optimization

For more information on oneMKL and complete documentation of all oneMKL routines, see https://www.intel.com/content/www/us/en/developer/tools/oneapi/onemkl-documentation.html.

## Purpose

The samples source code using SYCL were migrated from CUDA source code for offloading computations to a GPU/CPU. The sample demonstrates how to migrate code to SYCL, optimize the migration steps, and improve processing time.

Each of the cuBLAS samples source files shows the usage of oneMKL cuBLAS routines. All are basic programs containing the usage of a single function.

>**Note**: This sample is based on the [*cuBLAS Library - APIs Examples*](https://github.com/NVIDIA/CUDALibrarySamples/tree/master/cuBLAS) samples in the NVIDIA/CUDALibrary GitHub repository.

## Prerequisites

| Optimized for         | Description
|:---                   |:---
| OS                    | Ubuntu* 20.04 <br> Windows 10, 11
| Hardware              | 10th Gen Intel® processors or newer
| Software              | Intel® oneAPI DPC++/C++ Compiler

## Key Implementation Details

This sample contains two sets of sources in the following folders:

| Folder Name             | Description
|:---                     |:---
| `01_sycl_dpct_output`   | Contains output of Intel® DPC++ Compatibility Tool used to migrate SYCL-compliant code from CUDA code. <br> This SYCL code has some unmigrated or incorrectly generated code that has to be manually fixed before it is functional. (The code does not work as supplied.)
| `02_sycl_dpct_migrated` | Contains CUDA to SYCL migrated code generated by using the Intel® DPC++ Compatibility Tool with the manual changes implemented to make the code fully functional.

These functions are classified into three levels of difficulty. There are **52** samples:

- **14** Level 1 samples
- **23** Level 2 samples
- **15** Level 3 samples

## Set Environment Variables

When working with the command-line interface (CLI), you should configure the oneAPI toolkits using environment variables. Set up your CLI environment by sourcing the `setvars` script every time you open a new terminal window. This practice ensures that your compiler, libraries, and tools are ready for development.

## Build the `cuBLAS Migration` Sample

> **Note**: If you have not already done so, set up your CLI
> environment by sourcing  the `setvars` script in the root of your oneAPI installation.
>
> Linux*:
> - For system wide installations: `. /opt/intel/oneapi/setvars.sh`
> - For private installations: ` . ~/intel/oneapi/setvars.sh`
> - For non-POSIX shells, like csh, use the following command: `bash -c 'source <install-dir>/setvars.sh ; exec csh'`
>
> Windows*:
> - `C:\"Program Files (x86)"\Intel\oneAPI\setvars.bat`
> - Windows PowerShell*, use the following command: `cmd.exe "/K" '"C:\Program Files (x86)\Intel\oneAPI\setvars.bat" && powershell'`
>
> For more information on configuring environment variables, see *[Use the setvars Script with Linux* or macOS*](https://www.intel.com/content/www/us/en/develop/documentation/oneapi-programming-guide/top/oneapi-development-environment-setup/use-the-setvars-script-with-linux-or-macos.html)*.

### On Linux*

1. Change to the sample directory.
2. Build the samples.
   ```
   $ mkdir build
   $ cd build
   $ cmake ..
   $ make
   ```

   By default, this command sequence builds the version of the source code in the  `02_sycl_dpct_migrated` folder.

### On a Windows* System

Open "Intel oneAPI command prompt for Intel 64 for Visual Studio 2017" or
"Intel oneAPI command prompt for Intel 64 for Visual Studio 2019" and perform the following steps:

#### Microsoft Visual Studio Compiler

##### 1. Setup oneAPI development environment
```
C:\Program Files (x86)\Intel\oneAPI\setvars.bat
```
##### 2. Build the program using `cmake`
```
mkdir build
cd build
cmake -G "Visual Studio 16 2019" ..
cmake --build .
```

#### Troubleshooting

If an error occurs, you can get more details by running `make` with
the `VERBOSE=1` argument:
```
make VERBOSE=1
```
If you receive an error message, troubleshoot the problem using the **Diagnostics Utility for Intel® oneAPI Toolkits**. The diagnostic utility provides configuration and system checks to help find missing dependencies, permissions errors, and other issues. See the [Diagnostics Utility for Intel® oneAPI Toolkits User Guide](https://www.intel.com/content/www/us/en/develop/documentation/diagnostic-utility-user-guide/top.html) for more information on using the utility.


## Run the `cuBLAS Migration` Sample

### On Linux

Run the programs on a CPU or GPU. Each sample uses a default device, which in most cases is a GPU.

> **Note**: The code runs on a CPU by default
> If the user wants to run it on a compatible GPU,
> he has to comment/uncomment the device selection
> line in the code.


1. Run the samples in the `build` folder.
   ```
   make run_amax
   ```

## Example Output

This is example output if you built the default and ran `run_amax`.

```
[  0%] Building CXX object 02_sycl_dpct_migrated/Level-1/CMakeFiles/amax.dir/amax.cpp.o
[100%] Linking CXX executable amax
[100%] Built target amax
A
1.00 2.00 3.00 4.00 
=====
result
4
=====
[100%] Built target run_amax
```

## License

Code samples are licensed under the MIT license. See
[License.txt](https://github.com/oneapi-src/oneAPI-samples/blob/master/License.txt) for details.

Third party program licenses are at [third-party-programs.txt](https://github.com/oneapi-src/oneAPI-samples/blob/master/third-party-programs.txt).
