# TCL File Generated by Component Editor 23.2
# Tue Dec 12 06:40:33 PST 2023
# DO NOT MODIFY


# 
# oneapi_avs_to_axs_pixel_gasket "oneAPI Avalon Streaming to AXI4 Streaming Pixel Gasket" v0.2
# Intel 2023.12.12.06:40:33
# Allow a oneAPI IP to connect to an Intel Streaming Video AXI4 Streaming interface
# 

# 
# request TCL package from ACDS 23.2
# 
package require -exact qsys 23.2

proc ld x {
    expr {log($x)/[expr log(2)]}
}

proc elaboration_cb {} {
set param_parallelPixels [get_parameter_value PARALLEL_PIXELS]
set param_bitsPerChannel [get_parameter_value BITS_PER_CHANNEL]
set param_channels [get_parameter_value CHANNELS]

set bitsPerChannelAv [expr {1 << int(ceil([ld $param_bitsPerChannel]))}]
set bitsPerPixelAv [expr {$bitsPerChannelAv * $param_channels}]
set bitsAv [expr {$bitsPerPixelAv * $param_parallelPixels}]
set emptyBits [expr int(ceil([ld [expr $bitsAv / 8.0]]))]
set bitsPerChannelAxi [expr {$param_bitsPerChannel}]
set bitsPerPixelAxi [expr 8 * int(($param_channels * $bitsPerChannelAxi + 7) / 8.0)]
set bitsAxi [expr {$bitsPerPixelAxi * $param_parallelPixels}]
set tUserBits [expr {int(($bitsAxi + 7) / 8)}]
set tUserFill [expr {$tUserBits - 2}]
set maskOut [expr [expr 1 << [expr $bitsPerChannelAxi]] - 1]

puts "BITS_PER_CHANNEL_AV $bitsPerChannelAv"
puts "BITS_PER_PIXEL_AV $bitsPerPixelAv"
puts "BITS_AV $bitsAv"
puts "EMPTY_BITS $emptyBits"
puts "BITS_PER_CHANNEL_AXI $bitsPerChannelAxi"
puts "BITS_PER_PIXEL_AXI $bitsPerPixelAxi"
puts "BITS_AXI $bitsAxi"
puts "TUSER_BITS $tUserBits"
puts "TUSER_FILL $tUserFill"
puts [format "MASK_OUT %1x" $maskOut]

set_parameter_value BITS_PER_CHANNEL_AV $bitsPerChannelAv
set_parameter_value BITS_PER_PIXEL_AV $bitsPerPixelAv
set_parameter_value BITS_AV $bitsAv
set_parameter_value EMPTY_BITS $emptyBits
set_parameter_value BITS_PER_CHANNEL_AXI $bitsPerChannelAxi
set_parameter_value BITS_PER_PIXEL_AXI $bitsPerPixelAxi
set_parameter_value BITS_AXI $bitsAxi
set_parameter_value TUSER_BITS $tUserBits
set_parameter_value TUSER_FILL $tUserFill
set_parameter_value MASK_OUT $maskOut

set showDerivedParameters [get_parameter_value SHOW_DERIVED_PARAMETERS]
set_parameter_property BITS_PER_CHANNEL_AV  VISIBLE $showDerivedParameters
set_parameter_property BITS_PER_PIXEL_AV    VISIBLE $showDerivedParameters
set_parameter_property BITS_AV              VISIBLE $showDerivedParameters
set_parameter_property EMPTY_BITS           VISIBLE $showDerivedParameters
set_parameter_property BITS_PER_CHANNEL_AXI VISIBLE $showDerivedParameters
set_parameter_property BITS_PER_PIXEL_AXI   VISIBLE $showDerivedParameters
set_parameter_property BITS_AXI             VISIBLE $showDerivedParameters
set_parameter_property TUSER_BITS           VISIBLE $showDerivedParameters
set_parameter_property TUSER_FILL           VISIBLE $showDerivedParameters
set_parameter_property MASK_OUT             VISIBLE $showDerivedParameters

}


# 
# module oneapi_avs_to_axs_pixel_gasket
# 
set_module_property DESCRIPTION "Allow a oneAPI IP to connect to an Intel Streaming Video AXI4 Streaming interface"
set_module_property NAME oneapi_avs_to_axs_pixel_gasket
set_module_property VERSION 0.3
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property GROUP oneAPI
set_module_property AUTHOR Intel
set_module_property DISPLAY_NAME "oneAPI Avalon Streaming to AXI4 Streaming Pixel Gasket"
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property REPORT_HIERARCHY false
set_module_property LOAD_ELABORATION_LIMIT 0
set_module_property PRE_COMP_MODULE_ENABLED false
set_module_property ELABORATION_CALLBACK elaboration_cb


# 
# file sets
# 
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL oneapi_avs_to_axs_pixel_gasket
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property QUARTUS_SYNTH ENABLE_FILE_OVERWRITE_MODE false
add_fileset_file oneapi_avs_to_axs_pixel_gasket.sv SYSTEM_VERILOG PATH oneapi_avs_to_axs_pixel_gasket.sv TOP_LEVEL_FILE


# 
# parameters
# 
add_parameter PARALLEL_PIXELS INTEGER
set_parameter_property PARALLEL_PIXELS DEFAULT_VALUE 1
set_parameter_property PARALLEL_PIXELS DISPLAY_NAME "Parallel Pixels"
set_parameter_property PARALLEL_PIXELS WIDTH ""
set_parameter_property PARALLEL_PIXELS UNITS None
set_parameter_property PARALLEL_PIXELS ALLOWED_RANGES 1:8
set_parameter_property PARALLEL_PIXELS DESCRIPTION "The number of pixels that are processed in a single streaming transaction. "
set_parameter_property PARALLEL_PIXELS AFFECTS_GENERATION false
set_parameter_property PARALLEL_PIXELS HDL_PARAMETER true
set_parameter_property PARALLEL_PIXELS EXPORT true
add_parameter CHANNELS INTEGER 
set_parameter_property CHANNELS DEFAULT_VALUE 3
set_parameter_property CHANNELS DISPLAY_NAME "Color Channels"
set_parameter_property CHANNELS WIDTH ""
set_parameter_property CHANNELS UNITS None
set_parameter_property CHANNELS ALLOWED_RANGES 1:8
set_parameter_property CHANNELS DESCRIPTION "The number of color channels in each pixel. For example, an RGB pixel would have 3 channels. "
set_parameter_property CHANNELS AFFECTS_GENERATION false
set_parameter_property CHANNELS HDL_PARAMETER true
set_parameter_property CHANNELS EXPORT true
add_parameter BITS_PER_CHANNEL INTEGER
set_parameter_property BITS_PER_CHANNEL DEFAULT_VALUE 8
set_parameter_property BITS_PER_CHANNEL DISPLAY_NAME "Bits per Channel"
set_parameter_property BITS_PER_CHANNEL WIDTH ""
set_parameter_property BITS_PER_CHANNEL UNITS Bits
set_parameter_property BITS_PER_CHANNEL ALLOWED_RANGES 1:64
set_parameter_property BITS_PER_CHANNEL DESCRIPTION "The number of bits in each color channel on the AXI4-S interface. Padding bits will be added to each channel of the Avalon Streaming interface to adapt to limitations in the oneAPI compiler. "
set_parameter_property BITS_PER_CHANNEL AFFECTS_GENERATION false
set_parameter_property BITS_PER_CHANNEL HDL_PARAMETER true
set_parameter_property BITS_PER_CHANNEL EXPORT true
add_parameter SHOW_DERIVED_PARAMETERS BOOLEAN false "Display derived parameters in GUI"
set_parameter_property SHOW_DERIVED_PARAMETERS DISPLAY_NAME "Show Derived Parameters"
set_parameter_property SHOW_DERIVED_PARAMETERS AFFECTS_GENERATION false
set_parameter_property SHOW_DERIVED_PARAMETERS DISPLAY_HINT boolean

add_parameter BITS_PER_CHANNEL_AV INTEGER
set_parameter_property BITS_PER_CHANNEL_AV DERIVED true
set_parameter_property BITS_PER_CHANNEL_AV DEFAULT_VALUE 8
set_parameter_property BITS_PER_CHANNEL_AV DISPLAY_NAME BITS_PER_CHANNEL_AV
set_parameter_property BITS_PER_CHANNEL_AV WIDTH ""
set_parameter_property BITS_PER_CHANNEL_AV ENABLED false
set_parameter_property BITS_PER_CHANNEL_AV UNITS None
set_parameter_property BITS_PER_CHANNEL_AV ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_PER_CHANNEL_AV DESCRIPTION ""
set_parameter_property BITS_PER_CHANNEL_AV AFFECTS_GENERATION false
set_parameter_property BITS_PER_CHANNEL_AV HDL_PARAMETER true
set_parameter_property BITS_PER_CHANNEL_AV EXPORT true
add_parameter BITS_PER_PIXEL_AV INTEGER
set_parameter_property BITS_PER_PIXEL_AV DERIVED true
set_parameter_property BITS_PER_PIXEL_AV DEFAULT_VALUE 24
set_parameter_property BITS_PER_PIXEL_AV DISPLAY_NAME BITS_PER_PIXEL_AV
set_parameter_property BITS_PER_PIXEL_AV WIDTH ""
set_parameter_property BITS_PER_PIXEL_AV ENABLED false
set_parameter_property BITS_PER_PIXEL_AV UNITS None
set_parameter_property BITS_PER_PIXEL_AV ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_PER_PIXEL_AV DESCRIPTION ""
set_parameter_property BITS_PER_PIXEL_AV AFFECTS_GENERATION false
set_parameter_property BITS_PER_PIXEL_AV HDL_PARAMETER true
set_parameter_property BITS_PER_PIXEL_AV EXPORT true
add_parameter BITS_AV INTEGER
set_parameter_property BITS_AV DERIVED true
set_parameter_property BITS_AV DEFAULT_VALUE 24
set_parameter_property BITS_AV DISPLAY_NAME BITS_AV
set_parameter_property BITS_AV WIDTH ""
set_parameter_property BITS_AV ENABLED false
set_parameter_property BITS_AV UNITS None
set_parameter_property BITS_AV ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_AV DESCRIPTION ""
set_parameter_property BITS_AV AFFECTS_GENERATION false
set_parameter_property BITS_AV HDL_PARAMETER true
set_parameter_property BITS_AV EXPORT true
add_parameter EMPTY_BITS INTEGER
set_parameter_property EMPTY_BITS DERIVED true
set_parameter_property EMPTY_BITS DEFAULT_VALUE 2
set_parameter_property EMPTY_BITS DISPLAY_NAME EMPTY_BITS
set_parameter_property EMPTY_BITS WIDTH ""
set_parameter_property EMPTY_BITS ENABLED false
set_parameter_property EMPTY_BITS UNITS None
set_parameter_property EMPTY_BITS ALLOWED_RANGES -2147483648:2147483647
set_parameter_property EMPTY_BITS DESCRIPTION ""
set_parameter_property EMPTY_BITS AFFECTS_GENERATION false
set_parameter_property EMPTY_BITS HDL_PARAMETER true
set_parameter_property EMPTY_BITS EXPORT true
add_parameter BITS_PER_CHANNEL_AXI INTEGER
set_parameter_property BITS_PER_CHANNEL_AXI DERIVED true
set_parameter_property BITS_PER_CHANNEL_AXI DEFAULT_VALUE 8
set_parameter_property BITS_PER_CHANNEL_AXI DISPLAY_NAME BITS_PER_CHANNEL_AXI
set_parameter_property BITS_PER_CHANNEL_AXI WIDTH ""
set_parameter_property BITS_PER_CHANNEL_AXI ENABLED false
set_parameter_property BITS_PER_CHANNEL_AXI UNITS None
set_parameter_property BITS_PER_CHANNEL_AXI ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_PER_CHANNEL_AXI DESCRIPTION ""
set_parameter_property BITS_PER_CHANNEL_AXI AFFECTS_GENERATION false
set_parameter_property BITS_PER_CHANNEL_AXI HDL_PARAMETER true
set_parameter_property BITS_PER_CHANNEL_AXI EXPORT true
add_parameter BITS_PER_PIXEL_AXI INTEGER
set_parameter_property BITS_PER_PIXEL_AXI DERIVED true
set_parameter_property BITS_PER_PIXEL_AXI DEFAULT_VALUE 24
set_parameter_property BITS_PER_PIXEL_AXI DISPLAY_NAME BITS_PER_PIXEL_AXI
set_parameter_property BITS_PER_PIXEL_AXI WIDTH ""
set_parameter_property BITS_PER_PIXEL_AXI ENABLED false
set_parameter_property BITS_PER_PIXEL_AXI UNITS None
set_parameter_property BITS_PER_PIXEL_AXI ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_PER_PIXEL_AXI DESCRIPTION ""
set_parameter_property BITS_PER_PIXEL_AXI AFFECTS_GENERATION false
set_parameter_property BITS_PER_PIXEL_AXI HDL_PARAMETER true
set_parameter_property BITS_PER_PIXEL_AXI EXPORT true
add_parameter BITS_AXI INTEGER
set_parameter_property BITS_AXI DERIVED true
set_parameter_property BITS_AXI DEFAULT_VALUE 24
set_parameter_property BITS_AXI DISPLAY_NAME BITS_AXI
set_parameter_property BITS_AXI WIDTH ""
set_parameter_property BITS_AXI ENABLED false
set_parameter_property BITS_AXI UNITS None
set_parameter_property BITS_AXI ALLOWED_RANGES -2147483648:2147483647
set_parameter_property BITS_AXI DESCRIPTION ""
set_parameter_property BITS_AXI AFFECTS_GENERATION false
set_parameter_property BITS_AXI HDL_PARAMETER true
set_parameter_property BITS_AXI EXPORT true
add_parameter TUSER_BITS INTEGER
set_parameter_property TUSER_BITS DERIVED true
set_parameter_property TUSER_BITS DEFAULT_VALUE 3
set_parameter_property TUSER_BITS DISPLAY_NAME TUSER_BITS
set_parameter_property TUSER_BITS WIDTH ""
set_parameter_property TUSER_BITS ENABLED false
set_parameter_property TUSER_BITS UNITS None
set_parameter_property TUSER_BITS ALLOWED_RANGES -2147483648:2147483647
set_parameter_property TUSER_BITS DESCRIPTION ""
set_parameter_property TUSER_BITS AFFECTS_GENERATION false
set_parameter_property TUSER_BITS HDL_PARAMETER true
set_parameter_property TUSER_BITS EXPORT true
add_parameter TUSER_FILL INTEGER
set_parameter_property TUSER_FILL DERIVED true
set_parameter_property TUSER_FILL DEFAULT_VALUE 1
set_parameter_property TUSER_FILL DISPLAY_NAME TUSER_FILL
set_parameter_property TUSER_FILL WIDTH ""
set_parameter_property TUSER_FILL ENABLED false
set_parameter_property TUSER_FILL UNITS None
set_parameter_property TUSER_FILL ALLOWED_RANGES -2147483648:2147483647
set_parameter_property TUSER_FILL DESCRIPTION ""
set_parameter_property TUSER_FILL AFFECTS_GENERATION false
set_parameter_property TUSER_FILL HDL_PARAMETER true
set_parameter_property TUSER_FILL EXPORT true
add_parameter MASK_OUT INTEGER
set_parameter_property MASK_OUT DERIVED true
set_parameter_property MASK_OUT DEFAULT_VALUE 16777215
set_parameter_property MASK_OUT DISPLAY_NAME MASK_OUT
set_parameter_property MASK_OUT WIDTH ""
set_parameter_property MASK_OUT ENABLED false
set_parameter_property MASK_OUT UNITS None
set_parameter_property MASK_OUT ALLOWED_RANGES -2147483648:2147483647
set_parameter_property MASK_OUT DESCRIPTION ""
set_parameter_property MASK_OUT AFFECTS_GENERATION false
set_parameter_property MASK_OUT HDL_PARAMETER true
set_parameter_property MASK_OUT EXPORT true
set_parameter_property MASK_OUT DISPLAY_HINT hexadecimal


# 
# display items
# 


# 
# connection point clock
# 
add_interface clock clock end
set_interface_property clock ENABLED true
set_interface_property clock EXPORT_OF ""
set_interface_property clock PORT_NAME_MAP ""
set_interface_property clock CMSIS_SVD_VARIABLES ""
set_interface_property clock SVD_ADDRESS_GROUP ""
set_interface_property clock IPXACT_REGISTER_MAP_VARIABLES ""
set_interface_property clock SV_INTERFACE_TYPE ""
set_interface_property clock SV_INTERFACE_MODPORT_TYPE ""

add_interface_port clock csi_clk clk Input 1


# 
# connection point reset
# 
add_interface reset reset end
set_interface_property reset associatedClock clock
set_interface_property reset synchronousEdges DEASSERT
set_interface_property reset ENABLED true
set_interface_property reset EXPORT_OF ""
set_interface_property reset PORT_NAME_MAP ""
set_interface_property reset CMSIS_SVD_VARIABLES ""
set_interface_property reset SVD_ADDRESS_GROUP ""
set_interface_property reset IPXACT_REGISTER_MAP_VARIABLES ""
set_interface_property reset SV_INTERFACE_TYPE ""
set_interface_property reset SV_INTERFACE_MODPORT_TYPE ""

add_interface_port reset rsi_reset_n reset_n Input 1


# 
# connection point avalon_streaming_sink
# 
add_interface avalon_streaming_sink avalon_streaming end
set_interface_property avalon_streaming_sink associatedClock clock
set_interface_property avalon_streaming_sink associatedReset reset
set_interface_property avalon_streaming_sink dataBitsPerSymbol 8
set_interface_property avalon_streaming_sink errorDescriptor ""
set_interface_property avalon_streaming_sink firstSymbolInHighOrderBits true
set_interface_property avalon_streaming_sink maxChannel 0
set_interface_property avalon_streaming_sink readyAllowance 0
set_interface_property avalon_streaming_sink readyLatency 0
set_interface_property avalon_streaming_sink ENABLED true
set_interface_property avalon_streaming_sink EXPORT_OF ""
set_interface_property avalon_streaming_sink PORT_NAME_MAP ""
set_interface_property avalon_streaming_sink CMSIS_SVD_VARIABLES ""
set_interface_property avalon_streaming_sink SVD_ADDRESS_GROUP ""
set_interface_property avalon_streaming_sink IPXACT_REGISTER_MAP_VARIABLES ""
set_interface_property avalon_streaming_sink SV_INTERFACE_TYPE ""
set_interface_property avalon_streaming_sink SV_INTERFACE_MODPORT_TYPE ""

add_interface_port avalon_streaming_sink asi_ready ready Output 1
add_interface_port avalon_streaming_sink asi_valid valid Input 1
add_interface_port avalon_streaming_sink asi_data data Input "((BITS_AV - 1)) - (0) + 1"
add_interface_port avalon_streaming_sink asi_startofpacket startofpacket Input 1
add_interface_port avalon_streaming_sink asi_endofpacket endofpacket Input 1
add_interface_port avalon_streaming_sink asi_empty empty Input "((EMPTY_BITS - 1)) - (0) + 1"


# 
# connection point axi4stream_transmitter
# 
add_interface axi4stream_transmitter axi4stream start
set_interface_property axi4stream_transmitter associatedClock clock
set_interface_property axi4stream_transmitter associatedReset reset
set_interface_property axi4stream_transmitter ENABLED true
set_interface_property axi4stream_transmitter EXPORT_OF ""
set_interface_property axi4stream_transmitter PORT_NAME_MAP ""
set_interface_property axi4stream_transmitter CMSIS_SVD_VARIABLES ""
set_interface_property axi4stream_transmitter SVD_ADDRESS_GROUP ""
set_interface_property axi4stream_transmitter IPXACT_REGISTER_MAP_VARIABLES ""
set_interface_property axi4stream_transmitter SV_INTERFACE_TYPE ""
set_interface_property axi4stream_transmitter SV_INTERFACE_MODPORT_TYPE ""

add_interface_port axi4stream_transmitter axm_tready tready Input 1
add_interface_port axi4stream_transmitter axm_tvalid tvalid Output 1
add_interface_port axi4stream_transmitter axm_tdata tdata Output "((BITS_AXI - 1)) - (0) + 1"
add_interface_port axi4stream_transmitter axm_tlast tlast Output 1
add_interface_port axi4stream_transmitter axm_tuser tuser Output "((TUSER_BITS - 1)) - (0) + 1"
