

Unzip the package we get these three files.

``` bash
files.zip  __MACOSX  malware.py
```


In ``files.zip`` are four files with name endswith ``enc``

```bash
CTF-favicon.png.enc  flag.txt.enc  malware.py.enc  shopping_list.txt.enc
```

AES CTR encryption take key and iv to create keystream, ``xor`` on keystream and plaintext to generate cipher text. So we can ``xor`` cipher text(``malware.py.enc``) and plain text(``malware.py``) to get keystream. Once we have the keystream, to get plain text flag we need to ``xor`` the encrypted flag (``flag.txt.enc``) with it.


The encryption script use ``16`` bytes for one block, so we need to truncated cipher text and plain text into list of ``16`` byte blocks.


```python
    src = [src[i:i+16] for i in range(0, len(src), 16)]
    enc = [enc[i:i+16] for i in range(0, len(enc), 16)]
    enc_flag = [enc_flag[i:i+16] for i in range(0, len(enc_flag), 16)]
```


The ``iv`` used to create each encrypted file is increamented by one for each file, so lets say the initial value for counter is ``v``, the ``jth`` file listed after ``malware.py`` would be using ``v+j`` for encryption.

As the exact order of the four files being listed is not given, we could brute-force from 1 through 3. ``flag.txt.enc`` is 38, so it needs 3 (round up ``38/16``) blocks.

```bash
$ wc flag.txt.enc
 0  2 38 flag.txt.enc
```

Sum this up to have the following loop to output the flag.

```python
    for i in range(1, 4):
        flag = []
        for j in range(3):
            k = [x^y for x,y in zip(src[i+j], enc[i+j])]
            flag.extend([x^y for x,y in zip(enc_flag[j], k)])
        print(bytes(flag))
```

