#!/usr/bin/env python3
from Crypto.Util.number import *

p = 10782851882643568436690840861500470716392138950798808847901800880356088489358510127370728036479767973147003063168467186230765513438172292951359505497400115
q = 156706242812597368863822639576094365104687347205289704754937898429597824385199919052246554900504787988024439652223718201546746425116946202916886816790677
n = 20478919136950514294245372495162786227530374921935352984649681539174637614643555669008696530509252361041808530044811858058082236333967101803171893140577890580969033423481448289254067496901793538675705761458273359594646496576699260837347827885664785268524982706033238656594857347183110547622966141595910495419030633639738370191942836112347256795752107944630943134049527588823032184661809251580638724245630054912896260630873396364113961677176216533916990437967650967366883162620646560056820169862154955001597314689326441684678064934393012107591102558185875890938130348512800056137808443281706098125326248383526374158851
e = 65537

cipher = 19386365681911176116962673929966212779218446893629616096165535479988405148285413619761557889189211704676408056225729231312267774666516067344628902420462860500796694348719854753450503310214423075716290790730397428257808016249943644108687242803494660111203848028946883397960407526446222857172233473980414880412616288479351174943750112131566288658840674793729931330990659775746679427920973741044231239820653713719744056152497641552948891194509604049453065742204369183052918461477609558512635361757334304706673378249269583497003794274869298361016417188996692715520035544727779966978038114830108861813134381830342160591600

print('p size', p.bit_length())
print('q size', q.bit_length())

"""
p = p * (2**512) + x 
q = m * (2**512) + q

x = n * inverse(q, 2**512) % 2**512
d = inverse(e, (q-1)*(p-1))
plain = pow(cipher, d, n)
"""

p = p * 2**512 + n * inverse(q, 2**512) % 2**512
q = n // p
d = inverse(e, (q-1)*(p-1))
plain = long_to_bytes(pow(cipher, d, n))
print(plain)
