#!/usr/bin/env python3

def rsa_twins():
    from Cryptodome.Util import number
    n = 14783703403657671882600600446061886156235531325852194800287001788765221084107631153330658325830443132164971084137462046607458019775851952933254941568056899
    e = 65537
    c = 684151956678815994103733261966890872908254340972007896833477109225858676207046453897176861126186570268646592844185948487733725335274498844684380516667587

    # factorized n from http://factordb.com
    p = 121588253559534573498320028934517990374721243335397811413129137253981502291629
    q = 121588253559534573498320028934517990374721243335397811413129137253981502291631

    phi = (p-1)*(q-1)
    d = number.inverse(e, phi)
    print(number.long_to_bytes(pow(c, d, n)))

rsa_twins()
