from Crypto.PublicKey import RSA
from Crypto.Cipher import PKCS1_OAEP
from Crypto.Util import number
import gmpy
from itertools import combinations

grps = {'n':[],'c':[],'e':[]}
for i in range(1, 51):
    key = RSA.importKey(open(f"keys_and_messages/{i}.pem", 'r').read())
    cipher = open(f"keys_and_messages/{i}.ciphertext", 'r').read()
    cipher = number.bytes_to_long(bytes.fromhex(cipher))
    grps['n'].append(key.n)
    grps['c'].append(cipher)
    grps['e'].append(key.e)

N = 0
for i in range(len(grps['n'])):
    for j in range(i+1, len(grps['n'])):
        if i == j: continue
        gcd = gmpy.gcd(grps['n'][i], grps['n'][j])
        if gcd != 1:
            print(i, j, gcd)
            N = int(gcd)
            ind = i

e = grps['e'][ind]
p = N
q = grps['n'][ind]//N
phi = (p-1)*(q-1)
d = number.inverse(e, phi)

key = RSA.construct((grps['n'][ind], e, d))
cipher = PKCS1_OAEP.new(key)
flag = number.long_to_bytes(grps['c'][ind])
flag = cipher.decrypt(flag)
print(flag)

"""
21 65537
34 17
20 33 919031168254299342928662994540730760042229248845820491699169870943314884504551963184014786520812939038906152950817942941469675496074887272906954399256046690838233813273902630076899906873722574023918253104149453601408405078374008695616160025877687382663027910687942091698042309812910101246025081363544171351624307177908410700904833438480012985928358897861427063761678614898919524867442676631453135379994570031284289815099294504127712924001149921480778993635917803466637717023744788311275545126346774536416864472035644211758788016642401235014385037912224180351022196262011724157012443048941426178651665266181311662824205620324073087330858064769424755443807165558567191049013947419763315902476674266627953223373671797370373786249718677582213173537848582863398367624397247597103174897140005790273296171101569756006898658668311846034013183862374297777882433967015111727139360441681664840944403450472574336901043555319067050153928231938431298082827397506406624964952344826628463723499263165279281720105570577138817805451223334196017505528543229067732013216932022575286870744622250293712218581458417969597311485156075637589299870500738770767213366940656708757081771498126771190548298648709527029056697749965377697006723247968508680596118923
b"crypto{3ucl1d_w0uld_b3_pr0ud} If you haven't already, check out https://eprint.iacr.org/2012/064.pdf"

Reference [NSA Basemen Writeup](https://github.com/pcw109550/write-up/tree/master/2019/CryptoCTF/NSA_basement)
"""
