# MERN-Ecommerce
Ecommerce website has full CRUD operations of products, categories, orders, users ...etc , authentication &amp; authorization , img uploading, stripe or cash payment and much more.

## Tech
- React 
- ReduxToolkit
- Reactstrap, Styled Components
- Formik, Yup
- Node, Express
- MongoDB
- Mongoose
- JsonWebToken
- Express Validator
and much more ...

## Featuers
- Good folders structure
- Reusable components
- State management by ReduxToolkit
- Form Validation by Formik,Yup
- Admin Dashboard to handle all resources .. products, orders, users ...etc
- Server validation by express-validator
- Image uploading by Multer,Sharp
- Payment by stripe or can pay cash on delivery
- JWT Authentication, Authorization

## API Reference
[API reference](https://documenter.getpostman.com/view/22360984/2s93Jut2tg)

## ENV
To run this project, you will need to add the following environment variables to your .env file

`PORT`
`NODE_ENV`
`BASE_URL`
`API_URL`
`FILES_UPLOADS_PATH`
`CLIENT_URL`
`MONGO_URI`
`DB_NAME`
`JWT_SECRET`
`JWT_EXPIRE_IN`
`JWT_COOKIE_EXPIRE_IN`
`STRIPE_SECRET_KEY`
`STRIPE_WEBHOOK_SECRET`

## Demo
You can see app from [HERE](https://youtu.be/psp6Ojz_BDE)
