# RSSignal-LoRa

This repository contains the source code of a proposed validation framework called `RSSignal`.

RSSignal uses [RSSI](https://en.wikipedia.org/wiki/Received_signal_strength_indication) (Received Signal Strength Indication) measurements as input, process them through some steps and generates a key/password ready to be used by any cryptographically secure encryption algorithms (such as [AES](https://en.wikipedia.org/wiki/Advanced_Encryption_Standard)).

The limited resources of IoT devices, the reproducibility of the obtained results and the key randomness aspects were taken into consideration during the process of development of the framework.

## Motivation

Given the number of IoT devices already deployed worldwide, the wide range of possibilities related to the LoRa and LoRaWAN technologies, the [key distribution](https://en.wikipedia.org/wiki/Key_distribution) problem and the lack of reproducibility of experiments related to key generation in IoT environments, this work proposes an open source framework that tries to address some of those issues.

As explained on other work [[Gao et al., 2019]](https://doi.org/10.3390/s19235122), [[Yang et al., 2017]](https://www.dit.uoi.gr/e-class/modules/document/file.php/193/LPWAN/LPWAN%20Security%20Options/Thesis_Xueying%20%281%29.pdf), [[Yang et al., 2018]](https://doi.org/10.1109/IoTDI.2018.00022), sending such an important request (as the Join Request is) in plain text can be considered a security vulnerability because it opens up the possibility of a wide range of attacks to be performed. To avoid situations like this and to help developing another solution to key generation based on RSSI measurements and PHY techniques, an open source validation framework was deployed.

## File structure

On the root of the repository, goes all the files required to run the framework (more details in the subsection below)

The `dataset-files` folder should contain the data set source files which will be used as input in the framework

The `modules` folder contains all the external modules used by the framework, they should be recursively cloned together with this repository or could be obtained separately later on

The `results` folder contains all the intermediate files generated by each step of the framework. This folder has some sub folders that have the outputs of each script/step, for more information please refer to its [README](./results/README.md) file.

### File naming pattern

Each file inside the `results`' sub folders has the framework step name which it belongs to appended as a prefix of the file name. The next part is the name of the dataset it belongs to. Then comes and optional suffix (some steps write theirs ARGS to the filename so it's easy to find an specific file without having to open it or look it up inside the folder). After the dot, as usual for most operating systems, comes the file format.

## RSSignal's workflow

The image below is a summarized [sequence diagram](https://en.wikipedia.org/wiki/Component_diagram) that shows: in gray the relationship between the theoretical steps of the framework (which where created for didactic purposes); in blue/purplish the actually implemented steps; in green the names of each script file; and in blue/teal the extra supporting scripts which useful functionalities.

![RSSignal Component Diagram](./component-diagram-RSSignal.png)

The 2 possible execution flows are as follows:
- s2 > s3 > s4 > s5 > s6 > s7 > s8 > prepare-key-eval > key-eval OR
- s2 > auto-mode > prepare-key-eval > auto-key-eval

We recommend using the first one if you are learning about our framework or if you are trying to extend its implementation.

## Using this project

Please, make sure your environment meets the requirements below if you want to run the framework.

### Requirements

List of requirements to run the framework

#### Operating system requirements

\- An UNIX-like platform

\- [GNU BASH](https://www.gnu.org/software/bash/) 5.1.16 or above or other [Unix shell](https://en.wikipedia.org/wiki/Unix_shell) interpreter

\- Python 3.10.2 or above (tested with 3.10.8 already)

\- Python-pip 22.3.1 or above

\- [OpenSSL](https://www.openssl.org/) 1.1.1n or 3.0 or above (tested with 3.0.7 already)

#### Python pip requirements*

\- [Numpy](https://github.com/numpy/numpy) 1.22.2 or above (tested with 1.23.5 already)

\- [Scipy](https://github.com/scipy/scipy) 1.9.3 or above

#### Other modules

\- [Reed-Solomon Codec](https://github.com/tomerfiliba/reedsolomon) 1.5.4**

\- [NIST randomness test suite](https://github.com/stevenang/randomness_testsuite)***

\* Install them using pip

** Already shipped with the framework

*** A [custom version](https://github.com/oliveiraleo/RSSignal-LoRa_randomness_testsuite) already ships within the framework

### Running the framework

#### 1- Clone the source code using:

```
git clone --recursive https://github.com/oliveiraleo/RSSignal-LoRa.git
```

**Note:** The option `--recursive` will clone our code + all the modules required

#### 2- Enter the project folder

```
cd RSSignal-Lora
```

#### 3- Create one virtual environment

```
python -m venv pyvenv
```

#### 4- Load the virtual environment

```
source pyvenv/bin/activate
```

#### 5- Install the OS requirements

Install the packets listed on the `Operating system requirements` [section](#operating-system-requirements)


#### 6- Install the python/pip requirements

```
pip install -r requirements.txt
```

#### 7- Run the automated script****

```
python main_controller.py OPTION
```

Where OPTION is the step of the script automation. Please refer to the [list below](#automated-script-option-reference-lists).

\**** Each option calls a different module/file of the framework. It's possible to call each one separately and we recommend doing so if you are studying the framework (i.e. not using the "auto modes" until you understand the whole process)

### Automated script option reference lists

#### Main functionality

- s1: Packet exchange, RSSI data collection [RSSignal 1st step] (Currently *not* implemented, please refer [to the FAQ](#q2-why-didnt-you-implement-the-frameworks-1st-step-probing))
- s2: Preprocess the input [RSSignal 2nd step]
- s3: Quantization [RSSignal 3rd step]
- s4: Index exchange (calculates the indexes to be discarded) [RSSignal 4th step]
- s5: Index exchange (erases the indexes discarded) [RSSignal 4th step]
- s6: Key reconciliation (encodes the data and generates the ecc bits) [RSSignal 5th step]
- s7: Key reconciliation (reconciliates the data and ecc bits) [RSSignal 5th step]
- s8: Privacy amplification [RSSignal 6th step]

#### Extra functionality

- auto-mode: Executes the steps 3 - 8 automatically
- prepare-key-eval: Executes the preprocess script to prepare data for the key evaluation
- key-eval: Executes the key evaluation for a given file
- auto-key-eval: Executes the key evaluation for a given range of data automatically
- hash-benchmark: Executes the hash benchmark

## FAQ

Some frequently asked questions and their answers

### Q1: Where are the "step 2" files?

A: We didn't focus on any step that involved the real world environment implementation because, as stated in our work, RSSI is available in a range of wireless technologies (e.g. WiFi, ZigBee, LoRa, etc) and each one has its own standards which affects how the implementation would be done.

### Q2: Why didn't you implement the framework's 1st step (Probing)?

A: Please, read the answer above. For an example on how it would be, please refer to that [other project](https://github.com/oliveiraleo/LoRa-RSSI-Grabber). 

### Q3: Why so many different files? Wouldn't it be better to keep everything together and avoid some overhead?

A: Yes, it might would. However, we tried to be as didactic and modular as possible, then we tried to reduce the dependability between the modules so they can be more easily swapped.

### Q4: Why did you choose Reed Solomon instead of X?

A: As mentioned on the work by [[DaCruz et al., 2021]](https://doi.org/10.1016/j.phycom.2021.101480), for certain applications, maybe a convolutional approach might fit better, but for our project we thought that the RS codec suffices the requirements and still is as easy to understand.

### Q5: Why the RS codec does not work for me?

A: Please, note that the total number of RSSI measurements obtained from both sides should be equal. If they are different (or for some reason they were modified during the preprocess step), chances are that the RS codec will fail to correct the bits.

### Q6: What modifications did you make to the NIST test suite?

A: We didn't change any of it's internal functionality. The external module is based on the commit [32ff14c](https://github.com/stevenang/randomness_testsuite/tree/32ff14ce65da3090a57401069a4d2e65673f658b). The [original source code](https://github.com/stevenang/randomness_testsuite/) contained all the available tests and even a GUI program, so the only modifications we made were: (i) message related (i.e. suppressing some console messages); (ii) disabled automatic input (e.g. the original code had a randomly generated input and now we use our own); (iii) disabled some tests (some tests require very long inputs to be statistically meaningful, so we choose the tests according to the framework needs); (iv) adding a custom script ([CustomKeyEval.py](./modules/RSSignal-LoRa_randomness_testsuite/CustomKeyEval.py)) that calls the test suite implementation API; and (v) removing all unused/unneeded code and data. That modifications made a huge improvement in storage space required to have the test suite available, the original code took ~5MB and our custom version takes only 77kB of disk space.

### Q7: I'm a student and I want to learn about your framework, but I'm new to LoRa and Key Generation process. What do you recommend doing?

A: First, study the basics of LoRa (if you manage to read the docs from [Semtech](https://www.semtech.com/lora/), [LoRa Alliance](https://lora-alliance.org/about-lorawan/) or [TTN](https://www.thethingsnetwork.org/docs/lorawan/), good. If not, try to watch some up to date videos on YouTube - avoiding the old ones might be a good idea as they might be outdated because LoRa is constantly evolving). Then, try to take a look at the work by [[DaCruz et al., 2021]](https://doi.org/10.1016/j.phycom.2021.101480). The next step is to clone this repo, carefully read the README files, study the source code (you should know how to use Python programming language. The good news is that usually people find it very easy to learn), understand it and start using it with the datasets already shared or with some other you find online or you made yourself.

## Citing this work

Please, cite this work as:

de Oliveira, L., Chaves, L., & Silva, E. (2022). RSSignal: um Arcabouço para Evolução de Técnicas de Geração de Chaves Baseadas em RSSI. *In Anais do XXII Simpósio Brasileiro em Segurança da Informação e de Sistemas Computacionais*, (pp. 111-124). Porto Alegre: SBC. doi:10.5753/sbseg.2022.225333

Or use the BibTex code below:

```
@inproceedings{sbseg,
 author = {Leonardo de Oliveira and Luciano Chaves and Edelberto Silva},
 title = {RSSignal: um Arcabouço para Evolução de Técnicas de Geração de Chaves Baseadas em RSSI},
 booktitle = {Anais do XXII Simpósio Brasileiro em Segurança da Informação e de Sistemas Computacionais},
 location = {Santa Maria},
 country = Brazil,
 year = {2022},
 pages = {111--124},
 publisher = {SBC},
 address = {Porto Alegre, RS, Brasil},
 doi = {10.5753/sbseg.2022.225333},
 url = {https://sol.sbc.org.br/index.php/sbseg/article/view/21662}
}
```
For direct access, please link the DOI:

DOI: [https://doi.org/10.5753/sbseg.2022.225333](https://doi.org/10.5753/sbseg.2022.225333)

## Acknowledgments

The authors would like to acknowledge Mr. Pedro Ivo da Cruz for all the knowledge shared and Mr. Rodrigo Oliveira Silva for the technical advice given during the development of the framework

We would like to thank the [Federal University of Juiz de Fora](https://ufjf.br), [FAPEMIG](https://fapemig.br/) and [FAPESP](https://fapesp.br/) for financially supporting this work

We would like to thank also Mr. Marek Simka and Mr. Ladislav Polak for releasing their LoRa RSSI data set (available on [GitHub](https://github.com/xsimka/LoRa-Localization)) which was used for [their work](https://www.radioeng.cz/fulltexts/2022/22_01_0135_0143.pdf) entitled *On the RSSI-based Indoor Localization Employing LoRa in the 2.4 GHz ISM Band*

We would like to acknowledge Mr. [Steven Kho Ang](https://github.com/stevenang), Mr. [Tomer Filiba](https://github.com/tomerfiliba) and Mr. [Stephen Karl Larroque](https://github.com/lrq3000) for their open source work (NIST test suite and RS codec python implementations) that were [incorporated as part of the framework](./modules/ACKNOWLEDGEMENTS.txt)

## Repo TODOs

- [x] ~~Upload (or link) the NIST 800-22 implementation used for the tests~~
- [x] ~~Upload some test results~~
- [x] ~~Write and upload the automation script~~
- [ ] Finish up this README file 

**Note:** We can't provide an ETA for this list ATM. However we hope we can finish its activities ASAP

## License

The source code is licensed under the [MIT](https://opensource.org/licenses/MIT) license