---
title: Todool
slug: todool
summary: To-Do Editor with different modes, advanced movement & powerful commands <img src="https://img.itch.zone/aW1nLzEwNTQ2NDQxLnBuZw==/original/dgSdqI.png" class="showcase-preview">
author: Ginger Bill
date: '2022-01-24'
categories:
  - showcase
---

<div class="d-flex justify-content-center mt-2 p-2">
<img src="https://img.itch.zone/aW1nLzEwNTQ2NDQxLnBuZw==/original/dgSdqI.png" width="100%">
</div>

[Todool](https://skytrias.itch.io/todool) is a To-Do Editor with different modes, advanced movement & powerful commands. Track your development cycle with ease.

## Text Editing Experience
<img class="showcase-left" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY1OC5naWY=/original/EKSlHU.gif">

Enjoy a normal text editing experience in a tree like outline. 

Hide children tasks or cross tasks off one by one. 

Mutli-Selection allows performing all commands on multiple tasks at once.

Mouse usage is optional.

<div class="clearfix"></div>

### Task Tagging

<img class="showcase-right" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY1OS5naWY=/original/9MJECI.gif">

You can assign 1-8 tags to each task and switch between how the tags are showcased.

Edit the tag content to whatever your file needs.

Each tag also uses a customizable color from the theme.

<div class="clearfix"></div>

### Render Modes

<img class="showcase-left" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY2Mi5naWY=/original/zZfEoU.gif">

Seamlessly switch between ***List*** and ***Kanban*** mode at any point.

Prompts like *Search* and *Goto* remain working in both modes.

<div class="clearfix"></div>

### Bookmarks & Jumps

<img class="showcase-right" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY2My5naWY=/original/%2BdSPOE.gif">

***Bookmarks*** can be assigned to each task to allow quick-jumping forwards/backwards.

Once you start moving the next jump will be lead to the nearest bookmark.

<div class="clearfix"></div>

### Cut, Copy & Paste

<img class="showcase-left" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY2NC5naWY=/original/p86Rfy.gif">

*Cut, Copy & Paste* can be done in 2 modes: Task | Text.

When no text is selected and you perform a cut/copy - the next mode will be a task cut/copy. The next paste will then result in copying all selected tasks with all attached data like tags.

Selecting text and performing a cut/copy will result in a paste of the normal text content.

<div class="clearfix"></div>

## Sidebar / Options

<img class="showcase-right" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY2NS5naWY=/original/LiXpzx.gif">

Change the look & feel of the editor to your liking with several options.

The **Achive** stores any deleted task in case you lost tasks previously.

Customize amount of time **pomodoro** timers should last for.

<div class="clearfix"></div>

## Power Mode!

<img class="showcase-left" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY2OS5naWY=/original/cU1Ky8.gif">

***Power-Mode*** makes typing and adding task properties feel great.

Enjoy particles flying throughout any action you take.

Options allow you to disable or adjust screenshake or coloring of the particles.

<div class="clearfix"></div>

## Theme Editor

<img class="showcase-right" src="https://img.itch.zone/aW1hZ2UvMTY3MzU2Mi8xMDU0NjY3Mi5naWY=/original/t33NcF.gif">

Tired of the simple default themes? Customize your theme to whatever you enjoy with the builtin ***Theme-Editor***

Change color RGBA values manually or use the color picker.

Randomize wanted colors between *Low* / *High* ranges in the HSV color space.

<div class="clearfix"></div>

<div class="d-flex justify-content-center mt-2 p-2"><a href="https://skytrias.itch.io/todool" class="btn btn-outline-primary">Available on itch.io</a></div>
