---
title: EmberGen
slug: embergen
summary: JangaFX are the creators of the 3D animation software EmberGen written fully in Odin. <video autoplay loop muted class="showcase-preview"><source src="https://jangafx.com/Q12021Launch/Media_Organized/videos/EmberGen/Film/film-composite.mp4"></video>
author: Ginger Bill and Nick Seavert
date: '2022-01-24'
categories:
  - showcase
weight: 1
---

[JangaFX](https://jangafx.com/) are the creators of the 3D animation software [EmberGen](https://jangafx.com/software/embergen/) written fully in Odin.

[EmberGen](https://jangafx.com/software/embergen/) is a real-time volumetric fluid simulator that can instantly simulate, render, and export flipbooks, image sequences, and VDB volumes. With EmberGen, you can create anything from fire and smoke, to explosions and magic wisps. EmberGen gives you the creative freedom to iterate on your simulations in a few milliseconds instead of hours.

Through EmberGen, Odin runs in production among the giants of the games and film industries: Bethesda, CAPCOM, Codemasters, THQNordic, Warner Bros, Weta Digital, and many others.

EmberGen is commercial software with a [trial version](https://jangafx.com/software/embergen/download/) available.
<div class="clearfix"></div>

## 1.0 Release Trailer

{{< youtube id="EJgA0LLq5TM" >}}

## EmberGen for Games

<video width="100%" autoplay loop muted class="showcase-left"><source src="https://jangafx.com/Q12021Launch/Media_Organized/videos/EmberGen/Games/theascent.mp4"></video>
EmberGen is currently used in over 150 leading game studios. Our games specific workflow has been battle tested in production. From fire and explosions, to energy and magical effects, we have you covered. Not only does EmberGen allow for real-time iteration, but its ease of use and built-in texture export features are unparalleled.

<div class="pt-1 clearfix"></div>

### Iterate with Unprecedented Speed

<video width="100%" autoplay loop muted class="showcase-right"><source src="https://jangafx.com/Q12021Launch/Media_Organized/videos/EmberGen/Games/embergen-iterations.mp4"></video>

We get it: simulations and renders usually take forever to get right. That's why we built EmberGen. Unlike other software, it uses the full power of your GPU—so you can simulate and render volumetric phenomenon in real-time. Not only does EmberGen produce game-ready flipbooks in seconds, it now allows you to create iterations easier and faster than ever before. Utilize random seeds to generate new iterations with rapidity. Do note that all simulations are deterministic, so you can be sure the simulation is the same each time you open your project.

<div class="clearfix"></div>


### Use in Games

{{< youtube id="weP1ZieAltQ" >}}

## EmberGen for Film & Motion Graphics

<video width="100%" autoplay loop muted class="showcase-right"><source src="https://jangafx.com/Q12021Launch/Media_Organized/videos/EmberGen/Film/wargaming-01.mp4"></video>
With the release of EmberGen 1.0, we're now a force to be reckoned with in the film industry. After adding animated FBX and Alembic support, as well as FBX camera imports and backplates, we guarantee you that EmberGen has a place in your pipeline. In the face of ever-tightening deadlines, studios around the world are turning to EmberGen. EmberGen can help you dramatically reduce time spent on simulations and rendering. Export to EXR/PNG/TGA and openVDB.

<div class="clearfix"></div>

### A workflow for Compositing


<video width="100%" autoplay loop muted class="showcase-left"><source src="https://jangafx.com/Q12021Launch/Media_Organized/videos/EmberGen/Film/film-composite.mp4"></video>
Import your FBX cameras and backplates into EmberGen to create composite ready renders. Backplates can consist of image sequences or just a single image. In your final render, the jittering depicted in the video on the right will not be present. Once EmberGen is out of beta, we hope to smooth the results displayed in the viewport.

<div class="clearfix"></div>


## EmberGen for Concept Art

Whether you're painting in 2D, or adding atmospheric effects to a 3D world, EmberGen can help you produce stunning concept art featuring gorgeous visual effects. 3D concept artists love that EmberGen can generate endless VDB volume files or images for compositions. 2D artists can use EmberGen outputs as brushes or items to layer into their work, quickly adding volumetric effects with ease. Using our backplates import feature, import your concept art to properly light and render your simulation before creating your final piece.

<div class="clearfix"></div>
