---
title: September 2024 Newsletter
summary: Highlights for September - Interview with Marshall B
slug: newsletter-2024-09
author: Jeroen van Rijn
date: '2024-09-02'
draft: false
categories:
  - newsletter
  - odin
---

## Odin release highlights
* Add support for linux_riscv64 and freestanding_riscv64
* Add `vendor:box2d`

For the rest of the many compiler changes, read the [monthly release](https://github.com/odin-lang/Odin/releases/tag/dev-2024-09) notes.

---

## Projects shared this month

| Project Name | Description |
| --- | --- | 
| [Android-Native-Example](https://github.com/IllusionMan1212/android-native-example-odin) | Android Native Example |
| [odin-leif](https://github.com/sudokit/odin-leif) | bindings to leif GPU gui library |
| [Odin-Breakout](https://github.com/f43792/Odin-Breakout) | Breakout example using raylib |
| [particle-fluid-sim](https://github.com/nuclearshadow/particle-fluid-sim) | Particle Fluid Sim |
| [raylib-wasm](https://github.com/Aronicu/Odin-Raylib-WASM-Template) | Raylib & Wasm template |
| [winforms](https://github.com/kcvinker/Winforms) | Winforms gui library |
| [odin-ts](https://github.com/Sampie159/odin-ts-mode) | tresitter mode for emacs |
| [odin-harfbuzz](https://codeberg.org/mgavioli/odin-harfbuzz) | Harfbuzz bindings |
| [colorpicker](https://github.com/brunodeangelis/okhsv-picker) | colorpicker in Okhsv & Okhsl |
| [4ZCP-4-bit-emulator](https://github.com/Z7-Z7L/4ZCP-4-bit-computer-emulator/tree/main) | 4ZCP 4 bit emulator |
| [audio-example](https://github.com/markersniffen/odin-audio-example) | audio example showcase |
| [sdf-terrain-painter](https://github.com/karl-zylinski/sdf-terrain-painter) | An SDF terrain painter |
| [the-garden-of-odin](https://asibahi.github.io/thoughts/the-garden-of-odin/) | An abstract board game |

---

## Streams / Youtube Content

### Jakub

`jakubtomsu` is working on an intersting 3D game in odin! They also started a devlog series, hopefully we'll see more the development. You can also follow them on 
* Youtube: https://www.youtube.com/@jakubtomsu
* Twitter/X: https://x.com/jakubtomsu

{{< newsletter-youtube "TjYcIXLWUi8" >}}

### Karl Zylinski

`Karl Zylinski` has been releasing videos where he goes indepth on learning various odin language features.
* Youtube: https://www.youtube.com/@karl_zylinski
* Twitter/X: https://twitter.com/karl_zylinski

{{< newsletter-youtube "ffirdMtGacQ" >}}
{{< newsletter-youtube "Ntt73Zdoztc" >}}
{{< newsletter-youtube "3X2IzOfzepA" >}}

### Spaceman

`Spaceman` is working on a small game, maybe we'll see more updates from him!

* Youtube: https://www.youtube.com/@spacekeen

{{< newsletter-youtube "siaXH-KxQ8Q" >}}

### Intro to ODIN Live

Pretty interesting Podcast from `Turbo Makes Games` and `Dani` with an Introduction to Odin!

<div class="ratio ratio-16x9 my-2">
  <iframe src="https://www.youtube.com/embed/P0QiUpm3WuU?si=WUpXE5N92Z7XrVaS?rel=0" allowfullscreen crossorigin="anonymous"></iframe>
  <!-- <iframe width="560" height="315" src="https://www.youtube.com/embed/live_stream?channel=P0QiUpm3WuU?si=WUpXE5N92Z7XrVaS&autoplay=1" allowfullscreen></iframe> -->
</div>


<!-- https://www.youtube.com/live/P0QiUpm3WuU?si=WUpXE5N92Z7XrVaS -->

---

## Interview with Marshall B

An interview with [Marshall B](https://www.youtube.com/@marshallbcodes), author of OstrichDB.

Q: What can you say about how you discovered Odin, and what appealed to you about it?

A: I was starting a new side project and wanted to explore a programming language I hadn’t used before. Although I had previously enjoyed working with C, I was looking for something different. I considered Rust, but its steep learning curve deterred me. Zig seemed promising, as it was presented as a modern successor to C, but after writing a simple program in it, I felt it wasn’t quite right for my project.

My search led me to a [YouTube video by GingerBill](https://www.youtube.com/watch?v=rCqFdYUnC24) about a language he developed called Odin. Intrigued by the detailed presentation, I decided to give Odin a try. After recreating the same program I had previously done in Zig, I found that Odin fit my needs perfectly. It felt intuitive and familiar, similar to my initial experience with C. The absence of a package manager and the supportive community made Odin an ideal choice for my project.

===

Q: Exploring a new language, Odin in this case, a database is not often people's first project. How did you arrive at this choice of project, and where does its name come from?

A: I love learning new things, and luckily for me the tech industry offers endless opportunities to explore new technologies and languages. For my next project, I wanted to build something complex and enjoyable. My previous project, Hallpass Hero, was a student data tracker developed in C/C++ and Python using SQLite. This experience led me to question how I could create a database better tailored to my wants and needs.

I recognized that creating a database with the capabilities of SQLite would be beyond my current skillset, I decided to take inspiration from MongoDB, a database I was more familiar with. I aimed to build a database that was relatively fast and distinct from existing options. The name OstrichDB reflects this vision: ostriches are flightless birds known for their speed and unique characteristics, making it a fitting metaphor for a database with distinctive features.

===

Q: All serious projects face some challenges. Which did you face and overcome so far in developing OstrichDB?

A: In developing OstrichDB, I’ve encountered several challenges. I typically program procedurally, which works well for small codebases but becomes less effective as the project grows. With OstrichDB expanding to thousands of lines of code, coupled with my two years of programming experience and learning a new language on the go, tracking down bugs has been a significant challenge.

To address these issues, I’ve focused on improving both my coding practices and problem-solving skills. This process of refining my approach and learning from each obstacle has been incredibly valuable for my growth as a programmer.

===

Q: You've mentioned that help is welcome, but what would an OstrichDB v1.0 look like, and what is there left to do?

A: I welcome contributions to the OstrichDB project, whether it's through code, testing, bug reporting, feature requests, or integrating OstrichDB into other projects. Even if you’re not an Odin programmer, there are opportunities to contribute with C code or help with web development for a future OstrichDB web application to showcase use cases and documentation.

As for OstrichDB v1.0, I envision it being a robust database with a small, engaged community using it in their projects. Currently, I’m focused on v0.3, which is already a substantial undertaking, so v1.0 is still some way off. Nonetheless, I’m excited about the progress and looking forward to its future development!

===

Q: You've additionally mentioned originally trying to do this in C. Can you compare and constrast it with Odin?

A: I have a deep appreciation for C; learning it significantly enhanced my understanding of programming and clarified the types of projects I enjoy. However, I’ve found Odin to be more accommodating in my current development work. While C presented several blockers early on, Odin has allowed me to progress with fewer obstacles. This smoother experience with Odin has made the development process less frustrating and more efficient compared to working in C.

===

Q: What's your favorite thing about Odin, and what do you think could use some love? This could be the language semantics, the packages that come with it, the community, anything.

A: One of my favorite aspects of Odin is its vibrant and growing community, which has been incredibly supportive. I’ve also come to appreciate dynamic arrays and array programming, which Odin handles impressively. The standard library is another highlight, offering a strong alternative to C without requiring a steep learning curve, unlike some other modern languages.

However, I believe the documentation could use some improvement. While the source code is a valuable resource, well-written, comprehensive, and accessible documentation is crucial for a positive development experience in my opinion. Enhanced documentation would make it easier for newcomers to get up to speed and contribute effectively.

===

Q: Any closing remarks about OstrichDB and/or Odin?

A: For any programmers interested in contributing to OstrichDB, I encourage you to check out the repository and get involved. To the Odin programmers out there, let’s continue enhancing this fantastic language, growing our community, and supporting each other in creating great software.

If you’re considering learning Odin but need a nudge, I say go for it. Build something new or revisit an old project and rebuild it using Odin—you might be pleasantly surprised by what you can achieve and how quickly you can achieve it. Thank you for the opportunity to share my thoughts in this interview. I’m both honored and excited to see it published!