---
title: August 2024 Newsletter
summary: Highlights for August - Interview with Feoramund
slug: newsletter-2024-08
author: Jeroen van Rijn
date: '2024-08-02'
draft: false
categories:
  - newsletter
  - odin
---

Big highlights:
* Update to LLVM 18.1.8

For the rest of the many compiler changes, read the [monthly release](https://github.com/odin-lang/Odin/releases/tag/dev-2024-08) notes.

---

## Projects shared this month

| Project Name | Description |
| --- | --- | 
| [VEFontCache-Odin](https://github.com/Ed94/VEFontCache-Odin) | VEFontCache Port! |
| [odin-renderdoc](https://github.com/2nafish117/odin-renderdoc) | odin renderdoc loader |
| [KISSFFT](https://github.com/joaocarvalhoopen/kissfft_in_odin) | KISSFFT bindings |
| [locale](https://codeberg.org/mgavioli/locale) | locale handling library |
| [podin](https://codeberg.org/mgavioli/podin) | generates .pot files |
| [simple_neural_network](https://github.com/Alkamist/odin_simple_neural_network) | simple neural network |
| [odin-solitaire](https://github.com/A1029384756/odin-solitaire) | solitaire using raylib |
| [todo-app](https://github.com/scheinheiser/todo-app/) | todo app using raylib |
| [Odin-FreeCell](https://github.com/jfulto98/Odin-FreeCell/tree/master) | Odin FreeCell |
| [tic-tac-toe](https://github.com/brunodeangelis/tic-tac-toe) | Tic Tac Toe |
| [Odin-Libuv](https://github.com/Akmal4163/Odin-Libuv) | Libuv bindings |

---

## Streams / Youtube Content

### Karl Zylinski

`Karl Zylinski` has been streaming solo gamedev using Odin, Raylib & Aseprite.
* Youtube: https://www.youtube.com/@karl_zylinski

{{< newsletter-youtube "8J4ZGy-yIyc" >}}

{{< newsletter-youtube "DKaH9rY06BE" >}}

{{< newsletter-youtube "KVbHJ_CLdkA" >}}

{{< newsletter-youtube "itnWMsAEHoU" >}}

---

### GingerBill

`GingerBill` the creator of odin has been streaming some gamedev using raylib to learn it. It's amazing how quick he develops these things in such a short time!

{{< newsletter-youtube "B9kSV2TaKpw" >}}

{{< newsletter-youtube "YVapfoKYPLU" >}}

{{< newsletter-youtube "Ba_-oTLyoFs" >}}

### Other Channels Found

[Marshal B Codes](https://www.youtube.com/@marshallbcodes/videos) is working on [OstrichDB](https://github.com/Solitude-Software-Solutions/OstrichDB) a custom database written in odin. 

{{< newsletter-youtube "ZuhFv3fX2oA" >}}

--- 

[hughdavenport1](https://www.youtube.com/@hughdavenport1) is working on odinz, a Z-machine interpreter in Odin! I've never heard of it, but if you know about it, make sure to give it a watch. He's going strong with 10+ videos so far programming live.

{{< newsletter-youtube "d4Gjps5gIjw" >}}

--- 

[Cobb Coding](https://www.youtube.com/@cobbcoding) has done a video on investigating the odin source code for an issue he found, while trying out odin. Not something most newcomers do 😄. Great to see 

{{< newsletter-youtube "x2F9QznOBoY" >}}

---

[DylanFalconer](https://www.youtube.com/watch?v=hp-2fQN5Nwo) first video of reasons to use odin that I personally know! I completly agree with all the points mentioned in the video. 

{{< newsletter-youtube "hp-2fQN5Nwo" >}}

---

## Interview with Feoramund

An interview with [Feoramund](https://swevencraft.org), author of the improved `core:testing` package.

Q: Let’s start at the beginning. How did you find out about Odin and what
appealed to you about it?

A: Let me spin you a tale. It was October of 2023. I was getting the urge to
start on a couple grand projects -- something of real substance. So, I
evaluated the languages I knew against the new ones I hadn't yet tried.

I needed something that could support a large project worthy of spending months
on, something with good static analysis, where if I had forgotten how sections
of the codebase worked, it wouldn't be as much of an issue. This ruled out all
the scripting languages I knew.

I really didn't want to write a new project in C++. To give you a little
background, it was the only language I knew well enough at the time that could
theoretically sustain what I was aiming to make, but the towering mass of
complicated semantics and its standard library caused me a lot of friction in
the past. It didn't help that I was brought up in the OOP tradition.

I was lucky enough to see a recording of one of Ginger Bill's interviews as I
was gathering information on what was new in the programming language scene. So
I lined all the challengers up: Rust, Go, Nim, Zig, Odin. I spent about a week,
tinkering with each a day.

In short, Odin was the only one that really appealed to me and gave me a good
gut feeling about it being capable.

My first project in Odin was a rock-paper-scissors simulator, since that's a
good way to gauge a variety of things about a language and its ecosystem
without spending too much development time: user input, parsing, printing
output, random numbers, control flow, package management, comparisons, separate
procedures, et cetera.

For why it appealed to me at first, I can say this: Odin doesn't have garbage
collection, doesn't enforce any revolutionary new ideas, doesn't have macros or
a preprocessor. It's quite simple (as opposed to complicated, not complex; I
know Bill likes to make this distinction.). It also has a very sound package
management system that leverages the filesystem. The ideas and features that
Odin implements feel like common sense, like they've been around a long time
and speak to a natural flow.

Of course, Odin is also compiled and has a community upholding standards of
readability, maintenance, then speed. I wouldn't have to worry about many
layers of indirection or confusing APIs.

I will admit it took me some time to get used to putting variable names first,
then types, but I've come to prefer that style far better than the other way
now. This is true of almost everything in Odin: where there has been some
adjustment period, I've come to prefer the Odin way.

For perhaps the first time since my early days of programming, Odin feels like
a quickening or a refreshment. I'm not bogged down anymore.

===

Q: Is there something you can say about your programming journey prior to
discovering Odin?

A: It's still ongoing, for certain. I started out playing with BASIC many years
ago, entertaining myself with little more than PRINT, GOTO, and INPUT on a
home computer, and some days I do wish for those times again.

The only disappointment with my journey is that I had spent a significant
amount of time in the mire of poor thinking. I was caught by the OOP bug and
probably several other popular-yet-bad habits, and for a long time, those
paradigms were a vise over my mind in how I was able to form abstract
concepts or complete complex works.

Odin has been the bridge to clarifying much of my thinking, to the point that
I'm far more confident in my general programming skills than I've ever been.
I've had more eureka moments with Odin than any other language in recent
memory.

If there's anything I can leave the reader with, it's that you must continue to
explore what is possible and to not become dogmatically entwined with a tool, a
framework, or a way of solving problems just because it's all you know. Seek
out alternatives and try to have at least a couple possible pathways when
presented with a problem, so that you don't fall into similar traps.

I don't know if there's a shortcut past the stage of writing bad code and
having ideas about forcing square pegs into round holes, but maybe together we
can shorten the amount of time people spend in that stage.

I could go on for pages about my journey so far, but I think I've highlighted
the most important bits related to Odin.

===

Q: It's not every day someone comes out of nowhere and drops a complete
overhaul of a testing framework, never mind with code quality suggesting a
great familiarity with the language. Why *that* package, and what was the
design process like?

A: The design process was a slow, methodical one. I said in the original pull
request that my overhaul was the culmination of months of gathering ideas of
how tests could be done better, and this is no exaggeration. By the time I
sent that PR, I believe I had been programming almost exclusively in Odin
for eight months.

During that time, I had been working on my own core library of sorts to support
the future grand projects I dreamed of. It may sound curious, but I am a
newcomer to writing tests; I was never a student of Test-Driven Development or
related disciplines; I used to do a lot of manual testing and `printf`
debugging. The last big project I worked on with other people had an impressive
test suite, and that sowed the seeds for how I would begin to write my own
tests once I found how easy it was in Odin.

I wrote dozens of tests for every personal package I made.


Yet, I was not satisfied. I didn't like how all the test results just scrolled
past, and if you wanted to see individual results, you'd have to scroll back
up. My dissatisfaction grew, and I kept imagining ways it could be better.

Dissatisfaction coupled with the will and skill to change something, I think,
is the fundamental energy that drives open source software development.

And so, I set to work. I first started with how I wanted the test runner to
feel. I focused only on the visual aspect, what we as programmers and users
would see, since that was a big focal point for me. I created a test runner
simulator to that end, where I spent a few days tweaking how the output flowed.

After that, I experimented with multithreading and inter-process communication
solutions. In this way, everything was designed in a modular fashion, and only
at the end did all the pieces come together. It took a few weeks to properly
do, and I believe most of my time was taken up by analyzing edge cases around
multithreaded programming.

I like to think that the Odin test runner is my first real, serious multithreaded program.


Now, as for *why* did I pick `core:testing` to overhaul first... The short
answer is that tests are fundamental to development of large projects, and I
believed at the time that I identified a point in the Odin ecosystem that could
use some serious improvement.

To elaborate on this, I wanted to not only learn more about multithreading and
apply some of my user interface design ideas to relieve my own frustration, but
I also wanted to have a beneficial and lasting effect on this language that has
helped clear up so much fog for me.

Take tests as they are: they are procedures that signal concretely encoded
expectations of the programmer. They're so fundamental to what we do. We have
hundreds of tests for the Odin core library collection.

It's like giving back to the community, for me.

===

Q: You just dropped another pull request, this time to add `core:text/regex`.
Tell us about that a bit. What were the technical decisions you found yourself
having to address, for example.

A: The implementation of the virtual machine design itself took some time to
get just right. At first, the Opcode was a union of structs, which I found
ended up taking about 24 bytes per opcode. Nowadays, that's hardly any memory
at all. However, just because a resource is plentiful doesn't mean we should
spend it so needlessly.

The union of structs stage served me well in getting the initial implementation
up and running with some simple debugging tools, but I had to imagine the
scenarios in which this package would be used, in production environments. If I
could manage to crunch the costs down even further, it would be good for
everyone.

With that, I decided to use actual bytecode to represent the instructions for
the VM. This resulted in not only a significant drop in memory usage but even a
little speed gain. A win all across the board. There was a small cost in
readability, as everything that has to interact with a compiled regular
expression now needs to account for operand sizes, especially the compiler when
it's constructing operations, but it's a cost I'm willing to pay.


Another decision I made was to use a Top-Down Operator Precedence parser, also
known as a Pratt Parser, for constructing the regular expression from the
string. It's possible that I could've used a linear iteration through the
string and constructed the AST that way, but the TDOP parser felt like the
better, more maintainable choice. I had written only one in the past as an
experiment, and I was really interested in putting this parser design to the
test.

For any non-trivial expression parsing, I can highly recommend the simplicity
and power of the Pratt parser.


As for optimization, I wrote a pattern optimizer that tries to nudge the
expression towards better performance. I found great success with implementing
special case opcodes for `Global` patterns and patterns ending with `.*$`. I
had also considered using binary search to evaluate classes, but interestingly,
I found it to be slower in practice once I checked the benchmarks.

It's important to always benchmark and trial your ideas, just in case your
mental model of reality is incomplete; the test will reveal whether your
assumptions are correct or not. Then, if you're really curious, you can dig
deeper to find out why.

===

Q: When you're not busy writing or overhauling library code, in what manner are
you using Odin, and how does it hold up?

A: I've been using Odin for all of my new projects since late last year, from
small to big. Of note, I am building an internet archival tool that I will use
to preserve and display websites with the WARC format. I would also like to
write a full game in Odin, one day. To that end, I have written a few prototype
games in the language already.

Odin holds up surprisingly well, and where it doesn't, I have sought to improve
it within the reach of my skill. Usually, if I have an issue, it's more on my
own shoulders than the language's, which is to say I'm not wrestling with the
design decisions of C++ anymore, thankfully!


However, I must admit that I haven't had much time lately to work on my own
personal projects, as I've been rather busy as you've pointed out. I hope to
get back to it soon, but the prospect of writing more code for Odin itself is
alluring in a way.

It's a tough value proposition to make sometimes, you know?

Fixing bugs and writing library code is guaranteed to be useful to someone and
have a more profound impact on a greater number of people, but the outcome of
personal projects can be more grim, as anyone who's been doing this long
enough can attest to. I certainly have my own graveyard I've kept well-tended
for many years now across a myriad number of languages and frameworks.

===

Q: Is there anything else that strikes your fancy to grace us with in the short
to medium term?

A: Grace? You honour me with such words.

I have a few ideas I'm considering for additional candidates to the core
library collection, once I'm done with the `regex` package. I'm keeping my eye
towards what might be most useful while offering some learning opportunities
for me.

However, I won't say anything just yet. To borrow your phrasing from another
conversation we've had, I prefer to emerge fully formed. People are more
delighted when surprised with wonders rather than disappointed by fallen
promises.

===

Q: What would you say your favorite thing about Odin is, and what would you say
could be improved? This could be a feature, syntax, the community,
documentation, tooling, anything and everything related to working with Odin
that you really like, and conversely think could use some love, and why?

A: Two questions in one! Surely I have the strength to answer both.

I would have to say the plain simplicity is my favorite thing about Odin. The
clarity of the language lets me cut straight to the problem. It's almost as
unfettered as assembly. Odin truly is an alternative to C, if not a proper
successor.

As for what could be improved... Well, I'm conservative with my language
feature wishes, so I'd say it would be great if we could keep fixing bugs and
improving stability in the compiler. However, I will say that I'm curious what
an alternative backend to LLVM would be like. I imagine we would have faster
compile times. Maybe we would get better code generation and smaller binaries
too? I bet that's a heroic effort though, to build an alternative to LLVM.

Odin's flexible enough that if something's missing, usually I can write what I
need myself, so I don't have any great demands. So long as the code generated
by the compiler is as fast as can be, then the responsibility is on me to make
the code performant, and I won't have to worry about any underlying costs.


In closing, I will say that for Odin's future, I will be glad if the philosophy
behind the language stays the course over the years to come, weathering
whatever new techno-fads and siren songs composed only of buzz words happen to
entice and arouse the masses.