---
title: February 2024 Newsletter
summary: Highlights for February - Community Showcase ***Categorized***
slug: newsletter-2024-02
author: Michael Kutowski
date: '2024-02-01'
categories:
  - newsletter
  - odin
---

Odin is on the journey to 1.0! You can read up on all changes in the [monthly release](https://github.com/odin-lang/Odin/releases/tag/dev-2024-02) notes.

## Reddit
Karl Zylinski opened up a reddit again! Check it out here [Reddit](https://www.reddit.com/r/odinlang/).
Personally I've left reddit but building up communities other than discord is good. The same applies to searching for odin help online.

## Games

We've got a whopping ***3 Games*** this month! I'm very excited to show them off here, so please check them out.

### ***Solar Storm*** from `Jakub`

"Solar Storm steam page is live!
It's still fairly work-in-progress, the screenshots are outdated and there is no trailer, but I'm working on it!
Wishlists are greatly appereciated!!"

Also I'm also doing a first public playtest this weekend, if anyone is interested, join solar storm discord server to participate: https://discord.com/invite/wn5jMMMYe4

Steam: https://store.steampowered.com/app/2754920/Solar_Storm/

<div id="contenedor">
  <iframe src="https://store.steampowered.com/widget/2754920/" frameborder="0" width="100%" height="190"></iframe>
</div>

### ***The Legend of Ján Ïtor*** from `Colin Bellino`

"Adventurers are spreading a lot of slime and other mess in the dungeon and you are the one tasked to clean it up before it becomes out of hand.

This game was created over a period of 2 weeks by a team of 3 people, this is a submission for the Pirate Game Jam 14. 

Engine: This game was developed as an experiment and way of dog-fooding a custom, handmade game engine i am working on (written in the Odin language)."

<iframe height="167" frameborder="0" src="https://itch.io/embed/2464247" width="100%"><a href="https://colinbellino.itch.io/the-legend-of-jan-itor">The Legend of Ján Ïtor 💀 by Colin Bellino, Flip, TillerQueen</a></iframe>

### ***CAT & ONION*** from `karl_zylinski`

"My game CAT & ONION is now released on itch! https://zylinski.itch.io/cat-and-onion

It's a warm adventure game where you play as a cat who goes on a surreal lil journey 🐱

It has taken me months to make and I'm very proud to have finished a game all by myself. It is written in Odin + Raylib.

When you buy on itch you also get a drop of the source code. It's quite a chaotic code base, full of both good and bad things. The good parts is in my opinion the editor tools and the hot reloading etc. The bad parts is the entity system and the physics."

<iframe frameborder="0" src="https://itch.io/embed/2433536" width="100%" height="167"><a href="https://zylinski.itch.io/cat-and-onion">CAT &amp; ONION by Zylinski Games</a></iframe>

## Community Contributions

### Dynlib Helpers by Jeroen

Useful new helper added to `core:dynlib` to automagically populate a struct with procedure and global pointers from a DLL (or other shared lib depending on platform).

```odin
package example

import "core:dynlib"
import "core:fmt"

Symbols :: struct {
    // `foo_` is prefixed, so we look for the symbol `foo_add`.
    add: proc "c" (int, int) -> int,
    // We use the tag here to override the symbol to look for, namely `bar_sub`.
    sub: proc "c" (int, int) -> int `dynlib:"bar_sub"`,

    // Exported global (if exporting an i32, the type must be ^i32 because the symbol is a pointer to the export.)
    // If it's not a pointer or procedure type, we'll skip the struct field.
    hellope: ^i32,

    // Handle to free library.
    // We can have more than one of these so we can match symbols for more than one DLL with one struct.
    _my_lib_handle: dynlib.Library,
}

main :: proc() {
    sym: Symbols

    // Load symbols from `lib.dll` into Symbols struct.
    // Each struct field is prefixed with `foo_` before lookup in the DLL's symbol table.
    // The library's Handle (to unload) will be stored in `sym._my_lib_handle`. This way you can load multiple DLLs in one struct.
    count, ok := dynlib.initialize_symbols(&sym, "lib.dll", "foo_", "_my_lib_handle")
    defer dynlib.unload_library(sym._my_lib_handle)
    fmt.printf("ok: %v. %v symbols loaded from lib.dll (%p).\n", ok, count, sym._my_lib_handle)

    if count > 0 {
        fmt.println("42 + 42 =", sym.add(42, 42))
        fmt.println("84 - 13 =", sym.sub(84, 13))
        fmt.println("hellope =", sym.hellope^)
    }
}
```

Output
```
Creating library W:\Odin\core\dynlib\example\lib.lib and object W:\Odin\core\dynlib\example\lib.exp
ok: true. 3 symbols loaded from lib.dll (7FFDCF510000).
42 + 42 = 84
84 - 13 = 71
hellope = 42
```

### Odin / WASM / Webgl by thetarnav

"I've been slowly getting into learning Odin, WASM and WebGL
So I made a example project where I experiment with the three (and some js tooling for development/bundling)
Maybe it could be useful for somebody for reference or as a template
Also the wasm/js bindings there are rewritten into modules with types so it's a bit easier to understand and extend them (no more random typos)"

Check it out here: https://thetarnav.github.io/odin-wasm

## Community Showcase

Repositories:
- [red_black_tree](https://github.com/wilig/red_black_tree) - simple red black tree implementation
- [odin-libpcap](https://github.com/Pix-xiP/odin-libpcap) - libpcap bindings
- [odin-libktx](https://github.com/DanielGavin/odin-libktx ) - libktx bindings
- [odin-box2d](https://github.com/cristhofermarques/odin-box2d) - Box2D 3.0 bindings
- [efsw-odin](https://github.com/dch-GH/efsw-odin) - ESFW bindings
- [ogmo-loader](https://gist.github.com/Tekkunsan/4f41b1cf41acd6a69f30acacc43f5176) - Ogmo Project and - Level Loader
- [wcwidth](https://github.com/greenm01/wcwidth) - A simple implementation of wcwidth(3) and wcswidth(3)
- [odin-box2c](https://gitlab.com/L-4/odin-box2c) - Quick Box2c bindings
- [odin-pkg](https://github.com/leidegre/odin-pkg/tree/master/flag) - command line handling package

Gists:
- [blas_bindings](https://github.com/jon-lipstate/blas_bindings) - BLAS Bindings for Odin
- [sign_extension](https://gist.github.com/dotbmp/1d80d679ac93a5785b716aee163d7056) - Little sign-extension and zero-extension helpers
 
### Miscellaneous

{{<
  newsletter-img
  "My x86 disassembler disassembling itself. Sheesh now im realizing how long the SSE instructions really are - flysand"
  "https://media.discordapp.net/attachments/568871319425515531/1191676152125857824/image.png?ex=65f021e6&is=65ddace6&hm=e236417fc7be5899cbf6ad269b1aaa9de3028c8e4de742014ee0abf54d93c7fa&=&format=webp&quality=lossless"
>}}

{{<
  newsletter-video
  "Experimenting with a coroutine API for odin-http - laytan"
  "https://cdn.discordapp.com/attachments/568871319425515531/1192902982946279524/Screen_Recording_2024-01-05_at_19.48.27.mov?ex=65f4987a&is=65e2237a&hm=4162822c817088b38d8f52ff79b4b43f20fdf6ab4b6cfce747863ab64bc2debd&"

>}}

{{<
  newsletter-img
  "Finally, got raylib running on the web - Christhofer"
  "https://cdn.discordapp.com/attachments/568871319425515531/1195208287654780958/image.png?ex=65f3c0f5&is=65e14bf5&hm=80ede67d0c3740970b6efc67393644217370e3422ac8a826c45760a41a4eaa16&"
>}}

{{<
  newsletter-img
  "got a simple http server reading requests - fridge777"
  "https://cdn.discordapp.com/attachments/568871319425515531/1195555658746048582/image.png?ex=65f50479&is=65e28f79&hm=95e9cfaec3738432effab8bd7b8a224ed42d8d32ea230a8fb35b1048140ca882&"
>}}

{{<
  newsletter-video
  "minor update: odin-mustache now supports an explicit layout to render a given template inside of - b3lm0nt"
  "https://cdn.discordapp.com/attachments/568871319425515531/1196925328862498847/layout_demo.mp4?ex=65f0c594&is=65de5094&hm=b1ec3dfd16615c9edc6ea20bb3ac400f3523334f414da9541caa68ffcc25a7e4&"
  "https://github.com/benjamindblock/odin-mustache#layouts"
  "mustache"
>}}

{{<
  newsletter-video
  "Got an LED to blink on my RP4 - thanks to @irvin  for adding the freestanding_arm64 target and sharing his example code! - markersniffen"
  "https://cdn.discordapp.com/attachments/568871319425515531/1197695624733266020/rpi4_blink.mp4?ex=65f392f9&is=65e11df9&hm=2a8de47376572c9001c0bb7efdefafbfcef49e79831d79a924c5927781e192ad&"
>}}

{{<
  newsletter-video
  "Video visualization of linear vs binary search, made by generating ppms and then running x264 encoder - NicknEma"
  "https://cdn.discordapp.com/attachments/568871319425515531/1199027405109604412/video.mp4?ex=65ef30ca&is=65dcbbca&hm=e1c8f6a16e24ff65a6463150a870118f358fd26cb85187ce1cc9cbb7e7a643a9&"
  "https://nullprogram.com/blog/2017/11/03/"
  "Based on this article"
>}}

{{<
  newsletter-video
  "brainf* interpreter 😄 - NicknEma"
  "https://cdn.discordapp.com/attachments/568871319425515531/1200548746623205376/20240126_221055.mp4?ex=65f4b9a6&is=65e244a6&hm=590b82ba4cc07c520f3890bc1f4798b2f8c56d2f743e4af1e85dc3cd8e430830&"
>}}

{{<
  newsletter-video
  "optimized brainf* interpreter 😄 - NicknEma"
  "https://cdn.discordapp.com/attachments/568871319425515531/1200864945882013746/20240127_190744.mp4?ex=65f5e022&is=65e36b22&hm=ff5ef56ca2fb9dc17849886cf633573ff91ae341609484d6f9cff031c6b7ab9a&"
>}}

{{<
  newsletter-img
  "Its a mess but Hello world Jolt running in Odin. Bindings still have a looong way to go though. - Sumofat"
  "https://cdn.discordapp.com/attachments/568871319425515531/1201543641496297513/image.png?ex=65ef1db7&is=65dca8b7&hm=c211cde27b324d96399c1c296e17f64afbd65de59bf015c11e8cb8996bbde31f&"
>}}

### Game Development

{{<
  newsletter-video
  "juiced up analog detection for translating them into cardinal inputs. bonus points for use of quadrance instead of using square roots - Krzysztoφορος"
  "https://cdn.discordapp.com/attachments/568871319425515531/1192302662528536576/2024-01-04_13-41-18.mp4?ex=65f26962&is=65dff462&hm=6a9b82a66dcc0e1978b50de94ec41fe997f215bb4a5fea4d8a2dee558d3773f0&"
>}}

{{<
  newsletter-img  
  "Initial POC of Odin in Unity 😉 (DOTS is really making this easy :P) - Dani"
  "https://media.discordapp.net/attachments/568871319425515531/1192799605675536434/Code_KbjZ7AwcMF.gif?ex=65f43833&is=65e1c333&hm=86d68a4373e0faba7311c370054fe62c4e93895c9ebd905ec301e8d6cc048e5a&="
>}}

{{<
  newsletter-video
  "Heres our latest update on our 2D game engine @Marko - ScottCastle"
  "https://cdn.discordapp.com/attachments/568871319425515531/1192977245933932584/MainVideo1.mp4?ex=65f4dda3&is=65e268a3&hm=10302a138a777b0556894d60d44f4ba03c1dfd9298f270df56b47a42d20406ab&"
>}}

{{< newsletter-youtube "Ao9lrsKos1Y" >}}

{{<
  newsletter-img
  "My Tilengine journey is continuing with great success. I've been writing a little \"engine\" to handle level loading, game logic, sprites etc. to use with the bindings... - Akuspel"
  "https://cdn.discordapp.com/attachments/568871319425515531/1194794688398512188/Tilengine.gif?ex=65f23fc3&is=65dfcac3&hm=406fddb463b47b580f73f8430acff2207ba58369465d898b75cb511ccf4649b6&"
>}}

{{<
  newsletter-img
  "Still a spinning Unity Cube, but more stuff has been moved to odin (SystemState, EntityQueries & ComponentHandle usage.. also, dynamic dll loading) - Dani"
  "https://cdn.discordapp.com/attachments/568871319425515531/1197321983294181556/Code_o73MgoeB1L.gif?ex=65f236fd&is=65dfc1fd&hm=33ae2e77b400776063b4c69b2701725a461cb6c462951262813d42987fbb3fbb&"
  "https://github.com/Daxode/odecs/"
  "Source"
>}}

{{<
  newsletter-video
  "Day 1 - ҽʅʅσɾα"
  "https://cdn.discordapp.com/attachments/568871319425515531/1198093174078447646/2024-01-19_15-41-08.mp4?ex=65f50538&is=65e29038&hm=16d5978488338153915b2c8257484fefc432d0469bdaa9413366d515d770801d&"
>}}

{{<
  newsletter-video
  "Day 2 - ҽʅʅσɾα"
  "https://cdn.discordapp.com/attachments/568871319425515531/1198729685320859739/2024-01-21_17-18-49.mp4?ex=65ee1b84&is=65dba684&hm=d2b40da0129fe197e8f1c8d536eb6866ee05cdcff5019b45c186850997a7029e&"
>}}

{{<
  newsletter-video
  "Just a small prototype I have whipped up for a top down hack and slash game. Everything is very crude and basic but there is something emerging. So much to work on... - Perlind"
  "https://cdn.discordapp.com/attachments/568871319425515531/1199137715116052511/gamer_time.mp4?ex=65ef9786&is=65dd2286&hm=c1ca609e3a10e4cfbb8a59b68400450a4d992ef8bd6f908c4ddeedbe793728c6&"
>}}

{{<
  newsletter-video
  "Day 3 - ҽʅʅσɾα"
  "https://cdn.discordapp.com/attachments/568871319425515531/1199143900934328410/2024-01-22_13-22-56.mp4?ex=65ef9d48&is=65dd2848&hm=bdc6713ddfe0e5636fc445edcaec743105f682c7a2580e4e58feeff2ec9c0788&"
>}}

{{<
  newsletter-video
  "doing some funky collision-pair debug visualization using immediate mode rendering. This actually showed me that i forgot to delete the enemies once they go out of screen on the bottom side - The Lua Whisperer"
  "https://cdn.discordapp.com/attachments/568871319425515531/1199269741429280819/bitflight_OorRR4BKmJ.mp4?ex=65f0127b&is=65dd9d7b&hm=7417c097604f0aeffaa091ecfc9afc3010e16df306556f81b1e4fdc25395b0f4&"
>}}

{{<
  newsletter-video
  "randomly sized big explosions - The Lua Whisperer"
  "https://cdn.discordapp.com/attachments/568871319425515531/1199994551989977088/AmffcF50W4.mp4?ex=65f2b584&is=65e04084&hm=83dc0c7609189d1add3def65696db6ce46260eea4389ebdf886747e07335ce58&"
>}}

{{<
  newsletter-video
  "i've made hex-chess with odin/sdl2, i've also managed to \"link\" sdl2 to wasm target so there is a web build if u want to check out - шоськудись"
  "https://cdn.discordapp.com/attachments/568871319425515531/1200060053324058727/hex.mp4?ex=65f2f284&is=65e07d84&hm=d4ddb2d2d9fa20cf76a14bf14a8ef3b7c19eb6b61d4a53b18af6022ac3390d31&"
  "https://es-lo-que-es.github.io/hex-chess-web-build/"
  "Source"
>}}

{{<
  newsletter-img
  "Odin+SDL+GOL - Glennwiz"
  "https://cdn.discordapp.com/attachments/568871319425515531/1200475202413416549/NorseGridsOfGnipahellir_neDftTCDyC.gif?ex=65f47528&is=65e20028&hm=d5c43bd23f8545965b3ea245f7f22b08133a422ee38a8a0f9ea48df1f8a2cf91&"
>}}

### Graphics

{{<
  newsletter-img
  "Got my GPU driven animations to work. Basically doing all the computation and blending on the compute shader. The cpu just finds the animations frames indices and calculates the weight and are then sent to the gpu - Draoz"
  "https://cdn.discordapp.com/attachments/568871319425515531/1191467199475503154/anim.gif?ex=65ef5f4c&is=65dcea4c&hm=a5cc1d0728e018754a25e2cfb2e3131d543bed65bcbe15c3183517508d87bb75&"
>}}

{{<
  newsletter-video
  "i had recently implemented rxi's cached renderer in compute which overcomplicated things - so this version does tiles per draw call + instances calls within each tile - Skytrias"
  "https://cdn.discordapp.com/attachments/568871319425515531/1191512838787833976/20240101_233453.mp4?ex=65ef89ce&is=65dd14ce&hm=932d6eec42257ce950aa6ba4f2ca72e27d8d7f30e58eb1908cf3b3538e66cbb8&"
>}}

{{<
  newsletter-img
  "Got my first working build of odin bindings for the Spine-c runtime (with raylib)! - Zealous"
  "https://cdn.discordapp.com/attachments/568871319425515531/1193302368897470474/first-working-build.gif?ex=65f60c6f&is=65e3976f&hm=cd8214fe5e9d4b03c0f3f3ad6f2b6fbb70603290f208a8ab9740ab58f0c26415&"
>}}

{{< newsletter-youtube "toQelBElnW8" >}}

{{<
  newsletter-img
  "After some struggles, I got working Tilengine bindings in Odin! 🥳 - Akuspel"
  "https://cdn.discordapp.com/attachments/568871319425515531/1194278601101676604/image.png?ex=65f05f1f&is=65ddea1f&hm=b52b16e8af41ba3a7916fee44284f1687a8a80c9fc06dc546e7045ccbccb79f3&"
>}}

{{<
  newsletter-img
  "Back at it again fighting with my voxel engine, first pass at getting light sources to work done - Chris"
  "https://cdn.discordapp.com/attachments/568871319425515531/1194393958047023134/image.png?ex=65f0ca8e&is=65de558e&hm=472346c0d5769fee0622206c0e7f39a5cda8dc57f83b7647f2966fb3ef4f8215&"
>}}

{{<
  newsletter-img
  "I know I'm not the first, but here it is a basic Webgpu \"Hello Triangle\" application using a recent version of wgpu-native and some hand-made bindings - Vicix"
  "https://cdn.discordapp.com/attachments/568871319425515531/1195067121923805284/Screenshot_2024-01-11_at_18.38.35.png?ex=65f33d7d&is=65e0c87d&hm=0b9d26db72fc347879c31a5939c89fda721d28715d5acc3840ba2a69f9d465d9&"
>}}

{{<
  newsletter-img
  "not super fancy, but I drew a fish with the gpu, loaded from a .obj file. This is my first gpu project that isn't secretly a software renderer - Stvff"
  "https://cdn.discordapp.com/attachments/568871319425515531/1197361323730817145/image.png?ex=65f25ba1&is=65dfe6a1&hm=57d1542ef85e7f668d32adeb569719a033806b6e8b7e6904cc5ef6092a1e65d4&"
>}}

{{<
  newsletter-video
  "Achieved using Odin + SDL2 + OpenGL + @Jesse Blender importer-exporter - Smilex"
  "https://cdn.discordapp.com/attachments/568871319425515531/1200221698662862868/2024-01-26_00-30-12.mp4?ex=65f38910&is=65e11410&hm=99af6f800882c5428af94df9e0f9f2702ca858d17ff30750a0c51be3d2864d16&"
>}}

{{<
  newsletter-img
  "crudely animating my fish programmatically - Stvff"
  "https://cdn.discordapp.com/attachments/568871319425515531/1201569623045320704/Peek_2024-01-29_17-17.gif?ex=65ef35ea&is=65dcc0ea&hm=d9ce96dd598e2e57b67a63503413a7433f925ce70646b99ab7ed31c11c8366e1&"
>}}

{{<
  newsletter-video
  "CPU rendering transparency unlocked - Krzysztoφορος"
  "https://cdn.discordapp.com/attachments/568871319425515531/1202077568547954708/2024-01-31_13-15-27.mp4?ex=65f10ef9&is=65de99f9&hm=8b145a229e04a26ede3f9b6067246f656602dadd0154d5e51d1bce7effee2bcd&"
>}}

### Tools & UI

{{<
  newsletter-video
  "whats this? 👀 - Skytrias"
  "https://cdn.discordapp.com/attachments/568871319425515531/1194057737949163631/eduNhnna7r.mp4?ex=65ef916d&is=65dd1c6d&hm=0a4a63a1706ea565f2265143c98ddc4114af44d4a1f1aee03c83066ba6ac5785&"
>}}

{{<
  newsletter-img
  "Been getting quite annoyed with the sluggish windows file explorer recently... - Francis_the_cat"
  "https://cdn.discordapp.com/attachments/568871319425515531/1195046401466445994/image.png?ex=65f32a30&is=65e0b530&hm=1246b1fcd507ae397e28751c25f19059da52ee6aaa2e3b57b89a9a966072515a&"
>}}

{{<
  newsletter-video
  "The Focus text editor inspired me to try making my own editor with some things it doesn't have like identifier type coloring. Here's basic demo of it mostly working. Still have a long way to go, this just parses the file you're editing. Will look into parsing packages you declare through import statements now. - CasualKyle"
  "https://cdn.discordapp.com/attachments/568871319425515531/1198723046081573005/2024-01-21_14-10-23.mp4?ex=65ee1555&is=65dba055&hm=f4c643473819dd8cee2ec3d6fe26dd5f97ef6a7eeebdb925600d177dd391ac4f&"
>}}