---
title: January 2024 Newsletter
summary: Highlights for January - Community Showcase ***Categorized***
slug: newsletter-2024-01
author: Michael Kutowski
date: '2024-01-01'
categories:
  - newsletter
  - odin
---

Happy new year everyone! 

This year we'll be seeing lot's of improvements on the compiler and also solidifying core packages. December itself was going slow since most people took a break.

## Contributions

Here is the [Monthly Release](https://github.com/odin-lang/Odin/releases/tag/dev-2024-01)

- `obfuscate-source-code-locations` flag to hash location strings
MacOS:
  - `-no-crt` now works
  - Fix the duplicate `-lSystem` linker warning
  - Default to SDK version for -minimum-os-version to avoid linker warnings
- `#load` now works with absolute paths
- Fix a bug that caused running tests twice
- General compiler crash fixes

## Community Contributions

There were a lot of community contributions this month! We'll list a few of them and go into detail on some of these.

- [Raylib Odin Examples](https://github.com/SabeDoesThings/Raylib-Odin_Examples) - Ports of raylib examples to odin
- [do_parallel](https://github.com/joaocarvalhoopen/Lib__do_parallel__for_Odin) - parallel iteration
- [Ncurses](https://github.com/RaphGL/Ncurses.odin) - ncurses bindings
- [WAV Tools](https://github.com/joaocarvalhoopen/Library_WAV_tools_in_Odin) - A simple library to read and write WAV files for the Odin programming language
- [FFTW](https://github.com/joaocarvalhoopen/FFTW_lib_bindings_for_Odin) - bindings FFTW, Fast Fourier Transform in the West
- [Tree Sitter](https://github.com/laytan/odin-tree-sitter) - API bindings, wrappers and convenience for Tree Sitter
- [libui-ng](https://github.com/henkman/odin-libui-ng) - libui-ng bindings

### Odin + Flakes + Nix

"A using of the Odin Programming Language with the Nix+Flakes, to have a more accessible interaction with on Nix and NixOS operation system and any other Unix-like that have support for Nix as well (on the future!)

The main Idea is simplify the usage of Odin, to have all out of the box with no need to add any more software (or remove any unnecessary software if you wish  with only one comment), so you don't need to worry about anything after one line of Nix Flakes! with also have as plus+ reproducibility and immutability of Odin development/deploy!  (of any* branch of the Odin project!)" - `haller`

Source: https://github.com/haller33/Odin-Flake

### TodoMVC in odin & htmx

"I created a proof of concept todo list website fully with Odin. Using my own http and template engine packages (and a little bit of htmx)." - `laytan`

Demo: https://todomvc-odin-htmx.laytan.dev/

Source: https://github.com/laytan/todomvc-odin-htmx

### Todool Source Code

"Since Todool dev stopped a while ago i thought i might as well share the source before it dies, maybe a good resource to learn from? probably not" - `Skytrias`

Source: https://github.com/Skytrias/todool

## Community Showcase

### Miscellaneous

{{<
  newsletter-img
  "I am working on a cut-fill grading program to regrade my pasture using rtk gps. thus far ive managed to import a survey and get contour lines going. the patch there is not large, maybe 10' x 30' outside my front window - mjolnir"
  "https://cdn.discordapp.com/attachments/568871319425515531/1180395240486600714/image.png"
>}}

{{<
  newsletter-img
  "This might be useful for someone. I'm working on a parser for Java class files, creating a tool similar to javap (java disassembler). Currently working on reading the bytecode. - FourteenDoggo"
  "https://media.discordapp.net/attachments/568871319425515531/1180572764806053998/image.png"
  "https://github.com/FourteenBrush/Classreader"
  "Classreader"
>}}

{{<
  newsletter-img
  "I have made a simple open source lib or package to create plots in the Odin programming language, for line and scatter plots. Maybe latter I extend to histograms, it plots to file or to a image buffer in RGBA, of size_x by size_y , configurable. - JoaoCarvalho"
  "https://cdn.discordapp.com/attachments/568871319425515531/1180927005466824824/imagem.png"
  "https://github.com/joaocarvalhoopen/Plots_in_Odin"
  "Plots in Odin"
>}}

{{<
  newsletter-img
  "Since I want to support IDEA 2023.3, I am releasing 0.3.0 which supports very simple code completion and, of course, JetBrains IDEs until version 2023.3 - obiwan87"
  "https://media.discordapp.net/attachments/568871319425515531/1185548711984635944/image.png"
  "https://plugins.jetbrains.com/plugin/22933-odin-support"
  "Odin Support - IntelliJ IDEs Plugin | Marketplace"
>}}

{{<
  newsletter-img
  "Not much to look at, but a functioning prototype for an automatic differentiation library supporting both scalar and element-wise-array \"Variables\". Here looking at a basic cantilever beam problem and confirming the fundamentals about strength, stiffness, and mass efficiency. - Robot.Jay"
  "https://cdn.discordapp.com/attachments/568871319425515531/1187655416147091476/autodiff_prototype.png"
>}}

{{<
  newsletter-img
  "my new year's weekend project, an x86 disassembler has finally passed the chkstk test! - flysand"
  "https://media.discordapp.net/attachments/568871319425515531/1190918238620614726/image.png"
>}}

### Game Development

{{<
  newsletter-video
  "we've now got dummy record & playback. just needs some more QOL updates, and savestate, and we'll have a functional training mode - Krzysztoφορος"
  "https://cdn.discordapp.com/attachments/568871319425515531/1182250467540086784/2023-12-07_20-20-19.mp4"
>}}

{{<
  newsletter-img
  "Working on a Playstation 1 emulator, having the bios booting (kind of) but no games so far, getting close though - Virror"
  "https://cdn.discordapp.com/attachments/568871319425515531/1186267107311231057/image.png"
>}}

{{<
  newsletter-video
  "Trailer for my game: Cat & Onion. Coming January 2024. Made in Odin + Raylib. Design, programming, art and music by me. - karl_zylinski"
  "https://cdn.discordapp.com/attachments/568871319425515531/1186737229377310811/cat_and_onion_trailer_1_rc2.mp4"
>}}

### Graphics

{{<
  newsletter-video
  "Raylib and a simple parallax cpu shader - Laufeyson"
  "https://cdn.discordapp.com/attachments/568871319425515531/1180719182761951272/IMG_0914.mov"
>}}

{{<
  newsletter-img
  "got a basic software renderer working - Francis_the_cat"
  "https://cdn.discordapp.com/attachments/568871319425515531/1181268316082421910/image.png"
>}}

{{<
  newsletter-video
  "I KNOW VULKAN - Izanth"
  "https://cdn.discordapp.com/attachments/568871319425515531/1185636475304411247/vulkan.mp4"
>}}

{{<
  newsletter-img
  "freetype x opengl font rendering - flysand"
  "https://cdn.discordapp.com/attachments/568871319425515531/1186509125178372156/image.png"
>}}

{{<
  newsletter-img
  "Revamped terrain generation, added ground decorations, added biomes and mountains, first time it actually looks like mc - Chris"
  "https://cdn.discordapp.com/attachments/568871319425515531/1186787966719373382/image.png"
>}}

{{<
  newsletter-img
  "I promise this will be my last spam for the next few days, but finally figured out sparse rendering, this is 4096 chunks, 134 million blocks running at 200+ fps.  Next step is world generation, because this world took 5 minutes to load lol.  Average is about ~3k faces per chunk, down from 200k from dense chunks - Chris"
  "https://cdn.discordapp.com/attachments/568871319425515531/1186886322342863009/image.png"
>}}

{{<
  newsletter-video
  "INSTANCING - Izanth"
  "https://cdn.discordapp.com/attachments/568871319425515531/1187015718596780083/01.1.mp4"
>}}

{{<
  newsletter-img
  "Thanks for the tips, actual culling is way better.  Still working on the proper sorting of indices to render back to front, but the benefit without the sort is awesome anyways - Chris"
  "https://cdn.discordapp.com/attachments/568871319425515531/1187614629149544538/culling.gif"
>}}

{{<
  newsletter-img
  "Drawing 14k sprites before the game goes below 60fps - Izanth"
  "https://cdn.discordapp.com/attachments/568871319425515531/1188532471264989335/image.png"
>}}

{{<
  newsletter-video
  "Made a simple animation in Odin/raylib with seasonal spirit (let's see if the Discord programmers decided to embed a 2.8 MB mp4... edit: they did!) - 10aded"
  "https://cdn.discordapp.com/attachments/568871319425515531/1189401257811648543/2-16.mp4"
>}}

{{<
  newsletter-video
  "Using modern OpenGL AZDO stuff I managed to more than triple the amount of sprites before the game goes below 60 fps! (RX 7600) - Izanth"
  "https://cdn.discordapp.com/attachments/568871319425515531/1190250677134434334/01.10.mp4"
>}}

### Tools & UI

{{<
  newsletter-img
  "Apparently I made a tool that exports fonts as packed bitmap images and also gives you mapping from rune -> rectangle - flysand"
  "https://cdn.discordapp.com/attachments/568871319425515531/1183255965844381717/image.png"
>}}

{{<
  newsletter-video
  "\"microui\" rectcut fun - Skytrias"
  "https://cdn.discordapp.com/attachments/568871319425515531/1184994543905554532/pxPxbYxEO9.mp4"
>}}

{{<
  newsletter-video
  "just wrapped up my first odin project -- full implementation of mustache templates - b3lm0nt"
  "https://cdn.discordapp.com/attachments/568871319425515531/1185300987011940443/demo.mp4"
  "https://github.com/benjamindblock/odin-mustache"
  "odin mustache"
>}}

{{<
  newsletter-video
  "viewer for LMDB + CBOR (upcoming core:encoding/cbor from @laytan) byte blobs, similar to mongoDB compass - Skytrias"
  "https://cdn.discordapp.com/attachments/568871319425515531/1188610980188532869/Peek_2023-12-24_23-31.mp4"
>}}