---
title: September 2023 Newsletter
summary: Highlights for September - Community Showcase ***Categorized***
slug: newsletter-2023-09
author: Michael Kutowski
date: '2023-09-01'
categories:
  - newsletter
  - odin
---

## Compiler Updates 

[Monthly Release](https://github.com/odin-lang/Odin/releases/tag/dev-2023-10) including a few new language features and LLVM 17.0.1 support for windows.

* `or_break`
* `or_continue`
* `#relative [^]T` (relative multi-pointers)
  * Replaced `#relative []T` (relative slices)
  * This data type might be removed in the future

<hr>

## Socials

We'll split up the different social platforms this time around.

* YouTube
  * [Rickard Andersson](https://www.youtube.com/watch?v=VLcTrUhSdlg&list=PLEQTpgQ9eFCGlQa2z0j_TQTGggHOIF8Z1) (`gonz` on Discord) has been uploading a video series about Odin! 

  * [karl_zylinski](https://www.youtube.com/@karl_zylinski) is working on their cat game, uploading videos and streaming ocassionally.

* Twitter
  * [Charlie](https://twitter.com/charshenton) has been posting lot's of content on discord but some of his showcase material lands only on his twitter.

* Blogs
  * karl_zylinski has recently posted a blog on [Hot Reload Gameplay Code](http://zylinski.se/posts/hot-reload-gameplay-code/) in Odin!

<hr>

## Games


<div class="card my-2 shadow">
  <video class="object-fit-cover rounded" muted loop controls src="https://cdn.discordapp.com/attachments/568871319425515531/1155521114722812046/astrodrift.mp4"></video>
  
  <p class="d-flex justify-content-center pt-3">
    Astro Drift is a short roguelike rocket-drifting shooter. Destroy the asteroids to gain score!
  </p>

  <div class="d-flex justify-content-center pb-3">
    <iframe width="552" height="167" frameborder="0" src="https://itch.io/embed/2259099"><a href="https://jakubtomsu.itch.io/astrodrift">Astro Drift by jakubtomsu, Dylan Seibert, Jammigans</a></iframe>
  </div>
</div>

<hr>

## Editors

***Sentient Coffee*** has added support for the [focus editor](https://github.com/focus-editor/focus). Check out the discord [link / explanation](https://discord.com/channels/568138951836172421/568871319425515531/1156585773290762341).

<hr>

## New Bindings / Ports

* [Fractal-Buddhabrot](ttps://github.com/joaocarvalhoopen/Fractal-Buddhabrot-in-Odin) Port of Fractal Buddhabrot - `JoaCarvalho`
OLD
* [pegasus](https://github.com/dvrd/pegasus) Reimplemented golangs `gpeg` - `dvrd`
* [Moog-Ladder-Filter](https://github.com/joaocarvalhoopen/Moog-Ladder-Filter-in-Odin) Moog Ladder Filter - `JoaoCarvalho`
* [nbio](https://github.com/laytan/odin-http/tree/main/nbio) non-blocking IO - `laytan`
* [Piece-Table](https://github.com/xDahl/Piece-Table) Piece-Table in Odin - `xDahl`

<hr>

## New / Updated Packages

I'll try posting the comments the authors posted for their packages.

### Odin Dear ImGui - `L4`

[odin-imgui](https://gitlab.com/L-4/odin-imgui) Generated Dear ImGui bindings using dear_bindings

* Generates bindings for both the `master` and `docking` ImGui branches, using [`dear_bindings`](https://github.com/dearimgui/dear_bindings)
* Contains bindings for most of the Dear ImGui implementations
* All backends which exist in `vendor:` have bindings
* These include: `vulkan, sdl2, opengl3, sdlrenderer2, glfw, dx11, dx12, win32, osx, metal`
* Compiles bindings as well as any wanted backends
* Tested on Windows, Linux, and Mac
* Includes several examples which can be used as a reference
* `GLFW + OpenGL, SDL2 + D3D11, SDL2 + Metal, SDL2 + OpenGL, SDL2 + SDL2 Renderer, SDL2 + Vulkan`


### LBP-Serialization - `jakubtomsu (Jacob)`

[LBP-Serialization](https://github.com/jakubtomsu/odin-lbp-serialization) "I made my LBP serialization code open-source, it's still kinda experimental though."

Here are the benefits of this method:
* single procedure for both serialization and deserialization
* full backwards compatibility is extremely easy
* good control over the exact data layout if necessary
* no RTTI

This is how easy it is to serialize complex datastructures:

```odin
Foo :: struct {
    a:          i32,
    b:          f32,
    name:       string,
}

Bar :: struct {
    foos: [dynamic]Foo,
    data: map[i32]bit_set[0 ..< 8],
}

serialize_foo :: proc(s: ^Serializer, foo: ^Foo, loc := #caller_location) -> bool {
    serialize(s, &foo.a, loc) or_return
    serialize(s, &foo.b, loc) or_return
    serialize(s, &foo.name, loc) or_return
    return true
}

serialize_bar :: proc(s: ^Serializer, bar: ^Bar, loc := #caller_location) -> bool {
    serialize(s, &bar.foos) or_return
    serialize(s, &bar.data) or_return
    return true
}
```

### Getopts - `Pix`
[Getopts](https://github.com/Pix-xiP/getopts) A Odin command line argument parser, loosely based on the `getopts_long`.

```odin
opts := init_opts()
defer deinit_opts(&opts)
{ // Scoping for easy scope of using.
  using optarg_opt
  add_arg(&opts, "flag", .NO_ARGUMENT)
  add_arg(&opts, "opt-argument", .OPTIONAL_ARGUMENT)
  add_arg(&opts, "required", .REQUIRED_ARGUMENT)
  add_arg(&opts, "h", .NO_ARGUMENT, "help") // Alternative name // long_opt
  add_arg(&opts, "m", .OPTIONAL_ARGUMENT, "my_flag_here")

}
getopt_long(os.args, &opts)
// Parse opts:
for opt in opts.opts {
  if ! opt.set do continue // allows to skip non set options.
  switch opt.name { // name will always be set, don't have to check both
    case "flag":
      // Something
    case "required":
      // Something else 
    case:
      // default? Usage!
  }  
}
```

<hr>

## Categories

This month we'll do categories again. 

* Game Development
* Graphics
* Tools & UI
* Miscellaneous

### Game Development

{{<
  newsletter-img
  "Took some time to recreate the Playdate Hello World from the official C_API examples - Colin Bellino"
  "https://media.discordapp.net/attachments/568871319425515531/1146935058465304606/simulator.png"
>}}

{{<
  newsletter-video
  "Writing areas to underlying grid and handling edge-cases - _brian"
  "https://cdn.discordapp.com/attachments/568871319425515531/1147571737857376397/write_area_and_handle_edges.mp4"
>}}

{{<
  newsletter-video
  "Made a lil spline editor that uses cubic bézier curves :3 - karl_zylinski"
  "https://cdn.discordapp.com/attachments/568871319425515531/1149339866463731782/2023-09-07_15-38-21.mp4"
>}}

{{<
  newsletter-video
  "Odin-ifing the Playdate bindings, including documentation! - Mungo_"
  "https://cdn.discordapp.com/attachments/568871319425515531/1149579299523928134/PlaydateSimulator_87e1JZHaXp.mp4"
>}}

{{<
  newsletter-video
  "goofing around with postfx in my game/engine. Vignette + scuffed pixelator - The Lua Whisperer"
  "https://cdn.discordapp.com/attachments/568871319425515531/1149735588090609674/QaLCBG63Pl.mp4"
>}}

{{<
  newsletter-img
  "Gonna be transferring my game over to Odin, I really just need a refreshing language, and after using it, felt pretty darn great to write in. - Mezo☆"
  "https://cdn.discordapp.com/attachments/568871319425515531/1150961171575353475/image-1.png"
>}}

{{< newsletter-youtube "e8K6sCrmy4Q" >}}

{{<
  newsletter-img
  "Hell, GUI is a pain, got it to be somewhat pleasant to work with now... - Francis_the_cat"
  "https://cdn.discordapp.com/attachments/568871319425515531/1155967392564912238/image.png"
>}}

{{<
  newsletter-video
  "Latest cat game developments. Lots of new graphics and the interaction system is quite useful now."
  "https://cdn.discordapp.com/attachments/568871319425515531/1156153894519447563/trailer_1.mp4"
>}}

{{<
  newsletter-video
  "Super basic physics demo based off this repo - master jonsie"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156461782903296142/org.cshenton.questodin-20230925-202509.mp4"
>}}

{{<
  newsletter-video
  "Before vs after comparison of new art style! The new style uses only 8 colors 🎨 - karl_zylinski"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156882453001162822/trailer_new_comp_12.mp4"
>}}

### Graphics

{{<
  newsletter-video
  "Been wanting to write a point cloud renderer... but this isn't that, it's just GL_POINTS. - Charlie"
  "https://cdn.discordapp.com/attachments/568871319425515531/1147077104920449075/ply_60.mp4"
>}}

{{<
  newsletter-video
  "Odin running on the Quest 2 - Charlie"
  "https://cdn.discordapp.com/attachments/568871319425515531/1148516683019989052/odin_quest.mp4"
  "https://github.com/cshenton/odin-quest"
  "Github"
>}}

{{<
  newsletter-img
  "finally got object parenting working, and playing around with some environment lighting - Akuspel"
  "https://cdn.discordapp.com/attachments/568871319425515531/1149721652804976651/gl.gif"
>}}

{{<
  newsletter-img
  "Some environment lighting and reflections that don't look completely horrible - Akuspel"
  "https://cdn.discordapp.com/attachments/568871319425515531/1150173750784950432/gl.gif"
>}}

{{<
  newsletter-img
  "Made some good progress porting/rewriting my Game in Odin. Here is a diffuse lighting test. - Moritz Falk"
  "https://media.discordapp.net/attachments/568871319425515531/1155170232655163482/DiffuseLightingProgress.png"
>}}

{{<
  newsletter-img
  "Shadow Maps - Jesse"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156352276034748526/sm.jpg"
>}}

### Tools & UI

{{<
  newsletter-img
  "Spent today working on writing my own UI system - _brian"
  "https://cdn.discordapp.com/attachments/568871319425515531/1147751924372877373/image.png"
>}}

{{< newsletter-youtube "MQ6_eiIAK8c?si=KgN7ul_ufe2fuxpC" >}}

{{<
  newsletter-img
  "Line Input project: focused on making the input responsive, smooth and appealing - Volatus"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156073726748655696/2023-09-26_00-34-52.mp4"
>}}

{{<
  newsletter-video
  "My project for the Wheel Reinvention Jam is entirely in Odin, and it's been very delightful - Stvff"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156741622151774208/Peek_2023-09-28_01-32.mp4"
>}}

### Miscellaneous

{{<
  newsletter-img
  "Working on implementing UEFI in Odin! & it's open source right now for you to try! - slendi"
  "https://cdn.discordapp.com/attachments/568871319425515531/1156349244282773514/image.png"
  "https://git.xslendi.xyz/slendi/odin-efi"
  "gitea"
>}}

{{<
  newsletter-video
  "added GOP (Graphics Output Protocol) support to UEFI implementation - slendi"
  "https://cdn.discordapp.com/attachments/1059202257175973888/1156650767365718106/2023-09-27_20-56-10.mp4"
>}}
