---
title: November 2022 Newsletter
summary: Release Note Highlights & Interview with ***Skytrias***, author of ***Todool***
slug: newsletter-2022-11
author: Jeroen van Rijn
date: '2022-11-02'
categories:
  - newsletter
  - odin
  - todool
  - c
---

## Release note highlights
* `raw_data` was made an intrinsic, resulting in a speedup for slice heavy code.
* `transmute` can now be used on integer constants of the same internal endianness.
* `Static_Arena` and `Growing_Arena` have been unified into `Arena`, along with many other improvements to `core:mem/virtual`.
* Heavily improve time handling on Windows for `time.now()` and `os.File_Info`.
* And [much more](https://github.com/odin-lang/Odin/releases/tag/dev-2022-11)!

## Interview with Skytrias, author of Todool

Q: Why don't we begin with you telling us a bit about how you found out about [Odin](https://odin-lang.org).

A: I watched [Handmade Hero](https://handmadehero.org) and found the [Handmade Network site](https://handmade.network) - which hosted a bunch of projects.
After some game development I wanted to try making my own engine like Handmade Hero did but didn't like C - so I searched through Handmade Network for some system languages. 
That's where I found out about [Odin](https://odin.handmade.network/)'s. 🙂

Q: And what attracted you to it?

A: GB linked to some YouTube videos where he went through several features and you can see how clean the language already was back then.

Q: And so you gave it a real punt. Fast forwarding, you started working on [Todool](https://todool.handmade.network/). Did you decide to write Todool in Odin because you were comfortable with the language, as an extended exercise to improve your mastery of the language, a bit of both? And were there other factors that made you choose Odin for what is intended to be a commercial project?

A: In 2020 I went back and forth between Rust and Odin for several small games/clones I did. Ever since then I stuck with Odin - so I had prior experience with it before I started working on Todool.

The thing I like about Odin is how simple it is to use. You can keep all of it in your head and make use of its core library - which follows the simplicity of Handmade Hero.

Another thing I liked was the simple compiler commands (build | run | check) and the lack of a package manager.

Nowadays I really appreciate the C binding model in Odin but also how close to C code looks when ported over from it in entirety (like single-header stb libraries).

Q: What would you say your favorite thing about Odin is, and what would you say could be improved? This could be a feature, syntax, the community, documentation, tooling, anything and everything related to working with Odin that you really like and think could use some love, respectively, and why?

A: Definitely the [core](https://pkg.odin-lang.org/core/) library. You have all the power at your fingertips - from doing various encodings, string manipulation, formatting, etc. 

The core library could also use some *more* love/help from the community. There are a few unfinished packages and code that needs more fixing/testing.

Q: We've enjoyed your Todool progress updates in `#showcase` on our [Discord](https://discord.com/invite/sVBPHEv) and your [YT channel](https://www.youtube.com/c/Skytrias/videos). Is there a site people can pre-order it at?

A: Todool will be available soon on https://skytrias.itch.io/todool

The bigger tasks on the Todool roadmap are: 
* Date/Time management
* Agenda View
* Improved searching/pattern matching through regex (new core library)
* Filtering system of tasks
* Performance optimization on large files
* And more!

Q: Was there anything you wanted to say about Odin or Todool in addition to this? Any sage advice to newcomers to the language?

A: I'm pretty happy with Odin as a whole. I wish we had more compiler developers so it would make GB's life easier. 

The best way to currently learn Odin is to dive through the [overview](https://odin-lang.org/docs/overview) and try out the core library packages. I'd recommend starting a few small projects with all the knowledge you gain after each iteration.

From **cstring:**
| To | Action | Code |
| --- | --- | --- | 
| `string` | ***alias*** | `string(st)` |
| `[^]u8` | ***alias*** | `transmute([^]u8)st` |