<h1 align="center">
  <a href="https://ocean-ds.github.io/ocean-web/index.html">
    <img alt="ocean-logo" src="https://user-images.githubusercontent.com/3240432/130073671-e62059a3-19f5-47bd-8ce8-db66b3240eb7.png" width="400">
  </a>
</h1>

<p align="center">
  The design system made by <a href="https://www.useblu.com.br/sobre">Blu</a>
</p>

<p align="center">
  <a href="https://github.com/ocean-ds/ocean-web/actions">
    <img alt="Actions Status" src="https://github.com/ocean-ds/ocean-web/workflows/CI/badge.svg">
  </a>
  <a href="https://codecov.io/gh/ocean-ds/ocean-web">
    <img src="https://codecov.io/gh/ocean-ds/ocean-web/branch/master/graph/badge.svg"/>
  </a>
  <a href="https://sonarcloud.io/dashboard?id=ocean-ds_ocean-web">
    <img alt="Sonarcloud Status" src="https://sonarcloud.io/api/project_badges/measure?project=ocean-ds_ocean-web&metric=alert_status">
  </a>
  <a href="https://github.com/ocean-ds/ocean-web/blob/master/LICENSE">
    <img alt="GitHub License" src="https://img.shields.io/github/license/ocean-ds/ocean-web">
  </a>
  <a href="https://github.com/ocean-ds/ocean-web/graphs/commit-activity">
    <img alt="GitHub last commit" src="https://img.shields.io/github/last-commit/ocean-ds/ocean-web">
  </a>
  <a href="https://github.com/ocean-ds/ocean-web/network/updates">
    <img alt="Dependabot" src="https://img.shields.io/badge/Dependabot-enabled-brightgreen">
  </a>
  <a href="https://github.com/prettier/prettier">
    <img alt="Prettier code style" src="https://img.shields.io/badge/code_style-prettier-ff69b4.svg">
  </a>
  <a href="https://lerna.js.org/">
    <img alt="Lerna" src="https://img.shields.io/badge/maintained%20with-lerna-cc00ff.svg">
  </a>
  <a href="https://conventionalcommits.org">
    <img alt="Conventional Commits" src="https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg">
  </a>
  <a href="http://makeapullrequest.com">
    <img alt="Conventional Commits" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg">
  </a>
  <a href="https://discord.gg/hDWzGPKuG2">
    <img alt="Discord Server" src="https://img.shields.io/discord/875438252172136468.svg?color=7389D8&labelColor=6A7EC2&logo=discord&logoColor=ffffff">
  </a>
</p>

This project is composed of many npm packages for building web apps with [Ocean](https://zeroheight.com/9c9b2b3aa/p/257272-ocean-ds/t/968532) design system.

## Documentation

Documentation and examples can be found [here](https://ocean-ds.github.io/ocean-web/index.html).

## Get Started

To run the project, first install the packages:

```bash
yarn install
```

Then run the project with watch:

```bash
yarn watch:storybook
```

Or run the project without watch:

```bash
yarn run storybook
```

If you changed or added CSS, run this:

```bash
yarn watch:css
```

## Packages

| Package                                              | Version                                                           | Description                                            |
| ---------------------------------------------------- | ----------------------------------------------------------------- | ------------------------------------------------------ |
| [`@useblu/ocean-core`](packages/ocean-core#readme)   | ![npm (scoped)](https://img.shields.io/npm/v/@useblu/ocean-core)  | UIkit css that implement Ocean's Design System.        |
| [`@useblu/ocean-react`](packages/ocean-react#readme) | ![npm (scoped)](https://img.shields.io/npm/v/@useblu/ocean-react) | React components that implement Ocean's Design System. |

## Contributing

Whether you're helping us fix bugs, improve the docs, or spread the word, we'd love to have you as part of this project! :blue_heart: Read below to learn how you can take part of it.

### Code of Conduct

We adopted a Code of Conduct that we expect project participants to adhere to. Please read [the full text](.github/CODE_OF_CONDUCT.md) so that you can understand what actions will and will not be tolerated.

### Contributing Guide

Read our [contributing guide](.github/CONTRIBUTING.md) to learn about our development process, how to propose bugfixes and improvements, and how to build and test your changes.

### Good First Issues

To help you get your feet wet and get you familiar with our contribution process, we have a list of [good first issues](https://github.com/ocean-ds/ocean-web/labels/good%20first%20issue) that contain bugs which have a relatively limited scope. This is a great place to get started.

## Join our community

Join our [discord server](https://discord.gg/hDWzGPKuG2) to get the latest updates, chat with other Ocean enthusiasts, and see what's happening in the community!

## License

All packages are licensed under the terms of the [GPL-3.0 License](LICENSE).

## Related Projects

- [Design tokens for the Blu design system](https://github.com/ocean-ds/ocean-tokens)
- [SVG icons for Ocean DS](https://github.com/ocean-ds/ocean-icons)
