export default {
  '2fa': {
    name: '2FA',
    title: 'Authentification à deux facteurs',
  },
  app_configuration: {
    name_hint: "Un nom pour l'application qui représente votre organisation.",
    public_url_hint: "L'URL publique de l'application. Cette URL est utilisée pour générer des liens dans les e-mails et les notifications.",
    logout_url_hint: 'Rediriger les utilisateurs vers cette URL après la déconnexion.',
    languages_hint: 'Les langues disponibles pour les dictionnaires.',
    default_charset_hint: 'Le jeu de caractères par défaut pour les dictionnaires.',
    enforced_2fa_hint: "Activer l'authentification à deux facteurs pour tous les utilisateurs. Ne s'applique pas aux utilisateurs de registres extérieurs.",
    allow_r_packages_management: 'Gestion des paquets R autorisée',
    allow_r_packages_management_hint: 'Autoriser les administrateurs à installer, mettre à jour et à supprimer des paquets R dans les sessions R. Non recommandé pour les environnements de production.',
  },
  apps: {
    title: 'Applications',
    caption: 'Gérer les applications externes fournissant des services',
    info: "Une application est un service externe qui peut être utilisé par le système. Les applications peuvent être découvertes à partir de leur URL ou peuvent s'enregistrer elles-mêmes en utilisant le jeton d'authentification de l'application.",
    registry_list: 'Registre des Applications',
    discovery_info: "Les applications peuvent être découvertes à l'exécution (voir documentation {url}). Lorsqu'elles sont découvertes, l'application est automatiquement enregistrée. Ensuite, des vérifications périodiques sont effectuées : si l'application ne peut pas être atteinte ou se déclare dysfonctionnelle, elle est automatiquement désenregistrée.",
    apps_admin: 'Administration des Applications',
    rock_info: "Rock est un serveur R avec une API REST (voir projet {url}). Ajouter plus d'instances d'applications Rock permet de renforcer la capacité d'analyse R.",
    host_hint: 'URL pour se connecter au serveur Rock, requis.',
    unregister_confirm: "Veuillez confirmer que vous souhaitez désenregistrer l'application '{app}'. Certaines fonctionnalités du système peuvent être dégradées.",
    remove_config_confirm: "Veuillez confirmer que vous souhaitez supprimer la découverte du serveur R Rock situé à '{host}'. Notez que cela n'affectera pas les applications correspondantes qui auraient déjà été enregistrées.",
    add_service: 'Ajouter une app à découvrir',
    edit_service: "Modifier l'app à découvrir",
    manager_user: 'Gestionnaire et Utilisateur',
    credential_hints: {
      default: "Les identifiants Rock sont les identifiants par défaut, tels que définis dans le fichier de configuration principal d'Opal.",
      administrator: "Les identifiants Rock sont ceux d'un utilisateur avec un rôle d'administrateur. Ils seront utilisés à la fois pour gérer le serveur (démarrage/arrêt, paquets R, etc.) et pour créer de nouvelles sessions R.",
      manager_user: "Un identifiant Rock pour gérer le serveur (démarrage/arrêt, paquets R, etc.) et un autre pour créer de nouvelles sessions R. Avoir ces deux rôles d'utilisateur différents permet de restreindre les privilèges des utilisateurs dans les sessions R.",
    },
    name_hint: "Nom de l'utilisateur Rock avec le rôle '{type}'.",
    password_hint: "Mot de passe de l'utilisateur Rock avec le rôle '{type}'.",
    self_register: 'Auto-enregistrement',
    self_register_info: "Pour s'enregistrer, une application doit fournir le jeton d'enregistrement suivant dans sa demande (voir documentation {url}).",
    token_hint: 'Un secret',
    edit_token: 'Modifier le Jeton',
  },
  auth: {
    title: 'Identifiez-vous pour commencer une session',
    password: 'Mot de passe',
    signin: 'Se connecter',
    signout: 'Se déconnecter',
    username: "Nom d'utilisateur",
    totp_help: "Ouvrir l'application mobile d'authentification et scanner ce code QR pour initialiser votre générateur de code NIP.",
    code: 'Code',
    code_hint: 'Entrer le code à 6 chiffres.',
    validate: 'Valider',
  },
  auth_types: {
    PASSWORD: 'Mot de passe',
    CERTIFICATE: 'Certificat',
    UNRECOGNIZED: 'Non reconnu',
  },
  command_types: {
    import: 'Importer',
    export: 'exporter',
    copy: 'Copier',
    analyse: 'Analyser',
    import_vcf: 'Importer VCF',
    export_vcf: 'Exporter VCF',
    backup: 'Sauvegarde',
    restore: 'Restaurer',
  },
  db: {
    data_databases: 'Bases de données de données',
    data_databases_info: 'Les bases de données de données sont utilisées pour stocker les données et les dictionnaires des tables.',
    id_database: "Base de données d'identifiants",
    id_database_info: "La base de données d'identifiants est utilisée pour stocker les différents identifiants des entités.",
    name_hint: 'Le nom de la base de données doit être unique.',
    usage_hint: 'Détermine si la base de données est utilisée pour stocker les données ou pour importer/exporter des données.',
    driver: 'Pilote',
    driver_hint: 'Détermine comment établir la connexion avec la base de données.',
    batch_size: 'Taille du lot',
    batch_size_hint: 'Le nombre maximum de lignes à traiter en une seule fois.',
    register_sqldb: 'Enregistrer une base de données SQL',
    register_mongodb: 'Enregistrer une base de données MongoDB',
    unregister: 'Retirer',
    unregister_confirm: "Êtes-vous sûr de vouloir supprimer la base de données '{name}' ? Notez que les données NE SERONT PAS supprimées.",
    test_error: 'Test de connexion échoué',
    test_success: 'Test de connexion réussi',
    in_use: 'Utilisée',
    default_entity_type: "Type d'entité par défaut",
    default_entity_type_hint: "Type d'entité par défaut pour les tables nouvellement créées.",
    default_id_column: "Colonne d'identifiant",
    default_id_column_hint: "Le nom de la colonne d'identifiant des entités. Assurez-vous qu'il ne sera pas en conflit avec un nom de variable.",
    default_updated_column: 'Colonne de mise à jour',
    default_updated_column_hint: "Le nom de la colonne contenant la date de mise à jour des entités, requis pour effectuer des imports incrémentaux. Assurez-vous qu'il ne sera pas en conflit avec un nom de variable.",
    use_metadata_tables: 'Avec les tables de variables',
    use_metadata_tables_hint: 'Exporter les dictionnaires de données dans les tables de méta-données.',
    save_error: "Erreur lors de l'enregistrement de la base de données",
  },
  clipboard: {
    copy: 'Copier dans le presse-papiers',
    copied: 'Texte copié dans le presse-papiers !',
    copy_error: 'Échec de la copie du texte dans le presse-papiers',
  },
  datashield: {
    access_not_restricted: 'Tous les utilisateurs DataSHIELD peuvent accèder à ce profil.',
    access_restricted: 'Seuls les utilisateurs DataSHIELD autorisés peuvent accèder à ce profil.',
    aggregate_methods_info: "Les méthodes d'agrégation sont utilisées par DataSHIELD afin de compiler des données individuelles. Les mêmes méthodes d'agrégation doivent être définies dans chaque serveur DataSHIELD qui sera impliqué dans un processus de calcul. Chaque méthode d'agrégation est identifiée par un nom qui sera utilisé depuis le client DataSHIELD.",
    assign_methods_info: "Les méthodes d'affectation sont utilisées par DataSHIELD afin de transformer des données individuelles côté serveur. Les mêmes méthodes d'affectation doivent être définies dans chaque serveur DataSHIELD qui sera impliqué dans un processus de calcul. Chaque méthode d'affectation est identifiée par un nom qui sera utilisé depuis le client DataSHIELD.",
    audit: 'Audit',
    audit_info: "Le journal de l'activité Datashield peut être téléchargé.",
    caption: "Configurer DataSHIELD, accorder l'accès au service DataSHIELD",
    delete_methods_confirm: '- | Êtes-vous sûr de vouloir supprimer cette méthode DataSHIELD ? | Êtes-vous sûr de vouloir supprimer ces {count} méthodes DataSHIELD ?',
    delete_options_confirm: ' - | Êtes-vous sûr de vouloir supprimer cette option DataSHIELD ? | Êtes-vous sûr de vouloir supprimer ces {count} options DataSHIELD ?',
    download_all_logs: 'Télécharger tous les logs',
    download_latest_logs: 'Télécharger les derniers logs',
    method_func_hint: "La fonction R étant effectivement appellée côté serveur. Assurez vous qu'il n'y a pas d'ambiguité en spécifiant le paquet R dans lequel elle est définie.",
    method_name_hint: "Le nom de la méthode DataSHIELD doit être unique. C'est le nom de la fonction autorisée pouvant être appelée par un client DataSHIELD.",
    method_script_hint: 'Le code de la fonction R adhoc qui sera appelée.',
    option_name_hint: "Nom de l'option R.",
    option_value_hint: "Valeur de l'option R. Une syntaxe R est attendue : par exemple utiliser des guillemets pour les chaînes de caractère.",
    options_info: 'Les options R sont appliquées lors de la création de la session DataSHIELD et affectent le comportement de certaines méthodes DataSHIELD.',
    packages_info: 'Les paquets DataSHIELD sont des paquets R qui fournissent des fonctionnalités DataSHIELD. Ils sont installés sur les serveurs R et sont utilisés sont utiliséspar les clients DataSHIELD pour effectuer des analyses.',
    profile_cluster_hint: 'Le cluster de serveurs R pour ce profil DataSHIELD.',
    profile_delete_confirm: 'Êtes-vous sûr de vouloir supprimer ce profil DataSHIELD ?',
    profile_missing_cluster: "Le cluster de serveurs R pour ce profil DataSHIELD n'existe pas.",
    profile_name_hint: "Le nom du profil DataSHIELD doit être unique. C'est le nom qui sera utilisé par le client DataSHIELD pour démarrer une session DataSHIELD.",
    profile_settings_help: "Les paramètres du profil DataSHIELD sont utilisés pour définir les méthodes d'agrégation/affectation qui peuvent être appelées par un client DataSHIELD et les options R qui seront appliquées à la session DataSHIELD du serveur R.",
    profile_access_toggle: "Restreindre l'utilisation de ce profil",
    profile_status_toggle: 'Activer or désactivater le profil',
    profiles_info: 'Un profil DataSHIELD est associé à un cluster de serveurs R: les méthodes et options extraits des paquets DataSHIELD installés définissent la configuration du profil. Celle-ci peut être modifiée par la suite. ',
    settings_init_help: 'Selectionner quels paquets DataSHIELD auront leurs méthodes et options appliqués à ce profil.',
    settings_init: 'Initialiser la configuration DataSHIELD du profil à partir des paquets DataSHIELD sélectionnés',
  },
  error: {
    Forbidden: "L'operation est interdite",
    NoSuchValueTableInDatasource: "La table n'existe pas ou vous n'y avez pas accès",
    PasswordTooWeak: 'Mot de passe trop faible',
    OldPasswordMismatch: "L'ancien mot n'est pas valide",
    IllegalArgument: 'Données non valides',
    Conflict: 'Conflit détecté',
    BannedUser: "Trop d'erreurs d'identification, l'utilisateur {0} est banni pour une durée de {1} secondes",
    InvalidCredentials: "Nom d'utilisateur ou mot de passe incorrect, veuillez réessayer",
    TableAlreadyExists: 'La table existe déjà',
    MagmaRuntimeException: 'Erreur de traitement des données: {0}',
    DuplicateIDProvider: "Le fournisseur d'identité existe déjà",
    DuplicateSubjectToken: 'Le jeton existe déjà',
    DuplicateTaxonomy: 'La taxonomie existe déjà',
    TaxonomyImportFailed: "L'importation de la taxonomie a échoué, assurez-vous de fournir des informations valides",
    NoSuchTaxonomy: "La taxonomie n'existe pas",
    NoSuchProject: "Le projet n'existe pas",
    SQLError: "Une erreur SQL s'est produite lors de l'exécution de la requête, veuillez vérifiez sa syntaxe",
    NoSuchVariableInTable: "La variable n'existe pas dans la table",
    AccessDeniedToTableValues: "L'accès aux valeurs de la table est refusé",
  },
  identity_provider: {
    title: "Fournisseur d'identité",
    name_hint: "Un nom unique pour le fournisseur d'identité.",
    account_login: 'Connexion au compte',
    client_id: 'ID client',
    client_id_hint: "Identification du serveur Opal dans le fournisseur d'ID.",
    secret: 'Secret client',
    secret_hint: "Jeton secret du serveur Opal dans le fournisseur d'ID.",
    discovery_uri: 'URI de découverte',
    discovery_uri_hint: '{url} pour obtenir automatiquement les paramètres de connexion.',
    discovery_uri_definition: 'URI de découverte de la configuration OpenID Connect',
    label_hint: "Label du fournisseur d'ID à afficher dans le bouton de connexion.",
    provider_url: 'Connexion au compte',
    provider_url_hint: "Lien vers la page de connexion au compte afin que l'utilisateur puisse gérer ses informations d'identification.",
    groups_hint: "Liste de noms de groupes séparés par des espaces qui seront appliqués à chaque utilisateur qui signe à partir de ce fournisseur d'ID.",
    username_claim: "Mappage du nom d'utilisateur",
    username_claim_hint: 'Nom facultatif de la revendication dans le jeton d\'identification et dans la réponse UserInfo dont la valeur représentera le nom d\'utilisateur dans Opal. S\'il n\'est pas explicitement spécifié (ou introuvable), le nom d\'utilisateur sera recherché avec les revendications dans l\'ordre suivant: "preferred_username", "username", "email", "name" et "sub" (sujet ID).',
    scope: 'Portée',
    scope_hint: 'Liste des noms de portée à spécifier pour récupérer les informations utilisateur. Habituellement, {openid} suffit et constitue la valeur par défaut.',
    groups_mapping: 'Mappage des groupes',
    groups_claim: 'Par valeur de revendication',
    groups_claim_hint: 'Nom facultatif de la revendication (non standard) dans la réponse UserInfo qui représente les groupes auxquels appartient l\'utilisateur. Ces groupes seront appliqués à l\'utilisateur authentifié. La valeur de cette revendication peut être un tableau de chaînes ou une chaîne de noms de groupes séparés par des virgules ou des espaces. Les valeurs par défaut sont "groupes".',
    groups_javascript: 'Par javascript',
    groups_javascript_hint: "Un javascript personnalisé facultatif pour extraire le tableau de noms de groupes de l'objet UserInfo. Permet de s'adapter aux réclamations non standards et de transformer les valeurs en noms de groupes Opal. Ces groupes seront appliqués à l'utilisateur authentifié.",
    use_nonce: "{url} pour valider le jeton d'identification.",
    use_nonce_definition: 'Utiliser Nonce',
    use_logout: "{url} pour vous déconnecter d'Opal et du fournisseur d'ID.",
    use_logout_definition: 'Utiliser le point de terminaison de déconnexion',
    connect_timeout: "Délai d'expiration de la connexion",
    connect_timeout_hint: "Durée maximale d'attente avant qu'une connexion soit établie, en millisecondes. Zéro n'implique aucun délai d'attente.",
    read_timeout: 'Délai de lecture',
    read_timeout_hint: "Durée maximale d'attente avant la réception d'une réponse, en millisecondes. Zéro n'implique aucun délai d'attente.",
    callback_url: 'URL publique',
    callback_url_hint: "Dans le cas où Opal est accessible à partir de différentes URL publiques, il est possible de spécifier laquelle doit être utilisée pour ce fournisseur d'ID. Lorsqu'elle n'est pas spécifiée, l'URL publique du système s'applique. Notez que ce fournisseur d'ID ne sera visible que lorsque l'URL de base Opal correspond à cette URL publique.",
  },
  importer: {
    file: {
      csv: 'Ce format s\'attend à ce que le fichier utilise un format "valeurs séparées par des délimiteurs" (le délimiteur par défaut étant la virgule). La première colonne doit représenter les identifiants des participants et les noms de colonnes suivantes identifient les variables.',
      opal: "Ce format se présente sous la forme d'un fichier .zip contenant un dossier pour chaque table contenant : le dictionnaire de données complet dans un fichier XML, un fichier de données XML par entité.",
      haven_rds: "Ce format s'attend à ce que le fichier soit un fichier RDS valide contenant un objet R de classe tibble. Cette procédure d'importation nécessite un serveur R fonctionnel avec le paquet tibble installé.",
      haven_sas: "Ce format s'attend à ce que le fichier soit un fichier SAS valide contenant les variables et les données. Cette procédure d'importation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_sast: "Ce format s'attend à ce que le fichier soit un fichier de transport SAS valide contenant les variables et les données. Cette procédure d'importation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_spss: "Ce format s'attend à ce que le fichier soit un fichier SPSS valide, éventuellement compressé, contenant les variables et les données. Cette procédure d'importation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_stata: "Ce format s'attend à ce que le fichier soit un fichier Stata valide contenant les variables et les données. Cette procédure d'importation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
    },
    server: {
      opal: 'Ce format importe des dictionnaires de variables et des données depuis un Opal distant.',
    },
    id_mappings: {
      hint: "Lorsqu'un mappage d'identifiants est sélectionné, chaque identifiant dans les données importées sera mappé à un identifiant système. Sinon, l'identifiant importé sera ajouté aux identifiants système.",
      mapping_default: "Par défaut, chaque identifiant doit être mappé avant l'importation",
      mapping_default_hint: "L'importation échouera si un identifiant importé n'est pas mappé à un identifiant système.",
      mapping_ignore: "Ignorer les identifiants inconnus lors de l'importation",
      mapping_ignore_hint: "Les données dont l'identifiant ne peut pas être mappé à un identifiant système ne seront pas importées.",
      mapping_allow: 'Générer un identifiant système pour chaque identifiant importé inconnu',
      mapping_allow_hint: 'Un identifiant système sera généré pour chaque identifiant importé inconnu.',
    },
  },
  exporter: {
    file: {
      csv: 'Ce fichier utilisera un format "valeurs séparées par un délimiteur" (le délimiteur par défaut étant la virgule). La première colonne représente les identifiants et le nom des colonnes subséquentes représente chaque variable.',
      opal: 'Ce format sera un fichier .zip, contenant un dossier pour chaque table ayant : le dictionnaire de données complet dans un fichier XML, un fichier de données XML par entité.',
      haven_rds: "Ce fichier sera au format RDS, contenant un objet R de classe tibble. Cette procédure d'exportation nécessite un serveur R fonctionnel avec le paquet tibble installé.",
      haven_sas: "Ce fichier sera au format SAS, contenant les variables et les données. Cette procédure d'exportation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_sast: "Ce fichier sera au format SAS Transport, contenant les variables et les données. Cette procédure d'exportation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_spss: "Ce fichier sera au format SPSS, contenant les variables et les données. Cette procédure d'exportation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
      haven_stata: "Ce fichier sera au format Stata, contenant les variables et les données. Cette procédure d'exportation nécessite un serveur R fonctionnel avec les paquets tibble et haven installés.",
    },
  },
  access: {
    undefined: '[tous]',
    DEFAULT: 'Défaut',
    READ: 'Lecture seulement',
    READ_NO_VALUES: 'Lecture seulement, sans données individuelles',
  },
  acls: {
    // global permissions
    PROJECT_ADD: {
      label: 'Ajouter des projets',
      description: 'Ajouter de nouveaux projets et ainsi pouvoir importer/exporter des données dans ces projets.',
    },
    PROJECT_ALL: {
      label: 'Administrer le project',
      description: 'Accès complet au projet',
    },
    SYSTEM_ALL: {
      label: 'Administrer le système',
      description: 'Accès complet à toutes les ressources du système (utilisateurs de confiance uniquement !).',
    },
    // r service
    R_USE: {
      label: 'Utiliser le service R',
      description: "Pouvoir assigner les données accessibles dans une session R et executer n'importe quel commande R (utilisateurs de confiance uniquement !).",
    },
    // datashield service
    DATASHIELD_USE: {
      label: 'Utiliser le service DataSHIELD',
      description: 'Pouvoir assigner les données accessibles dans une session R et executer les commandes prédifinies.',
    },
    DATASHIELD_ALL: {
      label: 'Administrer le service DataSHIELD',
      description: 'Administrer la configuration de DataSHIELD.',
    },
    // datashield profile
    DATASHIELD_PROFILE_USE: {
      label: 'Utiliser le profil DataSHIELD',
      description: 'Pouvoir assigner les données accessibles dans une session R et executer des commandes dans le contexte de ce profil DataSHIELD.',
    },
    // datasource permissions
    DATASOURCE_VIEW: {
      label: 'Voir le dictonnaire et les données de toutes les tables',
      description: 'Accès en lecture des tables du projet, incluant les données individuelles.',
    },
    TABLE_ADD: {
      label: 'Ajouter des tables',
      description: 'Ajouter de tables ou des vues.',
    },
    DATASOURCE_ALL: {
      label: 'Administrer les tables',
      description: "Accès complet aux tables du projet, incluant l'édition des dictionnaire et des données individuelles.",
    },
    // table permissions
    TABLE_READ: {
      label: 'Voir le dictionnaire et les sommaires de la table',
      description: "Voir le dictionnaire et les sommaires (pas d'accès aux données individuelles).",
    },
    TABLE_VALUES: {
      label: 'Voir le dictionnaire et les valeurs de la table',
      description: 'Voir le dictionnaire et les données individuelles.',
    },
    TABLE_EDIT: {
      label: 'Éditer le dictionnaire et voir les sommaires de la table',
      description: "Éditer le dictionnaire et voir les sommaires (pas d'accès aux données individuelles).",
    },
    TABLE_VALUES_EDIT: {
      label: 'Éditer le dictionnaire et voir les valeurs de la table',
      description: 'Éditer le dictionnaire et voir les données individuelles.',
    },
    TABLE_ALL: {
      label: 'Administrer la table',
      description: "Accès complet à la table, incluant l'édition du dictionnaire et des données individuelles.",
    },
    // variable permissions
    VARIABLE_READ: {
      label: 'Voir avec le sommaire de la variable',
      description: "Voir la description de la variable et le sommaire des données (pas d'accès aux données individuelles).",
    },
    // file permissions
    FILES_READ: {
      label: 'Accéder aux fichiers',
      description: "Accéder à des fichiers sans avoir la permission d'en ajouter ou d'en supprimer.",
    },
    FILES_SHARE: {
      label: 'Ajouter et accéder à des fichiers',
      description: "Ajouter et accéder à des fichiers sans avoir l'autorisation de les supprimer.",
    },
    FILES_ALL: {
      label: 'Administrer lesfichiers',
      description: 'Accès complet aux fichiers.',
    },
    // resource permissions
    RESOURCE_ALL: {
      label: 'Administrer',
      description: 'Accès complet à la ressource.',
    },
    RESOURCES_ALL: {
      label: 'Administrer',
      description: 'Accès complet aux ressources du projet.',
    },
    RESOURCE_VIEW: {
      label: 'Voire la ressource (sans les identifiants associés)',
      description: 'Voir la ressource sans avoir accès aux identifiants associés (permission conforme à DataSHIELD).',
    },
    RESOURCES_VIEW: {
      label: 'Voire les ressources (sans les identifiants associés)',
      description: 'Voir les ressources sans avoir accès aux identifiants associés (permission conforme à DataSHIELD).',
    },
    // database permissions
    DATABASES_ALL: {
      label: 'DATABASES_ALL',
      description: 'DATABASES_ALL',
    },
    // vcf permissions
    VCF_STORE_ALL: {
      label: 'Administrer le magasin VCF',
      description: 'VCF_STORE_ALL',
    },
    VCF_STORE_VALUES: {
      label: 'Visualiser les données et les statistiques des fichiers VCF',
      description: 'VCF_STORE_VALUES',
    },
    VCF_STORE_VIEW: {
      label: 'Afficher les statistiques des fichiers VCF',
      description: 'VCF_STORE_VIEW',
    },
  },
  analysis_status: {
    IN_PROGRESS: 'En cours',
    PASSED: 'Réussi',
    FAILED: 'Échoué',
    ERROR: 'Erreur',
    IGNORED: 'Ignoré',
    UNRECOGNIZED: 'Non reconnu',
  },
  analyse_validate: {
    info: 'Les analyses peuvent améliorer la qualité des données en détectant les incohérences grâce à des règles de validation et des rapports personnalisés.',
    add: 'Nouvelle analyse',
    analyse_command_created: 'La tâche d\'analyse créée avec l\'identifiant [ {id} ].',
    delete_analysis_confirm: 'Êtes-vous sûr de vouloir supprimer l\'analyse \'{name}\' et ses résultats associés. Cette action est irréversible et toutes les données seront perdues.',
    analysis_dialog: {
      add_analysis: 'Ajouter une analyse',
      title: 'Ajouter une analyse',
      variables_hint: 'Les noms de variables (séparés par des virgules) auxquels l\'analyse s\'applique. S\'ils ne sont pas spécifiés, toutes les variables de la table pourront être analysées.',
      type_hint: 'Appliquer des règles de validation des données. La validation des données consiste à vérifier si un ensemble de données répond aux présomptions ou aux attentes que vous avez à son sujet. Basé sur le package R validate qui vise à rendre la vérification de vos données facile, maintenable et reproductible.'
    }
  },
  id_mappings: {
    title: "Correspondances d'Identifiants",
    info: "Les correspondances d'identifiants sont définies par type d'entité. Les correspondances d'identifiants consistent à associer, pour une entité donnée, son identifiant dans le système à ses identifiants dans les données importées ou exportées.",
    ids_list_title: "Tables d'Identifiants",
    manage_caption: "Gérer les correspondances d'identifiants",
    mappings_count: "Correspondances d'identifiants",
    system_ids_count: 'Identifiants système',
    add_identifier: "Ajouter une Table d'Identifiants",
    generate_identifiers: 'Générer des Identifiants',
    download_identifiers: 'Télécharger des Identifiants',
    delete_identifier: "Supprimer la Table d'Identifiants",
    delete_identifier_confirm: "Êtes-vous sûr de vouloir supprimer la table d'identifiants de '{entityType}'. Cette action est irréversible et tous les identifiants de cette table seront perdus.",
    add_mapping: "Ajouter une Correspondance d'Identifiants",
    edit_mapping: "Modifier la Correspondance d'Identifiants",
    delete_mapping: "Supprimer la Correspondance d'Identifiants",
    delete_mapping_confirm: "Êtes-vous sûr de vouloir supprimer la correspondance d'identifiants de '{name}'. Cette action est irréversible et tous les identifiants de cette correspondance seront perdus.",
    generate_identifiers_info: "{count} nouvel identifiant sera généré pour cette correspondance. Pour personnaliser le format de l'identifiant, modifiez les paramètres ci-dessous.",
    generate_identifiers_warning: "Cette correspondance ne contient pas d'identifiants système; veuillez les importer avant de générer de nouveaux identifiants à l'aide des options ci-dessous.",
    sample_identifier: "Exemple d'Identifiant: {sample}",
    identifier_size: "Taille de l'Identifiant",
    identifier_size_hint: "La taille de l'identifiant doit être comprise entre {min} et {max} chiffres.",
    with_checksum: 'Avec chiffre de contrôle',
    with_checksum_hint: 'Générer des identifiants avec leur chiffre de contrôle Luhn.',
    identifier_prefix: "Préfixe d'Identifiant",
    leading_zero: 'Autoriser les zéros en tête',
    import_identifiers_list: "Importer des Identifiants Système à partir d'une Liste",
    import_identifiers_table: "Importer des Identifiants Système à partir d'une Table",
    import_identifiers_mapping: "Importer une Correspondance d'Identifiants",
    mapping_name_hint: "Une correspondance d'identifiants doit avoir un nom unique. Si la correspondance n'existe pas, elle sera créée lorsque vous saisirez un nouveau nom et appuierez sur ENTRÉE.",
    system_identifiers: 'Identifiants Système',
    mapped_identifiers: 'Identifiants Correspondants',
    import_table_sys_ids_info: "La table dont les identifiants d'entité seront copiés en tant qu'identifiants système. Les nouveaux identifiants seront ajoutés, les existants seront ignorés.",
    entity_type_no_tables: "Il n'y a pas de tables pour le type d'entité '{entityType}'.",
    no_database_warning: "Aucune base de données d'identifiants n'est configurée.",
  },
  git: {
    diff_viewer: {
      titre: 'Détails de la validation',
    },
  },
  key_type: {
    KEY_PAIR: 'Paire de clés',
    CERTIFICATE: 'Certificat',
    UNRECOGNIZED: 'Non reconnu',
  },
  project_admin: {
    properties: 'Propriétés du projet',
    db_hint: 'Les tables de projet (dictionnaires et données) sont stockées dans la base de données:',
    db_reload_hint: "Le rechargement d'une base de données de projet rend ses données temporairement inaccessibles (pas de liste de tables, pas d'importation ou d'exportation) pendant que la connexion à la base de données est réinitialisée. Le temps nécessaire à cette opération dépend du type et du schéma de la base de données.",
    db_reload_confirm: 'Êtes-vous sûr de vouloir recharger la base de données du projet?',
    backup_restore: 'Sauvegarder / Restaurer',
    backup_project: 'Sauvegarder le projet',
    backup_hint: "La tâche de sauvegarde du projet a une portée limitée : tables (dictionnaire et exportation de données), vues (soit en tant que table logique, soit en tant que table exportée), ressources et fichiers. D'autres éléments du projet ne font pas partie de la sauvegarde : les autorisations des utilisateurs et des groupes, l'historique des modifications des vues, l'analyse des tables etc.",
    backup_success: 'La tâche de sauvegarde du projet a été lancée. Vous pouvez suivre sa progression dans la liste des tâches.',
    backup_folder: 'Dossier de sauvegarde',
    restore_project: 'Restaurer le projet',
    restore_folder: 'Dossier de sauvegarde ou archive',
    restore_hint: "Restaurer les données d'un projet à partir d'un fichier d'archive de sauvegarde se trouvant sur le système de fichiers.",
    restore_override: 'Remplacer les items existants',
    views_as_table: "Vues en tant que tableaux, c'est-à-dire exporter des données au lieu de conserver des scripts de dérivation",
    danger_zone: 'Zone de danger',
    danger_zone_info: "L'archivage d'un projet rend ses données inaccessibles. Les tables, les vues, les fichiers et la base de données du projet restent intacts. Ces données seront rétablies lorsqu'un projet portant le même nom sera ajouté. Notez que la description et les permissions du projet seront définitivement supprimées.",
    archive_confirm: 'Veuillez confirmer que vous souhaitez supprimer le projet actuel et conserver toutes les données qui y sont associées ?',
    archive: 'Archives le projet',
    remove_info: "La suppression d'un projet détruit toutes les données et tous les fichiers qui y sont associés. Il peut s'agir d'une tâche de longue haleine et il n'est pas possible de revenir en arrière.",
    remove_confirm: 'Veuillez confirmer que vous souhaitez supprimer définitivement le projet actuel et toutes les données qui y sont associées. Cette opération ne peut être annulée.',
    remove: 'Supprimer le projet',
    edit: 'Modifier le projet',
    no_database_warning: "Aucune base de données n'est définie, il n'est donc pas possible d'importer des données. Seules les vues et les ressources peuvent être ajoutées.",
    entity_type_hint: 'What the identifiers are about.',
    id_mappings_info: "Les mappages d'identifiants énumérés ci-dessous qui correspondent au type d'entité des données sont automatiquement sélectionnés au cours d'un processus d'importation/exportation.",
    id_mappings_hint: 'Le nom du mappage.',
    id_mapping: 'Mappage des identifiants',
    encryption_keys: 'Clés de chiffrement',
    encryption_keys_info: "Les données chiffrées seront automatiquement déchiffrées au moment de l'importation en utilisant les paires de clés enregistrées dans le projet.",
    import_key: 'Importer une paire de clés',
    import_key_info: 'Collez la clé de chiffrement au format PEM.',
    private_key: 'Clé privée',
    public_key: 'Clé publique (certificat)"  ',
    vcf_store_hint: "Les génotypes du projet sont stockés à l'aide du service:",
    no_vcf_store_warning: "Aucun magasin VCF n'est défini pour ce projet. Aucun génotype ne peut être importé.",
  },
  user_profile: {
    title: 'Mon profil',
    groups: 'Votre compte appartient au groupe | Votre compte appartient aux {count} groupes',
    password_update_not_allowed: "Votre compte a été défini dans le répertoire d'utilisateurs '{realm}'. Veuillez contacter votre administrateur du système pour modifier le mot de passe dans ce répertoire",
    '2fa_info': "En plus de l'authentification par nom d'utilisateur/mot de passe, un mot de passe dynamique (également appelé mot de passe à usage unique) peut être demandé pour renforcer la sécurité de l'accès à votre compte. Ce mot de passe unique est basé sur le temps (TOTP) : pour générer le code PIN temporaire, installez l'application Microsoft Authenticator ({androidOtp} ou {iosOtp}) ou l'application FreeOTP+ ({androidOnlyOtp}) sur votre appareil mobile, activez 2FA dans votre profil et suivez les instructions pour initialiser l'application Authenticator...",
    android_otp: 'Android',
    android_only_otp: 'Android uniquement',
    ios_otp: 'iOS',
    update_password: 'Mettre à jour le mot de passe',
    external_account: 'Compte externe',
    enable_2fa: 'Activer 2FA',
    disable_2fa: 'Désactiver 2FA',
    otp_qr_core_info: "Ouvrez l'application mobile authenticator et scannez ce code QR pour initialiser votre générateur de code PIN :",
    all_projects: '[tous]',
    personal_access_tokens: "Jetons d'accès personnels",
    tokens_info: "Des jetons d'accès personnels peuvent être créés pour être utilisés dans des scripts et sur la ligne de commande (à l'aide de l'API client R ou Python). Attention, ces jetons sont comme des mots de passe, il faut donc les garder précieusement. L'avantage d'utiliser un jeton plutôt que de mettre votre mot de passe dans un script est qu'un jeton peut être révoqué et que vous pouvez en générer un grand nombre. L'étendue de l'accès accordé au jeton peut être limitée par les projets, les opérations qui peuvent être effectuées sur ces projets et les services du système. Notez que cette portée n'accorde pas de nouvelles autorisations, mais modifie plutôt celles que vous avez.",
    add_token: "Ajouter un jeton d'accès",
    add_datashield_token: 'Ajouter un jeton DataSHIELD',
    add_r_token: 'Ajouter un jeton R',
    add_sql_token: 'Ajouter un jeton SQL',
    add_custom_token: 'Ajouter un jeton personnalisé',
    no_tokens: 'Aucun jeton d\'accès personnel.',
    password_dialog: {
      old_password: 'Ancien mot de passe',
      new_password: 'Nouveau mot de passe',
      info: "{'Le mot de passe doit comporter au moins 8 caractères, dont un chiffre, une lettre majuscule, une lettre minuscule, un caractère spécial (par exemple, @#$%^&+= !) et aucun espace blanc.'}",
    },
    token_dialog: {
      add_datashield_token: 'Ajouter un token DataSHIELD',
      add_r_token: 'Ajouter un jeton R',
      add_sql_token: 'Ajouter un jeton SQL',
      add_custom_token: 'Ajouter un jeton personnalisé',
      name_hint: "Le nom ou une courte description de ce jeton d'accès à l'API afin que vous puissiez vous souvenir de son utilisation.",
      projects_hint: 'L\'accès peut être limité à certain projets. Par défaut, aucune restriction n\'est appliquée.',
      project_access: 'Accès aux données du projet',
      project_access_hint: "L'accès aux données peut être limité aux opérations de lecture. La limitation de l'accès aux données affecte les tâches du projet qui peuvent être exécutées et les services qui peuvent être utilisés.",
      project_tasks: 'Tâches du projet',
      project_tasks_hint: "Sélectionnez les tâches du projet qui peuvent être effectuées à l'aide du jeton. Par défaut, aucune n'est disponible.",
      project_administration: 'Administration du projet',
      project_administration_hint: "Sélectionnez les opérations d'administration du projet qui peuvent être effectuées à l'aide du jeton. Par défaut, aucune n'est disponible.",
      services: 'Services',
      services_hint: "Sélectionnez les services du système qui peuvent être exécutés à l'aide du jeton. Par défaut, aucun service n'est disponible.",
    },
  },
  token_services: {
    useR: 'R',
    useDatashield: 'DataSHIELD',
    useSQL: 'SQL',
    sysAdmin: 'Administration',
  },
  token_administration: {
    createProject: 'Créer',
    updateProject: 'Mise à jour',
    deleteProject: 'Supprimer',
  },
  // value types
  text: 'Texte',
  integer: 'Entier',
  decimal: 'Décimal',
  date: 'Date',
  datetime: 'DateHeure',
  point: 'Point',
  linestring: 'Ligne',
  polygon: 'Polygone',
  binary: 'Binaire',
  boolean: 'Booléen',
  locale: 'Locale',
  validation: {
    name_required: 'Le nom est requis',
    password_required: 'Le mot de passe est requis',
    entity_type_required: "Le type d'entité est requis",
    range: 'La valeur doit être comprise entre {min} et {max} inclusivement',
    identifiers_required: 'Les identifiants sont requis',
    table_name_required: 'Le nom de la table est requis',
    missing_required_fields: 'Champs obligatoires manquants',
    folder: {
      invalid_chars: 'Le nom du dossier ne peut pas contenir: \'{chars}\'',
      dot_name: 'Les noms \'.\' et \'..\' ne sont pas autorisés',
    },
    password_min_length: 'Le mot de passe doit comporter au moins {min} caractères',
    user: {
      password_required: 'Le mot de passe est requis et doit comporter au moins 8 caractères',
      certificate_required: 'Le certificat est requis',
      confirm_password_required: 'La confirmation du mot de passe est requise',
      passwords_not_matching: 'Les mots de passe ne correspondent pas',
    },
    identity_provider: {
      clientId_required: "L'ID client est requis",
      secret_required: 'Le secret est requis',
      discovery_uri_required: "L'URI de découverte est requis",
      discovery_uri_format: 'L\'URI de découverte doit commencer par "https://" ou "http://"',
      provider_url_format: 'La connexion au compte doit commencer par "https://" ou "http://"',
      callback_url_format: 'L\'URL publique doit commencer par "https://" ou "http://"',
      scope_required: 'La portée est requise',
    },
    update_password: {
      old_password: "L'ancien mot de passe est requis",
      new_password: 'Un nouveau mot de passe est requis et doit comporter au moins 8 caractères.',
    },
    text_required: 'Un texte est requis',
    github: {
      org_required: "L'organisation ou le nom d'utilisateur Github est requis",
      repo_required: 'Le nom du référentiel Github est requis',
    },
    project_admin: {
      backup_folder_required: 'Le dossier de sauvegarde est requis',
      private_key_required: 'Clé privée au format PEM requise',
      public_key_required: 'Clé publique (certificat) au format PEM requis',
    },
    apps: {
      host_required: "L'hôte est requis",
      host_uri_format: 'L\'hôte doit commencer par "https://" ou "http://"',
    },
  },
  analysis : {
    name_exists : 'Le nom de l\'analyse doit être unique',
  },
  main: {
    brand: 'Opal',
    powered_by: 'Propulsé par',
    two_fa_info: 'Vous devriez améliorer la sécurité de votre compte avec l\'authentification à deux facteurs.',
    two_fa_link: 'Activer la 2FA',
    python_api: 'Apprenez comment utiliser la librairie Python et ses outils de commande en ligne.\n\n[Python user guide (en)](https://opaldoc.obiba.org/en/latest/python-user-guide/index.html)',
    r_api: 'Apprenez comment utiliser la librairie R pour gérer les données et faire des opérations DataSHIELD.\n\n[R/DataSHIELD user guide (en)](https://opaldoc.obiba.org/en/latest/r-user-guide/index.html)',
    javascript_api: 'Apprenez comment utiliser la librairie Javascript pour dériver des variables.\n\n[Javascript user guide (en)](https://opaldoc.obiba.org/en/latest/magma-user-guide/index.html)',
  },
  plugin: {
    installed: 'Installés',
    available: 'Disponibles',
    updates: 'Mises à jour',
    advanced: 'Avancé',
    installed_plugins_info: "Liste des plugins installés. L'installation ou la suppression d'un plugin nécessite un redémarrage du système pour être effective.",
    restart: 'Redémarrer',
    install_success: 'Le plugin a été installé',
    restarted: 'Le plugin a été redémarré',
    restart_failed: 'Le redémarrage du plugin a échoué',
    configure: 'Configurer',
    system_restart_required: "Le redémarrage du système est nécessaire pour que l'installation/la suppression des plugins soit effective.",
    site_properties: 'Propriétés du site',
    site_properties_hint: "Propriétés spécifiques au site d'installation du plugin. Ces propriétés améliorent ou remplacent les propriétés intégrées du plugin. Le redémarrage du service de plugin est généralement nécessaire pour que les modifications soient effectives.",
    updates_plugins_info: "Lister les mises à jour des plugins installés disponibles pour l'installation.",
    no_updates: 'Aucune mise à jour disponible',
    available_plugins_info: "Lister les nouveaux plug-ins disponibles pour l'installation.",
    none_available: 'Aucun plugin disponible',
    archive_installation: "Installation d'archive",
    archive_info: 'Une archive de plug-in peut être installée à partir d\'un fichier sélectionné. Le suffixe de fichier attendu est "-dist.zip"',
    archive_file: "Fichier d'archive",
    update_site: 'Dépôt de plugins',
    update_site_info: "Le dépot de plugins est vérifié pour les mises à jour des plugins installés et les nouveaux plugins disponibles pour le téléchargement et l'installation.",
    last_update: 'Dernière vérification du dépot : {ago}',
  },
  r: {
    cluster: 'Cluster',
    clusters_count: 'Aucun cluster de serveurs R | 1 cluster de serveurs R | {count} clusters de serveurs R',
    paquets_warn: "Cette opération peut paraître pratique mais elle n'est pas recommandée dans un environnement de production. Il est préférable de déployer le serveur R à partir d'une image Docker validée pour garantir la reproductibilité de l'environnement d'analyse R.",
    servers_info: "Les serveurs R sont regroupés par clusters. Dans chaque cluster, tous les serveurs R sont considérés comme interchangeables, c'est-à-dire que la charge d'activité sera répartie sur l'un ou l'autre serveur lors de la création d'une session R.",
    servers: 'Serveurs R',
    sessions_counts: '{count} ({active} active)',
    sessions_info: "Surveillance de l'activité du serveur R : chaque session R est une unité de calcul démarrée par les utilisateurs R/DataSHIELD ou par des processus internes. Les sessions R sans activité pendant un certain temps seront automatiquement terminées.",
    sessions: 'Sessions R',
    system: 'coeurs : {cores}, mémoire libre : {memory}',
    version: 'Version R',
    workspaces_info: "Stockage des espaces de travail R : chaque espace de travail R/DataSHIELD enregistré contient l'image et les fichiers de la session (le cas échéant). Ceux-ci peuvent être restaurés autant de fois que nécessaire à la demande de l'utilisateur.",
    workspaces: 'Espaces de travail R',
    clear_cache: 'Vider le cache R',
  },
  resource_ref: {
    label: 'Ressource référencée',
    provider: 'Fournisseur',
    provider_not_found: 'Fournisseur non trouvé : aucun serveur R ne peut fournir une façon de rendre la ressource disponible. Le paquet R {provider} est-il installé ?',
    test_success: "L'assignation de la resource a réussie.",
    test_error: "L'assignation de la resource a échoué.",
    add_from_provider: 'Ajouter à partir de {provider}',
    name_hint: 'Le nom de la ressource, unique dans le projet.',
    description_hint: 'Une courte description de la ressource, optionelle.',
    category: 'Categorie',
    category_hint: 'Le type de ressource.',
    factory: 'Constructeur',
    factory_hint: 'Comment la resource sera créée.',
    view_destination_hint: "La vue de destination sera créée si elle n'existe pas, sinon elle sera mise à jour.",
    entity_type_hint: 'A propos de quoi sont les données de cette vue.',
    id_column: 'Colonne ID',
    id_column_hint: 'Le nom de la colonne dans la représentation tabulaire de la ressource fournissant les identifiants. Si non spécifié, la première colonne sera utilisée.',
    all_columns: 'Toutes les colonnes',
    all_columns_hint: 'Quand sélectionné, toutes les colonnes observées (sauf la colonne des identifiants) seront décrites comme des variables quand la connexion avec la ressource sera établie. Cela signifie que quand une nouvelle colonne apparait dans la resource, une variable correspondante sera automatiquement ajoutée.',
    r_server_profile: 'Profile du serveur R',
    r_server_profile_hint: 'Nom (optionnel) du serveur R à utiliser pour établir la connexion avec la ressource. Si non spécifié, le profile sera deviné à partir du paquet R associé à la ressource.',
    from_hint: 'Le nom complet de la ressource à laquelle se connecter et à représenter sous forme de tableau.',
  },
  taxonomy: {
    title: 'Taxonomie',
    name_hint: 'Une taxonomie doit avoir un nom unique.',
    author_hint: "L'auteur de la taxonomie peut être spécifié (pour le droit d'auteur).",
    licence_hint: "Type de licence qui s'applique à cette taxonomie. Voir l'{url} suggérée.",
    creative_commons_licenses: 'Licences Creative Commons',
    description_hint: 'Description facultative de la taxonomie.',
    add: 'Ajouter une taxonomie',
    edit: 'Modifier la taxonomie',
    new_taxonomy: 'Nouvelle taxonomie',
    import_mlstr: 'Taxonomies de Maelstrom Research',
    import_github: 'Dépôt GitHub',
    import_file: 'Fichier YAML',
    change_history: 'Historique des modifications',
    compare_current: 'Comparer avec le courant',
    restore_confirm: "Êtes-vous sûr de vouloir restaurer la version à partir du '{date}' ? Cela remplacera les informations actuelles.",
    filter_vocabulary: 'Filtrer les vocabulaires...',
    vocabulary: {
      title: 'Vocabulaire',
      name_hint: 'Un vocabulaire doit avoir un nom unique.',
      description_hint: 'Description facultative du vocabulaire.',
      add: 'Ajouter du vocabulaire',
      edit: 'Modifier le vocabulaire',
      repeatable: 'Répétable',
      repeatable_hint: 'Lorsque plusieurs termes de ce vocabulaire peuvent être appliqués à une variable.',
      filter_terms: 'Filtrer les termes...',
    },
    term: {
      title: 'Terme',
      name_hint: 'Un terme doit avoir un nom unique.',
      description_hint: 'Description facultative du terme.',
      add: 'Ajouter un terme',
      edit: 'Modifier le terme',
      keywords_hint: 'Liste facultative de mots-clés du terme. Peut être utile lors de la création de requêtes de recherche de variables.',
    },
    import_mlstr: {
      label: 'Taxonomies de Maelstrom Research',
      title: 'Importer les taxonomies de Maelstrom Research',
      info: "Les taxonomies de classification des variables {mlstr_url} permettent d'annoter des études et des variables harmonisées pour faciliter la navigation dans les métadonnées et améliorer la découverte des données sur le portail Web de données {mica_url}.",
      versions: 'Versions publiées',
      versions_hint: "Ces taxonomies sont disponibles sous l'{url}",
      versions_hint_url: 'Licence publique internationale Creative Commons Attribution-NonCommercial-NoDerivatives 4.0.',
      licence_agreement: "J'ai lu et accepté les termes de la licence.",
    },
    import_github: {
      label: 'À partir de GitHub',
      title: 'Importer le référentiel GitHub',
      org_hint: 'Exemple : maelstrom-research',
      repo_hint: 'Exemple : maelstrom-taxonomies',
      ref_hint: 'Exemple: nom de la branche du référentiel (par exemple master), version (1.0) ou identifiant de commit.',
      file: 'Fichier',
      file_hint: 'Nom du fichier YAML de taxonomie (par exemple taxonomy.yml ou scales/taxonomy.yml). Laissez ce champ vide pour importer tous les fichiers de taxonomie.',
      override: 'Remplacer les taxonomies existantes',
    },
    import_file: {
      label: 'À partir du fichier YAML',
      title: 'Importer un fichier YAML',
    },
  },
  vcf_store: {
    label: 'Magasin VCF',
    identified_samples: 'Échantillons Identifiés',
    controls: 'Contrôles',
    sample_participants_mapping: 'Correspondance Échantillon-Participants',
    sample_participants_mapping_info: 'Améliorez la description des génotypes avec un tableau décrivant les échantillons: ID de participant associé et identification des cas-témoins.',
    add_mapping: 'Ajouter une correspondance',
    update_mapping: 'Mettre à Jour la correspondance',
    no_mapping_tables: "Il n'y a pas de table de correspondance disponible.",
    mapping_table_hint: 'Table de correspondance du génotype.',
    participant_id: "Variable d'ID de Participant",
    participant_id_hint: 'Le nom de la variable ID de participant.',
    role: "Variable de Rôle de l'Échantillon",
    role_hint: "Le nom de la variable de Rôle de l'échantillon.",
    vcf_files: 'Fichiers VCF',
    variants: 'Variantes',
    genotypes: 'Génotypes',
    import_vcf_file: 'Importer un Fichier VCF',
    export_vcf_file: 'Exporter un Fichier VCF',
    import_vcf_file_label: 'Fichier VCF/BCF',
    import_vcf_file_hint: 'Un fichier VCF/BCF (éventuellement compressé), avec suffixe .vcf, .vcf.gz, .bcf ou .bcf.gz.',
    import_vcf_command_created: "Tâche d'importation de fichiers VCF créée avec l'identifiant [ {id} ].",
    export_participants_filter_label: 'Filtre des Participants',
    export_vcf_file_label: "Un fichier VCF est sélectionné pour l'exportation. | {count} fichiers VCF sont sélectionnés pour l'exportation.",
    export_mapping_table_hint: "Sélectionnez un tableau pour fournir l'ensemble des participants dont les échantillons seront inclus dans le fichier VCF. Si aucun tableau n'est sélectionné, aucun filtre de participant ne sera appliqué.",
    export_vcf_command_created: "Tâche d'exportation de fichiers VCF créée avec l'identifiant [ {id} ].",
    export_case_control_label: 'Inclure les cas témoins',
    export_id_mappings_label: 'Correspondance des Identifiants des Participants',
    export_id_mappings_hint: "Sélectionnez une correspondance des identifiants des participants à utiliser lors de l'exportation de la correspondance des ID des échantillons.",
  },
  stats: {
    min: 'Minimun',
    max: 'Maximum',
    mean: 'Moyenne',
    stdDeviation: 'Déviation standard',
    total: 'Somme',
    variance: 'Variance',
    count: 'N',
  },
  table_index: {
    status_title: {
      NOT_INDEXED: "La table n'est pas indexée. L'indexation est recommandée pour de meilleures performances lors de l'extraction des statistiques récapitulatives de la variable.",
      OUTDATED: "L'index de la table est obsolète. L'indexation est recommandée pour de meilleures performances lors de l'extraction des statistiques récapitulatives de la variable.",
      IN_PROGRESS: "L'indexation de la table est en cours. ",
      UPTODATE: "L'index de la table est obsolète. ",
      UNRECOGNIZED: "L'index de la table est dans un état non reconnu. ",
    },
    status: {
      NOT_INDEXED: 'Non indexée',
      OUTDATED: 'Obsolète',
      IN_PROGRESS: 'En cours',
      UPTODATE: 'À jour',
      UNRECOGNIZED: 'Non reconnue',
    },
  },
  variable_nature: {
    CATEGORICAL: 'Catégorielle',
    CONTINUOUS: 'Continue',
    TEMPORAL: 'Temporelle',
    GEO: 'Géographique',
    BINARY: 'Binaire',
    UNDETERMINED: 'Indéterminée',
  },
  schedule_type: {
    NOT_SCHEDULED: 'Non planifié',
    MINUTES_5: 'Toutes les 5 minutes',
    MINUTES_15: 'Toutes les 15 minutes',
    MINUTES_30: 'Toutes les 30 minutes',
    HOURLY: 'Toutes les heures',
    DAILY: 'Tous les jours',
    WEEKLY: 'Toutes les semaines',
    UNRECOGNIZED: 'Non reconnu',
  },
  weekdays: {
    SUNDAY: 'Dimanche',
    MONDAY: 'Lundi',
    TUESDAY: 'Mardi',
    WEDNESDAY: 'Mercredi',
    THURSDAY: 'Jeudi',
    FRIDAY: 'Vendredi',
    SATURDAY: 'Samedi',
    UNRECOGNIZED: 'Non reconnu',
  },
  account: 'Compte',
  actions: 'Actions',
  add_a_view: 'Ajouter une vue',
  add_categories_range: 'Ajouter une plage de catégories',
  add_category: 'Ajouter une catégorie',
  add_folder: 'Ajouter un dossier',
  add_group_permission: 'Ajouter une permission de groupe',
  add_method: 'Ajouter une méthode',
  add_option: 'Ajouter une option',
  add_permission: 'Ajouter une permission',
  add_profile: 'Ajouter un profil',
  add_project: 'Ajouter un projet',
  add_table: 'Ajouter une table',
  add_tables: 'Ajouter/mettre à jour des tables',
  add_to_cart: 'Ajouter au panier',
  add_to_view_info: '- | Une variable dérivée sera ajoutée/mise à jour. | {count} variables dérivées seront ajoutées/mises à jour.',
  add_to_view: 'Ajouter à une vue',
  add_user_permission: "Ajouter une permission d'utilisateur",
  add_variable: 'Ajouter une variable',
  add_view: 'Ajouter une vue',
  add: 'Ajouter',
  administration: 'Administration',
  administrator: 'Administrateur',
  advanced_options: 'Options avancées',
  advanced_search: 'Recherche avancée',
  all_categories: 'Toutes',
  all_projects: 'Tous',
  analyses: 'Analyses',
  annotate_info: '- | Une variable sera annotée. | {count} variables seront annotées.',
  annotate: 'Annoter',
  annotation_texts_hint: 'Annotez avec du texte libre. Pour une lisibilité humaine, vous pouvez fournir un texte différent dans chaque langue. Pour un traitement automatique ou un texte sans localisation, choisissez la langue "default". Le texte vide sera ignoré. Le format de texte Markdown est pris en charge.',
  annotations: 'Annotations',
  annotations: 'Annotations',
  apply_annotation: 'Appliquer une annotation',
  apply: 'Appliquer',
  at: 'à',
  attribute_name_hint: "Un nom pour l'attribut est requis.",
  attribute_namespace_hint: 'Un espace de noms est facultatif.',
  attributes_annotations_info: "Les annotations sont des attributs en lien avec une taxonomie. Ils sont utilisés pour apporter un supplément d'information ou pour aider à la classification.",
  attributes_info: "Les attributs peuvent être utilisés pour stocker de l'information supplémentaire d'une manière structurée.",
  attributes_records_info: 'Ce sont les attributs tels qu\'ils sont stockés dans le dictionnaire de la variable. Le triplet (espace de noms, nom, locale) identifie de manière unique un attribut. Les annotations sont des attributs dont l\'"espace de noms" est le nom de la taxonomie associée, le "nom" est le vocabulaire dans la taxonomie et la "valeur" est le terme dans le vocabulaire. Les autres noms d\'attribut réservés sont "label", "description" et "script" (sans espace de noms).',
  attributes: 'Attributs',
  auth_method: "Méthode d'authentification",
  authentication: 'Authentification',
  author: 'Auteur',
  back: 'Retour',
  backup: 'Sauvegarder',
  bookmark_add: 'Ajouter aux favoris',
  bookmark_remove: 'Retirer des favoris',
  bookmarks: 'Favoris',
  built: 'Built',
  busy: 'Occupé',
  cache: 'Cache',
  cancel_task_confirm: 'Êtes-vous sûr de vouloir annuler cette tâche ?',
  cancel: 'Annuler',
  cart: 'Panier',
  categorical_variable_hint: 'Variable catégorielle ou logique.',
  categorical_variable: 'Variable catégorielle',
  categories_range_hint: "Utilisez le trait d'union '-' pour spécifier une plage de valeurs numériques et la virgule ',' pour séparer les noms ou les plages de noms, par exemple : '1-4, 9' ou 'A, B, C '. Les catégories existantes ne seront pas modifiées.",
  categories: 'Catégories',
  certificate_placeholder: 'Collez votre certificat ici',
  certificate: 'Certificat',
  char_set: 'Jeu de caractères',
  clear_tasks_confirm: 'Aucune tâche à nettoyer | Êtes-vous sûr de vouloir nettoyer cette tâche ? | Êtes-vous sûr de vouloir nettoyer ces {count} tâches ?',
  clear: 'Nettoyer',
  close: 'Fermer',
  cluster: 'Cluster',
  code: 'Code',
  comment: 'Commentaire',
  compare: 'Comparer',
  configuration: 'Configuration',
  configure_import_source: 'Configurer la source de données',
  configure: 'Configurer',
  confirm: 'Confirmer',
  content: 'Contenu',
  context: 'Context',
  contingency_table_info: 'Affiche la distribution de fréquence multivariée des variables sélectionnées.',
  contingency_table: 'Tableau de contingence',
  continue: 'Continuer',
  copy_data: 'Copier les données',
  copy_incremental_hint: 'Seuls les enregistrements nouveaux ou mises à jour seront copiés.',
  copy_incremental: 'Incrémental',
  copy_nulls_hint: 'Permettre de remplacer une donnée par une valeur nulle.',
  copy_nulls: 'Copier les valeurs nulles',
  copy_tables_data_task_created: "La tâche de copie des tables a été créée avec l'identifiant [ {id} ].",
  copy_tables_data_text: 'Aucune table à copier | Une table sera copiée | {count} tables seront copiées.',
  copy_tables_data: 'Copier la table | Copier la table | Copier les tables',
  copy_view: 'Copier la vue',
  copy: 'Copier',
  created: 'Date de création',
  credentials: "Informations d'identification",
  current: 'Actuel',
  dashboard: 'Tableau de bord',
  data_access: 'Accès aux données',
  data_analysis: 'Analyse de données',
  data_file: 'Fichier de données',
  data_format: 'Format des données',
  data_management: 'Gestion des données',
  data_server: 'Serveur de données',
  database: 'Base de données',
  databases_caption: "Gérer les bases de données pour le stockage, l'import et l'export des données",
  databases: 'Base de données',
  datashield_profile: 'Profil DataSHIELD',
  datashield_service: 'Service DataSHIELD',
  date: 'Date',
  day: 'Jour',
  default_charset: 'Jeu de caractères par défaut',
  default_storage: 'Stockage par défaut',
  default_value_type: 'Type de valeur par défaut',
  delay: 'Délai',
  delete_annotation_confirm: 'Êtes-vous sûr de vouloir supprimer cette annotation ?',
  delete_annotation: 'Supprimer une annotation',
  delete_attributs_confirm: 'Êtes-vous sûr de vouloir supprimer cet attribut (toutes langues) ?',
  delete_categories_confirm: '- | Êtes-vous sûr de vouloir supprimer cette catégorie ? | Êtes-vous sûr de vouloir supprimer ces {count} catégories ?',
  delete_files_confirm: '- | Êtes-vous sûr de vouloir supprimer ce fichier ? | Êtes-vous sûr de vouloir supprimer ces {count} fichiers ?',
  delete_group_confirm: "Êtes-vous sûr de vouloir supprimer le groupe '{groupe}'?",
  delete_identity_provider_confirm: "Êtes-vous sûr de vouloir supprimer le fournisseur '{provider}'?",
  delete_permission_confirm: "Êtes-vous sûr de vouloir supprimer la permission de '{principal}'?",
  delete_profile_acl_confirm: 'Êtes-vous sûr de vouloir révoquer la permission sélectionnée? | Êtes-vous sûr de vouloir révoquer ces {count} permissions?',
  delete_profile_confirm: "Êtes-vous sûr de vouloir supprimer le profil '{profile}'?",
  delete_profiles_confirm: "Êtes-vous sûr de vouloir supprimer le profil '{profile}'? | Êtes-vous sûr de vouloir supprimer ces {count} profils?",
  delete_profiles_selected: 'Supprimer les profils sélectionnés',
  delete_r_package_confirm: 'La suppression d\'un paquet R peut échouer s\'il est installé dans un dossier non accessible en écriture. Êtes-vous sûr de vouloir supprimer le paquet R "{name}" ?',
  delete_r_workspaces_confirm: '- | Êtes-vous sûr de vouloir terminer cet espace de travail R ? | Êtes-vous sûr de vouloir terminer ces {count} espaces de travail R ?',
  delete_resources_confirm: 'Aucune ressource à supprimer | Êtes-vous sûr de vouloir supprimer cette ressource ? | Êtes-vous sûr de vouloir supprimer ces {count} ressources ?',
  delete_tables_confirm: 'Aucune table à supprimer | Êtes-vous sûr de vouloir supprimer cette table ? | Êtes-vous sûr de vouloir supprimer ces {count} tables ?',
  delete_taxonomy_confirm: "Êtes-vous sûr de vouloir supprimer la taxonomie '{taxonomy}'?",
  delete_term_confirm: "Êtes-vous sûr de vouloir supprimer le terme '{term}' du vocabulaire '{vocabulary}'?",
  delete_token_confirm: "Êtes-vous sûr de vouloir supprimer le jeton '{token}'?",
  delete_user_confirm: "Êtes-vous sûr de vouloir supprimer l'utilisateur {user} ?",
  delete_variables_confirm: 'Aucune variable à supprimer | Êtes-vous sûr de vouloir supprimer cette variable ? | Êtes-vous sûr de vouloir supprimer ces {count} variables ?',
  delete_vcf_confirm: 'Êtes-vous sûr de vouloir supprimer le fichier VCF sélectionné ? | Êtes-vous sûr de vouloir supprimer ces {count} fichiers VCF ?',
  delete_vcf_mapping_confirm: 'Veuillez confirmer que vous souhaitez supprimer cette correspondance échantillon-participant. Notez que la table correspondante du projet ne sera pas supprimée.',
  delete_vocabulary_confirm: "Êtes-vous sûr de vouloir supprimer le vocabulaire '{vocabulary}' de la taxonomie '{taxonomy}'?",
  delete: 'Supprimer',
  density: 'Densité',
  derivation_script: 'Script de dérivation',
  derived_variables_hint: "Le nom et le type de la variable dérivée peuvent être différents de celui de la variable d'origine.",
  derived_variables: 'Variables dérivées',
  description: 'Description',
  description: 'Description',
  descriptive_statistics: 'Statistiques descriptives',
  destination_folder: 'Dossier de destination',
  details: 'Détails',
  dictionary: 'Dictionnaire',
  disable: 'Désactiver',
  discovery: 'Découverte',
  docs: 'Docs',
  documentation_cookbook: 'Documentation et recettes',
  download_dictionaries: 'Télécharger les dictionnaires',
  download_dictionary: 'Télécharger le dictionnaire',
  download_logs: 'Télécharger les logs',
  download_view: 'Télécharger la vue',
  download_views_backup: 'Sauvegarder les vues',
  download: 'Télécharger',
  duplicate: 'Dupliquer',
  duration: 'Durée',
  edit_category: 'Éditer la catégorie',
  edit_permission: 'Éditer la permission',
  edit_project: 'Éditer le projet',
  edit_script: 'Éditer le script',
  edit_table: 'Éditer la table',
  edit_variable: 'Éditer la variable',
  edit_view: 'Éditer la vue',
  edit: 'Éditer',
  empty_cart: 'Le panier est vide',
  enable: 'Activer',
  enabled: 'Activé',
  encrypt_file_content: 'Encrypter le contenu du fichier',
  encrypt_password_hint: 'Le mot de passe doit avoir au moins 8 caractères.',
  encrypt_password: 'Mot de passe',
  end_time: 'Fin',
  end: 'Fin',
  enforced_2fa: 'Authentification à deux facteurs obligatoire',
  entities: 'Entités',
  entity_filter: "Filtre d'entité",
  entity_search_caption: "Recherche d'entité par identifiant.",
  entity_search_info: "Recherche d'entité en fournissant son type et son identifiant. Voir [Search Entity documentation](http://opaldoc.obiba.org/en/latest/web-user-guide/search/entity.html) pour plus de détails.",
  entity_search: "Recherche d'entité",
  entity_type: "Type d'entité",
  entity: 'Entité',
  example: 'Exemple : {text}',
  expires: 'Expire',
  export_data: 'Exporter les données',
  export_database: 'Exporter vers une base de données',
  export_file: 'Exporter vers un fichier',
  export_folder: "Dossier d'exportation",
  export_tables_task_created: "Tâche d'exporter de tables créée avec l'identifiant [ {id} ]",
  export_tables_text: 'Aucune table à exporter | Une table sera exportée | {count} tables seront exportées',
  export: 'Exporter',
  extract_archive_password_hint: "Le mot de passe pour extraire le contenu de l'archive, si applicable.",
  extract: 'Extraire',
  file_folder_search: 'Rechercher des fichiers et dossiers',
  field_separator: 'Séparateur de champ',
  file_already_exists: 'Ce fichier existe déjà',
  file_selection: 'Sélection de fichier',
  file_system: 'Système',
  files_caption: 'Gérer le système de fichiers, téléverser et télécharger des fichiers',
  files: 'Fichiers',
  filter: 'Filtre',
  filters: 'Filtres',
  folder: 'Dossier',
  folder_file: 'Dossier ou fichier',
  format: 'Format',
  frequencies: 'Fréquences',
  frequency: 'Fréquence',
  from_row: 'A partir de la ligne',
  from_tables_hint: 'La vue fait référence à la ou aux tables à partir desquelles les entités et les variables sont extraites. Lorsqu\'une table est marquée comme étant "interne", ses entités ne contribueront pas aux entités de la vue : cela équivaut à une jointure interne en SQL.',
  from_tables_select_hint: 'Sélectionnez une ou plusieurs tables pour les ajouter à la vue.',
  from_tables: 'Depuis les tables',
  from: 'Depuis',
  full_name: 'Nom complet',
  full_summary: 'Sommaire complet',
  function: 'Fonction',
  general_settings_caption: 'Gérer la configuration générale du serveur',
  general_settings: 'Paramètres généraux',
  generate: 'Générer',
  genotypes: 'Génotypes',
  gh_org_hint: 'Exemple: datashield',
  gh_org: 'Organisation ou utilisateur',
  gh_ref_hint: 'Branche, tag ou commit, la valeur par défaut est "master"',
  gh_ref: 'Référence',
  gh_repo_hint: 'Exemple: dsBase',
  gh_repo: 'Dépôt',
  group: 'Groupe',
  groups_hint: "Sélectionnez un groupe ou saisissez un nouveau nom et appuyez sur 'Entrée'.",
  groups_info: "Les groupes ne peuvent être définis que par l'intermédiaire des utilisateurs. La suppression d'un groupe supprime les utilisateurs de ce groupe.",
  groups: 'Groupes',
  help: 'Help',
  histogram: 'Histogramme',
  history: 'Historique',
  home_folder: 'Dossier personnel',
  host: 'Hôte',
  hour: 'Heure',
  id_column_hint: "Nom de la colonne des identifiants uniques. Si non fournie, la première colonne sera utilisée pour déterminer l'identifiant de l'entité.",
  id_column_name_hint: "Nom de la colonne qui identifie l'entité. S'il n'est pas fourni, le nom par défaut s'applique",
  id_column_name: 'Nom de la colonne ID',
  id_column: 'Colonne ID',
  id: 'ID',
  identifiers: 'Identifiants',
  identity_provider_account_login: 'Connexion au compte',
  identity_provider_add: "Ajouter un fournisseur d'identité",
  identity_provider_discovery_uri: 'URI de découverte',
  identity_provider_edit: "Modifier le fournisseur d'identité",
  identity_provider_url: 'Connexion du fournisseur',
  identity_providers_caption: 'Gérer les fournisseurs OpenID Connect',
  identity_providers_info: "Les utilisateurs d'un {idProvider} déclaré peuvent se connecter à l'application en utilisant leurs informations d'identification. Une fois connectés, les utilisateurs sont automatiquement associés à un groupe portant le nom du fournisseur d'identité, afin que les autorisations puissent être appliquées à tous les utilisateurs de la même source. Des associations de groupes supplémentaires peuvent également être appliquées. Notez que seuls les fournisseurs d'identité de type {openId} sont pris en charge.",
  identity_providers: "Fournisseurs d'identité",
  import_data_task_created: "La tâche d'importation des données a été créée avec l'identifiant [ {id} ].",
  import_data: 'Importer des données',
  import_database: 'Importer depuis une base de données',
  import_file: 'Importer depuis un fichier',
  import_limit_hint: "Le nombre maximum de lignes à importer. Si aucune limite n'est définie ou si la limite est 0, tous les enregistrements seront importés.",
  import_server: 'Importer depuis un serveur',
  import: 'Importer',
  inactive: 'Inactif',
  incremental_import_hint: 'Importer uniquement les données nouvelles ou mises à jour',
  incremental_import: 'Importation incrémentale',
  index_hint: 'Position ou poids de la variable dans la table, pour établir un ordre.',
  index: 'Index',
  initialize: 'Initialiser',
  inner_join: 'Jointure interne',
  install_action: 'Installer',
  install_r_package_task_created: "La tâche d'installation du paquet R a été créée avec l'identifiant [ {id} ].",
  install_r_package: 'Installer un paquet R',
  install: 'Installer',
  intervals: 'Intervalles',
  is_missing_hint: "Indique qu'une valeur d'observation est manquante.",
  is_missing: 'Manquante',
  jvm_caption: 'Monitorer la machine virtuelle Java',
  jvm: 'Machine virtuelle Java',
  keywords: 'Mots-clés',
  kurtosis: 'Kurtosis',
  label_description: 'Libellé & description',
  label: 'Libellé',
  labels: 'Libellés',
  laguages: 'Langues',
  last_access: 'Dernier accès',
  last_update: 'Dernière mise à jour',
  latest: 'Dernière',
  less: 'Moins',
  libpath: 'Libpath',
  license: 'Licence',
  limit: 'Limite',
  logout_url: 'URL après déconnexion',
  manager: 'Gestionnaire',
  mappings: 'Correspondances',
  markdown_guide: 'Guide Markdown',
  max: 'Maximum',
  mean: 'Moyenne',
  median: 'Médiane',
  merge_dictionaries_hint: "Lorsqu'une table existe déjà, les caractéristiques des variables (propriétés, catégories, attributs) seront fusionnées avec celles importées au lieu d'être simplement remplacées. Cela permet de conserver les annotations des variables lors des importations ultérieures.",
  merge_dictionaries: 'Fusionner les dictionnaires',
  merge_variables_hint: 'Si sélectionné, les variables avec le même nom seront fusionnées (les propriétés, les catégories et les attributs seront ajoutés ou mis à jour, pas de suppression). Sinon, les variables fournies remplaceront les existantes.',
  merge_variables: 'Fusionner les variables',
  message: 'Message',
  messages: 'Messages',
  mime_type_hint: 'Le type MIME de la variable.',
  mime_type: 'Type mime',
  min: 'Minimum',
  minutes: 'Minutes',
  missings: 'Manquantes',
  mongodb: 'MongoDB',
  more_results: 'Plus de résultats',
  more: 'Plus',
  move_down: 'Descendre',
  move_up: 'Monter',
  my_profile: 'Mon profil',
  name: 'Nom',
  namespace: 'Espace de noms',
  nature: 'Nature',
  new_name: 'Nouveau nom',
  no_bookmarks: 'Aucun favori',
  no_datasource_configuration: 'Aucune configuration pour la source de données',
  no_entity_filter: "Aucun filtre d'entité n'est défini pour la vue.",
  no_options: 'Aucune option',
  no_permissions: 'Aucune permission',
  no_r_activity: 'Aucune activité R',
  no_results: 'Aucun résultat',
  no_sql_history: 'Aucun historique SQL',
  no_table_values: 'Aucune valeur dans la table',
  no_taxonomies: 'Aucune taxonomie',
  no: 'Non',
  non_missings: 'Non manquantes',
  none_value: '(Aucun)',
  none: 'Aucun',
  normal_distribution: 'Distribution normale',
  normal: 'Normal',
  not_empty: 'Non vide',
  occurrence_group_hint: 'Groupement de plusieurs variables répétables.',
  occurrence_group: "Groupe d'occurrence",
  on: 'le',
  opal_url: 'URL Opal',
  openid_connect: 'Connexion OpenID',
  optional_storage_hint: 'Base de données optionnelle utilisée pour stocker les données.',
  optional: 'Optionnel',
  options: 'Options',
  other_links: 'Autres liens',
  other_variable_hint: 'Variable catégorielle, logique ou numérique.',
  other_variable: 'Autre variable',
  other: 'Autre',
  owner: 'Propriétaire',
  package_manager: 'Gestionnaire de paquets',
  package: 'Package',
  packages: 'Packages',
  parameters: 'Paramètres',
  participant_id: 'ID Participant',
  participants: 'Participants',
  password_confirm: 'Confirmer le mot de passe',
  password_hint: "{'Le mot de passe doit comporter au moins 8 caractères, dont un chiffre, une lettre majuscule, une lettre minuscule, un caractère spécial (par exemple, @#$%^&+= !) et aucun espace blanc.'}",
  password: 'Mot de passe',
  percentage: 'Pourcentage',
  permission: 'Permission',
  permissions: 'Permissions',
  personal_access_token: "Jeton d'accès personnel",
  plugins_caption: 'Gérer les plugins du système',
  plugins_info: 'Les plugins sont des extensions qui amènent de nouvelles fonctions au système. Ils peuvent être installés, mis à jour ou supprimés.',
  plugins: 'Plugins',
  preview_import_source: 'Prévisualiser les données',
  preview: 'Prévisualiser',
  profile_groups_acls_info: "Liste des permissions accordées à l'utilisateur par l'intermédiaire de groupes auxquels il appartient. Notez que supprimer une permission d\'un groupe affecte les permissions accordées aux membres de ce groupe.",
  profile_groups_acls: 'Permissions de ses groupes',
  profile_otp_disable: "Désactiver l'authentification à deux facteurs pour l'utilisateur '{user}'",
  profile_otp_disabled: "L'authentification à deux facteurs peut être activée par l'utilisateur '{user}'",
  profile_user_acls_info: "Liste des permissions directement accordées à l'utilisateur. Les permissions accordées à l'utilisateur par l'intermédiaire de groupes ne sont pas incluses.",
  profile_user_acls: "Permissions de l'utilisateur",
  profile: 'Profile',
  profiles_info: "Chaque utilisateur qui se connecte a un profil. Un domaine est le répertoire d'utilisateurs dans lequel un utilisateur est défini. Pour des raisons de sécurité, il est interdit de se connecter à partir de différents domaines avec le même nom d'utilisateur. S'il est supprimé, le profil de l'utilisateur sera automatiquement recréé lorsque l'utilisateur se connectera.",
  profiles: 'Profils',
  progress: 'Progression',
  project_acls_empty: "Aucune permission n'a été accordée.",
  project_backup_success: 'La tâche de sauvegarde du projet a été lancée. Vous pouvez suivre sa progression dans la liste des tâches.',
  project_description_hint: 'Description optionnelle du projet.',
  project_destination: 'Projet de destination',
  project_files_info: 'Chaque projet a un dossier. Un utilisateur ayant accès à un élément du projet peut également voir le contenu de ce dossier.',
  project_permissions_info: 'Les permissions sont des autorisations accordées à des utilisateurs ou des groupes pour accéder à des éléments du projet. Les permissions définissent les opérations pouvant être effectuée. Les tables suivantes listes les permissions ayant été accordée à des utilisateurs ou des groupes.',
  project_settings: 'Paramètres du projet',
  project_tag_hint: "Tapez une nouvelle étiquette et appuyez sur 'ENTER'.",
  project: 'Projet',
  projects_caption: 'Parcourir les tables et les variables, créer des vues, importer/exporter des données et des dictionnaires',
  projects_info: 'Un projet est un dépôt de données avec dictionnaire et de références à des ressources. Dans un projet, les données peuvent être importées, exportées, analysées and transformées. Les projets permettent de contrôler les accès auc dictionnaires, aux sommaires statistiques et aux données individuelles.',
  projects: 'Projets',
  properties: 'Propriétés',
  public_url: 'URL publique',
  query: 'Requête',
  quotation_mark: 'Marque de citation',
  r_activity_info: 'Temps effectif passé à exécuter des commandes R/DataSHIELD.',
  r_activity: 'Activité R/DataSHIELD',
  r_execution_time: 'Temps d\'exécution R',
  r_func: 'Fonction',
  r_packages_management_forbidden: 'La gestion des paquets R (installation, mise à jour, suppression) n\'est pas autorisée : il est recommandé d\'utiliser des images Docker validées des serveurs R, pour garantir la reproductibilité de l\'environnement d\'analyse R. En tant que développeur de paquets R, vous pouvez modifier les paramètres système pour activer cette fonctionnalité.',
  r_script: 'Script',
  r_service: 'Service R',
  r_sessions_activity: 'Activité des sessions R',
  r_sessions_count: 'Nombre de sessions R',
  range: 'Plage',
  realm: 'Domaine',
  reconnect_view: 'Reconnecter la vue',
  records: 'Enregistrements',
  referenced_entity_type_hint: 'Quand les valeurs sont des identifiants, la variable est une référence à une autre entité.',
  referenced_entity_type: "Type d'entité référencée",
  references: 'Références',
  refresh: 'Rafraîchir',
  register: 'Enregistrer',
  reload: 'Recharger',
  remove_from_cart: 'Retirer du panier',
  remove: 'Supprimer',
  renew: 'Renouveler',
  repeatable_hint: 'Quand une entitié peut avoir plusieurs valeurs pour cette variable.',
  repeatable: 'Répétable',
  report: 'Rapport',
  reset: 'Réinitialiser',
  resource: 'Ressource',
  resources_info: "Les ressources sont des ensembles de données ou des unités de calcul dont l'emplacement est décrit par une URL et dont l'accès est protégé par des informations d'identification. Lorsqu'ils sont affectés à une session de serveur R/DataSHIELD, des ensembles de données distants volumineux/complexes ou des ordinateurs hautes performances sont rendus accessibles aux analystes de données.",
  resources: 'Ressources',
  restore_views_files_hint: "Sélectionnez un ou plusieurs fichiers de sauvegarde de vue au format JSON (extraits depuis l'archive de sauvegarde au format zip).",
  restore_views_files: 'Fichiers de vue',
  restore_views_override_error: "La vue '{name}' existe déjà.",
  restore_views_override: 'Remplacer les vues existantes',
  restore_views: 'Restaurer des vues',
  restore: 'Restaurer',
  results: 'Résultats',
  role: 'Rôle',
  rservers_caption: "Configurer les serveurs R, accorder l'accès au service R",
  rservers: 'R',
  run: 'Exécuter',
  sample_quantiles: "Quantiles d'échantillon",
  sample: 'Échantillon',
  samples: 'Échantillons',
  save: 'Sauvegarder',
  schedule: 'Planification',
  script: 'Script',
  search_caption: 'Gérer les index de recherche',
  search: 'Recherche',
  select_columns: 'Sélectionner des colonnes',
  select_dictionary_file_template: 'Utilisez le modèle Excel suivant pour ajouter de nouvelles variables ou mettre à jour des variables existantes:',
  select_dictionary_file: "Sélectionner un fichier de dictionnaire de variables au format Excel ou un fichier XML de vue pour l'édition en lot des tables et des variables.",
  select_files_overwrite: 'Écraser les fichiers existants',
  select_files_to_upload: 'Sélectionner les fichiers à téléverser',
  select_import_options: "Sélectionner les options d'import",
  select_import_source: 'Sélectionner la source de données',
  select: 'Sélectionner',
  server: 'Serveur',
  servers: 'Serveurs',
  services: 'Services',
  settings: 'Configuration',
  signin_with: "S'identifier avec {provider}",
  size: 'Taille',
  skewness: 'Skewness',
  source_code: 'Code source',
  sql_history_hint: "Cliquer deux fois sur une requête pour la copier dans l'éditeur SQL.",
  sql_info: "Des requètes SQL peuvent être exécutées sur une ou plusieurs tables du projet. La permission de voir les valeurs des tables considérées est requise. Voir la [documentation de l'API SQL](https://opaldoc.obiba.org/en/latest/web-user-guide/projects/tables.html#sql) pour une description de la syntaxe et des fonctions.",
  sql_query_hint: "Saisissez une requête SQL et appuyez sur Ctrl-Entrée pour l'exécuter.",
  sql: 'SQL',
  start_time: 'Début',
  start: 'Démarrer',
  started: 'Début',
  state: 'État',
  statistics: 'Statistiques',
  status: 'Statut',
  std_dev: 'Écart type',
  stop: 'Arrêter',
  storage: 'Stockage',
  sub_total: 'Sous-total',
  submit: 'Soumettre',
  sum: 'Somme',
  summary: 'Sommaire',
  sumsq: 'Somme des carrés',
  system_settings: 'Paramètres du système',
  system: 'Système',
  table_identifiers_import_hint: 'La table dont les identifiants seront importés en tant qu\'identifiants système à mapper.',
  table_name: 'Nom de la table',
  table_references: 'Tables référencées',
  table: 'Table',
  tables_views: 'Tables (vues)',
  tables: 'Tables',
  tags: 'Étiquettes',
  tasks_caption: 'Monitorer l\'avancement des tâches',
  tasks: 'Tâches',
  taxonomies_caption: 'Gérer les taxonomies et les vocabulaires contrôlés',
  taxonomies_info: 'Les taxonomies sont utilisées pour classer les variables avec des vocabulaires controllés.',
  taxonomies: 'Taxonomies',
  term: 'Terme',
  terminate_r_sessions_confirm: '- | Êtes-vous sûr de vouloir terminer cette session R ? | Êtes-vous sûr de vouloir terminer ces {count} sessions R ?',
  terminate: 'Terminer',
  terms: 'Termes',
  test: 'Test',
  theoretical_quantiles: 'Quantiles théoriques',
  title_hint: 'Un titre pour les êtres humains.',
  title: 'Titre',
  to: 'À',
  token: 'Jeton',
  total_duration: 'Durée totale',
  total_execution_time: 'Temps d\'execution total',
  total: 'Total',
  type: 'Type',
  unique_name_hint: 'Le nom doit être unique.',
  unit_hint: "L'unité de mesure de la variable.",
  unit: 'Unité',
  unknown_error: 'Une erreur inconnue est survenue',
  unrecognized: 'Non reconnu',
  unregister: 'Désenregistrer',
  update_action: 'Mettre à jour',
  update_all_r_packages_note: "Cette opération mettra à jour tous les paquets R à la dernière version disponible sur CRAN. Il s'agit d'une tâche pouvant prendre beaucoup de temps. Si une erreur se produit, recherchez les raisons possibles (dépendance du système manquante, échec de la connexion réseau, etc.) en téléchargeant le log du serveur R.",
  update_all_r_packages_task_created: "La tâche de mise à jour de tous les paquets R a été créée avec l'identifiant [ {id} ].",
  update_all_r_packages: 'Mettre à jour tous les paquets R',
  update_method: 'Mettre à jour la méthode',
  update_option: "Mettre à jour l'option",
  update: 'Mise à jour',
  upload: 'Téléverser',
  usage: 'Utilisation',
  user_add_with_crt: 'Ajouter un utilisateur avec un certificat',
  user_add_with_pwd: 'Ajouter un utilisateur avec un mot de passe',
  user_add: 'Ajouter un utilisateur',
  user_delete: "Supprimer l'utilisateur",
  user_disable: "Désactiver l'utilisateur",
  user_edit: "Modifier l'utilisateur",
  user_enable: "Activer l'utilisateur",
  user_profiles_caption: 'Gérer les profils',
  user_profiles: 'Profils des utilisateurs',
  user: 'Utilisateur',
  username: "Nom d'utilisateur",
  users_and_groups_caption: 'Ajouter, mettre à jour, supprimer des utilisateurs et des groupes',
  users_and_groups: 'Utilisateurs et groupes',
  users_filter_placeholder: "Filtrer les utilisateurs par nom, groupe ou type d'authentification...",
  users_info: "Les utilisateurs peuvent se connecter à l'aide d'un mot de passe ou de manière programmatique en fournissant un certificat dans une connexion sécurisée (HTTPS).",
  users: 'Utilisateurs',
  value_type_hint: 'Le type de valeur de la variable.',
  value_type: 'Type de valeur',
  value: 'Valeur',
  values_index_clear_error: "Erreur lors de la suppression de l'index des valeurs.",
  values_index_cleared: "L'index des valeurs a été supprimé.",
  values_index_info: 'Les valeurs des tables sont à indexer manuellement (défaut), ou automatiquement en définissant une planification.',
  values_index: 'Index des valeurs',
  values: 'Valeurs',
  variable_name_hint: 'Le nom de la variable doit être unique dans sa table.',
  variable: 'Variable',
  variables_hint: "Sélectionnez des variables pour accèder à plus d'actions.",
  variables_index_clear_error: "Erreur lors de la suppression de l'index des variables.",
  variables_index_cleared: "L'index des variables a été supprimé.",
  variables_index_info: 'Les dictionnaires des tables sont indexés automatiquement. Supprimer cet index permet de re-indexer toutes les variables.',
  variables_index: 'Index des variables',
  variables_search_caption: 'Recherche de variables par nom, type, catégorie, etc.',
  variables_search_info: "Rechercher des variables à l'aide de vocabulaires contrôlés et d'une recherche en texte intégral. Les vocabulaires contrôlés sont définis par les taxonomies. La recherche en texte intégral s'applique au nom et aux libellés des variables. Voir la [documentation sur la recherche de variables](http://opaldoc.obiba.org/en/latest/web-user-guide/search/variables.html) pour plus de détails.",
  variables_search: 'Recherche de variables',
  variables: 'Variables',
  variance: 'Variance',
  vcf: 'VCF',
  version: 'Version',
  view_destination_hint: "La vue de destination sera créée si elle n'existe pas, sinon elle sera mise à jour en fusionnant les variables dérivées.",
  view_name: 'Nom de la vue',
  view: 'Voir',
  vocabularies: 'Vocabulaires',
  vocabulary: 'Vocabulaire',
  waiting: 'En attente',
  yes: 'Oui',
};
