export default {
  '2fa': {
    name: '2FA',
    title: 'Two-Factor Authentication',
  },
  app_configuration: {
    name_hint: 'A name for the application that represents your organization.',
    public_url_hint: 'Public base URL of the server.',
    logout_url_hint: 'Optional redirection URL after user has logged out.',
    languages_hint: 'The languages used to describe the dictionaries.',
    default_charset_hint: 'The default char set used when prompting dictionnaries data.',
    enforced_2fa_hint: 'Enforce users to set up their two-factor authentication secret. Does not apply to users defined in external user registries.',
    allow_r_packages_management: 'Allow R packages management',
    allow_r_packages_management_hint: 'Allow administrators to install, update and remove R packages on the R servers. Not recommended in a production environment.',
  },
  apps: {
    title: 'Apps',
    caption: 'Manage external applications providing services',
    info: 'An application is an external service that can be used by the system. Applications can be discovered from their URL or can register themselves using the application authentication token.',
    registry_list: 'Application Registry',
    discovery_info: 'Applications can be discovered at runtime (see {url} documentation). When discovered, the application is automatically registered. Then periodical checks are performed: if the application cannot be reached or reports to be dysfunctional, it is automatically unregistered.',
    apps_admin: 'Applications Administration',
    rock_info: 'Rock is an R server with a REST API (see {url} project). Adding more Rock apps instances allows to scale up the R analysis capacity.',
    host_hint: 'URL to connect with the Rock server, required.',
    unregister_confirm: "Please confirm that you want to unregister the application '{app}'. Some system functionalities may be degraded.",
    remove_config_confirm: "Please confirm that you want to remove the discovery of the Rock R server located at '{host}'. Note that this will not affect any corresponding app that would have been already registered.",
    add_service: 'Add app discovery',
    edit_service: 'Edit Service Discovery',
    manager_user: 'Manager and User',
    credential_hints: {
      default: 'Rock credentials are the default ones, as defined in the main Opal configuration file.',
      administrator: 'Rock credentials are the ones of a user with administrator role. It will be used both for managing the server (start/stop, R packages etc.) and for creating new R sessions.',
      manager_user: 'One Rock credentials for managing the server (start/stop, R packages etc.) and another one for creating new R sessions. Having both different user roles allows to restrict user privileges in the R sessions.',
    },
    name_hint: "Name of the Rock user with '{type}' role.",
    password_hint: "Password of the Rock user with '{type}' role.",
    self_register: 'Self-Registration',
    self_register_info: 'To register itself, an application must provide the following registration token in its request (see {url} documentation).',
    token_hint: 'A secret',
    edit_token: 'Edit Token',
  },
  auth: {
    title: 'Sign in to start your session',
    password: 'Password',
    signin: 'Sign in',
    signout: 'Sign out',
    username: 'User name',
    totp_help: 'Open the authenticator mobile app and scan this QR code to initialise your PIN code generator.',
    code: 'Code',
    code_hint: 'Enter the 6-digits PIN code.',
    validate: 'Validate',
  },
  auth_types: {
    PASSWORD: 'Password',
    CERTIFICATE: 'Certificate',
    UNRECOGNIZED: 'Unrecognized',
  },
  command_types: {
    import: 'Import',
    export: 'Export',
    copy: 'Copy',
    analyse: 'Analyse',
    import_vcf: 'Import VCF',
    export_vcf: 'Export VCF',
    backup: 'Backup',
    restore: 'Restore',
  },
  db: {
    data_databases: 'Data databases',
    data_databases_info: 'Data databases are used to store data tables and variables.',
    id_database: 'Identifiers database',
    id_database_info: 'Identifiers database is used to store identifiers mappings.',
    name_hint: 'The name of the database must be unique.',
    usage_hint: "Determine if this database will be proposed at import/export time or as a project's data storage.",
    driver: 'Driver',
    driver_hint: 'Specifies which driver should be used to connect to this database.',
    batch_size: 'Batch size',
    batch_size_hint: 'The number of rows to be processed in a batch.',
    register_sqldb: 'Register SQL DB',
    register_mongodb: 'Register MongoDB',
    unregister: 'Unregister',
    unregister_confirm: "Are you sure you want to unregister this database '{name}'? Note that the data WILL NOT be deleted.",
    test_error: 'Connection test failed',
    test_success: 'Connection test succeeded',
    in_use: 'In use',
    default_entity_type: 'Default entity type',
    default_entity_type_hint: 'Entity type to be used if no variables description tables is available.',
    default_id_column: 'Entity Identifier Column',
    default_id_column_hint: 'The column name for identifying the entity. Make sure it will not conflict with a variable column name.',
    default_updated_column: 'Update Timestamp Column',
    default_updated_column_hint: 'The column name for entity values last update date time, required for performing incremental imports. Make sure it will not conflict with a variable column name.',
    use_metadata_tables: 'With variables description tables',
    use_metadata_tables_hint: 'Export data dictionnaries to metadata tables.',
    save_error: 'Error saving database',
  },
  clipboard: {
    copy: 'Copy to clipboard',
    copied: 'Text copied to clipboard!',
    copy_error: 'Failed to copy text to clipboard',
  },
  datashield: {
    access_not_restricted: 'Any DataSHIELD user can access this profile.',
    access_restricted: 'Only permitted DataSHIELD users can access this profile.',
    aggregate_methods_info: 'The aggregation methods are used by DataSHIELD in order to compile individual data. The same aggregation methods must be defined in each DataSHIELD server that will be involved in a computation process. Each aggregation method is identified by a name that will be used from the DataSHIELD client.',
    assign_methods_info: 'The assign methods are used by DataSHIELD in order to transform individual data on server side. The same assign methods must be defined in each DataSHIELD server that will be involved in a computation process. Each assign method is identified by a name that will be used from the DataSHIELD client.',
    audit: 'Audit',
    audit_info: 'Datashield activity logs can be downloaded.',
    caption: 'Configure DataSHIELD, grant access to DataSHIELD service',
    delete_methods_confirm: '- | Are you sure you want to delete this DataSHIELD method? | Are you sure you want to delete these {count} DataSHIELD methods?',
    delete_options_confirm: '- | Are you sure you want to delete this R option? | Are you sure you want to delete these {count} R options?',
    download_all_logs: 'Download all logs',
    download_latest_logs: 'Download latest logs',
    method_func_hint: 'The R server side function that will be effectively called. Make sure there is no ambiguity by specifying the R package in which it is defined.',
    method_name_hint: 'The name of the DataSHIELD method name must be unique. This is the name of the allowed function that can be called by the DataSHIELD client.',
    method_script_hint: 'A custom R function implementation that will be effectively called.',
    option_name_hint: 'R option name.',
    option_value_hint: 'R option value. R syntax is expected: for instance use quotes for string values.',
    options_info: 'The R options are applied at DataSHIELD R session creation and affect the behavior of some of the DataSHIELD methods.',
    packages_info: 'DataSHIELD packages are a set of R packages that provide the DataSHIELD functionalities. They are installed in the R servers and are used by the DataSHIELD clients to perform the analysis.',
    profile_cluster_hint: 'The R servers cluster that will be used by this DataSHIELD profile.',
    profile_delete_confirm: 'Are you sure you want to delete this DataSHIELD profile?',
    profile_missing_cluster: 'The R servers cluster for this DataSHIELD profile does not exist.',
    profile_name_hint: 'The DataSHIELD profile name must be unique. This is the name that will be used by the DataSHIELD client to start a DataSHIELD session.',
    profile_settings_help: 'The DataSHIELD profile settings are used to define the aggregate/assign methods that are allowed to be called by a DataSHIELD and the R options that will be applied to the server-side DataSHIELD R session.',
    profile_access_toggle: 'Restrict access to this profile',
    profile_status_toggle: 'Activate or deactivate profile',
    profiles_info: 'A DataSHIELD profile is associated to a R servers cluster: the methods and options are extracted from the installed DataSHIELD packages settings and can be amended. ',
    settings_init_help: 'Select which DataSHIELD packages will get their methods and options applied to this profile.',
    settings_init: 'Initialize the DataSHIELD profile settings with selected DataSHIELD packages',
  },
  error: {
    Forbidden: 'This operation is forbidden',
    NoSuchValueTableInDatasource: 'The table does not exist or you do not have access to it',
    PasswordTooWeak: 'Password is too weak',
    OldPasswordMismatch: 'Old password is invalid',
    IllegalArgument: 'Invalid data',
    Conflict: 'Conflicting entry detected',
    BannedUser: 'Too many sign in failures, user {0} is banned for {1} seconds',
    InvalidCredentials: 'Invalid credentials, please try again',
    TableAlreadyExists: 'The table already exists',
    MagmaRuntimeException: 'An error occurred while processing the data: {0}',
    DuplicateIDProvider: 'The identity provider already exists',
    DuplicateSubjectToken: 'The token already exists',
    DuplicateTaxonomy: 'The taxonomy already exists',
    TaxonomyImportFailed: 'The taxonomy import failed, make sure to provide valid information',
    NoSuchTaxonomy: 'The taxonomy does not exist',
    NoSuchProject: 'The project does not exist',
    SQLError: 'An error occurred while processing the query: {0}',
    NoSuchVariableInTable: 'The variable does not exist in the table',
    AccessDeniedToTableValues: 'Access to the table values is denied',
  },
  identity_provider: {
    title: 'Identity Provider',
    name_hint: 'A unique name for the identity provider.',
    account_login: 'Account Login',
    client_id: 'Client ID',
    client_id_hint: 'Identification of the Opal server in the ID provider.',
    secret: 'Client Secret',
    secret_hint: 'Secret token of the Opal server in the ID provider.',
    discovery_uri: 'Discovery URI',
    discovery_uri_hint: '{url} to automatically get connection parameters.',
    discovery_uri_definition: 'OpenID Connect configuration discovery URI',
    label_hint: 'Label of the ID provider to be displayed in the sign-in button.',
    provider_url: 'Account Login',
    provider_url_hint: 'Link to the account login page so that user can manage its credentials.',
    groups_hint: 'Space separated list of group names that will be applied to each user who signs from this ID provider.',
    username_claim: 'Username Mapping',
    username_claim_hint: 'Optional name of the claim in the ID token and in the UserInfo response which value will represent the username in Opal. If not explicitly specified (or not found), the username will be looked up with the claims in the following order: "preferred_username", "username", "email", "name" and "sub" (subject ID).',
    scope: 'Scope',
    scope_hint: 'List of scope names to be specified to retrieve user information. Usually {openid} is enough and is the default.',
    groups_mapping: 'Groups Mapping',
    groups_claim: 'By claim value',
    groups_claim_hint: 'Optional name of the (non-standard) claim in the UserInfo response that represents the groups to which the user belongs. These groups will be applied to the authenticated user. The value of this claim can be an array of strings or a string of comma or space-separated group names. The default values is "groups".',
    groups_javascript: 'By javascript',
    groups_javascript_hint: 'An optional custom javascript to extract the array of group names from the UserInfo object. Allows to adapt to non-standard claims and to transform values into Opal group names. These groups will be applied to the authenticated user.',
    use_nonce: '{url} to validate ID token.',
    use_nonce_definition: 'Use Nonce',
    use_logout: '{url} to logout from both Opal and the ID provider.',
    use_logout_definition: 'Use Logout Endpoint',
    connect_timeout: 'Connection Timeout',
    connect_timeout_hint: 'Maximum time to wait before a connection is established, in milliseconds. Zero implies no timeout.',
    read_timeout: 'Read Timeout',
    read_timeout_hint: 'Maximum time to wait before a response is received, in milliseconds. Zero implies no timeout.',
    callback_url: 'Public URL',
    callback_url_hint: "In case Opal is accessible from different public URLs, it is possible to specify which one is to be used for this ID provider. When not specified, the system's public URL applies. Note that this ID provider will be only visible when Opal base URL matches this public URL.",
  },
  importer: {
    file: {
      csv: 'This format expects the file to use a "delimiter separated values" format (default delimiter being comma). The first column should represent the participant identifiers and the subsequent column names identify variables.',
      opal: 'This format comes as a .zip file containing a folder for each table having: the full data dictionary in a XML file, a XML data file per entity.',
      haven_rds: 'This format expects the file to be a valid RDS file containing an R object of tibble class. This import procedure requires a functional R server with the tibble package installed.',
      haven_sas: 'This format expects the file to be a valid SAS file containing the variables and the data. This import procedure requires a functional R server with the tibble and haven packages installed.',
      haven_sast: 'This format expects the file to be a valid SAS Transport file containing the variables and the data. This import procedure requires a functional R server with the tibble and haven packages installed.',
      haven_spss: 'This format expects the file to be a valid SPSS file, optionally compressed, containing the variables and the data. This import procedure requires a functional R server with the tibble and haven packages installed.',
      haven_stata: 'This format expects the file to be a valid Stata file containing the variables and the data. This import procedure requires a functional R server with the tibble and haven packages installed.',
    },
    server: {
      opal: 'This format imports variable dictionaries and data from a remote Opal.',
    },
    id_mappings: {
      hint: 'When a mapping of identifiers is selected, each identifier in the imported data will be mapped to a system identifier. Otherwise the imported identifier will be added to the system identifiers.',
      mapping_default: 'Default Each identifiers must be mapped prior importation',
      mapping_default_hint: 'Importation will fail if one imported identifier is not mapped to a system identifier.',
      mapping_ignore: 'Ignore unknown identifiers at import',
      mapping_ignore_hint: 'Data which identifier cannot be mapped to a system identifier will not be imported.',
      mapping_allow: 'Generate a system identifier for each unknown imported identifiers',
      mapping_allow_hint: 'A system identifier will be generated for each unknown imported identifier.',
    },
  },
  exporter: {
    file: {
      csv: 'This file will use a "delimiter separated values" format (default delimiter being comma). The first column will represent the participant identifiers and the subsequent column names identify variables.',
      opal: 'This format will be a .zip file, containing a folder for each table having: the full data dictionary in a XML file, a XML data file per entity.',
      haven_rds: 'This file will be in RDS format, containing an R object of tibble class. This export procedure requires a functional R server with the tibble package installed.',
      haven_sas: 'This file will be in SAS format, containing the variables and the data. This export procedure requires a functional R server with the tibble and haven packages installed.',
      haven_sast: 'This file will be in SAS Transport format, containing the variables and the data. This export procedure requires a functional R server with the tibble and haven packages installed.',
      haven_spss: 'This file will be in SPSS format, containing the variables and the data. This export procedure requires a functional R server with the tibble and haven packages installed.',
      haven_stata: 'This file will in Stata format, containing the variables and the data. This export procedure requires a functional R server with the tibble and haven packages installed.',
    },
  },
  access: {
    undefined: '',
    DEFAULT: 'Default',
    READ: 'Read only',
    READ_NO_VALUES: 'Read only, without individual-level data',
  },
  acls: {
    // global permissions
    PROJECT_ADD: {
      label: 'Add projects',
      description: 'Add new projects and therefore can import/export data in the context of the project.',
    },
    PROJECT_ALL: {
      label: 'Administrate projects',
      description: 'Full access to project.',
    },
    SYSTEM_ALL: {
      label: 'Administrate system',
      description: 'Access to all resources and actions in the system (trusted users only!).',
    },
    // r service
    R_USE: {
      label: 'Use R service',
      description: 'Can push accessible data to an R server session and can execute ANY R commands on them (trusted users only!).',
    },
    // datashield service
    DATASHIELD_USE: {
      label: 'Use DataSHIELD service',
      description: 'Can push accessible data to an R server session and can execute limited R commands on them.',
    },
    DATASHIELD_ALL: {
      label: 'Administrate DataSHIELD service',
      description: 'Administrate DataSHIELD settings.',
    },
    // datashield profile
    DATASHIELD_PROFILE_USE: {
      label: 'Use DataSHIELD profile',
      description: 'Can push accessible data to R and can execute limited R commands on them, in the context of this DataSHIELD profile.',
    },
    // datasource permissions
    DATASOURCE_VIEW: {
      label: 'View dictionary and values of all tables',
      description: 'Read access to project tables, including individual values.',
    },
    TABLE_ADD: {
      label: 'Add table',
      description: 'Add tables or views.',
    },
    DATASOURCE_ALL: {
      label: 'Administrate tables',
      description: 'Full access to project tables, including individual values.',
    },
    // table permissions
    TABLE_READ: {
      label: 'View table dictionary and summaries',
      description: 'View dictionary and summaries (no access to individual values).',
    },
    TABLE_VALUES: {
      label: 'View table dictionary and values',
      description: 'View dictionary with access to individual values.',
    },
    TABLE_EDIT: {
      label: 'Edit table dictionary and view summaries',
      description: 'Edit dictionary and view values summary (no access to individual values).',
    },
    TABLE_VALUES_EDIT: {
      label: 'Edit table dictionary and view values',
      description: 'Edit dictionary and view individual values.',
    },
    TABLE_ALL: {
      label: 'Administrate table',
      description: 'Full access to the table, including edition of the dictionary and individual values.',
    },
    // variable permissions
    VARIABLE_READ: {
      label: 'View variable with summary',
      description: 'View variable description and values summary (no access to individual values).',
    },
    // file permissions
    FILES_READ: {
      label: 'Access files',
      description: 'Access files without the permission to add or delete.',
    },
    FILES_SHARE: {
      label: 'Add and access files',
      description: 'Add and access files without the permission to delete.',
    },
    FILES_ALL: {
      label: 'Administrate files',
      description: 'Full access to files.',
    },
    // resource permissions
    RESOURCE_ALL: {
      label: 'Administrate',
      description: 'Full access to the resource.',
    },
    RESOURCES_ALL: {
      label: 'Administrate',
      description: 'Full access to project resources.',
    },
    RESOURCE_VIEW: {
      label: 'View resource (no credentials)',
      description: 'View resource without having access to the associated credentials (DataSHIELD compliant permission).',
    },
    RESOURCES_VIEW: {
      label: 'View any resource (no credentials)',
      description: 'View any resource without having access to the associated credentials (DataSHIELD compliant permission).',
    },
    // database permissions
    DATABASES_ALL: {
      label: 'DATABASES_ALL',
      description: 'DATABASES_ALL',
    },
    // vcf permissions
    VCF_STORE_ALL: {
      label: 'Administrate VCF Store',
      description: 'Import/Export VCF files, view statistics and set samples-participants mapping table.',
    },
    VCF_STORE_VALUES: {
      label: 'View VCF files data and statistics',
      description: 'Export VCF files and view statistics.',
    },
    VCF_STORE_VIEW: {
      label: 'View VCF files statistics',
      description: 'View VCF files and statistics.',
    },
  },
  analysis_status: {
    IN_PROGRESS: 'In progress',
    PASSED: 'Passed!!!',
    FAILED: 'Failed',
    ERROR: 'Error',
    IGNORED: 'Ignored',
    UNRECOGNIZED: 'Unrecognized',
  },
  analyse_validate: {
    info: 'Analyses can improve data quality by detecting inconsistencies through validation rules and custom reports.',
    add: 'New Analysis',
    analyse_command_created: 'Analysis task created with identifier [ {id} ].',
    delete_analysis_confirm: 'Are sure you want to delete the \'{name}\' analysis and its associated results. This cannot be undone and all data will be lost.',
    analysis_dialog: {
      add_analysis: 'Add Analysis',
      title: 'Add Analysis',
      variables_hint: 'The variable names (comma separated) to which to the analysis applies. If not specified all the table variables will be analysable.',
      type_hint: 'Apply data validation rules. Validating data is all about checking whether a data set meets presumptions or expectations you have about it. Based on the validate R package which is intended to make checking your data easy, maintainable and reproducible.'
    }
  },
  id_mappings: {
    title: 'Identifiers Mappings',
    info: 'Identifiers mappings are defined per entity type. Mapping identifiers consist of associating, for a given entity, its identifier in the system to its identifiers in the data being imported or exported.',
    ids_list_title: 'Identifiers Tables',
    manage_caption: 'Manage identifiers mappings',
    mappings_count: 'Identifier mappings',
    system_ids_count: 'System identifiers',
    add_identifier: 'Add Identifiers Table',
    generate_identifiers: 'Generate Identifiers',
    download_identifiers: 'Download Identifiers',
    delete_identifier: 'Remove Identifiers Table',
    delete_identifier_confirm: "Are you sure you want to remove the '{entityType}' identifiers table. This cannot be undone and all identifiers of this table will be lost.",
    add_mapping: 'Add Identifiers Mapping',
    edit_mapping: 'Edit Identifiers Mapping',
    delete_mapping: 'Remove Identifiers Mapping',
    delete_mapping_confirm: "Are you sure you want to remove '{name}' identifiers mapping. This cannot be undone and all identifiers of this mapping will be lost.",
    generate_identifiers_info: '{count} new identifier will be generated for this mapping. To customize the identifier format modify the settings below.',
    generate_identifiers_warning: 'This mapping has no system identifiers; please import them before generating new ones using the options below.',
    sample_identifier: 'Sample Identifier: {sample}',
    identifier_size: 'Identifier Size',
    identifier_size_hint: 'Identifier size must be {min} to {max} digits long',
    with_checksum: 'With Checksum Digit',
    with_checksum_hint: 'Generate identifiers with its Luhn checksum.',
    identifier_prefix: 'Identifier Prefix',
    leading_zero: 'Allow leading zeros',
    import_identifiers_list: 'Import System Identifiers from List',
    import_identifiers_table: 'Import System Identifiers from Table',
    import_identifiers_mapping: 'Import Identifiers Mapping',
    mapping_name_hint: 'An identifiers mapping must have a unique name. If the mapping does not exist, it will be created when you type a new name and press ENTER.',
    system_identifiers: 'System Identifiers',
    mapped_identifiers: 'Mapped Identifiers',
    import_table_sys_ids_info: 'The table which entity identifiers will be copied as system identifiers. New identifiers will be added, existing ones will be ignored.',
    entity_type_no_tables: "There are no tables for entity type '{entityType}'.",
    no_database_warning: 'There are no identifiers database configured.',
  },
  git: {
    diff_viewer: {
      title: 'Commit Details',
    },
  },
  key_type: {
    KEY_PAIR: 'Key Pair',
    CERTIFICATE: 'Certificate',
    UNRECOGNIZED: 'Unrecognized',
  },
  project_admin: {
    properties: 'Project properties',
    db_hint: 'Project tables (dictionaries and data) are stored in the database:',
    db_reload_hint: 'Reloading a project database makes its data temporarily inaccessible (no table listing, no import or export) while the connection to the database is being re-initialised. The time taken by this operation depends on the database type and schema.',
    db_reload_confirm: 'Are you sure you want to reload the project database?',
    backup_restore: 'Backup / Restore',
    backup_project: 'Backup Project',
    backup_hint: 'The project backup task has a limited scope: tables (dictionary and data export), views (either as a logical table or as an exported table), resources and files. Other project elements that are not part of the backup: user and group permissions, view change history, table analysis etc.',
    backup_success: 'Project backup task has been launched. You can follow its progress in the task list.',
    backup_folder: 'Backup Folder',
    restore_project: 'Restore Project',
    restore_folder: 'Backup Folder or Archive',
    restore_hint: 'Restore the data of a project from a backup archive file to be found on the file system.',
    restore_override: 'Override existing items',
    views_as_table: 'Views as tables, i.e. export data instead of keeping derivation scripts',
    danger_zone: 'Danger Zone',
    danger_zone_info: 'Archiving a project makes its data inaccessible. Project tables, views, files and keystore will remain untouched. These data will be reinstated when a project with the same name is added. Note that project description and permissions will be deleted permanently.',
    archive_confirm: 'Please confirm that you want to remove the current project and keep all associated data?',
    archive: 'Archive Project',
    remove_info: 'Removing a project destroys all associated data and files. It can be a long running task and there is no going back.',
    remove_confirm: "Please confirm that you want to remove permanently the current project and all associated data. This operation can't be undone.",
    remove: 'Remove Project',
    edit: 'Edit Project',
    no_database_warning: 'No database is defined, so data cannot be imported. Only views and resources can be added.',
    entity_type_hint: 'What the identifiers are about.',
    id_mappings_info: 'Identifiers mappings listed below that match the entity type of the data are automatically selected during an import/export process.',
    id_mappings_hint: 'The name of the mapping.',
    id_mapping: 'Identifiers Mapping',
    encryption_keys: 'Encryption Keys',
    encryption_keys_info: 'Encrypted data will be automatically decrypted at importation time using the key pairs registered within the project.',
    import_key: 'Import Key Pair',
    import_key_info: 'Paste encryption key in PEM format.',
    private_key: 'Private Key',
    public_key: 'Public Key (Certificate)',
    vcf_store_hint: 'Project genotypes are stored using the service:',
    no_vcf_store_warning: 'No VCF store is defined for this project. No genotypes can be imported.',
  },
  user_profile: {
    title: 'My profile',
    groups: 'Your account belongs to the group | Your account belongs to the {count} groups',
    password_update_not_allowed: "Your account was defined in the user directory '{realm}'. Please contact your system administrator to change the password in this directory.",
    '2fa_info': 'In addition to your username/password authentication, a dynamic password (also called one-time password) can be requested for an enhanced security of your account access. This one-time password is time-based (TOTP): to generate the temporary PIN code, install the Microsoft Authenticator app ({androidOtp} or {iosOtp}) or the FreeOTP+ app ({androidOnlyOtp}) on your mobile device, enable 2FA in your profile and follow instructions to initialise the authenticator app.',
    android_otp: 'Android',
    android_only_otp: 'Android only',
    ios_otp: 'iOS',
    update_password: 'Update Password',
    external_account: 'External account',
    enable_2fa: 'Enable 2FA',
    disable_2fa: 'Disable 2FA',
    otp_qr_core_info: 'Open the authenticator mobile app and scan this QR code to initialise your PIN code generator:',
    all_projects: 'All Projects',
    personal_access_tokens: 'Personal Access Tokens',
    tokens_info: 'Personal access tokens can be created for use in scripts and on the command line (using R or Python client API). Be careful, these tokens are like passwords so you should guard them carefully. The advantage to using a token over putting your password into a script is that a token can be revoked, and you can generate lots of them. The scope of the access granted to the token can be restricted by projects, operations that can performed on these projects and system services. Note that this scope does not grant new permissions but rather alter the ones you have.',
    add_token: 'Add Access Token',
    add_datashield_token: 'Add DataSHIELD Token',
    add_r_token: 'Add R Token',
    add_sql_token: 'Add SQL Token',
    add_custom_token: 'Add Custom Token',
    no_tokens: 'No personal access tokens.',
    password_dialog: {
      old_password: 'Old Password',
      new_password: 'New Password',
      info: "{'The password must contain at least 8 characters, with at least one digit, one upper case alphabet, one lower case alphabet, one special character (which includes @#$%^&+=!) and no white space.'}",
    },
    token_dialog: {
      add_datashield_token: 'Add DataSHIELD Token',
      add_r_token: 'Add R Token',
      add_sql_token: 'Add SQL Token',
      add_custom_token: 'Add Custom Token',
      name_hint: 'The name or short description of this API access token so that you can remember its usage.',
      projects_hint: 'Access can be limited to some projects. Leave empty to apply no restrictions.',
      project_access: 'Project Data Access',
      project_access_hint: 'Data access can be limited to read operations. Limiting data access affects which project tasks can be performed and which services can be used.',
      project_tasks: 'Project Tasks',
      project_tasks_hint: 'Select the project tasks that can be performed using the token. By default none is available.',
      project_administration: 'Project Administration',
      project_administration_hint: 'Select the project administration operations that can be performed using the token. By default none is available.',
      services: 'Services',
      services_hint: 'Select the system services that can be performed using the token. By default none is available.',
    },
  },
  token_services: {
    useR: 'R',
    useDatashield: 'DataSHIELD',
    useSQL: 'SQL',
    sysAdmin: 'Administration',
  },
  token_administration: {
    createProject: 'Create',
    updateProject: 'Update',
    deleteProject: 'Delete',
  },
  // value types
  text: 'Text',
  integer: 'Integer',
  decimal: 'Decimal',
  date: 'Date',
  datetime: 'DateTime',
  point: 'Point',
  linestring: 'LineString',
  polygon: 'Polygon',
  binary: 'Binary',
  boolean: 'Boolean',
  locale: 'Locale',
  validation: {
    name_required: 'Name is required',
    password_required: 'Password is required',
    entity_type_required: 'Entity Type is required',
    range: 'Value must be between {min} and {max} inclusively',
    identifiers_required: 'Identifiers are required',
    table_name_required: 'Table name is required',
    missing_required_fields: 'Missing required fields',
    folder: {
      invalid_chars: 'Folder names cannot contain: \'{chars}\'',
      dot_name: 'The names \'.\' and \'..\' are not permitted',
    },
    password_min_length: 'Password must be at least {min} characters long',
    user: {
      password_required: 'Password is required and must be at least 8 characters long',
      certificate_required: 'Certificate is required',
      confirm_password_required: 'Confirm password is required',
      passwords_not_matching: 'Passwords do not match',
    },
    identity_provider: {
      clientId_required: 'Client ID is required',
      secret_required: 'Secret is required',
      discovery_uri_required: 'Discovery URI is required',
      discovery_uri_format: 'Discovery URI must begin with "https://" or "http://"',
      provider_url_format: 'Account login must begin with "https://" or "http://"',
      callback_url_format: 'Public URL must begin with "https://" or "http://"',
      scope_required: 'Scope is required',
    },
    update_password: {
      old_password: 'Old password is required',
      new_password: 'New password is required and must be at least 8 characters long',
    },
    text_required: 'A text is required',
    github: {
      org_required: 'Github organization or username is required',
      repo_required: 'Github repository name is required',
    },
    project_admin: {
      backup_folder_required: 'Backup folder is required',
      private_key_required: 'Private Key in PEM format is required',
      public_key_required: 'Public Key (Certificate) in PEM format is required',
    },
    apps: {
      host_required: 'Host is required',
      host_uri_format: 'Host must begin with "https://" or "http://"',
    },
    analysis: {
      name_exists: 'Analysis name must be unique',
    }
  },
  main: {
    brand: 'Opal',
    powered_by: 'Powered by',
    two_fa_info: 'You should enhance your account security with two-factor authentication.',
    two_fa_link: 'Enable 2FA',
    python_api: 'Learn how to use the Python API and command line tools.\n\n[Python user guide](https://opaldoc.obiba.org/en/latest/python-user-guide/index.html)',
    r_api: 'Learn how to use the R API to manage data and perform DataSHIELD operations.\n\n[R/DataSHIELD user guide](https://opaldoc.obiba.org/en/latest/r-user-guide/index.html)',
    javascript_api: 'Learn how to use the Javascript API to derive variables.\n\n[Javascript user guide](https://opaldoc.obiba.org/en/latest/magma-user-guide/index.html)',
  },
  plugin: {
    installed: 'Installed',
    available: 'Available',
    updates: 'Updates',
    advanced: 'Advanced',
    installed_plugins_info: 'List installed plugins. Installing or removing a plugin requires a system restart to be effective.',
    restart: 'Restart',
    install_success: 'Plugin has been installed',
    restarted: 'Plugin has been restarted',
    restart_failed: 'Plugin restart failed',
    configure: 'Configure',
    system_restart_required: 'System restart is required to have the installation/removal of plugins effective.',
    site_properties: 'Site Properties',
    site_properties_hint: 'Plugin installation site specific properties. These properties enhance or override the built-in properties of the plugin. Plugin service restart is usually required to make the changes effective.',
    updates_plugins_info: 'List updates of installed plugins available for install.',
    no_updates: 'No updates available',
    available_plugins_info: 'List new plugins available for install.',
    none_available: 'No plugins available',
    archive_installation: 'Archive Installation',
    archive_info: 'A plugin archive can be installed from a selected file. Expected file suffix is "-dist.zip".',
    archive_file: 'Archive file',
    update_site: 'Plugins Repository',
    update_site_info: 'The repository of plugin packages is checked for installed plugins updates and new plugins available for download and install.',
    last_update: 'Last repository check: {ago}',
  },
  r: {
    cluster: 'Cluster',
    clusters_count: 'No cluster of R servers | 1 cluster of R servers | {count} clusters of R servers',
    packages_warn: 'This operation may seem convenient but it is not recommended in a production environment. It is best to deploy the R server using a validated Docker image to ensure reproducibility of the R analysis environment.',
    servers_info: 'R servers are grouped by clusters. In each cluster all the R servers are considered to be interchangeable, i.e. a load balancer can select one or the other on R session creation.',
    servers: 'R servers',
    sessions_counts: '{count} ({active} active)',
    sessions_info: 'R server activity monitoring: each R session is a computation unit started by R/DataSHIELD users or by internal processes. R sessions without activity for a while will be automatically terminated.',
    sessions: 'R sessions',
    system: '{cores} cores, {memory} free memory',
    version: 'R version',
    workspaces_info: "R workspaces storage: each saved R/DataSHIELD workspace contains the session's image and files (if any). These can be restored any number of times on user demand.",
    workspaces: 'R workspaces',
    clear_cache: 'Clear R cache',
  },
  resource_ref: {
    label: 'Resource reference',
    provider: 'Provider',
    provider_not_found: 'Provider not found: no R server can provide a way to make this resource available. Is the R package {provider} installed?',
    test_success: 'Resource assignment successful.',
    test_error: 'Resource assignment failed.',
    add_from_provider: 'Add from {provider}',
    name_hint: 'The name of the resource, unique in the project.',
    description_hint: 'A short description of the resource, optional.',
    category: 'Category',
    category_hint: 'The type of resource.',
    factory: 'Factory',
    factory_hint: 'How to make a resource.',
    view_destination_hint: 'The destination view will be created if it does not exist, otherwise it will be updated.',
    entity_type_hint: 'What these view data are about.',
    id_column: 'ID column',
    id_column_hint: "The column name in the resource's tabular representation that provides the entity identifiers. If not specified, the first column will be used.",
    all_columns: 'All columns',
    all_columns_hint: "When checked, all the observed resource's columns (except the identifier's column) will be mapped to a variable when the connection with the resource is established. This means that when a new column appears in the resource, a corresponding variable will be automatically added.",
    r_server_profile: 'R server profile',
    r_server_profile_hint: 'Optional R server profile name to be used for establishing the connection with the resource. If not specified, the profile will be guessed based on the R package associated to the resource.',
    from_hint: 'The full name of the resource to be connected and coerced to its tabular representation.',
  },
  taxonomy: {
    title: 'Taxonomy',
    name_hint: 'A taxonomy must have a unique name.',
    author_hint: 'The taxonomy author can be specified (for copyright).',
    license_hint: 'License type that applies to this taxonomy. See suggested {url}.',
    creative_commons_licenses: 'Creative Commons Licenses',
    description_hint: 'Optional description of the taxonomy.',
    add: 'Add Taxonomy',
    edit: 'Edit Taxonomy',
    new_taxonomy: 'New Taxonomy',
    import_mlstr: 'Maelstrom Research Taxonomies',
    import_github: 'GitHub Repository',
    import_file: 'YAML File',
    change_history: 'History of Changes',
    compare_current: 'Compare with current',
    restore_confirm: "Are you sure you want to restore the version from '{date}'? This will replace the current information.",
    filter_vocabulary: 'Filter vocabularies...',
    vocabulary: {
      title: 'Vocabulary',
      name_hint: 'A vocabulary must have a unique name.',
      description_hint: 'Optional description of the vocabulary.',
      add: 'Add Vocabulary',
      edit: 'Edit Vocabulary',
      repeatable: 'Repeatable',
      repeatable_hint: 'When several terms of this vocabulary can be applied to a variable.',
      filter_terms: 'Filter terms...',
    },
    term: {
      title: 'Term',
      name_hint: 'A term must have a unique name.',
      description_hint: 'Optional description of the term.',
      add: 'Add Term',
      edit: 'Edit Term',
      keywords_hint: 'Optional list of keywords of the term. Can be useful when building variable search requests.',
    },
    import_mlstr: {
      label: 'Maelstrom Research Taxonomies',
      title: 'Import Maelstrom Research Taxonomies',
      info: 'The {mlstr_url} variable classification taxonomies allow annotating study and harmonized variables to facilitate metadata browsing and enhance data discoverability on the {mica_url} data web portal.',
      versions: 'Released Versions',
      versions_hint: 'These taxonomies are available under the {url}',
      versions_hint_url: 'Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International Public License.',
      license_agreement: 'I have read and accepted the license terms.',
    },
    import_github: {
      label: 'From GitHub Repository',
      title: 'Import GitHub Repository',
      org_hint: 'Example: maelstrom-research',
      repo_hint: 'Example: maelstrom-taxonomies',
      ref_hint: 'Example: Repository branch name (e.g. master), release version (1.0) or a commit id.',
      file: 'File',
      file_hint: 'Taxonomy YAML file name (e.g. taxonomy.yml or scales/taxonomy.yml). Leave this field empty to import all taxonomy files.',
      override: 'Override existing taxonomies',
    },
    import_file: {
      label: 'From YAML File',
      title: 'Import YAML File',
    },
  },
  vcf_store: {
    label: 'VCF Store',
    identified_samples: 'Identified Samples',
    controls: 'Controls',
    sample_participants_mapping: 'Sample-Participants Mapping',
    sample_participants_mapping_info: 'Enhance the description of the genotypes with a table describing the samples: associated participant ID and case-controls identification.',
    add_mapping: 'Add Mapping',
    update_mapping: 'Update Mapping',
    no_mapping_tables: 'There is no mapping table available.',
    mapping_table_hint: "Genotype's mapping table.",
    participant_id: 'Participant ID Variable',
    participant_id_hint: 'The participant ID variable name.',
    role: 'Sample Role Variable',
    role_hint: 'The sample Role variable name.',
    vcf_files: 'VCF Files',
    variants: 'Variants',
    genotypes: 'Genotypes',
    import_vcf_file: 'Import VCF File',
    export_vcf_file: 'Export VCF File',
    import_vcf_file_label: 'VCF/BCF File',
    import_vcf_file_hint: 'A VCF/BCF (optionally compressed) file, with suffix .vcf, .vcf.gz, .bcf or .bcf.gz.',
    import_vcf_command_created: 'Import VCF files task created with identifier [ {id} ].',
    export_participants_filter_label: 'Participants Filter',
    export_vcf_file_label: 'One VCF file is selected for export. | {count} VCF files are selected for export.',
    export_mapping_table_hint: 'Select a table to provide the set of participants from wich samples will be included in the VCF file. If no table is selected, no participant filter will be applied.',
    export_vcf_command_created: 'Export VCF files task created with identifier [ {id} ].',
    export_case_control_label: 'Include case controls',
    export_id_mappings_label: 'Participants Identifiers Mapping',
    export_id_mappings_hint: 'Select a mapping of participant identifiers to be used when exporting sample participant ID correspondence.',
  },
  stats: {
    min: 'Minimun',
    max: 'Maximum',
    mean: 'Mean',
    stdDeviation: 'Standard deviation',
    total: 'Sum',
    variance: 'Variance',
    count: 'N',
  },
  table_index: {
    status_title: {
      NOT_INDEXED: 'The table index is not indexed. Indexing is recommended for better performance when fetching the variables summary statistics.',
      OUTDATED: 'The table index is outdated. Indexing is recommended for better performance when fetching the variable summary statistics.',
      IN_PROGRESS: 'The table indexing is in progress.',
      UPTODATE: 'The table index is up to date.',
      UNRECOGNIZED: 'The table index is in an unrecognized state.',
    },
    status: {
      NOT_INDEXED: 'Not indexed',
      OUTDATED: 'Outdated',
      IN_PROGRESS: 'In progress',
      UPTODATE: 'Up to date',
      UNRECOGNIZED: 'Unrecognized',
    },
  },
  variable_nature: {
    CATEGORICAL: 'Categorical',
    CONTINUOUS: 'Continuous',
    TEMPORAL: 'Temporal',
    GEO: 'Geographical',
    BINARY: 'Binary',
    UNDETERMINED: 'Undetermined',
  },
  schedule_type: {
    NOT_SCHEDULED: 'Not scheduled',
    MINUTES_5: 'Every 5 minutes',
    MINUTES_15: 'Every 15 minutes',
    MINUTES_30: 'Every 30 minutes',
    HOURLY: 'Hourly',
    DAILY: 'Daily',
    WEEKLY: 'Weekly',
    UNRECOGNIZED: 'Unrecognized',
  },
  weekdays: {
    SUNDAY: 'Sunday',
    MONDAY: 'Monday',
    TUESDAY: 'Tuesday',
    WEDNESDAY: 'Wednesday',
    THURSDAY: 'Thursday',
    FRIDAY: 'Friday',
    SATURDAY: 'Saturday',
    UNRECOGNIZED: 'Unrecognized',
  },
  account: 'Account',
  actions: 'Actions',
  add_a_view: 'Add view',
  add_categories_range: 'Add category range',
  add_category: 'Add a category',
  add_folder: 'Add folder',
  add_group_permission: 'Add group permission',
  add_method: 'Add method',
  add_option: 'Add option',
  add_permission: 'Add permission',
  add_profile: 'Add profile',
  add_project: 'Add Project',
  add_table: 'Add table',
  add_tables: 'Add/update some tables',
  add_to_cart: 'Add to cart',
  add_to_view_info: '- | One derived variable will be added/updated. | {count} derived variables will be added/updated.',
  add_to_view: 'Add to view',
  add_user_permission: 'Add user permission',
  add_variable: 'Add variable',
  add_view: 'Add view',
  add: 'Add',
  administration: 'Administration',
  administrator: 'Administrator',
  advanced_options: 'Advanced options',
  advanced_search: 'Advanced search',
  all_categories: 'All',
  all_projects: 'All',
  anaylses: 'Analyses',
  annotate_info: '- | One variable will be annotated. | {count} variables will be annotated.',
  annotate: 'Annotate',
  annotation_texts_hint: 'Annotate with free text. For human readibility, you can provide a different text for each language. For machine processing or not localized text, choose "default" language. Empty text will be ignored. Markdown text format is supported.',
  annotations: 'Annotations',
  annotations: 'Annotations',
  apply_annotation: 'Apply annotation',
  apply: 'Apply',
  at: 'At',
  attribute_name_hint: 'A name for the attribute is required.',
  attribute_namespace_hint: 'A namespace is optional.',
  attributes_annotations_info: 'Annotations are attributes that are described by taxonomies. They are used to provide additional information or to classify the variable.',
  attributes_info: 'Attributes can be used to store metadata in a structured way.',
  attributes_records_info: 'These are the attributes as they are stored in the variable dictionary. The triplet (namespace, name, locale) defines uniquely an attribute. For annotations, the "namespace" is the taxonomy name, the "name" is the vocabulary name in the taxonomy and the "value" is the term in the vocabulary. Other reserved attribute names are "label", "description" and "script" (without namespace).',
  attributes: 'Attributes',
  auth_method: 'Authentication method',
  authentication: 'Authentication',
  author: 'Author',
  back: 'Back',
  backup: 'Backup',
  bookmark_add: 'Add to favorites',
  bookmark_remove: 'Remove from favorites',
  bookmarks: 'Favorites',
  built: 'Built',
  busy: 'Busy',
  cache: 'Cache',
  cancel_task_confirm: 'Are you sure you want to cancel this task?',
  cancel: 'Cancel',
  cart: 'Cart',
  categorical_variable_hint: 'Categorical or logical variable',
  categorical_variable: 'Categorical variable',
  categories_range_hint: "Use hyphen '-' to specify a range of numerical values and comma ',' to separate names or ranges of names, for example: '1-4, 9', or 'A, B, C'. Existing categories will not be overridden.",
  categories: 'Categories',
  certificate_placeholder: 'Paste your certificate here',
  certificate: 'Certificate',
  char_set: 'Character set',
  clear_tasks_confirm: 'No tasks to clear | Are you sure you want to clear this task? (does not apply if task is running) | Are you sure you want to clear these {count} tasks? (running tasks will not be affected)',
  clear: 'Clear',
  close: 'Close',
  cluster: 'Cluster',
  code: 'Code',
  comment: 'Comment',
  compare: 'Compare',
  configuration: 'Configuration',
  configure_import_source: 'Configure import source',
  configure: 'Configure',
  confirm: 'Confirm',
  content: 'Content',
  context: 'Context',
  contingency_table_info: 'Displays the multivariate frequency distribution of selected variables.',
  contingency_table: 'Contingency table',
  continue: 'Continue',
  copy_data: 'Copy data',
  copy_incremental_hint: 'Whether only new or updated data will be copied.',
  copy_incremental: 'Incremental',
  copy_nulls_hint: 'Whether a data can be overridden by a null value.',
  copy_nulls: 'Copy null values',
  copy_tables_data_task_created: 'Copy tables data task created with identifier [ {id} ].',
  copy_tables_data_text: 'No tables to be copied | One table will be copied | {count} tables will be copied.',
  copy_tables_data: 'Copy table data | Copy table data | Copy tables data',
  copy_view: 'Copy view',
  copy: 'Copy',
  created: 'Created on',
  credentials: 'Credentials',
  current: 'Current',
  dashboard: 'Dashboard',
  data_access: 'Data access',
  data_analysis: 'Data analysis',
  data_file: 'Data file',
  data_format: 'Data format',
  data_management: 'Data management',
  data_server: 'Data server',
  database: 'Database',
  databases_caption: 'Manage identifiers database and data databases for storage, import and export',
  databases: 'Databases',
  datashield_profile: 'DataSHIELD Profile',
  datashield_service: 'DataSHIELD Service',
  day: 'Day',
  default_charset: 'Default charset',
  default_storage: 'Default storage',
  default_value_type: 'Default value type',
  default: 'Default',
  delay: 'Delay',
  delete_annotation_confirm: 'Are you sure you want to delete this annotation?',
  delete_annotation: 'Delete annotation',
  delete_attributes_confirm: 'Are you sure you want to delete this attribute (all languages)?',
  delete_categories_confirm: '- | Are you sure you want to delete this category? | Are you sure you want to delete these {count} categories?',
  delete_files_confirm: '- | Are you sure you want to delete this file? | Are you sure you want to delete these {count} files?',
  delete_group_confirm: "Are you sure you want to delete the group '{group}'?",
  delete_identity_provider_confirm: "Are you sure you want to delete the provider '{provider}'?",
  delete_permission_confirm: "Are you sure you want to delete permission of '{principal}'?",
  delete_profile_acl_confirm: 'Are you sure you want to revoke the selected permission? | Are you sure you want to revoke these {count} permissions?',
  delete_profile_confirm: "Are you sure you want to delete profile '{profile}'?",
  delete_profiles_confirm: "Are you sure you want to delete  profile '{profile}'? | Are you sure you want to delete these {count} profiles?",
  delete_profiles_selected: 'Delete selected profiles',
  delete_r_package_confirm: 'The deletion of an R package may not succeed if it is installed in a folder that is not writable. Are you sure you want to delete the R package "{name}"?',
  delete_r_workspaces_confirm: '- | Are you sure you want to delete this R workspace? | Are you sure you want to delete these {count} R workspaces?',
  delete_resources_confirm: 'No resources to delete | Are you sure you want to delete this resource? | Are you sure you want to delete these {count} resources?',
  delete_tables_confirm: 'No tables to delete | Are you sure you want to delete this table? | Are you sure you want to delete these {count} tables?',
  delete_taxonomy_confirm: "Are you sure you want to delete taxonomy '{taxonomy}'?",
  delete_term_confirm: "Are you sure you want to delete term '{term}' from '{vocabulary}' vocabulary?",
  delete_token_confirm: "Are you sure you want to delete token '{token}'?",
  delete_user_confirm: "Are you sure you want to delete user '{user}'?",
  delete_variables_confirm: 'No variables to delete | Are you sure you want to delete this variable? | Are you sure you want to delete these {count} variables?',
  delete_vcf_confirm: 'Are you sure you want to remove the selected VCF file | Are you sure you want to remove these {count} VCF files.',
  delete_vcf_mapping_confirm: "Please confirm that you want to remove this sample-participant mapping. Note that the corresponding project's table won't be deleted.?",
  delete_vocabulary_confirm: "Are you sure you want to delete vocabulary '{vocabulary}' from '{taxonomy}' taxonomy?",
  delete: 'Delete',
  density: 'Density',
  derivation_script: 'Derivation script',
  derived_variables_hint: 'The derived variable name and value type can be different from the one of original variable.',
  derived_variables: 'Derived variables',
  description: 'Description',
  description: 'Description',
  descriptive_statistics: 'Descriptive statistics',
  destination_folder: 'Destination folder',
  details: 'Details',
  dictionary: 'Dictionary',
  disable: 'Disable',
  discovery: 'Discovery',
  docs: 'Docs',
  documentation_cookbook: 'Documentation and cookbook',
  download_dictionaries: 'Download dictionaries',
  download_dictionary: 'Download dictionary',
  download_logs: 'Download logs',
  download_view: 'Download view',
  download_views_backup: 'Backup views',
  download: 'Download',
  duplicate: 'Duplicate',
  duration: 'Duration',
  edit_category: 'Edit category',
  edit_permission: 'Edit permission',
  edit_project: 'Edit project',
  edit_script: 'Edit script',
  edit_table: 'Edit table',
  edit_variable: 'Edit variable',
  edit_view: 'Edit view',
  edit: 'Edit',
  empty_cart: 'The cart is empty',
  enable: 'Enable',
  enabled: 'Enabled',
  encrypt_file_content: 'Encrypt file content',
  encrypt_password_hint: 'The password must have at least 8 characters.',
  encrypt_password: 'Password',
  end_time: 'End time',
  end: 'End',
  enforced_2fa: 'Enforced 2FA',
  entities: 'Entities',
  entity_filter: 'Entity filter',
  entity_search_caption: 'Search for entity by identifier.',
  entity_search_info: 'Search an entity by providing its type and its identifier. See [Search Entity documentation](http://opaldoc.obiba.org/en/latest/web-user-guide/search/entity.html) for more details.',
  entity_search: 'Entity search',
  entity_type: 'Entity Type',
  entity: 'Entity',
  example: 'Example: {text}',
  expires: 'Expires',
  export_data: 'Export data',
  export_database: 'Export to a database',
  export_file: 'Export to file',
  export_folder: 'Export Folder',
  export_tables_task_created: 'Export tables task created with identifier [ {id} ].',
  export_tables_text: 'No tables to be exported | One table will be exported | {count} tables will be exported.',
  export: 'Export',
  extract_archive_password_hint: "The password to extract the archive's content, if applicable.",
  extract: 'Extract',
  file_folder_search: 'Search files and folders',
  field_separator: 'Field separator',
  file_already_exists: 'File already exists',
  file_selection: 'File selection',
  file_system: 'System',
  files_caption: 'Manage files and folders, upload and download files',
  files: 'Files',
  filter: 'Filter',
  filters: 'Filters',
  folder: 'Folder',
  folder_file: 'Folder or file',
  format: 'Format',
  frequencies: 'Frequencies',
  frequency: 'Frequency',
  from_row: 'From row',
  from_tables_hint: 'The view refers to table(s) from which the entities and variables are extracted. When a table is flagged as being "inner", its entities will not contribute to the view\'s entities: this is equivalent to a SQL inner join.',
  from_tables_select_hint: 'Select the table(s) to be added to the view.',
  from_tables: 'From tables',
  from: 'From',
  full_name: 'Full name',
  full_summary: 'Full summary',
  function: 'Function',
  general_settings_caption: 'Manage general server configuration',
  general_settings: 'General Settings',
  generate: 'Generate',
  genotypes: 'Genotypes',
  gh_org_hint: 'Example: datashield',
  gh_org: 'Organization or user',
  gh_ref_hint: 'Branch, tag or commit, default is "master"',
  gh_ref: 'Reference',
  gh_repo_hint: 'Example: dsBase',
  gh_repo: 'Repository',
  group: 'Group',
  groups_hint: "Select a group or type a new name and press 'ENTER'.",
  groups_info: 'Groups can only be defined through users. Removing a group removes users from this group.',
  groups: 'Groups',
  help: 'Help',
  histogram: 'Histogram',
  history: 'History',
  home_folder: 'Home Folder',
  host: 'Host',
  hour: 'Hour',
  id_column_hint: 'Name of the column that identifies the entity. If not provided, the first column will be selected as the entity IDs provider.',
  id_column_name_hint: 'Name of the column that identifies the entity. If not provided, the default name applies.',
  id_column_name: 'ID column name',
  id_column: 'ID column',
  id: 'ID',
  identifiers: 'Identifiers',
  identity_provider_account_login: 'Account Login',
  identity_provider_add: 'Add Identity Provider',
  identity_provider_discovery_uri: 'Discovery URI',
  identity_provider_edit: 'Edit Identity Provider',
  identity_provider_url: "Provider's Login",
  identity_providers_caption: 'Manage the OpenID Connect providers',
  identity_providers_info: "Users from a declared {idProvider} can sign in the application using their credentials. Once they have signed in, the users are automatically associated to a group having the Identity Provider's name, so that permissions can be applied to all the users from the same source. Additional group associations can be applied too. Note that only Identity Providers of type {openId} are supported.",
  identity_providers: 'Identity Providers',
  import_data_task_created: 'Import data task created with identifier [ {id} ].',
  import_data: 'Import data',
  import_database: 'Import from database',
  import_file: 'Import from file',
  import_limit_hint: 'The maximum number of rows to import. If there is no limit or the limit is 0, all the records will be imported.',
  import_server: 'Import from server',
  import: 'Import',
  inactive: 'Inactive',
  incremental_import_hint: 'Import only new or updated data.',
  incremental_import: 'Incremental import',
  index_hint: 'Position or weight of the variable in the list of variables of the table, for ordering.',
  index: 'Index',
  initialize: 'Initialize',
  inner_join: 'Inner join',
  install_action: 'Install',
  install_r_package_task_created: 'Install R package task created with identifier [ {id} ].',
  install_r_package: 'Install R package',
  install: 'Install',
  intervals: 'Intervals',
  is_missing_hint: 'Indicates that an observational value is missing.',
  is_missing: 'Missing',
  jvm_caption: 'Monitor Java virtual machine',
  jvm: 'Java Virtual Machine',
  keywords: 'Keywords',
  kurtosis: 'Kurtosis',
  label_description: 'Label & description',
  label: 'Label',
  labels: 'Labels',
  laguages: 'Languages',
  last_access: 'Last access',
  last_update: 'Last update',
  latest: 'Latest',
  less: 'Less',
  libpath: 'Libpath',
  license: 'License',
  limit: 'Limit',
  logout_url: 'URL after logout',
  manager: 'Manager',
  mappings: 'Mappings',
  markdown_guide: 'Markdown guide',
  max: 'Maximum',
  mean: 'Mean',
  median: 'Median',
  merge_dictionaries_hint: 'When a table already exists, the variable characteristics (properties, categories, attributes) will be merged with the imported ones instead of being simply overridden. This allows to preserve the variable annotations on subsequent imports.',
  merge_dictionaries: 'Merge dictionaries',
  merge_variables_hint: 'If selected, variable with same name will be merged (properties, categories and attributes will be added or updated, no deletion). Else the provided variables will replace the existing ones.',
  merge_variables: 'Merge variables',
  message: 'Message',
  messages: 'Messages',
  mime_type_hint: 'The MIME type of the variable values.',
  mime_type: 'Mime type',
  min: 'Minimum',
  minutes: 'Minutes',
  missings: 'Missings',
  mongodb: 'MongoDB',
  more_results: 'More results',
  more: 'More',
  move_down: 'Move down',
  move_up: 'Move up',
  my_profile: 'My profile',
  name: 'Name',
  namespace: 'Namespace',
  nature: 'Nature',
  new_name: 'New name',
  no_bookmarks: 'No favorites',
  no_datasource_configuration: 'No datasource configuration',
  no_entity_filter: 'No script for filtering the entities of the view is defined.',
  no_options: 'No options',
  no_permissions: 'No permissions',
  no_r_activity: 'No R activity',
  no_results: 'No results',
  no_sql_history: 'No SQL history',
  no_table_values: 'No table values',
  no_taxonomies: 'No taxonomies',
  no: 'No',
  non_missings: 'Non missings',
  none_value: '(None)',
  none: 'None',
  normal_distribution: 'Normal distribution',
  normal: 'Normal',
  not_empty: 'Not empty',
  occurrence_group_hint: 'Group name of several repeatable variables.',
  occurrence_group: 'Occurrence group',
  on: 'On',
  opal_url: 'Opal URL',
  openid_connect: 'OpenID Connect',
  optional_storage_hint: 'Optional database used to store data.',
  optional: 'Optional',
  options: 'Options',
  other_links: 'Other links',
  other_variable_hint: 'Categorical, logical or numerical variable',
  other_variable: 'Other variable',
  other: 'Other',
  owner: 'Owner',
  package_manager: 'Package manager',
  package: 'Package',
  packages: 'Packages',
  parameters: 'Parameters',
  participant_id: 'Participant ID',
  participants: 'Participants',
  password_confirm: 'Confirm password',
  password_hint: "{'The password must be at least 8 characters long, including one digit, one uppercase letter, one lowercase letter, one special character (e.g., @#$%^&+=!), and no white space.'}",
  password: 'Password',
  percentage: 'Percentage',
  permission: 'Permission',
  permissions: 'Permissions',
  personal_access_token: 'Personal access token',
  plugins_caption: 'Manage system plugins',
  plugins_info: 'Plugins are extensions that provide additional features to the system. They can be installed, updated or removed.',
  plugins: 'Plugins',
  preview_import_source: 'Preview the data',
  preview: 'Preview',
  profile_groups_acls_info: 'List of the permissions inherited by the user from groups membership. Note that revoking a permission of a group will affect the permissions granted to of all the group\'s members.',
  profile_groups_acls: 'User\'s Groups Permissions',
  profile_otp_disable: "Disable Two-factor authentication for user '{user}'",
  profile_otp_disabled: "Two-factor authentication can be enabled by user '{user}'",
  profile_user_acls_info: 'List of the permissions directly applied to the user. Permissions that would be inherited from groups membership are not included.',
  profile_user_acls: 'User Permissions',
  profile: 'Profile',
  profiles_info: 'Each user who logged in has a profile. A realm is the user directory in which a user is defined. Logging in from different realm with the same user name is forbidden for security reasons. If removed, the user profile will be automatically recreated when the user logs in.',
  profiles: 'Profiles',
  progress: 'Progress',
  project_acls_empty: 'No granted permissions.',
  project_backup_success: 'Project backup task has been launched. You can follow its progress in the task list.',
  project_description_hint: 'Optional description of the project.',
  project_destination: 'Destination project',
  project_files_info: 'Each project has a folder. A user having read access to a project item can also see the content of its folder.',
  project_permissions_info: 'Permissions are granted to users or groups for an item in the project. They define what operations can be performed. The following tables list the permissions granted to a selected user or group in the context of the current project.',
  project_settings: 'Project Settings',
  project_tag_hint: "Type a new tag and press 'ENTER'.",
  project: 'Project',
  projects_caption: 'Browse tables and variables, create views, import/export data and dictionaries',
  projects_info: 'A project is a repository of data with dictionaries and of resource references. In a project, data can be imported, exported, analysed and transformed. Projects also offer access controls to the dictionaries, the summary statistics and the individual data.',
  projects: 'Projects',
  properties: 'Properties',
  public_url: 'Public URL',
  query: 'Query',
  quotation_mark: 'Quotation mark',
  r_activity_info: 'Effective time spent to execute R/DataSHIELD commands.',
  r_activity: 'R/DataSHIELD Activity',
  r_execution_time: 'R execution time',
  r_func: 'Function',
  r_packages_management_forbidden: 'R packages management (installation, update, removal) is not allowed: it is recommended to use validated Docker images of R servers, to ensure reproducibility of the R analysis environment. As a R package developer, you may modify the system settings to enable this feature.',
  r_script: 'Script',
  r_service: 'R service',
  r_sessions_activity: 'R sessions activity',
  r_sessions_count: 'R sessions count',
  range: 'Range',
  realm: 'Realm',
  reconnect_view: 'Reconnect view',
  records: 'Records',
  referenced_entity_type_hint: 'When the value is an identifier, its entity type can be specified.',
  referenced_entity_type: 'Referenced entity type',
  references: 'References',
  refresh: 'Refresh',
  register: 'Register',
  reload: 'Reload',
  remove_from_cart: 'Remove from cart',
  remove: 'Remove',
  renew: 'Renew',
  repeatable_hint: 'When an entity can have multiple values for this variable.',
  repeatable: 'Repeatable',
  report: 'Report',
  reset: 'Reset',
  resource: 'Resource',
  resources_info: 'Resources are datasets or computation units which location is described by a URL and access is protected by credentials. When assigned to a R/DataSHIELD server session, remote big/complex datasets or high performance computers are made accessible to data analysts.',
  resources: 'Resources',
  restore_views_files_hint: 'Select one or more previously backed up views in JSON format (extracted from the backup zip archive).',
  restore_views_files: 'View files',
  restore_views_override_error: "View '{name}' already exists.",
  restore_views_override: 'Override existing views',
  restore_views: 'Restore views',
  restore: 'Restore',
  results: 'Results',
  role: 'Role',
  rservers_caption: 'Configure R server, grant access to R service',
  rservers: 'R',
  run: 'Run',
  sample_quantiles: 'Sample quantiles',
  sample: 'Sample',
  samples: 'Samples',
  save: 'Save',
  schedule: 'Schedule',
  script: 'Script',
  search_caption: 'Manage search indexes',
  search: 'Search',
  select_columns: 'Select columns',
  select_dictionary_file_template: 'Use the following Excel template to add new variables or update existing ones:',
  select_dictionary_file: 'Select a dictionary of variables in Excel file format or a View XML file for batch edition of tables and variables.',
  select_files_overwrite: 'Overwrite existing files',
  select_files_to_upload: 'Select files to upload',
  select_import_options: 'Select import options',
  select_import_source: 'Select the source of data',
  select: 'Select',
  server: 'Server',
  servers: 'Servers',
  services: 'Services',
  settings: 'Settings',
  signin_with: 'Sign in with {provider}',
  size: 'Size',
  skewness: 'Skewness',
  source_code: 'Source code',
  sql_history_hint: 'Double click on a query to load it in the SQL editor.',
  sql_info: 'SQL queries can be executed on one or more tables of the project. Permission to access the values of the considered tables is required. See [SQL API documentation](https://opaldoc.obiba.org/en/latest/web-user-guide/projects/tables.html#sql) for a description of the SQL syntax and functions.',
  sql_query_hint: 'Type a SQL query and press Ctrl-ENTER to execute.',
  sql: 'SQL',
  start_time: 'Start time',
  start: 'Start',
  started: 'Started',
  state: 'State',
  statistics: 'Statistics',
  status: 'Status',
  std_dev: 'Standard deviation',
  stop: 'Stop',
  storage: 'Storage',
  sub_total: 'Sub total',
  submit: 'Submit',
  sum: 'Sum',
  summary: 'Summary',
  sumsq: 'Sum of squares',
  system_settings: 'System Settings',
  system: 'System',
  table_identifiers_import_hint: 'The table which identifiers will be imported as system identifiers to be mapped.',
  table_name: 'Table name',
  table_references: 'Table references',
  table: 'Table',
  tables_views: 'Tables (views)',
  tables: 'Tables',
  tags: 'Tags',
  tasks_caption: 'Monitor tasks progress',
  tasks: 'Tasks',
  taxonomies_caption: 'Manage taxonomies for variable classification with controlled vocabularies',
  taxonomies_info: 'Taxonomies are used to classify variables with controlled vocabularies.',
  taxonomies: 'Taxonomies',
  term: 'Term',
  terminate_r_sessions_confirm: '- | Are you sure you want to terminate this R session? | Are you sure you want to terminate these {count} R sessions?',
  terminate: 'Terminate',
  terms: 'Terms',
  test: 'Test',
  theoretical_quantiles: 'Theoretical quantiles',
  title_hint: 'A title for the human beings.',
  title: 'Title',
  to: 'To',
  token: 'Token',
  total_duration: 'Total duration',
  total_execution_time: 'Total execution time',
  total: 'Total',
  type: 'Type',
  unique_name_hint: 'The name must be unique.',
  unit_hint: 'The unit of the variable values.',
  unit: 'Unit',
  unknown_error: 'An unknown error occurred',
  unrecognized: 'Unrecognized',
  unregister: 'Unregister',
  update_action: 'Update',
  update_all_r_packages_note: 'This operation will update all R packages to the latest version available on CRAN. This is a long time running task. If any error happens, look for possible reasons (system dependency missing, network connection failure etc.) by downloading the R server log.',
  update_all_r_packages_task_created: 'Update all R packages task created with identifier [ {id} ].',
  update_all_r_packages: 'Update all R packages',
  update_method: 'Update method',
  update_option: 'Update option',
  update: 'Update',
  upload: 'Upload',
  usage: 'Usage',
  user_add_with_crt: 'Add user with certificate',
  user_add_with_pwd: 'Add user with password',
  user_add: 'Add user',
  user_delete: 'Delete user',
  user_disable: 'Disable user',
  user_edit: 'Edit user',
  user_enable: 'Enable user',
  user_profiles_caption: 'Manage user and application profiles',
  user_profiles: 'User Profiles',
  user: 'User',
  username: 'User name',
  users_and_groups_caption: 'Add, update, remove users and groups',
  users_and_groups: 'Users and groups',
  users_filter_placeholder: 'Filter users by name, group or authentication type...',
  users_info: 'Users can login using a password or programmatically by providing a certificate in a secured connection (HTTPS).',
  users: 'Users',
  value_type_hint: 'The type of the variable values.',
  value_type: 'Value type',
  value: 'Value',
  values_index_clear_error: 'Values index clear error.',
  values_index_cleared: 'Values index cleared.',
  values_index_info: 'Table values are to be indexed manually (default), or automatically by defining a schedule.',
  values_index: 'Values index',
  values: 'Values',
  variable_name_hint: 'The name of the variable must be unique in its table.',
  variable: 'Variable',
  variables_hint: 'Select some variables to see more actions.',
  variables_index_clear_error: 'Variables index clear error.',
  variables_index_cleared: 'Variables index cleared.',
  variables_index_info: 'Table dictionaries are automatically indexed. Remove the index if you want to re-index all the variables.',
  variables_index: 'Variables index',
  variables_search_caption: 'Search for variables by name, label, description, category, attribute or vocabulary term.',
  variables_search_info: 'Search variables using controlled vocabularies and full-text search. The controlled vocabularies are defined by the taxonomies. The full-text search applies to the variable name and labels. See [Search Variables documentation](http://opaldoc.obiba.org/en/latest/web-user-guide/search/variables.html) for more details.',
  variables_search: 'Variables search',
  variables: 'Variables',
  variance: 'Variance',
  vcf: 'VCF',
  version: 'Version',
  view_destination_hint: 'The destination view will be created if it does not exist, otherwise it will be updated by merging derived variables with the existing ones.',
  view_name: 'View name',
  view: 'View',
  vocabularies: 'Vocabularies',
  vocabulary: 'Vocabulary',
  waiting: 'Waiting',
  yes: 'Yes',
};
