<?php

/**
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; under version 2
 * of the License (non-upgradable).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Copyright (c) 2021 (original work) Open Assessment Technologies SA;
 */

declare(strict_types=1);

namespace OAT\Library\Lti1p3Core\Message\Payload\Extractor;

use OAT\Library\Lti1p3Core\Message\Payload\MessagePayloadInterface;

class MessagePayloadClaimsExtractor
{
    public const DEFAULT_EXCLUDED_CLAIMS = [
        MessagePayloadInterface::CLAIM_JTI,
        MessagePayloadInterface::CLAIM_EXP,
        MessagePayloadInterface::CLAIM_IAT,
        MessagePayloadInterface::CLAIM_NBF,
        MessagePayloadInterface::CLAIM_NONCE,
    ];

    public static function extract(MessagePayloadInterface $messagePayload, array $excludedClaims = []): array
    {
        $excludedClaims = array_merge($excludedClaims, self::DEFAULT_EXCLUDED_CLAIMS);

        return array_diff_key(
            $messagePayload->getToken()->getClaims()->all(),
            array_flip($excludedClaims)
        );
    }
}
