﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class rptList_rpt_Balance :PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindAccountBalanceCount();
            BindRptAccountBalanceCount();
        }
    }
    #region 功能列表
    protected void btnRptExpenditureType_Click(object sender, EventArgs e)//类别支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureType.aspx");
    }
    protected void btnRptExpenditureAccount_Click(object sender, EventArgs e)//账户支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureAccount.aspx");
    }
    protected void btnRptExpenditureSeller_Click(object sender, EventArgs e)//商家支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureSeller.aspx");
    }
    protected void btnRptExpenditureProject_Click(object sender, EventArgs e)//项目支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureProject.aspx");
    }
    protected void btnRptIncomeType_Click(object sender, EventArgs e)//类别收入
    {
        Response.Redirect("../rptList/rpt_IncomeType.aspx");
    }
    protected void btnRptIncomeAccount_Click(object sender, EventArgs e)//账户收入
    {
        Response.Redirect("../rptList/rpt_IncomeAccount.aspx");
    }
    protected void btnRptIncomeSeller_Click(object sender, EventArgs e)//付款方收入
    {
        Response.Redirect("../rptList/rpt_IncomeSeller.aspx");
    }
    protected void btnRptIncomeProject_Click(object sender, EventArgs e)//项目收入
    {
        Response.Redirect("../rptList/rpt_IncomeProject.aspx");
    }
    protected void btnRptBalance_Click(object sender, EventArgs e)//余额状况
    {
        Response.Redirect("../rptList/rpt_Balance.aspx");
    }
    #endregion
    /// <summary>
    ///绑定账户余额汇总
    /// </summary>
    public void BindAccountBalanceCount()
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT SUM(AccountRemainder) as AccountRemainderSum FROM dbo.V_List_AccountBalance", "constring");
        if(ds.Tables[0].Rows.Count>0)
        {
            spanAccountMoney.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["AccountRemainderSum"]);//账户金额汇总
        }
    }
    /// <summary>
    /// 绑定账户余额报表
    /// </summary>
    public void BindRptAccountBalanceCount()
    {
        ControlHelper.BindRepeater(this.rptAccountBalanceCount, "constring", "SELECT AccountName,AccountTypeName,AccountRemainder FROM dbo.V_List_AccountBalance");
    }
}