﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text;

public partial class AccountType_ProjectType : PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            pageCount = GetPageCount();//总页数
            spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
            BindRptProjectType();
        }
    }
    #region 功能列表
    protected void btnExpenditureType_Click(object sender, EventArgs e)//支出类型
    {
        Response.Redirect("ExpenditureType.aspx");
    }
    protected void btnIncomeType_Click(object sender, EventArgs e)//收入类型
    {
        Response.Redirect("IncomeType.aspx");
    }
    protected void btnProjectType_Click(object sender, EventArgs e)//项目
    {
        Response.Redirect("ProjectType.aspx");
    }
    protected void btnSeller_Click(object sender, EventArgs e)//商家/付款方
    {
        Response.Redirect("Seller.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定项目rptProject
    /// </summary>
    public void BindRptProjectType()
    {
        SetStrWhere();
        ControlHelper.BindRepeater(this.rptProjectType, "constring", StrWhere + "AND Row BETWEEN (" + currentPageNum + "-1)*15+1 AND " + currentPageNum + "*15 ");
    }
    protected void rptProjectType_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int projectTypeId=ConvertHelper.GetInteger((e.Item.FindControl("hdProjectTypeId") as HiddenField).Value); 
        if(e.CommandName=="delete")//删除
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Type_Project SET State=0 WHERE ProjectTypeId="+projectTypeId+"", "constring");
            if (flag > 0)
            {
                BindRptProjectType();
            }
            else
            {
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(),"","<script language='javascript' defer>alert('删除失败，请联系管理员！')</script>");
            }
        }
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 15 == 0)
            {
                pagecount = loanAccountCount / 15;
            }
            else
            {
                pagecount = loanAccountCount / 15 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindRptProjectType();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindRptProjectType();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindRptProjectType();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindRptProjectType();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY CreateTime) AS Row,ProjectTypeId,ProjectTypeName FROM dbo.tabA_Type_Project WHERE State=1) AS temptable  WHERE 1=1 ");
        //if (uclBankCard.BankCardID != 0)//查询事件中的银行卡
        //{
        //    strb.Append("AND BankCardID=" + uclBankCard.BankCardID + " ");//银行卡id
        //}
        //else if (!string.IsNullOrEmpty(Request["BankId"]))//从银行卡列表页点击查看明细跳转到明细页面（即本页面）
        //{
        //    strb.Append("AND BankCardID=" + Request["BankId"] + " ");//银行卡id
        //}
        //if (!string.IsNullOrEmpty(txtCardNumber.Text.Trim()))
        //{
        //    strb.Append("AND BankCardNumber like '%" + txtCardNumber.Text.Trim() + "%' ");//银行卡号（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtHeader.Text.Trim()))
        //{
        //    strb.Append("AND Header like '%" + txtHeader.Text.Trim() + "%' ");//户主名（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtOther.Text.Trim()))
        //{
        //    strb.Append("AND OtherName like '%" + txtOther.Text.Trim() + "%'");//交易对方（模糊查询）
        //}
        //strb.Append(string.Format(timewhere.WhereString, " a.CreateTime"));
        StrWhere = strb.ToString();
    }
    #endregion
    protected void btnAddProjectType_Click(object sender, EventArgs e)//新增项目事件
    {
        Response.Redirect("ProjectTypeInfo.aspx");
    }
}
