﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Account_SavingsCardInfo : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindDdlBank();
            BindPage();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定储蓄卡页面数据
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["scid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT SCIssueBankId,SavingsCardName,SavingsCardNumber,SavingsCardRemainder,SavingsCardRemarks FROM dbo.tabA_Account_SavingsCard WHERE State=1 AND SavingsCardId=" + ConvertHelper.GetInteger(Request["scid"]) + "", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                ddlBank.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SCIssueBankId"]);//发卡行id
                txtSavingsCardName.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SavingsCardName"]);//名称
                txtSavingsCardNumber.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SavingsCardNumber"]);//卡号
                txtSavingsCardRemainder.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SavingsCardRemainder"]);//余额
                txtRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["SavingsCardRemarks"]);//备注
            }
        }
    }
    /// <summary>
    /// 绑定银行
    /// </summary>
    public void BindDdlBank()
    {
        ControlHelper.BindDropDownList(this.ddlBank, "constring", "SELECT BankID,BankName FROM tabA_Account_Bank WHERE State=1", "BankID", "BankName");
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if(!string.IsNullOrEmpty(Request["scid"]))//修改储蓄卡
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SCIssueBankId=" + ddlBank.SelectedValue + ",SavingsCardName='" + txtSavingsCardName.Text.Trim() + "',SavingsCardNumber='" + txtSavingsCardNumber.Text.Trim() + "',SavingsCardRemainder=" + ConvertHelper.GetDecimal(txtSavingsCardRemainder.Text.Trim()) + ",SavingsCardRemarks='" + txtRemarks.Text.Trim() + "',UpdateTime='" + System.DateTime.Now + "' WHERE SavingsCardId=" + ConvertHelper.GetInteger(Request["scid"]) + "", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_SavingsCard.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
            }
        }
        else//添加储蓄卡
        {
            int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Account_SavingsCard (SCIssueBankId,SavingsCardName,SavingsCardNumber,SavingsCardRemainder,SavingsCardRemarks,CreateTime)VALUES(" + ddlBank.SelectedValue + ",'" + txtSavingsCardName.Text.Trim() + "','" + txtSavingsCardNumber.Text.Trim() + "'," + ConvertHelper.GetDecimal(txtSavingsCardRemainder.Text.Trim()) + ",'" + txtRemarks.Text.Trim() + "','"+System.DateTime.Now+"')", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_SavingsCard.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
}