﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Account_OnlinePayInfo : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindPage();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定网上支付页面信息
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["opid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT OnlinePayType,OnlinePayName,OnlinePayRemainder,OnlinePayRemarks FROM dbo.tabA_Account_OnlinePay WHERE State=1 AND OnlinePayId=" + ConvertHelper.GetInteger(Request["opid"]) + "", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                DdlOnlineType.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["OnlinePayType"]);//网上支付类型
                txtOnlineName.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["OnlinePayName"]);//网上支付名称
                txtOnlineRemainder.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["OnlinePayRemainder"]);//网上支付余额
                txtRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["OnlinePayRemarks"]);//网上支付备注
            }
        }
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request["opid"]))//修改网上支付
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayType=" + ConvertHelper.GetInteger(DdlOnlineType.SelectedValue) + ",OnlinePayName='" + txtOnlineName.Text.Trim() + "',OnlinePayRemainder=" + ConvertHelper.GetDecimal(txtOnlineRemainder.Text.Trim()) + ",OnlinePayRemarks='" + txtRemarks.Text.Trim() + "',UpdateTime='"+System.DateTime.Now+"' WHERE OnlinePayId=" + ConvertHelper.GetInteger(Request["opid"]) + "", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_OnlinePay.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
            }
        }
        else//添加网上支付
        {
            int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Account_OnlinePay(OnlinePayType,OnlinePayName,OnlinePayRemainder,OnlinePayRemarks,CreateTime) VALUES("+ConvertHelper.GetInteger(DdlOnlineType.SelectedValue)+",'"+txtOnlineName.Text.Trim()+"',"+ConvertHelper.GetDecimal(txtOnlineRemainder.Text.Trim())+",'"+txtRemarks.Text.Trim()+"','"+System.DateTime.Now+"')", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_OnlinePay.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
}