﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Account_CreditCardInfo : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindDdlBank();
            BindPage();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定信用卡页面信息
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["ccid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT CCIssueBankId,CreditCardName,CreditCardNumber,CardArrears,CardLimit,BillDay,RepaymentDay,InfoType,CreditCardRemarks FROM dbo.tabA_Account_CreditCard WHERE State=1 AND CreditCardId=" + ConvertHelper.GetInteger(Request["ccid"]) + "", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                ddlBank.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CCIssueBankId"]);//银行id
                txtCreditCardName.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CreditCardName"]);//信用卡名称
                txtCreditCardNumber.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CreditCardNumber"]);//信用卡号
                txtCreditCardArrears.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CardArrears"]);//信用卡欠款
                txtLimit.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CardLimit"]);//信用卡额度
                ddlBillDay.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["BillDay"]);//账单日
                ddlReplaymentDay.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RepaymentDay"]);//还款日
                ddlReplaymentInfoWay.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["InfoType"]);//还款提醒方式（1-无需提醒，2-当天提醒，3-提前三天提醒）
                txtRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["CreditCardRemarks"]);//备注
            }
        }
    }
    /// <summary>
    /// 绑定银行
    /// </summary>
    public void BindDdlBank()
    {
        ControlHelper.BindDropDownList(this.ddlBank, "constring", "SELECT BankID,BankName FROM tabA_Account_Bank WHERE State=1", "BankID", "BankName");
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request["ccid"]))//编辑信用卡
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CCIssueBankId=" + ddlBank.SelectedValue + ",CreditCardName='" + txtCreditCardName.Text.Trim() + "',CreditCardNumber='" + txtCreditCardNumber.Text.Trim() + "',CardArrears=" + ConvertHelper.GetDecimal(txtCreditCardArrears.Text.Trim()) + ",CardLimit=" + ConvertHelper.GetDecimal(txtLimit.Text.Trim()) + ",BillDay=" + ddlBillDay.SelectedValue + ",RepaymentDay=" + ddlReplaymentDay.SelectedValue + ",InfoType="+ddlReplaymentInfoWay.SelectedValue+",CreditCardRemarks='" + txtRemarks.Text.Trim() + "',UpdateTime='" + System.DateTime.Now + "' WHERE State=1 AND CreditCardId=" + ConvertHelper.GetInteger(Request["ccid"]) + "", "constring");
            if (flag > 0)
            {
                Response.Redirect("Account_CreditCard.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
            }
        }
        else//添加信用卡
        {
            int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Account_CreditCard(CCIssueBankId,CreditCardName,CreditCardNumber,CardArrears,CardLimit,BillDay,RepaymentDay,InfoType,CreditCardRemarks,CreateTime) VALUES(" + ddlBank.SelectedValue + ",'" + txtCreditCardName.Text.Trim() + "','" + txtCreditCardNumber.Text.Trim() + "'," + ConvertHelper.GetDecimal(txtCreditCardArrears.Text.Trim()) + "," + ConvertHelper.GetDecimal(txtLimit.Text.Trim()) + "," + ddlBillDay.SelectedValue + "," + ddlReplaymentDay.SelectedValue + ","+ddlReplaymentInfoWay.SelectedValue+",'" + txtRemarks.Text.Trim() + "','" + System.DateTime.Now + "')", "constring");
            if (flag > 0)//添加信用卡成功
            {
                //int flagInfo = SqlHelper.Operation("INSERT INTO dbo.tabA_Info(InfoTypeId,InfoObjectId,InfoTime,CreateTime) VALUES(1,"+flag+",'"+System.DateTime.Now+"','"+System.DateTime.Now+"')", "constring");
                //if(flagInfo>0)
                //{
                //}
                Response.Redirect("Account_CreditCard.aspx");
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
}