﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class A_Detail_LoanInfo : PageBase
{
    private static int accountTypeIdBefore = 0;//修改前账户类型id
    private static int accountIdBefore = 0;//修改前账户id
    private static int loanAccountIdBefore = 0;//修改前借贷账户id
    private static double loanMonyBefore = 0.00;//修改前借贷金额
    private static double loanInterestBefore = 0.00;//修改前的利息（收款、还款时才有）；
    private static int accountTypeId = 0;//修改后账户类型id
    private static int accountId = 0;//修改后账户id
    private static int loanAccountId = 0;//修改后借贷账户id
    private static int loanTypeId = 0;//借贷类型
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            OfficeManage.BindLoanAccount(ddlLoanAccount);//绑定债务人/债权人（借贷账户）
            BindPage();
            LoanShow();
        }
    }
    #region 功能栏事件（全部、支出、收入、转账、借贷按钮）
    protected void btnAllDetail_Click(object sender, EventArgs e)//全部明细
    {
        Response.Redirect("Detail.aspx");
    }
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出明细
    {
        Response.Redirect("Detail_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入明细
    {
        Response.Redirect("Detail_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账明细
    {
        Response.Redirect("Detail_Transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷明细
    {
        Response.Redirect("Detail_Loan.aspx");
    }
    #endregion
    #region 绑定借贷页面数据
    /// <summary>
    /// 绑定借贷页面数据
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["liid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT RecordLoanMoney,RecordLoanTypeId,RLOutsideAccountId,LoanAccountName,LoanAccountState,RLInsideAccountTypeId,RLInsideAccountId,RLoanDateTime,RLoanInterest,RLRepaymentDateTime,RecordLoanRemarks,HandlerId FROM V_Detail_Loan WHERE RecordLoanId=" + ConvertHelper.GetInteger(Request["liid"]) + " AND State=1", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                #region 修改前账户类型id，账户id，债务人/债权人id,借贷金额，利息
                accountTypeIdBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountTypeId"]);//修改前账户类型id
                accountIdBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//修改前账户id
                loanAccountIdBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLOutsideAccountId"]);//修改前借贷账户id（债务人/债权人）
                loanMonyBefore = ConvertHelper.GetDouble(ds.Tables[0].Rows[0]["RecordLoanMoney"]);//修改前借贷金额
                loanInterestBefore = ConvertHelper.GetDouble(ds.Tables[0].Rows[0]["RLoanInterest"]);//修改前利息
                #endregion
                #region 借贷类型，赋值后不能修改
                loanTypeId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RecordLoanTypeId"]);//借贷类型Id
                int loanType=ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RecordLoanTypeId"]);//借贷类型
                ddlLoanType.SelectedValue =ConvertHelper.GetString(loanType);//借贷类型
                ddlLoanType.Enabled = false;//借贷类型不可用：借贷类型只能看不能修改
                #endregion
                txtLoanMoney.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RecordLoanMoney"]);//借贷金额
                #region 借贷账户
                if (ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["LoanAccountState"]) == 0)//借贷账户（债务人/债权人）已删除
                {
                    spanLoanAccountName.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["LoanAccountName"]);//已删除的借贷账户（债务人/债权人）
                    loanAccountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLOutsideAccountId"]);//修改后的借贷账户id
                }
                else//借贷账户（债务人/债权人）未删除
                {
                    ddlLoanAccount.SelectedValue = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RLOutsideAccountId"]);//借贷账户（债务人/债权人）
                }
                #endregion
                #region 账户
                uclAccount.AccountTypeID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountTypeId"]);//账户类型
                accountTypeId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountTypeId"]);//账户类型id
                if(uclAccount.AccountTypeID==1)//现金账户
                {
                    #region 现金账户
                     DataSet dsCashAccount = SqlHelper.GetDataSet("SELECT CashAccountName,State FROM dbo.tabA_Account_Cash WHERE CashAccountId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]) + "", "constring");
                     if (dsCashAccount.Tables[0].Rows.Count > 0)
                     {
                         if (ConvertHelper.GetInteger(dsCashAccount.Tables[0].Rows[0]["State"]) == 0)//现金账户已删除（0-已删除，1-未删除）
                         {
                             spanAccountName.InnerHtml = "现账户：" + ConvertHelper.GetString(dsCashAccount.Tables[0].Rows[0]["CashAccountName"]);//已删除的现金账户
                             accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//账户id
                         }
                         else//现金账户未删除
                         {
                             uclAccount.CashAccountID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//现金账户
                         }
                     }
                    #endregion
                }
                else if (uclAccount.AccountTypeID == 2)//信用卡
                {
                    #region 信用卡
                    DataSet dsCreditCard = SqlHelper.GetDataSet("SELECT CreditCardName,State FROM dbo.tabA_Account_CreditCard WHERE CreditCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]) + "", "constring");
                     if (dsCreditCard.Tables[0].Rows.Count > 0)
                     {
                         if (ConvertHelper.GetInteger(dsCreditCard.Tables[0].Rows[0]["State"]) == 0)//信用卡已删除（0-已删除，1-未删除）
                         {
                             spanAccountName.InnerHtml = "现账户：" + ConvertHelper.GetString(dsCreditCard.Tables[0].Rows[0]["CreditCardName"]);//已删除的信用卡
                             accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//账户id
                         }
                         else//信用卡未删除
                         {
                             uclAccount.CreditCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//信用卡
                         }
                     }
                    #endregion
                }
                else if (uclAccount.AccountTypeID == 3)//储蓄卡
                {
                    #region 储蓄卡
                    DataSet dsSavingsCard = SqlHelper.GetDataSet("SELECT SavingsCardName,State FROM dbo.tabA_Account_SavingsCard WHERE SavingsCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]) + "", "constring");
                    if (dsSavingsCard.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsSavingsCard.Tables[0].Rows[0]["State"]) == 0)//储蓄卡已删除（0-已删除，1-未删除）
                        {
                            spanAccountName.InnerHtml = "现账户：" + ConvertHelper.GetString(dsSavingsCard.Tables[0].Rows[0]["SavingsCardName"]);//已删除储蓄卡名
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//账户id
                        }
                        else//储蓄卡未删除
                        {
                            uclAccount.SavingsCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//储蓄卡
                        }
                    }
                    #endregion
                }
                else if(uclAccount.AccountTypeID==4)//网上支付
                {
                    #region 网上支付
                    DataSet dsOnlinePay = SqlHelper.GetDataSet("SELECT OnlinePayName,State FROM dbo.tabA_Account_OnlinePay WHERE OnlinePayId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]) + "", "constring");
                    if (dsOnlinePay.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsOnlinePay.Tables[0].Rows[0]["State"]) == 0)//网上支付已删除（0-已删除，1-未删除）
                        {
                            spanAccountName.InnerHtml = "现账户：" + ConvertHelper.GetString(dsOnlinePay.Tables[0].Rows[0]["OnlinePayName"]);//已删除网上支付名
                            accountId = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//账户id
                        }
                        else//网上支付未删除
                        {
                            uclAccount.OnlinePayID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RLInsideAccountId"]);//网上支付
                        }
                    }
                    #endregion
                }
                #endregion
                txtLoanDateTime.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RLoanDateTime"]);//借贷时间
                #region 还款日，利息
                if (loanType == 1 || loanType == 2)//loanType:借贷类型（1-借入，2-借出）(借入或借出时才有)
                {
                    txtRepaymentDateTime.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RLRepaymentDateTime"]);//还款日期
                }
                else if(loanType==3||loanType==4)//loanType:借贷类型（3-收款，4-还款）（收款或还款时才有）
                {
                    txtInterest.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RLoanInterest"]);//利息
                }
                #endregion
                txtLoanRemarks.Text = ConvertHelper.GetString(txtLoanRemarks.Text.Trim());//借贷备注
            }
        }
    }
    #endregion 
    #region 借贷页面显示
    /// <summary>
    /// 借贷页面显示
    /// </summary>
    public void LoanShow()
    {
        int loanTypeId = ConvertHelper.GetInteger(ddlLoanType.SelectedValue);//借贷类型id
        trRepaymentDateTime.Visible = false;//还款日行隐藏
        trInterst.Visible = false;//利息行隐藏
        trReplaymentInfo.Visible = false;//还款提醒行隐藏
        if (loanTypeId == 1)//借入
        {
            trRepaymentDateTime.Visible = true;//还款日行显示
            spanSellerTdName.InnerHtml = "债权人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "借入账户：";//账户td显示
            trReplaymentInfo.Visible = true;//还款提醒行显示
        }
        else if (loanTypeId == 2)//借出
        {
            trRepaymentDateTime.Visible = true;//还款日行显示
            spanSellerTdName.InnerHtml = "债务人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "借出账户：";//账户td显示
            trReplaymentInfo.Visible = true;//还款提醒行显示
        }
        else if (loanTypeId == 3)//收款
        {
            trInterst.Visible = true;//利息行显示
            spanSellerTdName.InnerHtml = "债务人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "收款账户：";//账户td显示
        }
        else if (loanTypeId == 4)//还款
        {
            trInterst.Visible = true;//利息行显示
            spanSellerTdName.InnerHtml = "债权人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "还款户：";//账户td显示
        }
    }
    #endregion
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if(!string.IsNullOrEmpty(Request["liid"]))
        {
            #region 修改后的债务人/债权人id（借贷账户）
            if (spanLoanAccountName.InnerHtml == "")//债务人/债权人未删除
            {
                loanAccountId = ConvertHelper.GetInteger(ddlLoanAccount.SelectedValue);//债务人/债权人
            }
            else//债务人/债权人已删除
            {
                if(ddlLoanAccount.SelectedValue!="0")
                {
                    loanAccountId = ConvertHelper.GetInteger(ddlLoanAccount.SelectedValue);//债务人/债权人
                }
            }
            #endregion
            #region 账户类型id及账户id
            if (spanAccountName.InnerHtml=="")//账户未删除
            {
                #region 现账户未删除的情况下修改后的账户类型id及账户id
                accountTypeId = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//账户类型id
                if (accountTypeId == 1)//现金账户
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.CashAccountID);
                }
                else if (accountTypeId == 2)//信用卡
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.CreditCardID);
                }
                else if (accountTypeId == 3)//储蓄卡
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.SavingsCardID);
                }
                else if (accountTypeId == 4)//网上支付
                {
                    accountId = ConvertHelper.GetInteger(uclAccount.OnlinePayID);
                }
                #endregion
            }
            else//账户已删除
            {
                #region 现账户已删除的情况下修改后的账户类型id及账户id
                if (!(uclAccount.CashAccountID==0&&uclAccount.CreditCardID==0&&uclAccount.SavingsCardID==0&&uclAccount.OnlinePayID==0))
                {
                    accountTypeId = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//账户类型id
                    if (accountTypeId == 1)//现金账户
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.CashAccountID);
                    }
                    else if (accountTypeId == 2)//信用卡
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.CreditCardID);
                    }
                    else if (accountTypeId == 3)//储蓄卡
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.SavingsCardID);
                    }
                    else if (accountTypeId == 4)//网上支付
                    {
                        accountId = ConvertHelper.GetInteger(uclAccount.OnlinePayID);
                    }
                }
                #endregion
            }
            #endregion
            int flag =0;//修改借贷记录是否成功的标志
            if (loanTypeId == 1 || loanTypeId == 2)//loanType:借贷类型（1-借入，2-借出）
            {
                flag = SqlHelper.Operation("UPDATE dbo.tabA_Record_Loan SET RecordLoanMoney=" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + ",RLOutsideAccountId=" + loanAccountId + ",RLInsideAccountTypeId=" + accountTypeId + ",RLInsideAccountId=" + accountId + ",RLoanDateTime='" + ConvertHelper.GetDateTime(txtLoanDateTime.Text.Trim()) + "',RLRepaymentDateTime='" + ConvertHelper.GetDateTime(txtRepaymentDateTime.Text.Trim()) + "',RLoanInfoWay="+ddlReplaymentInfoWay.SelectedValue+",RecordLoanRemarks='" + txtLoanRemarks.Text.Trim() + "',UpdateTime='" + System.DateTime.Now + "' WHERE RecordLoanId=" + ConvertHelper.GetInteger(Request["liid"]) + "", "constring");
            }
            else if(loanTypeId==3||loanTypeId==4)//loanType:借贷类型（3-收款，4-还款）
            {
                flag = SqlHelper.Operation("UPDATE dbo.tabA_Record_Loan SET RecordLoanMoney=" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + ",RLOutsideAccountId=" + loanAccountId + ",RLInsideAccountTypeId=" + accountTypeId + ",RLInsideAccountId=" + accountId + ",RLoanDateTime='" + ConvertHelper.GetDateTime(txtLoanDateTime.Text.Trim()) + "',RLoanInterest=" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + ",RLoanInfoWay=" + ddlReplaymentInfoWay.SelectedValue + ",RecordLoanRemarks='" + txtLoanRemarks.Text.Trim() + "',UpdateTime='" + System.DateTime.Now + "' WHERE RecordLoanId=" + ConvertHelper.GetInteger(Request["liid"]) + "", "constring");
            }
            if (flag > 0)//修改借贷记录成功
            {
                #region 修改的步骤注释
                /*修改的步骤：1-修改前的账户余额还原，成功则执行下一步，否则提示修改失败
                 *2-修改前的借贷账户（债务人/债权人）余额还原，成功则执行下一步，否则提示修改失败
                 *3-修改后的账户余额修改，成功则执行下一步，否则提示修改失败
                 *4-修改后的借贷账户（债务人/债权人）余额修改，成功则跳转到借贷明细页，否则提示修改失败
                 */
                #endregion

                if (loanTypeId==1)//借入
                {
                    #region 借入
                    #region 修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    if (accountTypeId==accountTypeIdBefore&&accountId==accountIdBefore&&ConvertHelper.GetDecimal(loanMonyBefore)==ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim())&&loanAccountId==loanAccountIdBefore)
                    {
                        Response.Redirect("Detail_Loan.aspx");//如果修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    }
                    #endregion 
                    int flagAccountBefore = 0;//修改前账户余额还原是否成功的标志
                    #region 修改前的账户余额还原
                    if (accountTypeIdBefore == 1)//现金账户
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + loanMonyBefore + " WHERE CashAccountId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore==2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + loanMonyBefore + " WHERE CreditCardId="+accountIdBefore+"","constring");
                    }
                    else if(accountTypeIdBefore==3)//储蓄卡
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + loanMonyBefore + " WHERE SavingsCardId="+accountIdBefore+"","constring");
                    }
                    else if(accountTypeIdBefore==4)//网上支付
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + loanMonyBefore + " WHERE OnlinePayId="+accountIdBefore+"", "constring");
                    }
                    #endregion
                    if (flagAccountBefore>0)//修改前的账户余额还原成功
                    {
                        int flagLoanAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder+" + ConvertHelper.GetDecimal(loanMonyBefore) + " WHERE LoanAccountId=" + loanAccountIdBefore + "", "constring");
                        if (flagLoanAccountBefore > 0)//修改前的借贷账户（债务人/债权人）余额还原成功
                        {
                            int flagAccountAfter = 0;//修改后账户余额修改是否成功的标志
                            #region 修改后账户余额修改
                            if (accountTypeId == 1)//现金账户
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CashAccountId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CreditCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 3)//储蓄卡
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 4)//网上支付
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                            }
                            #endregion
                            if (flagAccountAfter > 0)//修改后的账户余额修改成功
                            {
                                int flagLoanAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE LoanAccountId=" + loanAccountId + "", "constring");
                                if (flagLoanAccountAfter > 0)//修改后的借贷账户（债务人/债权人）余额修改成功
                                {
                                    Response.Redirect("Detail_Loan.aspx");
                                }
                                else//修改后的借贷账户（债务人/债权人）余额修改失败
                                {
                                    ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
                                }
                            }
                            else//修改后的账户余额修改失败
                            {
                                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
                            }
                        }
                        else//修改前的借贷账户（债务人/债权人）余额还原失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
                    }
                    #endregion
                }
                else if (loanTypeId == 2)//借出
                {
                    #region 借出
                    #region 修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    if (accountTypeId == accountTypeIdBefore && accountId == accountIdBefore && ConvertHelper.GetDecimal(loanMonyBefore) == ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) && loanAccountId == loanAccountIdBefore)
                    {
                        Response.Redirect("Detail_Loan.aspx");//如果修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    }
                    #endregion
                    int flagAccountBefore = 0;//修改前账户余额还原是否成功的标志
                    #region 修改前的账户余额还原
                    if (accountTypeIdBefore == 1)//现金账户
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + loanMonyBefore + " WHERE CashAccountId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + loanMonyBefore + " WHERE CreditCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 3)//储蓄卡
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + loanMonyBefore + " WHERE SavingsCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 4)//网上支付
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + loanMonyBefore + " WHERE OnlinePayId=" + accountIdBefore + "", "constring");
                    }
                    #endregion
                    if (flagAccountBefore > 0)//修改前的账户余额修改成功
                    {
                        int flagLoanAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder-" + ConvertHelper.GetDecimal(loanMonyBefore) + " WHERE LoanAccountId=" + loanAccountIdBefore + "", "constring");
                        if (flagLoanAccountBefore > 0)//修改前的借贷账户（债务人/债权人）余额还原成功
                        {
                            int flagAccountAfter = 0;//修改后账户余额修改是否成功的标志
                            #region 修改后的账户余额修改
                            if (accountTypeId == 1)//现金账户
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CashAccountId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CreditCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 3)//储蓄卡
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 4)//网上支付
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                            }
                            #endregion
                            if (flagAccountAfter > 0)//修改后的账户余额修改成功
                            {
                                int flagLoanAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE LoanAccountId=" + loanAccountId + "", "constring");
                                if (flagLoanAccountAfter > 0)//修改后的借贷账户（债务人/债权人）余额修改成功
                                {
                                    Response.Redirect("Detail_Loan.aspx");
                                }
                                else//修改后的借贷账户（债务人/债权人）余额修改失败
                                {
                                    ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                                }
                            }
                            else//修改后的账户余额修改失败
                            {
                                ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                            }
                        }
                        else//修改前的借贷账户（债务人/债权人）余额还原失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                    }
                    #endregion
                }
                else if(loanTypeId==3)//收款
                {
                    #region 收款
                    #region 修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    if (accountTypeId == accountTypeIdBefore && accountId == accountIdBefore && ConvertHelper.GetDecimal(loanMonyBefore) == ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) && loanAccountId == loanAccountIdBefore)
                    {
                        Response.Redirect("Detail_Loan.aspx");//如果修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    }
                    #endregion
                    int flagAccountBefore = 0;//修改前账户余额还原是否成功的标志
                    #region 修改前的账户余额还原
                    if (accountTypeIdBefore == 1)//现金账户
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + loanMonyBefore + "-"+loanInterestBefore+" WHERE CashAccountId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + loanMonyBefore + "+"+loanInterestBefore+" WHERE CreditCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 3)//储蓄卡
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + loanMonyBefore + "-" + loanInterestBefore + " WHERE SavingsCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 4)//网上支付
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + loanMonyBefore + "-" + loanInterestBefore + " WHERE OnlinePayId=" + accountIdBefore + "", "constring");
                    }
                    #endregion
                    if (flagAccountBefore > 0)//修改前的账户余额修改成功
                    {
                        int flagLoanAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder+" + ConvertHelper.GetDecimal(loanMonyBefore) + " WHERE LoanAccountId=" + loanAccountIdBefore + "", "constring");
                        if (flagLoanAccountBefore > 0)//修改前的借贷账户（债务人/债权人）余额还原成功
                        {
                            int flagAccountAfter = 0;//修改后账户余额修改是否成功的标志
                            #region 修改后的账户余额修改
                            if (accountTypeId == 1)//现金账户
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+"+ConvertHelper.GetDecimal(txtInterest.Text.Trim())+" WHERE CashAccountId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-"+ConvertHelper.GetDecimal(txtInterest.Text.Trim())+" WHERE CreditCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 3)//储蓄卡
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 4)//网上支付
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                            }
                            #endregion
                            if (flagAccountAfter > 0)//修改后的账户余额修改成功
                            {
                                int flagLoanAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE LoanAccountId=" + loanAccountId + "", "constring");
                                if (flagLoanAccountAfter > 0)//修改后的借贷账户（债务人/债权人）余额修改成功
                                {
                                    Response.Redirect("Detail_Loan.aspx");
                                }
                                else//修改后的借贷账户（债务人/债权人）余额修改失败
                                {
                                    ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                                }
                            }
                            else//修改后的账户余额修改失败
                            {
                                ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                            }
                        }
                        else//修改前的借贷账户（债务人/债权人）余额还原失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                    }
                    #endregion
                }
                else if(loanTypeId==4)//还款
                {
                    #region 还款
                    #region 修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    if (accountTypeId == accountTypeIdBefore && accountId == accountIdBefore && ConvertHelper.GetDecimal(loanMonyBefore) == ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) && loanAccountId == loanAccountIdBefore)
                    {
                        Response.Redirect("Detail_Loan.aspx");//如果修改前后账户类型，账户id，借贷金额，债务人/债权人都相同，则账户和借贷账户的余额都不做任何操作，直接跳转到借贷明细页
                    }
                    #endregion
                    int flagAccountBefore = 0;//修改前账户余额还原是否成功的标志
                    #region 修改前的账户余额还原
                    if (accountTypeIdBefore == 1)//现金账户
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + loanMonyBefore + "+"+loanInterestBefore+" WHERE CashAccountId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + loanMonyBefore + "-"+loanInterestBefore+" WHERE CreditCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 3)//储蓄卡
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + loanMonyBefore + "+"+loanInterestBefore+" WHERE SavingsCardId=" + accountIdBefore + "", "constring");
                    }
                    else if (accountTypeIdBefore == 4)//网上支付
                    {
                        flagAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + loanMonyBefore + "+"+loanInterestBefore+" WHERE OnlinePayId=" + accountIdBefore + "", "constring");
                    }
                    #endregion
                    if (flagAccountBefore > 0)//修改前的账户余额修改成功
                    {
                        int flagLoanAccountBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder-" + ConvertHelper.GetDecimal(loanMonyBefore) + " WHERE LoanAccountId=" + loanAccountIdBefore + "", "constring");
                        if (flagLoanAccountBefore > 0)//修改前的借贷账户（债务人/债权人）余额还原成功
                        {
                            int flagAccountAfter = 0;//修改后账户余额修改是否成功的标志
                            #region 修改后的账户余额修改
                            if (accountTypeId == 1)//现金账户
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-"+ConvertHelper.GetDecimal(txtInterest.Text.Trim())+" WHERE CashAccountId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+"+ConvertHelper.GetDecimal(txtInterest.Text.Trim())+" WHERE CreditCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 3)//储蓄卡
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE SavingsCardId=" + accountId + "", "constring");
                            }
                            else if (accountTypeId == 4)//网上支付
                            {
                                flagAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE OnlinePayId=" + accountId + "", "constring");
                            }
                            #endregion
                            if (flagAccountAfter > 0)//修改后的账户余额修改成功
                            {
                                int flagLoanAccountAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET LoanRemainder=LoanRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE LoanAccountId=" + loanAccountId + "", "constring");
                                if (flagLoanAccountAfter > 0)//修改后的借贷账户（债务人/债权人）余额修改成功
                                {
                                    Response.Redirect("Detail_Loan.aspx");
                                }
                                else//修改后的借贷账户（债务人/债权人）余额修改失败
                                {
                                    ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                                }
                            }
                            else//修改后的账户余额修改失败
                            {
                                ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                            }
                        }
                        else//修改前的借贷账户（债务人/债权人）余额还原失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                    }
                    #endregion
                }
            }
            else//修改借贷记录失败
            {
                ScriptHelper.AlertMessage(this.Page,"修改失败，请联系管理员！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Detail_Loan.aspx");
    }
}